#declare Temp_Vers = version;
#version 3.1;

#declare TestRender = 0;

/*
 * A 3X magnifying glass, silver rim with a tarnished
 * and worn silver handle. The lens is centered in
 * the XY plane, the handle extends down the Y axis.
 * The lens is 1.5 inches in diameter, while the handle
 * is 3.5 inches long. 
 *
 * Scale is 1 POVunit == 1 inch.
 * by Denton Gentry 1999
 */

#if (TestRender)
#include "colors.inc"
#include "metals.inc"

camera {
	location <0,-2,-2>
	look_at <0,-2,0>
}

light_source {
	<-10, 0, -20>
	color White
}

light_source {
	<10, 0, -20>
	color White
}

global_settings {
	assumed_gamma 1.8
	ambient_light rgb<1, 1, 1>
}

//plane {
//	<0,0,-1>,
//	-5
//	pigment { checker Black, White }
//}
#end

#declare T_MagnifyingGlassHandle = texture {
	pigment { color rgb <0.94, 0.93, 0.80> }
	finish {
		ambient 0.35
		diffuse 0.35
		brilliance 0.5
		metallic
		specular 0.10
		roughness 1/20
		reflection 0.1
	}
}

#declare Magnifying_Glass = union {
	// The lens
#ifndef (Quick)
	intersection {
		sphere { <0,0,  29.9375>, 30 }
		sphere { <0,0, -29.9375>, 30 }
		cylinder {<0,0,-1>, <0,0,1>, 1.5 }

		interior { ior 3.0 }
		pigment { color rgbf <0.99, 0.99, 0.99, 0.9> }
		finish {
			ambient 0
			diffuse 0
			reflection 0.2
			phong 0.2
			phong_size 90
		}
	}
#end

	// the rim around the lens
	difference {
		cylinder { <0, 0, -0.25>, <0, 0, 0.25>, 1.6 }
		cylinder { <0, 0, -1.000>, <0, 0, 1.000>, 1.5 }
		box { <-0.01, -2, -1>, <0.01, -1, 1> }	// the gap
		texture { T_MagnifyingGlassHandle }
	}

	// a connecting shaft between the lens housing and the handle
	difference {
		cylinder { <0, -1.55, 0>, <0, -1.80, 0>, 0.15 }
		box { <-0.01, -2, -1>, <0.01, -1, 1> }	// the gap
		texture { T_MagnifyingGlassHandle }
	}

	difference {
		cylinder { <0, -1.8, 0>, <0, -5.0, 0>, 0.25
			texture { T_MagnifyingGlassHandle }
		}

		#declare rot = 0;
		#while (rot < 360)
			union {
				cylinder { <0, -2.0, 0.25>, <0, -4.8, 0.25>, 0.08 }

				// the handle is ribbed to be easier to grip
				sphere { <0, -2.0, 0.25>, 0.08 }
				sphere { <0, -4.8, 0.25>, 0.08 }
				rotate <0, rot, 0>
			}
			#declare rot = rot + (360 / 6);
		#end

//		texture { pigment { Black } }
		texture { T_MagnifyingGlassHandle }

	}
}

#if (TestRender)
object { Magnifying_Glass }
#end

#version Temp_Vers;
