#declare Temp_Vers = version;
#version 3.1;

#declare TestRender = 0;

/*
 * Mathilda, Edwin's assistant. Mathilda is a cursed
 * shapeshifter, constantly changing from one form to the
 * next. Mathilda shifts amongst an endless variety of
 * animal and plant species. Mathilda is able to hear,
 * see and manipulate regardless of current form, but
 * is unable to speak unless in a humanoid shape.
 *
 * Mathilda is shown here in the form of a rosemary bush.
 *
 * scale is 1 POVunit == 1 foot
 */

#if (TestRender)
#include "colors.inc"

camera {
	location <1,3.2,-0.5>
	look_at <1,3.2,0>
}

light_source { <0, 10,  -10> color White}
light_source { <0, 10,   10> color White}
light_source { <-10, 10, 0>  color White}
light_source { < 10, 10, 0>  color White}
light_source { <0, 10,   0>  color White}
light_source { <-10, 0,  0>  color White}
light_source { < 10, 0,  0>  color White}

global_settings {
	assumed_gamma 1.8
	ambient_light rgb<1, 1, 1>
}
#end

#local T_Planter = texture {
//	pigment { color rgb <0.5, 0.1, 0> }

	pigment {
		bozo
		colour_map {
			[ 0.00 color rgb <0.4, 0.1, 0.00> ]
			[ 1.00 color rgb <0.5, 0.1, 0.05> ]
		}
		turbulence 0.9
	}

	finish {
		ambient 0.3
		diffuse 0.5
		specular 0.5
		roughness 0.4
		brilliance 1.0
	}
}
#local Planter = difference {
	merge {
		cone { <0,0,0>, 0.8
			<0,1,0>, 1.0
		}
		cylinder { <0,1,0>, <0,1.2,0> 1.1 }
	}
	cone { <0,0.1,0>, 0.7
		<0,2,0>, 0.9
	}

	texture { T_Planter }
}


#local T_Dirt = texture {
	pigment { VeryDarkBrown }
	finish {
		ambient 0.1
		diffuse 0.1
	}
	normal { bumps 0.3 }
}
#local Dirt = object {
	cone { <0,0.1,0>, 0.75
		<0,1.0,0>, 0.95
	}
	texture { T_Dirt }
}



#local T_Stem = texture {
	pigment { rgb <0.86, 0.58, 0.44> }
	finish {
		ambient 0.2
		diffuse 0.2
	}
}
#local T_leaf = texture {
	pigment { rgb <0.1, 0.6, 0.1> }
	finish {
		ambient 0.2
		diffuse 0.2
	}
}

#local R1 = seed (0.3487623);
#local leaflength = 0.15;
#local H=0;
#local J=0;

#local StemSeg = merge {
	sphere { <0, 0, 0>, 0.008
		texture { T_Stem }
	}
	cylinder { <0,0,0>, <0,0.5,0> 0.008
		texture { T_Stem }
	}

#ifndef (Quick)
	// the leaves
	#local H = 0.0;
	#while ( H < 0.5 )
		#local J=0;
		#while ( J < 3 )	
			cylinder { <0,0,0>, <0, leaflength, 0>, 0.008
				scale <1,1, 0.2>
				rotate <0, 0, 61>

				rotate <0, 120*J, 0>
				#local R1 = rand(R1);
				rotate <0, 120*R1, 0>

				translate y*H
				translate y*0.01*J

				texture { T_leaf }
			}
			#local J=J+1;
		#end

		#local H = H + 0.0714;
	#end
#end
}

#local Stem1 = merge {
	merge {
		merge {
			merge {
				merge {
					merge {
						merge {
							object { StemSeg
								rotate z*1 translate y*0.5 }
							object { StemSeg }
							rotate z*1 translate y*0.5
						}
						object { StemSeg }
						rotate z*1 translate y*0.5
					}
					object { StemSeg }
					rotate z*1 translate y*0.5
				}
				object { StemSeg }
				rotate z*1 translate y*0.5
			}
			object { StemSeg }
			rotate z*1 translate y*0.5
		}
		object { StemSeg }
		rotate z*1 translate y*0.5
	}
	object { StemSeg }
	translate y*0.5
}

#local Stem2 = merge {
	merge {
		merge {
			merge {
				merge {
					merge {
						merge {
							object { StemSeg
								rotate z*1.4 translate y*0.5 }
							object { StemSeg }
							rotate z*1.4 translate y*0.5
						}
						object { StemSeg }
						rotate z*1.4 translate y*0.5
					}
					object { StemSeg }
					rotate z*1.4 translate y*0.5
				}
				object { StemSeg }
				rotate z*1.4 translate y*0.5
			}
			object { StemSeg }
			rotate z*1.4 translate y*0.5
		}
		object { StemSeg }
		rotate z*1.4 translate y*0.5
	}
	object { StemSeg }
	translate y*0.5
}

#local TwizzleSep = 2*cos(45/360*2*pi)*0.04;
#local Twizzle = merge {
	intersection {
		torus { 0.02, 0.008
 			rotate x*90
		}
		box { <-1, 0, -1>, <1, 1, 1> }
		translate <0.02, 0, 0>
		rotate y*45
	}
	intersection {
		torus { 0.02, 0.008
			rotate x*90
		}
		box { <-1, -1, -1>, <1, 0, 1> }
		translate <-0.02, 0, 0>
		rotate y*-45
		translate <TwizzleSep, 0, 0>
	}
}

#local StemHand = merge {
	merge {
		merge {
			merge {
				merge {
					merge {
						object { Twizzle }
						object { Twizzle
							translate <TwizzleSep, 0, 0>
						}
						object { Twizzle
							translate <2*TwizzleSep, 0, 0>
						}
						object { Twizzle
							translate <3*TwizzleSep, 0, 0>
						}
						object { Twizzle
							translate <4*TwizzleSep, 0, 0>
						}
						object { Twizzle
							translate <5*TwizzleSep, 0, 0>
						}
						object { Twizzle
							translate <6*TwizzleSep, 0, 0>
						}
						object { Twizzle
							translate <7*TwizzleSep, 0, 0>
						}
						object { Twizzle
							translate <8*TwizzleSep, 0, 0>
						}
						object { Twizzle
							translate <9*TwizzleSep, 0, 0>
						}

						cone { <0, 0, 0>, 0.008
							<0, 0.2, 0>, 0.001
							translate <10*TwizzleSep, 0, 0>
						}
						rotate z*1.7 translate y*0.5

						texture { T_Stem }
					}
					object { StemSeg }
					rotate z*1.7 translate y*0.5
				}
				object { StemSeg }
				rotate z*1.7 translate y*0.5
			}
			object { StemSeg }
			rotate z*1.7 translate y*0.5
		}
		object { StemSeg }
		rotate z*1.7 translate y*0.5
	}
	object { StemSeg }
	translate y*0.5
}

#local R2 = seed(3.14159);

#declare Mathilda = merge {
	object { Planter }
	object { Dirt }

	#local N=0;
	#while ( N < 3 )
		object { Stem1
			rotate z*-9
			rotate y*120*N
			#local R2 = rand(R2);
			rotate y * 30 * (R2 - 0.5)
			#local N = N + 1;
			translate y*0.45
		}
	#end

	#local N=0;
	#while ( N < 4 )
		object { Stem2
			rotate z*-16
			rotate y*90*N
			#local R2 = rand(R2);
			rotate y * 30 * (R2 - 0.5)
			#local N = N + 1;
			translate y*0.45
		}
	#end

	// the branch to grasp the CandleSnuffer
	object { StemHand
//		rotate z*-20
		translate y*0.45
	}
}


#if (TestRender)
object { Mathilda }
#end

#version Temp_Vers;
