#declare Temp_Vers = version;
#version 3.1;

#declare TestRender = 0;

/*
 * A pocket computer which looks something like a PalmPilot
 *
 * scale is 1 POVunit == 1 inch. Bottom of chassis is flush
 * with XY plane.
 */

#if (TestRender)
#include "colors.inc"

camera {
	location <0,0,-4>
	look_at <0,0,0>
}

light_source {
	<0, 20, -20>
	color White
}

light_source {
	<-10, 4, -10>
	color White
}

light_source {
	<0, 10, 0>
	color White
}

global_settings {
	assumed_gamma 1.8
	ambient_light rgb<1, 1, 1>
}

background { White }
#end

#local T_Gray_Plastic = texture {
	pigment { Gray50 }
	finish {
		ambient 0.2
		diffuse 0.2
		reflection 0.05
		phong 0.3
		phong_size 60
	}
}

#local T_Pink_Plastic = texture {
	pigment { Pink }
	finish {
		ambient 0.35
		diffuse 0.35
	}
}

#local T_Blue_Plastic = texture {
	pigment { LightSteelBlue }
	finish {
		ambient 0.35
		diffuse 0.35
	}
}

#local T_LCD = texture {
	pigment { color rgb <0.31, 0.31, 0.19> } //DarkOliveGreen
	finish {
		ambient 0.3
		diffuse 0.4
		reflection 0.4
		specular 0.2
		roughness 0.05
	}
}

#declare Pocket_Comp = merge {
	difference {	// the chassis
		superellipsoid { <0.15, 0.15>
			scale <1.1,1.75,0.1>
		}
		// cutout for the LCD
		box { <-0.9, -1, -1>, <0.9, 1.525, -0.08> }
		
		// cutouts for the buttons
		cylinder { <0, -1.37, -1>, <0, -1.37, -0.04>, 0.20 }
		cylinder { <0.45, -1.37, -1>, <0.45, -1.37, -0.04>, 0.12 }
		cylinder { <0.80, -1.37, -1>, <0.80, -1.37, -0.04>, 0.12 }
		cylinder { <-0.45, -1.37, -1>, <-0.45, -1.37, -0.04>, 0.12 }
		cylinder { <-0.80, -1.37, -1>, <-0.80, -1.37, -0.04>, 0.12 }

		texture { T_Gray_Plastic }
	}

	box { // the LCD screen
		<-0.9, -1, -0.09>, <0.9, 1.525, -0.08>
		texture { T_LCD }
	}

	superellipsoid { <1, 0.2>
		scale <0.18, 0.18, 0.09>
		translate <0, -1.37, -0.04>
		texture { T_Pink_Plastic }
	}

	superellipsoid { <1, 0.2>
		scale <0.09, 0.09, 0.09>
		translate <-0.45, -1.37, -0.04>
		texture { T_Blue_Plastic }
	}

	superellipsoid { <1, 0.2>
		scale <0.09, 0.09, 0.09>
		translate <-0.8, -1.37, -0.04>
		texture { T_Blue_Plastic }
	}

	superellipsoid { <1, 0.2>
		scale <0.09, 0.09, 0.09>
		translate <0.45, -1.37, -0.04>
		texture { T_Blue_Plastic }
	}

	superellipsoid { <1, 0.2>
		scale <0.09, 0.09, 0.09>
		translate <0.8, -1.37, -0.04>
		texture { T_Blue_Plastic }
	}

	translate <0,0,-0.1>
}

#if (TestRender)
object { Pocket_Comp }
#end

#version Temp_Vers;
