#declare Temp_Vers = version;
#version 3.1;

#declare TestRender = 0;

/*
 * A sheet of paper.
 *
 * scale is 1 POVunit == 1 inch.
 */

#if (TestRender)
#include "colors.inc"

camera {
	location <-4.25,8.5,-1>
	look_at <4.25,8.5,0>
}

light_source {
	<0, 20, -20>
	color White
}

light_source {
	<-10, 4, -10>
	color White
}

light_source {
	<0, 10, 0>
	color White
}

global_settings {
	assumed_gamma 1.8
	ambient_light rgb<1, 1, 1>
}

background { Green }
#end

#local T_paperwhite = texture {
	pigment {
		granite
		turbulence 0.4
		color_map {
			[0.000	color rgb <1.00, 1.00, 0.99> ]
			[1.000	color rgb <1.00, 1.00, 1.00> ]
		}
	}
	finish {
		roughness 0.1
	}
	normal {
		wrinkles
		scale 0.9
	}
}

#local T_paperwriting = texture {
	pigment {
		image_map {
			gif "chronicle.gif"
			transmit 1, 1.0		// make white transparent
			map_type 0		// planar mapping (default, but make it explicit)
			once
		}
	}

	scale <0.90, 0.90, 1>
	translate <0.05, 0.05, 0>
}

#declare Chronicle = bicubic_patch {
	type 1  flatness 0  u_steps 4  v_steps 4
	<0, 0.0, 0.0>, <1, 0.0, 0.0>, <2, 0.0, 0.0>, <3, 0.0, 0.0>
	<0, 1.0, 0.0>, <1, 1.0, 0.0>, <2, 1.0, 0.0>, <3, 1.0, 0.0>
	<0, 2.6, 0.0>, <1, 2.6, 0.0>, <2, 2.6, 0.0>, <3, 2.6, 0.0>
	<0, 3.0,-4.0>, <1, 3.0,-4.0>, <2, 3.0,-4.0>, <3, 3.0,-4.0>
	scale 1/3

	texture { T_paperwhite }
	texture { T_paperwriting }
	
	scale <8.5, 11, 1>
}

#if (TestRender)
object { Chronicle }
#end

#version Temp_Vers;
