#declare Temp_Vers = version;
#version 3.1;


/*
 * Edwin's stool. 
 * The stool is 2 feet high, the seat is 10 inches in diameter.
 * There are 4 legs with bracing struts between them, the legs form
 * a square 1.2 feet on a side, standing on the XZ plane.

 * Scale is 1 POVunit == 1 foot
 */

#declare TestRender = 0;

#if (TestRender)
#include "colors.inc"
#include "woods.inc"


global_settings {
	assumed_gamma 1.8
	ambient_light rgb<1, 1, 1>
}

camera {
	location <-1,3,-2>
	look_at <0,2,0>
}

light_source { <0, 10,  -10> color Gray50}
light_source { <0, 10,   10> color Gray50}
light_source { <-10, 10, 0>  color Gray50}
light_source { < 10, 10, 0>  color Gray50}
light_source { <0, 10,   0>  color Gray50}
light_source { <-10, 0,  0>  color Gray50}
light_source { < 10, 0,  0>  color Gray50}
light_source { < 0, 0,  10>  color Gray50}
light_source { < 0, 0, -10>  color Gray50}
light_source { < 0, 0,   0>  color Gray50}


#end


#local T_Stool = texture { T_Wood3 }

#declare EdwinStool = merge {
	// the seat
	superellipsoid { <1, 0.25>
		rotate <90, 0, 0>
		scale <0.81, 0.1, 0.81>
		translate <0, 2, 0>
		texture { T_Stool
			rotate x*95
			rotate z*88
		}
	}

	// the legs
	cylinder { <-0.9, 0.08, 0>, <-0.6, 2, 0>, 0.08
		texture { T_Stool  rotate x*60}
	}
	sphere   { <-0.9, 0.08, 0>,  0.08
		texture { T_Stool  rotate x*60}
	}
	cylinder { <-0.9, 0.08, 0>, <-0.6, 2, 0>, 0.08
		texture { T_Stool  rotate x*60}
		rotate y*90
	}
	sphere   { <-0.9, 0.08, 0>,  0.08
		texture { T_Stool  rotate x*60}
		rotate y*90
	}
	cylinder { <-0.9, 0.08, 0>, <-0.6, 2, 0>, 0.08
		texture { T_Stool  rotate x*60}
		rotate y*180
	}
	sphere   { <-0.9, 0.08, 0>,               0.08
		texture { T_Stool  rotate x*60}
		rotate y*180
	}
	cylinder { <-0.9, 0.08, 0>, <-0.6, 2, 0>, 0.08
		texture { T_Stool  rotate x*60}
		rotate y*270
	}
	sphere   { <-0.9, 0.08, 0>,               0.08
		texture { T_Stool  rotate x*60}
		rotate y*270
	}


	// struts
	cylinder { <-0.75, 1, 0>, <0, 1, 0.75>, 0.05
		texture { T_Stool  rotate y*45}
	}
	cylinder { <-0.75, 1, 0>, <0, 1, 0.75>, 0.05
		texture { T_Stool  rotate y*45}
		rotate y*90
	}
	cylinder { <-0.75, 1, 0>, <0, 1, 0.75>, 0.05
		texture { T_Stool  rotate y*45}
		rotate y*180
	}
	cylinder { <-0.75, 1, 0>, <0, 1, 0.75>, 0.05
		texture { T_Stool  rotate y*45}
		rotate y*270
	}
}

#if (TestRender)
	object { EdwinStool }
#end
