
//"Infinite Worlds"
//  by Darren Izzard (SeDi)
//  for "Imaginary Worlds" IRTC round

#version 3.1;

global_settings {
                max_intersections 256
                }

#include "colors.inc"
#include "textures.inc"

//comment out any of these next few lines to remove that feature from the scene
#include "headmask.pov"     //the head-mask and cranial sphere
#include "drawstar.inc"     //the smiling star
#include "planetmk.inc"     //the planet-making macro
#include "wall.inc"         //the wall (and cityscape)
#include "desk.inc"         //the desk (and computer)
#include "waterscn.pov"     //the water-dwelling objects within the whirlpool

//FLAGS AFFECTING OBJECTS DEFINED WITHIN THIS FILE
#declare USE_MOUNTAINS=1;   //comment out to remove the mountains
#declare USE_ICEWORLD=1;    //comment out to remove the iceworld
#declare USE_STARFIELD=1;   //comment out to stop the starfield (sky_sphere) from showing
#declare USE_WHIRLPOOL=1;   //comment out to remove the whirlpool - nb. if you remove the
                            //whirlpool, POV-Ray will generate a "need at least two objects
                            //in CSG" warning (just ignore it though)

//WHIRLPOOL QUALITY SETTINGS
//#declare USE_ISOSURFACE_WHIRLPOOL=1;  //use isosurface instead of spheres (works nicely, but doesn't prevent the crash)
           // ^^ do not use this flag unless your version of POV-Ray supports isosurfaces
//#declare USE_TORUS_WHIRLPOOL=1;       //use torus instead of spheres (too slow, even with cylinders instead of tori)
//**** actually, whirlpool looks pretty good without these two!
//#declare USE_WHIRLPOOL_TRANSPARENCY=1;    //comment out to remove transparency from whirlpool
//#declare USE_DETAILED_WHIRLPOOL=1;          //comment out to use a less detailed whirlpool

camera {
       location <0,1,-5>
       look_at <0,0,0>
       }

light_source {
             <6,-0.5,-5.5> color White
             fade_power 2
             fade_distance 5.5
             }

light_source {
             <-2,-2,-2> color (Blue*3+White)/4
             fade_power 2
             fade_distance 4
             }

light_source {
             <-2,2,6> color (Orange+White*2)/3
             }

light_source {
             <1,2,8> color White
             }

light_source {
             <12,-2,-4> color White
             fade_power 2
             fade_distance 8
             }

box {   //invisible wall behind head and whirlpool
    <-0.1,-10,5>,<0.1,10,20>
    pigment { color Black }
    }

// THIS SECTION MOSTLY COPIED FROM MY OLDER "NIGHT VISION" SOURCE

#ifdef(USE_STARFIELD)
#declare Starfield2=pigment {       //this is modified from the Jeff Burton Starfield
                                    //supplied in the standard POV-Ray "textures.inc"
        granite
        color_map {
            [ 0.00  0.7 color Black  color Black ]  // No Stars in this area
            [ 0.7  0.75 color Gray20 color Gray40 ] // Very Very Faint Stars
            [ 0.75  0.75 color Gray40 color White ] // Very Faint Stars
            [ 0.75  0.93 color White  color Black ] // White Stars
            [ 0.93  1.0 color Black  color Black ]  // No Stars in this area
        }
    scale .015
    }

sky_sphere {
           pigment { gradient x
                     pigment_map {
                                 [0 Starfield2]
                                 [0.5 Starfield2]
                                 [0.5 gradient y
                                      pigment_map {
                                                  [0.0 color rgb <0.1,0.25,0.5>]
                                                  [0.5 Starfield2]
                                                  [1.0 Starfield2]
                                                  }
                                      ]
                                 }
                     translate x*-0.5
                     scale <2,1,1>
                     }
           }
#end

// END OF "NIGHT VISION" SECTION

#ifdef(Head)
object { Head
       scale <1.25,1.5,1.5>
//     rotate -x*5
       translate <0,-2.7,0>
       }
#end

#ifdef(HappyStar)
object { HappyStar
       scale 0.2
       rotate z*-25+y*-30+x*-10     //was y*-25
       translate x*0.8+y*0.4
       }
#end


#ifdef(USE_DETAILED_WHIRLPOOL)
#declare WhirlpoolRotStep=3;
#else
#declare WhirlpoolRotStep=9;
#end
#macro WhirlpoolTex(Transp)
       texture {
                                   normal {
                                          onion 0.1
                                          sine_wave
                                          turbulence 0.9
                                          scale 0.1
                                          }
                                   pigment {
                                           spiral2 5
                                           color_map {
                                                     [0 rgbt <0.9,0.9,0.9,Transp>]
                                                     [1 rgbt <0.5,0.6,0.9,Transp>]
                                                     }
                                           scale 0.25
                                           turbulence 0.9
                                           }
                                   }
#end

object {
       union {
             light_source { <0,5,0.5> color White }
#ifdef(USE_WHIRLPOOL)
 #ifdef(USE_ISOSURFACE_WHIRLPOOL)
    //for some reason, the sphere version is crashing POV-Ray (it didn't before I added
    //the extra blue light, but it is now)
    //I've tried CSG'ing some cylinders or tori, but they are far too slow
    //so now I'm going to try to duplicate the shape with an isosurface
    #declare WhirlpoolIso=isosurface {
             function { abs(sqrt((x*x)+(z*z))-(1.03^(y/0.05))*0.1) }
             threshold 0.01
             //sign -1
             bounded_by {box{ <-8,0,0>,<8,8,8> } }
             }
    object { WhirlpoolIso
             WhirlpoolTex(0)
             }
 #else
             #declare YPos=0;
             #declare Radius=0.1;
             #while(YPos<8)
#ifdef(USE_TORUS_WHIRLPOOL)
                 object {
                        intersection {
                              cylinder { <0,-0.4,0>,<0,0.4,0> Radius+0.4 }
                              cylinder { <0,-0.4,-0.1>,<0,0.4,0.1> Radius-0.4 }
                              #declare TorusBoundBox=box {<-Radius-0.4,-0.4,0>,<Radius+0.4,0.4,Radius+0.4>}
                              object{TorusBoundBox}
                              bounded_by { object{TorusBoundBox} }
                              translate <0,YPos,0>
                              }
                        WhirlpoolTex(0)
                        }
#else
                 #declare Rad=YPos*625.336;
                 #declare RPos=0;
                 #while(RPos<360)
                    #declare CurRad=radians(Rad+RPos);
                    #declare ZOffset=sin(CurRad)*Radius;
                    #if(ZOffset>0)
                       #declare Transparency=(Radius-ZOffset)/Radius;
                       sphere {
                           <cos(CurRad)*Radius,YPos,ZOffset>,0.4-0.399*Transparency
                           #ifdef (USE_WHIRLPOOL_TRANSPARENCY)
                                WhirlpoolTex(Transparency)
                           #else
                                WhirlpoolTex(0)
                           #end
                           }
                    #end
                    #declare RPos=RPos+WhirlpoolRotStep;
                 #end
#end
                 #declare YPos=YPos+0.05;
                 #declare Radius=Radius*1.03;
             #end
 #end
#end
    #ifdef(WaterSection)
          object {
                 WaterSection
                 no_shadow   //so we don't have problems lighting the whirlpool
                 //rotate x*20
                 scale <0.8,0.9,0.6>
                 translate <0,3,0>
                 }
    #end
             }
       translate y*-2.7+z
       }

#ifdef(MakePlanet)
//this is the same macro call I used for testing MakePlanet() -
//it looked so good I had to use it here!
object { MakePlanet(1.1,0.3,0.2,rgb <0.7,0.9,0.6>,Orange,
                    0.2,0.7,1,rgb <0.5,0.7,0.9>,0.5,0.6,
                    3,0.2,White*0.8,0.1,0.35)
         rotate <-10,0,25>
         scale 2.5
         translate <-6.5,0.6,9>
       }

//macro MakePlanet(Bulge,LandCover,LandTurb,GroundColour,MountainColour,
//                 SurfaceScale,LandScale,OceanScale,OceanColour,OceanTurb,OceanPhong,
//                 CloudBands,CloudDensity,CloudColour,CloudScale,CloudTurb)
object { MakePlanet(1,0.5,0.4,rgb <0.6,0.3,0.7>,White,
                    0.2,0.9,0.6,rgb <0.3,0.7,0.6>,0.6,0.3,
                    3,0.001,rgb (Yellow+White)/2,0.15,0.4)
//NOTE: in above line, rgb (Yellow+White)/2 is used, because just using (Yellow+White)/2
//      generates an error (for some reason). The rgb expression still generates a warning
//      though ("suspicious expression following rgb") but does at least work.
         rotate <-15,0,20>
         scale 0.35
         translate <-0.6,0.4,-0.5>
         }
#end

#ifdef(USE_MOUNTAINS)
#declare MountainSnowTex=texture {
         pigment {color <0.4,0.45,0.6>}
         normal { crackle 0.2 scale 0.01 turbulence 0.6}
         finish {specular 0.1}
         }
#declare MountainRockTex=texture {
         #declare BareRockTex=pigment {
                 bozo
                 color_map {
                   [0 rgb <0.3,0.37,0.4>]
                   [1 rgb <0.3,0.4,0.4>]
                   }
                 scale 0.5
                 }
         #declare GrassyRockTex=pigment {
                  bozo
                  color_map {
                            [0 rgb <0.33,0.37,0.33>]
                            [1 rgb <0.37,0.3,0.37>]
                            }
                  scale 0.5
                  }
         pigment {
                 bozo
                 pigment_map {
                             [0 BareRockTex]
                             [0.1 BareRockTex]
                             [0.9 GrassyRockTex]
                             [1 GrassyRockTex]
                             }
                 scale 0.3
                 turbulence 0.4
                 }
         normal { crackle 0.2 scale 0.01 turbulence 0.6 }
         }
height_field {
             tga "mountain.tga" smooth
             texture {
                     gradient y
                     texture_map {
                                 [0 MountainRockTex]
                                 [0.39 MountainRockTex]
                                 [0.42 MountainSnowTex]
                                 [1 MountainSnowTex]
                                 }
                     turbulence 0.9
                     }
             scale <12,6,8>
             rotate x*-40
             translate <0,-4,8>
             }
#end

#ifdef(USE_ICEWORLD)
height_field {
             tga "iceworld.tga" smooth
             texture {
                     pigment {
                             bozo
                             color_map {
                                       [0 color White/2]
                                       [0.5 color (White+Green)/3]
                                       [1 color White*2/3]
                                       }
                             scale 0.025
                             turbulence 0.5
//                             color White*2/3
                             }
                     finish { specular 0.1 }
                     normal { crackle 0.25 scale 0.05 turbulence 0.345 }
                     }
             scale <8,6,8>
             rotate x*-20
             translate <-10,-8,2>
             }
box {
    <-10,-3,0>,<-2,-8,10>
    pigment {
            color rgbf <0.8,0.4,0.4,0.5>
            }
    normal {
           ripples 0.3
           scale 0.25
           turbulence 0.235
           }
    finish { phong 0.6 reflection 0.3}
    }
#end

#ifdef(Wall)
object {
       Wall
       rotate y*20
       translate <0,-6,7>
       }
#end

#ifdef(Desk)
object {
       Desk
       rotate y*40
       translate <1.5,-5,2>
       }
#end


