
//Planet-making macro include, by Darren Izzard
//from "Infinite Worlds" by Darren Izzard

//macro MakePlanet(Bulge,LandCover,LandTurb,GroundColour,MountainColour,
//                 SurfaceScale,LandScale,OceanScale,OceanColour,OceanTurb,OceanPhong,
//                 CloudBands,CloudDensity,CloudColour,CloudScale,CloudTurb)
//places a planet at origin, radius approx. 1 (equatorial bulge will affect this however)
//Bulge: float, 0<x<MAX_FLOAT, equatorial bulge, 1=sphere; the bigger, the more bulge
//LandCover: float, 0<x<1, how much space is covered by land
//LandTurb: float, 0<x<1, land turbulence
//GroundColour: colour value, colour of ground
//MountainColour: colour value, colour of mountain peaks
//SurfaceScale: float, 0<x<1, scale of surface (land/ocean) texture (multiplies Land/OceanScale)
//LandScale: float, 0<x<1, scale of land texture
//OceanScale: float, 0<x<1, scale of ocean texture
//OceanColour: colour value, ocean colour will be scaled between this and this/3
//OceanTurb: float, 0<x<1, ocean turbulence
//OceanPhong: float, 0<x<1, phong value for ocean
//CloudBands: int, 1<x<MAX_INT, number of cloud bands (parameter of spiral2)
//CloudColour: colour value, self-explanatory
//CloudScale: float, 0<x<1, how wide the bands of cloud are
//CloudTurb: float, 0<x<1, cloud turbulence
//CloudDensity: float, 0.1<x<0.9, how thick the cloud cover is

#version 3.1;

#include "colors.inc"
#include "textures.inc"

//#declare TEST_PLANET_MAKER=1;   //uncomment to test this include

#ifdef(TEST_PLANET_MAKER)
// for testing
camera { location <3,2,-7> look_at <0,0,0>}
light_source { <3,10,-15> color White }
#end

#macro MakePlanet(Bulge,LandCover,LandTurb,GroundColour,MountainColour,
                  SurfaceScale,LandScale,OceanScale,OceanColour,OceanTurb,OceanPhong,
                  CloudBands,CloudDensity,CloudColour,CloudScale,CloudTurb)
       object {
              union {
                    sphere { 0,1    //main planet
                           texture {
                                   #declare PlanetLandTex=texture {
                                            pigment { bumps
                                                      color_map {
                                                                [0 GroundColour]
                                                                [1 MountainColour]
                                                                }
                                                      turbulence LandTurb
                                                      }
                                            normal { bumps 0.2
                                                     turbulence LandTurb
                                                     }
                                            scale LandScale
                                            }
                                   #declare PlanetOceanTex=texture {
                                            pigment { bozo
                                                      color_map {
                                                                [0 OceanColour]
                                                                [1 OceanColour/3]
                                                                }
                                                      turbulence OceanTurb
                                                      }
                                            finish { phong OceanPhong }
                                            scale OceanScale
                                            }
                                   bozo
                                   texture_map {
                                               [0 PlanetLandTex]
                                               [LandCover PlanetLandTex]
                                               [LandCover PlanetOceanTex]
                                               [1 PlanetOceanTex]
                                               }
                                   turbulence LandTurb
                                   scale SurfaceScale
                                   }
                           }
                    sphere { 0,1.01    //atmosphere
                           texture {
                              pigment {
                                   spiral2 CloudBands
                                   color_map {
                                             [0 color CloudColour]
                                             [CloudDensity-0.1 color CloudColour]
                                             [CloudDensity+0.1 color Clear]
                                             [1 color Clear]
                                             }
                                   sine_wave
                                   scale CloudScale
                                   turbulence CloudTurb
                                   }
                              normal {
                                  spiral2 CloudBands 0.2
                                  scale CloudScale/2
                                  turbulence CloudTurb
                                  }
                              }
                           }
                    }
              scale <Bulge,1,Bulge>
              }
#end

//macro MakePlanet(Bulge,LandCover,LandTurb,GroundColour,MountainColour,
//                 SurfaceScale,LandScale,OceanScale,OceanColour,OceanTurb,OceanPhong,
//                 CloudBands,CloudDensity,CloudColour,CloudScale,CloudTurb)

#ifdef(TEST_PLANET_MAKER)
object { MakePlanet(1.1,0.3,0.2,rgb <0.7,0.9,0.6>,Orange,
                    0.2,0.7,1,rgb <0.5,0.7,0.9>,0.5,0.6,
                    3,0.2,White*0.8,0.1,0.35)
         scale 3
       }
#end
