// File (partially) generated by sPatch
// part of Darren Izzard's IRTC entry for "Imaginary Worlds"
// ("Infinite Worlds")

//object=WaterSection, origin=<0,0,0>, height approx. 2(?)

#version 3.1;

#include "colors.inc"
#include "textures.inc"

//#declare TESTING_ONLY=0;    //uncomment to test this file

#declare FishTexture=texture {
         pigment {
                 bozo
                 color_map {
                           [0 color (Yellow+Orange)/3]
                           [1 color (Orange+Red)/3]
                           }
                 turbulence 0.345
                 scale 0.1
                 }
         normal { quilted 0.1 scale 0.1 }
         finish { specular 0.15 }
         }

#declare WeedTexture=texture {
         pigment {
                 gradient y
                 pigment_map {
                             [0 color Clear]
                             [0.5 bozo
                                color_map {
                                          [0 color Green/3]
                                          [1 color Green/4]
                                          }
                                scale <1,1/3,1>
                                ]
                             }
                 scale <1,3,1>
                 translate y*-0.2
                 }
         }

#ifdef (TESTING_ONLY)

background { color rgb <0, 0, 0> }

camera {
	location <0,2,-5>
	look_at <0,1.7,0>
}

light_source { < 0, 100, -200 > color rgb <1, 1, 1> }
light_source { < 200, 10, 0 > color rgb <0.4, 0.5, 0.4> }
light_source { < -50, 10, 200 > color rgb <0.4, 0.25, 0.25> }

#end

#declare WaterSection=union {
// Layer 1
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.716, 1.441, -0.003> <-0.716, 1.441, -0.003> <-0.716, 1.441, -0.003> <-0.716, 1.441, -0.003>
		<-0.648, 0.992, -0.001> <-0.648, 0.992, -0.001> <-0.617, 1.008, -0.050> <-0.617, 1.008, -0.050>
		<-0.557, 0.392, 0.012> <-0.527, 0.409, -0.038> <-0.524, 0.425, -0.133> <-0.465, 0.436, -0.134>
		<-0.489, -0.057, 0.003> <-0.458, -0.041, -0.047> <-0.446, -0.014, -0.160> <-0.387, -0.003, -0.162>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.489, -0.057, 0.003> <-0.458, -0.041, -0.047> <-0.446, -0.014, -0.160> <-0.387, -0.003, -0.162>
		<-0.447, -0.331, -0.003> <-0.417, -0.315, -0.052> <-0.396, -0.300, -0.178> <-0.337, -0.289, -0.180>
		<-0.384, -0.694, -0.044> <-0.366, -0.694, -0.075> <-0.359, -0.686, -0.161> <-0.324, -0.679, -0.156>
		<-0.349, -0.970, -0.050> <-0.331, -0.969, -0.082> <-0.325, -0.975, -0.160> <-0.290, -0.968, -0.155>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.349, -0.970, -0.050> <-0.331, -0.969, -0.082> <-0.325, -0.975, -0.160> <-0.290, -0.968, -0.155>
		<-0.320, -1.202, -0.056> <-0.302, -1.201, -0.087> <-0.296, -1.215, -0.159> <-0.261, -1.208, -0.154>
		<-0.298, -1.513, -0.041> <-0.268, -1.518, -0.077> <-0.257, -1.525, -0.157> <-0.211, -1.526, -0.155>
		<-0.276, -1.745, -0.037> <-0.246, -1.751, -0.073> <-0.224, -1.764, -0.157> <-0.177, -1.765, -0.155>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.716, 1.441, -0.003> <-0.590, 1.002, -0.002> <-0.395, 0.425, 0.004> <-0.297, -0.021, -0.001>
		<-0.716, 1.441, -0.003> <-0.590, 1.002, -0.002> <-0.422, 0.430, -0.044> <-0.324, -0.015, -0.049>
		<-0.716, 1.441, -0.003> <-0.617, 1.008, -0.050> <-0.410, 0.446, -0.135> <-0.333, 0.007, -0.163>
		<-0.716, 1.441, -0.003> <-0.617, 1.008, -0.050> <-0.465, 0.436, -0.134> <-0.387, -0.003, -0.162>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.297, -0.021, -0.001> <-0.237, -0.291, -0.004> <-0.227, -0.662, -0.025> <-0.190, -0.935, -0.029>
		<-0.324, -0.015, -0.049> <-0.264, -0.285, -0.052> <-0.256, -0.671, -0.063> <-0.220, -0.945, -0.067>
		<-0.333, 0.007, -0.163> <-0.282, -0.279, -0.181> <-0.277, -0.669, -0.150> <-0.242, -0.958, -0.149>
		<-0.387, -0.003, -0.162> <-0.337, -0.289, -0.180> <-0.324, -0.679, -0.156> <-0.290, -0.968, -0.155>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.190, -0.935, -0.029> <-0.158, -1.180, -0.033> <-0.104, -1.504, -0.028> <-0.067, -1.747, -0.028>
		<-0.220, -0.945, -0.067> <-0.188, -1.189, -0.071> <-0.137, -1.509, -0.066> <-0.100, -1.752, -0.066>
		<-0.242, -0.958, -0.149> <-0.214, -1.197, -0.148> <-0.161, -1.526, -0.153> <-0.127, -1.765, -0.153>
		<-0.290, -0.968, -0.155> <-0.261, -1.208, -0.154> <-0.211, -1.526, -0.155> <-0.177, -1.765, -0.155>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.594, 1.722, 0.072> <0.594, 1.722, 0.072> <0.594, 1.722, 0.072> <0.594, 1.722, 0.072>
		<0.452, 1.173, 0.072> <0.452, 1.173, 0.072> <0.501, 1.189, 0.085> <0.501, 1.189, 0.085>
		<0.291, 0.429, 0.132> <0.341, 0.445, 0.145> <0.412, 0.455, 0.120> <0.431, 0.464, 0.169>
		<0.119, -0.108, 0.070> <0.168, -0.092, 0.083> <0.264, -0.062, 0.065> <0.283, -0.054, 0.114>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.119, -0.108, 0.070> <0.168, -0.092, 0.083> <0.264, -0.062, 0.065> <0.283, -0.054, 0.114>
		<0.030, -0.385, 0.037> <0.079, -0.369, 0.051> <0.178, -0.365, 0.033> <0.197, -0.357, 0.082>
		<-0.211, -0.664, -0.222> <-0.182, -0.664, -0.214> <-0.119, -0.648, -0.189> <-0.102, -0.644, -0.165>
		<-0.265, -0.952, -0.239> <-0.236, -0.951, -0.230> <-0.186, -0.954, -0.234> <-0.169, -0.950, -0.210>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.265, -0.952, -0.239> <-0.236, -0.951, -0.230> <-0.186, -0.954, -0.234> <-0.169, -0.950, -0.210>
		<-0.312, -1.200, -0.252> <-0.283, -1.199, -0.244> <-0.240, -1.197, -0.270> <-0.223, -1.193, -0.246>
		<-0.216, -1.520, -0.088> <-0.186, -1.526, -0.123> <-0.164, -1.532, -0.164> <-0.118, -1.533, -0.162>
		<-0.194, -1.763, -0.024> <-0.165, -1.769, -0.059> <-0.142, -1.782, -0.143> <-0.096, -1.783, -0.141>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.594, 1.722, 0.072> <0.476, 1.184, 0.135> <0.346, 0.463, 0.304> <0.201, -0.072, 0.281>
		<0.594, 1.722, 0.072> <0.476, 1.184, 0.135> <0.371, 0.468, 0.254> <0.226, -0.067, 0.231>
		<0.594, 1.722, 0.072> <0.501, 1.189, 0.085> <0.451, 0.472, 0.221> <0.303, -0.045, 0.166>
		<0.594, 1.722, 0.072> <0.501, 1.189, 0.085> <0.431, 0.464, 0.169> <0.283, -0.054, 0.114>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.201, -0.072, 0.281> <0.125, -0.350, 0.270> <-0.094, -0.635, 0.011> <-0.125, -0.917, -0.038>
		<0.226, -0.067, 0.231> <0.150, -0.345, 0.220> <-0.107, -0.645, -0.040> <-0.138, -0.927, -0.090>
		<0.303, -0.045, 0.166> <0.217, -0.348, 0.134> <-0.071, -0.636, -0.121> <-0.139, -0.942, -0.166>
		<0.283, -0.054, 0.114> <0.197, -0.357, 0.082> <-0.102, -0.644, -0.165> <-0.169, -0.950, -0.210>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.125, -0.917, -0.038> <-0.153, -1.170, -0.082> <-0.028, -1.511, -0.021> <0.014, -1.765, -0.014>
		<-0.138, -0.927, -0.090> <-0.166, -1.180, -0.134> <-0.061, -1.516, -0.059> <-0.019, -1.770, -0.052>
		<-0.139, -0.942, -0.166> <-0.192, -1.186, -0.202> <-0.067, -1.533, -0.159> <-0.046, -1.783, -0.139>
		<-0.169, -0.950, -0.210> <-0.223, -1.193, -0.246> <-0.118, -1.533, -0.162> <-0.096, -1.783, -0.141>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.857, 1.240, 0.046> <0.857, 1.240, 0.046> <0.857, 1.240, 0.046> <0.857, 1.240, 0.046>
		<0.729, 0.836, 0.046> <0.729, 0.836, 0.046> <0.778, 0.852, 0.059> <0.778, 0.852, 0.059>
		<0.543, 0.299, 0.012> <0.593, 0.315, 0.025> <0.672, 0.322, 0.027> <0.691, 0.330, 0.077>
		<0.429, -0.108, 0.046> <0.478, -0.092, 0.059> <0.575, -0.062, 0.041> <0.594, -0.054, 0.090>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.429, -0.108, 0.046> <0.478, -0.092, 0.059> <0.575, -0.062, 0.041> <0.594, -0.054, 0.090>
		<0.358, -0.362, 0.067> <0.407, -0.346, 0.080> <0.505, -0.337, 0.051> <0.524, -0.328, 0.100>
		<0.314, -0.697, 0.232> <0.332, -0.696, 0.200> <0.349, -0.689, 0.147> <0.384, -0.681, 0.152>
		<0.241, -0.952, 0.228> <0.259, -0.951, 0.196> <0.265, -0.957, 0.118> <0.300, -0.950, 0.123>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.241, -0.952, 0.228> <0.259, -0.951, 0.196> <0.265, -0.957, 0.118> <0.300, -0.950, 0.123>
		<0.168, -1.207, 0.224> <0.186, -1.206, 0.192> <0.186, -1.213, 0.090> <0.221, -1.205, 0.095>
		<0.042, -1.520, 0.082> <0.072, -1.526, 0.047> <0.082, -1.532, -0.033> <0.129, -1.533, -0.031>
		<-0.043, -1.763, 0.020> <-0.014, -1.769, -0.015> <0.009, -1.782, -0.099> <0.055, -1.783, -0.097>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.857, 1.240, 0.046> <0.753, 0.846, 0.110> <0.596, 0.329, 0.220> <0.511, -0.072, 0.257>
		<0.857, 1.240, 0.046> <0.753, 0.846, 0.110> <0.621, 0.335, 0.170> <0.536, -0.067, 0.207>
		<0.857, 1.240, 0.046> <0.778, 0.852, 0.059> <0.711, 0.339, 0.129> <0.614, -0.045, 0.142>
		<0.857, 1.240, 0.046> <0.778, 0.852, 0.059> <0.691, 0.330, 0.077> <0.594, -0.054, 0.090>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.511, -0.072, 0.257> <0.458, -0.321, 0.281> <0.451, -0.669, 0.282> <0.400, -0.917, 0.249>
		<0.536, -0.067, 0.207> <0.483, -0.316, 0.231> <0.421, -0.679, 0.245> <0.370, -0.927, 0.211>
		<0.614, -0.045, 0.142> <0.544, -0.319, 0.152> <0.431, -0.671, 0.158> <0.348, -0.940, 0.129>
		<0.594, -0.054, 0.090> <0.524, -0.328, 0.100> <0.384, -0.681, 0.152> <0.300, -0.950, 0.123>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.400, -0.917, 0.249> <0.346, -1.182, 0.213> <0.235, -1.511, 0.095> <0.165, -1.765, 0.029>
		<0.370, -0.927, 0.211> <0.316, -1.191, 0.176> <0.202, -1.516, 0.057> <0.132, -1.770, -0.009>
		<0.348, -0.940, 0.129> <0.268, -1.195, 0.102> <0.179, -1.533, -0.029> <0.106, -1.783, -0.095>
		<0.300, -0.950, 0.123> <0.221, -1.205, 0.095> <0.129, -1.533, -0.031> <0.055, -1.783, -0.097>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.006, 1.568, 0.236> <0.006, 1.568, 0.236> <0.006, 1.568, 0.236> <0.006, 1.568, 0.236>
		<0.015, 1.157, 0.096> <0.015, 1.157, 0.096> <0.028, 1.176, 0.144> <0.028, 1.176, 0.144>
		<0.044, 0.627, -0.160> <0.056, 0.646, -0.112> <0.119, 0.652, -0.056> <0.079, 0.662, -0.023>
		<0.037, 0.199, -0.230> <0.050, 0.218, -0.183> <0.118, 0.252, -0.105> <0.078, 0.262, -0.073>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.037, 0.199, -0.230> <0.050, 0.218, -0.183> <0.118, 0.252, -0.105> <0.078, 0.262, -0.073>
		<0.032, -0.110, -0.281> <0.045, -0.091, -0.234> <0.117, -0.074, -0.146> <0.077, -0.064, -0.113>
		<-0.045, -0.527, -0.158> <-0.036, -0.523, -0.128> <0.011, -0.511, -0.078> <-0.008, -0.501, -0.054>
		<-0.033, -0.839, -0.162> <-0.023, -0.836, -0.131> <0.017, -0.839, -0.085> <-0.002, -0.829, -0.061>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.033, -0.839, -0.162> <-0.023, -0.836, -0.131> <0.017, -0.839, -0.085> <-0.002, -0.829, -0.061>
		<-0.021, -1.114, -0.165> <-0.012, -1.111, -0.135> <0.022, -1.121, -0.090> <0.003, -1.111, -0.067>
		<0.072, -1.469, -0.226> <0.071, -1.475, -0.184> <0.112, -1.481, -0.126> <0.079, -1.481, -0.099>
		<0.116, -1.738, -0.253> <0.116, -1.745, -0.212> <0.147, -1.761, -0.142> <0.114, -1.761, -0.115>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.006, 1.568, 0.236> <-0.035, 1.170, 0.138> <-0.109, 0.649, -0.041> <-0.131, 0.241, -0.091>
		<0.006, 1.568, 0.236> <-0.035, 1.170, 0.138> <-0.046, 0.656, -0.036> <-0.068, 0.247, -0.085>
		<0.006, 1.568, 0.236> <0.028, 1.176, 0.144> <0.031, 0.674, 0.017> <0.030, 0.274, -0.033>
		<0.006, 1.568, 0.236> <0.028, 1.176, 0.144> <0.079, 0.662, -0.023> <0.078, 0.262, -0.073>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.131, 0.241, -0.091> <-0.148, -0.066, -0.128> <-0.130, -0.481, -0.049> <-0.121, -0.791, -0.050>
		<-0.068, 0.247, -0.085> <-0.085, -0.060, -0.123> <-0.094, -0.492, -0.052> <-0.085, -0.802, -0.053>
		<0.030, 0.274, -0.033> <0.029, -0.052, -0.073> <-0.030, -0.489, -0.026> <-0.024, -0.817, -0.033>
		<0.078, 0.262, -0.073> <0.077, -0.064, -0.113> <-0.008, -0.501, -0.054> <-0.002, -0.829, -0.061>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.121, -0.791, -0.050> <-0.113, -1.076, -0.050> <-0.089, -1.456, -0.081> <-0.075, -1.741, -0.095>
		<-0.085, -0.802, -0.053> <-0.077, -1.088, -0.054> <-0.032, -1.462, -0.087> <-0.019, -1.747, -0.101>
		<-0.024, -0.817, -0.033> <-0.019, -1.099, -0.039> <0.035, -1.482, -0.062> <0.070, -1.762, -0.078>
		<-0.002, -0.829, -0.061> <0.003, -1.111, -0.067> <0.079, -1.481, -0.099> <0.114, -1.761, -0.115>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.444, 1.970, 0.074> <-0.444, 1.970, 0.074> <-0.444, 1.970, 0.074> <-0.444, 1.970, 0.074>
		<-0.372, 1.604, 0.046> <-0.372, 1.604, 0.046> <-0.427, 1.623, 0.074> <-0.427, 1.623, 0.074>
		<-0.288, 1.115, -0.011> <-0.343, 1.134, 0.017> <-0.393, 1.144, 0.088> <-0.455, 1.154, 0.075>
		<-0.205, 0.751, -0.021> <-0.259, 0.770, 0.007> <-0.325, 0.803, 0.087> <-0.387, 0.814, 0.073>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.205, 0.751, -0.021> <-0.259, 0.770, 0.007> <-0.325, 0.803, 0.087> <-0.387, 0.814, 0.073>
		<-0.097, 0.280, -0.034> <-0.151, 0.299, -0.005> <-0.225, 0.304, 0.084> <-0.287, 0.315, 0.071>
		<0.148, -0.330, 0.033> <0.124, -0.329, 0.051> <0.059, -0.313, 0.097> <0.033, -0.305, 0.084>
		<0.193, -0.810, -0.001> <0.170, -0.809, 0.017> <0.140, -0.815, 0.071> <0.114, -0.808, 0.059>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.193, -0.810, -0.001> <0.170, -0.809, 0.017> <0.140, -0.815, 0.071> <0.114, -0.808, 0.059>
		<0.221, -1.102, -0.021> <0.197, -1.102, -0.004> <0.187, -1.106, 0.056> <0.161, -1.099, 0.044>
		<0.082, -1.475, -0.138> <0.081, -1.481, -0.097> <0.089, -1.490, -0.050> <0.057, -1.490, -0.023>
		<0.034, -1.760, -0.197> <0.033, -1.766, -0.155> <0.064, -1.782, -0.085> <0.032, -1.782, -0.059>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.444, 1.970, 0.074> <-0.445, 1.617, 0.030> <-0.511, 1.142, -0.054> <-0.447, 0.793, -0.072>
		<-0.444, 1.970, 0.074> <-0.445, 1.617, 0.030> <-0.493, 1.149, -0.011> <-0.429, 0.799, -0.029>
		<-0.444, 1.970, 0.074> <-0.427, 1.623, 0.074> <-0.501, 1.162, 0.066> <-0.433, 0.822, 0.064>
		<-0.444, 1.970, 0.074> <-0.427, 1.623, 0.074> <-0.455, 1.154, 0.075> <-0.387, 0.814, 0.073>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.447, 0.793, -0.072> <-0.359, 0.309, -0.097> <-0.000, -0.280, -0.074> <0.055, -0.770, -0.067>
		<-0.429, 0.799, -0.029> <-0.341, 0.315, -0.054> <0.018, -0.292, -0.036> <0.073, -0.781, -0.029>
		<-0.433, 0.822, 0.064> <-0.333, 0.323, 0.061> <-0.004, -0.295, 0.066> <0.077, -0.797, 0.041>
		<-0.387, 0.814, 0.073> <-0.287, 0.315, 0.071> <0.033, -0.305, 0.084> <0.114, -0.808, 0.059>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.055, -0.770, -0.067> <0.090, -1.072, -0.063> <-0.094, -1.464, -0.047> <-0.158, -1.762, -0.039>
		<0.073, -0.781, -0.029> <0.107, -1.084, -0.025> <-0.037, -1.470, -0.053> <-0.101, -1.768, -0.045>
		<0.077, -0.797, 0.041> <0.124, -1.088, 0.026> <0.012, -1.490, 0.013> <-0.012, -1.783, -0.022>
		<0.114, -0.808, 0.059> <0.161, -1.099, 0.044> <0.057, -1.490, -0.023> <0.032, -1.782, -0.059>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.010, 1.481, 0.340> <-1.010, 1.481, 0.340> <-1.010, 1.481, 0.340> <-1.010, 1.481, 0.340>
		<-0.945, 1.164, 0.303> <-0.945, 1.164, 0.303> <-0.957, 1.178, 0.330> <-0.957, 1.178, 0.330>
		<-0.860, 0.742, 0.260> <-0.872, 0.756, 0.287> <-0.868, 0.767, 0.346> <-0.899, 0.772, 0.336>
		<-0.795, 0.427, 0.215> <-0.806, 0.441, 0.242> <-0.803, 0.469, 0.316> <-0.834, 0.473, 0.306>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.795, 0.427, 0.215> <-0.806, 0.441, 0.242> <-0.803, 0.469, 0.316> <-0.834, 0.473, 0.306>
		<-0.717, 0.055, 0.162> <-0.729, 0.069, 0.189> <-0.718, 0.079, 0.278> <-0.749, 0.084, 0.268>
		<-0.646, -0.446, 0.066> <-0.639, -0.445, 0.096> <-0.605, -0.434, 0.142> <-0.630, -0.428, 0.160>
		<-0.536, -0.810, 0.013> <-0.529, -0.809, 0.044> <-0.487, -0.814, 0.097> <-0.512, -0.808, 0.114>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.536, -0.810, 0.013> <-0.529, -0.809, 0.044> <-0.487, -0.814, 0.097> <-0.512, -0.808, 0.114>
		<-0.446, -1.105, -0.029> <-0.439, -1.104, 0.001> <-0.395, -1.112, 0.061> <-0.419, -1.106, 0.079>
		<-0.253, -1.475, -0.067> <-0.254, -1.481, -0.025> <-0.215, -1.490, 0.034> <-0.247, -1.490, 0.060>
		<-0.132, -1.760, -0.101> <-0.133, -1.766, -0.060> <-0.102, -1.782, 0.010> <-0.134, -1.782, 0.037>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.010, 1.481, 0.340> <-0.995, 1.172, 0.287> <-1.005, 0.761, 0.191> <-0.962, 0.452, 0.162>
		<-1.010, 1.481, 0.340> <-0.995, 1.172, 0.287> <-0.967, 0.768, 0.235> <-0.923, 0.459, 0.205>
		<-1.010, 1.481, 0.340> <-0.957, 1.178, 0.330> <-0.954, 0.780, 0.318> <-0.889, 0.482, 0.289>
		<-1.010, 1.481, 0.340> <-0.957, 1.178, 0.330> <-0.899, 0.772, 0.336> <-0.834, 0.473, 0.306>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.962, 0.452, 0.162> <-0.910, 0.082, 0.127> <-0.796, -0.409, 0.144> <-0.692, -0.770, 0.127>
		<-0.923, 0.459, 0.205> <-0.871, 0.088, 0.170> <-0.742, -0.420, 0.140> <-0.638, -0.781, 0.123>
		<-0.889, 0.482, 0.289> <-0.804, 0.092, 0.251> <-0.674, -0.416, 0.192> <-0.556, -0.796, 0.146>
		<-0.834, 0.473, 0.306> <-0.749, 0.084, 0.268> <-0.630, -0.428, 0.160> <-0.512, -0.808, 0.114>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.692, -0.770, 0.127> <-0.604, -1.075, 0.112> <-0.434, -1.464, 0.078> <-0.324, -1.762, 0.057>
		<-0.638, -0.781, 0.123> <-0.550, -1.086, 0.109> <-0.377, -1.470, 0.072> <-0.267, -1.768, 0.051>
		<-0.556, -0.796, 0.146> <-0.463, -1.095, 0.111> <-0.292, -1.490, 0.097> <-0.178, -1.783, 0.074>
		<-0.512, -0.808, 0.114> <-0.419, -1.106, 0.079> <-0.247, -1.490, 0.060> <-0.134, -1.782, 0.037>
	}
	texture {WeedTexture}
}
// Layer 2
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.138, 1.409, -0.370> <-0.148, 1.494, -0.388> <-0.343, 1.402, -0.412> <-0.429, 1.398, -0.394>
		<-0.155, 1.354, -0.446> <-0.165, 1.438, -0.465> <-0.341, 1.365, -0.413> <-0.426, 1.360, -0.395>
		<-0.302, 1.246, -0.324> <-0.309, 1.246, -0.350> <-0.416, 1.286, -0.373> <-0.421, 1.309, -0.386>
		<-0.393, 1.226, -0.300> <-0.400, 1.226, -0.325> <-0.410, 1.254, -0.356> <-0.414, 1.277, -0.368>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.138, 1.409, -0.370> <-0.138, 1.409, -0.370> <-0.138, 1.409, -0.370> <-0.138, 1.409, -0.370>
		<-0.128, 1.320, -0.350> <-0.144, 1.264, -0.427> <-0.144, 1.264, -0.427> <-0.155, 1.354, -0.446>
		<-0.326, 1.291, -0.388> <-0.321, 1.269, -0.375> <-0.309, 1.246, -0.350> <-0.302, 1.246, -0.324>
		<-0.414, 1.277, -0.368> <-0.410, 1.254, -0.356> <-0.400, 1.226, -0.325> <-0.393, 1.226, -0.300>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.138, 1.409, -0.370> <-0.155, 1.354, -0.446> <-0.302, 1.246, -0.324> <-0.393, 1.226, -0.300>
		<-0.128, 1.324, -0.351> <-0.145, 1.268, -0.428> <-0.296, 1.246, -0.299> <-0.387, 1.226, -0.275>
		<-0.294, 1.402, -0.228> <-0.292, 1.365, -0.228> <-0.378, 1.286, -0.225> <-0.381, 1.254, -0.244>
		<-0.378, 1.398, -0.201> <-0.376, 1.360, -0.201> <-0.376, 1.309, -0.212> <-0.379, 1.277, -0.231>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.138, 1.409, -0.370> <-0.138, 1.409, -0.370> <-0.138, 1.409, -0.370> <-0.138, 1.409, -0.370>
		<-0.122, 1.463, -0.296> <-0.139, 1.407, -0.373> <-0.139, 1.407, -0.373> <-0.155, 1.354, -0.446>
		<-0.291, 1.291, -0.258> <-0.293, 1.269, -0.271> <-0.296, 1.246, -0.299> <-0.302, 1.246, -0.324>
		<-0.379, 1.277, -0.231> <-0.381, 1.254, -0.244> <-0.387, 1.226, -0.275> <-0.393, 1.226, -0.300>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.138, 1.409, -0.370> <-0.122, 1.463, -0.296> <-0.291, 1.291, -0.258> <-0.379, 1.277, -0.231>
		<-0.128, 1.320, -0.350> <-0.112, 1.374, -0.276> <-0.293, 1.269, -0.271> <-0.381, 1.254, -0.244>
		<-0.326, 1.291, -0.388> <-0.321, 1.269, -0.375> <-0.393, 1.226, -0.300> <-0.387, 1.226, -0.275>
		<-0.414, 1.277, -0.368> <-0.410, 1.254, -0.356> <-0.400, 1.226, -0.325> <-0.393, 1.226, -0.300>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.138, 1.409, -0.370> <-0.122, 1.463, -0.296> <-0.291, 1.291, -0.258> <-0.379, 1.277, -0.231>
		<-0.149, 1.500, -0.389> <-0.133, 1.553, -0.316> <-0.289, 1.324, -0.239> <-0.376, 1.309, -0.212>
		<-0.303, 1.514, -0.255> <-0.297, 1.482, -0.237> <-0.378, 1.398, -0.201> <-0.376, 1.360, -0.201>
		<-0.393, 1.519, -0.227> <-0.386, 1.487, -0.210> <-0.380, 1.435, -0.200> <-0.378, 1.398, -0.201>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.138, 1.409, -0.370> <-0.138, 1.409, -0.370> <-0.138, 1.409, -0.370> <-0.138, 1.409, -0.370>
		<-0.128, 1.324, -0.351> <-0.112, 1.377, -0.277> <-0.112, 1.377, -0.277> <-0.122, 1.463, -0.296>
		<-0.294, 1.402, -0.228> <-0.292, 1.365, -0.228> <-0.289, 1.324, -0.239> <-0.291, 1.291, -0.258>
		<-0.378, 1.398, -0.201> <-0.376, 1.360, -0.201> <-0.376, 1.309, -0.212> <-0.379, 1.277, -0.231>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.138, 1.409, -0.370> <-0.128, 1.324, -0.351> <-0.294, 1.402, -0.228> <-0.378, 1.398, -0.201>
		<-0.121, 1.466, -0.291> <-0.111, 1.381, -0.273> <-0.297, 1.440, -0.227> <-0.380, 1.435, -0.200>
		<-0.319, 1.560, -0.320> <-0.312, 1.560, -0.295> <-0.391, 1.509, -0.222> <-0.386, 1.487, -0.210>
		<-0.413, 1.569, -0.295> <-0.407, 1.569, -0.270> <-0.397, 1.542, -0.240> <-0.393, 1.519, -0.227>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.138, 1.409, -0.370> <-0.138, 1.409, -0.370> <-0.138, 1.409, -0.370> <-0.138, 1.409, -0.370>
		<-0.149, 1.500, -0.389> <-0.139, 1.415, -0.371> <-0.139, 1.415, -0.371> <-0.128, 1.324, -0.351>
		<-0.303, 1.514, -0.255> <-0.297, 1.482, -0.237> <-0.297, 1.440, -0.227> <-0.294, 1.402, -0.228>
		<-0.393, 1.519, -0.227> <-0.386, 1.487, -0.210> <-0.380, 1.435, -0.200> <-0.378, 1.398, -0.201>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.138, 1.409, -0.370> <-0.149, 1.500, -0.389> <-0.303, 1.514, -0.255> <-0.393, 1.519, -0.227>
		<-0.154, 1.356, -0.444> <-0.165, 1.446, -0.463> <-0.308, 1.536, -0.267> <-0.397, 1.542, -0.240>
		<-0.338, 1.514, -0.385> <-0.336, 1.536, -0.372> <-0.413, 1.569, -0.295> <-0.407, 1.569, -0.270>
		<-0.428, 1.519, -0.364> <-0.426, 1.542, -0.351> <-0.420, 1.569, -0.320> <-0.413, 1.569, -0.295>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.138, 1.409, -0.370> <-0.138, 1.409, -0.370> <-0.138, 1.409, -0.370> <-0.138, 1.409, -0.370>
		<-0.121, 1.466, -0.291> <-0.132, 1.557, -0.311> <-0.132, 1.557, -0.311> <-0.149, 1.500, -0.389>
		<-0.319, 1.560, -0.320> <-0.312, 1.560, -0.295> <-0.308, 1.536, -0.267> <-0.303, 1.514, -0.255>
		<-0.413, 1.569, -0.295> <-0.407, 1.569, -0.270> <-0.397, 1.542, -0.240> <-0.393, 1.519, -0.227>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.138, 1.409, -0.370> <-0.121, 1.466, -0.291> <-0.319, 1.560, -0.320> <-0.413, 1.569, -0.295>
		<-0.148, 1.494, -0.388> <-0.131, 1.551, -0.310> <-0.326, 1.560, -0.345> <-0.420, 1.569, -0.320>
		<-0.343, 1.402, -0.412> <-0.345, 1.440, -0.412> <-0.429, 1.509, -0.370> <-0.426, 1.542, -0.351>
		<-0.429, 1.398, -0.394> <-0.431, 1.435, -0.394> <-0.431, 1.487, -0.383> <-0.428, 1.519, -0.364>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.138, 1.409, -0.370> <-0.138, 1.409, -0.370> <-0.138, 1.409, -0.370> <-0.138, 1.409, -0.370>
		<-0.154, 1.356, -0.444> <-0.137, 1.412, -0.366> <-0.137, 1.412, -0.366> <-0.121, 1.466, -0.291>
		<-0.338, 1.514, -0.385> <-0.336, 1.536, -0.372> <-0.326, 1.560, -0.345> <-0.319, 1.560, -0.320>
		<-0.428, 1.519, -0.364> <-0.426, 1.542, -0.351> <-0.420, 1.569, -0.320> <-0.413, 1.569, -0.295>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.138, 1.409, -0.370> <-0.154, 1.356, -0.444> <-0.338, 1.514, -0.385> <-0.428, 1.519, -0.364>
		<-0.128, 1.320, -0.350> <-0.144, 1.266, -0.424> <-0.340, 1.482, -0.403> <-0.431, 1.487, -0.383>
		<-0.326, 1.291, -0.388> <-0.332, 1.324, -0.406> <-0.429, 1.398, -0.394> <-0.431, 1.435, -0.394>
		<-0.414, 1.277, -0.368> <-0.421, 1.309, -0.386> <-0.426, 1.360, -0.395> <-0.429, 1.398, -0.394>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.138, 1.409, -0.370> <-0.138, 1.409, -0.370> <-0.138, 1.409, -0.370> <-0.138, 1.409, -0.370>
		<-0.148, 1.494, -0.388> <-0.164, 1.440, -0.462> <-0.164, 1.440, -0.462> <-0.154, 1.356, -0.444>
		<-0.343, 1.402, -0.412> <-0.345, 1.440, -0.412> <-0.340, 1.482, -0.403> <-0.338, 1.514, -0.385>
		<-0.429, 1.398, -0.394> <-0.431, 1.435, -0.394> <-0.431, 1.487, -0.383> <-0.428, 1.519, -0.364>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.138, 1.409, -0.370> <-0.138, 1.409, -0.370> <-0.138, 1.409, -0.370> <-0.138, 1.409, -0.370>
		<-0.148, 1.494, -0.388> <-0.138, 1.405, -0.369> <-0.138, 1.405, -0.369> <-0.128, 1.320, -0.350>
		<-0.343, 1.402, -0.412> <-0.341, 1.365, -0.413> <-0.332, 1.324, -0.406> <-0.326, 1.291, -0.388>
		<-0.429, 1.398, -0.394> <-0.426, 1.360, -0.395> <-0.421, 1.309, -0.386> <-0.414, 1.277, -0.368>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.393, 1.226, -0.300> <-0.400, 1.226, -0.325> <-0.410, 1.254, -0.356> <-0.414, 1.277, -0.368>
		<-0.508, 1.202, -0.270> <-0.515, 1.202, -0.295> <-0.526, 1.235, -0.329> <-0.531, 1.257, -0.342>
		<-0.668, 1.297, -0.229> <-0.671, 1.297, -0.240> <-0.676, 1.299, -0.263> <-0.678, 1.310, -0.267>
		<-0.782, 1.271, -0.199> <-0.785, 1.271, -0.210> <-0.789, 1.290, -0.220> <-0.791, 1.301, -0.223>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.393, 1.226, -0.300> <-0.508, 1.202, -0.270> <-0.668, 1.297, -0.229> <-0.782, 1.271, -0.199>
		<-0.387, 1.226, -0.275> <-0.502, 1.202, -0.245> <-0.665, 1.297, -0.217> <-0.779, 1.271, -0.188>
		<-0.381, 1.254, -0.244> <-0.495, 1.235, -0.209> <-0.659, 1.302, -0.194> <-0.778, 1.290, -0.178>
		<-0.379, 1.277, -0.231> <-0.493, 1.257, -0.196> <-0.658, 1.314, -0.190> <-0.778, 1.301, -0.174>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.942, 1.103, -0.157> <-0.894, 1.153, -0.170> <-0.849, 1.256, -0.182> <-0.782, 1.271, -0.199>
		<-0.972, 1.123, -0.178> <-0.924, 1.174, -0.191> <-0.852, 1.256, -0.193> <-0.785, 1.271, -0.210>
		<-0.920, 1.196, -0.170> <-0.884, 1.216, -0.185> <-0.830, 1.287, -0.204> <-0.789, 1.290, -0.220>
		<-0.912, 1.237, -0.174> <-0.876, 1.256, -0.189> <-0.831, 1.298, -0.207> <-0.791, 1.301, -0.223>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.942, 1.103, -0.157> <-0.915, 1.083, -0.138> <-0.900, 1.185, -0.161> <-0.894, 1.224, -0.161>
		<-0.894, 1.153, -0.170> <-0.867, 1.134, -0.150> <-0.865, 1.208, -0.165> <-0.859, 1.247, -0.165>
		<-0.849, 1.256, -0.182> <-0.846, 1.256, -0.170> <-0.820, 1.286, -0.172> <-0.819, 1.297, -0.168>
		<-0.782, 1.271, -0.199> <-0.779, 1.271, -0.188> <-0.778, 1.290, -0.178> <-0.778, 1.301, -0.174>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.894, 1.224, -0.161> <-0.887, 1.262, -0.161> <-0.898, 1.314, -0.156> <-0.900, 1.353, -0.156>
		<-0.859, 1.247, -0.165> <-0.853, 1.285, -0.165> <-0.862, 1.321, -0.158> <-0.864, 1.359, -0.158>
		<-0.819, 1.297, -0.168> <-0.819, 1.318, -0.161> <-0.815, 1.349, -0.160> <-0.816, 1.371, -0.159>
		<-0.778, 1.301, -0.174> <-0.777, 1.322, -0.166> <-0.778, 1.352, -0.163> <-0.779, 1.374, -0.162>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.900, 1.353, -0.156> <-0.903, 1.396, -0.155> <-0.898, 1.455, -0.158> <-0.910, 1.496, -0.157>
		<-0.864, 1.359, -0.158> <-0.867, 1.402, -0.157> <-0.861, 1.440, -0.162> <-0.873, 1.482, -0.161>
		<-0.816, 1.371, -0.159> <-0.817, 1.393, -0.159> <-0.823, 1.424, -0.159> <-0.826, 1.445, -0.166>
		<-0.779, 1.374, -0.162> <-0.781, 1.396, -0.162> <-0.783, 1.426, -0.165> <-0.786, 1.447, -0.172>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.910, 1.496, -0.157> <-0.921, 1.538, -0.156> <-0.962, 1.624, -0.108> <-0.972, 1.624, -0.150>
		<-0.873, 1.482, -0.161> <-0.884, 1.523, -0.160> <-0.908, 1.580, -0.122> <-0.919, 1.580, -0.163>
		<-0.826, 1.445, -0.166> <-0.828, 1.456, -0.170> <-0.859, 1.484, -0.167> <-0.862, 1.484, -0.178>
		<-0.786, 1.447, -0.172> <-0.788, 1.458, -0.175> <-0.791, 1.477, -0.184> <-0.794, 1.477, -0.196>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.972, 1.624, -0.150> <-0.983, 1.624, -0.191> <-0.926, 1.537, -0.169> <-0.914, 1.496, -0.174>
		<-0.919, 1.580, -0.163> <-0.930, 1.580, -0.205> <-0.891, 1.522, -0.183> <-0.879, 1.482, -0.188>
		<-0.862, 1.484, -0.178> <-0.865, 1.484, -0.190> <-0.836, 1.456, -0.202> <-0.836, 1.445, -0.206>
		<-0.794, 1.477, -0.196> <-0.797, 1.477, -0.207> <-0.799, 1.458, -0.217> <-0.799, 1.447, -0.221>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.914, 1.496, -0.174> <-0.902, 1.455, -0.179> <-0.893, 1.397, -0.183> <-0.893, 1.354, -0.183>
		<-0.879, 1.482, -0.188> <-0.867, 1.440, -0.193> <-0.865, 1.403, -0.198> <-0.864, 1.360, -0.198>
		<-0.836, 1.445, -0.206> <-0.837, 1.424, -0.214> <-0.829, 1.393, -0.219> <-0.827, 1.371, -0.219>
		<-0.799, 1.447, -0.221> <-0.800, 1.426, -0.228> <-0.799, 1.396, -0.232> <-0.797, 1.374, -0.232>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.893, 1.354, -0.183> <-0.893, 1.318, -0.183> <-0.905, 1.272, -0.178> <-0.912, 1.237, -0.174>
		<-0.864, 1.360, -0.198> <-0.864, 1.324, -0.198> <-0.869, 1.291, -0.192> <-0.876, 1.256, -0.189>
		<-0.827, 1.371, -0.219> <-0.826, 1.349, -0.219> <-0.834, 1.319, -0.214> <-0.831, 1.298, -0.207>
		<-0.797, 1.374, -0.232> <-0.796, 1.352, -0.233> <-0.794, 1.322, -0.230> <-0.791, 1.301, -0.223>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.778, 1.301, -0.174> <-0.777, 1.322, -0.166> <-0.778, 1.352, -0.163> <-0.779, 1.374, -0.162>
		<-0.658, 1.314, -0.190> <-0.658, 1.334, -0.183> <-0.658, 1.362, -0.173> <-0.659, 1.384, -0.173>
		<-0.493, 1.257, -0.196> <-0.490, 1.290, -0.177> <-0.491, 1.354, -0.164> <-0.493, 1.391, -0.164>
		<-0.379, 1.277, -0.231> <-0.376, 1.309, -0.212> <-0.376, 1.360, -0.201> <-0.378, 1.398, -0.201>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.779, 1.374, -0.162> <-0.781, 1.396, -0.162> <-0.783, 1.426, -0.165> <-0.786, 1.447, -0.172>
		<-0.659, 1.384, -0.173> <-0.660, 1.406, -0.173> <-0.663, 1.431, -0.181> <-0.666, 1.452, -0.188>
		<-0.493, 1.391, -0.164> <-0.495, 1.429, -0.163> <-0.502, 1.493, -0.174> <-0.508, 1.526, -0.192>
		<-0.378, 1.398, -0.201> <-0.380, 1.435, -0.200> <-0.386, 1.487, -0.210> <-0.393, 1.519, -0.227>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.786, 1.447, -0.172> <-0.788, 1.458, -0.175> <-0.791, 1.477, -0.184> <-0.794, 1.477, -0.196>
		<-0.666, 1.452, -0.188> <-0.668, 1.463, -0.192> <-0.674, 1.465, -0.215> <-0.677, 1.465, -0.226>
		<-0.508, 1.526, -0.192> <-0.513, 1.548, -0.204> <-0.523, 1.581, -0.239> <-0.530, 1.581, -0.264>
		<-0.393, 1.519, -0.227> <-0.397, 1.542, -0.240> <-0.407, 1.569, -0.270> <-0.413, 1.569, -0.295>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.794, 1.477, -0.196> <-0.797, 1.477, -0.207> <-0.799, 1.458, -0.217> <-0.799, 1.447, -0.221>
		<-0.677, 1.465, -0.226> <-0.680, 1.465, -0.238> <-0.686, 1.463, -0.261> <-0.686, 1.452, -0.265>
		<-0.530, 1.581, -0.264> <-0.537, 1.581, -0.289> <-0.544, 1.548, -0.325> <-0.546, 1.526, -0.338>
		<-0.413, 1.569, -0.295> <-0.420, 1.569, -0.320> <-0.426, 1.542, -0.351> <-0.428, 1.519, -0.364>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.799, 1.447, -0.221> <-0.800, 1.426, -0.228> <-0.799, 1.396, -0.232> <-0.797, 1.374, -0.232>
		<-0.686, 1.452, -0.265> <-0.687, 1.431, -0.273> <-0.689, 1.406, -0.282> <-0.688, 1.384, -0.282>
		<-0.546, 1.526, -0.338> <-0.549, 1.493, -0.356> <-0.549, 1.429, -0.369> <-0.547, 1.391, -0.370>
		<-0.428, 1.519, -0.364> <-0.431, 1.487, -0.383> <-0.431, 1.435, -0.394> <-0.429, 1.398, -0.394>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.797, 1.374, -0.232> <-0.796, 1.352, -0.233> <-0.794, 1.322, -0.230> <-0.791, 1.301, -0.223>
		<-0.688, 1.384, -0.282> <-0.686, 1.362, -0.283> <-0.681, 1.331, -0.274> <-0.678, 1.310, -0.267>
		<-0.547, 1.391, -0.370> <-0.545, 1.354, -0.370> <-0.538, 1.290, -0.360> <-0.531, 1.257, -0.342>
		<-0.429, 1.398, -0.394> <-0.426, 1.360, -0.395> <-0.421, 1.309, -0.386> <-0.414, 1.277, -0.368>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.707, 1.553, -0.219> <-0.707, 1.553, -0.219> <-0.707, 1.553, -0.219> <-0.707, 1.553, -0.219>
		<-0.674, 1.502, -0.227> <-0.582, 1.520, -0.251> <-0.582, 1.520, -0.251> <-0.616, 1.571, -0.242>
		<-0.597, 1.444, -0.247> <-0.603, 1.535, -0.246> <-0.550, 1.569, -0.259> <-0.493, 1.638, -0.274>
		<-0.595, 1.381, -0.248> <-0.602, 1.473, -0.246> <-0.461, 1.543, -0.283> <-0.403, 1.613, -0.298>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.258, 1.427, -0.335> <-0.253, 1.352, -0.337> <-0.309, 1.239, -0.322> <-0.375, 1.205, -0.305>
		<-0.263, 1.499, -0.334> <-0.258, 1.423, -0.335> <-0.375, 1.292, -0.305> <-0.441, 1.258, -0.288>
		<-0.336, 1.594, -0.315> <-0.394, 1.525, -0.300> <-0.596, 1.387, -0.248> <-0.589, 1.295, -0.249>
		<-0.403, 1.613, -0.298> <-0.461, 1.543, -0.283> <-0.602, 1.473, -0.246> <-0.595, 1.381, -0.248>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.697, 1.205, -0.221> <-0.697, 1.205, -0.221> <-0.697, 1.205, -0.221> <-0.697, 1.205, -0.221>
		<-0.600, 1.205, -0.246> <-0.570, 1.258, -0.254> <-0.570, 1.258, -0.254> <-0.666, 1.258, -0.229>
		<-0.462, 1.161, -0.282> <-0.528, 1.214, -0.265> <-0.587, 1.234, -0.250> <-0.593, 1.320, -0.248>
		<-0.375, 1.205, -0.305> <-0.441, 1.258, -0.288> <-0.589, 1.295, -0.249> <-0.595, 1.381, -0.248>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.013, 2.270, 0.104> <0.003, 2.352, 0.078> <-0.193, 2.311, 0.005> <-0.278, 2.329, -0.002>
		<-0.018, 2.226, 0.025> <-0.003, 2.308, -0.000> <-0.198, 2.281, 0.005> <-0.283, 2.300, -0.002>
		<-0.215, 2.188, 0.101> <-0.214, 2.188, 0.076> <-0.295, 2.239, 0.024> <-0.291, 2.259, 0.010>
		<-0.305, 2.196, 0.098> <-0.304, 2.196, 0.074> <-0.300, 2.216, 0.042> <-0.296, 2.235, 0.027>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.013, 2.270, 0.104> <-0.013, 2.270, 0.104> <-0.013, 2.270, 0.104> <-0.013, 2.270, 0.104>
		<-0.029, 2.187, 0.130> <-0.034, 2.142, 0.051> <-0.034, 2.142, 0.051> <-0.018, 2.226, 0.025>
		<-0.208, 2.224, 0.033> <-0.212, 2.204, 0.048> <-0.214, 2.188, 0.076> <-0.215, 2.188, 0.101>
		<-0.296, 2.235, 0.027> <-0.300, 2.216, 0.042> <-0.304, 2.196, 0.074> <-0.305, 2.196, 0.098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.013, 2.270, 0.104> <-0.018, 2.226, 0.025> <-0.215, 2.188, 0.101> <-0.305, 2.196, 0.098>
		<-0.029, 2.187, 0.130> <-0.034, 2.143, 0.051> <-0.216, 2.188, 0.125> <-0.306, 2.196, 0.123>
		<-0.198, 2.312, 0.196> <-0.203, 2.283, 0.196> <-0.299, 2.241, 0.172> <-0.303, 2.217, 0.155>
		<-0.284, 2.331, 0.198> <-0.289, 2.301, 0.198> <-0.296, 2.260, 0.187> <-0.300, 2.236, 0.169>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.013, 2.270, 0.104> <-0.013, 2.270, 0.104> <-0.013, 2.270, 0.104> <-0.013, 2.270, 0.104>
		<-0.007, 2.313, 0.181> <-0.013, 2.269, 0.103> <-0.013, 2.269, 0.103> <-0.018, 2.226, 0.025>
		<-0.212, 2.225, 0.168> <-0.215, 2.205, 0.154> <-0.216, 2.188, 0.125> <-0.215, 2.188, 0.101>
		<-0.300, 2.236, 0.169> <-0.303, 2.217, 0.155> <-0.306, 2.196, 0.123> <-0.305, 2.196, 0.098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.013, 2.270, 0.104> <-0.007, 2.313, 0.181> <-0.212, 2.225, 0.168> <-0.300, 2.236, 0.169>
		<-0.029, 2.187, 0.130> <-0.023, 2.230, 0.207> <-0.215, 2.205, 0.154> <-0.303, 2.217, 0.155>
		<-0.208, 2.224, 0.033> <-0.212, 2.204, 0.048> <-0.305, 2.196, 0.098> <-0.306, 2.196, 0.123>
		<-0.296, 2.235, 0.027> <-0.300, 2.216, 0.042> <-0.304, 2.196, 0.074> <-0.305, 2.196, 0.098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.013, 2.270, 0.104> <-0.007, 2.313, 0.181> <-0.212, 2.225, 0.168> <-0.300, 2.236, 0.169>
		<0.004, 2.355, 0.077> <0.009, 2.399, 0.154> <-0.208, 2.249, 0.186> <-0.296, 2.260, 0.187>
		<-0.179, 2.399, 0.168> <-0.184, 2.375, 0.185> <-0.284, 2.331, 0.198> <-0.289, 2.301, 0.198>
		<-0.266, 2.425, 0.168> <-0.271, 2.402, 0.186> <-0.279, 2.361, 0.198> <-0.284, 2.331, 0.198>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.013, 2.270, 0.104> <-0.013, 2.270, 0.104> <-0.013, 2.270, 0.104> <-0.013, 2.270, 0.104>
		<-0.029, 2.187, 0.130> <-0.023, 2.231, 0.207> <-0.023, 2.231, 0.207> <-0.007, 2.313, 0.181>
		<-0.198, 2.312, 0.196> <-0.203, 2.283, 0.196> <-0.208, 2.249, 0.186> <-0.212, 2.225, 0.168>
		<-0.284, 2.331, 0.198> <-0.289, 2.301, 0.198> <-0.296, 2.260, 0.187> <-0.300, 2.236, 0.169>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.013, 2.270, 0.104> <-0.029, 2.187, 0.130> <-0.198, 2.312, 0.196> <-0.284, 2.331, 0.198>
		<-0.007, 2.316, 0.185> <-0.023, 2.233, 0.211> <-0.193, 2.342, 0.196> <-0.279, 2.361, 0.198>
		<-0.168, 2.433, 0.100> <-0.169, 2.434, 0.125> <-0.267, 2.421, 0.172> <-0.271, 2.402, 0.186>
		<-0.257, 2.464, 0.098> <-0.257, 2.464, 0.122> <-0.262, 2.445, 0.154> <-0.266, 2.425, 0.168>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.013, 2.270, 0.104> <-0.013, 2.270, 0.104> <-0.013, 2.270, 0.104> <-0.013, 2.270, 0.104>
		<0.004, 2.355, 0.077> <-0.012, 2.273, 0.103> <-0.012, 2.273, 0.103> <-0.029, 2.187, 0.130>
		<-0.179, 2.399, 0.168> <-0.184, 2.375, 0.185> <-0.193, 2.342, 0.196> <-0.198, 2.312, 0.196>
		<-0.266, 2.425, 0.168> <-0.271, 2.402, 0.186> <-0.279, 2.361, 0.198> <-0.284, 2.331, 0.198>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.013, 2.270, 0.104> <0.004, 2.355, 0.077> <-0.179, 2.399, 0.168> <-0.266, 2.425, 0.168>
		<-0.018, 2.225, 0.025> <-0.002, 2.311, -0.002> <-0.175, 2.418, 0.153> <-0.262, 2.445, 0.154>
		<-0.175, 2.398, 0.033> <-0.172, 2.417, 0.047> <-0.257, 2.464, 0.098> <-0.257, 2.464, 0.122>
		<-0.262, 2.424, 0.027> <-0.259, 2.444, 0.041> <-0.256, 2.464, 0.073> <-0.257, 2.464, 0.098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.013, 2.270, 0.104> <-0.013, 2.270, 0.104> <-0.013, 2.270, 0.104> <-0.013, 2.270, 0.104>
		<-0.007, 2.316, 0.185> <0.009, 2.401, 0.158> <0.009, 2.401, 0.158> <0.004, 2.355, 0.077>
		<-0.168, 2.433, 0.100> <-0.169, 2.434, 0.125> <-0.175, 2.418, 0.153> <-0.179, 2.399, 0.168>
		<-0.257, 2.464, 0.098> <-0.257, 2.464, 0.122> <-0.262, 2.445, 0.154> <-0.266, 2.425, 0.168>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.013, 2.270, 0.104> <-0.007, 2.316, 0.185> <-0.168, 2.433, 0.100> <-0.257, 2.464, 0.098>
		<0.003, 2.352, 0.078> <0.009, 2.398, 0.160> <-0.168, 2.433, 0.076> <-0.256, 2.464, 0.073>
		<-0.193, 2.311, 0.005> <-0.187, 2.341, 0.005> <-0.262, 2.420, 0.024> <-0.259, 2.444, 0.041>
		<-0.278, 2.329, -0.002> <-0.272, 2.359, -0.002> <-0.265, 2.400, 0.009> <-0.262, 2.424, 0.027>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.013, 2.270, 0.104> <-0.013, 2.270, 0.104> <-0.013, 2.270, 0.104> <-0.013, 2.270, 0.104>
		<-0.018, 2.225, 0.025> <-0.013, 2.271, 0.106> <-0.013, 2.271, 0.106> <-0.007, 2.316, 0.185>
		<-0.175, 2.398, 0.033> <-0.172, 2.417, 0.047> <-0.168, 2.433, 0.076> <-0.168, 2.433, 0.100>
		<-0.262, 2.424, 0.027> <-0.259, 2.444, 0.041> <-0.256, 2.464, 0.073> <-0.257, 2.464, 0.098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.013, 2.270, 0.104> <-0.018, 2.225, 0.025> <-0.175, 2.398, 0.033> <-0.262, 2.424, 0.027>
		<-0.029, 2.187, 0.130> <-0.034, 2.142, 0.051> <-0.179, 2.374, 0.015> <-0.265, 2.400, 0.009>
		<-0.208, 2.224, 0.033> <-0.203, 2.247, 0.015> <-0.278, 2.329, -0.002> <-0.272, 2.359, -0.002>
		<-0.296, 2.235, 0.027> <-0.291, 2.259, 0.010> <-0.283, 2.300, -0.002> <-0.278, 2.329, -0.002>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.013, 2.270, 0.104> <-0.013, 2.270, 0.104> <-0.013, 2.270, 0.104> <-0.013, 2.270, 0.104>
		<0.003, 2.352, 0.078> <-0.003, 2.307, -0.001> <-0.003, 2.307, -0.001> <-0.018, 2.225, 0.025>
		<-0.193, 2.311, 0.005> <-0.187, 2.341, 0.005> <-0.179, 2.374, 0.015> <-0.175, 2.398, 0.033>
		<-0.278, 2.329, -0.002> <-0.272, 2.359, -0.002> <-0.265, 2.400, 0.009> <-0.262, 2.424, 0.027>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.013, 2.270, 0.104> <-0.013, 2.270, 0.104> <-0.013, 2.270, 0.104> <-0.013, 2.270, 0.104>
		<0.003, 2.352, 0.078> <-0.013, 2.269, 0.104> <-0.013, 2.269, 0.104> <-0.029, 2.187, 0.130>
		<-0.193, 2.311, 0.005> <-0.198, 2.281, 0.005> <-0.203, 2.247, 0.015> <-0.208, 2.224, 0.033>
		<-0.278, 2.329, -0.002> <-0.283, 2.300, -0.002> <-0.291, 2.259, 0.010> <-0.296, 2.235, 0.027>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.305, 2.196, 0.098> <-0.304, 2.196, 0.074> <-0.300, 2.216, 0.042> <-0.296, 2.235, 0.027>
		<-0.426, 2.207, 0.095> <-0.425, 2.207, 0.071> <-0.420, 2.231, 0.034> <-0.416, 2.250, 0.020>
		<-0.564, 2.322, 0.089> <-0.564, 2.322, 0.079> <-0.563, 2.322, 0.054> <-0.562, 2.332, 0.050>
		<-0.685, 2.332, 0.086> <-0.685, 2.332, 0.075> <-0.682, 2.346, 0.064> <-0.680, 2.355, 0.060>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.305, 2.196, 0.098> <-0.426, 2.207, 0.095> <-0.564, 2.322, 0.089> <-0.685, 2.332, 0.086>
		<-0.306, 2.196, 0.123> <-0.426, 2.208, 0.119> <-0.565, 2.322, 0.100> <-0.685, 2.332, 0.096>
		<-0.303, 2.217, 0.155> <-0.423, 2.232, 0.156> <-0.565, 2.325, 0.125> <-0.683, 2.346, 0.107>
		<-0.300, 2.236, 0.169> <-0.420, 2.251, 0.170> <-0.564, 2.335, 0.129> <-0.682, 2.355, 0.111>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.878, 2.244, 0.080> <-0.820, 2.271, 0.082> <-0.748, 2.337, 0.084> <-0.685, 2.332, 0.086>
		<-0.893, 2.262, 0.056> <-0.835, 2.289, 0.058> <-0.748, 2.337, 0.073> <-0.685, 2.332, 0.075>
		<-0.836, 2.309, 0.074> <-0.794, 2.314, 0.071> <-0.723, 2.354, 0.068> <-0.682, 2.346, 0.064>
		<-0.819, 2.338, 0.073> <-0.777, 2.343, 0.069> <-0.721, 2.363, 0.063> <-0.680, 2.355, 0.060>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.878, 2.244, 0.080> <-0.864, 2.227, 0.103> <-0.822, 2.296, 0.088> <-0.808, 2.325, 0.090>
		<-0.820, 2.271, 0.082> <-0.806, 2.253, 0.105> <-0.784, 2.305, 0.094> <-0.770, 2.334, 0.097>
		<-0.748, 2.337, 0.084> <-0.749, 2.337, 0.094> <-0.722, 2.353, 0.101> <-0.720, 2.362, 0.105>
		<-0.685, 2.332, 0.086> <-0.685, 2.332, 0.096> <-0.683, 2.346, 0.107> <-0.682, 2.355, 0.111>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.808, 2.325, 0.090> <-0.795, 2.353, 0.092> <-0.795, 2.396, 0.094> <-0.790, 2.426, 0.094>
		<-0.770, 2.334, 0.097> <-0.757, 2.362, 0.099> <-0.760, 2.392, 0.102> <-0.754, 2.422, 0.102>
		<-0.720, 2.362, 0.105> <-0.717, 2.378, 0.112> <-0.710, 2.402, 0.114> <-0.707, 2.419, 0.114>
		<-0.682, 2.355, 0.111> <-0.679, 2.371, 0.118> <-0.675, 2.395, 0.121> <-0.672, 2.412, 0.121>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.790, 2.426, 0.094> <-0.784, 2.460, 0.094> <-0.767, 2.504, 0.092> <-0.770, 2.538, 0.090>
		<-0.754, 2.422, 0.102> <-0.748, 2.456, 0.102> <-0.735, 2.483, 0.098> <-0.737, 2.517, 0.096>
		<-0.707, 2.419, 0.114> <-0.704, 2.436, 0.114> <-0.702, 2.462, 0.112> <-0.699, 2.477, 0.105>
		<-0.672, 2.412, 0.121> <-0.668, 2.430, 0.121> <-0.664, 2.453, 0.118> <-0.661, 2.469, 0.111>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.770, 2.538, 0.090> <-0.772, 2.574, 0.088> <-0.806, 2.652, 0.115> <-0.804, 2.652, 0.079>
		<-0.737, 2.517, 0.096> <-0.739, 2.553, 0.094> <-0.761, 2.604, 0.117> <-0.760, 2.604, 0.081>
		<-0.699, 2.477, 0.105> <-0.697, 2.487, 0.101> <-0.718, 2.514, 0.094> <-0.718, 2.514, 0.083>
		<-0.661, 2.469, 0.111> <-0.659, 2.478, 0.106> <-0.656, 2.492, 0.096> <-0.656, 2.492, 0.085>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.804, 2.652, 0.079> <-0.803, 2.651, 0.043> <-0.774, 2.573, 0.074> <-0.769, 2.538, 0.073>
		<-0.760, 2.604, 0.081> <-0.759, 2.604, 0.045> <-0.741, 2.553, 0.070> <-0.736, 2.517, 0.069>
		<-0.718, 2.514, 0.083> <-0.717, 2.513, 0.073> <-0.696, 2.487, 0.067> <-0.697, 2.477, 0.063>
		<-0.656, 2.492, 0.085> <-0.656, 2.492, 0.075> <-0.658, 2.478, 0.064> <-0.659, 2.469, 0.060>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.769, 2.538, 0.073> <-0.765, 2.504, 0.071> <-0.767, 2.457, 0.070> <-0.776, 2.423, 0.070>
		<-0.736, 2.517, 0.069> <-0.732, 2.483, 0.067> <-0.735, 2.453, 0.064> <-0.744, 2.420, 0.064>
		<-0.697, 2.477, 0.063> <-0.700, 2.461, 0.056> <-0.698, 2.435, 0.054> <-0.701, 2.418, 0.054>
		<-0.659, 2.469, 0.060> <-0.662, 2.453, 0.053> <-0.666, 2.429, 0.049> <-0.669, 2.412, 0.049>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.776, 2.423, 0.070> <-0.783, 2.395, 0.070> <-0.805, 2.363, 0.071> <-0.819, 2.338, 0.073>
		<-0.744, 2.420, 0.064> <-0.751, 2.392, 0.064> <-0.763, 2.368, 0.067> <-0.777, 2.343, 0.069>
		<-0.701, 2.418, 0.054> <-0.704, 2.400, 0.054> <-0.718, 2.379, 0.056> <-0.721, 2.363, 0.063>
		<-0.669, 2.412, 0.049> <-0.672, 2.394, 0.049> <-0.677, 2.371, 0.053> <-0.680, 2.355, 0.060>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.682, 2.355, 0.111> <-0.679, 2.371, 0.118> <-0.675, 2.395, 0.121> <-0.672, 2.412, 0.121>
		<-0.564, 2.335, 0.129> <-0.561, 2.351, 0.136> <-0.558, 2.373, 0.145> <-0.555, 2.390, 0.145>
		<-0.420, 2.251, 0.170> <-0.417, 2.275, 0.188> <-0.408, 2.327, 0.201> <-0.402, 2.357, 0.201>
		<-0.300, 2.236, 0.169> <-0.296, 2.260, 0.187> <-0.289, 2.301, 0.198> <-0.284, 2.331, 0.198>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.672, 2.412, 0.121> <-0.668, 2.430, 0.121> <-0.664, 2.453, 0.118> <-0.661, 2.469, 0.111>
		<-0.555, 2.390, 0.145> <-0.552, 2.408, 0.145> <-0.548, 2.427, 0.136> <-0.545, 2.443, 0.129>
		<-0.402, 2.357, 0.201> <-0.397, 2.386, 0.201> <-0.386, 2.437, 0.188> <-0.381, 2.461, 0.170>
		<-0.284, 2.331, 0.198> <-0.279, 2.361, 0.198> <-0.271, 2.402, 0.186> <-0.266, 2.425, 0.168>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.661, 2.469, 0.111> <-0.659, 2.478, 0.106> <-0.656, 2.492, 0.096> <-0.656, 2.492, 0.085>
		<-0.545, 2.443, 0.129> <-0.543, 2.452, 0.125> <-0.543, 2.454, 0.099> <-0.542, 2.453, 0.089>
		<-0.381, 2.461, 0.170> <-0.377, 2.480, 0.155> <-0.371, 2.503, 0.119> <-0.370, 2.503, 0.094>
		<-0.266, 2.425, 0.168> <-0.262, 2.445, 0.154> <-0.257, 2.464, 0.122> <-0.257, 2.464, 0.098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.656, 2.492, 0.085> <-0.656, 2.492, 0.075> <-0.658, 2.478, 0.064> <-0.659, 2.469, 0.060>
		<-0.542, 2.453, 0.089> <-0.542, 2.453, 0.078> <-0.541, 2.452, 0.053> <-0.542, 2.442, 0.049>
		<-0.370, 2.503, 0.094> <-0.369, 2.503, 0.070> <-0.373, 2.479, 0.034> <-0.376, 2.460, 0.019>
		<-0.257, 2.464, 0.098> <-0.256, 2.464, 0.073> <-0.259, 2.444, 0.041> <-0.262, 2.424, 0.027>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.659, 2.469, 0.060> <-0.662, 2.453, 0.053> <-0.666, 2.429, 0.049> <-0.669, 2.412, 0.049>
		<-0.542, 2.442, 0.049> <-0.545, 2.427, 0.042> <-0.548, 2.407, 0.032> <-0.552, 2.390, 0.032>
		<-0.376, 2.460, 0.019> <-0.380, 2.436, 0.001> <-0.390, 2.385, -0.012> <-0.396, 2.355, -0.012>
		<-0.262, 2.424, 0.027> <-0.265, 2.400, 0.009> <-0.272, 2.359, -0.002> <-0.278, 2.329, -0.002>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.669, 2.412, 0.049> <-0.672, 2.394, 0.049> <-0.677, 2.371, 0.053> <-0.680, 2.355, 0.060>
		<-0.552, 2.390, 0.032> <-0.555, 2.372, 0.032> <-0.558, 2.347, 0.043> <-0.562, 2.332, 0.050>
		<-0.396, 2.355, -0.012> <-0.401, 2.325, -0.012> <-0.411, 2.274, 0.002> <-0.416, 2.250, 0.020>
		<-0.278, 2.329, -0.002> <-0.283, 2.300, -0.002> <-0.291, 2.259, 0.010> <-0.296, 2.235, 0.027>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.554, 2.528, 0.088> <-0.554, 2.528, 0.088> <-0.554, 2.528, 0.088> <-0.554, 2.528, 0.088>
		<-0.530, 2.480, 0.089> <-0.435, 2.470, 0.092> <-0.435, 2.470, 0.092> <-0.459, 2.518, 0.091>
		<-0.464, 2.420, 0.092> <-0.451, 2.500, 0.091> <-0.394, 2.499, 0.093> <-0.323, 2.538, 0.095>
		<-0.476, 2.367, 0.092> <-0.463, 2.447, 0.092> <-0.309, 2.457, 0.096> <-0.238, 2.495, 0.098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.130, 2.315, 0.103> <-0.141, 2.252, 0.103> <-0.227, 2.183, 0.101> <-0.291, 2.175, 0.099>
		<-0.120, 2.377, 0.103> <-0.130, 2.314, 0.103> <-0.283, 2.240, 0.099> <-0.346, 2.233, 0.097>
		<-0.182, 2.467, 0.100> <-0.253, 2.428, 0.098> <-0.476, 2.368, 0.092> <-0.489, 2.288, 0.092>
		<-0.238, 2.495, 0.098> <-0.309, 2.457, 0.096> <-0.463, 2.447, 0.092> <-0.476, 2.367, 0.092>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.613, 2.259, 0.088> <-0.613, 2.259, 0.088> <-0.613, 2.259, 0.088> <-0.613, 2.259, 0.088>
		<-0.516, 2.234, 0.092> <-0.475, 2.266, 0.093> <-0.475, 2.266, 0.093> <-0.572, 2.292, 0.089>
		<-0.390, 2.164, 0.096> <-0.445, 2.221, 0.094> <-0.500, 2.237, 0.092> <-0.487, 2.316, 0.092>
		<-0.291, 2.175, 0.099> <-0.346, 2.233, 0.097> <-0.489, 2.288, 0.092> <-0.476, 2.367, 0.092>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.073, 3.125, 0.216> <1.059, 3.209, 0.195> <0.928, 3.090, 0.069> <0.849, 3.070, 0.038>
		<1.111, 3.076, 0.142> <1.096, 3.159, 0.121> <0.937, 3.054, 0.070> <0.858, 3.034, 0.038>
		<0.945, 2.934, 0.165> <0.953, 2.936, 0.140> <0.869, 2.961, 0.062> <0.868, 2.983, 0.049>
		<0.860, 2.898, 0.136> <0.868, 2.899, 0.111> <0.871, 2.928, 0.080> <0.870, 2.951, 0.068>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.073, 3.125, 0.216> <1.073, 3.125, 0.216> <1.073, 3.125, 0.216> <1.073, 3.125, 0.216>
		<1.088, 3.038, 0.238> <1.126, 2.988, 0.164> <1.126, 2.988, 0.164> <1.111, 3.076, 0.142>
		<0.951, 2.981, 0.099> <0.952, 2.959, 0.112> <0.953, 2.936, 0.140> <0.945, 2.934, 0.165>
		<0.870, 2.951, 0.068> <0.871, 2.928, 0.080> <0.868, 2.899, 0.111> <0.860, 2.898, 0.136>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.073, 3.125, 0.216> <1.111, 3.076, 0.142> <0.945, 2.934, 0.165> <0.860, 2.898, 0.136>
		<1.088, 3.041, 0.237> <1.126, 2.992, 0.163> <0.937, 2.933, 0.190> <0.852, 2.896, 0.160>
		<0.870, 3.079, 0.250> <0.879, 3.043, 0.251> <0.822, 2.952, 0.207> <0.836, 2.921, 0.190>
		<0.788, 3.058, 0.228> <0.797, 3.022, 0.228> <0.813, 2.973, 0.219> <0.826, 2.942, 0.202>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.073, 3.125, 0.216> <1.073, 3.125, 0.216> <1.073, 3.125, 0.216> <1.073, 3.125, 0.216>
		<1.037, 3.173, 0.286> <1.075, 3.123, 0.213> <1.075, 3.123, 0.213> <1.111, 3.076, 0.142>
		<0.910, 2.973, 0.227> <0.919, 2.952, 0.215> <0.937, 2.933, 0.190> <0.945, 2.934, 0.165>
		<0.826, 2.942, 0.202> <0.836, 2.921, 0.190> <0.852, 2.896, 0.160> <0.860, 2.898, 0.136>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.073, 3.125, 0.216> <1.037, 3.173, 0.286> <0.910, 2.973, 0.227> <0.826, 2.942, 0.202>
		<1.088, 3.038, 0.238> <1.052, 3.085, 0.308> <0.919, 2.952, 0.215> <0.836, 2.921, 0.190>
		<0.951, 2.981, 0.099> <0.952, 2.959, 0.112> <0.860, 2.898, 0.136> <0.852, 2.896, 0.160>
		<0.870, 2.951, 0.068> <0.871, 2.928, 0.080> <0.868, 2.899, 0.111> <0.860, 2.898, 0.136>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.073, 3.125, 0.216> <1.037, 3.173, 0.286> <0.910, 2.973, 0.227> <0.826, 2.942, 0.202>
		<1.058, 3.215, 0.193> <1.021, 3.262, 0.264> <0.896, 3.004, 0.244> <0.813, 2.973, 0.219>
		<0.856, 3.190, 0.223> <0.858, 3.157, 0.241> <0.788, 3.058, 0.228> <0.797, 3.022, 0.228>
		<0.767, 3.178, 0.197> <0.769, 3.145, 0.216> <0.778, 3.095, 0.227> <0.788, 3.058, 0.228>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.073, 3.125, 0.216> <1.073, 3.125, 0.216> <1.073, 3.125, 0.216> <1.073, 3.125, 0.216>
		<1.088, 3.041, 0.237> <1.051, 3.089, 0.307> <1.051, 3.089, 0.307> <1.037, 3.173, 0.286>
		<0.870, 3.079, 0.250> <0.879, 3.043, 0.251> <0.896, 3.004, 0.244> <0.910, 2.973, 0.227>
		<0.788, 3.058, 0.228> <0.797, 3.022, 0.228> <0.813, 2.973, 0.219> <0.826, 2.942, 0.202>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.073, 3.125, 0.216> <1.088, 3.041, 0.237> <0.870, 3.079, 0.250> <0.788, 3.058, 0.228>
		<1.035, 3.176, 0.291> <1.049, 3.092, 0.312> <0.861, 3.115, 0.249> <0.778, 3.095, 0.227>
		<0.869, 3.239, 0.159> <0.861, 3.237, 0.184> <0.767, 3.168, 0.203> <0.769, 3.145, 0.216>
		<0.776, 3.231, 0.129> <0.768, 3.229, 0.154> <0.765, 3.201, 0.185> <0.767, 3.178, 0.197>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.073, 3.125, 0.216> <1.073, 3.125, 0.216> <1.073, 3.125, 0.216> <1.073, 3.125, 0.216>
		<1.058, 3.215, 0.193> <1.072, 3.130, 0.214> <1.072, 3.130, 0.214> <1.088, 3.041, 0.237>
		<0.856, 3.190, 0.223> <0.858, 3.157, 0.241> <0.861, 3.115, 0.249> <0.870, 3.079, 0.250>
		<0.767, 3.178, 0.197> <0.769, 3.145, 0.216> <0.778, 3.095, 0.227> <0.788, 3.058, 0.228>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.073, 3.125, 0.216> <1.058, 3.215, 0.193> <0.856, 3.190, 0.223> <0.767, 3.178, 0.197>
		<1.110, 3.078, 0.145> <1.094, 3.167, 0.122> <0.854, 3.212, 0.210> <0.765, 3.201, 0.185>
		<0.897, 3.198, 0.095> <0.887, 3.219, 0.107> <0.776, 3.231, 0.129> <0.768, 3.229, 0.154>
		<0.810, 3.186, 0.063> <0.801, 3.207, 0.075> <0.784, 3.232, 0.105> <0.776, 3.231, 0.129>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.073, 3.125, 0.216> <1.073, 3.125, 0.216> <1.073, 3.125, 0.216> <1.073, 3.125, 0.216>
		<1.035, 3.176, 0.291> <1.019, 3.265, 0.268> <1.019, 3.265, 0.268> <1.058, 3.215, 0.193>
		<0.869, 3.239, 0.159> <0.861, 3.237, 0.184> <0.854, 3.212, 0.210> <0.856, 3.190, 0.223>
		<0.776, 3.231, 0.129> <0.768, 3.229, 0.154> <0.765, 3.201, 0.185> <0.767, 3.178, 0.197>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.073, 3.125, 0.216> <1.035, 3.176, 0.291> <0.869, 3.239, 0.159> <0.776, 3.231, 0.129>
		<1.059, 3.209, 0.195> <1.020, 3.259, 0.270> <0.877, 3.241, 0.135> <0.784, 3.232, 0.105>
		<0.928, 3.090, 0.069> <0.919, 3.127, 0.068> <0.814, 3.177, 0.058> <0.801, 3.207, 0.075>
		<0.849, 3.070, 0.038> <0.840, 3.107, 0.037> <0.824, 3.156, 0.046> <0.810, 3.186, 0.063>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.073, 3.125, 0.216> <1.073, 3.125, 0.216> <1.073, 3.125, 0.216> <1.073, 3.125, 0.216>
		<1.110, 3.078, 0.145> <1.071, 3.128, 0.220> <1.071, 3.128, 0.220> <1.035, 3.176, 0.291>
		<0.897, 3.198, 0.095> <0.887, 3.219, 0.107> <0.877, 3.241, 0.135> <0.869, 3.239, 0.159>
		<0.810, 3.186, 0.063> <0.801, 3.207, 0.075> <0.784, 3.232, 0.105> <0.776, 3.231, 0.129>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.073, 3.125, 0.216> <1.110, 3.078, 0.145> <0.897, 3.198, 0.095> <0.810, 3.186, 0.063>
		<1.088, 3.038, 0.238> <1.125, 2.990, 0.167> <0.910, 3.168, 0.078> <0.824, 3.156, 0.046>
		<0.951, 2.981, 0.099> <0.948, 3.014, 0.080> <0.849, 3.070, 0.038> <0.840, 3.107, 0.037>
		<0.870, 2.951, 0.068> <0.868, 2.983, 0.049> <0.858, 3.034, 0.038> <0.849, 3.070, 0.038>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.073, 3.125, 0.216> <1.073, 3.125, 0.216> <1.073, 3.125, 0.216> <1.073, 3.125, 0.216>
		<1.059, 3.209, 0.195> <1.095, 3.161, 0.124> <1.095, 3.161, 0.124> <1.110, 3.078, 0.145>
		<0.928, 3.090, 0.069> <0.919, 3.127, 0.068> <0.910, 3.168, 0.078> <0.897, 3.198, 0.095>
		<0.849, 3.070, 0.038> <0.840, 3.107, 0.037> <0.824, 3.156, 0.046> <0.810, 3.186, 0.063>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.073, 3.125, 0.216> <1.073, 3.125, 0.216> <1.073, 3.125, 0.216> <1.073, 3.125, 0.216>
		<1.059, 3.209, 0.195> <1.074, 3.121, 0.217> <1.074, 3.121, 0.217> <1.088, 3.038, 0.238>
		<0.928, 3.090, 0.069> <0.937, 3.054, 0.070> <0.948, 3.014, 0.080> <0.951, 2.981, 0.099>
		<0.849, 3.070, 0.038> <0.858, 3.034, 0.038> <0.868, 2.983, 0.049> <0.870, 2.951, 0.068>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.860, 2.898, 0.136> <0.868, 2.899, 0.111> <0.871, 2.928, 0.080> <0.870, 2.951, 0.068>
		<0.754, 2.852, 0.099> <0.762, 2.854, 0.074> <0.765, 2.888, 0.039> <0.763, 2.911, 0.026>
		<0.583, 2.916, 0.047> <0.586, 2.917, 0.036> <0.594, 2.920, 0.013> <0.592, 2.932, 0.009>
		<0.477, 2.869, 0.010> <0.481, 2.870, -0.001> <0.479, 2.889, -0.011> <0.477, 2.900, -0.015>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.860, 2.898, 0.136> <0.754, 2.852, 0.099> <0.583, 2.916, 0.047> <0.477, 2.869, 0.010>
		<0.852, 2.896, 0.160> <0.746, 2.851, 0.124> <0.579, 2.915, 0.058> <0.473, 2.869, 0.021>
		<0.836, 2.921, 0.190> <0.726, 2.881, 0.157> <0.571, 2.919, 0.081> <0.466, 2.887, 0.030>
		<0.826, 2.942, 0.202> <0.717, 2.902, 0.169> <0.567, 2.930, 0.085> <0.462, 2.897, 0.034>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.355, 2.674, -0.042> <0.392, 2.733, -0.026> <0.415, 2.842, -0.012> <0.477, 2.869, 0.010>
		<0.338, 2.692, -0.075> <0.375, 2.751, -0.060> <0.419, 2.843, -0.023> <0.481, 2.870, -0.001>
		<0.362, 2.771, -0.040> <0.397, 2.797, -0.033> <0.438, 2.878, -0.020> <0.479, 2.889, -0.011>
		<0.363, 2.812, -0.039> <0.398, 2.839, -0.032> <0.436, 2.889, -0.024> <0.477, 2.900, -0.015>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.355, 2.674, -0.042> <0.371, 2.658, -0.010> <0.376, 2.762, -0.022> <0.374, 2.801, -0.018>
		<0.392, 2.733, -0.026> <0.408, 2.716, 0.005> <0.402, 2.791, -0.007> <0.400, 2.830, -0.003>
		<0.415, 2.842, -0.012> <0.412, 2.841, -0.000> <0.429, 2.875, 0.012> <0.425, 2.886, 0.016>
		<0.477, 2.869, 0.010> <0.473, 2.869, 0.021> <0.466, 2.887, 0.030> <0.462, 2.897, 0.034>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.374, 2.801, -0.018> <0.372, 2.840, -0.015> <0.351, 2.889, -0.017> <0.341, 2.927, -0.017>
		<0.400, 2.830, -0.003> <0.398, 2.869, 0.001> <0.380, 2.901, 0.001> <0.371, 2.939, 0.001>
		<0.425, 2.886, 0.016> <0.418, 2.906, 0.023> <0.415, 2.937, 0.026> <0.409, 2.958, 0.025>
		<0.462, 2.897, 0.034> <0.454, 2.917, 0.040> <0.446, 2.946, 0.043> <0.441, 2.967, 0.042>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.341, 2.927, -0.017> <0.331, 2.968, -0.018> <0.325, 3.027, -0.018> <0.307, 3.066, -0.024>
		<0.371, 2.939, 0.001> <0.360, 2.981, -0.000> <0.360, 3.019, -0.002> <0.343, 3.058, -0.007>
		<0.409, 2.958, 0.025> <0.404, 2.979, 0.025> <0.394, 3.009, 0.021> <0.391, 3.030, 0.014>
		<0.441, 2.967, 0.042> <0.435, 2.989, 0.042> <0.429, 3.018, 0.038> <0.426, 3.038, 0.031>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.307, 3.066, -0.024> <0.290, 3.105, -0.029> <0.214, 3.178, -0.011> <0.227, 3.181, -0.051>
		<0.343, 3.058, -0.007> <0.325, 3.097, -0.012> <0.274, 3.145, 0.007> <0.287, 3.147, -0.034>
		<0.391, 3.030, 0.014> <0.389, 3.041, 0.010> <0.356, 3.062, -0.005> <0.360, 3.063, -0.016>
		<0.426, 3.038, 0.031> <0.424, 3.050, 0.027> <0.423, 3.069, 0.017> <0.426, 3.069, 0.006>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.227, 3.181, -0.051> <0.240, 3.183, -0.092> <0.292, 3.105, -0.042> <0.312, 3.067, -0.040>
		<0.287, 3.147, -0.034> <0.300, 3.150, -0.075> <0.331, 3.097, -0.035> <0.351, 3.059, -0.033>
		<0.360, 3.063, -0.016> <0.363, 3.064, -0.027> <0.400, 3.043, -0.022> <0.403, 3.032, -0.025>
		<0.426, 3.069, 0.006> <0.430, 3.070, -0.005> <0.438, 3.052, -0.014> <0.442, 3.042, -0.018>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.312, 3.067, -0.040> <0.333, 3.029, -0.038> <0.353, 2.974, -0.036> <0.361, 2.931, -0.036>
		<0.351, 3.059, -0.033> <0.372, 3.021, -0.031> <0.383, 2.986, -0.033> <0.392, 2.943, -0.033>
		<0.403, 3.032, -0.025> <0.411, 3.013, -0.032> <0.426, 2.984, -0.031> <0.432, 2.963, -0.031>
		<0.442, 3.042, -0.018> <0.449, 3.022, -0.024> <0.457, 2.993, -0.027> <0.463, 2.971, -0.026>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.361, 2.931, -0.036> <0.368, 2.896, -0.036> <0.364, 2.848, -0.039> <0.363, 2.812, -0.039>
		<0.392, 2.943, -0.033> <0.399, 2.908, -0.033> <0.398, 2.874, -0.031> <0.398, 2.839, -0.032>
		<0.432, 2.963, -0.031> <0.437, 2.941, -0.031> <0.433, 2.910, -0.031> <0.436, 2.889, -0.024>
		<0.463, 2.971, -0.026> <0.468, 2.950, -0.026> <0.475, 2.921, -0.022> <0.477, 2.900, -0.015>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.462, 2.897, 0.034> <0.454, 2.917, 0.040> <0.446, 2.946, 0.043> <0.441, 2.967, 0.042>
		<0.567, 2.930, 0.085> <0.559, 2.950, 0.091> <0.549, 2.976, 0.099> <0.543, 2.998, 0.099>
		<0.717, 2.902, 0.169> <0.703, 2.932, 0.187> <0.683, 2.994, 0.197> <0.674, 3.030, 0.196>
		<0.826, 2.942, 0.202> <0.813, 2.973, 0.219> <0.797, 3.022, 0.228> <0.788, 3.058, 0.228>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.441, 2.967, 0.042> <0.435, 2.989, 0.042> <0.429, 3.018, 0.038> <0.426, 3.038, 0.031>
		<0.543, 2.998, 0.099> <0.538, 3.019, 0.098> <0.536, 3.044, 0.090> <0.533, 3.064, 0.082>
		<0.674, 3.030, 0.196> <0.665, 3.066, 0.196> <0.653, 3.130, 0.183> <0.651, 3.162, 0.164>
		<0.788, 3.058, 0.228> <0.778, 3.095, 0.227> <0.769, 3.145, 0.216> <0.767, 3.178, 0.197>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.426, 3.038, 0.031> <0.424, 3.050, 0.027> <0.423, 3.069, 0.017> <0.426, 3.069, 0.006>
		<0.533, 3.064, 0.082> <0.531, 3.076, 0.078> <0.538, 3.079, 0.055> <0.541, 3.080, 0.044>
		<0.651, 3.162, 0.164> <0.650, 3.185, 0.152> <0.653, 3.219, 0.117> <0.661, 3.221, 0.092>
		<0.767, 3.178, 0.197> <0.765, 3.201, 0.185> <0.768, 3.229, 0.154> <0.776, 3.231, 0.129>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.426, 3.069, 0.006> <0.430, 3.070, -0.005> <0.438, 3.052, -0.014> <0.442, 3.042, -0.018>
		<0.541, 3.080, 0.044> <0.545, 3.080, 0.033> <0.553, 3.080, 0.010> <0.557, 3.069, 0.006>
		<0.661, 3.221, 0.092> <0.669, 3.222, 0.067> <0.688, 3.192, 0.033> <0.697, 3.171, 0.021>
		<0.776, 3.231, 0.129> <0.784, 3.232, 0.105> <0.801, 3.207, 0.075> <0.810, 3.186, 0.063>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.442, 3.042, -0.018> <0.449, 3.022, -0.024> <0.457, 2.993, -0.027> <0.463, 2.971, -0.026>
		<0.557, 3.069, 0.006> <0.565, 3.049, -0.000> <0.573, 3.026, -0.009> <0.578, 3.004, -0.009>
		<0.697, 3.171, 0.021> <0.711, 3.141, 0.004> <0.730, 3.079, -0.007> <0.739, 3.043, -0.006>
		<0.810, 3.186, 0.063> <0.824, 3.156, 0.046> <0.840, 3.107, 0.037> <0.849, 3.070, 0.038>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.463, 2.971, -0.026> <0.468, 2.950, -0.026> <0.475, 2.921, -0.022> <0.477, 2.900, -0.015>
		<0.578, 3.004, -0.009> <0.583, 2.983, -0.008> <0.589, 2.952, 0.002> <0.592, 2.932, 0.009>
		<0.739, 3.043, -0.006> <0.749, 3.006, -0.005> <0.761, 2.943, 0.008> <0.763, 2.911, 0.026>
		<0.849, 3.070, 0.038> <0.858, 3.034, 0.038> <0.868, 2.983, 0.049> <0.870, 2.951, 0.068>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.496, 3.161, 0.034> <0.496, 3.161, 0.034> <0.496, 3.161, 0.034> <0.496, 3.161, 0.034>
		<0.538, 3.116, 0.045> <0.623, 3.151, 0.075> <0.623, 3.151, 0.075> <0.580, 3.195, 0.064>
		<0.623, 3.073, 0.070> <0.599, 3.162, 0.068> <0.644, 3.205, 0.085> <0.687, 3.284, 0.104>
		<0.636, 3.013, 0.071> <0.613, 3.101, 0.069> <0.735, 3.197, 0.114> <0.778, 3.276, 0.133>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.952, 3.120, 0.179> <0.972, 3.047, 0.181> <0.939, 2.926, 0.163> <0.882, 2.881, 0.142>
		<0.934, 3.189, 0.178> <0.953, 3.116, 0.180> <0.866, 2.965, 0.142> <0.809, 2.920, 0.121>
		<0.846, 3.270, 0.154> <0.803, 3.191, 0.136> <0.635, 3.018, 0.071> <0.659, 2.929, 0.073>
		<0.778, 3.276, 0.133> <0.735, 3.197, 0.114> <0.613, 3.101, 0.069> <0.636, 3.013, 0.071>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.572, 2.821, 0.038> <0.572, 2.821, 0.038> <0.572, 2.821, 0.038> <0.572, 2.821, 0.038>
		<0.665, 2.839, 0.069> <0.684, 2.896, 0.079> <0.684, 2.896, 0.079> <0.591, 2.878, 0.048>
		<0.807, 2.821, 0.114> <0.733, 2.861, 0.092> <0.672, 2.869, 0.073> <0.650, 2.952, 0.071>
		<0.882, 2.881, 0.142> <0.809, 2.920, 0.121> <0.659, 2.929, 0.073> <0.636, 3.013, 0.071>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.041, 1.798, -0.341> <1.034, 1.868, -0.358> <0.876, 1.792, -0.393> <0.805, 1.788, -0.385>
		<1.034, 1.752, -0.406> <1.027, 1.822, -0.422> <0.878, 1.761, -0.393> <0.807, 1.757, -0.385>
		<0.903, 1.663, -0.317> <0.900, 1.663, -0.338> <0.813, 1.696, -0.366> <0.810, 1.715, -0.377>
		<0.826, 1.647, -0.305> <0.823, 1.647, -0.326> <0.817, 1.670, -0.351> <0.814, 1.688, -0.362>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.041, 1.798, -0.341> <1.041, 1.798, -0.341> <1.041, 1.798, -0.341> <1.041, 1.798, -0.341>
		<1.048, 1.724, -0.325> <1.041, 1.678, -0.389> <1.041, 1.678, -0.389> <1.034, 1.752, -0.406>
		<0.889, 1.700, -0.371> <0.892, 1.682, -0.361> <0.900, 1.663, -0.338> <0.903, 1.663, -0.317>
		<0.814, 1.688, -0.362> <0.817, 1.670, -0.351> <0.823, 1.647, -0.326> <0.826, 1.647, -0.305>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.041, 1.798, -0.341> <1.034, 1.752, -0.406> <0.903, 1.663, -0.317> <0.826, 1.647, -0.305>
		<1.048, 1.727, -0.325> <1.041, 1.681, -0.390> <0.906, 1.663, -0.296> <0.830, 1.647, -0.283>
		<0.902, 1.792, -0.237> <0.904, 1.761, -0.238> <0.833, 1.696, -0.242> <0.832, 1.670, -0.257>
		<0.831, 1.788, -0.222> <0.833, 1.757, -0.222> <0.834, 1.715, -0.231> <0.833, 1.688, -0.247>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.041, 1.798, -0.341> <1.041, 1.798, -0.341> <1.041, 1.798, -0.341> <1.041, 1.798, -0.341>
		<1.048, 1.842, -0.280> <1.041, 1.796, -0.344> <1.041, 1.796, -0.344> <1.034, 1.752, -0.406>
		<0.907, 1.700, -0.262> <0.906, 1.682, -0.272> <0.906, 1.663, -0.296> <0.903, 1.663, -0.317>
		<0.833, 1.688, -0.247> <0.832, 1.670, -0.257> <0.830, 1.647, -0.283> <0.826, 1.647, -0.305>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.041, 1.798, -0.341> <1.048, 1.842, -0.280> <0.907, 1.700, -0.262> <0.833, 1.688, -0.247>
		<1.048, 1.724, -0.325> <1.056, 1.768, -0.263> <0.906, 1.682, -0.272> <0.832, 1.670, -0.257>
		<0.889, 1.700, -0.371> <0.892, 1.682, -0.361> <0.826, 1.647, -0.305> <0.830, 1.647, -0.283>
		<0.814, 1.688, -0.362> <0.817, 1.670, -0.351> <0.823, 1.647, -0.326> <0.826, 1.647, -0.305>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.041, 1.798, -0.341> <1.048, 1.842, -0.280> <0.907, 1.700, -0.262> <0.833, 1.688, -0.247>
		<1.034, 1.873, -0.359> <1.041, 1.917, -0.297> <0.907, 1.727, -0.246> <0.834, 1.715, -0.231>
		<0.897, 1.884, -0.260> <0.901, 1.857, -0.245> <0.831, 1.788, -0.222> <0.833, 1.757, -0.222>
		<0.821, 1.888, -0.245> <0.825, 1.862, -0.230> <0.829, 1.819, -0.221> <0.831, 1.788, -0.222>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.041, 1.798, -0.341> <1.041, 1.798, -0.341> <1.041, 1.798, -0.341> <1.041, 1.798, -0.341>
		<1.048, 1.727, -0.325> <1.055, 1.771, -0.264> <1.055, 1.771, -0.264> <1.048, 1.842, -0.280>
		<0.902, 1.792, -0.237> <0.904, 1.761, -0.238> <0.907, 1.727, -0.246> <0.907, 1.700, -0.262>
		<0.831, 1.788, -0.222> <0.833, 1.757, -0.222> <0.834, 1.715, -0.231> <0.833, 1.688, -0.247>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.041, 1.798, -0.341> <1.048, 1.727, -0.325> <0.902, 1.792, -0.237> <0.831, 1.788, -0.222>
		<1.049, 1.845, -0.276> <1.056, 1.774, -0.260> <0.900, 1.823, -0.237> <0.829, 1.819, -0.221>
		<0.889, 1.922, -0.315> <0.892, 1.922, -0.294> <0.822, 1.880, -0.240> <0.825, 1.862, -0.230>
		<0.809, 1.930, -0.302> <0.813, 1.930, -0.281> <0.818, 1.907, -0.255> <0.821, 1.888, -0.245>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.041, 1.798, -0.341> <1.041, 1.798, -0.341> <1.041, 1.798, -0.341> <1.041, 1.798, -0.341>
		<1.034, 1.873, -0.359> <1.041, 1.802, -0.342> <1.041, 1.802, -0.342> <1.048, 1.727, -0.325>
		<0.897, 1.884, -0.260> <0.901, 1.857, -0.245> <0.900, 1.823, -0.237> <0.902, 1.792, -0.237>
		<0.821, 1.888, -0.245> <0.825, 1.862, -0.230> <0.829, 1.819, -0.221> <0.831, 1.788, -0.222>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.041, 1.798, -0.341> <1.034, 1.873, -0.359> <0.897, 1.884, -0.260> <0.821, 1.888, -0.245>
		<1.034, 1.753, -0.404> <1.027, 1.828, -0.421> <0.894, 1.903, -0.271> <0.818, 1.907, -0.255>
		<0.879, 1.884, -0.370> <0.879, 1.903, -0.359> <0.809, 1.930, -0.302> <0.813, 1.930, -0.281>
		<0.803, 1.888, -0.360> <0.803, 1.907, -0.349> <0.806, 1.930, -0.323> <0.809, 1.930, -0.302>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.041, 1.798, -0.341> <1.041, 1.798, -0.341> <1.041, 1.798, -0.341> <1.041, 1.798, -0.341>
		<1.049, 1.845, -0.276> <1.042, 1.919, -0.293> <1.042, 1.919, -0.293> <1.034, 1.873, -0.359>
		<0.889, 1.922, -0.315> <0.892, 1.922, -0.294> <0.894, 1.903, -0.271> <0.897, 1.884, -0.260>
		<0.809, 1.930, -0.302> <0.813, 1.930, -0.281> <0.818, 1.907, -0.255> <0.821, 1.888, -0.245>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.041, 1.798, -0.341> <1.049, 1.845, -0.276> <0.889, 1.922, -0.315> <0.809, 1.930, -0.302>
		<1.034, 1.868, -0.358> <1.042, 1.915, -0.292> <0.885, 1.922, -0.336> <0.806, 1.930, -0.323>
		<0.876, 1.792, -0.393> <0.875, 1.823, -0.392> <0.802, 1.880, -0.365> <0.803, 1.907, -0.349>
		<0.805, 1.788, -0.385> <0.803, 1.819, -0.384> <0.802, 1.862, -0.376> <0.803, 1.888, -0.360>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.041, 1.798, -0.341> <1.041, 1.798, -0.341> <1.041, 1.798, -0.341> <1.041, 1.798, -0.341>
		<1.034, 1.753, -0.404> <1.042, 1.800, -0.338> <1.042, 1.800, -0.338> <1.049, 1.845, -0.276>
		<0.879, 1.884, -0.370> <0.879, 1.903, -0.359> <0.885, 1.922, -0.336> <0.889, 1.922, -0.315>
		<0.803, 1.888, -0.360> <0.803, 1.907, -0.349> <0.806, 1.930, -0.323> <0.809, 1.930, -0.302>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.041, 1.798, -0.341> <1.034, 1.753, -0.404> <0.879, 1.884, -0.370> <0.803, 1.888, -0.360>
		<1.048, 1.724, -0.325> <1.041, 1.680, -0.387> <0.878, 1.857, -0.385> <0.802, 1.862, -0.376>
		<0.889, 1.700, -0.371> <0.885, 1.727, -0.386> <0.805, 1.788, -0.385> <0.803, 1.819, -0.384>
		<0.814, 1.688, -0.362> <0.810, 1.715, -0.377> <0.807, 1.757, -0.385> <0.805, 1.788, -0.385>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.041, 1.798, -0.341> <1.041, 1.798, -0.341> <1.041, 1.798, -0.341> <1.041, 1.798, -0.341>
		<1.034, 1.868, -0.358> <1.027, 1.823, -0.420> <1.027, 1.823, -0.420> <1.034, 1.753, -0.404>
		<0.876, 1.792, -0.393> <0.875, 1.823, -0.392> <0.878, 1.857, -0.385> <0.879, 1.884, -0.370>
		<0.805, 1.788, -0.385> <0.803, 1.819, -0.384> <0.802, 1.862, -0.376> <0.803, 1.888, -0.360>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.041, 1.798, -0.341> <1.041, 1.798, -0.341> <1.041, 1.798, -0.341> <1.041, 1.798, -0.341>
		<1.034, 1.868, -0.358> <1.042, 1.794, -0.341> <1.042, 1.794, -0.341> <1.048, 1.724, -0.325>
		<0.876, 1.792, -0.393> <0.878, 1.761, -0.393> <0.885, 1.727, -0.386> <0.889, 1.700, -0.371>
		<0.805, 1.788, -0.385> <0.807, 1.757, -0.385> <0.810, 1.715, -0.377> <0.814, 1.688, -0.362>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.826, 1.647, -0.305> <0.823, 1.647, -0.326> <0.817, 1.670, -0.351> <0.814, 1.688, -0.362>
		<0.729, 1.626, -0.289> <0.726, 1.626, -0.310> <0.719, 1.654, -0.339> <0.716, 1.672, -0.350>
		<0.595, 1.705, -0.268> <0.594, 1.705, -0.277> <0.591, 1.707, -0.297> <0.590, 1.716, -0.300>
		<0.499, 1.684, -0.252> <0.497, 1.684, -0.262> <0.495, 1.699, -0.270> <0.494, 1.709, -0.273>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.826, 1.647, -0.305> <0.729, 1.626, -0.289> <0.595, 1.705, -0.268> <0.499, 1.684, -0.252>
		<0.830, 1.647, -0.283> <0.733, 1.626, -0.267> <0.597, 1.705, -0.258> <0.500, 1.684, -0.242>
		<0.832, 1.670, -0.257> <0.736, 1.654, -0.238> <0.600, 1.709, -0.238> <0.501, 1.699, -0.234>
		<0.833, 1.688, -0.247> <0.736, 1.672, -0.227> <0.600, 1.719, -0.235> <0.500, 1.709, -0.231>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.364, 1.545, -0.230> <0.404, 1.586, -0.237> <0.442, 1.671, -0.243> <0.499, 1.684, -0.252>
		<0.342, 1.562, -0.250> <0.382, 1.603, -0.256> <0.441, 1.671, -0.253> <0.497, 1.684, -0.262>
		<0.383, 1.622, -0.239> <0.414, 1.638, -0.248> <0.460, 1.697, -0.260> <0.495, 1.699, -0.270>
		<0.390, 1.655, -0.242> <0.421, 1.671, -0.251> <0.459, 1.706, -0.263> <0.494, 1.709, -0.273>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.364, 1.545, -0.230> <0.385, 1.529, -0.212> <0.399, 1.613, -0.230> <0.404, 1.644, -0.230>
		<0.404, 1.586, -0.237> <0.426, 1.570, -0.219> <0.428, 1.632, -0.231> <0.433, 1.664, -0.230>
		<0.442, 1.671, -0.243> <0.444, 1.671, -0.233> <0.466, 1.696, -0.233> <0.466, 1.705, -0.230>
		<0.499, 1.684, -0.252> <0.500, 1.684, -0.242> <0.501, 1.699, -0.234> <0.500, 1.709, -0.231>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.404, 1.644, -0.230> <0.409, 1.676, -0.229> <0.400, 1.719, -0.226> <0.398, 1.751, -0.226>
		<0.433, 1.664, -0.230> <0.438, 1.695, -0.229> <0.430, 1.725, -0.225> <0.428, 1.757, -0.225>
		<0.466, 1.705, -0.230> <0.466, 1.722, -0.224> <0.469, 1.748, -0.222> <0.468, 1.766, -0.222>
		<0.500, 1.709, -0.231> <0.500, 1.726, -0.225> <0.499, 1.750, -0.222> <0.498, 1.769, -0.222>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.398, 1.751, -0.226> <0.396, 1.787, -0.225> <0.400, 1.835, -0.227> <0.391, 1.870, -0.228>
		<0.428, 1.757, -0.225> <0.426, 1.792, -0.224> <0.431, 1.823, -0.228> <0.422, 1.857, -0.228>
		<0.468, 1.766, -0.222> <0.467, 1.784, -0.222> <0.462, 1.810, -0.223> <0.460, 1.827, -0.229>
		<0.498, 1.769, -0.222> <0.497, 1.787, -0.222> <0.495, 1.812, -0.224> <0.493, 1.829, -0.230>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.391, 1.870, -0.228> <0.382, 1.904, -0.228> <0.344, 1.975, -0.191> <0.339, 1.975, -0.226>
		<0.422, 1.857, -0.228> <0.413, 1.892, -0.228> <0.389, 1.939, -0.199> <0.384, 1.939, -0.234>
		<0.460, 1.827, -0.229> <0.459, 1.836, -0.232> <0.433, 1.859, -0.232> <0.431, 1.859, -0.241>
		<0.493, 1.829, -0.230> <0.492, 1.838, -0.233> <0.490, 1.854, -0.241> <0.489, 1.854, -0.250>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.339, 1.975, -0.226> <0.333, 1.975, -0.261> <0.378, 1.903, -0.238> <0.389, 1.870, -0.242>
		<0.384, 1.939, -0.234> <0.378, 1.939, -0.269> <0.408, 1.891, -0.247> <0.418, 1.857, -0.251>
		<0.431, 1.859, -0.241> <0.430, 1.859, -0.251> <0.455, 1.836, -0.259> <0.455, 1.827, -0.262>
		<0.489, 1.854, -0.250> <0.487, 1.854, -0.260> <0.487, 1.838, -0.268> <0.487, 1.829, -0.272>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.389, 1.870, -0.242> <0.399, 1.836, -0.245> <0.406, 1.788, -0.247> <0.406, 1.752, -0.247>
		<0.418, 1.857, -0.251> <0.428, 1.823, -0.254> <0.431, 1.793, -0.257> <0.431, 1.757, -0.257>
		<0.455, 1.827, -0.262> <0.455, 1.810, -0.269> <0.462, 1.785, -0.272> <0.463, 1.766, -0.272>
		<0.487, 1.829, -0.272> <0.487, 1.812, -0.278> <0.488, 1.787, -0.281> <0.489, 1.769, -0.281>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.406, 1.752, -0.247> <0.407, 1.723, -0.247> <0.396, 1.684, -0.244> <0.390, 1.655, -0.242>
		<0.431, 1.757, -0.257> <0.431, 1.728, -0.257> <0.427, 1.700, -0.253> <0.421, 1.671, -0.251>
		<0.463, 1.766, -0.272> <0.464, 1.748, -0.272> <0.457, 1.723, -0.269> <0.459, 1.706, -0.263>
		<0.489, 1.769, -0.281> <0.490, 1.750, -0.281> <0.492, 1.726, -0.278> <0.494, 1.709, -0.273>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.500, 1.709, -0.231> <0.500, 1.726, -0.225> <0.499, 1.750, -0.222> <0.498, 1.769, -0.222>
		<0.600, 1.719, -0.235> <0.600, 1.736, -0.229> <0.599, 1.759, -0.221> <0.598, 1.777, -0.221>
		<0.736, 1.672, -0.227> <0.737, 1.699, -0.211> <0.735, 1.752, -0.201> <0.733, 1.783, -0.200>
		<0.833, 1.688, -0.247> <0.834, 1.715, -0.231> <0.833, 1.757, -0.222> <0.831, 1.788, -0.222>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.498, 1.769, -0.222> <0.497, 1.787, -0.222> <0.495, 1.812, -0.224> <0.493, 1.829, -0.230>
		<0.598, 1.777, -0.221> <0.597, 1.795, -0.221> <0.595, 1.816, -0.228> <0.593, 1.833, -0.234>
		<0.733, 1.783, -0.200> <0.732, 1.814, -0.200> <0.727, 1.867, -0.210> <0.723, 1.894, -0.225>
		<0.831, 1.788, -0.222> <0.829, 1.819, -0.221> <0.825, 1.862, -0.230> <0.821, 1.888, -0.245>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.493, 1.829, -0.230> <0.492, 1.838, -0.233> <0.490, 1.854, -0.241> <0.489, 1.854, -0.250>
		<0.593, 1.833, -0.234> <0.592, 1.842, -0.237> <0.589, 1.844, -0.257> <0.587, 1.844, -0.266>
		<0.723, 1.894, -0.225> <0.720, 1.912, -0.235> <0.715, 1.940, -0.265> <0.711, 1.940, -0.286>
		<0.821, 1.888, -0.245> <0.818, 1.907, -0.255> <0.813, 1.930, -0.281> <0.809, 1.930, -0.302>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.489, 1.854, -0.250> <0.487, 1.854, -0.260> <0.487, 1.838, -0.268> <0.487, 1.829, -0.272>
		<0.587, 1.844, -0.266> <0.585, 1.844, -0.276> <0.583, 1.842, -0.296> <0.583, 1.833, -0.299>
		<0.711, 1.940, -0.286> <0.708, 1.940, -0.307> <0.704, 1.912, -0.337> <0.704, 1.894, -0.347>
		<0.809, 1.930, -0.302> <0.806, 1.930, -0.323> <0.803, 1.907, -0.349> <0.803, 1.888, -0.360>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.487, 1.829, -0.272> <0.487, 1.812, -0.278> <0.488, 1.787, -0.281> <0.489, 1.769, -0.281>
		<0.583, 1.833, -0.299> <0.583, 1.816, -0.305> <0.582, 1.795, -0.313> <0.583, 1.777, -0.313>
		<0.704, 1.894, -0.347> <0.703, 1.867, -0.363> <0.704, 1.814, -0.374> <0.706, 1.783, -0.374>
		<0.803, 1.888, -0.360> <0.802, 1.862, -0.376> <0.803, 1.819, -0.384> <0.805, 1.788, -0.385>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.489, 1.769, -0.281> <0.490, 1.750, -0.281> <0.492, 1.726, -0.278> <0.494, 1.709, -0.273>
		<0.583, 1.777, -0.313> <0.584, 1.759, -0.313> <0.588, 1.733, -0.306> <0.590, 1.716, -0.300>
		<0.706, 1.783, -0.374> <0.707, 1.752, -0.374> <0.712, 1.699, -0.365> <0.716, 1.672, -0.350>
		<0.805, 1.788, -0.385> <0.807, 1.757, -0.385> <0.810, 1.715, -0.377> <0.814, 1.688, -0.362>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.562, 1.917, -0.262> <0.562, 1.917, -0.262> <0.562, 1.917, -0.262> <0.562, 1.917, -0.262>
		<0.590, 1.874, -0.267> <0.667, 1.889, -0.279> <0.667, 1.889, -0.279> <0.639, 1.931, -0.274>
		<0.655, 1.826, -0.277> <0.649, 1.901, -0.276> <0.694, 1.929, -0.283> <0.743, 1.987, -0.291>
		<0.656, 1.775, -0.277> <0.651, 1.850, -0.276> <0.770, 1.908, -0.295> <0.818, 1.966, -0.303>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.940, 1.813, -0.323> <0.944, 1.750, -0.323> <0.897, 1.657, -0.316> <0.842, 1.629, -0.307>
		<0.936, 1.872, -0.322> <0.940, 1.809, -0.323> <0.842, 1.701, -0.307> <0.786, 1.673, -0.298>
		<0.874, 1.950, -0.312> <0.826, 1.893, -0.304> <0.656, 1.779, -0.277> <0.661, 1.704, -0.278>
		<0.818, 1.966, -0.303> <0.770, 1.908, -0.295> <0.651, 1.850, -0.276> <0.656, 1.775, -0.277>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.571, 1.629, -0.264> <0.571, 1.629, -0.264> <0.571, 1.629, -0.264> <0.571, 1.629, -0.264>
		<0.652, 1.629, -0.277> <0.678, 1.673, -0.281> <0.678, 1.673, -0.281> <0.596, 1.673, -0.268>
		<0.769, 1.593, -0.295> <0.713, 1.637, -0.286> <0.663, 1.653, -0.278> <0.658, 1.724, -0.278>
		<0.842, 1.629, -0.307> <0.786, 1.673, -0.298> <0.661, 1.704, -0.278> <0.656, 1.775, -0.277>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.681, 1.990, -0.262> <-0.715, 2.068, -0.282> <-0.885, 1.942, -0.259> <-0.962, 1.922, -0.222>
		<-0.705, 1.940, -0.334> <-0.739, 2.018, -0.354> <-0.877, 1.913, -0.260> <-0.954, 1.893, -0.223>
		<-0.806, 1.831, -0.180> <-0.817, 1.829, -0.201> <-0.926, 1.837, -0.203> <-0.937, 1.854, -0.215>
		<-0.880, 1.801, -0.138> <-0.891, 1.798, -0.160> <-0.911, 1.815, -0.188> <-0.923, 1.832, -0.200>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.681, 1.990, -0.262> <-0.681, 1.990, -0.262> <-0.681, 1.990, -0.262> <-0.681, 1.990, -0.262>
		<-0.647, 1.911, -0.242> <-0.670, 1.861, -0.314> <-0.670, 1.861, -0.314> <-0.705, 1.940, -0.334>
		<-0.847, 1.860, -0.237> <-0.836, 1.842, -0.225> <-0.817, 1.829, -0.201> <-0.806, 1.831, -0.180>
		<-0.923, 1.832, -0.200> <-0.911, 1.815, -0.188> <-0.891, 1.798, -0.160> <-0.880, 1.801, -0.138>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.681, 1.990, -0.262> <-0.705, 1.940, -0.334> <-0.806, 1.831, -0.180> <-0.880, 1.801, -0.138>
		<-0.647, 1.912, -0.242> <-0.671, 1.862, -0.314> <-0.795, 1.834, -0.158> <-0.869, 1.803, -0.117>
		<-0.799, 1.960, -0.090> <-0.791, 1.931, -0.091> <-0.859, 1.851, -0.071> <-0.860, 1.825, -0.088>
		<-0.872, 1.941, -0.045> <-0.864, 1.912, -0.046> <-0.858, 1.871, -0.057> <-0.859, 1.846, -0.074>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.681, 1.990, -0.262> <-0.681, 1.990, -0.262> <-0.681, 1.990, -0.262> <-0.681, 1.990, -0.262>
		<-0.658, 2.040, -0.192> <-0.682, 1.990, -0.263> <-0.682, 1.990, -0.263> <-0.705, 1.940, -0.334>
		<-0.787, 1.872, -0.118> <-0.788, 1.852, -0.131> <-0.795, 1.834, -0.158> <-0.806, 1.831, -0.180>
		<-0.859, 1.846, -0.074> <-0.860, 1.825, -0.088> <-0.869, 1.803, -0.117> <-0.880, 1.801, -0.138>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.681, 1.990, -0.262> <-0.658, 2.040, -0.192> <-0.787, 1.872, -0.118> <-0.859, 1.846, -0.074>
		<-0.647, 1.911, -0.242> <-0.624, 1.961, -0.172> <-0.788, 1.852, -0.131> <-0.860, 1.825, -0.088>
		<-0.847, 1.860, -0.237> <-0.836, 1.842, -0.225> <-0.880, 1.801, -0.138> <-0.869, 1.803, -0.117>
		<-0.923, 1.832, -0.200> <-0.911, 1.815, -0.188> <-0.891, 1.798, -0.160> <-0.880, 1.801, -0.138>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.681, 1.990, -0.262> <-0.658, 2.040, -0.192> <-0.787, 1.872, -0.118> <-0.859, 1.846, -0.074>
		<-0.717, 2.072, -0.283> <-0.694, 2.121, -0.212> <-0.785, 1.898, -0.101> <-0.858, 1.871, -0.057>
		<-0.833, 2.043, -0.113> <-0.818, 2.021, -0.098> <-0.872, 1.941, -0.045> <-0.864, 1.912, -0.046>
		<-0.911, 2.031, -0.067> <-0.897, 2.009, -0.052> <-0.880, 1.970, -0.044> <-0.872, 1.941, -0.045>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.681, 1.990, -0.262> <-0.681, 1.990, -0.262> <-0.681, 1.990, -0.262> <-0.681, 1.990, -0.262>
		<-0.647, 1.912, -0.242> <-0.624, 1.961, -0.172> <-0.624, 1.961, -0.172> <-0.658, 2.040, -0.192>
		<-0.799, 1.960, -0.090> <-0.791, 1.931, -0.091> <-0.785, 1.898, -0.101> <-0.787, 1.872, -0.118>
		<-0.872, 1.941, -0.045> <-0.864, 1.912, -0.046> <-0.858, 1.871, -0.057> <-0.859, 1.846, -0.074>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.681, 1.990, -0.262> <-0.647, 1.912, -0.242> <-0.799, 1.960, -0.090> <-0.872, 1.941, -0.045>
		<-0.657, 2.042, -0.188> <-0.623, 1.964, -0.168> <-0.807, 1.989, -0.089> <-0.880, 1.970, -0.044>
		<-0.871, 2.072, -0.172> <-0.860, 2.075, -0.150> <-0.908, 2.027, -0.065> <-0.897, 2.009, -0.052>
		<-0.954, 2.063, -0.129> <-0.943, 2.065, -0.107> <-0.923, 2.048, -0.080> <-0.911, 2.031, -0.067>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.681, 1.990, -0.262> <-0.681, 1.990, -0.262> <-0.681, 1.990, -0.262> <-0.681, 1.990, -0.262>
		<-0.717, 2.072, -0.283> <-0.683, 1.993, -0.263> <-0.683, 1.993, -0.263> <-0.647, 1.912, -0.242>
		<-0.833, 2.043, -0.113> <-0.818, 2.021, -0.098> <-0.807, 1.989, -0.089> <-0.799, 1.960, -0.090>
		<-0.911, 2.031, -0.067> <-0.897, 2.009, -0.052> <-0.880, 1.970, -0.044> <-0.872, 1.941, -0.045>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.681, 1.990, -0.262> <-0.717, 2.072, -0.283> <-0.833, 2.043, -0.113> <-0.911, 2.031, -0.067>
		<-0.705, 1.940, -0.334> <-0.740, 2.021, -0.355> <-0.845, 2.061, -0.125> <-0.923, 2.048, -0.080>
		<-0.894, 2.030, -0.232> <-0.893, 2.051, -0.219> <-0.954, 2.063, -0.129> <-0.943, 2.065, -0.107>
		<-0.975, 2.018, -0.193> <-0.974, 2.038, -0.180> <-0.965, 2.060, -0.151> <-0.954, 2.063, -0.129>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.681, 1.990, -0.262> <-0.681, 1.990, -0.262> <-0.681, 1.990, -0.262> <-0.681, 1.990, -0.262>
		<-0.657, 2.042, -0.188> <-0.693, 2.124, -0.209> <-0.693, 2.124, -0.209> <-0.717, 2.072, -0.283>
		<-0.871, 2.072, -0.172> <-0.860, 2.075, -0.150> <-0.845, 2.061, -0.125> <-0.833, 2.043, -0.113>
		<-0.954, 2.063, -0.129> <-0.943, 2.065, -0.107> <-0.923, 2.048, -0.080> <-0.911, 2.031, -0.067>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.681, 1.990, -0.262> <-0.657, 2.042, -0.188> <-0.871, 2.072, -0.172> <-0.954, 2.063, -0.129>
		<-0.715, 2.068, -0.282> <-0.691, 2.120, -0.208> <-0.882, 2.070, -0.194> <-0.965, 2.060, -0.151>
		<-0.885, 1.942, -0.259> <-0.893, 1.971, -0.258> <-0.975, 2.013, -0.196> <-0.974, 2.038, -0.180>
		<-0.962, 1.922, -0.222> <-0.970, 1.951, -0.221> <-0.976, 1.992, -0.210> <-0.975, 2.018, -0.193>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.681, 1.990, -0.262> <-0.681, 1.990, -0.262> <-0.681, 1.990, -0.262> <-0.681, 1.990, -0.262>
		<-0.705, 1.940, -0.334> <-0.681, 1.992, -0.260> <-0.681, 1.992, -0.260> <-0.657, 2.042, -0.188>
		<-0.894, 2.030, -0.232> <-0.893, 2.051, -0.219> <-0.882, 2.070, -0.194> <-0.871, 2.072, -0.172>
		<-0.975, 2.018, -0.193> <-0.974, 2.038, -0.180> <-0.965, 2.060, -0.151> <-0.954, 2.063, -0.129>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.681, 1.990, -0.262> <-0.705, 1.940, -0.334> <-0.894, 2.030, -0.232> <-0.975, 2.018, -0.193>
		<-0.647, 1.911, -0.242> <-0.670, 1.861, -0.314> <-0.895, 2.005, -0.249> <-0.976, 1.992, -0.210>
		<-0.847, 1.860, -0.237> <-0.862, 1.881, -0.252> <-0.962, 1.922, -0.222> <-0.970, 1.951, -0.221>
		<-0.923, 1.832, -0.200> <-0.937, 1.854, -0.215> <-0.954, 1.893, -0.223> <-0.962, 1.922, -0.222>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.681, 1.990, -0.262> <-0.681, 1.990, -0.262> <-0.681, 1.990, -0.262> <-0.681, 1.990, -0.262>
		<-0.715, 2.068, -0.282> <-0.739, 2.018, -0.354> <-0.739, 2.018, -0.354> <-0.705, 1.940, -0.334>
		<-0.885, 1.942, -0.259> <-0.893, 1.971, -0.258> <-0.895, 2.005, -0.249> <-0.894, 2.030, -0.232>
		<-0.962, 1.922, -0.222> <-0.970, 1.951, -0.221> <-0.976, 1.992, -0.210> <-0.975, 2.018, -0.193>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.681, 1.990, -0.262> <-0.681, 1.990, -0.262> <-0.681, 1.990, -0.262> <-0.681, 1.990, -0.262>
		<-0.715, 2.068, -0.282> <-0.681, 1.989, -0.262> <-0.681, 1.989, -0.262> <-0.647, 1.911, -0.242>
		<-0.885, 1.942, -0.259> <-0.877, 1.913, -0.260> <-0.862, 1.881, -0.252> <-0.847, 1.860, -0.237>
		<-0.962, 1.922, -0.222> <-0.954, 1.893, -0.223> <-0.937, 1.854, -0.215> <-0.923, 1.832, -0.200>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.880, 1.801, -0.138> <-0.891, 1.798, -0.160> <-0.911, 1.815, -0.188> <-0.923, 1.832, -0.200>
		<-0.980, 1.760, -0.083> <-0.991, 1.757, -0.105> <-1.014, 1.778, -0.136> <-1.026, 1.795, -0.148>
		<-1.137, 1.804, -0.008> <-1.142, 1.803, -0.018> <-1.154, 1.801, -0.040> <-1.158, 1.810, -0.043>
		<-1.237, 1.762, 0.046> <-1.242, 1.761, 0.037> <-1.250, 1.774, 0.028> <-1.255, 1.783, 0.024>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.880, 1.801, -0.138> <-0.980, 1.760, -0.083> <-1.137, 1.804, -0.008> <-1.237, 1.762, 0.046>
		<-0.869, 1.803, -0.117> <-0.969, 1.762, -0.061> <-1.133, 1.805, 0.001> <-1.232, 1.763, 0.056>
		<-0.860, 1.825, -0.088> <-0.959, 1.789, -0.028> <-1.123, 1.811, 0.023> <-1.231, 1.778, 0.066>
		<-0.859, 1.846, -0.074> <-0.958, 1.809, -0.014> <-1.123, 1.820, 0.028> <-1.232, 1.788, 0.070>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.353, 1.602, 0.122> <-1.318, 1.650, 0.099> <-1.289, 1.740, 0.075> <-1.237, 1.762, 0.046>
		<-1.383, 1.609, 0.110> <-1.349, 1.657, 0.088> <-1.294, 1.739, 0.066> <-1.242, 1.761, 0.037>
		<-1.350, 1.678, 0.105> <-1.321, 1.699, 0.083> <-1.284, 1.764, 0.051> <-1.250, 1.774, 0.028>
		<-1.350, 1.710, 0.099> <-1.321, 1.732, 0.077> <-1.289, 1.773, 0.048> <-1.255, 1.783, 0.024>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.353, 1.602, 0.122> <-1.324, 1.594, 0.133> <-1.327, 1.673, 0.109> <-1.327, 1.705, 0.108>
		<-1.318, 1.650, 0.099> <-1.289, 1.642, 0.111> <-1.299, 1.697, 0.098> <-1.299, 1.730, 0.096>
		<-1.289, 1.740, 0.075> <-1.285, 1.741, 0.084> <-1.267, 1.767, 0.080> <-1.267, 1.777, 0.084>
		<-1.237, 1.762, 0.046> <-1.232, 1.763, 0.056> <-1.231, 1.778, 0.066> <-1.232, 1.788, 0.070>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.327, 1.705, 0.108> <-1.327, 1.736, 0.107> <-1.345, 1.774, 0.114> <-1.353, 1.804, 0.115>
		<-1.299, 1.730, 0.096> <-1.299, 1.760, 0.095> <-1.312, 1.786, 0.104> <-1.320, 1.816, 0.105>
		<-1.267, 1.777, 0.084> <-1.269, 1.793, 0.091> <-1.272, 1.818, 0.092> <-1.276, 1.834, 0.092>
		<-1.232, 1.788, 0.070> <-1.233, 1.804, 0.077> <-1.238, 1.827, 0.081> <-1.243, 1.844, 0.081>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.353, 1.804, 0.115> <-1.363, 1.837, 0.116> <-1.369, 1.883, 0.112> <-1.386, 1.913, 0.115>
		<-1.320, 1.816, 0.105> <-1.329, 1.849, 0.106> <-1.332, 1.879, 0.100> <-1.349, 1.909, 0.103>
		<-1.276, 1.834, 0.092> <-1.281, 1.851, 0.093> <-1.291, 1.875, 0.093> <-1.299, 1.890, 0.088>
		<-1.243, 1.844, 0.081> <-1.248, 1.861, 0.082> <-1.256, 1.884, 0.080> <-1.263, 1.899, 0.074>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.386, 1.913, 0.115> <-1.403, 1.944, 0.119> <-1.449, 2.003, 0.168> <-1.465, 2.000, 0.136>
		<-1.349, 1.909, 0.103> <-1.367, 1.940, 0.106> <-1.394, 1.979, 0.143> <-1.410, 1.976, 0.111>
		<-1.299, 1.890, 0.088> <-1.303, 1.899, 0.084> <-1.334, 1.913, 0.091> <-1.339, 1.912, 0.082>
		<-1.263, 1.899, 0.074> <-1.268, 1.907, 0.070> <-1.276, 1.920, 0.061> <-1.281, 1.919, 0.052>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.465, 2.000, 0.136> <-1.481, 1.996, 0.105> <-1.411, 1.942, 0.108> <-1.394, 1.911, 0.100>
		<-1.410, 1.976, 0.111> <-1.426, 1.972, 0.079> <-1.379, 1.936, 0.086> <-1.361, 1.906, 0.079>
		<-1.339, 1.912, 0.082> <-1.343, 1.911, 0.073> <-1.318, 1.895, 0.054> <-1.317, 1.886, 0.050>
		<-1.281, 1.919, 0.052> <-1.286, 1.918, 0.043> <-1.287, 1.903, 0.033> <-1.286, 1.894, 0.028>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.394, 1.911, 0.100> <-1.377, 1.882, 0.093> <-1.360, 1.838, 0.087> <-1.353, 1.805, 0.087>
		<-1.361, 1.906, 0.079> <-1.345, 1.877, 0.071> <-1.337, 1.848, 0.066> <-1.329, 1.815, 0.066>
		<-1.317, 1.886, 0.050> <-1.316, 1.870, 0.044> <-1.305, 1.847, 0.037> <-1.300, 1.830, 0.037>
		<-1.286, 1.894, 0.028> <-1.285, 1.878, 0.022> <-1.280, 1.854, 0.018> <-1.275, 1.837, 0.017>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.353, 1.805, 0.087> <-1.347, 1.777, 0.086> <-1.350, 1.739, 0.094> <-1.350, 1.710, 0.099>
		<-1.329, 1.815, 0.066> <-1.323, 1.787, 0.066> <-1.321, 1.760, 0.072> <-1.321, 1.732, 0.077>
		<-1.300, 1.830, 0.037> <-1.295, 1.813, 0.036> <-1.296, 1.788, 0.042> <-1.289, 1.773, 0.048>
		<-1.275, 1.837, 0.017> <-1.271, 1.820, 0.016> <-1.262, 1.798, 0.019> <-1.255, 1.783, 0.024>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.232, 1.788, 0.070> <-1.233, 1.804, 0.077> <-1.238, 1.827, 0.081> <-1.243, 1.844, 0.081>
		<-1.123, 1.820, 0.028> <-1.124, 1.836, 0.034> <-1.127, 1.859, 0.044> <-1.132, 1.876, 0.045>
		<-0.958, 1.809, -0.014> <-0.957, 1.834, 0.002> <-0.965, 1.886, 0.016> <-0.973, 1.915, 0.017>
		<-0.859, 1.846, -0.074> <-0.858, 1.871, -0.057> <-0.864, 1.912, -0.046> <-0.872, 1.941, -0.045>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.243, 1.844, 0.081> <-1.248, 1.861, 0.082> <-1.256, 1.884, 0.080> <-1.263, 1.899, 0.074>
		<-1.132, 1.876, 0.045> <-1.137, 1.893, 0.045> <-1.146, 1.911, 0.037> <-1.154, 1.926, 0.032>
		<-0.973, 1.915, 0.017> <-0.981, 1.944, 0.018> <-1.000, 1.993, 0.007> <-1.015, 2.015, -0.008>
		<-0.872, 1.941, -0.045> <-0.880, 1.970, -0.044> <-0.897, 2.009, -0.052> <-0.911, 2.031, -0.067>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.263, 1.899, 0.074> <-1.268, 1.907, 0.070> <-1.276, 1.920, 0.061> <-1.281, 1.919, 0.052>
		<-1.154, 1.926, 0.032> <-1.158, 1.935, 0.028> <-1.170, 1.933, 0.006> <-1.175, 1.932, -0.003>
		<-1.015, 2.015, -0.008> <-1.026, 2.032, -0.020> <-1.049, 2.052, -0.052> <-1.060, 2.050, -0.073>
		<-0.911, 2.031, -0.067> <-0.923, 2.048, -0.080> <-0.943, 2.065, -0.107> <-0.954, 2.063, -0.129>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.281, 1.919, 0.052> <-1.286, 1.918, 0.043> <-1.287, 1.903, 0.033> <-1.286, 1.894, 0.028>
		<-1.175, 1.932, -0.003> <-1.180, 1.931, -0.012> <-1.190, 1.928, -0.035> <-1.189, 1.918, -0.039>
		<-1.060, 2.050, -0.073> <-1.071, 2.048, -0.095> <-1.081, 2.021, -0.128> <-1.082, 2.000, -0.141>
		<-0.954, 2.063, -0.129> <-0.965, 2.060, -0.151> <-0.974, 2.038, -0.180> <-0.975, 2.018, -0.193>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.286, 1.894, 0.028> <-1.285, 1.878, 0.022> <-1.280, 1.854, 0.018> <-1.275, 1.837, 0.017>
		<-1.189, 1.918, -0.039> <-1.188, 1.902, -0.046> <-1.188, 1.882, -0.055> <-1.183, 1.865, -0.056>
		<-1.082, 2.000, -0.141> <-1.084, 1.975, -0.158> <-1.077, 1.924, -0.171> <-1.069, 1.895, -0.172>
		<-0.975, 2.018, -0.193> <-0.976, 1.992, -0.210> <-0.970, 1.951, -0.221> <-0.962, 1.922, -0.222>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.275, 1.837, 0.017> <-1.271, 1.820, 0.016> <-1.262, 1.798, 0.019> <-1.255, 1.783, 0.024>
		<-1.183, 1.865, -0.056> <-1.178, 1.848, -0.057> <-1.166, 1.825, -0.049> <-1.158, 1.810, -0.043>
		<-1.069, 1.895, -0.172> <-1.060, 1.866, -0.173> <-1.040, 1.817, -0.163> <-1.026, 1.795, -0.148>
		<-0.962, 1.922, -0.222> <-0.954, 1.893, -0.223> <-0.937, 1.854, -0.215> <-0.923, 1.832, -0.200>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.215, 1.995, 0.011> <-1.215, 1.995, 0.011> <-1.215, 1.995, 0.011> <-1.215, 1.995, 0.011>
		<-1.177, 1.961, -0.005> <-1.098, 1.992, -0.049> <-1.098, 1.992, -0.049> <-1.136, 2.026, -0.033>
		<-1.099, 1.935, -0.042> <-1.122, 2.012, -0.038> <-1.077, 2.036, -0.064> <-1.037, 2.101, -0.091>
		<-1.087, 1.883, -0.042> <-1.110, 1.960, -0.039> <-0.992, 2.034, -0.106> <-0.952, 2.098, -0.134>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.792, 1.982, -0.202> <-0.774, 1.921, -0.205> <-0.813, 1.821, -0.174> <-0.860, 1.788, -0.147>
		<-0.809, 2.042, -0.200> <-0.791, 1.981, -0.202> <-0.881, 1.850, -0.143> <-0.928, 1.816, -0.116>
		<-0.896, 2.097, -0.162> <-0.936, 2.032, -0.135> <-1.087, 1.884, -0.042> <-1.064, 1.806, -0.046>
		<-0.952, 2.098, -0.134> <-0.992, 2.034, -0.106> <-1.110, 1.960, -0.039> <-1.087, 1.883, -0.042>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.150, 1.727, 0.006> <-1.150, 1.727, 0.006> <-1.150, 1.727, 0.006> <-1.150, 1.727, 0.006>
		<-1.063, 1.745, -0.040> <-1.044, 1.792, -0.055> <-1.044, 1.792, -0.055> <-1.131, 1.774, -0.009>
		<-0.934, 1.736, -0.104> <-1.002, 1.764, -0.073> <-1.052, 1.755, -0.047> <-1.074, 1.832, -0.043>
		<-0.860, 1.788, -0.147> <-0.928, 1.816, -0.116> <-1.064, 1.806, -0.046> <-1.087, 1.883, -0.042>
	}
    texture {FishTexture}
}
}

#ifdef(TESTING_ONLY)
object{WaterSection}
#end
