// mushroom.inc
// defines macro Mushroom(T,Fins,X,Y,Z,Size,Yrot)
//
// Parameters:
// T     : Mushroom type: 0=old, 1=medium, 2=young
// Fins  : Boolean value specifying whether fins are visible
// X,Y,Z : Coordinates of the mushroom base
// Size  : Overall size of the mushroom
// Yrot  : Rotation of the asymmetrical stalk about the vertical axis

#declare StalkHeight = 1;
#declare StalkRadius = 0.2;
#declare StalkCurve = 2;
#declare Ptrans = 0;

#declare T_mush_top =
texture {
    pigment { bozo
        color_map {
            [0.01 rgb <0.5,0.5,0.5> ]
            [0.3 rgb <0.45,0.4,0.35> ]
            [0.5 rgb <0.35,0.32,0.3> ]
            [0.8 rgb <0.2,0.2,0.25> ]
            [0.85 rgb <0.4,0.4,0.25> ]
            [0.95 rgb <0.2,0.6,0.25> ]
        }
    }
    normal {
        wrinkles 2 scale 0.1
    }
    finish {
        ambient 0.8
        phong 0.5
        phong_size 20
    }
}

#declare T_mush_stalk =
texture {
    pigment { onion
        frequency 50
        color_map {
            [0.01 rgb <0.8,0.75,0.65> ]
            [0.5 rgb <0.45,0.4,0.35> ]
            [0.9 rgb <0.35,0.32,0.3> ]
        }
    }
    normal { onion 1
        frequency 50
        turbulence 0.2
    }
}

/*
#declare T_mush_stalk =
texture {
    pigment { radial
        frequency 50
        color_map {
            [0.01 rgb <0.8,0.75,0.65> ]
            [0.5 rgb <0.45,0.4,0.35> ]
            [0.9 rgb <0.35,0.32,0.3> ]
        }
    }
    normal { radial 1
        frequency 50
        turbulence 0.2
    }
}
*/

#declare T_mush_fins =
texture {
    pigment { rgb <0.5,0.5,0.5> }
    normal { radial
        frequency 100
        triangle_wave
    }
}

#declare A = array[3][18]
{
    {0.9, 0, 1, 0, 0.95, 0.05, 0.75, 0.1, 0.5, 0.25, 0.25, 0.4, 0.1, 0.475, 0.000001, 0.5, 0, 0.5},
    {0.6, 0, 0.7, 0, 0.64, 0.2, 0.54, 0.38, 0.44, 0.5, 0.35, 0.57, 0.19, 0.66, 0.000001, 0.7, 0, 0.7},
    {0.18, 0, 0.2, 0, 0.3, 0.01, 0.38, 0.2, 0.4, 0.45, 0.36, 0.72, 0.2, 0.95, 0.000001, 1, 0, 1}
}
#declare F = array[2]
{ A[0][2], A[1][2] }

#macro Mushroom(T,Fins,X,Y,Z,Size,Yrot)
// top
sor { 9
    <A[T][0], A[T][1]>
    <A[T][2], A[T][3]>
    <A[T][4], A[T][5]>
    <A[T][6], A[T][7]>
    <A[T][8], A[T][9]>
    <A[T][10], A[T][11]>
    <A[T][12], A[T][13]>
    <A[T][14], A[T][15]>
    <A[T][16], A[T][17]>
//    scale <1,0.5,1>
    texture { T_mush_top
        scale 0.3
        // use incrementing Ptrans value to ensure texture is not identical on each mushroom
        translate <Ptrans,0,0>
    }
    translate <0,StalkHeight,0>
    scale Size
    translate <X,Y,Z>
}

// stalk
intersection {
    torus { StalkCurve, StalkRadius
        texture { T_mush_stalk }
        rotate <90,0,0>
        translate <StalkCurve,StalkHeight,0>
        rotate <0,Yrot,0>
    }
    cylinder { <0,0,0>, <0,StalkHeight,0>, 3*StalkRadius
        texture { pigment { rgb <1,1,1> } }
    }
//    texture { T_mush_stalk }
    scale Size
    translate <X,Y,Z>
}

// fins - only if required
#if ((Fins) & (T != 2))
disc { <0,StalkHeight-0.001,0>, -y, F[T]
    texture { T_mush_fins }
    scale Size
    translate <X,Y,Z>
}
#end

// increment Ptrans so top pattern is different each time
#declare Ptrans = Ptrans + 1;
#end
