
//dragon head.inc
#include "colors.inc"
#include "claw.inc"
#include "horns.inc"
#include "textures.inc"

// ----------------------------------------

#declare Eye_Tex = texture{
pigment{
image_map
{
  gif "Sun.gif"
  map_type 1
  interpolate 4
}
scale <0.5,1.00,0.5>
rotate y*110
rotate x*6
}
}

//------------------------------------------

#declare Spine = union{
#declare Rad = 20;
#declare StAngle = 0.125; //Increasing gives tighter curve
#declare Inc = 0.1;
#declare SDiam = 0.55;
#declare SDiam_inc = 0.01;
#declare Count = 0.5;

#while (Count <150)
       #declare Angle = radians(StAngle * Count);

            #declare Cox = (Rad + Inc) *(sin(Angle));
            #declare Coy = Rad*(cos(Angle));
            #declare Point = <Cox,Coy,0>;

                object{sphere{<0,0,0>,SDiam - SDiam_inc
                        }
                        translate Point
                            scale <2,1,1>}

            #declare SDiam_inc = SDiam_inc + 0.015;
        #declare Count = Count + 5;
#end
}

//-------------------------------------------
#declare Cheek = union{
     #declare Rad = .75;
     #declare Angle = 90;

     #while(Angle<300)
           sphere{0,0.5
           translate<0,Rad,0>
           rotate z*Angle}

      #declare Angle = Angle + 25;
      #end
      scale <0.8,0.8,0.5>
      rotate z*-6.5
}

//------------------------------------------------
#declare  Jaw = union{
     cone{1.2*x,  1,-1*x, 0.5 rotate z*-7.5}
     sphere{<-0.95,0.125,0> 0.5}

     }

#declare Jaw2 = difference{
     object{Jaw}
     box{<1.3, -2, -1>  < -1.5,  0.5,  1>  }
     sphere{<-0.95,-0.3,0> 0.3}
     cone{1*x,  0.9,-1*x, 0.45 rotate z*-7.5}
     rotate x*180
     }

#declare Cone = union{
         torus{0.5,0.5 rotate z*90 translate<1,0,0>}
                       torus{0.425,0.5 rotate z*90 translate<0.75,0,0>}
         torus{0.375,0.5 rotate z*90 translate<0.5,0,0>}
                         torus{0.325,0.5 rotate z*90 translate<0.25,0,0>}
         torus{0.275,0.5 rotate z*90 translate<0,0,0>}
                         torus{0.225,0.5 rotate z*90 translate<-0.25,0,0>}
         torus{0.175,0.5 rotate z*90 translate<-0.5,0,0>}
                         torus{0.125,0.5 rotate z*90 translate<-0.75,0,0>}
         }


#declare Beak = intersection{
         sphere{x*-0.25,0.55}
         sphere{x*0.25,0.55}
         rotate y*90
         scale <1,1.25,1.7>
         }

#declare Jaw = union{
         object{Cone rotate z*-7.5}
         object {Beak translate<-0.95,0.225,0>}
         }


#declare UJaw = difference{
     object{Jaw rotate z*7.5}
     box{<1.5, -1.5, 1>  < -0.8,  0,  -1>  }
     sphere{<-0.7,-0.785,0> 1}
     cone{1*x,  0.9,-1*x, 0.45}
     }
#declare LJaw = difference {
     object{Jaw2}
     sphere{<-0.95,-0.3,0> 0.3}
     }
#declare Eye = union{
      torus{0.4,0.1 rotate x*90 rotate y*10
      texture{Copper_Texture} normal{radial frequency 25 rotate x*90 scallop_wave}finish{specular 1}}
      sphere{0,0.4 texture{Eye_Tex}translate<0,0,-0.2>finish{phong 1 phong_size 20}scale 1.1}
}

#declare Nose = union{
         #declare XInc = 0;
         #declare Reps = 0;
         #declare SDiam_Inc = 0;

         #while(Reps<5)
         sphere{<XInc,0,0>,0.5 + SDiam_Inc}

         #declare Reps = Reps + 1;
         #declare SDiam_Inc = SDiam_Inc + 0.07;
         #declare XInc = XInc + 2;
         #end
         }
//---------------------------------------------------------
#declare Head = union{
object{UJaw rotate z*-10 scale <1,1,0.8>}
object{LJaw rotate z*10}
object{Cheek  scale <1,0.8,1> rotate y*7 rotate x*5 translate <1.75,0.25,-0.625> }
object{Cheek scale <1,0.8,1>  rotate -y*7 rotate x*5 translate <1.75,0.25,0.625> }
sphere{<2,0,0>1scale <1,0.8,0.85>translate<-0.25,0.15,0>}
object{Eye clipped_by { box{<-1,-.2,-1> <1,3,1>}rotate z*180}rotate y*180 rotate x*7 rotate y*-3 translate <1.7,0.45,-0.775>}
object{Eye clipped_by { box{<-1,-.2,-1> <1,3,1>}rotate z*180} rotate x*-7 rotate y*-15 translate <1.7,0.45,0.75>}

//upper Jaw
object{Spine rotate z*197 rotate x*180 rotate y*7.0 scale 0.15 translate<0.3,-3.15,-0.66>
       texture{Copper_Texture}normal{radial rotate y*90 frequency 50 scallop_wave} finish{specular 1}}
object{Spine rotate z*197 rotate x*180 rotate y*-7.0 scale 0.15 translate<0.3,-3.15,0.66>
       texture{Copper_Texture}normal{radial rotate y*90 frequency 50 scallop_wave}finish{specular 1}}
//lowerjaw
cone{<-1,0,0.315>0.0,<1.25,0,0.775>0.09 rotate z*10 translate y*-0.51
       texture{Copper_Texture}normal{radial rotate y*90 frequency 50 scallop_wave}finish{specular 1}}
cone{<-1,0,-0.315>0.0,<1.25,0,-0.775>0.09 rotate z*10 translate y*-0.51
       texture{Copper_Texture}normal{radial rotate y*90 frequency 50 scallop_wave}finish{specular 1}}
//Nostrils
torus{0.15,0.075 rotate x*75 rotate y*10 translate<-0.75,0.45,-0.35>}
torus{0.15,0.075 rotate x*75 rotate y*10 translate<-0.75,0.45,0.35>}
//lower jaw spikes
object {Claw1 pigment{White} scale 0.08 rotate z*95 translate<0,-0.7,0>finish{specular 1}}
object {Claw1 pigment{White} scale 0.06 rotate z*95 translate<0.1,-0.7,0>finish{specular 1}}
object {Claw1 pigment{White} scale 0.04 rotate z*95 translate<0.15,-0.7,0>finish{specular 1}}
//upper teeth
object {Claw1 pigment{White} scale 0.07 rotate z*80 translate<-0.5,0.25,-0.2>}
object {Claw1 pigment{White} scale 0.07 rotate z*80 translate<-0.5,0.25,0.2>}
#declare WsegRot = 1;
#include "wings.inc"
object {Wing_Fan scale 1.00 rotate z*-240 rotate x*35
       texture{pigment{Red}} finish{specular 1}
       translate<2.6,-0.1,-1.3>}
#declare WsegRot = 0;
#include "wings.inc"
object {Wing_Fan2 scale 1.00 rotate z*-240 rotate x*-35
       texture{pigment{Red}} finish{specular 1}
       translate<2.55,0,1.25>}
object{Horn2 scale 0.4 rotate y*10 translate<5.85,0.6,-1.55>
             texture{Copper_Texture}normal{ripples 5 frequency 10} finish{specular 1}}
object{Horn2 scale 0.4 rotate y*-10 translate<5.85,0.6,1.5>
             texture{Copper_Texture}normal{ripples 5 frequency 10} finish{specular 1}}
object{Horn1 rotate z*-120 rotate y*180 scale 0.125 translate<-1.75,2.3,0>
             texture{Copper_Texture}normal{ripples 5 frequency 10} finish{specular 1}}
object{Nose scale 0.1 rotate y *12 translate<-0.525,0.5,-0.4>
            texture{Copper_Texture} finish{specular 1}}
object{Nose scale 0.1 rotate y *-12 translate<-0.525,0.5,0.4>
            texture{Copper_Texture} finish{specular 1}}
object{Horn1 scale <0.25,0.15,0.25> rotate z*-3.5 translate <-3,-0.25,0>
pigment{Red}finish{specular 1}normal{bumps 3 scale 0.025}}
}



