

// wings.inc



#declare Spine = union{

#declare Rad = 20;
#declare StAngle = 0.125;//Increasing gives tighter curve
#declare XInc = 0.1;
#declare SDiam = 0.35;
#declare SDiam_inc = 0.005;
#declare Count = 0.5;


#while (Count <220)
       #declare Angle = radians(StAngle * Count);

            #declare Cox = (Rad + XInc) *(sin(Angle));
            #declare Coy = Rad*(cos(Angle));
            #declare Point = <Cox,Coy,0>;

                object{sphere{<0,0,0>,SDiam - SDiam_inc
                        }
                        translate Point
                        scale<2,1,1>
}
            #declare SDiam_inc = SDiam_inc + 0.005;
        #declare Count = Count + 5;

#end
}

#declare Wing_secV2 = object {
bicubic_patch  {
   type	1
   flatness	0.01
   u_steps	4
   v_steps	4
   <-3.392, 1.917, 0.000>,
   <-0.948, 1.365, 0.000>,
   <0.918, 0.933, 0.000>,
   <4.666, 0.202, 0.000>,
   <-1.592, 0.579, -1.149>,
   <-0.932, 0.534, -0.505>,
   <0.967, 0.335, -0.257>,
   <4.815, 0.069, 0.000>,
   <-1.625, -0.577, -1.116>,
   <-0.965, -0.529, -0.522>,
   <0.967, -0.396, -0.241>,
   <4.831, -0.097, 0.000>,
   <-3.508, -1.980, 0.000>,
   <-0.981, -1.459, 0.000>,
   <0.967, -0.927, 0.000>,
   <4.666, -0.180, 0.000>
}
scale 0.3
#if (WsegRot = 1) rotate x*180 #end
}




#declare Wing_Fan = union{
object{Wing_secV2

	rotate < 0, 0, 25.5>
	scale < 0.5, 0.5, 0.5 >
    translate<0.075,-0.335,0>

}

object{Wing_secV2

	rotate < 0, 0, 0>
	scale < 0.5, 0.5, 0.5 >

}

object{Wing_secV2

	rotate < 0, 0, -25>
	scale < 0.5, 0.5, 0.5 >
    translate<0.1,0.335,0>

}

//top spine
object{Spine scale 0.075 rotate z*148 translate<1.5,1.375,0>
texture{Copper_Texture}
normal{gradient x 0.15 frequency 20 scallop_wave}
finish{specular 1}
}

object{Spine scale 0.075 rotate z*175 translate<0.8175,1.55,0>
texture{Copper_Texture}
normal{gradient x 0.15 frequency 20 scallop_wave}
finish{specular 1}
}

object{Spine scale 0.075 rotate z*200 translate<0.175,1.42,0>
texture{Copper_Texture}
normal{gradient x 0.15 frequency 20 scallop_wave}
finish{specular 1}
}
//bottom
object{Spine scale 0.075 rotate z*225 translate<-0.36,1.03,0>
texture{Copper_Texture}
normal{gradient x 0.15 frequency 20 scallop_wave}
finish{specular 1}
}

}

//-------------------------------Wing 2---------------------------------

#declare Spine2 = union{
#declare Rad = 20;
#declare StAngle = 0.125;//Increasing gives tighter curve
#declare Inc = 0.1;
#declare SDiam = 0.35;
#declare SDiam_inc = 0.005;
#declare Count = 0.5;

#while (Count <220)
       #declare Angle = radians(StAngle * Count);

            #declare Cox = (Rad + Inc) *(sin(Angle));
            #declare Coy = Rad*(cos(Angle));
            #declare Point = <Cox,Coy,0>;

                object{sphere{<0,0,0>,SDiam - SDiam_inc
                        }
                        translate Point
                            scale <2,1,1>}

            #declare SDiam_inc = SDiam_inc + 0.005;
        #declare Count = Count + 5;
#end
rotate x*180
}






#declare Wing_Fan2 = union{
object{Wing_secV2

	rotate < 0, 0, 25.>
	scale < 0.5, 0.5, 0.5 >
    translate<0.075,-0.335,0>

}

object{Wing_secV2

	rotate < 0, 0, 0>
	scale < 0.5, 0.5, 0.5 >

}

object{Wing_secV2

	rotate < 0, 0, -25.5>
	scale < 0.5, 0.5, 0.5 >
    translate<0.1,0.335,0>

}

//top spine
object{Spine2 scale 0.075 rotate z*135 translate<-0.345,-1.025,0>
texture{Copper_Texture}
normal{gradient x 0.15 frequency 20 scallop_wave}
finish{specular 1}
}

object{Spine2 scale 0.075 rotate z*160 translate<0.19,-1.425,0>
texture{Copper_Texture}
normal{gradient x 0.15 frequency 20 scallop_wave}
finish{specular 1}
}

object{Spine2 scale 0.075 rotate z*185 translate<0.85,-1.56,0>
texture{Copper_Texture}
normal{gradient x 0.15 frequency 20 scallop_wave}
finish{specular 1}
}

//bottom
object{Spine2 scale 0.075 rotate z*211 translate<1.5,-1.39,0>
texture{Copper_Texture}
normal{gradient x 0.15 frequency 20 scallop_wave}
finish{specular 1}
}

}
