#ifndef (Quick) #declare Quick=0; #end

#if (Quick)
  #declare P_Arch = pigment { colour rgb <0.9,0.9,0.9> }
#else
  #declare P_Arch1 = pigment { agate colour_map { [0.0 rgb <1,1,0.95>][1.0 rgb <0.9,0.9,0.85>] } scale <1,0.1,1> }
  #declare P_Arch = pigment { crackle pigment_map { [0.0 P_Arch1][1.0 rgb <0.8,0.8,0.75>] } scale <0.5,10,0.5> }
#end

#declare ArchColumn = box { <-10,0,-5>, <10,140,5> }
#declare ArchCap = difference {
  box { <-50,100,-5>, <50,140,5> }
  cylinder { <0,100,-5.001>, <0,100,5.001>, 30 scale <5/3,1,1> }
  bounded_by { box { <-50,100,-5>, <50,140,5> }}
}
#declare ArchCapPartial = difference {
  box { <35,100,-5>, <50,140,5> }
  cylinder { <0,100,-5.001>, <0,100,5.001>, 30 scale <5/3,1,1> }
  bounded_by { box { <35,100,-5>, <50,140,5> }}
  translate x*-50
}

#declare Arch1 = union {
  object { ArchColumn translate <10,0,-5> }
  object { ArchCapPartial translate <0,0,-5> scale <50,1,1>}
  texture { pigment { P_Arch } finish { ambient 0.4 }}
  rotate y*-90
}

#declare Arch2 = union {
  object { ArchColumn }
  object { ArchCap translate <-60,0,0> }
  object { ArchColumn translate <-120,0,0> }
  object { ArchCap translate <-180,0,0> }
  object { ArchColumn translate <-240,0,0> }
  object { ArchCap translate <-300,0,0> }
  object { ArchColumn translate <-360,0,0> }
  object { ArchCap translate <-420,0,0> }
  object { ArchColumn translate <-480,0,0> }
  pigment { colour rgb <1,1,1> } // not actually in view; for shadow purposes only.
}

#ifndef (FullScene)
  object { Arch1 translate <278.5,-53,-200> }
  object { Arch2 translate <250,0,-325> }
  plane { y, 0 pigment { colour rgb <1,1,1> }}
  camera { location <0.001,30,-500> look_at <0,40,0> angle 35.7 rotate y*-35 translate <20,0,125> }
  light_source { <-2000,7000,-10000> colour rgb <1,1,1> }
  light_source { <0,10000,-3000> colour rgb <1,1,1> }
  background { colour rgb <0.25,0.5,1.0> }
#end
