#ifndef (Quick) #declare Quick=0 #end

#if (Quick)
  #declare T_Building_Tan       = texture { pigment { colour rgb <0.6,0.4,0.08> }}
  #declare T_Building_White     = texture { pigment { colour rgb <1,1,1> }}
  #declare T_Building_Sand      = texture { pigment { colour rgb <0.9,0.8,0.7> }}
  #declare T_Building_Cyan      = texture { pigment { colour rgb <0.3,0.5,0.6> }}
  #declare T_Building_TanB      = texture { pigment { colour rgb <0.6,0.4,0.08> } finish { ambient 0.4 }}
  #declare T_Building_TanC      = texture { pigment { colour rgb <0.6,0.4,0.08> } finish { ambient 0.5 }}
  #declare T_Building_SandB     = texture { pigment { colour rgb <0.9,0.8,0.7> } finish { ambient 0.4 }}
  #declare T_Building2Top       = texture { T_Building_Sand finish { ambient 0.4 }}
  #declare T_Building_Lilac     = texture { pigment { colour rgb <0.8,0.8,0.9> }}
  #declare T_Building_Endcap    = texture { T_Building_Lilac }
  #declare T_Building_LightBlue = texture { pigment { colour rgb <0.63,0.77,0.85> }}
  #declare T_Building4          = texture { T_Building_Lilac }
  #declare T_Building_Blue      = texture { pigment { colour rgb <0,0.05,0.25> }}
  #declare T_Building5          = texture { T_Building_Cyan }
  #declare T_Building_Bone      = texture { pigment { colour rgb <1,1,0.9> }}
  #declare T_Building_BlueWhite = texture { T_Building_Blue }
  #declare T_Building_SkyBlue   = texture { pigment { colour rgb <0.55,0.65,0.8> }}
  #declare T_Building_MedBlue   = texture { pigment { colour rgb <0.3,0.3,0.6> }}
  #declare T_Building_LightGrey = texture { pigment { colour rgb <0.55,0.5,0.45> }}
  #declare T_Building8a         = texture { T_Building_White }
  #declare T_Building8b         = texture { T_Building_MedBlue }
  #declare T_Building8c         = texture { T_Building_LightGrey }
  #declare T_Building9a         = texture { T_Building_Lilac }
  #declare T_Building9b         = texture { T_Building_SkyBlue }
#else
  #declare T_Building_Tan       = texture { pigment { agate colour_map { [0.4 rgb <0.6,0.4,0.08>][0.6 rgb <0.4,0.26,0.04>] }}}
  #declare T_Building_White     = texture { pigment { quilted colour_map { [0.4 rgb <1,1,1>][0.6 rgb <0.5,0.5,0.5>] }}}
  #declare T_Building_Sand      = texture { pigment { granite colour_map { [0.4 rgb <0.9,0.8,0.7>][0.6 rgb <0.7,0.6,0.5>] }}}
  #declare T_Building_Cyan      = texture { pigment { crackle colour_map { [0.55 rgb <0.3,0.5,0.6>][0.75 rgb <0.15,0.325,0.45>] }}}
  #declare T_Building_TanB      = texture { pigment { agate colour_map { [0.4 rgb <0.6,0.4,0.08>][0.6 rgb <0.4,0.26,0.04>] }} finish { ambient 0.4 } scale <1,2/53.5,1> }
  #declare T_Building_TanC      = texture { pigment { agate colour_map { [0.4 rgb <0.6,0.4,0.08>][0.6 rgb <0.4,0.26,0.04>] }} finish { ambient 0.5 } scale <1,2/53.5,1> }
  #declare T_Building_SandB     = texture { pigment { granite colour_map { [0.4 rgb <0.9,0.8,0.7>][0.6 rgb <0.8,0.7,0.6>] }} finish { ambient 0.4 } scale <1,2/53.5,1> }
  #declare T_Building_SandC     = texture { pigment { granite colour_map { [0.4 rgb <0.9,0.8,0.7>][0.6 rgb <0.8,0.7,0.6>] }} finish { ambient 0.5 } scale <1,2/53.5,1> }
  #declare T_Building2Top       = texture { gradient y texture_map {[0.105 T_Building_SandB][0.105 T_Building_TanB][0.125 T_Building_TanB][0.125 T_Building_SandB][0.185 T_Building_SandB][0.185 T_Building_TanB][0.205 T_Building_TanB][0.205 T_Building_SandB][0.710 T_Building_SandB][0.710 T_Building_TanB][0.730 T_Building_TanB][0.730 T_Building_SandB][0.790 T_Building_SandB][0.790 T_Building_TanB][0.810 T_Building_TanB][0.810 T_Building_SandB][0.900 T_Building_SandB][0.900 T_Building_TanB]} scale <1,53.5,1> translate y*17.5}
  #declare T_Building_Lilac     = texture { pigment { bozo colour_map { [0.0 rgb <0.8,0.8,0.9>][1.0 rgb <0.75,0.75,0.85>] }}}
  #declare T_Building_Endcap    = texture { gradient y texture_map { [0.0 T_Building_Lilac][1.0 T_Building_Sand] } scale 200 translate y*-50 rotate x*-45 }
  #declare T_Building_LightBlue = texture { pigment { colour rgb <0.63,0.77,0.85> }}
  #declare T_Building4a         = texture { gradient y texture_map {[0.38 T_Building_Lilac][0.38 T_Building_White][0.40 T_Building_White][0.40 T_Building_Lilac][0.50 T_Building_Lilac][0.50 T_Building_Sand][0.65 T_Building_Sand][0.65 T_Building_Lilac][0.70 T_Building_Lilac][0.70 T_Building_White][0.72 T_Building_White][0.72 T_Building_Lilac][0.90 T_Building_Lilac][0.90 T_Building_White][0.95 T_Building_White][0.95 T_Building_Lilac][0.98 T_Building_Lilac][0.98 T_Building_White]}}
  #declare T_Building4          = texture { gradient x texture_map {[0.1 T_Building_White][0.1 T_Building4a][0.9 T_Building4a][0.9 T_Building_White]} scale <5.8823,125,5.8823> translate y*75 }
  #declare T_Building_Blue      = texture { pigment { colour rgb <0,0.05,0.25> }}
  #declare T_Building5a         = texture { gradient y texture_map {[0.20 T_Building_White][0.20 T_Building_Cyan][0.70 T_Building_Cyan][0.70 T_Building_White][0.90 T_Building_White][0.90 T_Building_Cyan]}}
  #declare T_Building5          = texture { gradient z texture_map {[0.1 T_Building_White][0.1 T_Building5a][0.9 T_Building5a][0.9 T_Building_White]} translate y*0.2 scale <1,2,1.5> }
  #declare T_Building_Bone      = texture { pigment { bozo colour_map {[0.0 rgb <0.95,0.95,0.9>][1.0 rgb <0.7,0.7,0.8>]} scale <0.5,10,0.5> }}
  #declare T_Building_BlueWhite = texture { gradient y texture_map { [0.30 T_Building_Blue][0.30 T_Building_White][0.40 T_Building_White][0.70 T_Building_Blue] } scale <1,150,1> }
  #declare T_Building_SkyBlue   = texture { pigment { colour rgb <0.55,0.65,0.8> }}
  #declare T_Building_MedBlue   = texture { pigment { colour rgb <0.3,0.3,0.6> }}
  #declare T_Building_LightGrey = texture { pigment { colour rgb <0.55,0.5,0.45> }}
  #declare T_Building8a1        = texture { radial texture_map {[0.025 T_Building_Lilac][0.025 T_Building_Blue][0.100 T_Building_Blue][0.100 T_Building_Lilac][0.235 T_Building_Lilac][0.235 T_Building_Blue][0.350 T_Building_Blue][0.350 T_Building_Lilac][0.400 T_Building_Lilac][0.400 T_Building_Blue][0.450 T_Building_Blue][0.450 T_Building_Lilac][0.550 T_Building_Lilac][0.550 T_Building_Blue][0.600 T_Building_Blue][0.600 T_Building_Lilac][0.650 T_Building_Lilac][0.650 T_Building_Blue][0.785 T_Building_Blue][0.785 T_Building_Lilac][0.900 T_Building_Lilac][0.900 T_Building_Blue][0.975 T_Building_Blue][0.975 T_Building_Lilac]}}
  #declare T_Building8a         = texture { gradient y texture_map {[0.590 T_Building8a1][0.590 T_Building_Blue][0.625 T_Building_Blue][0.625 T_Building8a1][0.750 T_Building8a1][0.750 T_Building_Blue][0.800 T_Building_Blue][0.800 T_Building8a1][0.925 T_Building8a1][0.925 T_Building_Blue][0.950 T_Building_Blue][0.950 T_Building8a1][0.975 T_Building8a1][0.975 T_Building_Blue]}}
  #declare T_Building8b         = texture { gradient y texture_map {[0.75 T_Building_MedBlue][0.75 T_Building_White]}}
  #declare T_Building8c         = texture { gradient x texture_map {[0.250 T_Building_Blue][0.250 T_Building_LightGrey][0.500 T_Building_LightGrey][0.500 T_Building_Blue][0.700 T_Building_Blue][0.700 T_Building_LightGrey]}}
  #declare T_Building9a         = texture { gradient x texture_map {[0.10 T_Building_Lilac][0.10 T_Building_LightGrey][0.15 T_Building_LightGrey][0.15 T_Building_Lilac][0.75 T_Building_Lilac][0.75 T_Building_LightGrey][0.80 T_Building_LightGrey][0.80 T_Building_Lilac]}}
  #declare T_Building9b1        = texture { gradient y texture_map {[0.3 T_Building_LightGrey][0.3 T_Building_Blue] } scale 15 }
  #declare T_Building9b         = texture { gradient x texture_map {[0.125 T_Building9b1][0.125 T_Building_SkyBlue][0.40 T_Building_SkyBlue][0.40 T_Building_LightGrey][0.65 T_Building_LightGrey][0.65 T_Building_SkyBlue][0.90 T_Building_SkyBlue][0.90 T_Building_Lilac][0.95 T_Building_Lilac][0.95 T_Building_Blue]} scale <10,1,1>}
#end

//------------------------------------------------------------------------------------------------------------

#declare Building1 = union {  // Rightmost building
  union {
    box { <-50,0,0>, <-45,60,200> texture { T_Building_Tan }}
    box { <-45,50,0>, <45,45,200> texture { T_Building_Tan }}
    box { <-45,0,200>, <45,45,201> texture { T_Building_Tan }}
    box { <-50,0,0>, <-48.75,58.75,-0.1> }    box { <-50,60,0>, <-45,58.75,-0.1> }
    box { <-46.25,0,0>, <-45,58.75,-0.1> }    box { <-45,50,0>, <45,48.75,-0.1> }
    box { <-45,45,0>, <45,46.25,-0.1> }
    texture { T_Building_White }
    matrix <1,0,0, -0.3,1,0, 0,-0.2,1, 0,0,0>
  }
  union {
    box { <-35,50,25>, <35,1000,125> texture { T_Building_Cyan }}
    box { <-37,50,24>, <-34,1000,25> }    box { <-32,50,24>, <-30,1000,25> }
    box { <-28,50,24>, <-26,1000,25> }    box { <-24,50,24>, <-22,1000,25> }
    box { <-20,50,24>, <-18,1000,25> }    box { <-16,50,24>, <-14,1000,25> }
    texture { T_Building_Sand }
    translate x*-2
  }
  scale <1,1.1,1>
}

//------------------------------------------------------------------------------------------------------------

#declare Building2Endcap = prism {
  linear_spline linear_sweep -2, 2, 58,
  <  2.5, 0.0>, < -0.5, 4.0>, < -3.0, 7.5>, < -5.7,10.7>, < -8.5,14.0>, < -4.4,15.9>,
  < -0.5,18.3>, <  3.2,21.3>, <  6.8,24.8>, < 10.2,28.6>, < 13.5,32.9>, < 16.5,37.5>,
  < 20.0,42.5>, < 22.6,46.7>, < 26.0,51.5>, < 29.5,57.5>, < 33.0,64.0>, < 36.0,72.5>,
  < 38.0,80.0>, < 39.5,87.5>, < 37.5,88.0>, < 35.0,84.5>, < 28.0,76.5>, < 22.5,71.0>,
  < 17.4,65.8>, < 12.6,61.0>, <  7.7,56.4>, <  2.5,52.1>, < -2.9,48.2>, < -8.5,44.6>,
  <-14.4,41.2>, <-20.5,38.3>, <-26.9,35.6>, <-33.5,33.2>, <-40.4,31.1>, <-47.5,29.4>,
  <-55.0,27.9>, <-62.6,26.7>, <-70.9,25.9>, <-76.0,25.5>, <-76.0,24.0>, <-70.8,23.9>,
  <-65.3,23.4>, <-59.6,22.7>, <-53.8,21.7>, <-48.1,20.4>, <-42.3,18.9>, <-36.6,17.3>,
  <-31.1,15.4>, <-26.8,13.8>, <-22.8,12.0>, <-18.9,10.2>, <-15.4, 8.3>, <-12.1, 6.3>,
  < -9.2, 4.3>, < -6.7, 2.2>, < -4.5, 0.0>, <  2.5, 0.0>
  rotate <-90,90,0>
}

#declare Building2TopPrism = prism {
  linear_spline linear_sweep 0, -1, 7,
  <24.5,69>, <13.5,54>, <-26,17.5>, <-27,20>, <12,56>, <23,71>, <24.5,69>
  rotate <-90,90,0>
}

#declare Building2TopSupport = object { Building2TopPrism scale <3,1,1> texture { T_Building_Tan }}
#declare Building2TopPanel = object { Building2TopPrism scale <27,1,1> translate x*3 texture { T_Building2Top }}

#declare Building2BottomSupport = box { <0,0,0>, <3,21.5,3> texture { T_Building_SandB scale <1,53.5,1> }}
#declare Building2BottomSlats = union {
  #declare foo=2.0;
  #while (foo < 18)
    cylinder { <0,foo,1.5>, <27,foo,1.5>, 0.75 }
    #declare foo=foo+2;
  #end
  texture { T_Building_TanC scale <1,53.5,1> }
  translate x*3
}
#declare Building2BottomStrut = union {
  cylinder { <1.5,25,60>, <1.5,-5,42.5>, 0.75 }
  cylinder { <1.5,5,48>, <1.5,-2,53>, 0.75 }
  sphere { <1.5,5,48>, 0.75 }
  matrix <1,0,0, 0,1,-1, 0,0,1, 0,0,0 >
  texture { T_Building_White }
}

#declare Building2Top = union {
  #declare foo=-150;
  #while (foo < 150)
    object { Building2TopSupport translate x*foo }
    object { Building2TopPanel translate x*foo }
    #declare foo=foo+30;
  #end
  object { Building2TopSupport translate x*foo }
}

#declare Building2Bottom = union {
  #declare foo=-150;
  #while (foo < 150)
    object { Building2BottomSupport translate x*foo }
    object { Building2BottomSlats translate x*foo }
    object { Building2BottomStrut translate x*foo }
    object { Building2BottomStrut translate x*(foo+15) }
    #declare foo=foo+30;
  #end
  object { Building2BottomSupport translate x*foo }
  box { <-150,0,4>, <150,21.5,4.1> pigment { colour rgb <0.1,0.1,0.1> }}
  matrix <1,0,0, 0,1,1, 0,0,1, 0,0,0>
}


#declare Building2 = union { // Pointy/Curvy building
  object { Building2Endcap texture { T_Building_Endcap } translate x*-152 }
  object { Building2Top }
  box { <-150,24.5,75>, <150,25.5,30> texture { T_Building_Lilac }}
  object { Building2Bottom }
  object { Building2Endcap texture { T_Building_Lilac } translate x*155 }
  rotate y*-90
  scale <1.1,1,1>
}

//------------------------------------------------------------------------------------------------------------

#declare Building3Comb = union {
  intersection {
    union {
      difference {
        union {
          torus { 30, 2.5 rotate x*-90 }
          cylinder { <0,0,-2.5>, <0,0,15>, 30 }
          cylinder { <0,0,0>, <0,0,15>, 32.5 }
        }
        cylinder { <-35,0,50>, <35,0,50>, 50 }
        cylinder { <-15,0,-2.51>, <-15,0,15.01>, 15 }
        cylinder { <15,0,-2.51>, <15,0,15.01>, 15 }
      }
      torus { 15, 2.5 rotate x*-90 translate x*-15 }
      torus { 15, 2.5 rotate x*-90 translate x* 15 }
    }
    box { <-32.51,0,-2.51>, <32.51,32.51,15.01> }
    bounded_by { box { <-32.5,0,-2.5>, <32.5,32.5,15> }}
    scale <1,2,1>
  }
  cylinder { <-30,0,0>, <-30,-150,0>, 2.5 }  cylinder { <  0,0,0>, <  0,-150,0>, 2.5 }
  translate y*150
}

#declare Building3Dome = union {
  intersection {
    sphere { 0, 38.890873 }
    box { <-27.5,0,-27.5>, <27.5,42.5,27.5> }
    bounded_by { box { <-27.5,0,-27.5>, <27.5,38.890873,27.5> }}
  }
  sphere { <0,30,0>, 17.5 }
  scale <1,1.1,1>
  translate y*180
}

#declare Building3 = union { // Weird gazebo-like structure
  object { Building3Comb translate z*-30 }
  object { Building3Comb rotate y*90  translate x*-30 }
  object { Building3Comb rotate y*180 translate z* 30 }
  object { Building3Comb rotate y*270 translate x* 30 }
  object { Building3Dome }
  scale <1.25,1,1.25>
  texture { T_Building_White }
}

//------------------------------------------------------------------------------------------------------------

// Simple rectangular building in the far right background
//
#declare Building4side = box { <-50,0,-50>, <50,200,-49.001> texture { T_Building4 } translate y*100}
#declare Building4 = union { object { Building4side } object { Building4side rotate y*-90 }}

//------------------------------------------------------------------------------------------------------------

#declare Building5 = union { //  "hotel" looking building behind the pointy curvy structure
  difference {
    box { <-25,0,-4>, <25,100,0> texture { T_Building_LightBlue }}
    box { <-14,87,-4.01>, <-10,82,-2> }  box { <14,87,-4.01>, <10,82,-2> }
    box { <-14,75,-4.01>, <-10,60,-2> }  box { <14,75,-4.01>, <10,60,-2> }
    box { <-2,70,-4.01>, <2,1,-2> }
    texture { T_Building_Cyan }
  }
  box { <-25,100,-4>, <6,103,0> texture { T_Building_Blue }}
  box { <6,100,-4>, <25,120,0> texture { T_Building_LightBlue }}
  box { <6,120,-4>, <25,123,0> texture { T_Building_Blue }}
  box { <20,0,0>, <21,110,500> texture { T_Building5 scale 6 }}
  box { <21,0,110>, <21.01,110,116> texture { T_Building_Tan }}
  box { <21,0,250>, <21.01,110,256> texture { T_Building_Tan }}
  matrix < 1,0,0, 0,1,0, 0,0.04,1, 0,0,0>
  translate y*50
}

//------------------------------------------------------------------------------------------------------------

#declare Building6 = intersection { // white dome behind the "hotel"
  sphere { <0,40,0>, 50 }
  box { <-45,0,-45>, <45,90.1,45> }
  bounded_by { box { <-45,0,-45>, <45,90,45> }}
  texture { T_Building_Bone scale 2 }
  translate y*7
}

//------------------------------------------------------------------------------------------------------------

#declare Building7 = union { // "space needle" type thing at the right, behind the dome
  intersection {
    cylinder { <0,0,0>, <0,100,0>, 0.5 }
    plane { y, 0 rotate x*-85 translate <0,100,0> rotate y*45 }
    bounded_by { cylinder { <0,0,0>, <0,100,0>, 0.5 }}
    texture { T_Building_White }
    translate <0.5,20,0.5>
  }
  union {
    cylinder { <0,0,0>, <0,90,0>, 0.5}
    cone { <0,90,0>, 0.5, <0,160,0>, 0 }
    texture { T_Building_BlueWhite }    
  }
  intersection {
    cylinder { <0,0,0>, <0,90,0>, 0.5 }
    plane { y, 0 rotate x*-85 translate <0,90,0> rotate y*-45 }
    bounded_by { cylinder { <0,0,0>, <0,100,0>, 0.5 }}
    texture { T_Building_White }
    translate <-0.5,20,0.5>
  }
  prism { linear_spline linear_sweep -0.4, -0.6, 5, <-3,0>, <-1,110>, <1,110>, <3,0>, <-3,0>
    rotate x*-90 texture { T_Building_Blue }
  }
  rotate y*-35
}

//------------------------------------------------------------------------------------------------------------

#declare Building8 = union { // left building behind white dome
  cylinder { <0,0,0>, <0,100,0>, 5 texture { T_Building8a scale <1,100,1> } rotate y*35 }
  sphere { <0,100,0>, 5 texture { T_Building8b scale <1,5,1> }}
  box { <-6,0,-3>, <8,90,3> texture { T_Building8c scale 6 } translate x*-11 }
}

//------------------------------------------------------------------------------------------------------------

#declare Building9 = union { // Tall, flat building behind the Wedge
  union {
    cylinder { <0,0,0>, <0,150,0>, 8.4 texture { T_Building_MedBlue }}
    #declare foo=0;
    #while (foo < 8)
      cylinder { <0,0,5>, <0,150,5>, 4 rotate y*45*foo }
      #declare foo=foo+1;
    #end
    texture { T_Building_SkyBlue }
    translate x*40
  }
  box { <-40,0,-9>, <40,150,9> texture { T_Building9a scale 40 }}
  prism { linear_sweep linear_spline 25, 135, 5,
    <-10,0>, <-1.25,-7.5>, <1.25,-7.5>, <10,0>, <-10,0>
    texture { T_Building9b }
    scale <0.75,1,0.75>
    translate <17.5,0,-9>
  }
}

//------------------------------------------------------------------------------------------------------------

#declare Building10 = union { // Tall, thin building(?) just to the right of the gazebo.
  box { <-0.625,0,-3>, <0.625,200,3> }
  box { <-6,0,-1>, <6,175,1> texture { T_Building_Lilac }}
  box { <-7,0,-2>, <-6,176,2> }
  box { <6,0,-2>, <7,185,2> }
  texture { T_Building_White }
  scale <0.75,0.75,0.75>
}

//------------------------------------------------------------------------------------------------------------

#ifndef (FullScene)
  object { Building10 rotate y*35 }
  camera { location <0,100,-400> look_at <0,100,0> angle 37.5 }
  light_source { <-1000,1000,-1000> colour rgb <1,1,1> }
  light_source { <0,30,-1000> colour rgb <1,1,1> }
#end
