#ifndef (Quick) #declare Quick=0 #end

#declare T_Building_LightBlue   = texture { pigment { colour rgb <0.63,0.77,0.85> }}
#declare T_Building_SkyBlue     = texture { pigment { colour rgb <0.55,0.65,0.8> }}
#declare T_Building_DustyBlue   = texture { pigment { colour rgb <0.35,0.45,0.6> }}
#declare T_Building_MedBlue     = texture { pigment { colour rgb <0.3,0.3,0.6> }}
#declare T_Building_Midnight    = texture { pigment { colour rgb <0.15,0.25,0.4> }}
#declare T_Building_Teal        = texture { pigment { colour rgb <0.0,0.25,0.22> }}
#declare T_Building_Blue        = texture { pigment { colour rgb <0,0.05,0.25> }}
#declare T_Building_LightGrey   = texture { pigment { colour rgb <0.55,0.5,0.45> }}
#declare T_Building_MedGrey     = texture { pigment { colour rgb <0.25,0.25,0.25> }}
#declare T_Building_DarkGrey    = texture { pigment { colour rgb <0.12,0.12,0.12> }}
#declare T_Building_Clear       = texture { pigment { colour rgbt <1,1,1,1> }}
#declare T_Building_Red         = texture { pigment { colour rgb <0.5,0,0> }}

#if (Quick)
  #declare T_Building_White     = texture { pigment { colour rgb <1,1,1> }}
  #declare T_Building_Bone      = texture { pigment { colour rgb <1,1,0.9> }}
  #declare T_Building_Sand      = texture { pigment { colour rgb <0.9,0.8,0.7> }}
  #declare T_Building_Ash       = texture { pigment { colour rgb <0.8,0.8,0.8> }}
  #declare T_Building_Tan       = texture { pigment { colour rgb <0.6,0.4,0.08> }}
  #declare T_Building_Cyan      = texture { pigment { colour rgb <0.3,0.5,0.6> }}
  #declare T_Building_Lilac     = texture { pigment { colour rgb <0.8,0.8,0.9> }}
  #declare T_Building_Orange    = texture { pigment { colour rgb <1,0.25,0> }}
  #declare T_Building_Silver    = texture { pigment { colour rgb <0.95,1,1> }}
  #declare T_Building11a8       = texture { T_Building_Lilac }
  #declare T_Building11a9       = texture { T_Building_Lilac }
  #declare T_Building14a        = texture { T_Building_Lilac }
  #declare T_Building14b        = texture { T_Building_Lilac }
  #declare T_Building14c        = texture { T_Building_Blue }
  #declare T_Building15a        = texture { T_Building_SkyBlue }
  #declare T_Building15b        = texture { T_Building_MedGrey }
  #declare T_Building16a        = texture { T_Building_Lilac }
  #declare T_Building16b        = texture { T_Building_Midnight }
  #declare T_Building17         = texture { T_Building_LightBlue }
  #declare T_Building18         = texture { T_Building_Sand }
#else
  #declare T_Building_White     = texture { pigment { quilted colour_map { [0.4 rgb <1,1,1>][0.6 rgb <0.5,0.5,0.5>] } warp { turbulence 1.0 } } scale 0.01 }
  #declare T_Building_Bone      = texture { pigment { bozo colour_map {[0.0 rgb <0.95,0.95,0.9>][1.0 rgb <0.7,0.7,0.8>]} scale <0.5,10,0.5> }}
  #declare T_Building_Sand      = texture { pigment { granite colour_map { [0.4 rgb <0.9,0.8,0.7>][0.6 rgb <0.7,0.6,0.5>] }}}
  #declare T_Building_Ash       = texture { pigment { bozo colour_map { [0.0 rgb <0.8,0.8,0.8>][1.0 rgb <0.75,0.75,0.75>] }}}
  #declare T_Building_Tan       = texture { pigment { agate colour_map { [0.4 rgb <0.6,0.4,0.08>][0.6 rgb <0.4,0.26,0.04>] }}}
  #declare T_Building_Cyan      = texture { pigment { crackle colour_map { [0.55 rgb <0.3,0.5,0.6>][0.75 rgb <0.15,0.325,0.45>] }}}
  #declare T_Building_Lilac     = texture { pigment { bozo colour_map { [0.0 rgb <0.8,0.8,0.9>][1.0 rgb <0.75,0.75,0.85>] }}}
  #declare T_Building_Orange    = texture { pigment { colour rgb <1,0.25,0> } finish { ambient 0.4 }}
  #declare T_Building_Silver    = texture { pigment { colour rgb <0.95,0.95,1> } finish { reflection 0.7 metallic brilliance 2.0 specular 1.0 roughness 0.001 }}
  #declare T_Building11a1       = texture { gradient x texture_map {[0.05 T_Building_White][0.05 T_Building_Blue][0.45 T_Building_Blue][0.45 T_Building_White][0.55 T_Building_White][0.55 T_Building_Blue][0.95 T_Building_Blue][0.95 T_Building_White]}}
  #declare T_Building11a2       = texture { gradient x texture_map {[0.05 T_Building_White][0.05 T_Building_MedGrey][0.45 T_Building_MedGrey][0.45 T_Building_White][0.55 T_Building_White][0.55 T_Building_MedGrey][0.95 T_Building_MedGrey][0.95 T_Building_White]}}
  #declare T_Building11a3       = texture { gradient x texture_map {[0.05 T_Building_White][0.05 T_Building_Lilac][0.95 T_Building_Lilac][0.95 T_Building_White]}}
  #declare T_Building11a4       = texture { bozo texture_map { [0.0 T_Building_Lilac][0.5 T_Building_Ash][1.0 T_Building_Lilac] }}
  #declare T_Building11a5       = texture { gradient x texture_map { [0.05 T_Building_White][0.05 T_Building11a4][0.95 T_Building11a4][0.95 T_Building_White]}}
  #declare T_Building11a6       = texture { gradient x texture_map {[0.05 T_Building_White][0.05 T_Building_Teal][0.95 T_Building_Teal][0.95 T_Building_White]}}
  #declare T_Building11a7       = texture { gradient x texture_map {[0.05 T_Building_White][0.05 T_Building_Teal][0.45 T_Building_Teal][0.45 T_Building_White][0.55 T_Building_White][0.55 T_Building_Teal][0.95 T_Building_Teal][0.95 T_Building_White]}}
  #declare T_Building11a8       = texture { gradient y texture_map {[0.31 T_Building11a3][0.31 T_Building11a1][0.32 T_Building11a1][0.32 T_Building11a3][0.34 T_Building11a3][0.34 T_Building11a1][0.35 T_Building11a1][0.35 T_Building11a3][0.37 T_Building11a3][0.37 T_Building11a1][0.38 T_Building11a1][0.38 T_Building11a3][0.70 T_Building11a3][0.70 T_Building11a1][0.71 T_Building11a1][0.71 T_Building11a3][0.72 T_Building11a3][0.72 T_Building11a2][0.73 T_Building11a2][0.73 T_Building11a3][0.74 T_Building11a3][0.74 T_Building11a1][0.75 T_Building11a1][0.75 T_Building11a3][0.76 T_Building11a3][0.76 T_Building11a2][0.77 T_Building11a2][0.77 T_Building11a3][0.78 T_Building11a3][0.78 T_Building11a1][0.79 T_Building11a1][0.79 T_Building11a3][0.95 T_Building11a3][0.95 T_Building11a6][0.96 T_Building11a6][0.96 T_Building11a3]}}
  #declare T_Building11a9       = texture { gradient y texture_map {[0.30 T_Building11a5][0.30 T_Building11a2][0.31 T_Building11a2][0.31 T_Building11a5][0.32 T_Building11a5][0.32 T_Building11a1][0.33 T_Building11a1][0.33 T_Building11a5][0.34 T_Building11a5][0.34 T_Building11a1][0.35 T_Building11a1][0.35 T_Building11a5][0.36 T_Building11a5][0.36 T_Building11a2][0.37 T_Building11a2][0.37 T_Building11a5][0.38 T_Building11a5][0.38 T_Building11a2][0.39 T_Building11a2][0.39 T_Building11a5][0.40 T_Building11a5][0.40 T_Building11a7][0.43 T_Building11a7][0.43 T_Building11a5][0.44 T_Building11a5][0.44 T_Building11a2][0.45 T_Building11a2][0.45 T_Building11a5][0.62 T_Building11a5][0.62 T_Building11a2][0.63 T_Building11a2][0.63 T_Building11a5][0.64 T_Building11a5][0.64 T_Building11a1][0.65 T_Building11a1][0.65 T_Building11a5][0.66 T_Building11a5][0.66 T_Building11a1][0.67 T_Building11a1][0.67 T_Building11a5][0.68 T_Building11a5][0.68 T_Building11a1][0.69 T_Building11a1][0.69 T_Building11a5][0.70 T_Building11a5][0.70 T_Building11a2][0.71 T_Building11a2][0.71 T_Building11a5][0.72 T_Building11a5][0.72 T_Building11a2][0.73 T_Building11a2][0.73 T_Building11a5][0.74 T_Building11a5][0.74 T_Building11a1][0.75 T_Building11a1][0.75 T_Building11a5][0.91 T_Building11a5][0.91 T_Building11a7][0.92 T_Building11a7][0.92 T_Building11a5][0.93 T_Building11a5][0.93 T_Building11a1][0.94 T_Building11a1][0.94 T_Building11a5]}}
  #declare T_Building14a1       = texture { gradient y texture_map {[0.31 T_Building_Ash][0.80 T_Building_Ash][0.80 T_Building_LightGrey][0.82 T_Building_LightGrey][0.82 T_Building_Ash][0.89 T_Building_Ash][0.89 T_Building_Blue][0.90 T_Building_Blue][0.90 T_Building_Ash][0.91 T_Building_Ash][0.91 T_Building_Blue][0.93 T_Building_Blue][0.93 T_Building_Ash]}}
  #declare T_Building14a2       = texture { gradient x texture_map {[0.1 T_Building_White][0.1 T_Building14a1][0.9 T_Building14a1][0.9 T_Building_White]}}
  #declare T_Building14a        = texture { gradient y texture_map {[0.30 T_Building_LightGrey][0.30 T_Building_Red][0.31 T_Building_Red][0.31 T_Building14a2] }}
  #declare T_Building14b1       = texture { gradient x texture_map {[0.06 T_Building_Cyan][0.06 T_Building_Lilac]}}
  #declare T_Building14b        = texture { gradient y texture_map {[0.60 T_Building_LightGrey][0.60 T_Building14b1][0.97 T_Building14b1][0.97 T_Building_Cyan] }}
  #declare T_Building14c        = texture { gradient y texture_map {[0.30 T_Building_Blue][0.30 T_Building_Lilac][0.40 T_Building_Lilac][0.40 T_Building_Blue][0.80 T_Building_Blue][0.80 T_Building_Lilac]}}
  #declare T_Building15a1       = texture { gradient y texture_map { [0.80 T_Building_SkyBlue][0.80 T_Building_Ash ] }}
  #declare T_Building15a2       = texture { gradient x texture_map { [0.1 T_Building_White][0.1 T_Building15a1][0.9 T_Building15a1][0.9 T_Building_White] }}
  #declare T_Building15a        = texture { gradient z texture_map { [0.2 T_Building15a2][0.2 T_Building_SkyBlue] }}
  #declare T_Building15b1       = texture { gradient x texture_map { [0.1 T_Building_MedGrey][0.1 T_Building_Clear][0.9 T_Building_Clear][0.9 T_Building_MedGrey] }}
  #declare T_Building15b        = texture { gradient y texture_map { [0.1 T_Building_MedGrey][0.1 T_Building15b1][0.9 T_Building15b1][0.9 T_Building_MedGrey] }}
  #declare T_Building16a1       = texture { gradient x texture_map {[0.08 T_Building_White][0.08 T_Building_Lilac][0.75 T_Building_Lilac][0.75 T_Building_LightGrey][0.85 T_Building_LightGrey][0.85 T_Building_Lilac][0.95 T_Building_Lilac][0.95 T_Building_White]}}
  #declare T_Building16a2       = texture { gradient x texture_map {[0.08 T_Building_White][0.08 T_Building_Lilac][0.16 T_Building_Lilac][0.16 T_Building_White][0.24 T_Building_White][0.24 T_Building_Lilac][0.32 T_Building_Lilac][0.32 T_Building_White][0.40 T_Building_White][0.40 T_Building_Lilac][0.85 T_Building_Lilac][0.85 T_Building_White]}}
  #declare T_Building16a3       = texture { gradient x texture_map {[0.04 T_Building_White][0.04 T_Building_Teal][0.16 T_Building_Teal][0.16 T_Building_White][0.24 T_Building_White][0.24 T_Building_Lilac][0.32 T_Building_Lilac][0.32 T_Building_White][0.40 T_Building_White][0.40 T_Building_Lilac][0.95 T_Building_Lilac][0.95 T_Building_White]}}
  #declare T_Building16a4       = texture { gradient y texture_map {[0.14 T_Building16a1][0.14 T_Building16a2][0.55 T_Building16a2][0.55 T_Building16a3]}}
  #declare T_Building16a5       = texture { gradient z texture_map {[0.01 T_Building16a4][0.01 T_Building_Lilac]}}
  #declare T_Building16a6       = texture { gradient x texture_map {[0.08 T_Building_White][0.08 T_Building_Blue][0.16 T_Building_Blue][0.16 T_Building_White][0.24 T_Building_White][0.24 T_Building_Blue][0.32 T_Building_Blue][0.32 T_Building_White][0.40 T_Building_White][0.40 T_Building_Blue][0.85 T_Building_Blue][0.85 T_Building_White][0.9999 T_Building_White][0.9999 T_Building_Midnight]}}
  #declare T_Building16a7       = texture { gradient x texture_map {[0.04 T_Building_White][0.04 T_Building_Blue][0.32 T_Building_Blue][0.32 T_Building_White][0.40 T_Building_White][0.40 T_Building_Blue][0.95 T_Building_Blue][0.95 T_Building_White][0.9999 T_Building_White][0.9999 T_Building_Midnight]}}
  #declare T_Building16a        = texture { gradient y texture_map {[0.0300 T_Building16a5][0.0300 T_Building_LightGrey][0.0425 T_Building_LightGrey][0.0425 T_Building16a5] [0.1200 T_Building16a5][0.1200 T_Building_LightGrey][0.1550 T_Building_LightGrey][0.1550 T_Building16a5] [0.1925 T_Building16a5][0.1925 T_Building16a6] [0.1950 T_Building16a6][0.1950 T_Building16a5] [0.2400 T_Building16a5][0.2400 T_Building16a6] [0.2475 T_Building16a6][0.2475 T_Building16a5] [0.3000 T_Building16a5][0.3000 T_Building16a6] [0.3075 T_Building16a6][0.3075 T_Building16a5] [0.4925 T_Building16a5][0.4925 T_Building16a6] [0.5075 T_Building16a6][0.5075 T_Building16a5] [0.5275 T_Building16a5][0.5275 T_Building16a6] [0.5550 T_Building16a6][0.5550 T_Building16a5] [0.8075 T_Building16a5][0.8075 T_Building16a7] [0.8275 T_Building16a7][0.8275 T_Building16a5] [0.8800 T_Building16a5][0.8800 T_Building16a7] [0.9000 T_Building16a7][0.9000 T_Building16a5] [0.9525 T_Building16a5][0.9525 T_Building_Blue]}}
  #declare T_Building16b        = texture { gradient y texture_map {[0.4925 T_Building_Midnight][0.4925 T_Building_Teal] [0.5075 T_Building_Teal][0.5075 T_Building_Midnight] [0.5275 T_Building_Midnight][0.5275 T_Building_Teal] [0.5550 T_Building_Teal][0.5550 T_Building_Midnight] [0.8075 T_Building_Midnight][0.8075 T_Building_Teal] [0.8275 T_Building_Teal][0.8275 T_Building_Midnight] [0.8800 T_Building_Midnight][0.8800 T_Building_Teal] [0.9000 T_Building_Teal][0.9000 T_Building_Midnight]}}
  #declare T_Building17a        = texture { gradient x texture_map {[0.1 T_Building_Midnight][0.1 T_Building_Lilac][0.9 T_Building_Lilac][0.9 T_Building_Midnight]}}
  #declare T_Building17b        = texture { gradient y texture_map {[0.65 T_Building17a][0.65 T_Building_Blue][0.655 T_Building_Blue][0.655 T_Building17a][0.92 T_Building17a][0.90 T_Building_Blue][0.94 T_Building_Blue][0.94 T_Building17a][0.97 T_Building17a][0.97 T_Building_Blue]}}
  #declare T_Building17         = texture { gradient z texture_map {[0.01 T_Building17b][0.01 T_Building_Cyan]}}
  #declare T_Building18a1       = texture { average texture_map { [5 T_Building_Sand][1 T_Building_Bone] }}
  #declare T_Building18a2       = texture { average texture_map { [4 T_Building_Sand][2 T_Building_Bone] }}
  #declare T_Building18a3       = texture { average texture_map { [3 T_Building_Sand][3 T_Building_Bone] }}
  #declare T_Building18a4       = texture { average texture_map { [2 T_Building_Sand][4 T_Building_Bone] }}
  #declare T_Building18a5       = texture { average texture_map { [1 T_Building_Sand][5 T_Building_Bone] }}
  #declare T_Building18a        = texture { gradient y texture_map {[0.05 T_Building_Tan][0.05 T_Building18a1][0.20 T_Building18a1][0.20 T_Building_Tan][0.25 T_Building_Tan][0.25 T_Building18a2][0.40 T_Building18a2][0.40 T_Building_Tan][0.45 T_Building_Tan][0.45 T_Building18a3][0.60 T_Building18a3][0.60 T_Building_Tan][0.65 T_Building_Tan][0.65 T_Building18a4][0.80 T_Building18a4][0.80 T_Building_Tan][0.85 T_Building_Tan][0.85 T_Building18a5][1.00 T_Building18a5]} translate y*-0.05 }
  #declare T_Building18b        = texture { gradient x texture_map {[0.05 T_Building_Lilac][0.05 T_Building18a][0.95 T_Building18a][0.95 T_Building_Lilac]}}
  #declare T_Building18         = texture { gradient z texture_map {[0.001 T_Building18b][0.001 T_Building_Tan][0.05 T_Building_Tan][0.05 T_Building_Sand]}}
#end

//------------------------------------------------------------------------------------------------------------

#declare Building11 = union {  // Wedge-shaped building
  box { <0,0,-2>, <115,150,2> texture { T_Building11a8 scale <11,150,1> }
    rotate y*-90 scale <1,1.1,1>
  }
  prism { linear_sweep linear_spline -4, 4, 5,
    <30,0>, <70,200>, <-70,200>, <-30,0>, <30,0> rotate x*-90
    texture { T_Building11a9 scale <10,200,1> }
  }
  prism { linear_sweep linear_spline -0.5, 0.5, 5,
    <0,92>, <0,200>, <-56,200>, <-32,94>, <0,92> rotate x*-90
    texture { T_Building11a9 scale <10,200,1> }
    rotate y*-90
    no_shadow
  }
  #if (Quick=0) // fake shadow from crosspiece
    prism { linear_sweep linear_spline -4.002, -4.001, 5,
      <0,92>, <0,200>, <-56,200>, <-32,94>, <0,92> rotate x*-90
      translate y*-92
      matrix <0.75,0.5,0, 0,1,0, 0,0,1, 0,0,0>
      translate y*92
      texture { pigment { colour rgbt <0,0,0.125,0.9> }}
      rotate y*180
    }
  #end
  scale <1,0.9,1> translate y*20
}

//------------------------------------------------------------------------------------------------------------

#declare Building12 = union { // wall behind "stadium"
  box { <-1,-20,-1>, <1,20,200> texture { T_Building_Ash }}
  cylinder { <0,21,0>, <0,21,200>, 1 texture { T_Building_MedGrey }}
  cylinder { <0,23,0>, <0,23,200>, 1 texture { T_Building_White }}
}

//------------------------------------------------------------------------------------------------------------

#declare Building13Arm = union {
  intersection {
    difference {
      cylinder { <-0.5,0,0>, <0.5,0,0>, 18 }
      cylinder { <-0.51,0,0>, <0.51,0,0>, 17 }
    }
    box { <-0.51,0,0>, <0.51,18.01,-18.01> }
    bounded_by { box { <-0.5,0,0>, <0.5,18,-18> }}
    texture { T_Building_Tan }
    scale <1,1.5,1>
  }
  box { <-0.5,5,-18>, <0.5,6,-28> texture { T_Building_Tan }}
  box { <-0.5,5,-18>, <0.5,7,0> texture { T_Building_Cyan }}
  union {
    sphere { <0,5.5,-28.5>, 0.5 }
    cone { <0,5.5,-28.5>, 0.5, <0,4.0,-28.5>, 0 }
    texture { T_Building_Orange }
  }
  sphere { <0,9.250000,-16.021470>, 0.5 scale <1,1.5,1> texture { T_Building_Orange }}
  sphere { <0,11.570177,-13.788800>, 0.5 scale <1,1.5,1> texture { T_Building_Orange }}
}
  

#declare Building13 = union { // Carousel?
  cylinder { <0,0,0>, <0,-5,0>, 21 texture { T_Building_Sand }}
  #declare foo=0; #while (foo < 20) object { Building13Arm rotate y*18*foo } #declare foo=foo+1; #end
  #declare foo=0; #while (foo < 36) sphere { <0,25.5,-10>, 0.5 texture { T_Building_Orange } rotate y*10*foo } #declare foo=foo+1; #end
  union {
    cone { <0,23,0>, 0, <0,27,0>, 10 texture { T_Building_Sand }}
    cylinder { <0,27,0>, <0,28,0>, 10 texture { T_Building_Sand }}
    cone { <0,31,0>, 0, <0,28,0>, 10 texture { T_Building_Tan }}
    cylinder { <0,28,0>, <0,31,0>, 4 texture { T_Building_Sand }}
    sphere { <0,31,0>, 1 scale <2.666667,1,2.666667> texture { T_Building_Cyan }}
    sphere { <0,32,0>, 1 texture { T_Building_Orange }}
    cylinder { <0,27,0>, <0,20,0>, 5 texture { T_Building_Cyan }}
    cylinder { <-4.5,20,0>, <-4.5,6.5,0>, 0.5 texture { T_Building_Cyan }}
    cylinder { <4.5,20,0>, <4.5,6.5,0>, 0.5 texture { T_Building_Cyan }}
    sphere { <0,29.5,-4>,1 scale <1.5,1,1> rotate y*40  texture { T_Building_Orange }}
    sphere { <0,29.5,-4>,1 scale <1.5,1,1>              texture { T_Building_Red }}
    sphere { <0,29.5,-4>,1 scale <1.5,1,1> rotate y*-40 texture { T_Building_Red }}
    translate y*-2
  }
  rotate y*-35
}

//------------------------------------------------------------------------------------------------------------

#declare Building14 = union { // Left of wedge
  box { <-50,0,-6>, <50,150,6> texture { T_Building14a scale <8.11,150,1> }}
  box { <0,0,0>, <100,100,1> texture { T_Building14b scale 100 } rotate y*-90 translate <49,0,6> }
  box { <0,0,0>, <100,75,1> texture { T_Building14b scale <100,75,1> } rotate y*-90 translate <50,0,7> }
  box { <-15,0,-5>, <5,30,5> texture { T_Building14c scale <1,30,1> } translate y*150 }
  cylinder { <-48,150,0>, <-48,190,0>, 0.5 texture { T_Building_White }}
  cylinder { <-37,150,0>, <-37,200,0>, 0.75 texture { T_Building_Blue }}
  cylinder { <-26,150,0>, <-26,201,0>, 0.75 texture { T_Building_Blue }}
}

//------------------------------------------------------------------------------------------------------------

#declare Building15 = union { // Railed building left of Building14
  box { <0,0,0>, <-100,175,100> texture { T_Building15a  translate x*-0.11 scale <9,175,100> }}
  box { <0,175,0>, <-100,185,0.1> texture { T_Building15b scale 10 translate y*175 }}
  box { <0,175,0>, <0.1,185,100> texture { T_Building15b scale 10 translate y*175 rotate y*90 }}
}

//------------------------------------------------------------------------------------------------------------

#declare Building16 = union { // The really tall building
  box { <-10,-40,-10>, <10,200,10>
    texture { T_Building16a translate <-0.5,0,-0.5> scale <20.001,200,20> }
  }
  union {
    box { <0,185,-10>, <5,95,-12> }
    torus { 2, 0.5 rotate x*-90 translate <2.5,95,-11.5> }
    cylinder { <2.5,95,-12>, <2.5,95,-10>, 2 }
    cylinder { <2.5,95,-11.5>, <2.5,95,-10>, 2 }
    cone { <2.5,95,-10>, 2, <2.5,85,-10>, 0 }
    cylinder { <2.5,95,-10>, <2.5,65,-10>, 0.5 }
    texture { T_Building16b scale <1,200,1>}
  }
  union {
    cylinder { <10,-10,-1>, <10,33,-1>, 0.5 }
    cone { <10,33,-1>, 0.5, <10,35,-1>, 0 }
    cone { <10,42,-1>, 0, <10,44,-1>, 0.5 }
    cylinder { <10,44,-1>, <10,118,-1>, 0.5 }
    cone { <10,118,-1>, 0.5, <10,120,-1>, 0 }
    texture { T_Building_Midnight }
  }
  union {
    box { <10,61,2>, <10.001,84,5> }
    box { <10,104,2>, <10.001,124,5> }
    box { <10,128,2>, <10.001,140,5> }
    texture { T_Building_Teal }
  }
  box { <10,62,-10>, <10.001,59,-1> texture { T_Building_Lilac }}
  box { <-9,-30,10>, <9,155,14> texture { T_Building_DustyBlue }}
  no_shadow
}

//------------------------------------------------------------------------------------------------------------

#declare Building17 = box { <-20,0,0>, <20,200,40>   // Building behind the tall one
  texture { T_Building17 translate <-0.5,0,0> scale <3.5,200,40> }
  matrix < 1,0,0, 0,1,0, 0,-0.25,1, 0,0,0>
}

//------------------------------------------------------------------------------------------------------------

#declare Building18 = box { <-15,0,0>, <15,174,40>   // Building to the left of #17
  texture { T_Building18 translate <-0.5,0,0> scale <6,29,40> }
}

//------------------------------------------------------------------------------------------------------------

#declare Building19 = union { // Spire behind the "temple"
  difference {
    cone { <0,0,0>, 20, <0,40,0>, 0 }
    torus { 20, 19 scale <1,3.15,1> translate y*60 }
    bounded_by { cone { <0,0,0>, 20, <0,35,0>, 4 }}
    texture { T_Building_DustyBlue }
  }
  union {
    cone { <0,35,0>, 2.5, <0,42,0>, 1 }
    cone { <0,42,0>, 1, <0,75,0>, 0 }
    texture { T_Building_Silver }
  }
  cylinder { <0,0,0>, <0,-50,0>, 16 texture { T_Building_LightGrey }}
  translate y*50
  scale <3.25,3,3.25>
}

//------------------------------------------------------------------------------------------------------------

#declare Building20 = union { // Tall needle left of the temple
  cylinder { <0,0,0>, <0,200,0>, 1.5 }
  cone { <0,200,0>, 1.5, <0,280,0>, 0 }
  cylinder { <0,0,-2>, <0,200,-2>, 3 }
  cylinder { <0,0,2>, <0,190,2>, 2 }
  cylinder { <0,0,-5>, <0,199,-5>, 1 texture { T_Building_Ash }}
  texture { T_Building_MedGrey }
  rotate y*30
  no_shadow
}

//------------------------------------------------------------------------------------------------------------

#ifndef (FullScene)
  object { Building11 rotate y*35 }
  camera { location <0,150,-700> look_at <0,150,0> angle 37.5 }
  light_source { <-1000,1000,-1000> colour rgb <1,1,1> }
  light_source { <500,30,-1000> colour rgb <1,1,1> }
#end
