#ifndef (Quick) #declare Quick=0 #end

#declare T_Building_LightBlue   = texture { pigment { colour rgb <0.63,0.77,0.85> }}
#declare T_Building_LightBlue2  = texture { pigment { colour rgb <0.59,0.71,0.825> }}
#declare T_Building_SkyBlue     = texture { pigment { colour rgb <0.55,0.65,0.8> }}
#declare T_Building_DustyBlue   = texture { pigment { colour rgb <0.35,0.45,0.6> }}
#declare T_Building_MedBlue     = texture { pigment { colour rgb <0.3,0.3,0.6> }}
#declare T_Building_Midnight    = texture { pigment { colour rgb <0.15,0.25,0.4> }}
#declare T_Building_Teal        = texture { pigment { colour rgb <0.0,0.25,0.22> }}
#declare T_Building_Blue        = texture { pigment { colour rgb <0,0.05,0.25> }}
#declare T_Building_LightGrey   = texture { pigment { colour rgb <0.55,0.5,0.45> }}
#declare T_Building_MedGrey     = texture { pigment { colour rgb <0.25,0.25,0.25> }}
#declare T_Building_DarkGrey    = texture { pigment { colour rgb <0.12,0.12,0.12> }}
#declare T_Building_Clear       = texture { pigment { colour rgbt <1,1,1,1> }}
#declare T_Building_Red         = texture { pigment { colour rgb <0.5,0,0> }}
#declare T_Building_BrightRed   = texture { pigment { colour rgb <1.0,0,0> }}
#declare T_Building_Yellow      = texture { pigment { colour rgb <1,1,0> }}

#if (Quick)
  #declare T_Building_White     = texture { pigment { colour rgb <1,1,1> }}
  #declare T_Building_Bone      = texture { pigment { colour rgb <1,1,0.9> }}
  #declare T_Building_OffWhite  = texture { pigment { colour rgb <0.9,0.9,0.9> }}
  #declare T_Building_Sand      = texture { pigment { colour rgb <0.9,0.8,0.7> }}
  #declare T_Building_Ash       = texture { pigment { colour rgb <0.8,0.8,0.8> }}
  #declare T_Building_Tan       = texture { pigment { colour rgb <0.6,0.4,0.08> }}
  #declare T_Building_Brown     = texture { pigment { colour rgb <0.4,0.2,0.06> }}
  #declare T_Building_Cyan      = texture { pigment { colour rgb <0.3,0.5,0.6> }}
  #declare T_Building_Lilac     = texture { pigment { colour rgb <0.8,0.8,0.9> }}
  #declare T_Building_Orange    = texture { pigment { colour rgb <1,0.25,0> }}
  #declare T_Building_Silver    = texture { pigment { colour rgb <0.95,1,1> }}
  #declare T_Building_Copper    = texture { pigment { colour rgb <1,0.5,0> }}
  #declare T_Building21a        = texture { T_Building_Ash }
  #declare T_Building21b        = texture { T_Building_Ash }
  #declare T_Building21c        = texture { T_Building_Ash }
  #declare T_Building22a        = texture { T_Building_OffWhite }
  #declare T_Building22b        = texture { T_Building_Ash }
  #declare T_Building22c        = texture { T_Building_Ash }
  #declare T_Building25a        = texture { T_Building_LightBlue2 }
#else
  #declare T_Building_White     = texture { pigment { quilted colour_map { [0.4 rgb <1,1,1>][0.6 rgb <0.5,0.5,0.5>] } warp { turbulence 1.0 } } scale 0.01 }
  #declare T_Building_Bone      = texture { pigment { bozo colour_map {[0.0 rgb <0.95,0.95,0.9>][1.0 rgb <0.7,0.7,0.8>]} scale <0.5,10,0.5> }}
  #declare T_Building_OffWhite  = texture { pigment { bozo colour_map { [0.0 rgb <0.9,0.9,0.9>][0.5 rgb <0.8,0.8,0.9>][0.0 rgb <0.9,0.9,0.9>] } warp { turbulence 1.0 } } scale 0.01 }
  #declare T_Building_Sand      = texture { pigment { granite colour_map { [0.4 rgb <0.9,0.8,0.7>][0.6 rgb <0.7,0.6,0.5>] }}}
  #declare T_Building_Ash       = texture { pigment { bozo colour_map { [0.0 rgb <0.8,0.8,0.8>][1.0 rgb <0.75,0.75,0.75>] }}}
  #declare T_Building_Tan       = texture { pigment { agate colour_map { [0.4 rgb <0.6,0.4,0.08>][0.6 rgb <0.4,0.26,0.04>] }}}
  #declare T_Building_Brown     = texture { pigment { agate colour_map { [0.4 rgb <0.4,0.2,0.06>][0.6 rgb <0.2,0.4,0.02>] }}}
  #declare T_Building_Cyan      = texture { pigment { crackle colour_map { [0.55 rgb <0.3,0.5,0.6>][0.75 rgb <0.15,0.325,0.45>] }}}
  #declare T_Building_Lilac     = texture { pigment { bozo colour_map { [0.0 rgb <0.8,0.8,0.9>][1.0 rgb <0.75,0.75,0.85>] }}}
  #declare T_Building_Orange    = texture { pigment { colour rgb <1,0.25,0> } finish { ambient 0.4 }}
  #declare T_Building_Silver    = texture { pigment { colour rgb <0.95,0.95,1> } finish { reflection 0.6 metallic brilliance 4 ambient 0.25 diffuse 0.5 specular 0.8 roughness 1/80 }}
  #declare T_Building_Copper    = texture { pigment { colour rgb <1,0.5,0> } finish { ambient 0.20 diffuse 0.55 brilliance 4.5 specular 1.0 roughness 0.011 metallic reflection 0.6 } normal { bumps 0.25 scale 0.5 }}
  #declare T_Building21a1       = texture { gradient y texture_map {[0.390 T_Building_Ash][0.390 T_Building_Blue][0.424 T_Building_Blue][0.424 T_Building_Ash][0.500 T_Building_Ash][0.500 T_Building_MedBlue][0.535 T_Building_MedBlue][0.535 T_Building_Ash][0.555 T_Building_Ash][0.555 T_Building_LightBlue][0.560 T_Building_MedBlue][0.560 T_Building_Ash][0.585 T_Building_Ash][0.585 T_Building_Midnight][0.620 T_Building_Midnight][0.620 T_Building_Ash][0.625 T_Building_Ash][0.625 T_Building_DustyBlue][0.660 T_Building_DustyBlue][0.660 T_Building_Ash][0.665 T_Building_Ash][0.665 T_Building_Midnight][0.700 T_Building_Midnight][0.700 T_Building_Ash][0.715 T_Building_Ash][0.715 T_Building_Midnight][0.750 T_Building_Midnight][0.750 T_Building_Ash][0.835 T_Building_Ash][0.835 T_Building_DustyBlue][0.840 T_Building_DustyBlue][0.840 T_Building_Ash][0.870 T_Building_Ash][0.870 T_Building_DustyBlue][0.905 T_Building_DustyBlue][0.905 T_Building_Ash]}}
  #declare T_Building21a        = texture { gradient x texture_map {[0.05 T_Building_White][0.05 T_Building21a1][0.95 T_Building21a1][0.95 T_Building_White]}}
  #declare T_Building21b1       = texture { gradient y texture_map {[0.390 T_Building_Ash][0.390 T_Building_Blue][0.424 T_Building_Blue][0.424 T_Building_Ash][0.500 T_Building_Ash][0.500 T_Building_MedBlue][0.535 T_Building_MedBlue][0.535 T_Building_Ash][0.555 T_Building_Ash][0.555 T_Building_LightBlue][0.560 T_Building_MedBlue][0.560 T_Building_Ash][0.585 T_Building_Ash][0.585 T_Building_Midnight][0.620 T_Building_Midnight][0.620 T_Building_Ash][0.625 T_Building_Ash][0.625 T_Building_DustyBlue][0.660 T_Building_DustyBlue][0.660 T_Building_Ash][0.665 T_Building_Ash][0.665 T_Building_Midnight][0.700 T_Building_Midnight][0.700 T_Building_Ash][0.715 T_Building_Ash][0.715 T_Building_Midnight][0.750 T_Building_Midnight][0.750 T_Building_Ash][0.835 T_Building_Ash][0.835 T_Building_DustyBlue][0.840 T_Building_DustyBlue][0.840 T_Building_Ash][0.870 T_Building_Ash][0.870 T_Building_DustyBlue][0.905 T_Building_DustyBlue][0.905 T_Building_LightBlue][0.940 T_Building_LightBlue][0.940 T_Building_Ash]}}
  #declare T_Building21b        = texture { gradient x texture_map {[0.05 T_Building_White][0.05 T_Building21b1][0.95 T_Building21b1][0.95 T_Building_White]}}
  #declare T_Building21c        = texture { gradient z texture_map {[0.001 T_Building_White][0.001 T_Building_LightGrey]}}
  #declare T_Building22a        = texture { gradient y texture_map {[0.280 T_Building_OffWhite][0.280 T_Building_DustyBlue][0.335 T_Building_DustyBlue][0.335 T_Building_OffWhite][0.425 T_Building_OffWhite][0.425 T_Building_DustyBlue][0.460 T_Building_DustyBlue][0.460 T_Building_OffWhite][0.735 T_Building_OffWhite][0.735 T_Building_DustyBlue][0.760 T_Building_DustyBlue][0.760 T_Building_OffWhite][0.765 T_Building_OffWhite][0.765 T_Building_DustyBlue][0.775 T_Building_DustyBlue][0.775 T_Building_OffWhite]}}
  #declare T_Building22b1       = texture { gradient x texture_map {[0.25 T_Building_DustyBlue][0.25 T_Building_White][0.75 T_Building_White][0.75 T_Building_DustyBlue]}}
  #declare T_Building22b        = texture { gradient y texture_map {[0.2 T_Building22b1][0.2 T_Building_Ash]}}
  #declare T_Building22c        = texture { gradient y texture_map {[0.19 T_Building_Ash][0.19 T_Building_DarkGrey][0.21 T_Building_DarkGrey][0.21 T_Building_Ash]}}
  #declare T_Building25a        = texture { bozo texture_map { [0.0 T_Building_LightBlue][0.5 T_Building_LightBlue2][1.0 T_Building_LightBlue] } scale <20,200,20> warp { turbulence 0.5 }}

#end

//------------------------------------------------------------------------------------------------------------

#declare Building21 = union { // Left/backmost building
  box { <0,0,0>, <-50,200,1> texture { T_Building21a scale <10,200,1> }}
  box { <-49.5,0,-5>, <-50.5,200,0> texture { T_Building21c scale <1,1,5> }}
  box { <-50,0,0>, <-100,200,1> texture { T_Building21b scale <10,200,1> }}
  box { <-100,0,0>, <-200,200,1> texture { T_Building21a scale <10,200,1> }}
  rotate y*-90
}

//------------------------------------------------------------------------------------------------------------


#declare Building22_Face = union {
  prism { linear_spline conic_sweep 1, 0, 4, <-1,-1>, <1,-1>, <0,0>, <-1,-1> 
    scale <40,20,40> texture { T_Building_White }
  }
  box { <-40,20,-40>, <40,22,40> texture { T_Building_Blue }}
  prism { linear_spline conic_sweep 1, 0, 4, <-1,-1>, <1,-1>, <0,0>, <-1,-1> 
    rotate x*180
    scale <40,30,40> translate y*52 texture { T_Building22b scale <22,20,22> }
  }
  prism { linear_spline conic_sweep 1, 0, 4, <-1,-1>, <1,-1>, <0,0>, <-1,-1> 
    rotate x*180
    scale <40,30,40> translate y*30 texture { T_Building22b scale <22,20,22> }
    rotate x*180 translate y*35 
  }
  box { <-40,35,-40>, <40,37,40> texture { T_Building_Blue }}
  prism { linear_spline conic_sweep 1, 0, 4, <-1,-1>, <1,-1>, <0,0>, <-1,-1> 
    rotate x*180
    scale <40,20,40> translate y*55 texture { T_Building_White }
  }
  sphere { <-20,10,-20>, 2 texture { T_Building_DustyBlue }}
  sphere { < -7,10,-20>, 2 texture { T_Building_DustyBlue }}
  sphere { <  7,10,-20>, 2 texture { T_Building_DustyBlue }}
}

#declare Building22_Spire = union {
  prism { linear_spline conic_sweep 0, 1, 4,
    <0,0.5>, <0.433,-0.25>, <-0.433,-0.25>, <0,0.5>
    rotate x*180 translate y*1 scale <15,100,15>
    texture { T_Building_DarkGrey }
  }
  prism { linear_spline conic_sweep 0, 1, 5,
    <0,0.5>, <0.433,-0.25>, <-0.300,-0.25>, <-0.380,-0.155> <0,0.5>
    rotate x*180 translate y*1 scale <15.001,100.001,15.001>
    texture { T_Building22c scale <1,110,1> }
  }
  rotate y*190 
  scale <1,1.2,1>
}

#declare Building22 = union { // New York World's Fair tower?
  cylinder { <0,0,0>, <0,200,0>, 15 texture { T_Building22a scale <1,150,1> translate y*50 }}
  #declare foo=0;
  #while (foo < 9)
    cylinder { <0,0,-15.5>, <0,200,-15.5>, 0.5 rotate y*40*foo texture { T_Building_White }}
    #declare foo=foo+1;
  #end
  cylinder { <0,125,0>, <0,127,0>, 19 texture { T_Building_Sand }}
  #declare foo=0;
  #while (foo < 4)
    object { Building22_Face translate y*195 rotate y*90*foo }
    #declare foo=foo+1;
  #end
  object { Building22_Spire translate y*240 }
}

//------------------------------------------------------------------------------------------------------------

#declare Building23 = union { // Round thing to the left of (and behind) the World's Fair tower
  #declare foo=0;
  #while (foo < 24)
    prism { linear_sweep linear_spline -0.25, 0.5, 12,
      <0,0>, <0,132>, <-2,138>, <-6,140>, <-11,139>, <-13,136>, <-11,132>, <-7,132>, <-5,131>, <-4,127>, <-4,0>, <0,0>
      rotate <-90,-90,0> translate z*-40 rotate y*foo*15 texture { T_Building_Silver }}
    #declare foo=foo+1;
  #end
  sphere { <0,144,0>, 11 scale <4,1,4> texture { T_Building_Silver }}
  cylinder { <0,130,0>, <0,138,0>, 42 texture { T_Building_Sand }}
  cylinder { <0,115,0>, <0,113,0>, 42 texture { T_Building_Sand }}
  cylinder { <0,100,0>, <0, 98,0>, 42 texture { T_Building_Sand }}
  cylinder { <0, 85,0>, <0, 83,0>, 42 texture { T_Building_White }}
  sphere { <0,70,0>, 4 scale <10.5,1,10.5> texture { T_Building_Silver }}
  cylinder { <0,70,0>, <0,65,0>, 42 texture { T_Building_DustyBlue }}
  cylinder { <0,65,0>, <0,0,0>, 42 texture { T_Building_Bone }}
}

//------------------------------------------------------------------------------------------------------------

#declare Building24 = union { // Tall building behind building #23
  box { <-25,0,-25>, <25,200,25> texture { T_Building_White }}
  box { <-23,0,-25>, <-15,210,-26> texture { T_Building_Blue }}
  box { <23,0,-25>, <15,210,-26> texture { T_Building_Blue }}
  box { <-5,120,-25>, <5,140,-25.001> texture { T_Building_DustyBlue }}
  scale <1,2,1>
  rotate y*-90
}

//------------------------------------------------------------------------------------------------------------


#declare Building25MouldingPart = union {
  prism { linear_spline linear_sweep -1, 1, 20,
    <0,0>, <0,4>, <0.2,7.6>, <0.8,11.3>, <1.8,14.8>, <3.1,18.4>, <4.5,21.4>, <6.2,24.3>,
    <8,27.2>, <10,30>, <10,25>, <8.1,21.9>, <6.5,18.9>, <5.1,16>, <3.9,12.9>,
    <3.1,10.1>, <2.5,7>, <2.1,3.7>, <2,0>, <0,0>
    texture { T_Building_Tan }
  }
  prism { linear_spline linear_sweep -0.01, 0.01, 19,
    <5,0>, <5.1,1.9>, <5.4,3.7>, <5.8,5.5>, <6.4,7.4>, <7.1,9.1>, <8,10.8>, <8.9,12.4>,
    <10,14>, <10,25>, <8.1,21.9>, <6.5,18.9>, <5.1,16>, <3.9,12.9>, <3.1,10.1>,
    <2.5,7>, <2.1,3.7>, <2,0>, <5,0>
    texture { T_Building_SkyBlue }
  }
  rotate x*-90
}

#declare Building25FrontMoulding = union {
  #declare foo = 0;
  #declare hpos = -110;
  #while (foo < 11)
    object { Building25MouldingPart rotate y*180 translate <hpos+10,90,0> }
    object { Building25MouldingPart translate <hpos+10,90,0> }
    #declare hpos = hpos + 20;
    #declare foo=foo+1;
  #end
}

#declare Building25SideMoulding = union {
  #declare foo = 0;
  #declare hpos = 0;
  #while (foo < 11)
    object { Building25MouldingPart rotate y*180 translate <hpos+10,90,-110> }
    object { Building25MouldingPart translate <hpos+10,90,-110> }
    #declare hpos = hpos + 20;
    #declare foo=foo+1;
  #end
  rotate y*-90
}

#declare Building25Moulding2 = intersection {
  box { <-115,0,-5>, <115,5,225> texture { T_Building_SkyBlue }}
  plane { -z, 0 rotate x*45 translate <0,1,-5> }
  plane { z, 0 rotate x*-45 translate <0,1,225> }
  plane { -x, 0 rotate z*-45 translate <-115,1,0> }
  plane { x, 0 rotate z*45 translate <115,1,0> }
  bounded_by { box { <-115,0,-5>, <115,5,225> }}
  texture { T_Building_Sand }
}

#declare Building25Middle = union {
  box { <-110,0,0>, <110,90,220> texture { T_Building25a }}
  object { Building25FrontMoulding }
  object { Building25SideMoulding }
  box { <-110,90,0>, <110,120,220> texture { T_Building_MedBlue }}
  box { <-115,120,-5>, <115,123,225> texture { T_Building_BrightRed }}
  object { Building25Moulding2 rotate z*180 translate y*90 }
  object { Building25Moulding2 scale <1,0.5,1> rotate z*180 translate y*65 }
  object { Building25Moulding2 scale <1,0.5,1> translate y*65 }
  box { <70,65,0>, <60,90,-0.001> texture { T_Building_Tan }}
  box { <-70,65,0>, <-60,90,-0.001> texture { T_Building_Tan }}
  union {
    box { <-2,20,0>, <2,22,-0.001> texture { T_Building_Tan }}
    box { <-10,-10,0>, <10,20,-0.001> texture { T_Building_Tan }}
    box { <-9,-10,-0.001>, <9,17,-0.002> texture { T_Building_Sand }}
    box { <-8,-10,-0.002>, <8,16,-0.003> texture { T_Building_Tan }}
    cylinder { <0,2,-0.003>, <0,2,-0.004>, 6 scale <1,1.5,1> pigment { colour rgb <0,0,0> }}
    cylinder { <0,18,0>, <0,18,-0.001>, 1.5 scale <1,1.5,1> texture { T_Building_Tan }}
    scale <1.5,1,1>
    translate y*20
  }
  scale <0.75,1,1.2> 
}

#declare Building25TopPart = union {
  difference {
    box { <-60,20,-60>, <60,100,60> }
    cylinder { <-61,0,-98>, <61,0,-98>, 85 scale <1,90/85,1> translate y*100 }
    cylinder { <-61,0,-98>, <61,0,-98>, 85 scale <1,90/85,1> translate y*100 rotate y*90}
    cylinder { <-61,0,-98>, <61,0,-98>, 85 scale <1,90/85,1> translate y*100 rotate y*180}
    cylinder { <-61,0,-98>, <61,0,-98>, 85 scale <1,90/85,1> translate y*100 rotate y*270}
    bounded_by { box { <-60,20,-60>, <60,100,60> }}
    texture { T_Building_White scale <1,20,1> }
  }
  box { <-15,90,-15>, <15,88,15> pigment { colour rgb <0,0,0> }}
  box { <-14,100,-14>, <14,98,14> pigment { colour rgb <0,0,0> }}
  sphere { < 8,94,-13>, 2 texture { T_Building_Red }}
  sphere { <-8,94,-13>, 2 texture { T_Building_Red }}
  sphere { <13,94, -8>, 2 texture { T_Building_Red }}
  sphere { <13,94,  8>, 2 texture { T_Building_Red }}
  torus { 15, 1.5 translate y*101.5 texture { T_Building_Red }}
  torus { 15, 1.5 translate y*104.5 pigment { colour rgb <0,0,0> }}
}

#declare Building25TopSupport = union {
  difference {
    box { <-50,0,-50>, <50,20,-45> }
    cylinder { <0,0,-50.001>, <0,0,-44.999>, 10 scale <1,1.5,1> translate x*-50 }
    cylinder { <0,0,-50.001>, <0,0,-44.999>, 10 scale <1,1.5,1> translate x* 50 }
    cylinder { <0,0,-50.001>, <0,0,-44.999>, 15 scale <7/3,1,1> }
    bounded_by { box { <-50,0,-50>, <50,20,-45> }}
    texture { T_Building_DustyBlue }
  }
  cylinder { <-37,14,-50>, <-37,14,-50.001>, 4 texture { T_Building_Blue }}
  cylinder { < 37,14,-50>, < 37,14,-50.001>, 4 texture { T_Building_Blue }}
}

#declare Building25TopDecoration = union {
  #declare foo=-43;
  #while (foo < 43)
    sphere { <foo,32,-43>, 1.5 texture { T_Building_Red }}
    #declare foo = foo + (86/11);
  #end
  difference {
    union {
      cylinder { <-3,85,-12>, <-3,85,-27>, 3 }  cylinder { <3,85,-12>, <3,85,-27>, 3 }
      cylinder { <-3,79,-12>, <-3,79,-27>, 3 }  cylinder { <3,79,-12>, <3,79,-27>, 3 }
      intersection {
        cylinder { <0,0,-12>, <0,0,-27>, 3 scale <1,29/3,1> }
        box { <-3.001,0,-11.999>, <3.001,-29.001,-27.001> }
        bounded_by { box { <-3,0,-12>, <3,-29,-27> }}
        translate y*82
      }
    }
    cylinder { <-7,0,-98>, <7,0,-98>, 84.999 scale <1,90/85,1> translate y*100 }
    texture { T_Building_BrightRed }
  }
  cylinder { <0,82,-14>, <0,82,-16>, 3 texture { T_Building_Yellow }}
}

#declare Building25CopperTop = union { // Outlasts the Energiser?
  #declare foo=0;
  #declare r = 16.5;
  #while (foo < 50)
    cone { <0,foo,0>, r-2, <0,foo+2.5,0>, r }
    cone { <0,foo+2.5,0>, r, <0,foo+5,0>, r-2 }
    #declare r = r - 1;
    #declare foo = foo + 5;
  #end
  torus { 5, 1.5 translate y*51.5 pigment { colour rgb <0,0,0>  }}
  sphere { <0,57,0>, 6.5 }
  cone { <0,60,0>, 5, <0,64,0>, 7.5 }
  torus { 6, 1.5 translate y*64 pigment { colour rgb <0,0,0> }}
  sphere { <0,69,0>, 5 texture { T_Building_DustyBlue }}
  cylinder { <0,68.5,0>, <0,69.5,0>, 7 texture { T_Building_Copper }}
  cylinder { <0,72,0>, <0,73,0>, 5 texture { T_Building_Silver }}
  sphere { <0,77,0>, 4 texture { T_Building_DustyBlue }}
  sphere { <0,82,0>, 3 texture { T_Building_Copper }}
  sphere { <0,44,0>, 2 texture { T_Building_DustyBlue } scale <1,2,1> }
  sphere { <0,93.5,0>, 1.5 pigment { colour rgb <0,0,0> }}
  cone { <0,93.5,0>, 1, <0,130,0>, 0 pigment { colour rgb <0,0,0> }}
  texture { T_Building_Copper }
  scale <1,1.25,1>
  translate y*106
}

#declare Building25Top = union {
  object { Building25TopPart }
  object { Building25TopDecoration }
  object { Building25TopDecoration rotate y*-90 }
  object { Building25TopDecoration rotate y*180 }
  object { Building25TopSupport }
  object { Building25TopSupport rotate y*-90 }
  object { Building25TopSupport rotate y*180 }
  object { Building25TopSupport rotate y* 90 }
  object { Building25CopperTop }
  scale <1.4,1,1.4>
  translate <0,122, 90>
}

#declare Building25Bottom = union {
  box { <-100,0,0>, <150,6,1> texture { T_Building_Tan }}
  box { <-100,6,0>, <150,10,1> }
  box { <-100,14,0>, <150,15,0> }
  #declare foo=-100;
  #while (foo < 150)
    sphere { <foo,6,1>, 2 scale <1,2,1> }
    #declare foo=foo+10;
  #end
  box { <-4,0,0>, <0,7,-2> texture { T_Building_Sand }}
  box { <5,0,0>, <9,2,-2> texture { T_Building_Sand }}
  box { <14,0,0>, <18,7,-2> texture { T_Building_Sand }}
  texture { T_Building_Brown }
  translate <20,0,-20>
}

#declare Building25 = union { // The temple (probably the most complex building in the scene)
  object { Building25Top }
  object { Building25Middle }
  object { Building25Bottom }
}

//------------------------------------------------------------------------------------------------------------

#declare T_Building_Lavender = texture { pigment { colour rgb <0.55,0.45,0.75> }}


#declare Building26Segment = union {
  box { <-20,0,0>, <20,100,1> texture { T_Building_Lavender }}
  box { <-20,100,-1>, <20,110,1> texture { T_Building_MedBlue }}
  box { <-20,46,0>, <20,50,-1> texture { T_Building_Brown }}
  box { <-20,46,0>, <20,43,-1> texture { T_Building_Sand }}
  box { <-20,0,0>, <20,5,-1> texture { T_Building_Sand }}
  box { <-20,5,0>, <-17.5,43,-1> texture { T_Building_Sand }}
  box { <20,5,0>, <17.5,43,-1> texture { T_Building_Sand }}
  box { <-2.5,5,0>, <2.5,43,-1> texture { T_Building_Sand }}
  intersection {
    difference {
      cylinder { <0,100,0>, <0,100,-1>, 50 scale <0.46,1,1> }
      cylinder { <0,100,0.001>, <0,100,-1.001>, 44 scale <0.37,1,1> }
    }
    box { <-20.001,100,0.001>, <20.001,49.999,-1.001> }
    bounded_by { box { <-20,100,0>, <20,50,-1> }}
    texture { T_Building_Yellow }
  }
  intersection {
    box { <-20,100,0.001>, <20,50,-1.001> }
    union {
      cylinder { <0,100,0>, <0,100,-1>, 16 scale <0.25,1,1> }
      cylinder { <-20,56,0>, <-20,56,-1>, 3 }
      cylinder { <20,56,0>, <20,56,-1>, 3 }
    }
    bounded_by { box { <-20,50,0>, <20,100,-1> }}
    texture { T_Building_Yellow }
  }
  translate x*-20
}

#declare Building26 = union { // The wall in front of (and to the left of) the temple.
  #declare foo=0;
  #while (foo > -560)
    object { Building26Segment translate x*foo }
    #declare foo=foo-40;
  #end
  rotate y*-125
  no_shadow
}

//------------------------------------------------------------------------------------------------------------

#ifndef (FullScene)
  object { Building26 rotate y*35 }
  camera { location <110,100,-700> look_at <110,100,0> angle 37.5 }
  light_source { <-1000,1000,-1000> colour rgb <1,1,1> }
  light_source { <500,30,-1000> colour rgb <1,1,1> }
  background { colour rgb <0.25,0.5,1.0> }
#end
