#declare Quick=0         // Use nonlayered/nonreflective textures
#declare QuickLights=1   // Change to 0 to use area lights
#declare UseFilter=1     // Change to 1 to simulate film grain

#declare FullScene=1

#default { finish { ambient 0.3 diffuse 0.6 }}

#include "sky.inc"
#include "ground.inc"
#include "wall.inc"
#include "dais.inc"
#include "arch.inc"
#include "buildng1.inc"
#include "buildng2.inc"
#include "buildng3.inc"

object { Wall1 scale <0.75,0.95,1> translate x*20 }
object { Wall2 scale <0.9,1,1> translate x*180 }
object { Ground }
object { Dais translate <150,0,-40> }
object { Plant scale <1.6,1.4,1.6> rotate y*-35 translate <20,0,150> }
object { Arch1 translate <278.5,-53,-200> }
object { Arch2 translate <250,0,-325> }
object { Building1 scale 1.35 translate <190,0,150> }                      // Rightmost building
object { Building2 scale 2 translate <-800,0,1475> }                       // Pointy/curvy "stadium"?
object { Building3 scale 0.335 rotate y*-7.5 translate <-120,5,160> }      // Gazebo behind left wall
object { Building4 scale <0.45,0.5,0.45> translate <-5,0,500> }            // Right-hand "office"
object { Building5 scale <1.9,1.75,1.9> translate <-1000,0,1850> }         // "hotel"-looking building
object { Building6 scale 4.1 translate <-1200,0,2575> }                    // White dome behind hotel
object { Building7 scale <10,5.5,10> translate <-1200,0,2800> }            // Space Needle behind dome
object { Building8 scale 3.5 translate <-1600,275,3100> }                  // Other bldg behind dome
object { Building9 scale 6.5 translate <-3375,0,5140> }                    // Flat bldg behind wedge
object { Building10 translate <-204,0,280> }                               // Tall thing near gazebo
object { Building11 scale <3,4,3> translate <-1600,0,2100> }               // The big wedge
object { Building12 scale 3 translate <-1000,0,1150> }                     // Wall behind "stadium"
object { Building13 scale 4 translate <-1300,87,1730> }                    // Carousel?
object { Building14 scale 2 translate <-1860,30,2100> }                    // Left of wedge
object { Building15 scale <1.75,1.85,1.75> translate <-1960,30,2050> }     // Railed building
object { Building16 scale <4.0,3.85,4.0> translate <-1960,130,1910> }      // The tall building
object { Building17 scale <3,2.5,4.5> translate <-2325,0,2150> }           // Building behind tall one
object { Building18 scale <4,2.4,3> translate <-2455,0,2150> }             // Building to left of #17
object { Building19 scale 1 translate <-1695,0,1500> }                     // Round roof behind temple
object { Building20 scale 1.5 translate <-2600,175,2175> }                 // Spire to left of temple
object { Building21 scale 2 translate <-2515,0,2150> }                     // Left/backmost building
object { Building22 scale 2.4 translate <-2300,0,1800> }                   // World's Fair tower?
object { Building23 scale 1.75 translate <-2450,0,1795> }                  // Round building at left
object { Building24 scale <1,1.1,1> translate <-2475,0,1800> }             // Building behind #23
object { Building25 scale 0.7 translate <-1000,0,775> }                    // The temple
object { Building26 scale 0.35 translate <-1025,0,765> }                   // Wall to left of temple

// "film grain" filter in front of camera.
//
#if (UseFilter=1)
  mesh {triangle{<-1,-1,0>,<-1,1,0>,<1,1,0>} triangle{<-1,-1,0>,<1,1,0>,<1,-1,0>} pigment{granite colour_map{[0.5 rgbt <1,1,1,1>][1.0 rgbt <0.5,0.25,0,0.15>]} warp{turbulence 1.0 lambda 5} scale 0.0025} translate <0,30,-499> rotate y*-35 translate <20,0,125>}
#end

camera { location <0.001,30,-500> look_at <0,40,0> angle 35.7 rotate y*-35 translate <20,0,125> }

#if (QuickLights)
  light_source { <-2000,7000,-10000> colour rgb <1,1,1> }
  light_source { <0,10000,-3000> colour rgb <1,1,1> }
#else
  light_source { <-2000,7000,-10000> colour rgb 1 area_light x*1000, y*1000, 3, 3 adaptive 1 jitter }
  light_source { <0,10000,-3000> colour rgb 1 area_light x*1000, z*1000, 3, 3 adaptive 1 jitter }
#end
