#ifndef (Quick) #declare Quick=0 #end

#if (Quick)
  #declare P_Sidewalk      = pigment { colour rgb <0.9,0.9,0.8> }
  #declare T_Grass         = texture { pigment { colour rgb <0.0,0.375,0.05> }}
  #declare T_Water         = texture { pigment { colour rgb <0.0,0.3,1.0> }}
  #declare P_PlantPetal    = pigment { colour rgb <0.9,0,0> }
  #declare P_PlantStem     = pigment { colour rgb <0.2,0.4,0.15> }
  #declare T_PlantStem     = texture { pigment { P_PlantStem }}
  #declare P_PlantDirtRing = pigment { wood colour_map { [0.4 rgb <0.7,0.6,0>][0.6 rgb <0.0,0.375,0.05>] } turbulence 1 }
#else
  #declare P_Sidewalk      = pigment { granite colour_map { [0.0 rgb <1,1,0.9>][1.0 rgb <0.7,0.7,0.65>] } scale 0.3 }
  #declare P_Water         = pigment { colour rgb <0.0,0.3,1.0> }
  #declare T_Water         = texture { pigment { P_Water } finish { reflection 0.75 specular 1.0 roughness 0.005 } normal { ripples scale 0.5 }}
  #declare P_Grass1        = pigment { colour rgb <0.6,0.5,0.25> }
  #declare P_Grass2        = pigment { bozo    colour_map { [0.65 rgbt <1,1,1,1>][0.7 rgb <0.5,0.4,0>] } warp { turbulence 1.0 lambda 3 } scale 5}
  #declare P_Grass3        = pigment { granite colour_map { [0.7 rgbt <1,1,1,1>][0.7 rgb <0.7,0.7,0.1>] } warp { turbulence 1.0 lambda 5 omega 0.75 } }
  #declare P_Grass4        = pigment { bozo    colour_map { [0.5 rgbt <1,1,1,1>][0.6 rgb <0.1,0.25,0.125>] } warp { turbulence 1.0 omega 0.8 } scale <10,0.5,0.5> rotate y*50 warp { turbulence 1.0 lambda 4 omega 1.0 } }
  #declare P_Grass5        = pigment { marble  colour_map { [0.6 rgbt <1,1,1,1>][0.7 rgb <0.2,0.6,0.2>] } warp { turbulence 1.0 omega 1 } scale <10,0.5,0.5> rotate y*176 }
  #declare P_Grass6        = pigment { bozo    colour_map { [0.6 rgbt <1,1,1,1>][0.7 rgb <0.1,0.4,0.05>] } warp { turbulence 1.0 omega 1 } scale <8,0.75,0.75> rotate y*35 }
  #declare P_Grass7        = pigment { bozo    colour_map { [0.5 rgbt <1,1,1,1>][0.6 rgb <0.3,0.5,0.1>] } warp { turbulence 1.0 omega 1 } scale <5,1,1> rotate y*102 }
  #declare T_Grass         = texture { pigment { P_Grass1 }} texture { pigment { P_Grass2 }} texture { pigment { P_Grass3 }} texture { pigment { P_Grass4 }} texture { pigment { P_Grass5 }} texture { pigment { P_Grass6 }} texture { pigment { P_Grass7 }}
  #declare P_PlantPetal    = pigment { bozo colour_map { [0.0 rgb <1,0,0>][0.5 rgb <0.75,0,0>][1.0 rgb <1,0.5,0>] } warp { turbulence 0.75 } scale <0.1,0.1,10> }
  #declare P_PlantGuts     = pigment { bozo colour_map { [0.0 rgb <1,1,0>][1.0 rgb <0.75,0.75,0.>] } warp { turbulence 1.0 omega 1.0 } scale 0.25 }
  #declare P_PlantStem     = pigment { colour rgb <0.2,0.5,0.15> }
  #declare T_PlantStem     = texture { pigment { P_PlantStem } finish { specular 0.9 roughness 0.005 }}
  #declare P_PlantDirt     = pigment { granite colour_map { [0.0 rgb <0.9,0.8,0.4>][1.0 rgb <0.5,0.4,0.1>] }}
  #declare P_PlantDirtRing = pigment { wood pigment_map { [0.4 P_PlantDirt][0.6 colour rgbt <1,1,1,1>] } turbulence 1 }
#end

#declare Sidewalks = union {
  box { < -800,0.01,-250>, <-700,-10,2000> }
  box { < -200,0,-250>, <-170,-10,1000> }
  box { <  100,0, -40>, < 130,-10,-250> }
  box { <  200,0, -40>, < 225,-10,-250> }
  box { <  275,0, -40>, < 305,-10,-250> }
  box { <-1000,0,-250>, <1000,-10,-500> }
  box { <-1000,0,   0>, <1000,-10, -40> }
  box { <-1000,0, 500>, <1000,-10, 540> }
  box { <-1000,0, 250>, <-200,  0, 250.1> }
  pigment { P_Sidewalk }
}

#declare Lawn = union {
  box { <130,0,-40>, < 200,-10,-250> }
  box { <225,0,-40>, < 275,-10,-250> }
  box { <305,0,-40>, <1000,-10,-250> }
  box { <-170,0,0>,  <1000,-10,1000> }
  box { <-1000,0,250.1>, <-200,-10,500> }
  box { <-5000,0,540>, <5000,-10,5000> }
  texture { T_Grass }
}

#declare Pools = union {
  box { <0,-2,-40>, <100,-10,-125> }
  box { <-1000,-2,0>, <-200,-10,250> }
  texture { T_Water }
}


#if (Quick)
  #declare PlantFlower = cone { <0,0,0>, 0.1, <0,4,0>, 2 pigment { P_PlantPetal } scale 0.2}
  #declare PlantGrass  = triangle { <-0.1,0,0>, <0.1,0,0>, <0,2,0> rotate x*-30 texture { T_PlantStem }}
#else
  #declare PlantFlowerPetal = bicubic_patch { type 0 flatness 0.001 u_steps 3 v_steps 3
    <-0.05,0.00,0.0>, <-0.025,0.0,0.0>, <0.025,0.0,0.0>, <0.05,0.00,0.0>,
    <-0.50,0.25,1.0>, <-0.250,-0.5,1.0>, <0.250,-0.5,1.0>, <0.50,0.25,1.0>,
    <-2.00,0.75,3.0>, <-1.000,1.5,3.5>, <1.000,1.5,3.5>, <2.00,0.75,3.0>,
    <-0.50,0.25,4.0>, <-0.250,0.0,3.5>, <0.250,0.0,3.5>, <0.50,0.25,4.0>
    pigment { P_PlantPetal } finish { ambient 0.5 }
    rotate x*-30
  }

  #declare PlantFlower = union {
    #declare foo=0;
    #while (foo < 5)
      object { PlantFlowerPetal rotate y*72*foo }
      #declare foo=foo+1;
    #end
    sphere { <0,0.5,0>, 0.45 pigment { P_PlantGuts }}
    cylinder { <0,0.5,0>, <0,-2,0>, 0.4 texture { T_PlantStem }}
    translate y*1
    scale 0.2
  }

  #declare PlantGrass = mesh {
    triangle { <-0.040,1.820,-0.410>, <0.040,1.820,-0.410>, < 0.000,2.000,-0.625> }
    triangle { <-0.040,1.820,-0.410>, <0.040,1.820,-0.410>, <-0.065,1.630,-0.275> }
    triangle { < 0.040,1.820,-0.410>, <0.065,1.630,-0.275>, <-0.065,1.630,-0.275> }
    triangle { <-0.065,1.630,-0.275>, <0.065,1.630,-0.275>, <-0.085,1.400,-0.155> }
    triangle { < 0.065,1.630,-0.275>, <0.085,1.400,-0.155>, <-0.085,1.400,-0.155> }
    triangle { <-0.085,1.400,-0.155>, <0.085,1.400,-0.155>, <-0.090,1.155,-0.090> }
    triangle { < 0.085,1.400,-0.155>, <0.090,1.155,-0.090>, <-0.090,1.155,-0.090> }
    triangle { <-0.090,1.155,-0.090>, <0.090,1.155,-0.090>, <-0.100,0.000, 0.000> }
    triangle { < 0.090,1.155,-0.090>, <0.100,0.000, 0.000>, <-0.100,0.000, 0.000> }
    rotate x*-5
    texture { T_PlantStem }
  }
#end

#declare PlantStem = union {
  #declare fs=seed(1024);
  cylinder { <0,0,0>, <0,10,0>, 0.5 }
  cone { <0,10,0>, 0.5, <0,20,0>, 0.3 }
  #declare foo=0;
  #while (foo < 4)
    #declare bar=10;
    #while (bar < 20)
      #declare ytrans = bar+(0.8*rand(fs))-0.4;
      #declare ztrans = -0.5+((ytrans-10)*0.02);
      #declare yrot   = (90*foo)+((10*rand(fs))-5)
      object { PlantFlower scale (0.2*rand(fs))+0.9 rotate <-90+(10*rand(fs))-5,0,(30*rand(fs))-15> translate <0,ytrans,ztrans> rotate y*yrot }
      #declare bar=bar+1.5;
    #end
    #declare foo=foo+1;
  #end
  object { PlantFlower scale 1.2 translate y*20 }
  texture { T_PlantStem }
}

#declare Stone1 = blob { threshold 0.1
  sphere { <-2,0,0>, 3, strength 1 }
  sphere { < 1,0.5,0>, 3.5, strength 1 }
  sphere { <-0.5,-1,0>, 2, strength 0.115 scale <1,1,3> }
  cylinder { <1,3,-3>, <3.5,3,3>, 2 strength -1 }
  pigment { P_Sidewalk }
  scale <0.7,0.4,0.4>
}

#declare Plant = union {
  #declare ps=seed(2048)
  object { PlantStem }
  object { PlantStem scale 0.95 rotate y* 89 translate <-1.5,0, 5> }
  object { PlantStem scale 0.90 rotate y*185 translate < 1.0,0,-3> }
  object { PlantStem scale 0.75 rotate y*260 translate <-3.5,0, 1> }
  object { PlantStem scale 0.70 rotate y*-13 translate <-0.5,0,-2> }
  #declare foo=0;
  #while (foo < 360)
    object { PlantGrass scale 2+(4*rand(ps)-2) rotate x*(50*rand(ps)-25) translate -z*rand(ps)*7 rotate y*foo }
    #if (Quick)
      #declare foo=foo+5;
    #else
      #declare foo=foo+1;
    #end
  #end
  disc { <0,0.001,0>, y, 12 pigment { P_PlantDirtRing scale 21 }}
  #declare foo=0;
  #declare rs=seed(4096)
  #while (foo < 360)
    #declare bar=0;
    #if (2*rand(rs)=1) #declare bar=180 #end
    object { Stone1 scale 0.6+(0.2*rand(rs)) rotate <360*rand(rs),bar,0> translate z*-10 rotate y*foo }
    #declare foo=foo+30
  #end
}

#declare Ground = union {
  object { Sidewalks }
  object { Lawn }
  object { Pools }
  matrix <1,0,0, 0,1,0, 0.125,0,1, 0,0,0>
}

#ifndef (FullScene)
  object { Ground }
  object { Plant scale <1.6,1.4,1.6> rotate y*-35 translate <20,0,150> }

  camera { location <0.001,30,-500> look_at <0,40,0> angle 35.7 rotate y*-35 translate <20,0,125> }
  light_source { <-2000,7000,-10000> colour rgb <1,1,1> }
  light_source { <0,10000,-3000> colour rgb <1,1,1> }
#end
