// Persistence of Vision Raytracer
// Theme "Imaginary worlds" 01-02/99: The Queen's Croquet-ground
// Sizes in cm

global_settings {
   max_trace_level 10
   adc_bailout 1/255
   assumed_gamma 1.9
   radiosity{
      distance_maximum  15     // def.   0, essais=500, puis 35
      brightness       3.3     // def.   3.3
      count            200     // def. 100
      error_bound        0.38  // def.   0.4
      gray_threshold     0.5   // def.   0.5
      low_error_factor   0.8   // def.   0.8
      minimum_reuse      0.015 // def.   0.015
      nearest_count     10     // def.   6
      recursion_limit    2     // def.   1
      }
   }

/******************************************************************************

        Gnralits

******************************************************************************/

#declare MAIN_POV=1
#include "common.inc"
#include "soldat.inc"

#declare Vue_1= camera {
   perspective
   location  <100, 100, 200>
   up        y
   right     -4/3 * x
   look_at   <0, 0, 0>
   //angle 25 //Attention: angle  la base et non sur la diagonale!
   angle 35 //57mm
}

#declare Vue_2= camera {
   perspective
   location  <250, 120, 350>
   up        y
   right     -4/3 * x
   look_at   <-250, 0, 0>
   angle 60
}

#declare Vue_3= camera {
   perspective
   location  <200, 120, 350>
   up        y
   right     -1 * x
   look_at   <-250, 120, 0>
   angle 70
}

#declare Lampes=union{
   object {
      light_source {
         <0, 15000, -10000>
         color rgb <1, 1, 1>*.7
         shadowless
         }
      }
   object {
      light_source {
         <15000, 15000, 14000>
         color rgb <1, .9, .8>*.6*1.3
         }
      }
   }

#declare C_Lampes_E=color rgb <1, .9, .8>*.4;
#declare Lampes_E=union{
   object {
      light_source {
         <0, 25000, -10000>
         color rgb <1, 1, 1>*.7
         shadowless
         //area_light
         //<1000, 0, 0> <0, 1000, 0>
         //4, 4
         //adaptive 0 jitter
         }
      }
   object {
      light_source {
         <15000, 15000, 14000>
         color rgb <1, .9, .8>*.6*1.3
         area_light
         <1000, 0, 0> <0, 1000, 0>
         4, 4
         adaptive 0 jitter
         }
      }
/*   object {//Montagnes
      light_source {
         <-5000, 1000, 3000>
         color rgb <.7, .6, 1>*.7
         fade_distance 3000
         fade_power 10
         }
      }
   object {//Entre
      light_source {
         <0, 250, 600>
         color C_Lampes_E
         fade_distance 300
         fade_power 2
         }
      }
   object {//Couloir
      light_source {
         <-600, 250, 0>
         color C_Lampes_E
         fade_distance 300
         fade_power 2
         }
      }
   object {//Face entre
      light_source {
         <0, 250, -600>
         color C_Lampes_E
         fade_distance 300
         fade_power 2
         area_light
         <5, 3, 0> <0, 3, 5>
         4, 4
         adaptive 0 jitter
         }
      }
   object {//Fill-in Shahriar
      light_source {
         //<-450, 7, 450>
         <-450, 14, 450> // Slightly cheated ;-)
         color rgb <1, .85, .7>*.6
         //color White*5
         spotlight
         radius 20
         falloff 20
         tightness 1
         point_at <-310, 130, 567>
         area_light
         <3, 5, 0> <0, 5, 3>
         4, 4
         adaptive 0 jitter
         }
      }
    }*/
   }
   
/******************************************************************************

        Sky, Adapted from S_Cloud5

******************************************************************************/

#declare MyS_Cloud =
sky_sphere {
    pigment { rgb <0.258, 0.258, 0.435>*2 }
    pigment {
        bozo
        turbulence 1.5
        octaves 10
        omega .5
        lambda 2.5
        color_map {
            [0.0, 0.5 color rgbf<1.0, .5, .5, 0>
                      color rgbf<.9, .9, .9, .9> ]
            [0.5, 0.7 color rgbf<.9, .9, .9, .9>
                      color rgbf<1, 1, 1, 1> ]
            [0.7, 1.0 color rgbf<1, 1, 1, 1>
                      color rgbf<1, 1, 1, 1> ]
        }
    scale <1, 0.3, 10>
    }
    pigment {
        bozo
        turbulence 0.6
        octaves 10
        omega .5
        lambda 2.5
        color_map {
            [0.0, 0.4 color rgbf<1.0, .75, .75, 0>
                      color rgbf<.9, .9, .9, .9> ]
            [0.4, 0.7 color rgbf<.9, .9, .9, .9>
                      color rgbf<1, 1, 1, 1> ]
            [0.7, 1.0 color rgbf<1, 1, 1, 1>
                      color rgbf<1, 1, 1, 1> ]
        }
    scale <1, 0.3, 10>
    }
    pigment {
        bozo
        turbulence 0.8
        octaves 10
        omega .5
        lambda 2.5
        color_map {
            [0.0, 0.4 color rgbf<1.0, .75, .75, 0>
                      color rgbf<.9, .9, .9, .9> ]
            [0.4, 0.6 color rgbf<.9, .9, .9, .9>
                      color rgbf<1, 1, 1, 1> ]
            [0.6, 1.0 color rgbf<1, 1, 1, 1>
                      color rgbf<1, 1, 1, 1> ]
        }
    scale <1, 0.3, 10>
    }
rotate -60*y
}

/******************************************************************************

        Scne complte

******************************************************************************/
                          
camera {Vue_3}                  
#declare WideLight = 1
sky_sphere {MyS_Cloud}

object{#include "herisson.inc" rotate 30*y scale 3 translate <90, 65, 300>}
union {#include "rosier.inc" scale 1 translate <150, 63, 200>}
union {#include "decor.inc" scale 1}
//union {#include "alice.inc" scale .5 translate <90, 62, 250>}
union {#include "pelouse.inc" scale 1}
//Big soldiers:
object {soldat(4, 10, 4, 4, 90, -40, 90, -40, 0) rotate 80*x rotate 20*y translate <75, 90, 300>}
object {soldat(4,  3, 4, 4, 90, -40, 90, -40, 0) rotate 80*x rotate 200*y translate <35, 90, 320>}
object {soldat(20, 7, 3, -6, 40, -40, 70, 10, 2) rotate 60*y translate <80, 102, 190>}
object {soldat(12, 8, 50, 50, 40, -70, -90, 50, 3) rotate 15*x rotate 90*y translate <85, 100, 250>}
//Small soldiers:

object {soldat(20, 4, 20, 5,  50,  5, -90, 5, 1) scale 1 rotate 100*y translate <-930, 12, -100>}
object {soldat(12, 6, 20, 5, -90,  0,  60, 5, 2) scale 1 rotate 90*y translate <-850, 12, -80>}
object {soldat(20,10, 20, 5, -90, -5, -90,15, 0) scale 1 rotate 100*y translate <-750, 12, -40>}
object {soldat(16, 5, 20, 5,  80,  5, -90, 5, 1) scale 1 rotate 110*y translate <-650, 12, 20>}
object {soldat(10, 9, 20, 5, -90,-10, -90,-5, 0) scale 1 rotate 100*y translate <-500, 12, 50>}
object {soldat(20, 2, 20, 5, -90,  0,  70, 5, 2) scale 1 rotate 60*y translate <-450, 22, 140>}
object {soldat(18, 3, 20, 5,  60, 10, -90, 5, 1) scale 1 rotate 30*y translate <-450, 22, 180>}
object {soldat(12, 8, 20, 5, -90,  0, -90, 5, 0) scale 1 rotate 80*y translate <-380, 22, 220>}
object {soldat(15, 5,  3,-6,  70, 10, -90, 0, 1) scale 1 rotate 60*y translate <-150, 42, 150>}
object {soldat(20, 9, 20,20, -90, 10, -90,10, 0) scale 1 rotate 90*y translate <-170, 32, 160>}
object {soldat( 8, 2,  5,20, -85, 10, -90, 0, 0) scale 1 rotate 70*y translate <-110, 32, 130>}
object {soldat(20, 3, -6, 3, -90,  0,   0,45, 2) scale 1 rotate 80*y translate <-220, 22, 180>}
object {soldat(12, 7, 20, 5, -90,  0, -90, 5, 0) scale 1 rotate 100*y translate <-300, 32, 180>}

// Proto testing:
//object {soldat(20, 7, 20, 2, 70, -10, 90, -90, 1)scale .7 rotate (90+90-35)*y translate <145, 112, 300>}

#ifdef (WideLight)
  object {Lampes_E}
  #debug "Lumieres etendues\n"
#else
  object {Lampes}
  #debug "Lumieres ponctuelles\n"
#end
