// Persistence of Vision Raytracer
// Groundhog

#local myRand=seed(123);

#declare Herisson=object{
union{
   union{
      #local i=0;
      #while (i<1000)
         #local theta = 2*pi*rand(myRand);
         #local phi = 2*pi*rand(myRand);
         #local x0 = sin(theta)*cos(phi);
         #local y0 = cos(theta)+.5;
         #local z0 = sin(theta)*sin(phi);
         #local x1 = 2*sin(theta)*cos(phi)*(1+cos(theta));
         #local y1 = 2*cos(theta)*(1+cos(theta));
         #local z1 = 2*sin(theta)*sin(phi)*(1+cos(theta));
         cone {<x0, y0, z0>, .1, <x1, y1, z1>, 0}
         #local i=i+1;
         #end
      cone {0, .8, -1.5*y, 0} 
      pigment {
         bozo 
         turbulence 0.4 
         color_map {
            [0 Tan*0.7]
            [1 Tan*1.0]
            }
         scale .5
         }
      normal {
         bumps bump_size .5 scale .03
         }
      finish {
         phong 0.1 phong_size 1
         }
      }
   union{
      sphere {-1.4*y, .2}
      sphere {<0.3, -.5,-0.25>, .2}
      sphere {<0.3, -.5, 0.25>, .2}
      pigment {Black}
      finish {Glossy}
      }
   }
rotate 90*z
translate .5*y
scale <1, .8, 1>
}
object {Herisson}