//==============================================================================
//      INCLUDES...
//==============================================================================
#include "frgjnt.inc"
#include "tetpak.inc"
#include "submar.inc"
#include "moucha.inc"
//==============================================================================
//      LINO BLEU
//==============================================================================
#declare LumiCoff=.4
#declare LinoBleu =
   texture
   {   
      pigment
      {
         dents
         color_map
         {
            [ 0.0     rgbft <0.0, 0.0, 0.583333, 0.0, 0.0>*LumiCoff ]
            [ 0.391459  rgbft <0.0, 0.1354, 0.583333, 0.0, 0.0>*LumiCoff ]
            [ 0.679715  rgbft <0.0, 0.0, 0.270833, 0.0, 0.0>*LumiCoff ]
            [ 1.0     rgbft <0.0104, 0.0, 0.583333, 0.0, 0.0>*LumiCoff ]
         }
         turbulence 0.1211
         ramp_wave
      }   
      normal
      {
         wrinkles , 0.2
      }   
      finish
      {
         ambient 0.1
         phong 0.172633
         specular .3
         reflection 0.2
      }   
      scale  2
   }
//==============================================================================
//      GRADIENT HEIGHT FIELD
//==============================================================================
#declare HFGrad = 
   pigment
   {
      gradient y
      color_map
      {
         [ 0.0     rgbft <0.0, 0.4479, 0.489567, 0.0, 0.0> ]
         [ 0.071174  rgbft <0.25, 0.5104, 0.617175, 0.0, 0.0> ]
         [ 0.170819  rgbft <0.6354, 0.604167, 0.680979, 0.0, 0.0> ]
         [ 0.309609  rgbft <0.625, 0.739567, 0.718733, 0.0, 0.0> ]
         [ 0.409253  rgbft <0.406233, 0.546883, 0.656233, 0.0, 0.0> ]
         [ 0.601423  rgbft <0.750599, 0.656233, 0.537746, 0.0, 0.0> ]
         [ 0.658363  rgbft <0.792366, 0.746744, 0.50324, 0.0, 0.0> ]
         [ 0.725979  rgbft <0.905812, 0.858038, 0.698321, 0.0, 0.0> ]
         [ 0.807829  rgbft <1.0, 1.0, 0.936196, 0.0, 0.0> ]
         [ 0.814947  rgbft <0.9375, 0.965494, 0.708333, 0.0, 0.0> ]
         [ 1.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
      }
      turbulence 0.0803
      octaves 10
      omega 0.777
      ramp_wave
   }
//==============================================================================
//      CANETTE COCA (...)
//==============================================================================
#declare Canette=union {
torus {2.4 .1 translate y*.1 texture {T_Silver_5D}}

difference {
        cone {<0,0.163,0>,2.4777,<0,0.2852,0>,2.4941}
        torus {2.5525 .0912 translate y*.2151}
        texture {T_Silver_5D}
        }
cone {<0,0.9094,0>,3.2424,<0,0.2852,0>,2.4941 texture {T_Silver_5D}}
torus {3.2 .1 translate y*1}
cylinder {<0,1,0>,<0,9,0>,3.3}
torus {3.1 .2 translate y*9}

difference {
  union {cylinder {<0,9,0>,<0,10.4,0>,2.65}
  cone {<0,9.0986,0>,3.274,<0,10.2,0>,2.65}}
  
  torus {3.1698 .5713 translate y*10.437}
  cylinder {<0,8,0>,<0,10.6,0>,2.60 texture {T_Silver_5D}}
           }
torus {2.65 .05 scale <1,2,1> translate y*10.5  texture {T_Silver_5D}}
disc {0,y*1,2.6 translate y*10 texture {T_Silver_5D}}
cone {<0,10,0>,2.5,<0,10.2,0>,2.4 texture {T_Silver_5D}}
torus {.8 .05 translate <1.2,10.25,0> texture {T_Silver_5D}}
torus {.75 .05 translate <1.2,10.25,0> texture {T_Silver_5D}}
cylinder {<0,10.2,0>,<0,10.25,0>,.15 texture {T_Silver_5D}}

pigment {image_map {gif "sgtpepp.gif" map_type 2} rotate y*150 scale <1,8,1> translate y*1} 
finish {phong .9 reflection .3}

}
//==============================================================================
//      JOINT DE LA PORTE
//==============================================================================
#declare V_Joint = intersection {
object {Frigo_Joint scale <4,2,2> translate y*-1 scale <1,44,1>}
plane {y,0 rotate x*45 translate <0,-44,.945*2> inverse}
plane {y,0 rotate x*-45 translate <0,44,.945*2>}
bounded_by {cylinder {<0,-45,0>,<0,45,0>,4}}
}

#declare H_Joint = intersection {
object {Frigo_Joint scale <4,2,2> translate y*-1 rotate x*90 scale <1,1,29>}
plane {z,0 rotate x*-45 translate <0,-.945*2,29>}
plane {z,0 rotate x*45 translate <0,-.945*2,-29> inverse}
bounded_by {cylinder {<0,0,-30>,<0,0,30>,4}}
}

#declare Joint_Pourtour=union {
object {V_Joint translate z*(29-(.945*2)) }
object {V_Joint translate z*(29-(.945*2)) scale <1,1,-1>}
object {H_Joint scale <1,-1,1> translate y*(44-(.945*2)) }
object {H_Joint scale <1,-1,1> translate y*(44-(.945*2)) scale <1,-1,1>}
}
//==============================================================================
//      MACRO ROUNDED-BOX
//==============================================================================
#macro RoundedBox(v_SP,v_EP,R)
 union {
               #local vSP=(v_SP)*<1,1,1>;
               #local vEP=(v_EP)*<1,1,1>;
             #if (vSP.x > vEP.x)
               #local tSave=vSP.x;
               #local vSP=<vEP.x,vSP.y,vSP.z>;
               #local vEP=<tSave,vEP.y,vEP.z>;
             #end
             #if (vSP.y > vEP.y)
               #local tSave=vSP.y;
               #local vSP=<vSP.x,vEP.y,vSP.z>;
               #local vEP=<vEP.x,tSave,vEP.z>;
             #end
             #if (vSP.z > vEP.z)
               #local tSave=vSP.z;
               #local vSP=<vSP.x,vSP.y,vEP.z>;
               #local vEP=<vEP.x,vEP.y,tSave>;
             #end

               box {<vSP.x,vSP.y+R,vSP.z+R>,<vEP.x,vEP.y-R,vEP.z-R>}
               box {<vSP.x+R,vSP.y,vSP.z+R>,<vEP.x-R,vEP.y,vEP.z-R>}
               box {<vSP.x+R,vSP.y+R,vSP.z>,<vEP.x-R,vEP.y-R,vEP.z>}

               #local vSP=vSP+R;
               #local vEP=vEP-R;

               sphere { <vSP.x,vSP.y,vSP.z>,R}
               sphere { <vEP.x,vSP.y,vSP.z>,R}
               sphere { <vSP.x,vEP.y,vSP.z>,R}
               sphere { <vEP.x,vEP.y,vSP.z>,R}
               sphere { <vSP.x,vSP.y,vEP.z>,R}
               sphere { <vEP.x,vSP.y,vEP.z>,R}
               sphere { <vSP.x,vEP.y,vEP.z>,R}
               sphere { <vEP.x,vEP.y,vEP.z>,R}

               cylinder { <vSP.x,vSP.y,vSP.z>,<vEP.x,vSP.y,vSP.z>,R }
               cylinder { <vSP.x,vEP.y,vSP.z>,<vEP.x,vEP.y,vSP.z>,R }
               cylinder { <vSP.x,vSP.y,vEP.z>,<vEP.x,vSP.y,vEP.z>,R }
               cylinder { <vSP.x,vEP.y,vEP.z>,<vEP.x,vEP.y,vEP.z>,R }
               cylinder { <vSP.x,vSP.y,vSP.z>,<vSP.x,vEP.y,vSP.z>,R }
               cylinder { <vEP.x,vSP.y,vSP.z>,<vEP.x,vEP.y,vSP.z>,R }
               cylinder { <vSP.x,vSP.y,vEP.z>,<vSP.x,vEP.y,vEP.z>,R }
               cylinder { <vEP.x,vSP.y,vEP.z>,<vEP.x,vEP.y,vEP.z>,R }
               cylinder { <vSP.x,vSP.y,vSP.z>,<vSP.x,vSP.y,vEP.z>,R }
               cylinder { <vEP.x,vSP.y,vSP.z>,<vEP.x,vSP.y,vEP.z>,R }
               cylinder { <vSP.x,vEP.y,vSP.z>,<vSP.x,vEP.y,vEP.z>,R }
               cylinder { <vEP.x,vEP.y,vSP.z>,<vEP.x,vEP.y,vEP.z>,R }
               }
             #end
//==============================================================================
//      OEUF
//==============================================================================
#declare OeufTex = 
   texture
   {   
      pigment {color rgb <0.8392, 0.7372, 0.6705>}   
      normal {wrinkles 0.083}   
      finish {phong 0.064 phong_size 15 specular 0.050 roughness 0.1428}   
   }

#declare Oeuf=union {
sphere {<0,0,0>,5}
sphere {<0,5,0>,2.9289}
lathe {bezier_spline 4,<5,0>,<5,4>,<3.14,6>,<2.07,7.0711>}
texture {OeufTex scale .1}
}
//==============================================================================
//      POT DE MIEL...
//==============================================================================
#macro HoneyPot (MapName)
 union {
cylinder {<0,1.6,0>,<0,6.5,0>,4.43

        pigment {image_map {gif MapName map_type 2} scale <1,5,1> rotate y*90 translate y*1.6}
        finish {ambient .4 specular .2} normal {bumps .4}
        //pigment {White}

        }

difference {
merge {
torus {3.5 .2 translate y*.2}
cylinder {<0,0,0>,<0,.4,0>,3.5}
torus {3.5 1 translate y*1.2}
torus {4.3 .2 translate y*1.4}
cylinder {<0,1.4,0>,<0,7,0>,4.4}
torus {4.3 .2 translate y*7}
torus {3.3 1 translate y*7}    
cylinder {<0,7.8,0>,<0,9,0>,3.2}
torus {3.2 .1 rotate x*2 translate y*8}
torus {3.2 .1 rotate x*2 translate y*8.4}
torus {3.2 .1 rotate x*2 translate y*8.8}
}
merge {
        cylinder {<0,.6,0>,<0,9.1,0>,2.9}
        torus {3 1 translate y*7}
        cylinder {<0,1.4,0>,<0,7,0>,4.2}
        torus {3.2 1 translate y*1.2}

}
}

pigment {LightBlue filter .8} finish {phong .7 reflection .2}
scale <.8,1,.8>*1.5
}
#end
//==============================================================================
//      BOUTEILLES
//==============================================================================
#declare Bouteille1=
 merge {
difference { //difference entre 2 merge
     merge {
       union {//goulot a descendre
         torus {11 3 translate y*312}
         cylinder {<0,315,0>,<0,306,0>,11}cylinder {<0,200,0>,<0,312,0>,14}cylinder {<0,295,0>,<0,305,0>,15}cylinder {<0,296,0>,<0,304,0>,16}
         torus {15 1 translate y*296}torus {15 1 translate y*304}
         translate y*-30
         }//fin union
       cylinder {<0,11.42,0>,<0,40,0>,34.97} //cylindre positif bas
       torus {28.09 13.80/2 scale <1,22.84/13.80,1> translate y*13.80/2}
       lathe {bezier_spline 12,<0,40-.1>,<0,40-.1>,<34.95,40>,<34.95,40>,<34.95,40>,<34.95,120>,<11,140>,<11,253>,<0,253>,<0,253>,<11,253>,<11,253>}
       }//fin merge
     //plane {x,0 inverse pigment {checker color White color Green scale 10}}
     merge {
       cylinder {<0,147,0>,<0,316,0>,9}
       lathe {bezier_spline 12,<0,40>,<0,40>,<32,40>,<32,40>,<32,40>,<32,120>,<9,140>,<9,253>,<0,253.1>,<0,253.1>,<9,253>,<9,253>}
       cylinder {<0,15.42,0>,<0,40.1,0>,32}
       }//fin merge
     }//fin difference
  bounded_by {cylinder {0,y*315,36}}
  scale 1
  }//fin "Bouteille1"

#declare Bouteille2=merge {
difference {
merge {
  union {//goulot a descendre
  torus {11 3 translate y*312}cylinder {<0,315,0>,<0,306,0>,11}cylinder {<0,200,0>,<0,312,0>,14}cylinder {<0,295,0>,<0,305,0>,15}cylinder {<0,296,0>,<0,304,0>,16}
  torus {15 1 translate y*296}torus {15 1 translate y*304}
  translate y*-30
  }
difference {
        cylinder {<0,182.87,0>,<0,223.01,>,95.09}
        torus {95.09 81.48 translate y*223.01}
        }
sphere {<0,0,0>,34.97 scale <1,50.24/34.97,1> translate y*147.07}
cylinder {<0,11.42,0>,<0,147.07,0>,34.97}
torus {28.09 13.80/2 scale <1,22.84/13.80,1> translate y*13.80/2}
}
merge {
cylinder {<0,147,0>,<0,316,0>,9}
sphere {<0,0,0>,32 scale <1,50.24/34.97,1> translate y*147.07}
cylinder {<0,15.42,0>,<0,147.07,0>,32}

difference {
        cylinder {<0,182.87,0>,<0,223.01,>,95.09}
        torus {95.09 83 translate y*223.01}
        }
}}
bounded_by {cylinder {0,y*315,36}}
scale 1}
//==============================================================================
//      C'EST FINI...
//==============================================================================
