#include "colors.inc"
#include "mestex.inc"
#include "frigo.inc"

plane {x,0 pigment {checker color White color White/2 scale 3.5} normal {wrinkles .1 scale 2} finish {specular .3}}
plane {y,0 texture {LinoBleu}}                                                               
box {<0,0,-500>,<2,15,500> texture {T_Wood23 scale 1 rotate <10,10,10>}}


camera {location <110,120,55> direction <0,0,1> look_at <60,60,20>}

object {submarine1 scale .1 rotate y*-110 translate <65,55,-30>}
object {submarine1 scale .1 rotate y*150 translate <95,25,-10>}
object {Moucha_Complet rotate y*-30 scale .02 translate <75,35,-60>}

box {<55,0,-5>,<105,5,-105> pigment {White}}
union {
RoundedBox (<50,95.5,0>,<54,5,-300>,.2)
RoundedBox (<110,95.5,0>,<106,5,-300>,.2)
RoundedBox (<50,9,0>,<110,5,-300>,.2)                                   
object {RoundedBox (<50,95.5,5>,<110,100,-300>,.1) pigment {rgb <1,1,.95>}}
pigment {White}
}

height_field {gif "frighf.ghf" pigment {HFGrad} scale <1,1,-1> translate z*1 scale <52,30,120>
                translate <54,8.9,-130>

                }

#declare ContenuPorte=union {

object {Canette translate <10,50.3,35>}
object {Oeuf scale 2/5 translate <12,70.3+2,15>}
object {Oeuf scale 2/5 rotate z*10 translate <12,70.3+2,20>}
object {Oeuf scale 2/5 rotate z*-10 translate <8,70.3+2,17>}
object {Oeuf scale 2/5 rotate z*-5 translate <8,70.3+2,12>}
object {Oeuf scale 2/5 rotate z*15 translate <8,70.3+2,22>}
object {HoneyPot ("potmap1") scale .7 translate <10,70.3,32>}
object {HoneyPot ("potmap2") rotate y*-45 scale .7 translate <8,70.3,45>}
object {TetraPak scale 8 rotate y*40 translate <12,50.3,15> pigment {Orange/2+White/2}}
object {TetraPak scale 8 rotate y*80 translate <12,50.3,22> pigment {White*1.2}}
object {Bouteille1 scale .1 pigment {SeaGreen} translate <12,11,35> finish {phong .5 reflection .05}}
object {Bouteille2 scale .1 pigment {MediumSeaGreen} translate <8,11,20> finish {phong .5 reflection .05}}
}
//==============================================================================
//      CADRE INTERIEUR PORTE FRIGO
//==============================================================================
#declare QuarTorus=intersection {torus {2 .2} plane {x,0} plane {z,0}
                        rotate y*-90 translate z*2}

#declare GardeCorps=union {
cylinder {<0,0,-24>,<12,0,-24>,.2}
cylinder {<0,0,24>,<12,0,24>,.2}
object {QuarTorus translate <12,0,-24>}
object {QuarTorus scale <1,1,-1> translate <12,0,24>}
cylinder {<14,0,-22>,<14,0,22>,.2}
}

#declare CadrIntern=union {
object {GardeCorps translate <0,18,0>}
object {GardeCorps translate <0,24,0>}

#declare RoundCoff=.4;
RoundedBox (<0,85,25>,<10,60,23.5>,RoundCoff)
RoundedBox (<0,85,-25>,<10,60,-23.5>,RoundCoff)
RoundedBox (<0,50,25>,<8,60,23.5>,RoundCoff)
RoundedBox (<0,50,-25>,<8,60,-23.5>,RoundCoff)
RoundedBox (<0,80,25>,<6,10,23.5>,RoundCoff)
RoundedBox (<0,80,-25>,<6,10,-23.5>,RoundCoff)
RoundedBox (<0,85,25>,<8,82,-25>,RoundCoff)
RoundedBox (<0,10,25>,<16,11,-25>,RoundCoff)
RoundedBox (<15,10,25>,<16,15,-25>,RoundCoff)
RoundedBox (<0,15,25>,<16,10,23.5>,RoundCoff)
RoundedBox (<0,15,-25>,<16,10,-23.5>,RoundCoff)

pigment {White*1.1} finish {reflection 0 phong 1.5}
}

#declare BoxTry=difference {
                RoundedBox (<0,0,-23>,<15,25,23>,2)
                RoundedBox (<.3,.3,-22.7>,<14.7,24.7,22.7>,1.7)
                plane {y,10 inverse rotate z*-15}
        pigment {rgb <1,1,.95>} finish {phong .9 reflection .05}
        }
//==============================================================================
//      GROUPE PORTE FRIGO
//==============================================================================
#declare PorteFrigo=union {
object {RoundedBox (0,<4,90,60>,.25) pigment {White} finish {phong .9 reflection .08 metallic}}
object {Joint_Pourtour translate <4,45,30> pigment {Wheat}}
object {BoxTry translate <4,70,30>}
object {BoxTry translate <4,50,30>}
object {CadrIntern translate <3.7,0,30>}
object {ContenuPorte}
}
//==============================================================================
//      PLACEMENTS
//==============================================================================
object {PorteFrigo translate <-2,5,-2> rotate y*-10 translate <52,0,3>}

light_source {<85,80,-40> <1,.99,.95>*1.5
               area_light x*20,z*20,4,4 adaptive 0 jitter
                }

light_source {<85,80,-40> Red*4+Magenta*4 spotlight point_at <85,80,-41> radius 120 falloff 150}

light_source {<250,250,300> White*.7
              area_light x*50,z*50,4,4 adaptive 0 jitter
              }
                            
