/*****************************************************************************

      Created by: John DeLancey Stevens, Worcester MA, USA
      Dates worked on: 1 Feb 99-27 Feb 99
      Render time:1 day, 7 hours, 37 minutes, and 15 seconds
      Parse time:13 seconds
      
      IRTC premise: Imagainary Worlds
      Scene Title: A Foreshadowing of Tomorrow   
      
      
      When I first started creating this scene, I knew only one thing
      for certain, and that was that I would try to make a realistic 
      volcano.  Since this was established already, I started thinking 
      about what type of "imaginary world" this volcano would be a part
      of.  Two things leapt to mind, the idea behind the movie "Neverending
      Story" with the destruction of the world by the nothing.  Second was
      the great cascade range volcanoes of the American Northwest.  I wanted
      to make it look like a possible future of the Great Northwest, in which
      massive eruptions have occurred, and floods have eroded great gaps in
      the landscape.  Hence I came up with a bunch of landforms looking like
      great vaulted pinnacles.  On the central pinnacle is a rotting cabin, 
      perhaps the remains of an old hunters hide out.  It is one of the few
      remaining signs of humanity.  The world is once again trying to take
      back its heritage.
     
      This scene makes use of Height Field Lab

*****************************************************************************/


#include "colors.inc"
#include "augustskies.inc"
#include "pinetree2.pov"

global_settings { max_trace_level 20 }          //By increasing this number you get rid of those nasty transparent object
                                                //anomalies 
                                                
#declare camera_location = <8.5, 3.5, -6>;
#declare camera_look_at = <8.5, 4.5, 20>;   
 
#declare RSeed = seed(30000);                   //Set up a random rotation function
#macro RandRot()
	<rand(RSeed)*20,rand(RSeed)*360,rand(RSeed)*20>
#end  
 
camera {  
  location camera_location
  look_at camera_look_at            
  angle 85 

}


//Put the pine trees together 

#declare Needles = object{
 cone{<0,0,0>,1,<0,1,0>,0 open
  texture{
   pigment{
    image_map{ 
      gif "pineneedles.gif" 
      interpolate 2.0 
      transmit 0 1.0 
    }
    rotate<90,0,0> 
    translate<0.5,0.5,0.5> 
    scale<1.8,1.9,1.8>
   }
  }
 }
 hollow
}

#declare Bark = object{
   cone{<0,0,0>,0.2,<0,10,0>,0}
     texture{
       pigment { color rgb<0.501, 0.313, 0.184>}
       normal {
       bumps
       bump_size -2
       scale< .02, .1, .02>
       }
     }
   }

#declare PineTree2 = object {
 union {
  object{Bark scale<1,1.03,1>}
  object{Needles scale<2,1.7,2> rotate<0,120,0> translate <0,1.9,0>}
  object{Needles scale<3.1,2.9,3.1> rotate<0,90,0> translate <0,2.5,0>}
  object{Needles scale<2.5,2.4,2.5> rotate<0,0,0> translate <0,4,0>}
  object{Needles scale<2.1,1.9,2.1> rotate<0,120,0> translate <0,5.3  ,0>}
  object{Needles scale<1.7,1.5,1.7> rotate<0,180,0> translate <0,6.5,0>}
  object{Needles scale<1.3,1,1.3> rotate<0,90,0> translate <0,8  ,0>}
 }
} 


//Layered textures for volcano
 
#declare Layer1 = pigment {
  gradient x
  turbulence 0.5
  lambda 30
  omega 1
  octaves 2
  color_map {
    [0.0 color Gray35 filter .7]
    [0.2 color Gray35 filter .7]
    [0.3 color Black filter .7]
    [0.35 color Gray65 filter .7]
    [0.4 color Gray20 filter .7]
    [0.7 color Gray65 filter .7]
    [1 color Gray65 filter .7]
  }
  rotate -45*z
}

#declare Layer2 = pigment {
  gradient x
  turbulence 0.5
  color_map {
    [0.0 color Gray70 filter .8]
    [0.2 color Gray60 filter .8]
    [0.3 color Gray50 filter .8]
    [0.35 color Gray40 filter .8]
    [0.4 color Gray30 filter .8]
    [0.7 color Gray20 filter .8]
    [1 color Gray10 filter .8]
  }
  rotate <60, 0, -45>
}

#declare Layer3 = pigment {
    gradient x
    turbulence 0.5
    lambda 20
    omega 1
    octaves 2
    color_map {
      [0.0 color Gray40]
      [0.08 color Gray45]
      [0.16 color Gray50]
      [0.24 color Gray55]
      [0.33 color Gray60]
      [0.4 color Gray65]
      [.45 color Gray65]
      [.52 color Gray70]
      [.64 color Gray75]
      [.76 color Gray75]
      [.88 color Gray80]
      [1 color Gray80]
    }
    rotate <60, 0, -45>
  }   
  
//Lets make a boulder
  
#declare Boulder = blob {
  threshold 0.6
  cylinder{<-0.25,0,0.3>,<0.2,0.3,-0.2>,0.42, 0.75}
  cylinder{<-0.25,-0.2,0>,<0.2,0.3,0.2>,0.32, 0.95}
  cylinder{<-0.25,0,0>,<0.25,0,0>,0.4, 0.75}
  texture {Layer3}
  texture {Layer2}
  texture {Layer1}
  normal {wrinkles 2 scale 3}
  finish {
    ambient rgb <0, 0, 0.2>
    irid {
      .2
      thickness .9
      turbulence 5
    }
  }
} 

//Make the sun 

#declare effect_location = <-10700, 800, 18000>; 
#declare effect_color = <0.67, 0.91, 0.91>;  
#declare effect_scale = 1.3; 
#declare effect_always_on_top = true;
#declare effect_type = "Sun3"
#include "augustlens.INC"


//This light source makes the scattering media visible

light_source {
  <-10100, 400, 10000> 
   color <0.7, 0.7, 0.7>
   spotlight
   point_at <0, 0, 0>
   radius 0.2
   falloff 0.4
   tightness 1 
}  

//This light creates the watery phong type surface
 
light_source {
  <-6100, 300, 10000>
   color <1, 1, 1>
   spotlight
   point_at <0, 0, 0>
   radius 0.2
   falloff 0.4
   tightness 1
   media_attenuation off
   media_interaction off 
}  

//This light acts to light up some of the darker scene elements so we can see them

light_source {
  <-4000, 1000, -2250>
   color <1, 1, 1>
   spotlight   
   point_at <0, 0, 0>
   radius 45
   falloff 45
   tightness 1 
   fade_power 2
   fade_distance 4000
   media_attenuation off
   media_interaction off
   shadowless
}  

//Make the sky
 
object {AugustSky}

//Declare our water 
 
#declare augustwater = texture {
  pigment {color red 0.109216 green 0.146471 blue 0.218824}
  finish {reflection .65 phong 1.5}
  normal {wrinkles 1 scale 0.15 turbulence 2}
}

//The large volcano      

height_field {  
  tga "augustmount.tga"
  smooth
  scale <40, 9, 40> 
  rotate <0, 45, 0>
  texture {Layer3}
  texture {Layer2}
  texture {Layer1}
  normal {wrinkles 2 scale 3}
  finish {
    ambient rgb <0, 0, 0.2>
    irid {
      .2
      thickness .9
      turbulence 5
    }
  }
  translate <-20, 0, 20>
}  

 
//This is the media for the billowy updraft plumes coming directly out of the vent

#declare PillowyUpdraftInterior =
	interior {  
          media {          
            scattering { 1, <0.8,0.8,0.8,> extinction 0.8 } //By using type 1 media, the scattering is not dependent on light angle
	    density { 
	      spherical
		color_map {
		  [0.0 color rgb <0.0,0.0,0.0> ] 
		  [0.2 color rgb <0,0,0> ] 
		  [1.0 color rgb <2,2,2> ]                  //Brighten the media by having higher rgb values here
		}
		turbulence .48
		omega 0.7    
    	    }
	  }
	}
	
	
#declare PillowyUpdraftTexture =
	texture {
		pigment { color rgbf<1,1,1,1> } 
		normal {bumps 0.3 scale 0.3}
		finish { ambient .01 diffuse 0.7 }
	}
	
	
#declare PillowyUpdrafts =
	material {
		texture { PillowyUpdraftTexture }
		interior { PillowyUpdraftInterior }
	}  
	

//This media stuff is for the darker fanning out of the ash, which is less turbulent
	
#declare AshFanOutInterior =
        interior {  
	  media {            
	    scattering { 1, <1,1,1,> extinction 1.0 } 
	    density { 
	      spherical
		color_map{
		  [0.0 color rgb <0.0,0.0,0.0> ] 
		  [0.1 color rgb <0,0,0> ] 
		  [1.0 color rgb <5,5,5> ] 
		}
	        turbulence .03
		omega 0.1 
    	     }
	   }
	 }
	 
#declare AshFanOutTexture =
	texture {
		pigment { color rgbf<1,1,1,1> } 
		normal {waves 1 scale 3}
		finish { ambient .8 diffuse 0.7 }
	}
	
#declare AshFanOut =
	material {
		texture { AshFanOutTexture }
		interior { AshFanOutInterior }
	} 

 
//Stuff coming immediately out of the vent 

#declare ventstuff1 = union {

sphere { <0,0,0>,1 hollow material { PillowyUpdrafts} scale 1.4 rotate y*170 translate <8.7, 9.2, 20>}
sphere { <0,0,0>,1 hollow material { PillowyUpdrafts} scale 1.6 rotate y*170 translate <9.1, 9.2, 20>}
sphere { <0,0,0>,1 hollow material { PillowyUpdrafts} scale 1.8 rotate y*130 translate <8.7, 10.2, 20>}
sphere { <0,0,0>,1 hollow material { PillowyUpdrafts} scale 1.8 rotate y*110 translate <8.7, 11.2, 20>}
sphere { <0,0,0>,1 hollow material { PillowyUpdrafts} scale 2.2 translate <9, 12.2, 20>}
sphere { <0,0,0>,1 hollow material { PillowyUpdrafts} scale 2.6 rotate y*120 translate <9.1, 13.4, 20>}

       
} 

//Higher "pillows" of ash

#declare level3 = union {

sphere { <0, 0, 0>,1 hollow material { PillowyUpdrafts} scale 1.3 rotate RandRot() translate <0, 0, -3>}
sphere { <0, 0, 0>,1 hollow material { PillowyUpdrafts} scale 1.3 rotate RandRot() translate <1, 2, -3>}
sphere { <0, 0, 0>,1 hollow material { PillowyUpdrafts} scale 1.3 rotate RandRot() translate <2, 1, -1>}
sphere { <0, 0, 0>,1 hollow material { PillowyUpdrafts} scale 1.3 rotate RandRot() translate <1, -1, 0>}
sphere { <0, 0, 0>,1 hollow material { PillowyUpdrafts} scale 1.3 rotate RandRot() translate <-2, 0, -1>}
sphere { <0, 0, 0>,1 hollow material { PillowyUpdrafts} scale 1.3 rotate RandRot() translate <-1, 0, -2>}

}

//Group together some of the constructs

#declare abovevent2 = union {

object {level3 rotate RandRot() scale 1.4 translate <8.7, 19, 20>}    
object {level3 rotate RandRot() scale 1.4 translate <10.7, 19, 18>}
object {level3 rotate RandRot() scale 1.8 translate <6.7, 19, 21>}
object {level3 rotate RandRot() scale 1.8 translate <8.7, 17, 16>}

}     
 
//Put everything together
 
object {ventstuff1}   
object {ventstuff1 translate <0, 0, 0.1>} 
object {abovevent2 translate <0, 4, 0>}
object {abovevent2 translate <3, -1, 4>}  
object {abovevent2 translate <8, 6, 3>}
object {abovevent2 translate <14, 9, 0>}
object {abovevent2 translate <10, 7, 1>}
object {abovevent2 translate <-5, 7, 0>}
object {abovevent2 translate <5, 10, 2>}
object {abovevent2 translate <5, 16, 3>}
object {abovevent2 translate <15, 18, 0>}
object {abovevent2 translate <12, 16, 0>}  
object {abovevent2 translate <5, 2, 3>}
object {abovevent2 translate <-5, 20, 0>}
object {abovevent2 translate <24, 12, 0>}
object {abovevent2 translate <27, 16, 0>}  
object {abovevent2 translate <9, 18, 3>}
object {abovevent2 translate <17, 15, 0>} 
object {abovevent2 translate <0, 9, 10>}
object {abovevent2 translate <3, 4, 14>}  
object {abovevent2 translate <8, 11, 13>}
object {abovevent2 translate <14, 14, 10>}
object {abovevent2 translate <10, 12, 11>}
object {abovevent2 translate <-5, 12, 10>}
object {abovevent2 translate <5, 15, 12>}
object {abovevent2 translate <5, 21, 13>}
object {abovevent2 translate <15, 23, 10>}
object {abovevent2 translate <12, 21, 10>}  
object {abovevent2 translate <5, 7, 13>}
object {abovevent2 translate <-5, 25, 10>}
object {abovevent2 translate <24, 17, 10>}
object {abovevent2 translate <27, 21, 10>}  
object {abovevent2 translate <9, 23, 13>}
object {abovevent2 translate <17, 20, 10>}

sphere { <0,0,0>,1 hollow material { AshFanOut} scale <18, 4, 18> translate <24, 33, 33>}
sphere { <0,0,0>,1 hollow material { AshFanOut} scale <27, 3, 27> translate <42, 35, 45>}
sphere { <0,0,0>,1 hollow material { AshFanOut} scale <90, .55, 90> translate <75, 45, 70>}
sphere { <0,0,0>,1 hollow material { AshFanOut} scale <100, 100, 50> translate <95, 20, 80>}
 


//This is some background terrain
 
height_field { 
  tga "augustmount2.tga"
  smooth
  scale <100, 10, 100>
  pigment {Gray50} 
  finish {ambient 0.2}
  normal {wrinkles 1 scale 0.1}
  translate <8, 0, 0>
}  


//Stem for middle pinnacle

blob {
  threshold .65
  sphere { <7.9, 0, 5>,1, 1 }
  sphere { <8.3, 0.1, 5>,1, 1 }
  sphere { <7.1, 0, 5>,1, 1 }
  sphere { <6.3, -0.3, 5>,1, 1 }
  sphere { <5.7, -0.7, 5>,1, 1 }
  sphere { <7.7, 0, 4.7>,1, 1  }  
  sphere { <8.8, 0, 5>,1, 1 } 
  sphere { <9.7, 0, 5>,1, 1} 
  sphere { <9.7, 0.4, 5>,1, 1}
  sphere { <10.5, 0, 5>,1, 1} 
  sphere { <9.7, 0, 4.5>,1, 1} 
  sphere { <9.7, 0, 5.9>,1, 1}
  sphere { <8.8, 0, 5.9>,1, 1 }
  sphere { <8.8, 0.2, 4.5>,1, 1}
  sphere { <8.4, 0, 4.6>,1, 1} 
  
  //Start going up  
  
  sphere { <8.5, 0.8, 5>,0.7, 1}
  sphere { <8.8, 1.1, 5>,0.5, 1}
  sphere { <9.1, 0.6, 5>,0.7, 1}
  sphere { <9.1, 1.2, 5>,0.7, 1}
  sphere { <9.1, 1.8, 5>,0.7, 1}
  sphere { <9, 2.4, 5>,0.7, 1}
  sphere { <9.2, 3, 5>,0.7, 1}
  sphere { <9.6, 3.3, 5>,0.7, 1}
  sphere { <10, 3.6, 5>,0.7, 1}
  sphere { <10.3, 4.1, 5>,0.7, 1}
  sphere { <9.7, 3.8, 5>,0.7, 1}
  sphere { <9.3, 3.7, 5>,0.4, 1 }
  sphere { <9.1, 3.8, 5>,0.4, 1}
  sphere { <8.9, 3.8, 5>,0.4, 1}
  sphere { <8.7, 3.8, 5>,0.4, 1}
  sphere { <8.6, 3.9, 5>,0.3, 1}
  sphere { <8.4, 4, 5>,0.3, 1}
  sphere { <8.2, 4.05, 5>,0.3, 1 }
  sphere { <8.0, 4.05, 5>,0.3, 1}  
  pigment {rgb <0.2, 0.3, 0.3>} 
  finish {ambient 0.2}
  normal {wrinkles 1 scale 0.1} 
  scale 0.7  
  translate <1.2, 0, -2.5>
} 



//Cap for middle pinnacle

blob {
  threshold 0.65 
  sphere {<0, 0, 0>,1, 1 scale <1, 0.3, 1> translate <0, -0.65, 0>}
  sphere {<0, 0, 0>,1, 1 scale <1, 0.2, 1> translate <1, -0.65, 0>}
  sphere {<0, 0, 0>,1, 1 scale <1, 0.2, 1> translate <-1, -0.65, 0>} 
  sphere {<0, 0, 0>,1, 1.1 scale <3, 0.4, 3> translate <0.3, -0.6, 0>}
  sphere {<0, 0, 0>,1, 1.1 scale <1.8, 0.5, 1.8> translate <0, -0.45, 0>}
  sphere {<0, 0, 0>,1, 1 scale <1, 0.2, 1> translate <0.5, -0.65, 0.6>}
  sphere {<0, 0, 0>,1, 1 scale <1, 0.2, 1> translate <-0.5, -0.65, 0.6>}
  sphere {<0, 0, 0>,1, 1 scale <1, 0.2, 1> translate <-0.5, -0.65, -0.6>}
  sphere {<0, 0, 0>,1, 1 scale <1, 0.2, 1> translate <0.5, -0.65, -0.6>} 
  
  //Overhangs
  
  sphere {<0, 0, 0>,1, 1 scale 0.3 translate <-1.05, -0.8, -0.9>}
  sphere {<0, 0, 0>,1, 1 scale 0.3 translate <-0.95, -0.8, -0.8>}
  sphere {<0, 0, 0>,1, 1 scale 0.3 translate <-0.9, -0.75, -0.9>}
  sphere {<0, 0, 0>,1, 1 scale 0.3 translate <-0.8, -0.9, -1>}
  sphere {<0, 0, 0>,1, 1 scale 0.3 translate <-0.85, -0.8, -0.85>}
  sphere {<0, 0, 0>,1, 1 scale 0.3 translate <-0.7, -0.8, -0.8>}
  sphere {<0, 0, 0>,1, 1 scale <0.3, 0.5, 0.3> translate <-0.97, -0.9, -1.2>}
  sphere {<0, 0, 0>,1, 1 scale 0.4 translate <-0.5, -0.9, -1.2>}
  sphere {<0, 0, 0>,1, 1 scale 0.4 translate <-0.4, -0.9, -1.2>}
  sphere {<0, 0, 0>,1, 1 scale 0.4 translate <-0.3, -1.2, -1.2>}
  sphere {<0, 0, 0>,1, 1 scale 0.4 translate <-0.2, -0.9, -1.2>}
  sphere {<0, 0, 0>,1, 1 scale 0.5 translate <-0.1, -0.9, -0.8>} 
  sphere {<0, 0, 0>,1, 1 scale <0.2, 0.3, 0.2> translate <1.4, -0.9, -0.7>}
  sphere {<0, 0, 0>,1, 1 scale 0.3 translate <1.3, -0.8, -0.8>}
  sphere {<0, 0, 0>,1, 1 scale 0.3 translate <1.5, -0.8, -0.6>}
  scale 0.9
  translate <7.5, 3.52, 1.6>
  pigment {color ForestGreen}
  normal { bumps 0.2 scale 0.001}
}
 
 
//Trees on middle pinnacle 

object {PineTree2 scale 0.15 rotate <0, 0, -10> translate <8.5, 2.9, 1.5>}
object {PineTree2 scale 0.13 rotate <0, 0, 10> translate <8.5, 2.9, 1.5>}
object {PineTree2 scale 0.11 rotate <0, 0, -20> translate <8.7, 2.8, 1.5>}
object {PineTree2 scale 0.07 rotate <0, 0, 10> translate <6.5, 2.8, 1.5>} 
object {PineTree2 scale 0.1 translate <6.8, 2.8, 1.4>}
object {PineTree2 scale 0.14 translate <6.7, 2.8, 1.6>}
object {PineTree2 scale 0.18 translate <7, 2.8, 1.6>}
object {PineTree2 scale 0.15 rotate <0, 0, -12> translate <7.5, 2.8, 1.8>}   
object {PineTree2 scale 0.12 rotate <0, 0, -4> translate <7.6, 2.8, 1.2>}
object {PineTree2 scale 0.08 rotate <0, 0, 3> translate <7.4, 2.8, 1.2>}
object {PineTree2 scale 0.1 rotate <0, 0, 10> translate <7.8, 2.8, 1.2>} 

//Boulder on middle pinnacle

object {Boulder scale 1.2 rotate RandRot() translate <7.9, 3, 1.15> }



//Left blob cliffs

blob {
  threshold 0.65
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0.6, 0, 0>}
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0.35, 0.4, 0>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0, 0.8, 0>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <-0.2, 1.2, 0>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0, 1.6, 0>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0.35, 2, 0>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0.9, 2.4, 0>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0.5, 2.4, 0>}
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0.1, 2.4, 0>}
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <-0.3, 2.4, 0>}
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0.6, 0, -0.5>}
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0.35, 0.4, -0.5>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0, 0.8, -0.5>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <-0.2, 1.2, -0.5>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0, 1.6, -0.5>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0.35, 2, -0.5>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0.9, 2.4, -0.5>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0.5, 2.4, -0.5>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0.1, 2.4, -0.5>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <-0.3, 2.4, -0.5>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0.6, 0, -1>}
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0.35, 0.4, -1>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0, 0.8, -1>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <-0.2, 1.2, -1>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0, 1.6, -1>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0.35, 2, -1>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0.9, 2.4, -1>}  
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0.6, 0, -1.5>}
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0.55, 0.4, -1.5>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0.2, 0.8, -1.5>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0, 1.2, -1.5>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0.2, 1.6, -1.5>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0.55, 2, -1.5>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0.9, 2.4, -1.5>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0.9, 0, -2>}
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0.85, 0.4, -2>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0.5, 0.8, -12>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0.3, 1.2, -2>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0.5, 1.6, -2>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <0.85, 2, -2>} 
  sphere {<0, 0, 0>,1, 1 scale <0.7, 0.7, 0.7> translate <1.2, 2.4, -2>} 
  
  pigment {rgb <0.2, 0.3, 0.3>} 
  finish {ambient 0.1}
  normal {wrinkles 1 scale 0.1} 
  translate <3, 0, 1> 
}  

//Grassy caps on the right
                       
blob {
  threshold 0.65                       
  sphere { <0, 0, 0>,1, 1 scale <12, 1, 12> translate <17, 2.8, 4>}
  sphere { <0, 0, 0>,1, 1 scale <2, 0.5, 2> translate <12, 2.8, 2>}
  sphere { <0, 0, 0>,1, 1 scale <1.5, 0.5, 1.5> translate <13, 2.8, 1>}
  sphere { <0, 0, 0>,1, 1 scale <1.5, 0.3, 1.5> translate <12, 2.8, 0>}
  sphere { <0, 0, 0>,1, 1 scale <1, 0.2, 1> translate <11, 2.8, -1>} 
  sphere { <0, 0, 0>,1, 1 scale <1, 0.2, 1> translate <10, 2.8, -1.5>}
  sphere { <0, 0, 0>,1, 1 scale <1, 0.2, 1> translate <9.5, 2.8, -2>}
  sphere { <0, 0, 0>,1, 1 scale <1, 0.2, 1> translate <10, 2.8, -2.4>}
  sphere { <0, 0, 0>,1, 1 scale <2, 0.2, 2> translate <10.2, 2.8, -2.9>}
  sphere { <0, 0, 0>,1, 1 scale <2, 0.15, 2> translate <10.6, 2.8, -3.3>}
  pigment {color ForestGreen}
  normal { bumps 0.2 scale 0.001}
} 


//Supports for the right caps

blob {
  threshold .65
  sphere { <7.9, 0, 5>,1, 1 }
  sphere { <8.3, 0.1, 5>,1, 1 }
  sphere { <7.1, 0, 5>,1, 1 }
  sphere { <6.3, -0.3, 5>,1, 1 }
  sphere { <5.7, -0.7, 5>,1, 1 }
  sphere { <7.7, 0, 4.7>,1, 1  }  
  sphere { <8.8, 0, 5>,1, 1 } 
  sphere { <9.7, 0, 5>,1, 1} 
  sphere { <9.7, 0.4, 5>,1, 1}
  sphere { <10.5, 0, 5>,1, 1} 
  sphere { <9.7, 0, 4.5>,1, 1} 
  sphere { <9.7, 0, 5.9>,1, 1}
  sphere { <8.8, 0, 5.9>,1, 1 }
  sphere { <8.8, 0.2, 4.5>,1, 1}
  sphere { <8.4, 0, 4.6>,1, 1} 
  
  //Start going up  
  
  sphere { <8.5, 0.8, 5>,0.7, 1}
  sphere { <8.8, 1.1, 5>,0.5, 1}
  sphere { <9.1, 0.6, 5>,0.7, 1}
  sphere { <9.1, 1.2, 5>,0.7, 1}
  sphere { <9.1, 1.8, 5>,0.7, 1}
  sphere { <9, 2.4, 5>,0.7, 1}
  sphere { <9.2, 3, 5>,0.7, 1}
  sphere { <9.6, 3.3, 5>,0.7, 1}
  sphere { <10, 3.6, 5>,0.7, 1}
  sphere { <10.3, 4.1, 5>,0.5, 1}
  sphere { <9.7, 3.8, 5>,0.4, 1}
  sphere { <9.3, 3.7, 5>,0.4, 1 }
  sphere { <9.1, 3.8, 5>,0.4, 1}
  sphere { <8.9, 3.8, 5>,0.4, 1}
  sphere { <8.7, 3.8, 5>,0.4, 1}
  sphere { <8.6, 3.9, 5>,0.3, 1}
  sphere { <8.4, 4, 5>,0.3, 1}
  sphere { <8.2, 4.05, 5>,0.3, 1 }
  sphere { <8.0, 4.05, 5>,0.3, 1} 
  
  pigment {rgb <0.2, 0.3, 0.3>} 
  finish {ambient 0.2}
  normal {wrinkles 1 scale 0.1} 
  scale <1, 0.7, 1>  
  translate <4, 0, -2>
}

//This is the most visible support on the right        

blob {
  threshold .65
  sphere { <7.9, 0, 5>,1, 1 }
  sphere { <8.3, 0.1, 5>,1, 1 }
  sphere { <7.1, 0, 5>,1, 1 }
  sphere { <6.3, -0.3, 5>,1, 1 }
  sphere { <5.7, -0.7, 5>,1, 1 }
  sphere { <7.7, 0, 4.7>,1, 1  }  
  sphere { <8.8, 0, 5>,1, 1 } 
  sphere { <9.7, 0, 5>,1, 1} 
  sphere { <9.7, 0.4, 5>,1, 1}
  sphere { <10.5, 0, 5>,1, 1} 
  sphere { <9.7, 0, 4.5>,1, 1} 
  sphere { <9.7, 0, 5.9>,1, 1}
  sphere { <8.8, 0, 5.9>,1, 1 }
  sphere { <8.8, 0.2, 4.5>,1, 1}
  sphere { <8.4, 0, 4.6>,1, 1}
  sphere { <6, -0.5, 5>,2, 1}
  sphere { <7, -1, 4>,2, 1}
  sphere { <9, -1, 5>,2, 1}
  sphere { <10, -1, 5>,2, 1} 
  
  //Start going up
   
  sphere { <8.3, 0.8, 5>,0.8, 1}
  sphere { <8.1, 1.1, 5>,0.8, 1}
  sphere { <8.1, 0.6, 5>,0.8, 1}
  sphere { <8.5, 1.3, 4.5>,0.7, 1}
  sphere { <8.9, 1.5, 4.2>, 0.7, 1}
  sphere { <9.3, 1.6, 3.8>, 0.7, 1}
  sphere { <9.7, 2, 3.3>, 0.7, 1}
  sphere { <10.1, 2.5, 3>, 0.7, 1}
  sphere { <10.6, 3, 2.6>, 0.7, 1}
  sphere { <7.7, 1.2, 5>,0.7, 1}
  sphere { <7.3, 1.3, 5>,0.7, 1}
  sphere { <7, 1.5, 5>,0.7, 1}
  sphere { <7, 1.7, 5>,0.7, 1}
  sphere { <6.8, 1.9, 5>,0.7, 1}
  sphere { <6.4, 1.9, 5>,0.7, 1}
  sphere { <6.1, 2, 5>, 0.7, 1}
  sphere { <5.8, 2.5, 5>,0.7, 1}
  
  pigment {rgb <0.2, 0.3, 0.3>} 
  finish {ambient 0.2}
  normal {wrinkles 1 scale 0.1} 
  scale 0.7  
  translate <6, 0, -3.5>
}  



//Grassy cap on left cliff 

blob {
  threshold 0.65
  sphere {<0, 0, 0>,1, 1 scale <3, 1, 3> translate <3, 3, 1>}  
  sphere {<0, 0, 0>,1, 1 scale 0.7 translate <4.2, 2.6, 1>}
  sphere {<0, 0, 0>,1, 1 scale 0.4 translate <4.25, 2.3, 1>}
  sphere {<0, 0, 0>,1, 1 scale 0.7 translate <3.9, 2.6, 0.7>}
  sphere {<0, 0, 0>,1, 1 scale 0.7 translate <3.5, 2.6, 0.4>}
  sphere {<0, 0, 0>,1, 1 scale 0.7 translate <3.0, 2.6, 0.1>}      
  pigment {color ForestGreen}
  normal { bumps 0.2 scale 0.001}
} 



//Trees on right cliff 

#declare TreeGroup = union {

object {PineTree2 scale 0.17 translate <0, 0, 0>} 
object {PineTree2 scale 0.13 rotate <0, 0, -10> translate <0.6, 0, 0>}
object {PineTree2 scale 0.11 rotate <0, 0, 10> translate <-0.5, 0, 0>}
object {PineTree2 scale 0.07 translate <0.2, 0, 0.2>}
object {PineTree2 scale 0.06 translate <-0.2, 0, 0.2>}
object {PineTree2 scale 0.04 translate <0.15, 0, -0.25>}
object {PineTree2 scale 0.05 translate <-0.15, 0, -0.3>}

} 

object {TreeGroup translate <12.5, 2.8, 3>}
object {TreeGroup scale 1.2 translate <13, 2.8, 3>}
object {TreeGroup scale 0.6 translate <13.5, 2.8, 3>}
object {TreeGroup scale 0.3 translate <13.9, 2.8, 3>}
object {TreeGroup scale 0.3 translate <15, 2.8, 3>}
object {TreeGroup scale 0.6 translate <15.4, 2.8, 3>}
object {TreeGroup scale 1.2 translate <16, 2.8, 3>}
object {TreeGroup scale 0.6 translate <16, 2.8, 2.5>}
object {TreeGroup scale 0.6 translate <13, 2.8, 2.5>}
object {TreeGroup scale 0.3 translate <13, 2.8, 2.2>}
object {TreeGroup scale 0.3 translate <16, 2.8, 2.2>}
object {TreeGroup scale 1.2 translate <16, 2.8, 3>}

//Put Boulder here 

object {Boulder scale 1 translate <9.8, 3, -3.35> }

object {TreeGroup scale 0.8 translate <9.8, 2.8, -2.4>}
object {TreeGroup scale 1.2 translate <11, 2.8, -3.7>}

//This is the big pinetree on the right

object {PineTree scale <0.01, 0.01, 0.01> rotate <-90, 0, 0> translate <8.9, 3.35, -5.5>}




//Trees on left cliff

object {PineTree2 scale 0.3 translate <2, 2.8, 1.5>}
object {PineTree2 scale 0.2 translate <2.7, 2.8, 1.5>}

//Old rotting cabin on pinnacle
//Front Wall of cabin 
 
union { 

box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.26, 1.3>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.28, 1.3>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 0, 0> translate <7.8, 3.3, 1.3>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.32, 1.3>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 0, 0> translate <7.8, 3.34, 1.3>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 0, 0> translate <7.8, 3.36, 1.3>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.38, 1.3>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 0, 0> translate <7.8, 3.4, 1.3>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.42, 1.3>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 0, 0> translate <7.8, 3.44, 1.3>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.46, 1.3>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.48, 1.3>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 0, 0> translate <7.8, 3.5, 1.3>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.52, 1.3>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.54, 1.3>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.56, 1.3>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.58, 1.3>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 0, 0> translate <7.8, 3.6, 1.3>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 0, 0> translate <7.8, 3.62, 1.3>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.64, 1.3>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 0, 0> translate <7.8, 3.66, 1.3>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 0, 0> translate <7.8, 3.68, 1.3>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.7, 1.3>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.72, 1.3>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.74, 1.3>}

} 

//Back wall of cabin

union { 

box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 0, 0> translate <7.8, 3.26, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.28, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 0, 0> translate <7.8, 3.3, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.32, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 0, 0> translate <7.8, 3.34, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.36, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 0, 0> translate <7.8, 3.38, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.4, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 0, 0> translate <7.8, 3.42, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.44, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 0, 0> translate <7.8, 3.46, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.48, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.5, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 0, 0> translate <7.8, 3.52, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.54, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.56, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 0, 0> translate <7.8, 3.58, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 0, 0> translate <7.8, 3.6, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.62, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 0, 0> translate <7.8, 3.64, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.66, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.68, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 0, 0> translate <7.8, 3.7, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.72, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 0, 0> translate <7.8, 3.74, 1.5>}

translate <0, 0, 1>

} 

//Left wall
union { 

box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 90, 0> translate <7.9, 3.26, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 90, 0> translate <7.9, 3.28, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 90, 0> translate <7.9, 3.3, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 90, 0> translate <7.9, 3.32, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 90, 0> translate <7.9, 3.34, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 90, 0> translate <7.9, 3.36, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 90, 0> translate <7.9, 3.38, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 90, 0> translate <7.9, 3.4, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 90, 0> translate <7.9, 3.42, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 90, 0> translate <7.9, 3.44, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 90, 0> translate <7.9, 3.46, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 90, 0> translate <7.9, 3.48, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 90, 0> translate <7.9, 3.5, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 90, 0> translate <7.9, 3.52, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 90, 0> translate <7.9, 3.54, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 90, 0> translate <7.9, 3.56, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 90, 0> translate <7.9, 3.58, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 90, 0> translate <7.9, 3.6, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 90, 0> translate <7.9, 3.62, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 90, 0> translate <7.9, 3.64, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 90, 0> translate <7.9, 3.66, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 90, 0> translate <7.9, 3.68, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 90, 0> translate <7.9, 3.7, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, 90, 0> translate <7.9, 3.72, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, 90, 0> translate <7.9, 3.74, 1.5>} 

translate <-0.5, 0, 0>

}    

//Right wall
union { 

box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, -90, 0> translate <7.8, 3.26, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, -90, 0> translate <7.8, 3.28, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, -90, 0> translate <7.8, 3.3, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, -90, 0> translate <7.8, 3.32, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, -90, 0> translate <7.8, 3.34, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, -90, 0> translate <7.8, 3.36, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, -90, 0> translate <7.8, 3.38, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, -90, 0> translate <7.8, 3.4, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, -90, 0> translate <7.8, 3.42, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, -90, 0> translate <7.8, 3.44, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, -90, 0> translate <7.8, 3.46, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, -90, 0> translate <7.8, 3.48, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, -90, 0> translate <7.8, 3.5, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, -90, 0> translate <7.8, 3.52, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, -90, 0> translate <7.8, 3.54, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, -90, 0> translate <7.8, 3.56, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, -90, 0> translate <7.8, 3.58, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, -90, 0> translate <7.8, 3.6, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, -90, 0> translate <7.8, 3.62, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, -90, 0> translate <7.8, 3.64, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, -90, 0> translate <7.8, 3.66, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, -90, 0> translate <7.8, 3.68, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, -90, 0> translate <7.8, 3.7, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} scale 0.4 rotate <10, -90, 0> translate <7.8, 3.72, 1.5>}
box {<-1, -0.02, -0.02>, <1, 0.02, 0.02> pigment {color DarkBrown} rotate RandRot() scale 0.4 rotate <10, -90, 0> translate <7.8, 3.74, 1.5>} 

translate <0.5, 0, 0>

}

//Place our water
  
plane {y, 0.15
  texture {augustwater}
}  

//Mix a couple of fogs together

fog{
    color DarkSlateGray
    fog_type 2
    fog_alt 6
    fog_offset 0
    distance 70
    omega 0.35
    lambda 1.25
    octaves 5
}

fog{
    color rgbt <0.7, 0.8, 0.7, 0.6>
    fog_type 2
    fog_alt 0.2
    fog_offset 0
    distance 1
    omega 0.35
    lambda 1.25
    octaves 5
}  

      