//--------------------------------------------------------------------------
// The stem of a tree made with SPatch
//--------------------------------------------------------------------------

#declare Tree = object {
  #declare IMPORT_SPATCH = 1;
  #include "tree.inc" 
}

//--------------------------------------------------------------------------
// A Fern made with LSystem 3 using the model fern.ls
//--------------------------------------------------------------------------
/*12                                      # recursion
  20                                      # angle
  15                                      # thickness
  #
  #---------------------------------------- axioms
  #
  #c(12)&(60)C                            # use this as axiom to test a leave
  #c(12)b                                 # use this as axiom to test a branch
  c(12)b>(60)b>(60)b>(60)b>(60)b>(60)b    # the whole thing
  #
  # ---------------------------------------- rules
  #
  b=[&(30)A]
  #
  A=~(7)$t(.1)F[+(40)C][-(40)C]!(.95)~(7)t(.1)FA
  #
  C=~(10)$tF[+(60)L][-(60)L]C
  #
  L=[~(15)c(4){-f+f+f-|-f+f}]
  #
  F='(1.3)F'(.77)
  f='(1.3)f'(.77)
  #
  #~=_                                    # uncomment to remove random efx
  @                                       */
//--------------------------------------------------------------------------
//This object has the following minimum and maximum values:
//xmin=-375.67774, xmax=375.67774
//ymin=-245.64336, ymax=245.64308
//zmin=-443.33008, zmax=443.33017
//--------------------------------------------------------------------------

#declare declare_only = true;
read_mesh ("fern.pcm")

#declare Fern = union {
   object {Mesh[0] texture {Stem}}
   object {Mesh[1] texture {Leafs}}
   translate 245.643362*y
   scale 0.002
}

//--------------------------------------------------------------------------
// A plant with big leafes
//--------------------------------------------------------------------------

#declare leaf_body =object {
  intersection {
    sphere {0, 20}
    plane {z, 0 rotate  26*y translate -10*z inverse}
    plane {z, 0 rotate -26*y translate  10*z}   
  }
  texture {BigLeaf}
  clipped_by {plane {y, 0 rotate 22.5*z translate 8*y inverse}}
  clipped_by {sphere {0, 19.9 inverse}}
  bounded_by {sphere {0, 21}}
}

#declare stem = object {
  cylinder {z, -z, 1 scale <77, 77, 0.7> translate <-40, -40, 0>}
  texture {BigLeaf}
  clipped_by {plane {x, 0 rotate 22.5*z translate 20*x inverse}}
  clipped_by {quadric {<1, 1, 0>, <0, 0, 0>, <0, 0, 0>, -1 scale <76.5, 76.5, 1> translate <-40, -40, 0> inverse}}
}

#declare leaf = union {
  object {leaf_body}
  object {stem}
  translate <-37, 40, 0>   
}

#declare R = seed(1999);

#declare bunch4 = union {   // 4 leafs in a bunch
  object {leaf scale (0.8+0.2*rand(R))}
  object {leaf rotate  90*y scale (0.8+0.3*rand(R))}
  object {leaf rotate 180*y scale (0.8+0.3*rand(R))}
  object {leaf rotate 270*y scale (0.8+0.3*rand(R))}
}

#declare bunch3 = union {   // 3 leafs in a bunch
  object {leaf scale (0.8+0.3*rand(R))}
  object {leaf rotate 120*y scale (0.8+0.3*rand(R))}
  object {leaf rotate 240*y scale (0.8+0.3*rand(R))}
}

#declare LeafPlant = union {
  object {bunch4}
  object {bunch4 rotate 45*y}
  object {bunch3 rotate 15*y}
  scale 1/100
}

//--------------------------------------------------------------------------
// A bunch of grass centered at the origin with radius 1 and height 0.5
//--------------------------------------------------------------------------

#ifndef (G1)               #declare G1         = seed(42); #end
#ifndef (Grasn)            #declare Grasn      = 100;      #end
#ifndef (Grashvar)         #declare Grashvar   = 0.3;      #end
#ifndef (Grasrotvar)       #declare Grasrotvar = 20;       #end

#declare Grass = union {
  #declare Grasi=0;
  #while (Grasi<Grasn)
    #declare Grasi=Grasi+1;
    #declare Grasaussen=1-pow(rand(G1),1.5);
    bicubic_patch {
      type 0
      flatness 0.1
      u_steps 10
      v_steps 10
      < 0,     0, 0>,     < 0.0075,0,    -0.005>, < 0.015 ,0,    -0.005>, <0.02,  0,    0>,
      <-0.0075,0,-0.005>, < 0,     0.1875,0.05>,  < 0.01,  0.25,  0>    , <0.015, 0.25, 0.00>,
      <-0.015 ,0,-0.005>, <-0.01,  0.25,  0.00>,  < 0,     0.4375,0.1>  , <0.0075,0.375,0.07>,
      <-0.02,  0, 0>,     <-0.015, 0.25,  0.00> , <-0.0075,0.375, 0.07> , <0,     0.5,  0.15>
      pigment {color rgb <0.3+rand(G1)*0.2, 0.3+rand(G1)*0.3, rand(G1)*0.2>}
      finish {ambient 0.4 diffuse 1 phong 0.5 phong_size 40}
      scale <1-(Grashvar*rand(G1)), 1-(Grashvar*rand(G1))-(0.4*Grasaussen), 1+(0.2*Grasaussen)>
      #declare Grasrand=<0, 0.5, 0.15*(1+0.2*Grasaussen)>;
      #declare Grasrotate=(2*rand(G1))-1;
      rotate x*((30*Grasaussen)+(Grasrotvar*(Grasrotate)))
      #declare Grasrand=vrotate(Grasrand, x*((30*Grasaussen)+(Grasrotvar*(Grasrotate))));
      rotate z*Grasrotvar*((2*rand(G1))-1)
      rotate y*Grasrotvar*((2*rand(G1))-1)
      translate <0, 0, Grasaussen-Grasrand.z>
      rotate y*360*rand(G1)
    }
  #end
}  

//--------------------------------------------------------------------------
// A cup shaped mushroom made with SPatch
//--------------------------------------------------------------------------

#declare Mushroom1 = object {
  #declare IMPORT_SPATCH = 1;
  #include "mushroom1.inc" 
  texture {
    slope y
    texture_map {
      [0.0 MShroom2]
      [0.1 MShroom2]
      [0.3 MShroom1]
    }
  }
}

//--------------------------------------------------------------------------
// An other mushroom made with SPatch
//--------------------------------------------------------------------------
 
#declare IMPORT_SPATCH = 1;
#include "mushroom2.inc" 
#declare Mushroom2 = union {
  object {
    Layer1 
    texture {
      slope y
      texture_map {
        [0.00 MShroom3]
        [0.14 MShroom3]
        [0.24 MShroom4]
      }
    }  
  }
  object {Layer2 texture {MShroom5}}  
}
