#include "colors.inc"
#include "shapes.inc"

camera { location <0, 20, -3300>
         right x*4/3
         angle 45
         look_at <0, 600, 0> }

light_source { <5000, 250000, -140000> color White }

//Fort
#declare WallBase = texture { pigment { wrinkles turbulence 1.1
                                        octaves 8
                                        lambda 1.4
                                        omega 0.8
                                        color_map { [0 0.5 color CornflowerBlue color rgb <0.3, 0.4, 0.6>]
                                                    [0.5 1 color rgb <0.35, 0.45, 0.7> color rgb <0.6, 0.7, 1>] }
                                        scale 1500 }
                              finish { ambient 0.2 crand 0.1 } }
                    texture { pigment { bozo turbulence 0.8
                                        octaves 4
                                        lambda 5
                                        omega 0.4
                                        color_map { [0 color Clear]
                                                    [0.5 color Clear]
                                                    [0.7 color Gray80 filter 0.5]
                                                    [1 color Gray70 filter 0.5] }
                                        scale 500 }
                              finish { ambient 0.2 } }
// Keep
#declare KeepCren = union {
                    object { Cube scale <320, 5, 2> translate <0, 0, 36> }
                    object { Cube scale <320, 5, 2> translate <0, 0, 28> }
                    object { Cube scale <320, 5, 2> translate <0, 0, 20> }
                    object { Cube scale <320, 5, 2> translate <0, 0, 12> }
                    object { Cube scale <320, 5, 2> translate <0, 0, 4> }
                    object { Cube scale <320, 5, 2> translate <0, 0, -4> }
                    object { Cube scale <320, 5, 2> translate <0, 0, -12> }
                    object { Cube scale <320, 5, 2> translate <0, 0, -20> }
                    object { Cube scale <320, 5, 2> translate <0, 0, -28> }
                    object { Cube scale <320, 5, 2> translate <0, 0, -36> } }
#declare KeepCrens = union {
                     object { KeepCren translate <0, 0, -200> }
                     object { KeepCren translate <0, 0, -120> }
                     object { KeepCren translate <0, 0, -40> }
                     object { KeepCren translate <0, 0, 40> }
                     object { KeepCren translate <0, 0, 120> }
                     object { KeepCren translate <0, 0, 200> }
                     object { KeepCren translate <0, 0, 280> } }
#declare Keep = difference {
                object { Cube scale <500, 405, 500> translate <0, 405, 0> }
                plane { <0, 0, 1>, 0 rotate <15, 0, 0> translate <0, 0, -500> }
                plane { <1, 0, 0>, 0 rotate <0, 0, -15> translate <-500, 0, 0> }
                plane { <-1, 0, 0>, 0 rotate <0, 0, 15> translate <500, 0, 0> }
                plane { <0, 0, -1>, 0 rotate <-15, 0, 0> translate <0, 0, 500> }
            // crenellations
                object { Cube scale <280, 10, 280> translate <0, 810, 0> }
                object { KeepCrens translate <0, 810, 0> }
                object { KeepCrens translate <0, 810, 0> rotate <0, 90, 0> }
            // door
                object { Cube scale <50, 50, 100> translate <0, 50, -500> } }
// Tower
#declare Tower = difference {
                 object { Cube scale <200, 150, 200> translate <0, 150, 0> }
                 plane { <0, 0, 1>, 0 rotate <15, 0, 0> translate <0, 0, -200> }
                 plane { <1, 0, 0>, 0 rotate <0, 0, -15> translate <-200, 0, 0> }
                 plane { <-1, 0, 0>, 0 rotate <0, 0, 15> translate <200, 0, 0> }
                 plane { <0, 0, -1>, 0 rotate <-15, 0, 0> translate <0, 0, 200> }
             // crenellations
                 object { Cube scale <117, 10, 117> translate <0, 300, 0> }
                 object { KeepCren scale <2, 1, 1> translate <0, 300, 40> }
                 object { KeepCren scale <2, 1, 1> translate <0, 300, -40> }
                 object { KeepCren rotate <0, 90, 0> scale <1, 1, 2> translate <-40, 300, 0> }
                 object { KeepCren rotate <0, 90, 0> scale <1, 1, 2> translate <40, 300, 0> } }
// Turrets
#declare TurretCren = union {
                      object { Cube scale <45, 5, 2> translate <0, 0, 32> }
                      object { Cube scale <45, 5, 2> translate <0, 0, 24> }
                      object { Cube scale <45, 5, 2> translate <0, 0, 16> }
                      object { Cube scale <45, 5, 2> translate <0, 0, 8> }
                      object { Cube scale <45, 5, 2> translate <0, 0, 0> }
                      object { Cube scale <45, 5, 2> translate <0, 0, -8> }
                      object { Cube scale <45, 5, 2> translate <0, 0, -16> }
                      object { Cube scale <45, 5, 2> translate <0, 0, -24> }
                      object { Cube scale <45, 5, 2> translate <0, 0, -32> } }
#declare Turret = difference {
                  object { Cube scale <80, 200, 80> translate <0, -50, 0> }
                  plane { <0, 0, 1>, 0 rotate <-15, 0, 0> translate <0, 0, -80> }
                  plane { <-1, 0, 0>, 0 rotate <0, 0, -15> translate <80, 0, 0> }
                  plane { <1, 0, 0>, 0 rotate <0, 0, 15> translate <-80, 0, 0> }
                  plane { <0, 0, -1>, 0 rotate <15, 0, 0> translate <0, 0, 80> }
                  plane { <0, 0, 1>, 0 rotate <15, 0, 0> translate <0, 0, -80> }
                  plane { <-1, 0, 0>, 0 rotate <0, 0, 15> translate <80, 0, 0> }
                  plane { <1, 0, 0>, 0 rotate <0, 0, -15> translate <-80, 0, 0> }
                  plane { <0, 0, -1>, 0 rotate <-15, 0, 0> translate <0, 0, 80> }
              // crenellations
                  object { Cube scale <37, 10, 37> translate <0, 150, 0> }
                  object { TurretCren translate <0, 150, 0> }
                  object { TurretCren rotate <0, 90, 0> translate <0, 150, 0> }
              // slots
                  object { Cube scale <7, 80, 100> translate <-20, -100, 0> }
                  object { Cube scale <7, 80, 100> translate <20, -100, 0> }
                  object { Cube scale <100, 80, 7> translate <0, -100, -20> }
                  object { Cube scale <100, 80, 7> translate <0, -100, 20> } }
#declare Buttress = intersection {
                    plane { <1, 0, 0>, 0 }
                    plane { <0, -1, 0>, 0 }
                    plane { <0, 0, -1>, 0 rotate <20, 0, 0> rotate <0, 25, 0> translate <-500, 0, 0> }
                    plane { <0, 0, 1>, 0 rotate <-20, 0, 0> rotate <0, -25, 0> translate <-500, 0, 0> }
                    translate <-350, 0, 0>
                    rotate <0, 45, 0> }
#declare Fort = union {
                object { Keep }
                object { Tower translate <0, 800, 0> }
                object { Turret translate <300, 800, -300> }
                object { Turret translate <-300, 800, -300> }
                object { Turret translate <-300, 800, 300> }
                object { Turret translate <300, 800, 300> }
                object { Buttress }
                object { Buttress rotate <0, 90, 0> }
                object { Buttress rotate <0, 180, 0> }
                object { Buttress rotate <0, 270, 0> }
                texture { WallBase }
                texture { pigment { image_map { gif "Biggreen.gif"
                                                once
                                                filter 255, 1
                                                filter 35, 0.5 }
                                    translate <-0.5, 0, 0>
                                    scale <1000, 800, 1> }
                          finish { ambient 0.2 } }
                texture { pigment { image_map { gif "Biggreen.gif"
                                                once
                                                filter 255, 1
                                                filter 35, 0.5 }
                                    translate <-0.5, 0, 0>
                                    scale <1000, 800, 1>
                                    rotate <0, 90, 0> }
                          finish { ambient 0.2 } }
                texture { pigment { image_map { gif "Towergre.gif"
                                                once
                                                filter 255, 1
                                                filter 35, 0.5 }
                                    translate <-0.5, 0, 0>
                                    scale <400, 300, 1>
                                    translate <0, 800, 0> }
                          finish { ambient 0.2 } }
                texture { pigment { image_map { gif "Towergre.gif"
                                                once
                                                filter 255, 1
                                                filter 35, 0.5 }
                                    translate <-0.5, 0, 0>
                                    scale <400, 300, 1>
                                    rotate <0, 90, 0>
                                    translate <0, 800, 0> }
                          finish { ambient 0.2 } }
                texture { pigment { image_map { gif "Turretgr.gif"
                                                once
                                                filter 255, 1
                                                filter 35, 0.5 }
                                    translate <-0.5, 0, 0>
                                    scale <760, 120, 1>
                                    translate <0, 800, 0> }
                          finish { ambient 0.2 } }
                texture { pigment { image_map { gif "Turretgr.gif"
                                                once
                                                filter 255, 1
                                                filter 35, 0.5 }
                                    translate <-0.5, 0, 0>
                                    scale <760, 120, 1>
                                    rotate <0, 90, 0>
                                    translate <0, 800, 0> }
                          finish { ambient 0.2 } } }
// Ground
#declare th = 2.5
#declare One = object { Cube scale <5+th, 500, th> translate <0, -500, 0> }
#declare Two = object { Cube scale <10+th, 500, th> translate <0, -500, 0> }
#declare Three = object { Cube scale <15+th, 500, th> translate <0, -500, 0> }
#declare Four = object { Cube scale <20+th, 500, th> translate <0, -500, 0> }
#declare Five = object { Cube scale <25+th, 500, th> translate <0, -500, 0> }
#declare Six = object { Cube scale <30+th, 500, th> translate <0, -500, 0> }
#declare Seven = object { Cube scale <35+th, 500, th> translate <0, -500, 0> }
#declare Maze = union {
            // horizontals
                object { Two translate <-15, 0, 0> }
                object { One translate <10, 0, 0> }
                object { Three translate <-40, 0, 20> }
                object { Four translate <55, 0, 20> }
                object { Four translate <-65, 0, 30> }
                object { Four translate <-15, 0, 30> }
                object { Two translate <35, 0, 30> }
                object { Three translate <70, 0, 30> }
                object { Six translate <-55, 0, 40> }
                object { Four translate <15, 0, 40> }
                object { Five translate <80, 0, 40> }
                object { Five translate <-90, 0, 50> }
                object { Two translate <-35, 0, 50> }
                object { Three translate <20, 0, 50> }
                object { Five translate <80, 0, 50> }
                object { Six translate <-85, 0, 60> }
                object { Two translate <-35, 0, 60> }
                object { One translate <0, 0, 60> }
                object { Two translate <25, 0, 60> }
                object { Six translate <75, 0, 60> }
                object { Seven translate <-80, 0, 70> }
                object { One translate <-30, 0, 70> }
                object { One translate <-10, 0, 70> }
                object { One translate <50, 0, 70> }
                object { Four translate <85, 0, 70> }
                object { Seven translate <-90, 0, 80> }
                object { One translate <-30, 0, 80> }
                object { One translate <10, 0, 80> }
                object { Two translate <45, 0, 80> }
                object { Five translate <90, 0, 80> }
                object { Two translate <-115, 0, 90> }
                object { Two translate <-85, 0, 90> }
                object { One translate <-60, 0, 90> }
                object { One translate <-40, 0, 90> }
                object { Two translate <15, 0, 90> }
                object { Three translate <50, 0, 90> }
                object { Six translate <95, 0, 90> }
                object { Two translate <-115, 0, 100> }
                object { Two translate <-75, 0, 100> }
                object { One translate <-50, 0, 100> }
                object { Two translate <15, 0, 100> }
                object { Five translate <100, 0, 100> }
                object { Three translate <-110, 0, 110> }
                object { One translate <-80, 0, 110> }
                object { Two translate <-55, 0, 110> }
                object { One translate <-10, 0, 110> }
                object { Two translate <35, 0, 110> }
                object { Five translate <100, 0, 110> }
                object { Four translate <-105, 0, 120> }
                object { Four translate <-65, 0, 120> }
                object { One translate <-20, 0, 120> }
                object { One translate <50, 0, 120> }
                object { Six translate <95, 0, 120> }
                object { Three translate <-110, 0, 130> }
                object { One translate <-80, 0, 130> }
                object { Two translate <-55, 0, 130> }
                object { One translate <-30, 0, 130> }
                object { Two translate <15, 0, 130> }
                object { Five translate <60, 0, 130> }
                object { Five translate <90, 0, 130> }
                object { Six translate <-95, 0, 140> }
                object { One translate <-50, 0, 140> }
                object { One translate <-30, 0, 140> }
                object { One translate <0, 0, 140> }
                object { Two translate <25, 0, 140> }
                object { Two translate <55, 0, 140> }
                object { Five translate <120, 0, 140> }
                object { Four translate <-105, 0, 150> }
                object { Two translate <-65, 0, 150> }
                object { Two translate <-25, 0, 150> }
                object { One translate <0, 0, 150> }
                object { Three translate <30, 0, 150> }
                object { One translate <60, 0, 150> }
                object { Five translate <120, 0, 150> }
                object { Three translate <-110, 0, 160> }
                object { Two translate <-15, 0, 160> }
                object { One translate <20, 0, 160> }
                object { Two translate <45, 0, 160> }
                object { One translate <80, 0, 160> }
                object { Five translate <120, 0, 160> }
                object { Three translate <-110, 0, 170> }
                object { One translate <-10, 0, 170> }
                object { Five translate <60, 0, 170> }
                object { Six translate <115, 0, 170> }
            // verticals
                object { Two rotate <0, 90, 0> translate <-95, 0, 100> }
                object { One rotate <0, 90, 0> translate <-85, 0, 105> }
                object { Two rotate <0, 90, 0> translate <-85, 0, 130> }
                object { Two rotate <0, 90, 0> translate <-85, 0, 160> }
                object { One rotate <0, 90, 0> translate <-75, 0, 95> }
                object { One rotate <0, 90, 0> translate <-75, 0, 115> }
                object { Two rotate <0, 90, 0> translate <-75, 0, 160> }
                object { One rotate <0, 90, 0> translate <-65, 0, 105> }
                object { One rotate <0, 90, 0> translate <-65, 0, 135> }
                object { One rotate <0, 90, 0> translate <-65, 0, 165> }
                object { One rotate <0, 90, 0> translate <-55, 0, 55> }
                object { Two rotate <0, 90, 0> translate <-55, 0, 90> }
                object { Three rotate <0, 90, 0> translate <-55, 0, 155> }
                object { One rotate <0, 90, 0> translate <-45, 0, 55> }
                object { Two rotate <0, 90, 0> translate <-45, 0, 80> }
                object { Two rotate <0, 90, 0> translate <-45, 0, 160> }
                object { One rotate <0, 90, 0> translate <-35, 0, 35> }
                object { One rotate <0, 90, 0> translate <-35, 0, 75> }
                object { Four rotate <0, 90, 0> translate <-35, 0, 110> }
                object { Two rotate <0, 90, 0> translate <-35, 0, 160> }
                object { Two rotate <0, 90, 0> translate <-25, 0, 10> }
                object { One rotate <0, 90, 0> translate <-25, 0, 65> }
                object { Four rotate <0, 90, 0> translate <-25, 0, 100> }
                object { One rotate <0, 90, 0> translate <-25, 0, 135> }
                object { One rotate <0, 90, 0> translate <-25, 0, 165> }
                object { Seven rotate <0, 90, 0> translate <-15, 0, 40> }
                object { Three rotate <0, 90, 0> translate <-15, 0, 95> }
                object { Three rotate <0, 90, 0> translate <-15, 0, 135> }
                object { Two rotate <0, 90, 0> translate <-5, 0, 10> }
                object { Two rotate <0, 90, 0> translate <-5, 0, 50> }
                object { Seven rotate <0, 90, 0> translate <-5, 0, 105> }
                object { One rotate <0, 90, 0> translate <-5, 0, 155> }
                object { Two rotate <0, 90, 0> translate <5, 0, 10> }
                object { Three rotate <0, 90, 0> translate <5, 0, 65> }
                object { Three rotate <0, 90, 0> translate <5, 0, 125> }
                object { Two rotate <0, 90, 0> translate <5, 0, 160> }
                object { Four rotate <0, 90, 0> translate <15, 0, 20> }
                object { Two rotate <0, 90, 0> translate <15, 0, 70> }
                object { Three rotate <0, 90, 0> translate <15, 0, 115> }
                object { Three rotate <0, 90, 0> translate <25, 0, 15> }
                object { Three rotate <0, 90, 0> translate <25, 0, 75> }
                object { Two rotate <0, 90, 0> translate <25, 0, 120> }
                object { One rotate <0, 90, 0> translate <25, 0, 165> }
                object { One rotate <0, 90, 0> translate <35, 0, 35> }
                object { One rotate <0, 90, 0> translate <35, 0, 55> }
                object { Three rotate <0, 90, 0> translate <35, 0, 85> }
                object { Two rotate <0, 90, 0> translate <35, 0, 130> }
                object { Four rotate <0, 90, 0> translate <45, 0, 50> }
                object { Two rotate <0, 90, 0> translate <45, 0, 110> }
                object { One rotate <0, 90, 0> translate <45, 0, 145> }
                object { One rotate <0, 90, 0> translate <55, 0, 45> }
                object { One rotate <0, 90, 0> translate <55, 0, 75> }
                object { Three rotate <0, 90, 0> translate <55, 0, 105> }
                object { One rotate <0, 90, 0> translate <55, 0, 155> }
                object { Two rotate <0, 90, 0> translate <65, 0, 70> }
                object { Three rotate <0, 90, 0> translate <65, 0, 105> }
                object { One rotate <0, 90, 0> translate <65, 0, 145> }
                object { One rotate <0, 90, 0> translate <65, 0, 165> }
                object { Two rotate <0, 90, 0> translate <75, 0, 150> }
                object { Three rotate <0, 90, 0> translate <85, 0, 155> }
                object { One rotate <0, 90, 0> translate <95, 0, 115> }
                object { One rotate <0, 90, 0> translate <105, 0, 135> }
                texture { pigment { crackle turbulence 0.3
                                    lambda 4
                                    color_map { [0 color Tan]
                                                [1 color DarkWood] }
                                    scale <0.5, 5, 0.5> }
                          finish { ambient 0.2 } }
                texture { pigment { bozo turbulence 0.8
                                    lambda 4
                                    omega 0.5
                                    color_map { [0 color DarkWood filter 0.6]
                                                [0.5 color DarkWood filter 0.75]
                                                [0.7 color Clear]
                                                [1 color Clear] }
                                    scale 5 }
                          finish { ambient 0.2 } } }
// Obelisk
#declare Obelisk = union {
                   difference { object { Cube scale <10, 10, 10> translate <0, 10, 0> }
                                plane { <1, 0, 0>, 0 rotate <0, 0, -15> translate <-10, 0, 0> }
                                plane { <-1, 0, 0>, 0 rotate <0, 0, 15> translate <10, 0, 0> }
                                plane { <0, 0, 1>, 0 rotate <15, 0, 0> translate <0, 0, -10> }
                                plane { <0, 0, -1>, 0 rotate <-15, 0, 0> translate <0, 0, 10> } }
                   difference { object { Cube scale <7, 40, 7> translate <0, 40, 0> }
                                plane { <1, 0, 0>, 0 rotate <0, 0, -3> translate <-7, 0, 0> }
                                plane { <-1, 0, 0>, 0 rotate <0, 0, 3> translate <7, 0, 0> }
                                plane { <0, 0, 1>, 0 rotate <3, 0, 0> translate <0, 0, -7> }
                                plane { <0, 0, -1>, 0 rotate <-3, 0, 0> translate <0, 0, 7> }
                                plane { <1, 0, 0>, 0 rotate <0, 0, -45> translate <0, 80, 0> }
                                plane { <-1, 0, 0>, 0 rotate <0, 0, 45> translate <0, 80, 0> }
                                plane { <0, 0, 1>, 0 rotate <45, 0, 0> translate <0, 80, 0> }
                                plane { <0, 0, -1>, 0 rotate <-45, 0, 0> translate <0, 80, 0> }
                                object { Cube scale <10, 1, 10> translate <0, 65, 0> }
                                object { Cube scale <10, 1, 10> translate <0, 61, 0> } }
                   object { Cube scale <3.5, 1, 3.5> translate <0, 61, 0> }
                   object { Cube scale <3.2, 1, 3.2> translate <0, 65, 0> }
                   scale 0.35
                   texture { WallBase scale 0.025 } }
// Bridge
#declare Post = union {
                object { Cube scale <5, 5, 5> }
                cylinder { <0, 5, 0>, <0, 10, 0>, 4.5 }
                object { Cube scale <5, 5, 5> translate <0, 15, 0> }
                sphere { <0, 20, 0>, 4.5 }
                sphere { <0, 0, 0>, 4.5 scale <1, 1, 0.2> translate <0, 15, -5> }
                sphere { <0, 0, 0>, 4.5 scale <1, 1, 0.2> translate <0, 15, 5> }
                sphere { <0, 0, 0>, 4.5 scale <0.2, 1, 1> translate <-5, 15, 0> }
                sphere { <0, 0, 0>, 4.5 scale <0.2, 1, 1> translate <5, 15, 0> }
                sphere { <0, 0, 0>, 4.5 scale <0.2, 1, 1> translate <5, 0, 0> }
                scale 0.03 }
#declare Rod = cylinder { <0, 30, -0.5>, <0, 30, 0.5>, 0.02 }
#declare RRod = cylinder { <0, 0, -0.5>, <0, 0, 0.5>, 0.02 }
#declare Footbit = union { object { Rod rotate <0, 0, -1.8> }
                           object { Rod rotate <0, 0, -1.4> }
                           object { Rod rotate <0, 0, -1> }
                           object { Rod rotate <0, 0, -0.6> }
                           object { Rod rotate <0, 0, -0.2> }
                           object { Rod rotate <0, 0, 0.2> }
                           object { Rod rotate <0, 0, 0.6> }
                           object { Rod rotate <0, 0, 1> }
                           object { Rod rotate <0, 0, 1.4> }
                           object { Rod rotate <0, 0, 1.8> } }
#declare Railings = intersection {
                    union {
                       object { RRod rotate <90, 0, 0> scale <1, 5, 1> rotate <0, 0, 45> translate <4, 0, 0> }
                       object { RRod rotate <90, 0, 0> scale <1, 5, 1> rotate <0, 0, 45> translate <3, 0, 0> }
                       object { RRod rotate <90, 0, 0> scale <1, 5, 1> rotate <0, 0, 45> translate <2, 0, 0> }
                       object { RRod rotate <90, 0, 0> scale <1, 5, 1> rotate <0, 0, 45> translate <1, 0, 0> }
                       object { RRod rotate <90, 0, 0> scale <1, 5, 1> rotate <0, 0, 45> }
                       object { RRod rotate <90, 0, 0> scale <1, 5, 1> rotate <0, 0, 45> translate <-1, 0, 0> }
                       object { RRod rotate <90, 0, 0> scale <1, 5, 1> rotate <0, 0, 45> translate <-2, 0, 0> }
                       object { RRod rotate <90, 0, 0> scale <1, 5, 1> rotate <0, 0, 45> translate <-3, 0, 0> }
                       object { RRod rotate <90, 0, 0> scale <1, 5, 1> rotate <0, 0, 45> translate <-4, 0, 0> }
                       object { RRod rotate <90, 0, 0> scale <1, 5, 1> rotate <0, 0, -45> translate <4, 0, 0> }
                       object { RRod rotate <90, 0, 0> scale <1, 5, 1> rotate <0, 0, -45> translate <3, 0, 0> }
                       object { RRod rotate <90, 0, 0> scale <1, 5, 1> rotate <0, 0, -45> translate <2, 0, 0> }
                       object { RRod rotate <90, 0, 0> scale <1, 5, 1> rotate <0, 0, -45> translate <1, 0, 0> }
                       object { RRod rotate <90, 0, 0> scale <1, 5, 1> rotate <0, 0, -45> }
                       object { RRod rotate <90, 0, 0> scale <1, 5, 1> rotate <0, 0, -45> translate <-1, 0, 0> }
                       object { RRod rotate <90, 0, 0> scale <1, 5, 1> rotate <0, 0, -45> translate <-2, 0, 0> }
                       object { RRod rotate <90, 0, 0> scale <1, 5, 1> rotate <0, 0, -45> translate <-3, 0, 0> }
                       object { RRod rotate <90, 0, 0> scale <1, 5, 1> rotate <0, 0, -45> translate <-4, 0, 0> } }
                    difference { cylinder { <0, -29.7+(15*0.03), -1>, <0, -29.7+(15*0.03), 1>, 30 }
                                 cylinder { <0, -29.7, -1.5>, <0, -29.7, 1.5>, 30 }
                                 plane { <0, 1, 0>, -5 }
                                 plane { <1, 0, 0>, -5 }
                                 plane { <-1, 0, 0>, -5 } } }
#declare Bridge = union {
                  object { Post translate <-5.1, -0.1, -0.5> }
                  object { Post translate <-5.1, -0.1, 0.5> }
                  object { Post rotate <0, 180, 0> translate <5.1, -0.1, -0.5> }
                  object { Post rotate <0, 180, 0> translate <5.1, -0.1, 0.5> }
                  difference { union { torus { 30, 0.06 rotate <90, 0, 0> translate <0, -29.7, 0.5> }
                                       torus { 30, 0.06 rotate <90, 0, 0> translate <0, -29.7, -0.5> }
                                       torus { 30, 0.02 rotate <90, 0, 0> translate <0, -29.7, -0.4> }
                                       torus { 30, 0.02 rotate <90, 0, 0> translate <0, -29.7, -0.3> }
                                       torus { 30, 0.02 rotate <90, 0, 0> translate <0, -29.7, -0.2> }
                                       torus { 30, 0.02 rotate <90, 0, 0> translate <0, -29.7, -0.1> }
                                       torus { 30, 0.02 rotate <90, 0, 0> translate <0, -29.7, 0> }
                                       torus { 30, 0.02 rotate <90, 0, 0> translate <0, -29.7, 0.1> }
                                       torus { 30, 0.02 rotate <90, 0, 0> translate <0, -29.7, 0.2> }
                                       torus { 30, 0.02 rotate <90, 0, 0> translate <0, -29.7, 0.3> }
                                       torus { 30, 0.02 rotate <90, 0, 0> translate <0, -29.7, 0.4> }
                                       torus { 30, 0.04 rotate <90, 0, 0> translate <0, -29.7+(15*0.03), 0.5> }
                                       torus { 30, 0.04 rotate <90, 0, 0> translate <0, -29.7+(15*0.03), -0.5> } }
                               plane { <1, 0, 0>, -5 }
                               plane { <-1, 0, 0>, -5 }
                               plane { <0, 1, 0>, -5 } }
                  object { Footbit rotate <0, 0, 8> translate <0, -29.7, 0> }
                  object { Footbit rotate <0, 0, 4> translate <0, -29.7, 0> }
                  object { Footbit translate <0, -29.7, 0> }
                  object { Footbit rotate <0, 0, -4> translate <0, -29.7, 0> }
                  object { Footbit rotate <0, 0, -8> translate <0, -29.7, 0> }
                  object { Railings translate <0, 0, -0.5> }
                  object { Railings translate <0, 0, 0.5> }
                  scale 17.65/2
                  pigment { color Brass }
                  finish { ambient 0.2 phong 1 phong_size 5 }
                  normal { bumps 0.2 scale 0.02 } }

object { Maze scale 17.65 translate <0, 0, -3000> }
object { Fort rotate <0, -25, 0> }
union { object { Obelisk translate <5, 0, 0>*17.65 }
        object { Obelisk translate <-5, 0, 20>*17.65 }
        object { Obelisk translate <-15, 0, 30>*17.65 }
        object { Obelisk translate <5, 0, 30>*17.65 }
        object { Obelisk translate <15, 0, 40>*17.65 }
        object { Obelisk translate <-5, 0, 60>*17.65 }
        object { Obelisk translate <5, 0, 80>*17.65 }
        object { Obelisk translate <35, 0, 40>*17.65 }
        object { Obelisk translate <-15, 0, 110>*17.65 }
        object { Obelisk translate <25, 0, 90>*17.65 }
        object { Obelisk translate <65, 0, 120>*17.65 }
        object { Obelisk translate <-45, 0, 110>*17.65 }
        translate <0, 0, -3000> }
union { object { Bridge rotate <0, 90, 0> translate <5, 0, 25>*17.65 }
        object { Bridge translate <0, 0, 5>*17.65 }
        object { Bridge translate <20, 0, 25>*17.65 }
        object { Bridge translate <-20, 0, 50>*17.65 }
        object { Bridge translate <0, 0, 100>*17.65 }
        object { Bridge rotate <0, 90, 0> translate <-30, 0, 45>*17.65 }
        translate <0, 0, -3000> }

// Background, landscape, etc
#declare CloudTexture = pigment { bozo turbulence 1
                                  octaves 8
                                  lambda 5
                                  omega 0.35
                                  color_map { [0 color White filter 0.75]
                                              [0.3 color White filter 0.95]
                                              [0.6 color Clear]
                                              [1 color Clear] }
                                  scale 0.1 }
difference { plane { <0, 1, 0>, 0 }
             plane { <0, 1, 0>, -1 }
             translate <0, 350, 0>
             pigment { wood pigment_map { [0 color Clear]
                                          [0.15 Clear]
                                          [0.2 CloudTexture]
                                          [1 CloudTexture] }
                       rotate <90, 0, 0>
                       scale 6000 }
             finish { ambient 1 } }
fog { fog_type 2
      distance 1000
      color White
      fog_alt 50 }
difference { sphere { <0, 0, 0>, 10000 }
             sphere { <0, 0, 0>, 9999 }
             pigment { gradient y
                       color_map { [0 color White filter 0.6]
                                   [0.5 color Pink filter 0.6]
                                   [1 color IndianRed filter 0.6] }
                       scale 10000 }
             finish { ambient 1 diffuse 0 }
             no_shadow }
sphere { <-15000, 10000, 50000>, 10000
         pigment { bozo turbulence 0.9
                   color_map { [0 color White]
                               [0.5 color Gray80]
                               [1 color Black] }
                   scale 5000 } }
sphere { <15000, 17000, 50000>, 4000
         pigment { bozo turbulence 0.9
                   color_map { [0 color White]
                               [0.5 color Gray80]
                               [1 color Black] }
                   scale 1700 } }
