
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: Land of the Giants
// Date: 99/02/15
// Auth: Matthias M. Giwer

// 0d9h05m51s render PPro 333MHz at max_trace_level 6 render time 
// roughly proportional to mtl number 

// 2h 50m on a clean boot

global_settings { assumed_gamma 2.2 
				max_trace_level 6 } // 6

// numbers from the same test area, aquamarine and coins in lower right
// at 5 35 pps 20 min
// at 6 25 pps 24 min
// at 8 18 pps 30 min
// at 11 12 pps 55 min
#include "colors.inc"
#include "shapes.inc"

// ----------------------------------------

#declare place = 1*<3,2.75,4> ;

camera
{
  location  place //<0.0, 0.5, -2.4> // close to the y wall
  direction 1.25*z // 1.5*x
  right     4/3*x
  look_at   <0.0, 2.5, 0.0>
}
  
light_source
{
  0*x 
  color < 1, 1, 1> 
  translate place + <-3, 10, -3>
}

/*/  more than four times slower
// An area light (creates soft shadows)
// WARNING: This special light can significantly slow down rendering times!
light_source
{
  0*x // light's position (translated below)
  color rgb 1.0  // light's color
  // <widthVector> <heightVector> nLightsWide mLightsHigh
  area_light
  <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
  2, 2                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3... 
  jitter              // adds random softening of light
  translate place + <-3, 10, -3> //<40, 80, -40>   // <x y z> position of light
} */
  

light_source
{
  0*x 
  color <0.33, .33, .33> 
  translate place + <3, 10, 3>
} 

/*
light_source
{
  0*x 
  color < 0, 0, .33> 
  translate place + <-4, 10, -3>
} 
*/


// ----------------------------------------                
// 1 unit = 1 inch 

plane { y, 100 
   pigment {color rgb <1,1,1>} 
   finish {reflection 0.9}
   } // ceiling

plane { y, -60
   pigment {color rgb <0.7,0.7,0.7>}
   finish {reflection 0.9*<0.5,0.5,0.5>}
   } // floor

plane { x, -600
   pigment {color rgb <0.5,0.5,0.5>}
   finish {reflection 0.9*<0.5,0.5,0.5>}
} // -x wall

plane { x, 600
   pigment {color rgb <0.5,0.5,0.5>}
   finish {reflection 0.9*<0.5,0.5,0.5>}
} //+x wall

plane { z, -600
   pigment {color rgb <0.5,0.5,0.5>}
   finish {reflection 0.9*<0.5,0.5,0.5>}
} //-z wall

plane { z, 600
   pigment {color rgb <0.5,0.5,0.5>}
   finish {reflection 0.9*<0.5,0.5,0.5>}
} // +z wall


//----- jewel box

#declare bgrainmz = pigment {
   wood
   turbulence 0.01
   octaves 4
   lambda 3
   scale <1, .2, .02>  //2 //0.02
   rotate <0.125, 0.125, 0>
   } // end pigment declare

#declare bgrainpz = pigment {
   wood
   turbulence 0.1
   octaves 4
   lambda 3
   scale <1, .2, .02> //0.02
   rotate <0.125, 0.125, 0>
} // end pigment declare  plus z placement // left wall

#declare bgrainmx = pigment {
   wood
   turbulence 0.01
   octaves 4
   lambda 3
   scale < 1, .2, .02>//  0.02
   rotate <0.125, 0.125, 0>
} // end pigment declare minus x placement // right wall

#declare bgrainpx = pigment {
   wood
   turbulence 0.1
   octaves 4
   lambda 3
   scale <1, .2, .02> // 0.02
   rotate <0.125, 0.125, 0>
   } // end pigment declare

#declare bfinish = finish {
   reflection <0.3,0.0,0.0>
   roughness 0.01
   } // edn finish declare

#declare bgrainpeg = pigment {
   wood
   turbulence 0.05
   octaves 4
   lambda 3
   scale <1, .22, .02>  //2 //0.02
   rotate <0.125, 0.125, 0>
   } // end pigment declare

#declare bfinishpeg = finish {
   reflection <0.9, 0.6, 0.0>
   roughness 0.1
   } // end finish declare

cylinder
{
  0*x,  5*x,  1
   pigment {bgrainpeg}
   finish {bfinishpeg}
   translate <-27,32.5,12>
   rotate <0,-90,0>
   scale 1/6
}
#declare end_cap = union {
   superellipsoid {<.5,.3>} // .5 .5
   scale <1.1,1.1,0.3> // 1.1 1.1 0.3
   scale 1/4
   pigment {bgrainmx}//peg}
   finish {bfinish}//peg}
   rotate <0,0,0>
//   scale <1.1,1.1,0.3>
//   scale 1/4
   //pigment {bgrainmx}//peg}
   //finish {bfinish}//peg}
   translate <-2.,5.45,-3.7>
   rotate <0,0,0>
   //scale 1/6
//   translate <0,2,0> 
}
end_cap


box { <-1,-1,-1> <1,1,1>
   pigment {bgrainmz}
   finish { bfinish }
   scale <5, 3, 1/2>
   translate <0,3,5> 
   } // end box -z wall

box { <-1,-1,-1> <1,1,1>
   pigment { bgrainpz }
   finish { bfinish }
   scale <5, 3, 1/2>
   translate <0,3,-5>
   } // end box +z wall
                      
box { <-1,-1,-1> <1,1,1>
   pigment { bgrainmx }
   finish { bfinish }
   scale <1/2,3,5>
   translate <-4.5,3,0>
   } // end -x wall

box { <-1,-1,-1> <1,1,1>
   pigment { bgrainpx }
   finish { bfinish }
   scale <1/2,3,5>
   translate <4.5,3,0>
   } // end +x wall

#declare bgrainfl = pigment { 
   granite
   turbulence 0.1
   octaves 4
   lambda 3
   scale 20//3//0.3
   rotate <0.125, 0.125, 0>
   } // end pigment declare

box { <-1,-1,-1> <1,1,1>
   pigment { bgrainfl }
   finish { reflection <0.1, 0.1, 0.1>//<0,0,0>
      ambient <1, 0.6, 0.6>}
   scale <4,1/2,5>
   translate <0,1,0>
   } // end floor


#declare dsize = 1 ;
#declare dscale = <dsize, 0.6*dsize, dsize> ;// 
#declare dtrans = <0, 0, 0> ;// translation based upon 


#declare dtex = texture {
   pigment {rgbf <1, 1, 1, 0.9> }
   finish {
      reflection 0.51 // <0.4, 0.9, 0.4>
      ambient 0.0 // <0.2, 0.7, 0.2>
      diffuse 0. brilliance 10
      phong 0.9 phong_size 100
      specular 0.5
      roughness 0.01
      phong 0.3 phong_size 60
      }}

#declare stex = texture {
   pigment {rgbf <0.2, 0.2, 1, 0.9> }
   finish {
      reflection 0.51 // <0.4, 0.9, 0.4>
      ambient 0.0 // <0.2, 0.7, 0.2>
      diffuse 0. brilliance 10
      phong 0.9 phong_size 100
      specular 0.5
      roughness 0.01
      phong 0.3 phong_size 60
      }}
#declare rtex = texture {
   pigment {rgbf <1, 0.2, 0.2, 0.9> }
   finish {
      reflection 0.51 // <0.4, 0.9, 0.4>
      ambient 0.0 // <0.2, 0.7, 0.2>
      diffuse 0. brilliance 10
      phong 0.9 phong_size 100
      specular 0.5
      roughness 0.01
      phong 0.3 phong_size 60
      }}

#declare etex = texture {
   pigment {rgbf <0.2, 1, 0.2, 0.9> }
   finish {
      reflection 0.51 // <0.4, 0.9, 0.4>
      ambient 0.0 // <0.2, 0.7, 0.2>
      diffuse 0. brilliance 10
      phong 0.9 phong_size 100
      specular 0.5
      roughness 0.01
      phong 0.3 phong_size 60
      }}

#declare atex = texture {
   pigment {rgbf <0.2, 0.7, 1, 0.9> }
   finish {
      reflection 0.51 // <0.4, 0.9, 0.4>
      ambient 0.0 // <0.2, 0.7, 0.2>
      diffuse 0. brilliance 10
      phong 0.9 phong_size 100
      specular 0.5
      roughness 0.01
      phong 0.3 phong_size 60
      }}



#declare diamond0 = object { intersection
   { // start intersection
  superellipsoid {<2,2> rotate <0,0,0>}
  superellipsoid {<2,2> rotate <0,45,0>} 
  superellipsoid {<2,2> scale <0.9,1.1,0.9> rotate <0,45+45/2,0>}
  superellipsoid {<2,2> scale <0.9,1.1,0.9> rotate <0,4545/2,0>}  
  superellipsoid {<2,2> scale <0.83,2.7,0.83> rotate <0,0,0>}
  superellipsoid {<2,2> scale <0.83,2.7,0.83> rotate <0,45,0>}
  box { <-1,-1,-1> <1,1,1> translate <0, -.6, 0> } // diamond shape addition 
  interior { ior 2.3 caustics 1}  
  texture { dtex }                                              
  scale <0.5,0.5,0.5>*dscale
  rotate <0,0,45> 
  rotate <0,65,0>
  translate <-3.25, 1.75, -3> + dtrans 
  } // end intersection 
} // end object

diamond0 //diamond in far corner


#declare diamond1 = object { intersection
   { // start intersection
  superellipsoid {<2,2> rotate <0,0,0>}
  superellipsoid {<2,2> rotate <0,45,0>} 
  superellipsoid {<2,2> scale <0.9,1.1,0.9> rotate <0,45+45/2,0>}
  superellipsoid {<2,2> scale <0.9,1.1,0.9> rotate <0,4545/2,0>}  
  superellipsoid {<2,2> scale <0.83,2.7,0.83> rotate <0,0,0>}
  superellipsoid {<2,2> scale <0.83,2.7,0.83> rotate <0,45,0>}
  box { <-1,-1,-1> <1,1,1> translate <0, -.6, 0> } // diamond shape addition 
  interior { ior 2.3 caustics 1}  
  texture { stex }                                              
  scale <1/2,1/2,(1/2)>*dscale 
  rotate <0,0,45>
  rotate <0,95,0>
  translate <-3, 1.75, -2> + dtrans 
  } // end intersection 
} // end object

diamond1 // saphire right of far corner

  
#declare diamond2 = object { intersection
   { // start intersection
  superellipsoid {<2,2> rotate <0,0,0>}
  superellipsoid {<2,2> rotate <0,45,0>} 
  superellipsoid {<2,2> scale <0.9,1.1,0.9> rotate <0,45+45/2,0>}
  superellipsoid {<2,2> scale <0.9,1.1,0.9> rotate <0,4545/2,0>}  
  superellipsoid {<2,2> scale <0.83,2.7,0.83> rotate <0,0,0>}
  superellipsoid {<2,2> scale <0.83,2.7,0.83> rotate <0,45,0>}
  box { <-1,-1,-1> <1,1,1> translate <0, -.6, 0> } // diamond shape addition 
  interior { ior 2.3 caustics 1}  
  texture { rtex }                                              
  scale <1/2,1/2,(1/2)>*dscale 
  rotate <0,0,45>
  rotate <0,170,0>
  translate <-1, 1.75, -2> + dtrans 
  } // end intersection 
} // end object

diamond2 // ruby left of far corner

#declare diamond3 = object { intersection
   { // start intersection
  superellipsoid {<2,2> rotate <0,0,0>}
  superellipsoid {<2,2> rotate <0,45,0>} 
  superellipsoid {<2,2> scale <0.9,1.1,0.9> rotate <0,45+45/2,0>}
  superellipsoid {<2,2> scale <0.9,1.1,0.9> rotate <0,4545/2,0>}  
  superellipsoid {<2,2> scale <0.83,2.7,0.83> rotate <0,0,0>}
  superellipsoid {<2,2> scale <0.83,2.7,0.83> rotate <0,45,0>}
  box { <-1,-1,-1> <1,1,1> translate <0, -.6, 0> } // diamond shape addition 
  interior { ior 2.3 caustics 1}  
  texture { etex }                                              
  scale <1/2,1/2,(8/5)*(1/2)>*dscale 
  rotate <0,0,45>
  rotate <0,70,0>
  translate <-0.4, 1.75, -2> + dtrans 
  } // end intersection 
} // end object

diamond3 // emerald left of far corner

#declare diamond4 = object { intersection
   { // start intersection
  superellipsoid {<2,2> rotate <0,0,0>}
  superellipsoid {<2,2> rotate <0,45,0>} 
  superellipsoid {<2,2> scale <0.9,1.1,0.9> rotate <0,45+45/2,0>}
  superellipsoid {<2,2> scale <0.9,1.1,0.9> rotate <0,4545/2,0>}  
  superellipsoid {<2,2> scale <0.83,2.7,0.83> rotate <0,0,0>}
  superellipsoid {<2,2> scale <0.83,2.7,0.83> rotate <0,45,0>}
  box { <-1,-1,-1> <1,1,1> translate <0, -.6, 0> } // diamond shape addition 
  interior { ior 2.3 caustics 1}  
  texture { dtex }                                              
  scale <0.5,0.5,0.5>*dscale 
  rotate <0,0,45>
  rotate <0,175,0>
  translate <0.5, 1.75, -1.7> + dtrans 
  } // end intersection 
} // end object

diamond4


#declare diamond5 = object { intersection
   { // start intersection
  superellipsoid {<2,2> rotate <0,0,0>}
  superellipsoid {<2,2> rotate <0,45,0>} 
  superellipsoid {<2,2> scale <0.9,1.1,0.9> rotate <0,45+45/2,0>}
  superellipsoid {<2,2> scale <0.9,1.1,0.9> rotate <0,4545/2,0>}  
  superellipsoid {<2,2> scale <0.83,2.7,0.83> rotate <0,0,0>}
  superellipsoid {<2,2> scale <0.83,2.7,0.83> rotate <0,45,0>}
  box { <-1,-1,-1> <1,1,1> translate <0, -.6, 0> } // diamond shape addition 
  interior { ior 2.3 caustics 1}  
  texture { dtex }                                              
  scale <0.5,0.5,0.5>*dscale 
  rotate <0,0,45>
  rotate <0,90,0>
  translate <-1.5, 1.75, -2.1> + dtrans 
  } // end intersection 
} // end object

diamond5

#declare diamond6 = object { intersection
   { // start intersection
  superellipsoid {<2,2> rotate <0,0,0>}
  superellipsoid {<2,2> rotate <0,45,0>} 
  superellipsoid {<2,2> scale <0.9,1.1,0.9> rotate <0,45+45/2,0>}
  superellipsoid {<2,2> scale <0.9,1.1,0.9> rotate <0,4545/2,0>}  
  superellipsoid {<2,2> scale <0.83,2.7,0.83> rotate <0,0,0>}
  superellipsoid {<2,2> scale <0.83,2.7,0.83> rotate <0,45,0>}
  box { <-1,-1,-1> <1,1,1> translate <0, -.6, 0> } // diamond shape addition 
  interior { ior 2.3 caustics 1}  
  texture { etex }                                              
  scale <1/2,1/2,(8/5)*(1/2)>*dscale 
  rotate <0,0,45>
  rotate <0,165,0>
  translate <1, 1.75, -2> + dtrans 
  } // end intersection 
} // end object

diamond6

#declare diamond7 = object { intersection
   { // start intersection
  superellipsoid {<2,2> rotate <0,0,0>}
  superellipsoid {<2,2> rotate <0,45,0>} 
  superellipsoid {<2,2> scale <0.9,1.1,0.9> rotate <0,45+45/2,0>}
  superellipsoid {<2,2> scale <0.9,1.1,0.9> rotate <0,4545/2,0>}  
  superellipsoid {<2,2> scale <0.83,2.7,0.83> rotate <0,0,0>}
  superellipsoid {<2,2> scale <0.83,2.7,0.83> rotate <0,45,0>}
  box { <-1,-1,-1> <1,1,1> translate <0, -.6, 0> } // diamond shape addition 
  interior { ior 2.3 caustics 1}  
  texture { stex }                                              
  scale <1/2,1/2,(1/2)>*dscale 
  rotate <0,0,45>
  rotate <0,80,0>
  translate <-1, 1.75, -2.5> + dtrans 
  } // end intersection 
} // end object

diamond7


#declare diamond8 = object { intersection
   { // start intersection
  superellipsoid {<2,2> rotate <0,0,0>}
  superellipsoid {<2,2> rotate <0,45,0>} 
  superellipsoid {<2,2> scale <0.9,1.1,0.9> rotate <0,45+45/2,0>}
  superellipsoid {<2,2> scale <0.9,1.1,0.9> rotate <0,4545/2,0>}  
  superellipsoid {<2,2> scale <0.83,2.7,0.83> rotate <0,0,0>}
  superellipsoid {<2,2> scale <0.83,2.7,0.83> rotate <0,45,0>}
  box { <-1,-1,-1> <1,1,1> translate <0, -.6, 0> } // diamond shape addition 
  interior { ior 2.3 caustics 1}  
  texture { atex }                                              
  scale <1/2,1/2,(1/2)>*dscale 
  rotate <0,0,45>
  rotate <0,195,0>
  translate <-1.5, 1.75, 0.6> + dtrans 
  } // end intersection 
} // end object

diamond8

#declare diamond9 = object { intersection
   { // start intersection
  superellipsoid {<2,2> rotate <0,0,0>}
  superellipsoid {<2,2> rotate <0,45,0>} 
  superellipsoid {<2,2> scale <0.9,1.1,0.9> rotate <0,45+45/2,0>}
  superellipsoid {<2,2> scale <0.9,1.1,0.9> rotate <0,4545/2,0>}  
  superellipsoid {<2,2> scale <0.83,2.7,0.83> rotate <0,0,0>}
  superellipsoid {<2,2> scale <0.83,2.7,0.83> rotate <0,45,0>}
  box { <-1,-1,-1> <1,1,1> translate <0, -.6, 0> } // diamond shape addition 
  interior { ior 2.3 caustics 1}  
  texture { etex }                                              
  scale <1/2,1/2,(8/5)*(1/2)>*dscale 
  rotate <0,0,45>
  rotate <0,105,0>
  translate <-1.8, 1.75, 0.0> + dtrans 
  } // end intersection 
} // end object

diamond9



#declare diamond10 = object { intersection
   { // start intersection
  superellipsoid {<2,2> rotate <0,0,0>}
  superellipsoid {<2,2> rotate <0,45,0>} 
  superellipsoid {<2,2> scale <0.9,1.1,0.9> rotate <0,45+45/2,0>}
  superellipsoid {<2,2> scale <0.9,1.1,0.9> rotate <0,4545/2,0>}  
  superellipsoid {<2,2> scale <0.83,2.7,0.83> rotate <0,0,0>}
  superellipsoid {<2,2> scale <0.83,2.7,0.83> rotate <0,45,0>}
  box { <-1,-1,-1> <1,1,1> translate <0, -.6, 0> } // diamond shape addition 
  interior { ior 2.3 caustics 1}  
  texture { rtex }                                              
  scale <1/2,1/2,(1/2)>*dscale 
  rotate <0,0,45>
  rotate <0,55,0>
  translate <1.25, 1.75, -2.5> + dtrans 
  } // end intersection 
} // end object

diamond10


#declare diamond11 = object { intersection
   { // start intersection
  superellipsoid {<2,2> rotate <0,0,0>}
  superellipsoid {<2,2> rotate <0,45,0>} 
  superellipsoid {<2,2> scale <0.9,1.1,0.9> rotate <0,45+45/2,0>}
  superellipsoid {<2,2> scale <0.9,1.1,0.9> rotate <0,4545/2,0>}  
  superellipsoid {<2,2> scale <0.83,2.7,0.83> rotate <0,0,0>}
  superellipsoid {<2,2> scale <0.83,2.7,0.83> rotate <0,45,0>}
  box { <-1,-1,-1> <1,1,1> translate <0, -.6, 0> } // diamond shape addition 
  interior { ior 2.3 caustics 1}  
  texture { dtex }                                              
  scale <1/2,1/2,(1/2)>*dscale
  rotate <0,0,45> 
  rotate <0,145,0>
  translate <1.7, 1.75, -2.0> + dtrans 
  } // end intersection 
} // end object

diamond11


#declare diamond12 = object { intersection
   { // start intersection
  superellipsoid {<2,2> rotate <0,0,0>}
  superellipsoid {<2,2> rotate <0,45,0>} 
  superellipsoid {<2,2> scale <0.9,1.1,0.9> rotate <0,45+45/2,0>}
  superellipsoid {<2,2> scale <0.9,1.1,0.9> rotate <0,4545/2,0>}  
  superellipsoid {<2,2> scale <0.83,2.7,0.83> rotate <0,0,0>}
  superellipsoid {<2,2> scale <0.83,2.7,0.83> rotate <0,45,0>}
  box { <-1,-1,-1> <1,1,1> translate <0, -.6, 0> } // diamond shape addition 
  interior { ior 2.3 caustics 1}  
  texture { rtex }                                              
  scale <1/2,1/2,(1/2)>*dscale
  rotate <0,0,45> 
  rotate <0,190,0>
  translate <-.75, 1.75, -0.5> + dtrans 
  } // end intersection 
} // end object

diamond12



#declare cyltex = texture 
{ pigment { color rgb <0.64, 0.51, 0.05> }
         
  finish {reflection 0.55*<0.64, 0.51, 0.05> 
         metallic
         ambient 0.5 * <0.64, 0.51, 0.05> //<0.75, 0.75, 0.05> // 0.99
         specular 0.9 //specular 0.5
         roughness 0.01
         diffuse 0.5 
         brilliance 8
         phong 0.75
         phong_size 800 
          } 
}

#declare cyltex2 = texture 
{ pigment { color rgb 1.5* <0.64, 0.51, 0.05> }
         
  finish {reflection 0.85*<0.64, 0.51, 0.05> 
         metallic
         ambient 0.5 * <0.64, 0.51, 0.05> //<0.75, 0.75, 0.05> // 0.99
         specular 0.9 //specular 0.5
         roughness 0.01
         diffuse 0.5 
         brilliance 8
         phong 0.75
         phong_size 800 
          } 
}

#declare otex = 
pigment {
    bozo
    turbulence <0.2,0.3,0.2> //0.1
    scale <1/10,1000,1/10> //1/10
    color_map {     // r b switch
        [0.00 rgbft <0.990, 0.100, 0.000, 0.000, 0.000>] // gold .79
        [0.50 rgbft <0.790, 0.290, 0.000, 0.000, 0.000>] // 39 79
        [0.50 rgbft <0.000, 0.900, 0.000, 0.000, 0.000>]
        [0.51 rgbft <0.000, 0.990, 0.000, 0.000, 0.000>]
        [0.51 rgbft <0.090, 0.990, 0.000, 0.000, 0.000>] // red
        [0.60 rgbft <0.390, 0.990, 0.000, 0.000, 0.000>] // 0 0.39 0.99
        [0.60 rgbft <0.000, 0.990, 0.000, 0.000, 0.000>]
        [0.61 rgbft <0.000, 0.900, 0.000, 0.000, 0.000>]
        [0.61 rgbft <0.600, 0.115, 0.000, 0.000, 0.000>] // darker red 0.6 0.025
    }
} // finish B_S

#declare cab = object { union
   { // start union
   superellipsoid {<0.3,0.3> scale <1.00, .15, 1.00*(8/5)> pigment{ otex  } 
   finish { specular 0.9}translate <0,0.05,0>
   interior {ior 1.8} }
   superellipsoid {<0.3,0.3> scale <1.05, .14, 1.05*(8/5)> texture{ cyltex2} }
   superellipsoid {<0.3,0.3> scale <1.08, .10, 1.08*(8/5)> texture{ cyltex2} }
   superellipsoid {<0.3,0.3> scale <1.11, .05, 1.11*(8/5)> texture{ cyltex2} }

//   torus {0.8, 0.05 scale <1.5,1.0,1.0>  texture { cyltex} 
//   rotate <90,0,0> translate <0,-0.5,0> } //0 -1 0
   rotate <0,90,0>
   rotate <0,0,-65>
   translate <-7.1,4.72,0>
   scale 0.5

   } // end union                          
} // end object cab 

cab

#declare tscale = 0.05 ;
#declare ring = torus {0.7,0.2 scale tscale   texture { cyltex2} 
   rotate <90,0,0> translate <0,2,0> } //0 -1 0

// Define the macro.  Parameters are:
//   Stuff:    The stuff to be multiplied and rotated
//   How_Many: Number of copies to make
//   Axis:     The axis about which we'll rotate the copies.
#macro Make_Many (Stuff,How_Many,Axis)
  #local Count=0;   // this identifier is local and 
                    // temporary to this macro
  #while (Count<How_Many)
    object{Stuff rotate Axis*Count*(360/How_Many) 
      translate Count*y*tscale 
      translate Count*z*tscale*0.15}
    #local Count=Count+1;
  #end
#end

union {
  Make_Many (ring,90,y)  
  translate <-3.93,1.0,0>
}

#macro Make_Many2 (Stuff,How_Many,Axis)
  #local Count=0;   // this identifier is local and 
                    // temporary to this macro
  #while (Count<How_Many)
    object{Stuff rotate Axis*Count*(360/How_Many) 
      translate Count*y*tscale 
      translate -Count*z*tscale*0.1}
    #local Count=Count+1;
  #end
#end

union {
  Make_Many2 (ring,100,y)
  translate <-3.92,1.0,0>
}

// chains for opal


#declare tscale2 = 1 ;  // hanging thing
                 
#declare ball = union {
sphere {0.0,0.1 scale tscale2   texture { cyltex2 } 
   rotate <90,0,0> translate <0,2,0> } //0 -1 0
//torus {1 .05 texture {cyltex2 } 
  // rotate <90,0,0> translate <0,2,0> }
}

// Define the macro.  Parameters are:
//   Stuff:    The stuff to be multiplied and rotated
//   How_Many: Number of copies to make
//   Axis:     The axis about which we'll rotate the copies.
#macro Make_Many3 (Stuff,How_Many,Axis)
  #local Count=0;   // this identifier is local and 
                    // temporary to this macro
  #while (Count<How_Many)
    object{Stuff rotate Axis*Count*(360/How_Many) 
      translate y*cos (Count*tscale2)/.5 //Count*y*tscale2
      translate x*sin (Count*tscale2*1)/.5 //Count*x*tscale2*1
      }
    #local Count=Count+1;
  #end
#end

union {
  Make_Many3 (ball,130,y)  
  torus {2 0.03 texture {cyltex2} rotate <90,0,0> translate <0,2,0>}
  translate <-2.75, 3.5, -5.7>
  scale 0.75  
}        

#declare tscale3 = 1 ;  // hanging thing
                 
#declare ball2 = union {
sphere {0.0,0.1 scale tscale3   texture { cyltex2 } 
   rotate <90,0,0> translate <0,2,0> } //0 -1 0
//torus {1 .05 texture {cyltex2 } 
  // rotate <90,0,0> translate <0,2,0> }
}

// Define the macro.  Parameters are:
//   Stuff:    The stuff to be multiplied and rotated
//   How_Many: Number of copies to make
//   Axis:     The axis about which we'll rotate the copies.
#macro Make_Many4 (Stuff,How_Many,Axis)
  #local Count=0;   // this identifier is local and 
                    // temporary to this macro
  #while (Count<How_Many)
    object{Stuff rotate Axis*Count*(360/How_Many) 
      translate y*cos (Count*tscale3)/.5 //Count*y*tscale2
      translate x*sin (Count*tscale3*1)/.5 //Count*x*tscale2*1
      }
    #local Count=Count+1;
  #end
#end

union {
  Make_Many4 (ball2,45,y)  
  torus {2 0.03 texture {cyltex2} rotate <90,0,0> translate <0,2,0>}
  translate <-3, 4.5, -5.9>
  scale 0.65  
}

/* to big for earrings 
#declare cab2 = object { union
   { // start union

   sphere { 
      0,1 scale <1.00, .1, 1.00*(8/5)> 
      pigment{ rgbft <1, 1, 1, 0.2, 0.8> }
      normal {waves 70 } 
      finish { specular 0.9}
      translate <0,0.05,0>
      interior {ior 2.3}        
   }
   
   sphere { 
      0,1 scale 0.99*<1.0, .1, 1.00*(8/5)> 
      pigment{ rgbft <1, 1, 1, 0., 0.> }
      normal {waves 70 } 
      finish { specular 0.9}
      translate <0,0.05,0>
      interior {ior 2.3}        
   }
   
   sphere {0,1.05 scale <1.05, .09, 1.05*(8/5)> texture{ cyltex2} }

   rotate <0,90,0>
   rotate <70,0,0>
   rotate <0,20,0>
   translate <-1,4.,-7.5> //<-7.1,4.72,0>
   scale 0.5
   } // end union                          
} // end object cab 

cab2
*/

#declare cab3 = object { union
   { // start union

   sphere { 
      0,1 scale <1.00, .1, 1.00*(8/5)> 
      pigment{ rgbft <1, 1, 1, 0.2, 0.8> }
      normal {waves 70 } 
      finish { specular 0.9}
      translate <0,0.05,0>
      interior {ior 2.3}        
   }
   
   sphere { 
      0,1 scale 0.99*<1.0, .1, 1.00*(8/5)> 
      pigment{ rgbft <1, 1, 1, 0., 0.> }
      normal {waves 70 } 
      finish { specular 0.9}
      translate <0,0.05,0>
      interior {ior 2.3}        
   }
   
   sphere {0,1.05 scale <1.05, .09, 1.05*(8/5)> texture{ cyltex2} }

   rotate <0,90,0>
   rotate <65,0,0>
   rotate <0,0,0>
   translate <2.3,4.,-7.5> //<-7.1,4.72,0>
   scale 0.5
   } // end union                          
} // end object cab 

cab3


#declare stex = texture
{ pigment {color rgbf<0.8,0.8,0.8,1> }
  finish {       
    ambient 0
    diffuse 0.25 brilliance 10.0
    specular 0.2
    reflection 0.1 reflection_exponent 0.95
    irid {
          0.35
          thickness .001
          turbulence .5
          }
} 
} 

#declare pearl0 = object { union {

sphere { 0.0, 1.000 hollow texture { stex }interior { ior 1.6 caustics 1} }
sphere { 0.0, 0.999 hollow texture { stex } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.998 hollow texture { stex } interior {ior 1.6 caustics 1} }                                   
sphere { 0.0, 0.997 hollow texture { stex } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.996 hollow texture { stex } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.995 hollow texture { stex } interior {ior 1.6 caustics 1} }                                   
sphere { 0.0, 0.994 hollow texture { stex } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.993 hollow texture { stex } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.992 hollow texture { stex } interior {ior 1.6 caustics 1} }                                   
sphere { 0.0, 0.991 hollow texture { stex } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.990 hollow texture { stex }interior { ior 1.6 caustics 1} }
sphere { 0.0, 0.989 hollow texture { stex } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.988 hollow texture { stex } interior {ior 1.6 caustics 1} }                                   
sphere { 0.0, 0.987 hollow texture { stex } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.986 hollow texture { stex } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.985 hollow texture { stex } interior {ior 1.6 caustics 1} }                                   
sphere { 0.0, 0.984 hollow texture { stex } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.983 hollow texture { stex } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.982 hollow texture { stex } interior {ior 1.6 caustics 1} }                                   
sphere { 0.0, 0.981 hollow texture { stex } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.980 texture {pigment{ color rgbf<1,1,1,0>} } }
scale 0.2
translate <1.5,1.7,0>
}}

pearl0

#declare stexr = texture
{ pigment {color rgbf<1,.8,.8,1> }
  finish { 
    ambient 0
    diffuse 0.25 brilliance 10.0
    specular 0.2
    reflection 0.1 reflection_exponent 0.75
    irid {
          0.35
          thickness .001
          turbulence .5
          }
} 
} 

#declare pearl1 = object { union {

sphere { 0.0, 1.000 hollow texture { stexr }interior { ior 1.6 caustics 1} }
sphere { 0.0, 0.999 hollow texture { stexr } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.998 hollow texture { stexr } interior {ior 1.6 caustics 1} }                                   
sphere { 0.0, 0.997 hollow texture { stexr } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.996 hollow texture { stexr } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.995 hollow texture { stexr } interior {ior 1.6 caustics 1} }                                   
sphere { 0.0, 0.994 hollow texture { stexr } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.993 hollow texture { stexr } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.992 hollow texture { stexr } interior {ior 1.6 caustics 1} }                                   
sphere { 0.0, 0.991 hollow texture { stexr } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.990 hollow texture { stexr }interior { ior 1.6 caustics 1} }
sphere { 0.0, 0.989 hollow texture { stexr } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.988 hollow texture { stexr } interior {ior 1.6 caustics 1} }                                   
sphere { 0.0, 0.987 hollow texture { stexr } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.986 hollow texture { stexr } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.985 hollow texture { stexr } interior {ior 1.6 caustics 1} }                                   
sphere { 0.0, 0.984 hollow texture { stexr } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.983 hollow texture { stexr } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.982 hollow texture { stexr } interior {ior 1.6 caustics 1} }                                   
sphere { 0.0, 0.981 hollow texture { stexr } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.980 texture {pigment{ color rgbf<1,1,1,0>} } }
scale 0.2
translate <1.0,1.7,0.5>
}}

pearl1

#declare stexb = texture
{ pigment {color rgbf<0.85,0.85,1,1> }
  finish { 
ambient 0
    diffuse 0.25 brilliance 10.0
    specular 0.2
    reflection 0.1 reflection_exponent 0.95
    irid {
          0.35
          thickness .001
          turbulence .5
          }
} 
} 

#declare pearl2 = object { union {

sphere { 0.0, 1.000 hollow texture { stexb }interior { ior 1.6 caustics 1} }
sphere { 0.0, 0.999 hollow texture { stexb } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.998 hollow texture { stexb } interior {ior 1.6 caustics 1} }                                   
sphere { 0.0, 0.997 hollow texture { stexb } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.996 hollow texture { stexb } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.995 hollow texture { stexb } interior {ior 1.6 caustics 1} }                                   
sphere { 0.0, 0.994 hollow texture { stexb } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.993 hollow texture { stexb } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.992 hollow texture { stexb } interior {ior 1.6 caustics 1} }                                   
sphere { 0.0, 0.991 hollow texture { stexb } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.990 hollow texture { stexb }interior { ior 1.6 caustics 1} }
sphere { 0.0, 0.989 hollow texture { stexb } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.988 hollow texture { stexb } interior {ior 1.6 caustics 1} }                                   
sphere { 0.0, 0.987 hollow texture { stexb } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.986 hollow texture { stexb } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.985 hollow texture { stexb } interior {ior 1.6 caustics 1} }                                   
sphere { 0.0, 0.984 hollow texture { stexb } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.983 hollow texture { stexb } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.982 hollow texture { stexb } interior {ior 1.6 caustics 1} }                                   
sphere { 0.0, 0.981 hollow texture { stexb } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.980 texture {pigment{ color rgbf<1,1,1,0>} } }
scale 0.2
translate <-0.5,1.7,0.1>
}}

pearl2

#declare pearl3 = object { union {

sphere { 0.0, 1.000 hollow texture { stex }interior { ior 1.6 caustics 1} }
sphere { 0.0, 0.999 hollow texture { stex } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.998 hollow texture { stex } interior {ior 1.6 caustics 1} }                                   
sphere { 0.0, 0.997 hollow texture { stex } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.996 hollow texture { stex } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.995 hollow texture { stex } interior {ior 1.6 caustics 1} }                                   
sphere { 0.0, 0.994 hollow texture { stex } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.993 hollow texture { stex } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.992 hollow texture { stex } interior {ior 1.6 caustics 1} }                                   
sphere { 0.0, 0.991 hollow texture { stex } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.990 hollow texture { stex }interior { ior 1.6 caustics 1} }
sphere { 0.0, 0.989 hollow texture { stex } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.988 hollow texture { stex } interior {ior 1.6 caustics 1} }                                   
sphere { 0.0, 0.987 hollow texture { stex } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.986 hollow texture { stex } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.985 hollow texture { stex } interior {ior 1.6 caustics 1} }                                   
sphere { 0.0, 0.984 hollow texture { stex } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.983 hollow texture { stex } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.982 hollow texture { stex } interior {ior 1.6 caustics 1} }                                   
sphere { 0.0, 0.981 hollow texture { stex } interior {ior 1.6 caustics 1} }
sphere { 0.0, 0.980 texture {pigment{ color rgbf<1,1,1,0>} } }
scale 0.2
translate <-3.8,1.7,-4>
}}

pearl3

/*
//-------------------- the funny shape 

#declare diamondx = object { intersection
   { // start intersection
  superellipsoid {<2,2> rotate <0,0,0>}
  superellipsoid {<2,2> rotate <0,45,0>} 
  superellipsoid {<2,2> scale <0.9,1.1,0.9> rotate <0,45+45/2,0>}
  superellipsoid {<2,2> scale <0.9,1.1,0.9> rotate <0,4545/2,0>}  
  superellipsoid {<2,2> scale <0.83,2.7,0.83> rotate <0,0,0>}
  superellipsoid {<2,2> scale <0.83,2.7,0.83> rotate <0,45,0>}
  box { <-1,-1,-1> <1,1,1> translate <0, -.6, 0> } // diamond shape addition 
  interior { ior 2.3 caustics 1}  
  texture { rtex }                                              
  scale 0.5*dscale
  rotate <0,0,90> 
  rotate <0,0,0>
  translate <0, 2, 0.2> + dtrans 
  } // end intersection 
} // end object

//diamondx //diamond in ring // way too slow to render and not fixed

#declare tscale3 = 0.3 ;                 
                 
#declare mount = union { //xx
torus {1,0.1 scale tscale3   texture { cyltex2 } 
   rotate <90,0,0> translate <0,2,0> } //0 -1 0
diamondx
//torus {1 .05 texture {cyltex2 } 
  // rotate <90,0,0> translate <0,2,0> }
}
  */
  
  /*
#macro Make_Many3 (Stuff,How_Many,Axis)
  #local Count=0;   // this identifier is local and 
                    // temporary to this macro
  #while (Count<How_Many)
    object{Stuff rotate Axis*Count*(360/How_Many) 
      rotate y*Count*360/How_Many
      translate z*cos (Count*tscale3) //Count*y*tscale3
      translate x*sin (Count*tscale3*1) //Count*x*tscale3*1
      }
    #local Count=Count+1;
  #end
#end

union {
  Make_Many3 (mount,26,y)
  //torus {2 0.03 texture {cyltex2} rotate <90,0,0> translate <0,2,0>}
  translate <-0, 2.69, 3>
  scale 0.35  
}

*/

#declare xloc = -.5;
#declare zloc = 2;
#declare yshift = 0.0863;
#declare coin =  union
{
intersection 
  {
   height_field {
    gif "coin2b.gif"
    smooth
    texture {cyltex2} // pigment {color <1,0.7,0>}
    translate <-.5, -.5, -.50>
    scale <1, 0.0275, 1>
         } // end height_field                   
   cylinder { <0,-.0137,0> <0,0.2,0> 1 translate <0,0.0,0> }
  }                                                           
 cylinder { <0,-.0137,0> <0,-0.1,0> 0.42 translate <0,0,0.01> 
   texture  {cyltex2}}//color <1,0.7,0>} }
rotate <0,45,0>
translate <xloc, 1.604, zloc>
}
coin 

#declare coin2 =  union
{
intersection 
  {
   height_field {
    gif "coin2b.gif"
    smooth
    texture {cyltex2} // pigment {color <1,0.7,0>}
    translate <-.5, -.5, -.50>
    scale <1, 0.0275, 1>
         } // end height_field                   
   cylinder { <0,-.0137,0> <0,0.2,0> 1 translate <0,0.0,0> }
  }                                                           
 cylinder { <0,-.0137,0> <0,-0.1,0> 0.42 translate <0,0,0.01> 
   texture  {cyltex2}}//color <1,0.7,0>} }
   rotate <0,-45,0>
translate <xloc-.05, 1.604+(1*yshift), zloc+.02>
}
coin2 

#declare coin3 =  union
{
intersection 
  {
   height_field {
    gif "coin2b.gif"
    smooth
    texture {cyltex2} // pigment {color <1,0.7,0>}
    translate <-.5, -.5, -.50>
    scale <1, 0.0275, 1>
         } // end height_field                   
   cylinder { <0,-.0137,0> <0,0.2,0> 1 translate <0,0.0,0> }
  }                                                           
 cylinder { <0,-.0137,0> <0,-0.1,0> 0.42 translate <0,0,0.01> 
   texture  {cyltex2}}//color <1,0.7,0>} }
rotate <0,95,0>
translate <xloc+.03, 1.604+(2*yshift), zloc - .04>
}
coin3 

#declare coin4 =  union
{
intersection 
  {
   height_field {
    gif "coin2b.gif"
    smooth
    texture {cyltex2} // pigment {color <1,0.7,0>}
    translate <-.5, -.5, -.50>
    scale <1, 0.0275, 1>
         } // end height_field                   
   cylinder { <0,-.0137,0> <0,0.2,0> 1 translate <0,0.0,0> }
  }                                                           
 cylinder { <0,-.0137,0> <0,-0.1,0> 0.42 translate <0,0,0.01> 
   texture  {cyltex2}}//color <1,0.7,0>} }
rotate <0,-75,0>
translate <xloc-.01, 1.604+(3*yshift), zloc - .02>
}
coin4 

#declare coin5 =  union
{
intersection 
  {
   height_field {
    gif "coin2b.gif"
    smooth
    texture {cyltex2} // pigment {color <1,0.7,0>}
    translate <-.5, -.5, -.50>
    scale <1, 0.0275, 1>
         } // end height_field                   
   cylinder { <0,-.0137,0> <0,0.2,0> 1 translate <0,0.0,0> }
  }                                                           
 cylinder { <0,-.0137,0> <0,-0.1,0> 0.42 translate <0,0,0.01> 
   texture  {cyltex2}}//color <1,0.7,0>} }
rotate <0,-175,0>
translate <xloc-.02, 1.604+(4*yshift), zloc - .03>
}
coin5

#declare coin6 =  union
{
intersection 
  {
   height_field {
    gif "coin2b.gif"
    smooth
    texture {cyltex2} // pigment {color <1,0.7,0>}
    translate <-.5, -.5, -.50>
    scale <1, 0.0275, 1>
         } // end height_field                   
   cylinder { <0,-.0137,0> <0,0.2,0> 1 translate <0,0.0,0> }
  }                                                           
 cylinder { <0,-.0137,0> <0,-0.1,0> 0.42 translate <0,0,0.01> 
   texture  {cyltex2}}//color <1,0.7,0>} }
rotate <0,175,0>
translate <xloc+.03, 1.604+(5*yshift), zloc + .04>
}
coin6

#declare coin7 =  union
{
intersection 
  {
   height_field {
    gif "coin2b.gif"
    smooth
    texture {cyltex2} // pigment {color <1,0.7,0>}
    translate <-.5, -.5, -.50>
    scale <1, 0.0275, 1>
         } // end height_field                   
   cylinder { <0,-.0137,0> <0,0.2,0> 1 translate <0,0.0,0> }
  }                                                           
 cylinder { <0,-.0137,0> <0,-0.1,0> 0.42 translate <0,0,0.01> 
   texture  {cyltex2}}//color <1,0.7,0>} }
rotate <0,15,0>
translate <xloc-.08, 1.604+(6*yshift), zloc - .05>
}
coin7
   
#declare coin8 =  union
{
intersection 
  {
   height_field {
    gif "coin2b.gif"
    smooth
    texture {cyltex2} // pigment {color <1,0.7,0>}
    translate <-.5, -.5, -.50>
    scale <1, 0.0275, 1>
         } // end height_field                   
   cylinder { <0,-.0137,0> <0,0.2,0> 1 translate <0,0.0,0> }
  }                                                           
 cylinder { <0,-.0137,0> <0,-0.1,0> 0.42 translate <0,0,0.01> 
   texture  {cyltex2}}//color <1,0.7,0>} }
rotate <0,38,0>
translate <xloc+.02, 1.604+(7*yshift), zloc - .01>
}
coin8

#declare coin9 =  union
{
intersection 
  {
   height_field {
    gif "coin2b.gif"
    smooth
    texture {cyltex2} // pigment {color <1,0.7,0>}
    translate <-.5, -.5, -.50>
    scale <1, 0.0275, 1>
         } // end height_field                   
   cylinder { <0,-.0137,0> <0,0.2,0> 1 translate <0,0.0,0> }
  }                                                           
 cylinder { <0,-.0137,0> <0,-0.1,0> 0.42 translate <0,0,0.01> 
   texture  {cyltex2}}//color <1,0.7,0>} }
rotate <0,238,0>
translate <xloc-.02, 1.604+(8*yshift), zloc + .01>
}
coin9

#declare coin10 =  union
{
intersection 
  {
   height_field {
    gif "coin2b.gif"
    smooth
    texture {cyltex2} // pigment {color <1,0.7,0>}
    translate <-.5, -.5, -.50>
    scale <1, 0.0275, 1>
         } // end height_field                   
   cylinder { <0,-.0137,0> <0,0.2,0> 1 translate <0,0.0,0> }
  }                                                           
 cylinder { <0,-.0137,0> <0,-0.1,0> 0.42 translate <0,0,0.01> 
   texture  {cyltex2}}//color <1,0.7,0>} }
rotate <0,-38,0>
translate <xloc+.1, 1.604+(9*yshift), zloc + .2>
}
coin10
  /*
#declare coin11 =  union
{
intersection 
  {
   height_field {
    gif "coin2b.gif"
    smooth
    texture {cyltex2} // pigment {color <1,0.7,0>}
    translate <-.5, -.5, -.50>
    scale <1, 0.0275, 1>
         } // end height_field                   
   cylinder { <0,-.0137,0> <0,0.2,0> 1 translate <0,0.0,0> }
  }                                                           
 cylinder { <0,-.0137,0> <0,-0.1,0> 0.42 translate <0,0,0.01> 
   texture  {cyltex2}}//color <1,0.7,0>} }
rotate <0,-38,0>
translate <xloc+.01, 1.604+(10*yshift), zloc + .06>
}
coin11
 
#declare coin12 =  union
{
intersection 
  {
   height_field {
    gif "coin2b.gif"
    smooth
    texture {cyltex2} // pigment {color <1,0.7,0>}
    translate <-.5, -.5, -.50>
    scale <1, 0.0275, 1>
         } // end height_field                   
   cylinder { <0,-.0137,0> <0,0.2,0> 1 translate <0,0.0,0> }
  }                                                           
 cylinder { <0,-.0137,0> <0,-0.1,0> 0.42 translate <0,0,0.01> 
   texture  {cyltex2}}//color <1,0.7,0>} }
rotate <0,-20,0>
translate <xloc+.02, 1.604+(11*yshift), zloc + .04>
}
coin12

#declare coin13 =  union
{
intersection 
  {
   height_field {
    gif "coin2b.gif"
    smooth
    texture {cyltex2} // pigment {color <1,0.7,0>}
    translate <-.5, -.5, -.50>
    scale <1, 0.0275, 1>
         } // end height_field                   
   cylinder { <0,-.0137,0> <0,0.2,0> 1 translate <0,0.0,0> }
  }                                                           
 cylinder { <0,-.0137,0> <0,-0.1,0> 0.42 translate <0,0,0.01> 
   texture  {cyltex2}}//color <1,0.7,0>} }
rotate <0,-120,0>
translate <xloc-.02, 1.604+(12*yshift), zloc + .04>
}
coin13

#declare coin14 =  union
{
intersection 
  {
   height_field {
    gif "coin2b.gif"
    smooth
    texture {cyltex2} // pigment {color <1,0.7,0>}
    translate <-.5, -.5, -.50>
    scale <1, 0.0275, 1>
         } // end height_field                   
   cylinder { <0,-.0137,0> <0,0.2,0> 1 translate <0,0.0,0> }
  }                                                           
 cylinder { <0,-.0137,0> <0,-0.1,0> 0.42 translate <0,0,0.01> 
   texture  {cyltex2}}//color <1,0.7,0>} }
rotate <0,120,0>
translate <xloc-.03, 1.604+(13*yshift), zloc + .025>
}
coin14

#declare coin15 =  union
{
intersection 
  {
   height_field {
    gif "coin2b.gif"
    smooth
    texture {cyltex2} // pigment {color <1,0.7,0>}
    translate <-.5, -.5, -.50>
    scale <1, 0.0275, 1>
         } // end height_field                   
   cylinder { <0,-.0137,0> <0,0.2,0> 1 translate <0,0.0,0> }
  }                                                           
 cylinder { <0,-.0137,0> <0,-0.1,0> 0.42 translate <0,0,0.01> 
   texture  {cyltex2}}//color <1,0.7,0>} }
rotate <0,120,0>
translate <xloc -.06, 1.604+(14*yshift), zloc + .045>
}
coin15

*/

   
#declare coinv =  union
{
intersection 
  {
   height_field {
    gif "coin2b.gif"
    smooth
    texture {cyltex2} // pigment {color <1,0.7,0>}
    translate <-.5, -.5, -.50>
    scale <1, 0.0275, 1>
         } // end height_field                   
   cylinder { <0,-.0137,0> <0,0.2,0> 1 translate <0,0.0,0> }
  }                                                           
 cylinder { <0,-.0137,0> <0,-0.1,0> 0.42 translate <0,0,0.01> 
   texture  {cyltex2}}//color <1,0.7,0>} }
 scale 0.9
rotate <0, 0, 0>
rotate <0,-90, 0>
rotate <0, 0, -60>
rotate <0, -36, 0>
translate <xloc + .65, 1.604+(3.*yshift), zloc + 0.33>
}
coinv

#declare tscale9 = .1 ;
#declare ring = torus {0.7,0.2 scale tscale9   texture { cyltex2} 
   rotate <90,0,0> translate <0,0,0> } //0 -1 0
     
#macro Make_Many9 (Stuff,How_Many,Axis)
  #local Count=0;   // this identifier is local and 
                    // temporary to this macro
  #while (Count<How_Many)
    object{Stuff rotate Axis*Count*(360/How_Many) 
      rotate y*Count*360/1 //How_Many
      translate 1.9*z*cos (Count*tscale3*1) //Count*y*tscale3
      translate x*sin (Count*tscale3*2) //Count*x*tscale3*1
      }
    #local Count=Count+1;
  #end
#end

union {
  Make_Many9 (ring,480,y) //360,y)
  //torus {2 0.03 texture {cyltex2} rotate <90,0,0> translate <0,2,0>}
  rotate <0,20,0>
  translate <1.75, 1.6, 2.5>
  scale 1  
}
