#include "colors.inc"
#include "makeitlookgood.inc"

global_settings{assumed_gamma 1}

camera {
location <0,10,-4>
//location <0,20,10>
//look_at <0,9,10>
look_at <0,9,0,>
}

light_source {<0,100,-50> color rgb<0.9,1,0.9>
area_light
<20,0,0>,<0,0,20>,4,4
adaptive 1
}

sky_sphere{
pigment{the_sun}
pigment{the_gradient}
pigment{cloud_layer}
}

height_field{
tga "bed1.tga"
smooth
water_level 0.4
   texture  
   {
      pigment
      {
         gradient z
         pigment_map
         {
            [0.0
               bozo
               color_map
               {
                  [ 0.0     rgbft <0.3125, 0.156233, 0.0, 0.0, 0.0> ]
                  [ 0.5     rgbft <0.218733, 0.2604, 0.1354, 0.0, 0.0> ]
                  [ 0.75    rgbft <0.47258, 0.47258, 0.006553, 0.0, 0.0> ]
                  [ 1.0     rgbft <0.0104, 0.4479, 0.0104, 0.0, 0.0> ]
               }
            ]
            [0.7
               bozo
               color_map
               {
                  [ 0.0     rgbft <0.3125, 0.156233, 0.0, 0.0, 0.0> ]
                  [ 0.5     rgbft <0.218733, 0.2604, 0.1354, 0.0, 0.0> ]
                  [ 0.75    rgbft <0.47258, 0.47258, 0.006553, 0.0, 0.0> ]
                  [ 1.0     rgbft <0.0104, 0.4479, 0.0104, 0.0, 0.0> ]
               }
            ]
            [1.0
               bozo
               color_map
               {
                  [ 0.0     rgbft <0.6,0.6, 0.6, 0.0, 0.0> ]
                  [ 1.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
               }               turbulence 0.3
            ]
         }
      }
      normal
      {
         gradient z
         normal_map
         {
            [0.0
               granite , 0.1
            ]
            [0.3
               granite , 0.1
            ]
            [1.0
               granite , 0.1               turbulence 0.3               scale  0.3
            ]
         }
      }
      finish
      {
         ambient 0.1
         diffuse 0.7
      }
   }



translate <0,0,0>
scale <24,4,18>*2
translate <-26,0.2,-5>
rotate y*23
}

plane{y, 3.51
texture{wada}}

plane{y, 3.5
pigment{color rgb<0,0,0.2>}}

//-----Solenoids

#declare times = 0
#declare level =2
#declare circlepts = 200
//#declare circlepts = 100
#declare SOLTEX= texture{
 pigment{
  gradient y
  color_map{
   [0 Yellow]
   [1 Green]
          }
    turbulence 0.3
     }
 finish{
  phong .85
  phong_size 30
  }  
}


#declare SOL = union {
#while(times<6)
#declare RO = <0,times*50,0>
#declare TR = <0+cos(times)*5,2,8+sin(times)*5>
#include "solenoid.inc"
#declare times=times+1
#end
}

object {SOL
scale 0.5
translate<6,4,7.4>
}

object {SOL
scale 1.4
translate<-3,4,10.4>
}

//-----Lissajous

#declare theta =30
#declare phi = 12
#declare rep = 20
#declare r1 = 1.5
#declare r2= 2
#declare theta= theta*(pi/180)
#declare phi=phi*(pi/180)
#declare T =0

#declare G = union {
//threshold 0.1
#while (T<(rep*pi))
#declare X = r1*sin(theta*T)*cos(phi*T)
#declare Z = r1*cos(theta*T)
#declare Y = r1*sin(theta*T)*sin(phi*T)
sphere{<X,Z,Y>0.2}
#declare T = T + 0.05
#end
}

object{G
pigment{
leopard
color_map{
[0 White]
[0.4 Red]
[1 Red]
  }
scale 0.2
}
finish{
phong 0.8
phong_size 20
reflection 0.2
}

translate<6,6,11>
}
object{G
pigment{
leopard
color_map{
[0 Red]
[0.4 White]
[1 White]
  }
scale 0.2
}
finish{
phong 0.8
phong_size 20
reflection 0.2
}
scale 2
translate<-2.7,8,20>
}

//-----Butterfly Things

#declare  theta =0
#declare BU = union {
#while(theta<100*pi)
#declare r1 = exp(cos(theta)) - 2*cos(4*theta) + (sin(theta/12))*5
#declare X = r1*cos(theta)
#declare Y = r1*sin(theta)
#declare xx = (X)
#declare yy = (Y)
sphere{<xx,0,yy>,0.5}
#declare theta= theta + 0.05
//#declare theta= theta + 0.5
#end
}

#declare times =0
#while(times<12)
#declare RO = <0,times*50,0>
#declare TR = <-5+cos(times)*4,5,12+sin(times)*4>
object{BU
scale 0.1
rotate RO
translate TR
pigment{rgb <0,1,0>}
finish{phong 0.8 phong_size 50}
}
#declare times=times+1
#end



//-----Strange Chaotic Attractor

#declare iter2=5000
#declare A=2.24
#declare B=0.43
#declare C=-0.65
#declare D=-2.43
#declare E=1
#declare i=0
#declare X=0
#declare Y=0
#declare Z=0

#declare SCA= union{
 #while(i<iter2)
 #declare xx=sin(A*Y) -Z*cos(B*X)
 #declare yy=Z*sin(C*X)-cos(D*Y)
 #declare zz=E*sin(X)
 #declare X=xx
 #declare Y=yy
 #declare Z=zz
sphere{<X,Z,Y>,0.1 pigment{color rgb <X+0.01,Y+0.01,Z+0.01>}
finish{diffuse 0.65 specular 1 roughness 0.05 phong 0.5 phong_size 70} }
#declare i=i+1
 #end
}

object{SCA
translate <-5,5.5,12>
}


plane {y, 900
texture {
pigment {bozo
turbulence .4
lambda 6
octaves 3
omega .7
color_map {
[0 color rgbt <1,1,1, 1>]
[.4 color rgbt <1,1,1, 1>]
[.5 color rgbt <1, 1, .5, .8>]
[.7 color rgbt <1,1,1, 1>]
[1 color rgbt <1,1,1, 1>]
}
}
finish {ambient .7 diffuse .5}
scale 2000
translate <-500,-10000,900>
}
hollow
}

plane { y, 300.0
hollow on
pigment {
bozo
omega .5
lambda 5
octaves 6
turbulence 0.5
color_map {
[0.0  color rgbf <1, 1, 1, 1>]
[0.6 color rgbft <0.4, 0.4, 0.1, 1,1>]
[0.8 1.001 color rgbt <0.2, 0.25, 0.2,0.8>
color rgb <0.8, 0.8, 0.1>]
}
scale <1000.0, 200.0, 800.0>
}
finish {
ambient 1
diffuse 0.0
}
translate -450*x
}
