#include "colors.inc"
#include "textures.inc"
#include "jellytext.inc"

#declare R1 = seed (1234)
#include "jellyobj.inc"

camera {
       location  <-3, 2, -10.0>
       look_at   <0, 0.5, 0.001>
}

light_source {<-30, 30, -30> color White}
light_source {<10, 50, -10> color Gray70 shadowless}

plane {z, 50
      hollow
      pigment {
              gradient y
              color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
              scale 50
              }
}

// used to speeed up test renders
#declare final = 0
#declare final = 1

// ----------------------------------------------------
// scene

// hills
#if (final = 1)
object {Jelly_Mountain
        translate <3, 0, 7>
        texture {Red_Jelly}
}
object {Jelly_Mountain
        scale 1.5
        translate <12, 0, 11>
        texture {Yellow_Jelly}
}
object {Jelly_Mountain
        scale 1.8
        translate <-10, 0, 18>
        texture {Purple_Jelly}
}

// trees
object {Candy_Floss_Tree
        translate <-3, 5, 5>
}
object {Candy_Floss_Tree
        rotate <0, 50, 0>
        translate <-7, 4, 8>
}
object {Candy_Floss_Tree
        rotate <0, 50, 0>
        translate <11, 4, 3>
}

object {Toffee_Apple_Tree
        rotate <5, 30, 0>
        translate <-4, 3, 3>
}
object {Toffee_Apple_Tree
        translate <8.6, 2, 4>
}
#end

// diving board
superellipsoid {<0.2, 0.2>
               texture {Nougat}
               scale <1.5, 0.1, 0.3>
               translate <1, 0.5, -4>
}
object {DB_rail
        translate <2, 0, -3.7>
}
object {DB_rail
        translate <2, 0, -4.3>
}

// ground + tiling around pool
object {Choc_Chunk
        translate <2, 0, -2>}
object {Choc_Chunk
        translate <-2, 0, -2>}
object {Choc_Chunk
        translate <-6, 0, -2>}
object {Choc_Chunk
        translate <2, 0, -6>}
object {Choc_Chunk
        translate <2, 0, -10>}
object {Choc_Chunk
        translate <-2, 0, -10>}
object {Choc_Chunk
        translate <-6, 0, -10>}
object {Choc_Chunk
        translate <-8, 0, -6>}
object {Choc_bit
        translate <-6.5, -0.4, 1.5>}
object {Choc_bit
        translate <-6.5, -0.4, 0.5>}

difference {
           plane { y, 0 }
           box {<-4, 1, -2>, <2, -2, -6>}
           texture {Chocolate}
}

// pool
height_field {
              gif
              "waves.gif"
              smooth
              translate <-0.5, 0, -0.5>
              scale <6, 0.5, 5>
              translate <-1, -0.5, -4>
              texture {Milk}
}

// splashes


// swimmers
object {Jelly_Baby
        rotate <0, -30, 0>
        translate <-2.5, -0.5, -3>
}
// diver
object {Jelly_Baby
        rotate <0, 80, 0>
        translate <-0.1, 0.7, -4>
        pigment {color Gray20}
}
// air bed
union {
object {Liq_Round}
object {Liq_Round
        translate <-0.25, 0, 0>}
object {Liq_Round
        translate <0.25, 0, 0>}        
object {Jelly_Baby
        pigment {color rgb <0.8, 0.8, 0.2>}
        rotate <90, 0, 0>
        translate <0, 0.2, -0.25>
}                
rotate <0, -30, 0>
translate <-2, -0.25, -5>       
} // end union 


// poolside
object {Lolly_Umbrella
        rotate <0, 0, -10>
        translate <-2.5, 0.5, -1.5>}
object {Jelly_Baby
        pigment {color rgb <0.8, 0.8, 0.6>}
        rotate <90, -40, 0>
        translate <-2, 0.25, -1.5>
}                        
object {Jelly_Baby
        pigment {color Gray20}
        rotate <90, -40, 0>
        translate <-2.5, 0.25, -1.5>
}                        

object {Lolly_Umbrella
        translate <-5, 0.5, -3>}

object {Jelly_Baby
        pigment {color rgb <0.8, 0.8, 0.6>}
        rotate <0, 40, 0>
        translate <-3, 0.2, -7>
}                        


object {Lolly_Umbrella
        rotate <0, 0, -10>
        translate <-0.5, 0.8, -8>}        
union {
object {Liq_Round}
object {Liq_Round
        translate <-0.25, 0, 0>}
object {Liq_Round
        translate <0.25, 0, 0>}        
object {Jelly_Baby
        rotate <90, 0, 0>
        translate <0, 0.2, -0.25>
}                
rotate <0, 60, 0>
translate <-0.5, 0.2, -7>       
} // end union 


// wall
#declare Count = 0
#while (Count < 14)
object {Liq_Square
       translate <-7 + Count, 0, 2>
}
object {Liq_Square
        rotate <0, 0, 180>
        translate <-7 + Count+ 0.65, 0.4, 2>
}
object {Liq_Square
        rotate <0, 0, 180>
        translate <6.5, 0.4, 2 - Count>
}
object {Liq_Square
        translate <6.5, 0, 2 - Count - 0.65>
}

#declare Count=Count + 1.3
#end


