//
// File: belljar.inc - A bell Jar
// Written: Jonathan Merritt, 1998 / 1999.
// Description: A Bell Jar, about 18 units tall.
// Contact: jmerritt@warpax.com
//
// Dependencies:
//#include "golds.inc"
//#include "glass.inc"
//#include "metals.inc"
//
// Copyright (C), Jonathan Merritt, 1998, 1999.
//
// This file was submitted to the IRTC in Feb 1999.
//


// A bell jar,
// about 18 units tall

#declare chain_tex = texture { T_Gold_5E }
#declare jar_tex = texture { T_Glass3 }
#declare base_tex = texture {
  pigment
  {
    color rgb <0.247059, 0.247059, 0.247059>
  }
  finish
  {
    ambient 0.1
    phong 0.5
    phong_size 3.0
    roughness 0.6
    reflection 0.08
  }
}


#declare link = blob {
  threshold 1
  #declare Count = 0;
  #declare NumSteps = 150;
  #while (Count < NumSteps)
    cylinder {
      <-0.7, 0, 0>, <0.7, 0, 0>, 2, 1
      scale <1,1,0.2>
      rotate y*((Count/NumSteps)*180 + 45)
      translate 10*x
      rotate z*((Count/NumSteps)*360 + 45)
    }
    #declare Count = Count + 1;
  #end
  scale <1,1.5,1>
  //rotate y*60
  scale 0.1
}

#declare bell = merge {
  cylinder { <0,0,0>, <0,8,0>, 5 }
  sphere { <0,8,0>, 5 }
}

#declare linkset1 = union {
  object { link rotate -14*y rotate 97*x translate <0,13.3,0> }
  object { link rotate 14*y rotate 70*x translate <0,13,-2.4> }
  object { link rotate -14*y rotate 50*x translate <0,11.8,-4.2> }
  object { link rotate 14*y rotate 30*x translate <0,9.9,-5.8> }
  object { link rotate -14*y rotate 40*x translate <0,8,-7.1> }
}

#declare alllinks = union {
  object { linkset1 }
  object { linkset1 translate -13*y rotate 180*x translate 0.7*y translate -16*z }
  sphere { <0,7,-8>, 0.6 }
  rotate y*23
}

#declare handle = union {
  difference {
    sphere { <0,13,0>, 0.8 }
    object { bell }
  }
  cylinder { <0,13,0>, <0,14,0>, 0.6 }
  sphere { <0,14,0>, 0.6 }
  torus {
    2.5, 0.1
    translate 2.5*x
    rotate -30*z
    translate y*14
  }
}

#declare chain = union {
  object { handle }
  object { alllinks }
  texture { chain_tex }
}

#declare bellbase = cylinder {
  <0,0,0>, <0,1,0>, 4.8
  texture { base_tex }
}

#declare jar = difference {
  object { bell }
  object { bell scale (1-0.2/5) translate -0.001*y hollow }
  texture { jar_tex }
}

#declare belljar = union {
  object { bellbase }
  object { chain }
  object { jar scale 1.001 }
  scale 1.4
}
