//
// File: crystal_ball.inc - A crystal ball!
// Written: Jonathan Merritt, 1998 / 1999.
// Description: A crystal ball in a holder with green felt lining.
//              about 12 units tall.
// Contact: jmerritt@warpax.com
//
// Dependencies:
//#include "glass.inc"
//
// Copyright (C), Jonathan Merritt, 1998, 1999.
//
// This file was submitted to the IRTC in Feb 1999.
//

#declare ball_tex = texture {
  T_Glass3
}

#declare base_tex = texture {
  pigment
  {
    color rgb <0.247059, 0.247059, 0.247059>
  }
  finish
  {
    ambient 0.1
    phong 0.5
    phong_size 3.0
    roughness 0.6
    reflection 0.08
  }
}

#declare felt_tex = texture {
  pigment { color Green * 0.4 }
}


#declare ball = sphere {
  <0,6.05,0>, 6
}

#declare base = difference {
  cone {
    <0,0,0>, 6
    <0,3,0>, 5.4
    texture { base_tex }
  }
  object {
    ball
    scale 1.01
    texture { felt_tex }
  }
}

#declare crystal_ball = union {
  object { ball texture { ball_tex } }
  object { base }
}
