//
// File: dodohedron.inc - A cool blocky wooden thing.
// Written: Jonathan Merritt, 1998 / 1999.
// Description: A wooden shape, made of several blocks.
// Contact: jmerritt@warpax.com
//
// Dependencies:
//#include "woods.inc"
//
// Copyright (C), Jonathan Merritt, 1998, 1999.
//
// This file was submitted to the IRTC in Feb 1999.
//

#declare dodohedron_tex = texture {
  T_Wood1
  finish {
    ambient 0.3
    reflection 0.1
    phong 0.1
  }
}


#declare ta = (sqrt( 18 ) / 2);


#declare ubox = box {
  <-4.5,-1.5,-1.5>, <4.5, 1.5, 1.5>
  rotate x * 45
}

#declare unit = difference {
  object { ubox scale 0.9999 }
  object { ubox rotate y*90 translate <-2.25, -ta, 0> }
  object { ubox rotate y*90 translate <2.25, -ta, 0> }
  object { ubox rotate z*90 translate <-4.5, 0, -ta> }
  object { ubox rotate z*90 translate <-4.5, 0, ta> }
  object { ubox rotate z*90 translate <4.5, 0, -ta> }
  object { ubox rotate z*90 translate <4.5, 0, ta> }
  scale 0.95
  bounded_by { object { ubox } }
  texture { dodohedron_tex rotate y*90 }
}

#declare dodohedron = union {
  object { unit translate 2.25*y }
  object { unit rotate 180*x translate -2.25*y }
  object { unit rotate 90*y rotate 90*z translate -2.25*x }
  object { unit rotate 90*y rotate -90*z translate 2.25*x }
  object { unit rotate 90*z rotate 90*y translate 2.25*z }
  object { unit rotate 90*z rotate -90*y translate -2.25*z }
  translate y*4.5
}
