//
// File: hatstand.inc - A hatstand
// Written: Jonathan Merritt, 1998 / 1999.
// Description: A Hat Stand.
// Contact: jmerritt@warpax.com
//
// Dependencies:
//#include "woods.inc"
//
// Copyright (C), Jonathan Merritt, 1998, 1999.
//
// This file was submitted to the IRTC in Feb 1999.
//

#declare hstex = texture {
  T_Wood34
}

#declare hattex = texture {
  pigment {
    color Yellow * 0.8 + Red * 0.2
  }
  finish {
    diffuse 0.3
  }
}

#declare ss = 0.000001

#declare arm = union {
  cylinder { <0,0,0>, <1.5,0,0>, 0.2 }
  intersection {
    torus { 0.7, 0.2 rotate 90*x translate <1.5,0.7,0> sturm }
    box { <1.5,-0.2-ss,-0.2-ss>, <2.4+ss,0.7,0.2+ss> }
  }
  cylinder { <2.2,0.7,0>, <2.2,1.7,0>, 0.2 }
  sphere { <2.2,1.7,0>, 0.2 }
  texture { hstex scale 4 rotate 20*z rotate 30*y }
}

#declare hbowl = union {
  cylinder { <0,0,0>, <0,0.7,0>, 0.7 scale <(1/0.7),1,1> }
  sphere { <0,0,0>, 0.7 scale <(1/0.7),(0.3/0.7),1> translate 0.7*y }
}

#declare hrim = intersection {
  difference {
    sphere { <0,-6,0>, (sqrt(37)+0.05) }
    sphere { <0,-6,0>, (sqrt(37)) }
  }
  cylinder { <0,-0.5,0>, <0,0.5,0>, 1 scale <(1.3/1),1,1> }
}

#declare hat = union {
  difference {
    object { hbowl }
    object { hbowl scale 0.9 translate -0.001*y }
    object { hrim }
  }
  difference {
    object { hrim }
    object { hbowl scale 0.9 translate -0.5*y }
    translate -0.05*y
  }
  texture { hattex }
}

#declare stand = union {
  union {
    cylinder { <0,0,0>, <0,0.3,0>, 1.7 }
    difference {
      torus { 1.7, 0.3 }
      cylinder { <0,-0.3-ss,0>, <0,0,0>, 2+ss }
    }
    texture { hstex rotate 30*x rotate 42*y translate 0.5*x }
  }
  union {
    cylinder { <0,0.3,0>, <0,15,0>, 0.2 }
    sphere { <0,0,0>, 0.3 scale <1,2,1> translate 15*y }
    texture { hstex rotate 88*x rotate 80*y }
  }
  object { arm translate <0,11.8,0> }
  object { arm rotate 90*y translate <0,11.8,0> }
  object { arm rotate 180*y translate <0,11.8,0> }
  object { arm rotate 270*y translate <0,11.8,0> }
}

#declare hatstand = union {
  object { stand }
  object { hat rotate -60*z translate <2.25,13.2,0> }
}
