//
// File: escher.pov - Escher's office
// Written: Jonathan Merritt, 1998 / 1999.
// Description: Escher's Office flies through a starry void!
// Contact: jmerritt@warpax.com
//
// Copyright (C), Jonathan Merritt, 1998, 1999.
//
// This file was submitted to the IRTC in Feb 1999.
//

#include "colors.inc"
#include "woods.inc"
#include "metals.inc"
#include "stones.inc"
#include "glass.inc"

#include "newton.inc"
#include "dodohedron.inc"
#include "crystal_ball.inc"
#include "belljar.inc"
#include "trumpet.inc"
#include "hatstand.inc"

camera {
  location <7.5,8,-7>
  look_at <7.5,8,15>
}

light_source {
  <40,25,2>
  color White
}

sky_sphere {
    pigment {
        granite
        color_map {
            [ 0.000  0.270 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.270  0.280 color rgb <.5,.5,.4> color rgb <.8,.8,.4> ]
            [ 0.280  0.470 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.470  0.480 color rgb <.4,.4,.5> color rgb <.4,.4,.8> ]
            [ 0.480  0.680 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.680  0.690 color rgb <.5,.4,.4> color rgb <.8,.4,.4> ]
            [ 0.690  0.880 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.880  0.890 color rgb <.5,.5,.5> color rgb < 1, 1, 1> ]
            [ 0.890  1.000 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
        }
    turbulence 1
    sine_wave
    scale .05
    }
}

#declare roomtex = texture {
  T_Stone17    // T_Stone5 is also a good one
  finish {
    reflection 0.05
  }
  scale 1.5
}

// ss is an additive constant for CSG stuff (stop walls and cut-outs looking bad).
#declare ss = 0.000001;

// The following are various structural elements of the room:
#declare wall_frame1 = difference {
  box { <0,0,0>, <15,15,2> }
  box { <-ss,3,-ss>, <12,12,2+ss> }
  bounded_by {
    box { <-ss,-ss,-ss>, <15+ss,15+ss,2+ss> }
  }
}

#declare wall_frame = difference {
  object { wall_frame1 }
  box { <-ss,12-ss,-ss>, <0.4,15+ss,2+ss> }
  bounded_by {
    box { <-ss,-ss,-ss>, <15+ss,15+ss,2+ss> }
  }
}

#declare arch = difference {
  box { <0.4,9,0.4>, <12,12,1.6> }
  cylinder { <6,6.5,0>, <6,6.5,2>, sqrt(25.61) }
  bounded_by {
    box { <0.4-ss,9-ss,0.4-ss>, <12+ss,12+ss,1.6+ss> }
  }
}

#declare column = union {
  box { <-1,0,-1>, <1,0.5,1> }
  box { <-1,5.5,-1>, <1,6,1> }
  cylinder { <0,0.5,0>, <0,5,0>, 0.6 }
  prism {
    conic_sweep
    linear_spline
    0.9, 1, 5
    <-1,-1>, <1,-1>, <1,1>, <-1,1>, <-1,-1>
    translate -0.9*y
    scale <1,2,1>
    translate 5.3*y
  }
  cone { <0,5,0>, 0.8, <0,5.3,0>, 0.9 }
  torus { 0.6, 0.2 translate 5*y }
  torus { 0.6, 0.1 scale <1,2,1> translate 0.6*y }
  torus { 0.6, 0.2 translate 0.5*y }
}

#declare ibeam = difference {
  box { <0,0,0>, <15,15,2> }
  box { <-ss,3,-ss>, <7,12,2+ss> }
  box { <8,3,-ss>, <15+ss,12,2+ss> }
  box { <-ss,12-ss,-ss>, <0.4,15+ss,2+ss> }
  box { <14.6,-ss,-ss>, <15+ss,3+ss,2+ss> }
  bounded_by {
    box { <-ss,-ss,-ss>, <15+ss,15+ss,2+ss> }
  }
}

#declare smarch1 = difference {
  box { <0.4,9,0.4>, <7,12,1.6> }
  cylinder { <3,8.5,0>, <3,8.5,2>, 2.5 }
  bounded_by {
    box { <0.4-ss,9-ss,0.4-ss>, <7+ss,12+ss,1.6+ss> }
  }
}

#declare smarch2 = difference {
  box { <8,3,0.4>, <14.6,6,1.6> }
  cylinder { <11.5,6.5,0>, <11.5,6.5,2>, sqrt(3.86) }
  bounded_by {
    box { <8-ss,3-ss,0.4-ss>, <14.6+ss,6+ss,1.6+ss> }
  }
}

// The room was originally going to be split into little brick sections, to give an
// effect similar to 'Other World'. This was abandoned, however, when rendering times
// became *PROHIBITIVELY* large (est. at 40hrs plus!).
//  'roommask' is the actual room solid geometry (to be used in a CSG intersection with
//             the lattice).
//  'room' is the version of the room after the intersection.
// The only part rendered is 'roommask' (for the reason given above).
                                                                   
#declare roommask = union {
  // Top & side
  object { wall_frame translate 13*z }
  object { wall_frame rotate 90*y translate 15*z }
  object { arch translate 13*z }
  object { arch rotate 90*y translate 15*z }
  object { column translate <1,3,14> }
  object { column translate <11,3,14> }
  object { column translate <1,3,4> }
  // Base
  object { wall_frame1 rotate <90,0,180> translate <15,0,0> }
  object { arch rotate <90,0,180> translate <15,0,0> }
  object { column rotate 90*x translate <4,1,3> }
  object { column rotate 90*x translate <14,1,3> }
  // Top
  object { wall_frame1 rotate <-90,0,180> translate <15,16,15> }
  object { arch rotate <-90,0,180> translate <15,16,15> }
  object { column rotate -90*x translate <4,15,12> }
  object { column rotate -90*x translate <14,15,12> }
  // H-Side
  object { ibeam rotate -90*z rotate 90*y translate <13,15,15> }
  object { column rotate -90*x translate <14,9,12> }
  object { smarch1 rotate -90*z rotate 90*y translate <13,15,15> }
  object { smarch2 rotate -90*z rotate 90*y translate <13,15,15> }
  object { column rotate 90*x translate <14,6,3> }
}


// The abandoned lattice section...
#declare NumLattice = 30;
#declare BoxHeight = 16/NumLattice;
#declare Gap = 0.1;
#declare lattice1 = union {
  #declare Count = 0;
  #while (Count < NumLattice)
    box { <0,0,0>, <15,(BoxHeight-Gap),16> translate BoxHeight*Count*y }
    #declare Count = Count + 1;
  #end
}
#declare lattice2 = union {
  #declare Count = 0;
  #while (Count < NumLattice)
    box { <0,0,0>, <15,16,(BoxHeight-Gap)> translate BoxHeight*Count*z }
    #declare Count = Count + 1;
  #end
}
#declare lattice3 = union {
  #declare Count = 0;
  #while (Count < NumLattice)
    box { <0,0,0>, <(BoxHeight-Gap),16,15> translate BoxHeight*Count*x }
    #declare Count = Count + 1;
  #end
}

// The room made of bricks
#declare room = intersection {
  object { roommask }
  object { lattice1 }
  object { lattice2 }
  //object { lattice3 }
  bounded_by {
    object { roommask }
  }
  texture { roomtex }
}

// roommask (no bricks) or room (bricks - BIG render time)
object { roommask texture { roomtex } }


/////////////////////////////////////////////////////////////////////////////////////////////
// The trumpets in the room
object { trumpet scale (1/6) rotate 90*y translate <1,12.3,8.5> }
object { trumpet scale (1/6) rotate 90*y rotate -90*x translate <14,11.78,3.4> }
object { trumpet scale (1/6) rotate 90*y rotate 90*x translate <14,3.81,11.7> }

/////////////////////////////////////////////////////////////////////////////////////////////
// Other objects around the room

object { hatstand scale (4/10) rotate -35*y rotate -90*x translate <2.9,13,13> }

object { belljar scale (1/9) rotate -20*y translate <1,3,12> }

object { dodohedron scale (1/9) rotate -50*y translate <1,3,7> }

object { newtons_cradle scale (1/13) rotate 80*y rotate -90*x translate <14,12.3,12> }

/////////////////////////////////////////////////////////////////////////////////////////////
// Central Decoration (green organic thingo).

blob {
  threshold 5.5
  #declare Count = 0;
  #declare MaxNum = 200;
  #while (Count < MaxNum)
    #declare X = 7.5 + sin( radians( Count/MaxNum*360*6 ) )*2;
    #declare Z = 7.5 + cos( radians( Count/MaxNum*360*6 ) )*2;
    #declare Y = Count/MaxNum*20;
    sphere {
      <X,Y,Z>, 2 strength 1
    }
    #declare Count = Count + 1;
    #declare X = 7.5 + sin( radians( Count/MaxNum*360*4 ) )*1.5;
    #declare Z = 7.5 + cos( radians( Count/MaxNum*360*4 ) )*1.5;
    #declare Y = Count/MaxNum*20;
    sphere {
      <X,Y,Z>, 2 strength 1
    }
    #declare X = 7.5 + cos( radians( Count/MaxNum*360*4 ) )*2;
    #declare Z = 7.5 + cos( radians( Count/MaxNum*360*4 ) )*0.1;
    #declare Y = Count/MaxNum*20;
    sphere {
      <X,Y,Z>, 2 strength -0.3
    }
  #end
  translate <0,-2,3>
  scale <1,1.5,1>
  texture {
    pigment {
      color Green transmit 0.4 filter 0.3
    }
    finish
    {
      phong 0.5
      reflection 0.8
      metallic
      refraction 1
      ior 1.7
    }
  }
}


// END OF FILE //