//
// File: newton.inc - a Newton's Cradle
// Written: Jonathan Merritt, 1998 / 1999.
// Description: A Newton's Cradle, 15 units tall.
// Contact: jmerritt@warpax.com
//
// Dependencies:
//#include "colors.inc"
//#include "metals.inc"
//#include "stones.inc"
//
// Copyright (C), Jonathan Merritt, 1998, 1999.
//
// This file was submitted to the IRTC in Feb 1999.
//


#declare tex_arm = texture { T_Chrome_3C }
#declare tex_ball = texture { T_Gold_4D }
#declare tex_wire = texture {
  pigment
  {
    color rgb <0.247059, 0.247059, 0.247059>
  }
  finish
  {
    ambient 0.1
    phong 0.2
    phong_size 5.0
    roughness 0.6
    reflection 0.03
  }
}
// T_Wood6 - dark red
#declare tex_base = texture { T_Wood34 }
#declare tex_base_top = texture { T_Wood34 }



#declare elbow = blob {
  threshold 1.0

  #declare Count = 0;
  #declare Steps = 40;
  #while (Count < Steps)
    sphere {
      <0,0,0>, 1.5
      strength 0.47
      translate 3*x
      rotate z*(-20)
      rotate z*(130/Steps)*Count
    }
    #declare Count = Count + 1;
  #end

  translate -3*y
  translate 0.03*y
  translate 0.045*x
}


#declare arm = union {
  cylinder {  <-20,0,0>, <20,0,0>, 1  }
  cylinder {  <-23,-3, 0>, <-23, -30, 0>, 1  }
  cylinder {  <23, -3, 0>, <23, -30, 0>, 1  }
  object { elbow translate 20*x }
  object { elbow rotate 180*y translate -20*x }
  texture { tex_arm }
  translate 30*y
}


#declare ball = union {
  sphere { <0, 9, 0>, 3  texture { tex_ball } }
  union {
    cylinder {  <0, 11.5, 0>, <0, 30, 8>, 0.1  }
    cylinder {  <0, 11.5, 0>, <0, 30, -8>, 0.1  }
    texture { tex_wire }
  }
}

#declare newtons_cradle = union {

  // 2 supporting arms
  object { arm translate  8*z }
  object { arm translate -8*z }

  // Balls
  object { ball translate -15*x }
  object { ball translate -9*x }
  object { ball translate -3*x }
  object { ball translate 3*x }
  object { ball translate 9*x }
  object { ball translate -25*y rotate 20*z translate 25*y translate 15*x }

  // Base
  difference {
    box {
      <-30, -2, -13>, <30, 1, 13>
      texture { tex_base }
    }
    box {
      <-31, 0, -14>, <31, 2, 14>
      texture { tex_base_top }
    }
  }

  translate y*2.01

  // Scale the whole lot to be 15 units tall
  scale 15/30
}
