//
// File: trumpet.inc - An Escher trumpet
// Written: Jonathan Merritt, 1998 / 1999.
// Description: A 'trumpet' of the style used by Escher in 'Other World'
// Contact: jmerritt@warpax.com
//
// Dependencies:
//#include "golds.inc"
//#include "metals.inc"
//
// Copyright (C), Jonathan Merritt, 1998, 1999.
//
// This file was submitted to the IRTC in Feb 1999.
//

#declare trumpettex = texture { T_Gold_4D }

#declare IRad = 0.2;
#declare ORadI = 3;
#declare ORadF = 0.2;
#declare CRad = 15;
#declare NRings = 50;
#declare AngleI = 30;
#declare AngleF = -50;

#declare trumpet = union {
  #declare Count = 0;
  #while (Count < NRings)
    torus {
      ( 3 - ((ORadI-ORadF)/NRings) * Count ),
      IRad
      rotate 90*z
      translate (-CRad)*y
      rotate (AngleI + ((AngleF-AngleI)/NRings) * Count)*z
      translate -15*y
    }
    #declare Count = Count + 1;
  #end
  cylinder { <-7,0,0>, <-7,-27,0>, 0.3 }
  cylinder { <4,0,0>, <4,-27,0>, 0.3 }
  texture { trumpettex }
}
