#include "colors.inc"
#include "woods.inc"
#include "glass.inc"
#include "metals.inc"
#include "P_Watch.inc"
#include "Deck.inc"
#include "Clip.inc"
#include "Stand.inc"

#declare Floor_On=on
#declare Domino_On=on
#declare Spheres_On=on
#declare Watch_On=on
#declare Deck_On=on
#declare Clip_On=on
#declare dist=2

camera {
  //location <1*dist,3.55*dist,-6*dist>
  location <1*dist,4.4-1/3,-6*dist>
  look_at <0,.25,0>
}

/*light_source {<65,50,0> color rgb <1,1,.9>
  //fade_distance 40
  //fade_power 2
  //area_light <3,0,0>,<0,0,3>,3,3
  //adaptive 1
  //jitter
}
light_source {<0,30,-25> color rgb <.5,.5,.45>
  //fade_distance 20
  //fade_power 1
  //area_light <3,0,0>,<0,0,3>,3,3
  //adaptive 1
  //jitter
}
light_source {<17.5,40,0> color Blue*.5
  //area_light <3,0,0>,<0,0,3>,3,3
  //adaptive 1
  //jitter
}*/

background {SkyBlue}

#declare R1=seed(205)

#declare Dust=pigment {
  granite
  color_map {
    [0 rgbt 1]
    [2/3 rgbt 1]
    [2/3 Gray25]
    [9/12 Gray50]
    [9/12 rgbt 1]
    [1 rgbt 1]
  }
  turbulence .1
  scale .03125
}

/*#declare Dusty=texture {
  bozo
  texture_map {
    [0 pigment {Dust}]
    [.25 pigment {Dust scale 2}]
    [.5 pigment {Dust scale 1.5}]
    [.75 pigment {Dust scale .75}]
    [1 pigment {Dust scale 2.5}]
  }
  turbulence .15
}*/

#declare Norm1=normal {
  bozo .05
  turbulence .04
  octaves 3
  scale <.05,.05,1>
}

#declare Norm2=normal {
  onion .1
  turbulence .2125
  scale <.225,.2,1.15>
}

#declare Wood_Tex1=
    texture {pigment {P_WoodGrain15A color_map {M_Wood7A}}}
    texture {pigment {P_WoodGrain15B color_map {M_Wood7B}}}

#declare Wood_Tex2=
  texture {pigment {P_WoodGrain15A color_map {M_Wood10A}}}
  texture {pigment {P_WoodGrain15B color_map {M_Wood10B}}}


#declare Wooden1=texture {
  Wood_Tex1
  //pigment {White}
  //pigment {Brown}
  finish {
    //ambient .7
    //diffuse .2
    reflection .15
    specular .5
    roughness .05
  }
  normal {Norm1}
  rotate x*1
}

#declare Wooden2=texture {
  Wood_Tex2
  //pigment {White}
  //pigment {Brown}
  finish {
    //ambient .7
    //diffuse .2
    reflection .15
    specular .5
    roughness .05
  }
  normal {Norm1}
  scale 1
  rotate x*-1
}

#declare Gloss=finish {
  ambient .7
  diffuse .15
  brilliance 2.5
  specular 1
  roughness .005
  reflection .05
}

#declare Gloss2=finish {
  ambient .7
  diffuse .2
  specular 1
  roughness .0025
  reflection .175
}

#declare Big_Tile=union {
  box {<-3.95,-.1,-3.95>,<3.95,.1,3.95>}
  sphere {<-3.95,.05,-3.95>,.05}
  sphere {<-3.95,.05,3.95>,.05}
  sphere {<3.95,.05,-3.95>,.05}
  sphere {<3.95,.05,3.95>,.05}
  cylinder {<-3.95,.05,3.95>,<3.95,.05,3.95>,.05}
  cylinder {<-3.95,.05,-3.95>,<3.95,.05,-3.95>,.05}
  cylinder {<-3.95,.05,-3.95>,<-3.95,.05,3.95>,.05}
  cylinder {<3.95,.05,-3.95>,<3.95,.05,3.95>,.05}
}

#declare Small_Tile=union {
  box {<-1.95,-.1,-1.95>,<1.95,.1,1.95>}
  sphere {<-1.95,.05,-1.95>,.05}
  sphere {<-1.95,.05,1.95>,.05}
  sphere {<1.95,.05,-1.95>,.05}
  sphere {<1.95,.05,1.95>,.05}
  cylinder {<-1.95,.05,1.95>,<1.95,.05,1.95>,.05}
  cylinder {<-1.95,.05,-1.95>,<1.95,.05,-1.95>,.05}
  cylinder {<-1.95,.05,-1.95>,<-1.95,.05,1.95>,.05}
  cylinder {<1.95,.05,-1.95>,<1.95,.05,1.95>,.05}
}

#declare Domino_Base=difference {
  superellipsoid {<.25,.25>
    scale <2,1/3,1>
    //pigment {rgb <1,1,.625>}
    pigment {rgb <1,1,.65>}
    finish {Gloss}
    normal {bumps .025 scale .025}
  }
  box {<-.05,.3,-.85>,<.05,.35,.85>
    pigment {Black}
    finish {Gloss2}
  }
  box {<-2.1,-.4,-1.1>,<0,.4,1.1> pigment {rgb <1,1,.65>}}
}

#declare Domino_1=difference {
  object {Domino_Base}
  sphere {<1,1/3,0>,.2
    pigment {Black}
    finish {Gloss2}
  }
}

#declare Domino_2=difference {
  object {Domino_Base}
  sphere {<.5,1/3,.5>,.2
    pigment {Black}
    finish {Gloss2}
  }
  sphere {<1.5,1/3,-.5>,.2
    pigment {Black}
    finish {Gloss2}
  }
}

#declare Domino_3=difference {
  object {Domino_2}
  sphere {<1,1/3,0>,.2
    pigment {Black}
    finish {Gloss2}
  }
  /*sphere {<.5,1/3,.5>,.2
    pigment {Black}
    finish {Gloss2}
  }
  sphere {<1.5,1/3,-.5>,.2
    pigment {Black}
    finish {Gloss2}
  }*/
}

#declare Domino_4=difference {
  object {Domino_Base}
  sphere {<.5,1/3,-.5>,.2
    pigment {Black}
    finish {Gloss2}
  }
  sphere {<.5,1/3,.5>,.2
    pigment {Black}
    finish {Gloss2}
  }
  sphere {<1.5,1/3,-.5>,.2
    pigment {Black}
    finish {Gloss2}
  }
  sphere {<1.5,1/3,.5>,.2
    pigment {Black}
    finish {Gloss2}
  }
}

#declare Domino_5=difference {
  object {Domino_4}
  sphere {<1,1/3,0>,.2
    pigment {Black}
    finish {Gloss2}
  }
}

#declare Domino_6=difference {
  object {Domino_4}
  sphere {<1,1/3,-.5>,.2
    pigment {Black}
    finish {Gloss2}
  }
  sphere {<1,1/3,.5>,.2
    pigment {Black}
    finish {Gloss2}
  }
}

plane {y,-1/2 //-1/3
  texture {Wooden1}
}

#if (Domino_On=on)
object {Domino_2 rotate y*180}
object {Domino_Base}
object {Domino_1 rotate y*31 translate <.7,2/3,.3>}
object {Domino_3 rotate y*211 translate <.7,2/3,.3>}
object {Domino_1 rotate y*-23 translate <1.5,0,-2.75>}
object {Domino_4 rotate y*157 translate <1.5,0,-2.75>}
object {Domino_5 rotate x*-90 rotate y*-67 translate <-3,2/3,1.5>}
object {Domino_Base rotate y*180 rotate x*-90 rotate y*-67 translate <-3,2/3,1.5>}
object {Domino_6 rotate y*90 translate <4,0,3>}
object {Domino_4 rotate y*-90 translate <4,0,3>}
#end

#declare Tile_Pattern=union {
object {Big_Tile texture {Wooden1 rotate y*-10+rand(R1)*20} translate y*-1/3}
object {Small_Tile texture {Wooden2 rotate y*80+rand(R1)*20} translate <-6,-1/3,-2>}
object {Small_Tile texture {Wooden2 rotate y*80+rand(R1)*20} translate <6,-1/3,2>}
object {Small_Tile texture {Wooden2 rotate y*80+rand(R1)*20} translate <2,-1/3,-6>}
object {Small_Tile texture {Wooden2 rotate y*80+rand(R1)*20} translate <10,-1/3,10>}
object {Small_Tile texture {Wooden2 rotate y*80+rand(R1)*20} translate <-2,-1/3,6>}
object {Big_Tile texture {Wooden1 rotate y*-10+rand(R1)*20} translate <-8,-1/3,4>}
object {Big_Tile texture {Wooden1 rotate y*-10+rand(R1)*20} translate <8,-1/3,-4>}
object {Big_Tile texture {Wooden1 rotate y*-10+rand(R1)*20} translate <-4,-1/3,-8>}
object {Big_Tile texture {Wooden1 rotate y*-10+rand(R1)*20} translate <4,-1/3,8>}
}

#if (Floor_On=on)
object {Tile_Pattern translate y*-.1}
object {Tile_Pattern translate <20,-.1,0>}
object {Tile_Pattern translate <-20,-.1,0>}
object {Tile_Pattern translate <0,-.1,20>}
object {Tile_Pattern translate <0,-.1,-20>}
object {Tile_Pattern translate <20,-.1,20>}
object {Tile_Pattern translate <-20,-.1,20>}
object {Tile_Pattern translate <20,-.1,-20>}
object {Tile_Pattern translate <-20,-.1,-20>}
object {Tile_Pattern translate <-40,-.1,20>}
object {Tile_Pattern translate <-40,-.1,40>}
object {Tile_Pattern translate <-20,-.1,40>}
object {Tile_Pattern translate <0,-.1,40>}
object {Tile_Pattern translate <20,-.1,40>}
object {Tile_Pattern translate <40,.1,40>}
object {Tile_Pattern translate <-60,-.1,40>}
object {Tile_Pattern translate <-40,-.1,60>}
object {Tile_Pattern translate <-20,-.1,60>}
object {Tile_Pattern translate <0,-.1,60>}
object {Tile_Pattern translate <20,-.1,60>}
object {Tile_Pattern translate <40,-.1,60>}
object {Tile_Pattern translate <-60,-.1,60>}
object {Tile_Pattern translate <-40,-.1,80>}
object {Tile_Pattern translate <-20,-.1,80>}
object {Tile_Pattern translate <0,-.1,80>}
object {Tile_Pattern translate <20,-.1,80>}
object {Tile_Pattern translate <40,-.1,80>}
object {Tile_Pattern translate <-60,-.1,80>}
object {Tile_Pattern translate <-80,-.1,80>}
object {Tile_Pattern translate <-40,-.1,100>}
object {Tile_Pattern translate <-20,-.1,100>}
object {Tile_Pattern translate <0,-.1,100>}
object {Tile_Pattern translate <20,-.1,100>}
object {Tile_Pattern translate <40,-.1,100>}
object {Tile_Pattern translate <-60,-.1,100>}
object {Tile_Pattern translate <-80,-.1,100>}
#end
#if (Spheres_On=on)
object {Stand scale .5 translate <1,-1/3,7>}
sphere {<1,1.25-1/3+sqrt(7.1875),7>,3.5
  texture {T_Glass3
    normal {bumps .0025}
    finish {caustics 1}
  }
}
sphere {<-5,1.5,5>,1.5+1/3
  texture {T_Silver_2B
    normal {bumps .0025}
  }
}
sphere {<7,2,4>,2+1/3
  texture {T_Copper_4C
    normal {bumps .0025}
  }
}
#end
#if (Watch_On=on)
  object {Watch scale 2.5 rotate y*-35 translate <4.5,-1/3,-5>}
#end
#if (Deck_On=on)
  object {Deck scale <1,2,1> rotate y*-40 translate <-6,-1/3,-3.25>}
  //object {Aces rotate y*0 translate <-6,-1/3+1.02,-2.5>}
#end
#if (Clip_On=on)
  object {Clip scale 2 rotate y*25 translate <6.75,-1/3,-1.65>}
  object {Clip scale 2 rotate <4,110,0> translate <6,-1/3+.06,-2.5>}
#end
