#include "colors.inc"         
#include "glass.inc"

#declare galaxy_seed = 271
#include "GALAXY.INC"          

camera {
  location <0, 1, -5>
  look_at <.75, 1, 0>
} 

light_source { <-250, 300, -200> color White jitter }       
light_source { <-200, 100, 30> color White jitter }   

//Planet - thanks to Chris Colefax
union {sphere {0, 1 pigment {wrinkles color_map {[0 rgb <.2, 0, 0>] [1 rgb <.7, .3, .1>]} scale .3}}
      difference {cylinder {-y, y, 1 scale <1.6, .03, 1.6>} cylinder {-y, y, 1 scale <1.2, .1, 1.2>}
         pigment {onion pigment_map {
            [.8 granite color_map {[.1 rgb <.5, .5, .6>] [.3 rgbt <.5, .5, .6, 1>]} scale .1] [.9 granite color_map {[.3 rgb <.4, .4, .4>] [.5 rgbt <.4, .4, .4, 1>]} scale .07]
            [.93 granite color_map {[0 rgb <.6, .5, .3>] [.2 rgbt <.6, .5, .3, 1>]} scale .2] [1 granite color_map {[.1 rgb <.5, .5, .6>] [.3 rgbt <.5, .5, .6, 1>]} scale .1]}
            scale 1.6}
         rotate <10, 0, 0> no_shadow}
      scale 60 translate <250, 100, 500>}

//Ground with ice
plane { y,0
   pigment { image_map { tga "Snow.tga" } turbulence .5 }
   }        

union { //Bottle plus paper
    merge { // Bottle
        difference { // Body
            cylinder { <0,-1,0> <0,2,0>, 1 }
            cylinder { <0,-.99,0> <0,3,0>, .99}
        }
        difference { // Hemisphere on top
            sphere { <0,2,0>, 1}
            sphere { <0,2,0>, .99}  
            cylinder { <0,1,0> <0,1.99,0>, 1 }
        }
        difference { // Neck
            cylinder { <0,2,0> <0,3.6,0>, .25 }
            cylinder { <0,2,0> <0,3.6,0>, .24}
            sphere { <0,2,0>, 1}
        }
        texture{ T_Winebottle_Glass }      
    }   
    difference { // Paper
        cylinder { <0,.36, 0> <0,4.5,0>, .15 }
        cylinder { <0,.36, 0> <0,5,0>, .1 }   
        pigment { color White }           
    }            
    rotate 70*z 
    translate <2.5,-.2,3>
}