// A futiristic car
// 1995 Christian Perle <christian.perle@tu-clausthal.de>
// POV version: 2.0 or higher
// Copying policy: LGPL (see file COPYING)

#include "colors.inc"

/*camera {
  location <2, 3, -4>*2
  direction <0, 0, 2>
  look_at <0, 0, 0>
}

light_source { <-4, 10, -30> color White }
light_source { <1, 50, 1> color Gray75 }
*/

#declare Tyre = difference {
  cylinder { <0, 0, 0>, <1, 0, 0>, 1.4 }
  cone {
    <.5, 0, 0>, 1
    <1.1, 0, 0>, 1.3
  }
}

#declare Car = union {
  difference {
    box { <-1, 0, -2>, <1, 1, 2> }
    cylinder { <-1.1, 5.2, -1.5>, <1.1, 5.2, -1.5>, 5 }
    pigment {
      granite
      color_map {
        [0 color Green]
        [1 color rgb<0, .5, .2>]
      }
    }
  }
  union {  // tyres
    object { Tyre scale .4 translate <1, 0, -.9> }
    object { Tyre scale .4 translate <1, 0, .9> }
    object { Tyre scale .4 rotate 180*y translate <-1, 0, -.9> }
    object { Tyre scale .4 rotate 180*y translate <-1, 0, .9> }
    pigment { Gray30 }
    finish { phong 1 phong_size 10 }
  }
  sphere {  // windshield
    <0, 0, 0>, 1
    scale <.8, .2, 1.2>
    rotate -20*x
    translate 0.5*y
    pigment { color blue .1 }
    finish { phong 1 reflection .2 }
  }
  union {  // front lights
    box { <-.95, .05, -2.05>, <-.65, .15, -2> }
    box { <.65, .05, -2.05>, <.95, .15, -2> }
    pigment { Yellow }
    finish { ambient .5 }
  }
  union {  // back lights
    box { <-.95, .2, 2>, <-.8, .8, 2.05> }
    box { <.8, .2, 2>, <.95, .8, 2.05> }
    pigment { Red }
    finish { ambient .5 }
  }
  bounded_by { box { <-1.42, -.58, -2.07>, <1.42, 1.02, 2.07> } }
}

#declare Road = union {
  // road
  box { <-4, -.7, -1e6>, <4, -.58, 1e6> pigment { Gray50 } }
  // marks
  box {
    <-.2, -.7, -1e6>, <.2, -.57, 1e6>
    pigment {
      gradient z
      translate -1000*z
      scale <1, 1, 7>
      color_map {
        [0 0.5 color White color White]
        [0.5 1 color Gray50 color Gray50]
      }
    }
  }
}

/*union {
  object { Car translate -2*x }
  object { Road }
  translate 1.6*x
}*/
