#include "colors.inc"
#include "finish.inc"

#include "car.pov"

global_settings{max_trace_level 5000}

background{rgb .15}

camera{
location<0,3,-2>*1.2
look_at <0,0.6,0>
angle 23
}

light_source{
 <10,10,5>
color White*.7
}

light_source{
 <-100,100,-200>
color White*.5
}

light_source{<.1,2,.1>*10
color White
}

#declare mirror=texture{pigment{rgb 1}
                        finish{Shiny}
                        finish{ambient 0.05 reflection 1 diffuse 0.03} }

#declare para_bottom=
union{

sor{7,
<0,0>,
<0.1,0.01>,<0.2,0.04>,<0.3,0.09>,<0.4,0.16>,<0.5,.25>,<.6,.36>
open
}
disc{
<0,.01,0>,<0,1,0>,.1
}
}

#declare para_top=
sor{7,
<0,0>,
<0.1,0.01>,<0.2,0.04>,<0.3,0.09>,<0.4,0.16>,<0.5,0.25>,<.6,.36>
open
rotate x*180
translate <0,.384,0>
}

#declare clip_cyl=cylinder{<0,0,0>,<0,1,0>,0.438178}

#declare schrift=pigment{image_map{tga "magicbox2.tga" map_type 1 } rotate z*7 rotate y*-50 }

#declare outside_tex=texture{
pigment{schrift rotate 0}
finish{phong .15 phong_size 2.5 diffuse 0.8}
}

#declare para_yscale=.8025;

#declare para_bottom_obj=union{
object{para_bottom scale <1,para_yscale,1> texture{mirror} clipped_by{clip_cyl}}
object{para_bottom scale <1,para_yscale,1> translate <0,-0.001,0> texture{outside_tex} clipped_by{clip_cyl}}
}
#declare para_top_obj=union{
object{para_top scale <1,para_yscale,1> translate <0,0.001,0> texture{outside_tex} clipped_by{clip_cyl}}
object{para_top scale <1,para_yscale,1> texture{mirror} clipped_by{clip_cyl}}
}

//First Magic Box
union{
object{para_bottom_obj}
object{para_top_obj}
object{Car scale .027 translate<.02,0.0275,-.02> rotate y*250 finish{ambient .2}}
translate <-.15,0,0>
}

//Opened Magic Box
#declare OMB_trans=<.7,0,.25>
union{
object{para_bottom_obj translate OMB_trans finish{ambient .4}}
object{para_top_obj translate <0,-.384,0> rotate x*180 rotate z*22 rotate y*70 translate OMB_trans+<-.2,0,.52>}
object{Car scale .027 translate<.02,0.0275,-.02> rotate y*150//y*250 
                 finish{ambient .2} translate OMB_trans}
rotate y*-25
}

#include "pencil.inc"

//Third Magic Box
union{
object{para_bottom_obj }
object{para_top_obj rotate y*-110}
object{Car scale .027 translate<.04,0.0275,-.02> rotate y*280 finish{ambient .2}}
object{pencil scale .071 rotate x*-90 translate<0,.3,0.2> rotate y*180}
translate<-.25,0,1>
rotate y*-35
}

//Room
box{<-9,-9,-9>,<10,10,10> pigment{rgb .5} normal{bumps .2 scale .0051} inverse no_shadow finish{diffuse .6}
}

//Table
#include "table.inc"
object{BUEROTISCH2 scale 0.01 translate <0,-8,0> scale .25 rotate y*-20 translate <.5,0,.8> 
}

