// Persistence of Vision Ray Tracer Scene Description File
// File: mg_olymp.pov
// Vers: 3.1
// Desc: Olympus  
// Date: February 25 1999
// Auth: Marjorie Graterol 



#version 3.1;

#include "colors.inc" 
#include "textures.inc"
#include "finish.inc"
#include "emecolor.inc" //custom colors 
global_settings {  assumed_gamma 1.8  }

// ---------------------------------------- 

camera {
 
  location <-10, 1, -50> 
  look_at <-58, 29, 40> 
  
}

//overall light -iluminacion general
light_source{<-35,45,-3 > NewTan media_attenuation off} 
light_source {4*z color Tan media_attenuation on}
light_source {5*y color DarkTan media_attenuation off}

//
  

// background
#declare olym_p = color_map { 
 [0.1 color agua2 ]
 [0.70 color agua]
 [1.0 color Gray90]
}

#declare olym_t = texture {
   pigment{
      bozo
      turbulence 0.6
      octaves 3
      lambda 6
      color_map { olym_p }
   }
   finish { ambient 1 diffuse 0 }
   scale 0.33
}

sphere {
   <0, 0, 0>, 1
   texture { olym_t }
   scale <1000, 100, 1000>
   hollow
} 


//First plane Water  --Primer plano -horizontal-Agua
plane { y, -1.4 
 
texture {
           pigment {agua transmit .5}
           normal {waves 0.5 frequency 2  phase 0.2  turbulence 0.3  scale 3.5  rotate 72*y}

           finish {phong .8  ambient 0.2   diffuse 0.2  
           metallic}
           
           } 
hollow 
interior{ior 1.33 fade_power 1.55}
}


//Second plane (under water) --segundo plano - debajo del agua  
plane { y, -1.60 
texture {
     pigment{Gold} 
     normal {wrinkles 0.6 scale 2}
     finish{phong 0.6}
     }
     hollow 
} 

 

// Acropolis(kind of) --Acropolis (quasi)

height_field 
{
  gif               
  "oly3.gif"     
texture   {
     pigment
          { image_map { gif "oly3_map.gif" map_type 0 interpolate 2 once }
      rotate x*90 } 
      normal{
      bumps 0.7 
      frequency 3
      turbulence .5

      normal_map {
        [0.00 granite]
        [0.25 spotted turbulence .5]
        [0.50 marble turbulence .5]
        [0.75 bozo turbulence .5]
        [1.00 granite]
      }
      }
    
  }
 smooth 
 scale <150,50,-200>   //<75,20,-75>
 rotate <0,25,0>
 translate <-90,-2,212 >  //85
}
 


//Hades light_source ---Iluminacion Hades
light_source{<-150,45,500 > Turquoise*2 media_attenuation on}//DarkOrchid}



// Hades --Hades

height_field 
{
  gif               
  "oly6.gif" 
    
texture   {
     pigment { Gray30 } 
     normal{   bumps 0.7 
               frequency 3
               turbulence .5

               normal_map {
               [0.00 granite]
               [0.25 spotted turbulence .5]
               [0.50 marble turbulence .5]
               [0.75 bozo turbulence .5]
               [1.00 granite]      }
      }
    
  }
 smooth
 scale <300,600,400>   //<75,20,-75>
 
 translate <-650,-2,250 >  //85
}


//Theater -teatro

 height_field  
{
  gif               
  "oly4.gif"     
     texture {PinkAlabaster}
     water_level 0
 smooth
 scale <16,140,16>   
 rotate <0,-60,0>
 translate <-54,-1,-2>  
 
 
}




//Upper disc, Olympus floor --disco superior, piso del Olimpo 

disc
{
  <-25, 50,1>  
  y,         
  480.0,       
  35   
  texture{
  pigment{
      bozo
      turbulence 0.6
      octaves 2
      lambda 6
      scale 75
      color_map { 
        [0.0 color rgbf <1, 1, 1, 1>]
        [0.5 color rgbf <1, 1, 1, .35>]
        [1.0 color rgbf <1, 1, 1, 1>]       }
      }
      
  normal {bumps 0.6 scale 3}
  finish {ambient 1 diffuse 0 
  
  }}
      hollow
  interior{ior 1.000292 } 
}
 
 
//Temples over Acropolis ---Templos sobre la acropolis 
#include "olympus2.inc" 


object {templo1
scale 15
translate <-29,11.10,28>
}  

object {templo1
scale <18,16,18>
translate <-29.7,17.7,49>
} 

//temples over disc--templos encima del disco

//Zeus
object{templo1 
texture {Lightening1}
scale <80,60,80>//<60,25,60> 
translate <-90,70,70>} 


//Apollo -Apolo
object {templo1
texture {Lightening1}
scale <60,40,60>
translate <-20,70,220>
}
  
//Demeter temple

object {templo1 
texture {Lightening1}
scale <60,40,60>
translate <-200,70,120>
}


//escaleras

#include "olympus.inc" //uses spiral.inc (see mg_olymp.txt)
//stairs --escaleras

object{stairs translate <-60,-10,-30>}
object{stairs translate <-200,-10,120>} //
object{stairs translate <-22,-10,220>}
object{stairs translate <-90,0,70>}


//ship spotlight
 
light_source
{ 
  <-12.01, 40, -35>                   
  color NewTan*3
  spotlight
  point_at <-12.5,-0.55,-35>      
  radius 5               
  tightness 35            
  falloff 10               
}

//ship remnant
#include "olympus3.inc"

object {ship
scale <1.50,1.25,1>
rotate <0,140,0> 
translate <-12,-0.55,-35>}

//Delphi Oracle --Orculo de Delfos

union{
object {tripod1  scale 9 }

sphere {<0,0,0> 8  interior {ior 1.000292}} 
texture{
pigment{LightSteelBlue}
normal{ bozo 0.6 turbulence .45}
finish {Mirror}
}
//texture {Glass} 
translate <-20,65,100>
}

light_source{<-20,100,100> Tan media_attenuation on}


#include "olympus4.inc" 

//Columnas
object {oly_set scale 5 translate <-20,70,100>
texture {PinkAlabaster}} 

#declare via=
union{
torus
{  75,  0.75}
torus{  50,  0.75}
  texture {Gold_Nugget}
}
 
object {via translate <-219,65,35>}
object {via translate <-10,65,225>} 


object {hesperide  translate <-26.5,-1,-38>}
object {hesperide  rotate 30*y translate <-25,-1.20,-41>}

#include "olympus5.inc"

 
//debajo de las escaleras
 
object {pote 
//interior {  // describes inside of a shape (similar to texture, but for inside, not surface)
  //fade_power 1.5 }
//rotate 10*z
scale <1.50,2.10,1.50>
translate <-29,0,-36>

}                    

object {tapestry  
//rotate 15*z  
translate <-11.25,-1.75,-36>}

object {tapestry  
rotate 90*z  
translate <-11.25,-2,-36>}
