 //File olympus3.inc
 //used by mg_olymp.pov


//CSG and macro  
// by Chris Young
// MACRO1.POV by Chris Young  POV files 
//Tripod--tripode 
 #declare tripod=
#macro Make_Many (Stuff,How_Many,Axis)
  #local Count=0;   // this identifier is local and 
                    // temporary to this macro
  #while (Count<How_Many)
    object{Stuff rotate Axis*Count*(360/How_Many)}
    #local Count=Count+1;
  #end
#end

#declare Thing = torus
{
  0.8,
  0.1 
  clipped_by { sphere { <0,0,0>, 1.0 }  translate <0,0,-0.55>}
}

union {
  Make_Many (Thing,3,z)  // Make 6 things rotated about z
  //pigment{Blue}
}
#declare tripod1=
object {tripod rotate 180*y rotate 90*x}


//Ship
//Object modeled in sPatch
// Object converted to POVRay V3.0 by Crossroads 3D
#declare _X1_X2_G0 = texture{
  pigment {
    wood
    color_map {
      
      [0.5 DarkWood]
      [0.6 Gold]
    }
  }
finish {
    specular 0.3
    roughness 0.15
  }  
   normal {
    wrinkles 1 scale 0.5
  }
}   


// This object has the following minimum and maximum values:
// xmin=-2.171617, xmax=1.609150
// ymin=-2.264665, ymax=1.959021
// zmin=-0.940210, zmax=0.841917
#declare ship=
object {
  // _X1_X2_G0
  mesh {
    triangle {
      <-1.560130, -1.294494, -0.661707>,
      <-1.877609, -1.584069, -0.570540>,
      < -2.102610, -1.094660, -0.427357>
    }
    triangle {
      <-2.102610, -1.094660, -0.427357>,
      <-1.920810, -0.847203, -0.476505>,
      < -1.560130, -1.294494, -0.661707>
    }
    triangle {
      <-1.186073, -1.019873, -0.760481>,
      <-1.560130, -1.294494, -0.661707>,
      < -1.920810, -0.847203, -0.476505>
    }
    triangle {
      <-1.920810, -0.847203, -0.476505>,
      <-1.618952, -0.650136, -0.566840>,
      < -1.186073, -1.019873, -0.760481>
    }
    triangle {
      <-1.132618, -1.703653, -0.715099>,
      <-1.507837, -1.989794, -0.619418>,
      < -1.877609, -1.584069, -0.570540>
    }
    triangle {
      <-1.877609, -1.584069, -0.570540>,
      <-1.560130, -1.294494, -0.661707>,
      < -1.132618, -1.703653, -0.715099>
    }
    triangle {
      <-0.764600, -1.396952, -0.784656>,
      <-1.132618, -1.703653, -0.715099>,
      < -1.560130, -1.294494, -0.661707>
    }
    triangle {
      <-1.560130, -1.294494, -0.661707>,
      <-1.186073, -1.019873, -0.760481>,
      < -0.764600, -1.396952, -0.784656>
    }
    triangle {
      <-0.985682, -0.823913, -0.843653>,
      <-0.786053, -0.626320, -0.906872>,
      < -0.332512, -0.963240, -0.936093>
    }
    triangle {
      <-0.332512, -0.963240, -0.936093>,
      <-0.540287, -1.189926, -0.874575>,
      < -0.985682, -0.823913, -0.843653>
    }
    triangle {
      <-1.186073, -1.019873, -0.760481>,
      <-0.985682, -0.823913, -0.843653>,
      < -0.540287, -1.189926, -0.874575>
    }
    triangle {
      <-0.540287, -1.189926, -0.874575>,
      <-0.764600, -1.396952, -0.784656>,
      < -1.186073, -1.019873, -0.760481>
    }
    triangle {
      <-1.451256, -0.475744, -0.640029>,
      <-1.268320, -0.317889, -0.701849>,
      < -0.786053, -0.626320, -0.906872>
    }
    triangle {
      <-0.786053, -0.626320, -0.906872>,
      <-0.985682, -0.823913, -0.843653>,
      < -1.451256, -0.475744, -0.640029>
    }
    triangle {
      <-1.618952, -0.650136, -0.566840>,
      <-1.451256, -0.475744, -0.640029>,
      < -0.985682, -0.823913, -0.843653>
    }
    triangle {
      <-0.985682, -0.823913, -0.843653>,
      <-1.186073, -1.019873, -0.760481>,
      < -1.618952, -0.650136, -0.566840>
    }
    triangle {
      <-0.332792, -0.260654, -0.918326>,
      <-0.009317, -0.519797, -0.902383>,
      < -0.332512, -0.963240, -0.936093>
    }
    triangle {
      <-0.332512, -0.963240, -0.936093>,
      <-0.786053, -0.626320, -0.906872>,
      < -0.332792, -0.260654, -0.918326>
    }
    triangle {
      <-0.671675, -0.014059, -0.813275>,
      <-0.332792, -0.260654, -0.918326>,
      < -0.786053, -0.626320, -0.906872>
    }
    triangle {
      <-0.786053, -0.626320, -0.906872>,
      <-1.268320, -0.317889, -0.701849>,
      < -0.671675, -0.014059, -0.813275>
    }
    triangle {
      <0.102530, 0.104503, -0.828532>,
      <0.284641, -0.075176, -0.781927>,
      < -0.009317, -0.519797, -0.902383>
    }
    triangle {
      <-0.009317, -0.519797, -0.902383>,
      <-0.332792, -0.260654, -0.918326>,
      < 0.102530, 0.104503, -0.828532>
    }
    triangle {
      <-0.081797, 0.287668, -0.809113>,
      <0.102530, 0.104503, -0.828532>,
      < -0.332792, -0.260654, -0.918326>
    }
    triangle {
      <-0.332792, -0.260654, -0.918326>,
      <-0.671675, -0.014059, -0.813275>,
      < -0.081797, 0.287668, -0.809113>
    }
    triangle {
      <0.166102, -0.741050, -0.654992>,
      <-0.149226, -1.243524, -0.563359>,
      < -0.332512, -0.963240, -0.936093>
    }
    triangle {
      <-0.332512, -0.963240, -0.936093>,
      <-0.009317, -0.519797, -0.902383>,
      < 0.166102, -0.741050, -0.654992>
    }
    triangle {
      <0.442538, -0.217987, -0.656958>,
      <0.166102, -0.741050, -0.654992>,
      < -0.009317, -0.519797, -0.902383>
    }
    triangle {
      <-0.009317, -0.519797, -0.902383>,
      <0.284641, -0.075176, -0.781927>,
      < 0.442538, -0.217987, -0.656958>
    }
    triangle {
      <0.270595, -0.920768, -0.319226>,
      <-0.080267, -1.467969, -0.065890>,
      < -0.149226, -1.243524, -0.563359>
    }
    triangle {
      <-0.149226, -1.243524, -0.563359>,
      <0.166102, -0.741050, -0.654992>,
      < 0.270595, -0.920768, -0.319226>
    }
    triangle {
      <0.572752, -0.333101, -0.480521>,
      <0.270595, -0.920768, -0.319226>,
      < 0.166102, -0.741050, -0.654992>
    }
    triangle {
      <0.166102, -0.741050, -0.654992>,
      <0.442538, -0.217987, -0.656958>,
      < 0.572752, -0.333101, -0.480521>
    }
    triangle {
      <-0.341720, -1.448967, -0.502861>,
      <-0.540287, -1.189926, -0.874575>,
      < -0.332512, -0.963240, -0.936093>
    }
    triangle {
      <-0.332512, -0.963240, -0.936093>,
      <-0.149226, -1.243524, -0.563359>,
      < -0.341720, -1.448967, -0.502861>
    }
    triangle {
      <-0.245142, -1.645870, -0.007181>,
      <-0.341720, -1.448967, -0.502861>,
      < -0.149226, -1.243524, -0.563359>
    }
    triangle {
      <-0.149226, -1.243524, -0.563359>,
      <-0.080267, -1.467969, -0.065890>,
      < -0.245142, -1.645870, -0.007181>
    }
    triangle {
      <-0.551574, -1.638074, -0.431721>,
      <-0.764600, -1.396952, -0.784656>,
      < -0.540287, -1.189926, -0.874575>
    }
    triangle {
      <-0.540287, -1.189926, -0.874575>,
      <-0.341720, -1.448967, -0.502861>,
      < -0.551574, -1.638074, -0.431721>
    }
    triangle {
      <-0.428389, -1.810772, 0.044177>,
      <-0.551574, -1.638074, -0.431721>,
      < -0.341720, -1.448967, -0.502861>
    }
    triangle {
      <-0.341720, -1.448967, -0.502861>,
      <-0.245142, -1.645870, -0.007181>,
      < -0.428389, -1.810772, 0.044177>
    }
    triangle {
      <-0.881248, -1.954968, -0.312443>,
      <-1.132618, -1.703653, -0.715099>,
      < -0.764600, -1.396952, -0.784656>
    }
    triangle {
      <-0.764600, -1.396952, -0.784656>,
      <-0.551574, -1.638074, -0.431721>,
      < -0.881248, -1.954968, -0.312443>
    }
    triangle {
      <-0.654699, -2.078486, 0.172014>,
      <-0.881248, -1.954968, -0.312443>,
      < -0.551574, -1.638074, -0.431721>
    }
    triangle {
      <-0.551574, -1.638074, -0.431721>,
      <-0.428389, -1.810772, 0.044177>,
      < -0.654699, -2.078486, 0.172014>
    }
    triangle {
      <-1.225334, -2.220886, -0.235821>,
      <-1.507837, -1.989794, -0.619418>,
      < -1.132618, -1.703653, -0.715099>
    }
    triangle {
      <-1.132618, -1.703653, -0.715099>,
      <-0.881248, -1.954968, -0.312443>,
      < -1.225334, -2.220886, -0.235821>
    }
    triangle {
      <-0.902436, -2.264665, 0.188593>,
      <-1.225334, -2.220886, -0.235821>,
      < -0.881248, -1.954968, -0.312443>
    }
    triangle {
      <-0.881248, -1.954968, -0.312443>,
      <-0.654699, -2.078486, 0.172014>,
      < -0.902436, -2.264665, 0.188593>
    }
    triangle {
      <0.463688, 0.227807, -0.600214>,
      <0.442538, -0.217987, -0.656958>,
      < 0.284641, -0.075176, -0.781927>
    }
    triangle {
      <0.284641, -0.075176, -0.781927>,
      <0.102530, 0.104503, -0.828532>,
      < 0.463688, 0.227807, -0.600214>
    }
    triangle {
      <0.462415, 0.674230, -0.461476>,
      <0.463688, 0.227807, -0.600214>,
      < 0.102530, 0.104503, -0.828532>
    }
    triangle {
      <0.102530, 0.104503, -0.828532>,
      <-0.081797, 0.287668, -0.809113>,
      < 0.462415, 0.674230, -0.461476>
    }
    triangle {
      <0.787708, 0.364887, -0.300328>,
      <0.572752, -0.333101, -0.480521>,
      < 0.442538, -0.217987, -0.656958>
    }
    triangle {
      <0.442538, -0.217987, -0.656958>,
      <0.463688, 0.227807, -0.600214>,
      < 0.787708, 0.364887, -0.300328>
    }
    triangle {
      <0.959930, 1.060788, -0.022568>,
      <0.787708, 0.364887, -0.300328>,
      < 0.463688, 0.227807, -0.600214>
    }
    triangle {
      <0.463688, 0.227807, -0.600214>,
      <0.462415, 0.674230, -0.461476>,
      < 0.959930, 1.060788, -0.022568>
    }
    triangle {
      <0.401145, 0.368902, -0.641143>,
      <0.641424, 0.503911, -0.438883>,
      < 0.284641, -0.075176, -0.781927>
    }
    triangle {
      <0.102530, 0.104503, -0.828532>,
      <0.401145, 0.368902, -0.641143>,
      < 0.284641, -0.075176, -0.781927>
    }
    triangle {
      <0.462415, 0.674230, -0.461476>,
      <0.959930, 1.060788, -0.022568>,
      < 0.641424, 0.503911, -0.438883>
    }
    triangle {
      <0.641424, 0.503911, -0.438883>,
      <0.401145, 0.368902, -0.641143>,
      < 0.462415, 0.674230, -0.461476>
    }
    triangle {
      <-0.081797, 0.287668, -0.809113>,
      <0.462415, 0.674230, -0.461476>,
      < 0.401145, 0.368902, -0.641143>
    }
    triangle {
      <0.401145, 0.368902, -0.641143>,
      <0.102530, 0.104503, -0.828532>,
      < -0.081797, 0.287668, -0.809113>
    }
    triangle {
      <0.599106, 0.180756, -0.542357>,
      <0.641424, 0.503911, -0.438883>,
      < 0.284641, -0.075176, -0.781927>
    }
    triangle {
      <0.442538, -0.217987, -0.656958>,
      <0.599106, 0.180756, -0.542357>,
      < 0.284641, -0.075176, -0.781927>
    }
    triangle {
      <0.787708, 0.364887, -0.300328>,
      <0.959930, 1.060788, -0.022568>,
      < 0.641424, 0.503911, -0.438883>
    }
    triangle {
      <0.641424, 0.503911, -0.438883>,
      <0.599106, 0.180756, -0.542357>,
      < 0.787708, 0.364887, -0.300328>
    }
    triangle {
      <0.572752, -0.333101, -0.480521>,
      <0.787708, 0.364887, -0.300328>,
      < 0.599106, 0.180756, -0.542357>
    }
    triangle {
      <0.599106, 0.180756, -0.542357>,
      <0.442538, -0.217987, -0.656958>,
      < 0.572752, -0.333101, -0.480521>
    }
    triangle {
      <-1.603125, -1.255500, -0.466175>,
      <-1.920556, -1.551809, -0.411085>,
      < -2.145766, -1.062427, -0.267257>
    }
    triangle {
      <-2.145766, -1.062427, -0.267257>,
      <-1.965749, -0.810185, -0.311958>,
      < -1.603125, -1.255500, -0.466175>
    }
    triangle {
      <-1.226143, -0.986757, -0.563258>,
      <-1.603125, -1.255500, -0.466175>,
      < -1.965749, -0.810185, -0.311958>
    }
    triangle {
      <-1.965749, -0.810185, -0.311958>,
      <-1.664991, -0.608372, -0.398960>,
      < -1.226143, -0.986757, -0.563258>
    }
    triangle {
      <-1.178494, -1.658900, -0.520986>,
      <-1.550925, -1.957627, -0.459283>,
      < -1.920556, -1.551809, -0.411085>
    }
    triangle {
      <-1.920556, -1.551809, -0.411085>,
      <-1.603125, -1.255500, -0.466175>,
      < -1.178494, -1.658900, -0.520986>
    }
    triangle {
      <-0.807746, -1.364758, -0.624647>,
      <-1.178494, -1.658900, -0.520986>,
      < -1.603125, -1.255500, -0.466175>
    }
    triangle {
      <-1.603125, -1.255500, -0.466175>,
      <-1.226143, -0.986757, -0.563258>,
      < -0.807746, -1.364758, -0.624647>
    }
    triangle {
      <0.107337, -0.692982, -0.472957>,
      <-0.207925, -1.192300, -0.387343>,
      < -0.375527, -0.931009, -0.775979>
    }
    triangle {
      <-0.375527, -0.931009, -0.775979>,
      <-0.052390, -0.487539, -0.742395>,
      < 0.107337, -0.692982, -0.472957>
    }
    triangle {
      <0.383723, -0.172984, -0.469051>,
      <0.107337, -0.692982, -0.472957>,
      < -0.052390, -0.487539, -0.742395>
    }
    triangle {
      <-0.052390, -0.487539, -0.742395>,
      <0.241553, -0.043009, -0.621792>,
      < 0.383723, -0.172984, -0.469051>
    }
    triangle {
      <0.227512, -0.888471, -0.159147>,
      <-0.123356, -1.435802, 0.094245>,
      < -0.207925, -1.192300, -0.387343>
    }
    triangle {
      <-0.207925, -1.192300, -0.387343>,
      <0.107337, -0.692982, -0.472957>,
      < 0.227512, -0.888471, -0.159147>
    }
    triangle {
      <0.529596, -0.300868, -0.320421>,
      <0.227512, -0.888471, -0.159147>,
      < 0.107337, -0.692982, -0.472957>
    }
    triangle {
      <0.107337, -0.692982, -0.472957>,
      <0.383723, -0.172984, -0.469051>,
      < 0.529596, -0.300868, -0.320421>
    }
    triangle {
      <-0.401484, -1.398870, -0.326911>,
      <-0.583433, -1.157733, -0.714567>,
      < -0.375527, -0.931009, -0.775979>
    }
    triangle {
      <-0.375527, -0.931009, -0.775979>,
      <-0.207925, -1.192300, -0.387343>,
      < -0.401484, -1.398870, -0.326911>
    }
    triangle {
      <-0.288298, -1.613637, 0.152919>,
      <-0.401484, -1.398870, -0.326911>,
      < -0.207925, -1.192300, -0.387343>
    }
    triangle {
      <-0.207925, -1.192300, -0.387343>,
      <-0.123356, -1.435802, 0.094245>,
      < -0.288298, -1.613637, 0.152919>
    }
    triangle {
      <-0.612461, -1.589078, -0.255963>,
      <-0.807746, -1.364758, -0.624647>,
      < -0.583433, -1.157733, -0.714567>
    }
    triangle {
      <-0.583433, -1.157733, -0.714567>,
      <-0.401484, -1.398870, -0.326911>,
      < -0.612461, -1.589078, -0.255963>
    }
    triangle {
      <-0.471478, -1.778605, 0.204312>,
      <-0.612461, -1.589078, -0.255963>,
      < -0.401484, -1.398870, -0.326911>
    }
    triangle {
      <-0.401484, -1.398870, -0.326911>,
      <-0.288298, -1.613637, 0.152919>,
      < -0.471478, -1.778605, 0.204312>
    }
    triangle {
      <-1.024669, -0.792748, -0.648766>,
      <-0.823712, -0.597327, -0.714640>,
      < -0.375527, -0.931009, -0.775979>
    }
    triangle {
      <-0.375527, -0.931009, -0.775979>,
      <-0.583433, -1.157733, -0.714567>,
      < -1.024669, -0.792748, -0.648766>
    }
    triangle {
      <-1.226143, -0.986757, -0.563258>,
      <-1.024669, -0.792748, -0.648766>,
      < -0.583433, -1.157733, -0.714567>
    }
    triangle {
      <-0.583433, -1.157733, -0.714567>,
      <-0.807746, -1.364758, -0.624647>,
      < -1.226143, -0.986757, -0.563258>
    }
    triangle {
      <-1.495883, -0.438544, -0.475745>,
      <-1.311409, -0.285722, -0.541715>,
      < -0.823712, -0.597327, -0.714640>
    }
    triangle {
      <-0.823712, -0.597327, -0.714640>,
      <-1.024669, -0.792748, -0.648766>,
      < -1.495883, -0.438544, -0.475745>
    }
    triangle {
      <-1.664991, -0.608372, -0.398960>,
      <-1.495883, -0.438544, -0.475745>,
      < -1.024669, -0.792748, -0.648766>
    }
    triangle {
      <-1.024669, -0.792748, -0.648766>,
      <-1.226143, -0.986757, -0.563258>,
      < -1.664991, -0.608372, -0.398960>
    }
    triangle {
      <-0.374463, -0.230018, -0.725012>,
      <-0.052390, -0.487539, -0.742395>,
      < -0.375527, -0.931009, -0.775979>
    }
    triangle {
      <-0.375527, -0.931009, -0.775979>,
      <-0.823712, -0.597327, -0.714640>,
      < -0.374463, -0.230018, -0.725012>
    }
    triangle {
      <-0.714344, 0.017431, -0.653794>,
      <-0.374463, -0.230018, -0.725012>,
      < -0.823712, -0.597327, -0.714640>
    }
    triangle {
      <-0.823712, -0.597327, -0.714640>,
      <-1.311409, -0.285722, -0.541715>,
      < -0.714344, 0.017431, -0.653794>
    }
    triangle {
      <0.056360, 0.137525, -0.633518>,
      <0.241553, -0.043009, -0.621792>,
      < -0.052390, -0.487539, -0.742395>
    }
    triangle {
      <-0.052390, -0.487539, -0.742395>,
      <-0.374463, -0.230018, -0.725012>,
      < 0.056360, 0.137525, -0.633518>
    }
    triangle {
      <-0.124953, 0.319900, -0.649014>,
      <0.056360, 0.137525, -0.633518>,
      < -0.374463, -0.230018, -0.725012>
    }
    triangle {
      <-0.374463, -0.230018, -0.725012>,
      <-0.714344, 0.017431, -0.653794>,
      < -0.124953, 0.319900, -0.649014>
    }
    triangle {
      <-0.934630, -1.908094, -0.127508>,
      <-1.178494, -1.658900, -0.520986>,
      < -0.807746, -1.364758, -0.624647>
    }
    triangle {
      <-0.807746, -1.364758, -0.624647>,
      <-0.612461, -1.589078, -0.255963>,
      < -0.934630, -1.908094, -0.127508>
    }
    triangle {
      <-0.697779, -2.046358, 0.332057>,
      <-0.934630, -1.908094, -0.127508>,
      < -0.612461, -1.589078, -0.255963>
    }
    triangle {
      <-0.612461, -1.589078, -0.255963>,
      <-0.471478, -1.778605, 0.204312>,
      < -0.697779, -2.046358, 0.332057>
    }
    triangle {
      <-1.268416, -2.188589, -0.075741>,
      <-1.550925, -1.957627, -0.459283>,
      < -1.178494, -1.658900, -0.520986>
    }
    triangle {
      <-1.178494, -1.658900, -0.520986>,
      <-0.934630, -1.908094, -0.127508>,
      < -1.268416, -2.188589, -0.075741>
    }
    triangle {
      <-0.945592, -2.232433, 0.348693>,
      <-1.268416, -2.188589, -0.075741>,
      < -0.934630, -1.908094, -0.127508>
    }
    triangle {
      <-0.934630, -1.908094, -0.127508>,
      <-0.697779, -2.046358, 0.332057>,
      < -0.945592, -2.232433, 0.348693>
    }
    triangle {
      <0.411154, 0.266807, -0.408698>,
      <0.383723, -0.172984, -0.469051>,
      < 0.241553, -0.043009, -0.621792>
    }
    triangle {
      <0.241553, -0.043009, -0.621792>,
      <0.056360, 0.137525, -0.633518>,
      < 0.411154, 0.266807, -0.408698>
    }
    triangle {
      <0.419268, 0.706423, -0.301468>,
      <0.411154, 0.266807, -0.408698>,
      < 0.056360, 0.137525, -0.633518>
    }
    triangle {
      <0.056360, 0.137525, -0.633518>,
      <-0.124953, 0.319900, -0.649014>,
      < 0.419268, 0.706423, -0.301468>
    }
    triangle {
      <0.744561, 0.397080, -0.140320>,
      <0.529596, -0.300868, -0.320421>,
      < 0.383723, -0.172984, -0.469051>
    }
    triangle {
      <0.383723, -0.172984, -0.469051>,
      <0.411154, 0.266807, -0.408698>,
      < 0.744561, 0.397080, -0.140320>
    }
    triangle {
      <0.916857, 1.093046, 0.137420>,
      <0.744561, 0.397080, -0.140320>,
      < 0.411154, 0.266807, -0.408698>
    }
    triangle {
      <0.411154, 0.266807, -0.408698>,
      <0.419268, 0.706423, -0.301468>,
      < 0.916857, 1.093046, 0.137420>
    }
    triangle {
      <0.539101, 0.215950, -0.355107>,
      <0.580287, 0.529270, -0.252164>,
      < 0.241553, -0.043009, -0.621792>
    }
    triangle {
      <0.383723, -0.172984, -0.469051>,
      <0.539101, 0.215950, -0.355107>,
      < 0.241553, -0.043009, -0.621792>
    }
    triangle {
      <0.744561, 0.397080, -0.140320>,
      <0.916857, 1.093046, 0.137420>,
      < 0.580287, 0.529270, -0.252164>
    }
    triangle {
      <0.580287, 0.529270, -0.252164>,
      <0.539101, 0.215950, -0.355107>,
      < 0.744561, 0.397080, -0.140320>
    }
    triangle {
      <0.529596, -0.300868, -0.320421>,
      <0.744561, 0.397080, -0.140320>,
      < 0.539101, 0.215950, -0.355107>
    }
    triangle {
      <0.539101, 0.215950, -0.355107>,
      <0.383723, -0.172984, -0.469051>,
      < 0.529596, -0.300868, -0.320421>
    }
    triangle {
      <0.347494, 0.398158, -0.450304>,
      <0.580287, 0.529270, -0.252164>,
      < 0.241553, -0.043009, -0.621792>
    }
    triangle {
      <0.056360, 0.137525, -0.633518>,
      <0.347494, 0.398158, -0.450304>,
      < 0.241553, -0.043009, -0.621792>
    }
    triangle {
      <0.419268, 0.706423, -0.301468>,
      <0.916857, 1.093046, 0.137420>,
      < 0.580287, 0.529270, -0.252164>
    }
    triangle {
      <0.580287, 0.529270, -0.252164>,
      <0.347494, 0.398158, -0.450304>,
      < 0.419268, 0.706423, -0.301468>
    }
    triangle {
      <-0.124953, 0.319900, -0.649014>,
      <0.419268, 0.706423, -0.301468>,
      < 0.347494, 0.398158, -0.450304>
    }
    triangle {
      <0.347494, 0.398158, -0.450304>,
      <0.056360, 0.137525, -0.633518>,
      < -0.124953, 0.319900, -0.649014>
    }
    triangle {
      <0.436395, 0.717181, -0.373547>,
      <0.955281, 1.105193, 0.076057>,
      < 0.916857, 1.093046, 0.137420>
    }
    triangle {
      <0.916857, 1.093046, 0.137420>,
      <0.419268, 0.706423, -0.301468>,
      < 0.436395, 0.717181, -0.373547>
    }
    triangle {
      <-0.128974, 0.329229, -0.731885>,
      <0.436395, 0.717181, -0.373547>,
      < 0.419268, 0.706423, -0.301468>
    }
    triangle {
      <0.419268, 0.706423, -0.301468>,
      <-0.124953, 0.319900, -0.649014>,
      < -0.128974, 0.329229, -0.731885>
    }
    triangle {
      <0.462415, 0.674230, -0.461476>,
      <0.959930, 1.060788, -0.022568>,
      < 0.955281, 1.105193, 0.076057>
    }
    triangle {
      <0.955281, 1.105193, 0.076057>,
      <0.436395, 0.717181, -0.373547>,
      < 0.462415, 0.674230, -0.461476>
    }
    triangle {
      <-0.081797, 0.287668, -0.809113>,
      <0.462415, 0.674230, -0.461476>,
      < 0.436395, 0.717181, -0.373547>
    }
    triangle {
      <0.436395, 0.717181, -0.373547>,
      <-0.128974, 0.329229, -0.731885>,
      < -0.081797, 0.287668, -0.809113>
    }
    triangle {
      <0.785435, 0.385399, -0.200403>,
      <0.955281, 1.105193, 0.076057>,
      < 0.916857, 1.093046, 0.137420>
    }
    triangle {
      <0.916857, 1.093046, 0.137420>,
      <0.744561, 0.397080, -0.140320>,
      < 0.785435, 0.385399, -0.200403>
    }
    triangle {
      <0.572996, -0.336481, -0.379282>,
      <0.785435, 0.385399, -0.200403>,
      < 0.744561, 0.397080, -0.140320>
    }
    triangle {
      <0.744561, 0.397080, -0.140320>,
      <0.529596, -0.300868, -0.320421>,
      < 0.572996, -0.336481, -0.379282>
    }
    triangle {
      <0.787708, 0.364887, -0.300328>,
      <0.959930, 1.060788, -0.022568>,
      < 0.955281, 1.105193, 0.076057>
    }
    triangle {
      <0.955281, 1.105193, 0.076057>,
      <0.785435, 0.385399, -0.200403>,
      < 0.787708, 0.364887, -0.300328>
    }
    triangle {
      <0.572752, -0.333101, -0.480521>,
      <0.787708, 0.364887, -0.300328>,
      < 0.785435, 0.385399, -0.200403>
    }
    triangle {
      <0.785435, 0.385399, -0.200403>,
      <0.572996, -0.336481, -0.379282>,
      < 0.572752, -0.333101, -0.480521>
    }
    triangle {
      <-0.721056, 0.024829, -0.731320>,
      <-0.128974, 0.329229, -0.731885>,
      < -0.081797, 0.287668, -0.809113>
    }
    triangle {
      <-0.081797, 0.287668, -0.809113>,
      <-0.671675, -0.014059, -0.813275>,
      < -0.721056, 0.024829, -0.731320>
    }
    triangle {
      <-1.320329, -0.280829, -0.614478>,
      <-0.721056, 0.024829, -0.731320>,
      < -0.671675, -0.014059, -0.813275>
    }
    triangle {
      <-0.671675, -0.014059, -0.813275>,
      <-1.268320, -0.317889, -0.701849>,
      < -1.320329, -0.280829, -0.614478>
    }
    triangle {
      <-0.714344, 0.017431, -0.653794>,
      <-0.124953, 0.319900, -0.649014>,
      < -0.128974, 0.329229, -0.731885>
    }
    triangle {
      <-0.128974, 0.329229, -0.731885>,
      <-0.721056, 0.024829, -0.731320>,
      < -0.714344, 0.017431, -0.653794>
    }
    triangle {
      <-1.311409, -0.285722, -0.541715>,
      <-0.714344, 0.017431, -0.653794>,
      < -0.721056, 0.024829, -0.731320>
    }
    triangle {
      <-0.721056, 0.024829, -0.731320>,
      <-1.320329, -0.280829, -0.614478>,
      < -1.311409, -0.285722, -0.541715>
    }
    triangle {
      <-1.503587, -0.433689, -0.550660>,
      <-1.320329, -0.280829, -0.614478>,
      < -1.268320, -0.317889, -0.701849>
    }
    triangle {
      <-1.268320, -0.317889, -0.701849>,
      <-1.451256, -0.475744, -0.640029>,
      < -1.503587, -0.433689, -0.550660>
    }
    triangle {
      <-1.671516, -0.603399, -0.475659>,
      <-1.503587, -0.433689, -0.550660>,
      < -1.451256, -0.475744, -0.640029>
    }
    triangle {
      <-1.451256, -0.475744, -0.640029>,
      <-1.618952, -0.650136, -0.566840>,
      < -1.671516, -0.603399, -0.475659>
    }
    triangle {
      <-1.495883, -0.438544, -0.475745>,
      <-1.311409, -0.285722, -0.541715>,
      < -1.320329, -0.280829, -0.614478>
    }
    triangle {
      <-1.320329, -0.280829, -0.614478>,
      <-1.503587, -0.433689, -0.550660>,
      < -1.495883, -0.438544, -0.475745>
    }
    triangle {
      <-1.664991, -0.608372, -0.398960>,
      <-1.495883, -0.438544, -0.475745>,
      < -1.503587, -0.433689, -0.550660>
    }
    triangle {
      <-1.503587, -0.433689, -0.550660>,
      <-1.671516, -0.603399, -0.475659>,
      < -1.664991, -0.608372, -0.398960>
    }
    triangle {
      <0.264706, -0.923654, -0.212925>,
      <0.270595, -0.920768, -0.319226>,
      < 0.572752, -0.333101, -0.480521>
    }
    triangle {
      <0.572752, -0.333101, -0.480521>,
      <0.572996, -0.336481, -0.379282>,
      < 0.264706, -0.923654, -0.212925>
    }
    triangle {
      <0.227512, -0.888471, -0.159147>,
      <0.264706, -0.923654, -0.212925>,
      < 0.572996, -0.336481, -0.379282>
    }
    triangle {
      <0.572996, -0.336481, -0.379282>,
      <0.529596, -0.300868, -0.320421>,
      < 0.227512, -0.888471, -0.159147>
    }
    triangle {
      <-0.092369, -1.470555, 0.045549>,
      <-0.080267, -1.467969, -0.065890>,
      < 0.270595, -0.920768, -0.319226>
    }
    triangle {
      <0.270595, -0.920768, -0.319226>,
      <0.264706, -0.923654, -0.212925>,
      < -0.092369, -1.470555, 0.045549>
    }
    triangle {
      <-0.123356, -1.435802, 0.094245>,
      <-0.092369, -1.470555, 0.045549>,
      < 0.264706, -0.923654, -0.212925>
    }
    triangle {
      <0.264706, -0.923654, -0.212925>,
      <0.227512, -0.888471, -0.159147>,
      < -0.123356, -1.435802, 0.094245>
    }
    triangle {
      <-0.255386, -1.647176, 0.104230>,
      <-0.245142, -1.645870, -0.007181>,
      < -0.080267, -1.467969, -0.065890>
    }
    triangle {
      <-0.080267, -1.467969, -0.065890>,
      <-0.092369, -1.470555, 0.045549>,
      < -0.255386, -1.647176, 0.104230>
    }
    triangle {
      <-0.288298, -1.613637, 0.152919>,
      <-0.255386, -1.647176, 0.104230>,
      < -0.092369, -1.470555, 0.045549>
    }
    triangle {
      <-0.092369, -1.470555, 0.045549>,
      <-0.123356, -1.435802, 0.094245>,
      < -0.288298, -1.613637, 0.152919>
    }
    triangle {
      <-0.436776, -1.810798, 0.155560>,
      <-0.428389, -1.810772, 0.044177>,
      < -0.245142, -1.645870, -0.007181>
    }
    triangle {
      <-0.245142, -1.645870, -0.007181>,
      <-0.255386, -1.647176, 0.104230>,
      < -0.436776, -1.810798, 0.155560>
    }
    triangle {
      <-0.471478, -1.778605, 0.204312>,
      <-0.436776, -1.810798, 0.155560>,
      < -0.255386, -1.647176, 0.104230>
    }
    triangle {
      <-0.255386, -1.647176, 0.104230>,
      <-0.288298, -1.613637, 0.152919>,
      < -0.471478, -1.778605, 0.204312>
    }
    triangle {
      <-0.669686, -2.070464, 0.267767>,
      <-0.654699, -2.078486, 0.172014>,
      < -0.428389, -1.810772, 0.044177>
    }
    triangle {
      <-0.428389, -1.810772, 0.044177>,
      <-0.436776, -1.810798, 0.155560>,
      < -0.669686, -2.070464, 0.267767>
    }
    triangle {
      <-0.697779, -2.046358, 0.332057>,
      <-0.669686, -2.070464, 0.267767>,
      < -0.436776, -1.810798, 0.155560>
    }
    triangle {
      <-0.436776, -1.810798, 0.155560>,
      <-0.471478, -1.778605, 0.204312>,
      < -0.697779, -2.046358, 0.332057>
    }
    triangle {
      <-0.924080, -2.248568, 0.268590>,
      <-0.902436, -2.264665, 0.188593>,
      < -0.654699, -2.078486, 0.172014>
    }
    triangle {
      <-0.654699, -2.078486, 0.172014>,
      <-0.669686, -2.070464, 0.267767>,
      < -0.924080, -2.248568, 0.268590>
    }
    triangle {
      <-0.945592, -2.232433, 0.348693>,
      <-0.924080, -2.248568, 0.268590>,
      < -0.669686, -2.070464, 0.267767>
    }
    triangle {
      <-0.669686, -2.070464, 0.267767>,
      <-0.697779, -2.046358, 0.332057>,
      < -0.945592, -2.232433, 0.348693>
    }
    triangle {
      <-1.261287, -2.216305, -0.152716>,
      <-1.225334, -2.220886, -0.235821>,
      < -0.902436, -2.264665, 0.188593>
    }
    triangle {
      <-0.902436, -2.264665, 0.188593>,
      <-0.924080, -2.248568, 0.268590>,
      < -1.261287, -2.216305, -0.152716>
    }
    triangle {
      <-1.268416, -2.188589, -0.075741>,
      <-1.261287, -2.216305, -0.152716>,
      < -0.924080, -2.248568, 0.268590>
    }
    triangle {
      <-0.924080, -2.248568, 0.268590>,
      <-0.945592, -2.232433, 0.348693>,
      < -1.268416, -2.188589, -0.075741>
    }
    triangle {
      <-1.558173, -1.996795, -0.533186>,
      <-1.507837, -1.989794, -0.619418>,
      < -1.225334, -2.220886, -0.235821>
    }
    triangle {
      <-1.225334, -2.220886, -0.235821>,
      <-1.261287, -2.216305, -0.152716>,
      < -1.558173, -1.996795, -0.533186>
    }
    triangle {
      <-1.550925, -1.957627, -0.459283>,
      <-1.558173, -1.996795, -0.533186>,
      < -1.261287, -2.216305, -0.152716>
    }
    triangle {
      <-1.261287, -2.216305, -0.152716>,
      <-1.268416, -2.188589, -0.075741>,
      < -1.550925, -1.957627, -0.459283>
    }
    triangle {
      <-0.410719, -1.702937, 0.195737>,
      <-0.094798, -1.441954, 0.239419>,
      < -0.059747, -1.507534, 0.254126>
    }
    triangle {
      <-0.059747, -1.507534, 0.254126>,
      <-0.489731, -1.982649, 0.320789>,
      < -0.410719, -1.702937, 0.195737>
    }
    triangle {
      <-0.713259, -1.848692, 0.046834>,
      <-0.410719, -1.702937, 0.195737>,
      < -0.489731, -1.982649, 0.320789>
    }
    triangle {
      <-0.489731, -1.982649, 0.320789>,
      <-0.914987, -2.185478, 0.168646>,
      < -0.713259, -1.848692, 0.046834>
    }
    triangle {
      <-0.198214, -1.385586, 0.106463>,
      <-0.149733, -1.396121, 0.179269>,
      < -0.094798, -1.441954, 0.239419>
    }
    triangle {
      <-0.094798, -1.441954, 0.239419>,
      <-0.410719, -1.702937, 0.195737>,
      < -0.198214, -1.385586, 0.106463>
    }
    triangle {
      <-0.224687, -1.416934, 0.042257>,
      <-0.198214, -1.385586, 0.106463>,
      < -0.410719, -1.702937, 0.195737>
    }
    triangle {
      <-0.410719, -1.702937, 0.195737>,
      <-0.713259, -1.848692, 0.046834>,
      < -0.224687, -1.416934, 0.042257>
    }
    triangle {
      <-0.379126, -1.757054, 0.209389>,
      <-0.086554, -1.567864, 0.170309>,
      < -0.059747, -1.507534, 0.254126>
    }
    triangle {
      <-0.059747, -1.507534, 0.254126>,
      <-0.094798, -1.441954, 0.239419>,
      < -0.379126, -1.757054, 0.209389>
    }
    triangle {
      <-0.611367, -1.779304, 0.263054>,
      <-0.379126, -1.757054, 0.209389>,
      < -0.094798, -1.441954, 0.239419>
    }
    triangle {
      <-0.094798, -1.441954, 0.239419>,
      <-0.149733, -1.396121, 0.179269>,
      < -0.611367, -1.779304, 0.263054>
    }
    triangle {
      <-0.598891, -2.056028, 0.084480>,
      <-0.142283, -1.572965, 0.075257>,
      < -0.086554, -1.567864, 0.170309>
    }
    triangle {
      <-0.086554, -1.567864, 0.170309>,
      <-0.379126, -1.757054, 0.209389>,
      < -0.598891, -2.056028, 0.084480>
    }
    triangle {
      <-0.914987, -2.185478, 0.168646>,
      <-0.598891, -2.056028, 0.084480>,
      < -0.379126, -1.757054, 0.209389>
    }
    triangle {
      <-0.379126, -1.757054, 0.209389>,
      <-0.611367, -1.779304, 0.263054>,
      < -0.914987, -2.185478, 0.168646>
    }
    triangle {
      <-0.359760, -1.737048, 0.334606>,
      <-0.489731, -1.982649, 0.320789>,
      < -0.059747, -1.507534, 0.254126>
    }
    triangle {
      <-0.094798, -1.441954, 0.239419>,
      <-0.359760, -1.737048, 0.334606>,
      < -0.059747, -1.507534, 0.254126>
    }
    triangle {
      <-0.611367, -1.779304, 0.263054>,
      <-0.914987, -2.185478, 0.168646>,
      < -0.489731, -1.982649, 0.320789>
    }
    triangle {
      <-0.489731, -1.982649, 0.320789>,
      <-0.359760, -1.737048, 0.334606>,
      < -0.611367, -1.779304, 0.263054>
    }
    triangle {
      <-0.149733, -1.396121, 0.179269>,
      <-0.611367, -1.779304, 0.263054>,
      < -0.359760, -1.737048, 0.334606>
    }
    triangle {
      <-0.359760, -1.737048, 0.334606>,
      <-0.094798, -1.441954, 0.239419>,
      < -0.149733, -1.396121, 0.179269>
    }
    triangle {
      <0.264176, -0.864337, -0.039498>,
      <0.290064, -0.898393, 0.016126>,
      < -0.059747, -1.507534, 0.254126>
    }
    triangle {
      <-0.059747, -1.507534, 0.254126>,
      <-0.094798, -1.441954, 0.239419>,
      < 0.264176, -0.864337, -0.039498>
    }
    triangle {
      <0.246264, -0.864429, -0.123924>,
      <0.264176, -0.864337, -0.039498>,
      < -0.094798, -1.441954, 0.239419>
    }
    triangle {
      <-0.094798, -1.441954, 0.239419>,
      <-0.149733, -1.396121, 0.179269>,
      < 0.246264, -0.864429, -0.123924>
    }
    triangle {
      <0.554616, -0.240341, -0.263477>,
      <0.570861, -0.244967, -0.178967>,
      < 0.290064, -0.898393, 0.016126>
    }
    triangle {
      <0.290064, -0.898393, 0.016126>,
      <0.264176, -0.864337, -0.039498>,
      < 0.554616, -0.240341, -0.263477>
    }
    triangle {
      <0.574275, -0.283859, -0.360094>,
      <0.554616, -0.240341, -0.263477>,
      < 0.264176, -0.864337, -0.039498>
    }
    triangle {
      <0.264176, -0.864337, -0.039498>,
      <0.246264, -0.864429, -0.123924>,
      < 0.574275, -0.283859, -0.360094>
    }
    triangle {
      <-0.406621, -1.781866, 0.150602>,
      <-0.489731, -1.982649, 0.320789>,
      < -0.059747, -1.507534, 0.254126>
    }
    triangle {
      <-0.059747, -1.507534, 0.254126>,
      <-0.086554, -1.567864, 0.170309>,
      < -0.406621, -1.781866, 0.150602>
    }
    triangle {
      <-0.194588, -1.505929, 0.033443>,
      <-0.406621, -1.781866, 0.150602>,
      < -0.086554, -1.567864, 0.170309>
    }
    triangle {
      <-0.086554, -1.567864, 0.170309>,
      <-0.142283, -1.572965, 0.075257>,
      < -0.194588, -1.505929, 0.033443>
    }
    triangle {
      <-0.713259, -1.848692, 0.046834>,
      <-0.914987, -2.185478, 0.168646>,
      < -0.489731, -1.982649, 0.320789>
    }
    triangle {
      <-0.489731, -1.982649, 0.320789>,
      <-0.406621, -1.781866, 0.150602>,
      < -0.713259, -1.848692, 0.046834>
    }
    triangle {
      <-0.224687, -1.416934, 0.042257>,
      <-0.713259, -1.848692, 0.046834>,
      < -0.406621, -1.781866, 0.150602>
    }
    triangle {
      <-0.406621, -1.781866, 0.150602>,
      <-0.194588, -1.505929, 0.033443>,
      < -0.224687, -1.416934, 0.042257>
    }
    triangle {
      <0.319739, -0.978085, -0.027532>,
      <0.290064, -0.898393, 0.016126>,
      < -0.059747, -1.507534, 0.254126>
    }
    triangle {
      <-0.059747, -1.507534, 0.254126>,
      <-0.086554, -1.567864, 0.170309>,
      < 0.319739, -0.978085, -0.027532>
    }
    triangle {
      <0.326025, -1.028221, -0.111243>,
      <0.319739, -0.978085, -0.027532>,
      < -0.086554, -1.567864, 0.170309>
    }
    triangle {
      <-0.086554, -1.567864, 0.170309>,
      <-0.142283, -1.572965, 0.075257>,
      < 0.326025, -1.028221, -0.111243>
    }
    triangle {
      <0.648310, -0.334997, -0.178218>,
      <0.570861, -0.244967, -0.178967>,
      < 0.290064, -0.898393, 0.016126>
    }
    triangle {
      <0.290064, -0.898393, 0.016126>,
      <0.319739, -0.978085, -0.027532>,
      < 0.648310, -0.334997, -0.178218>
    }
    triangle {
      <0.707953, -0.421133, -0.246123>,
      <0.648310, -0.334997, -0.178218>,
      < 0.319739, -0.978085, -0.027532>
    }
    triangle {
      <0.319739, -0.978085, -0.027532>,
      <0.326025, -1.028221, -0.111243>,
      < 0.707953, -0.421133, -0.246123>
    }
    triangle {
      <-0.350756, -1.907529, 0.228929>,
      <-0.489731, -1.982649, 0.320789>,
      < -0.059747, -1.507534, 0.254126>
    }
    triangle {
      <-0.086554, -1.567864, 0.170309>,
      <-0.350756, -1.907529, 0.228929>,
      < -0.059747, -1.507534, 0.254126>
    }
    triangle {
      <-0.598891, -2.056028, 0.084480>,
      <-0.914987, -2.185478, 0.168646>,
      < -0.489731, -1.982649, 0.320789>
    }
    triangle {
      <-0.489731, -1.982649, 0.320789>,
      <-0.350756, -1.907529, 0.228929>,
      < -0.598891, -2.056028, 0.084480>
    }
    triangle {
      <-0.142283, -1.572965, 0.075257>,
      <-0.598891, -2.056028, 0.084480>,
      < -0.350756, -1.907529, 0.228929>
    }
    triangle {
      <-0.350756, -1.907529, 0.228929>,
      <-0.086554, -1.567864, 0.170309>,
      < -0.142283, -1.572965, 0.075257>
    }
    triangle {
      <0.763111, 0.427067, -0.078625>,
      <0.795256, 0.395312, -0.027054>,
      < 0.570861, -0.244967, -0.178967>
    }
    triangle {
      <0.570861, -0.244967, -0.178967>,
      <0.554616, -0.240341, -0.263477>,
      < 0.763111, 0.427067, -0.078625>
    }
    triangle {
      <0.746303, 0.429842, -0.161208>,
      <0.763111, 0.427067, -0.078625>,
      < 0.554616, -0.240341, -0.263477>
    }
    triangle {
      <0.554616, -0.240341, -0.263477>,
      <0.574275, -0.283859, -0.360094>,
      < 0.746303, 0.429842, -0.161208>
    }
    triangle {
      <0.973623, 1.073270, 0.217697>,
      <1.023604, 1.018105, 0.222518>,
      < 0.795256, 0.395312, -0.027054>
    }
    triangle {
      <0.795256, 0.395312, -0.027054>,
      <0.763111, 0.427067, -0.078625>,
      < 0.973623, 1.073270, 0.217697>
    }
    triangle {
      <0.918570, 1.118710, 0.162827>,
      <0.973623, 1.073270, 0.217697>,
      < 0.763111, 0.427067, -0.078625>
    }
    triangle {
      <0.763111, 0.427067, -0.078625>,
      <0.746303, 0.429842, -0.161208>,
      < 0.918570, 1.118710, 0.162827>
    }
    triangle {
      <0.843320, 0.330752, -0.074611>,
      <0.795256, 0.395312, -0.027054>,
      < 0.570861, -0.244967, -0.178967>
    }
    triangle {
      <0.570861, -0.244967, -0.178967>,
      <0.648310, -0.334997, -0.178218>,
      < 0.843320, 0.330752, -0.074611>
    }
    triangle {
      <0.862701, 0.290034, -0.158701>,
      <0.843320, 0.330752, -0.074611>,
      < 0.648310, -0.334997, -0.178218>
    }
    triangle {
      <0.648310, -0.334997, -0.178218>,
      <0.707953, -0.421133, -0.246123>,
      < 0.862701, 0.290034, -0.158701>
    }
    triangle {
      <1.029095, 0.983710, 0.131410>,
      <1.023604, 1.018105, 0.222518>,
      < 0.795256, 0.395312, -0.027054>
    }
    triangle {
      <0.795256, 0.395312, -0.027054>,
      <0.843320, 0.330752, -0.074611>,
      < 1.029095, 0.983710, 0.131410>
    }
    triangle {
      <0.994830, 0.992962, 0.035714>,
      <1.029095, 0.983710, 0.131410>,
      < 0.843320, 0.330752, -0.074611>
    }
    triangle {
      <0.843320, 0.330752, -0.074611>,
      <0.862701, 0.290034, -0.158701>,
      < 0.994830, 0.992962, 0.035714>
    }
    triangle {
      <1.149863, 1.433135, 0.300132>,
      <1.439677, 1.553154, 0.541201>,
      < 1.023604, 1.018105, 0.222518>
    }
    triangle {
      <1.023604, 1.018105, 0.222518>,
      <0.973623, 1.073270, 0.217697>,
      < 1.149863, 1.433135, 0.300132>
    }
    triangle {
      <0.883940, 1.135145, 0.089027>,
      <1.149863, 1.433135, 0.300132>,
      < 0.973623, 1.073270, 0.217697>
    }
    triangle {
      <0.973623, 1.073270, 0.217697>,
      <0.918570, 1.118710, 0.162827>,
      < 0.883940, 1.135145, 0.089027>
    }
    triangle {
      <1.218418, 1.711346, 0.245658>,
      <1.609150, 1.959021, 0.582438>,
      < 1.439677, 1.553154, 0.541201>
    }
    triangle {
      <1.439677, 1.553154, 0.541201>,
      <1.149863, 1.433135, 0.300132>,
      < 1.218418, 1.711346, 0.245658>
    }
    triangle {
      <0.880341, 1.117483, 0.018712>,
      <1.218418, 1.711346, 0.245658>,
      < 1.149863, 1.433135, 0.300132>
    }
    triangle {
      <1.149863, 1.433135, 0.300132>,
      <0.883940, 1.135145, 0.089027>,
      < 0.880341, 1.117483, 0.018712>
    }
    triangle {
      <1.223998, 1.457992, 0.464685>,
      <1.439677, 1.553154, 0.541201>,
      < 1.023604, 1.018105, 0.222518>
    }
    triangle {
      <0.973623, 1.073270, 0.217697>,
      <1.223998, 1.457992, 0.464685>,
      < 1.023604, 1.018105, 0.222518>
    }
    triangle {
      <1.263737, 1.734984, 0.505212>,
      <1.609150, 1.959021, 0.582438>,
      < 1.439677, 1.553154, 0.541201>
    }
    triangle {
      <1.439677, 1.553154, 0.541201>,
      <1.223998, 1.457992, 0.464685>,
      < 1.263737, 1.734984, 0.505212>
    }
    triangle {
      <0.918570, 1.118710, 0.162827>,
      <1.263737, 1.734984, 0.505212>,
      < 1.223998, 1.457992, 0.464685>
    }
    triangle {
      <1.223998, 1.457992, 0.464685>,
      <0.973623, 1.073270, 0.217697>,
      < 0.918570, 1.118710, 0.162827>
    }
    triangle {
      <1.199648, 1.379047, 0.306223>,
      <1.029095, 0.983710, 0.131410>,
      < 1.023604, 1.018105, 0.222518>
    }
    triangle {
      <1.023604, 1.018105, 0.222518>,
      <0.973623, 1.073270, 0.217697>,
      < 1.199648, 1.379047, 0.306223>
    }
    triangle {
      <1.263737, 1.734984, 0.505212>,
      <1.199648, 1.379047, 0.306223>,
      < 0.973623, 1.073270, 0.217697>
    }
    triangle {
      <0.973623, 1.073270, 0.217697>,
      <0.918570, 1.118710, 0.162827>,
      < 1.263737, 1.734984, 0.505212>
    }
    triangle {
      <1.406096, 1.510561, 0.259879>,
      <0.994830, 0.992962, 0.035714>,
      < 1.029095, 0.983710, 0.131410>
    }
    triangle {
      <1.029095, 0.983710, 0.131410>,
      <1.199648, 1.379047, 0.306223>,
      < 1.406096, 1.510561, 0.259879>
    }
    triangle {
      <1.609150, 1.959021, 0.582438>,
      <1.406096, 1.510561, 0.259879>,
      < 1.199648, 1.379047, 0.306223>
    }
    triangle {
      <1.199648, 1.379047, 0.306223>,
      <1.263737, 1.734984, 0.505212>,
      < 1.609150, 1.959021, 0.582438>
    }
    triangle {
      <1.184027, 1.377168, 0.244377>,
      <1.439677, 1.553154, 0.541201>,
      < 1.023604, 1.018105, 0.222518>
    }
    triangle {
      <1.023604, 1.018105, 0.222518>,
      <1.029095, 0.983710, 0.131410>,
      < 1.184027, 1.377168, 0.244377>
    }
    triangle {
      <0.934869, 1.049924, 0.000120>,
      <1.184027, 1.377168, 0.244377>,
      < 1.029095, 0.983710, 0.131410>
    }
    triangle {
      <1.029095, 0.983710, 0.131410>,
      <0.994830, 0.992962, 0.035714>,
      < 0.934869, 1.049924, 0.000120>
    }
    triangle {
      <1.218418, 1.711346, 0.245658>,
      <1.609150, 1.959021, 0.582438>,
      < 1.439677, 1.553154, 0.541201>
    }
    triangle {
      <1.439677, 1.553154, 0.541201>,
      <1.184027, 1.377168, 0.244377>,
      < 1.218418, 1.711346, 0.245658>
    }
    triangle {
      <0.880341, 1.117483, 0.018712>,
      <1.218418, 1.711346, 0.245658>,
      < 1.184027, 1.377168, 0.244377>
    }
    triangle {
      <1.184027, 1.377168, 0.244377>,
      <0.934869, 1.049924, 0.000120>,
      < 0.880341, 1.117483, 0.018712>
    }
    triangle {
      <1.309582, 1.322904, 0.321089>,
      <1.439677, 1.553154, 0.541201>,
      < 1.023604, 1.018105, 0.222518>
    }
    triangle {
      <1.029095, 0.983710, 0.131410>,
      <1.309582, 1.322904, 0.321089>,
      < 1.023604, 1.018105, 0.222518>
    }
    triangle {
      <1.406096, 1.510561, 0.259879>,
      <1.609150, 1.959021, 0.582438>,
      < 1.439677, 1.553154, 0.541201>
    }
    triangle {
      <1.439677, 1.553154, 0.541201>,
      <1.309582, 1.322904, 0.321089>,
      < 1.406096, 1.510561, 0.259879>
    }
    triangle {
      <0.994830, 0.992962, 0.035714>,
      <1.406096, 1.510561, 0.259879>,
      < 1.309582, 1.322904, 0.321089>
    }
    triangle {
      <1.309582, 1.322904, 0.321089>,
      <1.029095, 0.983710, 0.131410>,
      < 0.994830, 0.992962, 0.035714>
    }
    triangle {
      <-0.443592, -1.720598, 0.127385>,
      <-0.194588, -1.505929, 0.033443>,
      < -0.142283, -1.572965, 0.075257>
    }
    triangle {
      <-0.142283, -1.572965, 0.075257>,
      <-0.598891, -2.056028, 0.084480>,
      < -0.443592, -1.720598, 0.127385>
    }
    triangle {
      <-0.611367, -1.779304, 0.263054>,
      <-0.443592, -1.720598, 0.127385>,
      < -0.598891, -2.056028, 0.084480>
    }
    triangle {
      <-0.598891, -2.056028, 0.084480>,
      <-0.914987, -2.185478, 0.168646>,
      < -0.611367, -1.779304, 0.263054>
    }
    triangle {
      <-0.198214, -1.385586, 0.106463>,
      <-0.224687, -1.416934, 0.042257>,
      < -0.194588, -1.505929, 0.033443>
    }
    triangle {
      <-0.194588, -1.505929, 0.033443>,
      <-0.443592, -1.720598, 0.127385>,
      < -0.198214, -1.385586, 0.106463>
    }
    triangle {
      <-0.149733, -1.396121, 0.179269>,
      <-0.198214, -1.385586, 0.106463>,
      < -0.443592, -1.720598, 0.127385>
    }
    triangle {
      <-0.443592, -1.720598, 0.127385>,
      <-0.611367, -1.779304, 0.263054>,
      < -0.149733, -1.396121, 0.179269>
    }
    triangle {
      <-0.500654, -1.832575, 0.031085>,
      <-0.598891, -2.056028, 0.084480>,
      < -0.142283, -1.572965, 0.075257>
    }
    triangle {
      <-0.194588, -1.505929, 0.033443>,
      <-0.500654, -1.832575, 0.031085>,
      < -0.142283, -1.572965, 0.075257>
    }
    triangle {
      <-0.713259, -1.848692, 0.046834>,
      <-0.914987, -2.185478, 0.168646>,
      < -0.598891, -2.056028, 0.084480>
    }
    triangle {
      <-0.598891, -2.056028, 0.084480>,
      <-0.500654, -1.832575, 0.031085>,
      < -0.713259, -1.848692, 0.046834>
    }
    triangle {
      <-0.224687, -1.416934, 0.042257>,
      <-0.713259, -1.848692, 0.046834>,
      < -0.500654, -1.832575, 0.031085>
    }
    triangle {
      <-0.500654, -1.832575, 0.031085>,
      <-0.194588, -1.505929, 0.033443>,
      < -0.224687, -1.416934, 0.042257>
    }
    triangle {
      <0.293436, -1.006070, -0.188020>,
      <0.326025, -1.028221, -0.111243>,
      < -0.142283, -1.572965, 0.075257>
    }
    triangle {
      <-0.142283, -1.572965, 0.075257>,
      <-0.194588, -1.505929, 0.033443>,
      < 0.293436, -1.006070, -0.188020>
    }
    triangle {
      <0.253013, -0.947503, -0.233124>,
      <0.293436, -1.006070, -0.188020>,
      < -0.194588, -1.505929, 0.033443>
    }
    triangle {
      <-0.194588, -1.505929, 0.033443>,
      <-0.224687, -1.416934, 0.042257>,
      < 0.253013, -0.947503, -0.233124>
    }
    triangle {
      <0.699445, -0.444447, -0.345728>,
      <0.707953, -0.421133, -0.246123>,
      < 0.326025, -1.028221, -0.111243>
    }
    triangle {
      <0.326025, -1.028221, -0.111243>,
      <0.293436, -1.006070, -0.188020>,
      < 0.699445, -0.444447, -0.345728>
    }
    triangle {
      <0.653441, -0.417071, -0.432828>,
      <0.699445, -0.444447, -0.345728>,
      < 0.293436, -1.006070, -0.188020>
    }
    triangle {
      <0.293436, -1.006070, -0.188020>,
      <0.253013, -0.947503, -0.233124>,
      < 0.653441, -0.417071, -0.432828>
    }
    triangle {
      <0.827582, 0.309704, -0.233810>,
      <0.862701, 0.290034, -0.158701>,
      < 0.707953, -0.421133, -0.246123>
    }
    triangle {
      <0.707953, -0.421133, -0.246123>,
      <0.699445, -0.444447, -0.345728>,
      < 0.827582, 0.309704, -0.233810>
    }
    triangle {
      <0.776470, 0.359966, -0.275602>,
      <0.827582, 0.309704, -0.233810>,
      < 0.699445, -0.444447, -0.345728>
    }
    triangle {
      <0.699445, -0.444447, -0.345728>,
      <0.653441, -0.417071, -0.432828>,
      < 0.776470, 0.359966, -0.275602>
    }
    triangle {
      <0.934869, 1.049924, 0.000120>,
      <0.994830, 0.992962, 0.035714>,
      < 0.862701, 0.290034, -0.158701>
    }
    triangle {
      <0.862701, 0.290034, -0.158701>,
      <0.827582, 0.309704, -0.233810>,
      < 0.934869, 1.049924, 0.000120>
    }
    triangle {
      <0.880341, 1.117483, 0.018712>,
      <0.934869, 1.049924, 0.000120>,
      < 0.827582, 0.309704, -0.233810>
    }
    triangle {
      <0.827582, 0.309704, -0.233810>,
      <0.776470, 0.359966, -0.275602>,
      < 0.880341, 1.117483, 0.018712>
    }
    triangle {
      <1.143553, 1.418227, 0.227288>,
      <1.406096, 1.510561, 0.259879>,
      < 0.994830, 0.992962, 0.035714>
    }
    triangle {
      <0.994830, 0.992962, 0.035714>,
      <0.934869, 1.049924, 0.000120>,
      < 1.143553, 1.418227, 0.227288>
    }
    triangle {
      <0.883940, 1.135145, 0.089027>,
      <1.143553, 1.418227, 0.227288>,
      < 0.934869, 1.049924, 0.000120>
    }
    triangle {
      <0.934869, 1.049924, 0.000120>,
      <0.880341, 1.117483, 0.018712>,
      < 0.883940, 1.135145, 0.089027>
    }
    triangle {
      <1.263737, 1.734984, 0.505212>,
      <1.609150, 1.959021, 0.582438>,
      < 1.406096, 1.510561, 0.259879>
    }
    triangle {
      <1.406096, 1.510561, 0.259879>,
      <1.143553, 1.418227, 0.227288>,
      < 1.263737, 1.734984, 0.505212>
    }
    triangle {
      <0.918570, 1.118710, 0.162827>,
      <1.263737, 1.734984, 0.505212>,
      < 1.143553, 1.418227, 0.227288>
    }
    triangle {
      <1.143553, 1.418227, 0.227288>,
      <0.883940, 1.135145, 0.089027>,
      < 0.918570, 1.118710, 0.162827>
    }
    triangle {
      <1.171494, 1.417009, 0.113710>,
      <0.934869, 1.049924, 0.000120>,
      < 0.994830, 0.992962, 0.035714>
    }
    triangle {
      <1.406096, 1.510561, 0.259879>,
      <1.171494, 1.417009, 0.113710>,
      < 0.994830, 0.992962, 0.035714>
    }
    triangle {
      <1.218418, 1.711346, 0.245658>,
      <0.880341, 1.117483, 0.018712>,
      < 0.934869, 1.049924, 0.000120>
    }
    triangle {
      <0.934869, 1.049924, 0.000120>,
      <1.171494, 1.417009, 0.113710>,
      < 1.218418, 1.711346, 0.245658>
    }
    triangle {
      <1.609150, 1.959021, 0.582438>,
      <1.218418, 1.711346, 0.245658>,
      < 1.171494, 1.417009, 0.113710>
    }
    triangle {
      <1.171494, 1.417009, 0.113710>,
      <1.406096, 1.510561, 0.259879>,
      < 1.609150, 1.959021, 0.582438>
    }
    triangle {
      <-0.695108, -1.749591, 0.143468>,
      <-0.713259, -1.848692, 0.046834>,
      < -0.914987, -2.185478, 0.168646>
    }
    triangle {
      <-0.611367, -1.779304, 0.263054>,
      <-0.695108, -1.749591, 0.143468>,
      < -0.914987, -2.185478, 0.168646>
    }
    triangle {
      <-0.198214, -1.385586, 0.106463>,
      <-0.224687, -1.416934, 0.042257>,
      < -0.713259, -1.848692, 0.046834>
    }
    triangle {
      <-0.713259, -1.848692, 0.046834>,
      <-0.695108, -1.749591, 0.143468>,
      < -0.198214, -1.385586, 0.106463>
    }
    triangle {
      <-0.149733, -1.396121, 0.179269>,
      <-0.198214, -1.385586, 0.106463>,
      < -0.695108, -1.749591, 0.143468>
    }
    triangle {
      <-0.695108, -1.749591, 0.143468>,
      <-0.611367, -1.779304, 0.263054>,
      < -0.149733, -1.396121, 0.179269>
    }
    triangle {
      <0.240939, -0.894806, -0.193283>,
      <0.246264, -0.864429, -0.123924>,
      < -0.149733, -1.396121, 0.179269>
    }
    triangle {
      <-0.149733, -1.396121, 0.179269>,
      <-0.198214, -1.385586, 0.106463>,
      < 0.240939, -0.894806, -0.193283>
    }
    triangle {
      <0.253013, -0.947503, -0.233124>,
      <0.240939, -0.894806, -0.193283>,
      < -0.198214, -1.385586, 0.106463>
    }
    triangle {
      <-0.198214, -1.385586, 0.106463>,
      <-0.224687, -1.416934, 0.042257>,
      < 0.253013, -0.947503, -0.233124>
    }
    triangle {
      <0.607291, -0.349137, -0.421730>,
      <0.574275, -0.283859, -0.360094>,
      < 0.246264, -0.864429, -0.123924>
    }
    triangle {
      <0.246264, -0.864429, -0.123924>,
      <0.240939, -0.894806, -0.193283>,
      < 0.607291, -0.349137, -0.421730>
    }
    triangle {
      <0.653441, -0.417071, -0.432828>,
      <0.607291, -0.349137, -0.421730>,
      < 0.240939, -0.894806, -0.193283>
    }
    triangle {
      <0.240939, -0.894806, -0.193283>,
      <0.253013, -0.947503, -0.233124>,
      < 0.653441, -0.417071, -0.432828>
    }
    triangle {
      <0.750382, 0.404125, -0.231921>,
      <0.746303, 0.429842, -0.161208>,
      < 0.574275, -0.283859, -0.360094>
    }
    triangle {
      <0.574275, -0.283859, -0.360094>,
      <0.607291, -0.349137, -0.421730>,
      < 0.750382, 0.404125, -0.231921>
    }
    triangle {
      <0.776470, 0.359966, -0.275602>,
      <0.750382, 0.404125, -0.231921>,
      < 0.607291, -0.349137, -0.421730>
    }
    triangle {
      <0.607291, -0.349137, -0.421730>,
      <0.653441, -0.417071, -0.432828>,
      < 0.776470, 0.359966, -0.275602>
    }
    triangle {
      <0.883940, 1.135145, 0.089027>,
      <0.918570, 1.118710, 0.162827>,
      < 0.746303, 0.429842, -0.161208>
    }
    triangle {
      <0.746303, 0.429842, -0.161208>,
      <0.750382, 0.404125, -0.231921>,
      < 0.883940, 1.135145, 0.089027>
    }
    triangle {
      <0.880341, 1.117483, 0.018712>,
      <0.883940, 1.135145, 0.089027>,
      < 0.750382, 0.404125, -0.231921>
    }
    triangle {
      <0.750382, 0.404125, -0.231921>,
      <0.776470, 0.359966, -0.275602>,
      < 0.880341, 1.117483, 0.018712>
    }
    triangle {
      <1.076579, 1.565641, 0.282369>,
      <1.263737, 1.734984, 0.505212>,
      < 0.918570, 1.118710, 0.162827>
    }
    triangle {
      <0.883940, 1.135145, 0.089027>,
      <1.076579, 1.565641, 0.282369>,
      < 0.918570, 1.118710, 0.162827>
    }
    triangle {
      <1.218418, 1.711346, 0.245658>,
      <1.609150, 1.959021, 0.582438>,
      < 1.263737, 1.734984, 0.505212>
    }
    triangle {
      <1.263737, 1.734984, 0.505212>,
      <1.076579, 1.565641, 0.282369>,
      < 1.218418, 1.711346, 0.245658>
    }
    triangle {
      <0.880341, 1.117483, 0.018712>,
      <1.218418, 1.711346, 0.245658>,
      < 1.076579, 1.565641, 0.282369>
    }
    triangle {
      <1.076579, 1.565641, 0.282369>,
      <0.883940, 1.135145, 0.089027>,
      < 0.880341, 1.117483, 0.018712>
    }
    triangle {
      <-0.490900, -1.518170, 0.702936>,
      <-0.175062, -1.257213, 0.746729>,
      < -0.139928, -1.322768, 0.761325>
    }
    triangle {
      <-0.139928, -1.322768, 0.761325>,
      <-0.569912, -1.797883, 0.827988>,
      < -0.490900, -1.518170, 0.702936>
    }
    triangle {
      <-0.793440, -1.663926, 0.554033>,
      <-0.490900, -1.518170, 0.702936>,
      < -0.569912, -1.797883, 0.827988>
    }
    triangle {
      <-0.569912, -1.797883, 0.827988>,
      <-0.995168, -2.000711, 0.675845>,
      < -0.793440, -1.663926, 0.554033>
    }
    triangle {
      <-0.278395, -1.200819, 0.613662>,
      <-0.229988, -1.211419, 0.686488>,
      < -0.175062, -1.257213, 0.746729>
    }
    triangle {
      <-0.175062, -1.257213, 0.746729>,
      <-0.490900, -1.518170, 0.702936>,
      < -0.278395, -1.200819, 0.613662>
    }
    triangle {
      <-0.304951, -1.232193, 0.549568>,
      <-0.278395, -1.200819, 0.613662>,
      < -0.490900, -1.518170, 0.702936>
    }
    triangle {
      <-0.490900, -1.518170, 0.702936>,
      <-0.793440, -1.663926, 0.554033>,
      < -0.304951, -1.232193, 0.549568>
    }
    triangle {
      <-0.459307, -1.572287, 0.716587>,
      <-0.166736, -1.383098, 0.677508>,
      < -0.139928, -1.322768, 0.761325>
    }
    triangle {
      <-0.139928, -1.322768, 0.761325>,
      <-0.175062, -1.257213, 0.746729>,
      < -0.459307, -1.572287, 0.716587>
    }
    triangle {
      <-0.691621, -1.594602, 0.770272>,
      <-0.459307, -1.572287, 0.716587>,
      < -0.175062, -1.257213, 0.746729>
    }
    triangle {
      <-0.175062, -1.257213, 0.746729>,
      <-0.229988, -1.211419, 0.686488>,
      < -0.691621, -1.594602, 0.770272>
    }
    triangle {
      <-0.679072, -1.871261, 0.591678>,
      <-0.222464, -1.388199, 0.582456>,
      < -0.166736, -1.383098, 0.677508>
    }
    triangle {
      <-0.166736, -1.383098, 0.677508>,
      <-0.459307, -1.572287, 0.716587>,
      < -0.679072, -1.871261, 0.591678>
    }
    triangle {
      <-0.995168, -2.000711, 0.675845>,
      <-0.679072, -1.871261, 0.591678>,
      < -0.459307, -1.572287, 0.716587>
    }
    triangle {
      <-0.459307, -1.572287, 0.716587>,
      <-0.691621, -1.594602, 0.770272>,
      < -0.995168, -2.000711, 0.675845>
    }
    triangle {
      <-0.440024, -1.552308, 0.841917>,
      <-0.569912, -1.797883, 0.827988>,
      < -0.139928, -1.322768, 0.761325>
    }
    triangle {
      <-0.175062, -1.257213, 0.746729>,
      <-0.440024, -1.552308, 0.841917>,
      < -0.139928, -1.322768, 0.761325>
    }
    triangle {
      <-0.691621, -1.594602, 0.770272>,
      <-0.995168, -2.000711, 0.675845>,
      < -0.569912, -1.797883, 0.827988>
    }
    triangle {
      <-0.569912, -1.797883, 0.827988>,
      <-0.440024, -1.552308, 0.841917>,
      < -0.691621, -1.594602, 0.770272>
    }
    triangle {
      <-0.229988, -1.211419, 0.686488>,
      <-0.691621, -1.594602, 0.770272>,
      < -0.440024, -1.552308, 0.841917>
    }
    triangle {
      <-0.440024, -1.552308, 0.841917>,
      <-0.175062, -1.257213, 0.746729>,
      < -0.229988, -1.211419, 0.686488>
    }
    triangle {
      <0.176580, -0.673246, 0.495903>,
      <0.202297, -0.707015, 0.551825>,
      < -0.139928, -1.322768, 0.761325>
    }
    triangle {
      <-0.139928, -1.322768, 0.761325>,
      <-0.175062, -1.257213, 0.746729>,
      < 0.176580, -0.673246, 0.495903>
    }
    triangle {
      <0.158986, -0.673494, 0.411140>,
      <0.176580, -0.673246, 0.495903>,
      < -0.175062, -1.257213, 0.746729>
    }
    triangle {
      <-0.175062, -1.257213, 0.746729>,
      <-0.229988, -1.211419, 0.686488>,
      < 0.158986, -0.673494, 0.411140>
    }
    triangle {
      <0.474435, -0.055574, 0.243722>,
      <0.490680, -0.060201, 0.328232>,
      < 0.202297, -0.707015, 0.551825>
    }
    triangle {
      <0.202297, -0.707015, 0.551825>,
      <0.176580, -0.673246, 0.495903>,
      < 0.474435, -0.055574, 0.243722>
    }
    triangle {
      <0.494094, -0.099093, 0.147104>,
      <0.474435, -0.055574, 0.243722>,
      < 0.176580, -0.673246, 0.495903>
    }
    triangle {
      <0.176580, -0.673246, 0.495903>,
      <0.158986, -0.673494, 0.411140>,
      < 0.494094, -0.099093, 0.147104>
    }
    triangle {
      <-0.486802, -1.597099, 0.657800>,
      <-0.569912, -1.797883, 0.827988>,
      < -0.139928, -1.322768, 0.761325>
    }
    triangle {
      <-0.139928, -1.322768, 0.761325>,
      <-0.166736, -1.383098, 0.677508>,
      < -0.486802, -1.597099, 0.657800>
    }
    triangle {
      <-0.274769, -1.321163, 0.540641>,
      <-0.486802, -1.597099, 0.657800>,
      < -0.166736, -1.383098, 0.677508>
    }
    triangle {
      <-0.166736, -1.383098, 0.677508>,
      <-0.222464, -1.388199, 0.582456>,
      < -0.274769, -1.321163, 0.540641>
    }
    triangle {
      <-0.793440, -1.663926, 0.554033>,
      <-0.995168, -2.000711, 0.675845>,
      < -0.569912, -1.797883, 0.827988>
    }
    triangle {
      <-0.569912, -1.797883, 0.827988>,
      <-0.486802, -1.597099, 0.657800>,
      < -0.793440, -1.663926, 0.554033>
    }
    triangle {
      <-0.304951, -1.232193, 0.549568>,
      <-0.793440, -1.663926, 0.554033>,
      < -0.486802, -1.597099, 0.657800>
    }
    triangle {
      <-0.486802, -1.597099, 0.657800>,
      <-0.274769, -1.321163, 0.540641>,
      < -0.304951, -1.232193, 0.549568>
    }
    triangle {
      <0.232222, -0.786798, 0.507795>,
      <0.202297, -0.707015, 0.551825>,
      < -0.139928, -1.322768, 0.761325>
    }
    triangle {
      <-0.139928, -1.322768, 0.761325>,
      <-0.166736, -1.383098, 0.677508>,
      < 0.232222, -0.786798, 0.507795>
    }
    triangle {
      <0.238836, -0.837130, 0.423654>,
      <0.232222, -0.786798, 0.507795>,
      < -0.166736, -1.383098, 0.677508>
    }
    triangle {
      <-0.166736, -1.383098, 0.677508>,
      <-0.222464, -1.388199, 0.582456>,
      < 0.238836, -0.837130, 0.423654>
    }
    triangle {
      <0.568120, -0.150192, 0.329072>,
      <0.490680, -0.060201, 0.328232>,
      < 0.202297, -0.707015, 0.551825>
    }
    triangle {
      <0.202297, -0.707015, 0.551825>,
      <0.232222, -0.786798, 0.507795>,
      < 0.568120, -0.150192, 0.329072>
    }
    triangle {
      <0.627771, -0.236366, 0.261076>,
      <0.568120, -0.150192, 0.329072>,
      < 0.232222, -0.786798, 0.507795>
    }
    triangle {
      <0.232222, -0.786798, 0.507795>,
      <0.238836, -0.837130, 0.423654>,
      < 0.627771, -0.236366, 0.261076>
    }
    triangle {
      <-0.430938, -1.722762, 0.736128>,
      <-0.569912, -1.797883, 0.827988>,
      < -0.139928, -1.322768, 0.761325>
    }
    triangle {
      <-0.166736, -1.383098, 0.677508>,
      <-0.430938, -1.722762, 0.736128>,
      < -0.139928, -1.322768, 0.761325>
    }
    triangle {
      <-0.679072, -1.871261, 0.591678>,
      <-0.995168, -2.000711, 0.675845>,
      < -0.569912, -1.797883, 0.827988>
    }
    triangle {
      <-0.569912, -1.797883, 0.827988>,
      <-0.430938, -1.722762, 0.736128>,
      < -0.679072, -1.871261, 0.591678>
    }
    triangle {
      <-0.222464, -1.388199, 0.582456>,
      <-0.679072, -1.871261, 0.591678>,
      < -0.430938, -1.722762, 0.736128>
    }
    triangle {
      <-0.430938, -1.722762, 0.736128>,
      <-0.166736, -1.383098, 0.677508>,
      < -0.222464, -1.388199, 0.582456>
    }
    triangle {
      <0.738584, 0.535698, 0.197254>,
      <0.773108, 0.506838, 0.247948>,
      < 0.490680, -0.060201, 0.328232>
    }
    triangle {
      <0.490680, -0.060201, 0.328232>,
      <0.474435, -0.055574, 0.243722>,
      < 0.738584, 0.535698, 0.197254>
    }
    triangle {
      <0.718736, 0.534994, 0.115728>,
      <0.738584, 0.535698, 0.197254>,
      < 0.474435, -0.055574, 0.243722>
    }
    triangle {
      <0.474435, -0.055574, 0.243722>,
      <0.494094, -0.099093, 0.147104>,
      < 0.718736, 0.534994, 0.115728>
    }
    triangle {
      <1.004227, 1.125857, 0.257953>,
      <1.058552, 1.074477, 0.261500>,
      < 0.773108, 0.506838, 0.247948>
    }
    triangle {
      <0.773108, 0.506838, 0.247948>,
      <0.738584, 0.535698, 0.197254>,
      < 1.004227, 1.125857, 0.257953>
    }
    triangle {
      <0.943517, 1.166306, 0.204626>,
      <1.004227, 1.125857, 0.257953>,
      < 0.738584, 0.535698, 0.197254>
    }
    triangle {
      <0.738584, 0.535698, 0.197254>,
      <0.718736, 0.534994, 0.115728>,
      < 0.943517, 1.166306, 0.204626>
    }
    triangle {
      <0.819100, 0.439996, 0.200385>,
      <0.773108, 0.506838, 0.247948>,
      < 0.490680, -0.060201, 0.328232>
    }
    triangle {
      <0.490680, -0.060201, 0.328232>,
      <0.568120, -0.150192, 0.329072>,
      < 0.819100, 0.439996, 0.200385>
    }
    triangle {
      <0.835402, 0.396310, 0.116369>,
      <0.819100, 0.439996, 0.200385>,
      < 0.568120, -0.150192, 0.329072>
    }
    triangle {
      <0.568120, -0.150192, 0.329072>,
      <0.627771, -0.236366, 0.261076>,
      < 0.835402, 0.396310, 0.116369>
    }
    triangle {
      <1.059932, 1.036283, 0.171477>,
      <1.058552, 1.074477, 0.261500>,
      < 0.773108, 0.506838, 0.247948>
    }
    triangle {
      <0.773108, 0.506838, 0.247948>,
      <0.819100, 0.439996, 0.200385>,
      < 1.059932, 1.036283, 0.171477>
    }
    triangle {
      <1.019786, 1.040519, 0.077422>,
      <1.059932, 1.036283, 0.171477>,
      < 0.819100, 0.439996, 0.200385>
    }
    triangle {
      <0.819100, 0.439996, 0.200385>,
      <0.835402, 0.396310, 0.116369>,
      < 1.019786, 1.040519, 0.077422>
    }
    triangle {
      <1.145973, 1.457400, 0.327421>,
      <1.404575, 1.568725, 0.564667>,
      < 1.058552, 1.074477, 0.261500>
    }
    triangle {
      <1.058552, 1.074477, 0.261500>,
      <1.004227, 1.125857, 0.257953>,
      < 1.145973, 1.457400, 0.327421>
    }
    triangle {
      <0.908235, 1.182119, 0.130915>,
      <1.145973, 1.457400, 0.327421>,
      < 1.004227, 1.125857, 0.257953>
    }
    triangle {
      <1.004227, 1.125857, 0.257953>,
      <0.943517, 1.166306, 0.204626>,
      < 0.908235, 1.182119, 0.130915>
    }
    triangle {
      <1.183536, 1.708301, 0.293056>,
      <1.509685, 1.934779, 0.656848>,
      < 1.404575, 1.568725, 0.564667>
    }
    triangle {
      <1.404575, 1.568725, 0.564667>,
      <1.145973, 1.457400, 0.327421>,
      < 1.183536, 1.708301, 0.293056>
    }
    triangle {
      <0.905298, 1.165040, 0.060420>,
      <1.183536, 1.708301, 0.293056>,
      < 1.145973, 1.457400, 0.327421>
    }
    triangle {
      <1.145973, 1.457400, 0.327421>,
      <0.908235, 1.182119, 0.130915>,
      < 0.905298, 1.165040, 0.060420>
    }
    triangle {
      <1.224295, 1.480901, 0.473994>,
      <1.404575, 1.568725, 0.564667>,
      < 1.058552, 1.074477, 0.261500>
    }
    triangle {
      <1.004227, 1.125857, 0.257953>,
      <1.224295, 1.480901, 0.473994>,
      < 1.058552, 1.074477, 0.261500>
    }
    triangle {
      <1.231708, 1.731123, 0.534485>,
      <1.509685, 1.934779, 0.656848>,
      < 1.404575, 1.568725, 0.564667>
    }
    triangle {
      <1.404575, 1.568725, 0.564667>,
      <1.224295, 1.480901, 0.473994>,
      < 1.231708, 1.731123, 0.534485>
    }
    triangle {
      <0.943517, 1.166306, 0.204626>,
      <1.231708, 1.731123, 0.534485>,
      < 1.224295, 1.480901, 0.473994>
    }
    triangle {
      <1.224295, 1.480901, 0.473994>,
      <1.004227, 1.125857, 0.257953>,
      < 0.943517, 1.166306, 0.204626>
    }
    triangle {
      <1.197774, 1.404045, 0.333295>,
      <1.059932, 1.036283, 0.171477>,
      < 1.058552, 1.074477, 0.261500>
    }
    triangle {
      <1.058552, 1.074477, 0.261500>,
      <1.004227, 1.125857, 0.257953>,
      < 1.197774, 1.404045, 0.333295>
    }
    triangle {
      <1.231708, 1.731123, 0.534485>,
      <1.197774, 1.404045, 0.333295>,
      < 1.004227, 1.125857, 0.257953>
    }
    triangle {
      <1.004227, 1.125857, 0.257953>,
      <0.943517, 1.166306, 0.204626>,
      < 1.231708, 1.731123, 0.534485>
    }
    triangle {
      <1.365491, 1.522815, 0.302844>,
      <1.019786, 1.040519, 0.077422>,
      < 1.059932, 1.036283, 0.171477>
    }
    triangle {
      <1.059932, 1.036283, 0.171477>,
      <1.197774, 1.404045, 0.333295>,
      < 1.365491, 1.522815, 0.302844>
    }
    triangle {
      <1.509685, 1.934779, 0.656848>,
      <1.365491, 1.522815, 0.302844>,
      < 1.197774, 1.404045, 0.333295>
    }
    triangle {
      <1.197774, 1.404045, 0.333295>,
      <1.231708, 1.731123, 0.534485>,
      < 1.509685, 1.934779, 0.656848>
    }
    triangle {
      <1.180220, 1.401459, 0.271554>,
      <1.404575, 1.568725, 0.564667>,
      < 1.058552, 1.074477, 0.261500>
    }
    triangle {
      <1.058552, 1.074477, 0.261500>,
      <1.059932, 1.036283, 0.171477>,
      < 1.180220, 1.401459, 0.271554>
    }
    triangle {
      <0.959149, 1.096807, 0.042154>,
      <1.180220, 1.401459, 0.271554>,
      < 1.059932, 1.036283, 0.171477>
    }
    triangle {
      <1.059932, 1.036283, 0.171477>,
      <1.019786, 1.040519, 0.077422>,
      < 0.959149, 1.096807, 0.042154>
    }
    triangle {
      <1.183536, 1.708301, 0.293056>,
      <1.509685, 1.934779, 0.656848>,
      < 1.404575, 1.568725, 0.564667>
    }
    triangle {
      <1.404575, 1.568725, 0.564667>,
      <1.180220, 1.401459, 0.271554>,
      < 1.183536, 1.708301, 0.293056>
    }
    triangle {
      <0.905298, 1.165040, 0.060420>,
      <1.183536, 1.708301, 0.293056>,
      < 1.180220, 1.401459, 0.271554>
    }
    triangle {
      <1.180220, 1.401459, 0.271554>,
      <0.959149, 1.096807, 0.042154>,
      < 0.905298, 1.165040, 0.060420>
    }
    triangle {
      <1.305673, 1.353897, 0.337131>,
      <1.404575, 1.568725, 0.564667>,
      < 1.058552, 1.074477, 0.261500>
    }
    triangle {
      <1.059932, 1.036283, 0.171477>,
      <1.305673, 1.353897, 0.337131>,
      < 1.058552, 1.074477, 0.261500>
    }
    triangle {
      <1.365491, 1.522815, 0.302844>,
      <1.509685, 1.934779, 0.656848>,
      < 1.404575, 1.568725, 0.564667>
    }
    triangle {
      <1.404575, 1.568725, 0.564667>,
      <1.305673, 1.353897, 0.337131>,
      < 1.365491, 1.522815, 0.302844>
    }
    triangle {
      <1.019786, 1.040519, 0.077422>,
      <1.365491, 1.522815, 0.302844>,
      < 1.305673, 1.353897, 0.337131>
    }
    triangle {
      <1.305673, 1.353897, 0.337131>,
      <1.059932, 1.036283, 0.171477>,
      < 1.019786, 1.040519, 0.077422>
    }
    triangle {
      <-0.523773, -1.535831, 0.634583>,
      <-0.274769, -1.321163, 0.540641>,
      < -0.222464, -1.388199, 0.582456>
    }
    triangle {
      <-0.222464, -1.388199, 0.582456>,
      <-0.679072, -1.871261, 0.591678>,
      < -0.523773, -1.535831, 0.634583>
    }
    triangle {
      <-0.691621, -1.594602, 0.770272>,
      <-0.523773, -1.535831, 0.634583>,
      < -0.679072, -1.871261, 0.591678>
    }
    triangle {
      <-0.679072, -1.871261, 0.591678>,
      <-0.995168, -2.000711, 0.675845>,
      < -0.691621, -1.594602, 0.770272>
    }
    triangle {
      <-0.278395, -1.200819, 0.613662>,
      <-0.304951, -1.232193, 0.549568>,
      < -0.274769, -1.321163, 0.540641>
    }
    triangle {
      <-0.274769, -1.321163, 0.540641>,
      <-0.523773, -1.535831, 0.634583>,
      < -0.278395, -1.200819, 0.613662>
    }
    triangle {
      <-0.229988, -1.211419, 0.686488>,
      <-0.278395, -1.200819, 0.613662>,
      < -0.523773, -1.535831, 0.634583>
    }
    triangle {
      <-0.523773, -1.535831, 0.634583>,
      <-0.691621, -1.594602, 0.770272>,
      < -0.229988, -1.211419, 0.686488>
    }
    triangle {
      <-0.580909, -1.647873, 0.538304>,
      <-0.679072, -1.871261, 0.591678>,
      < -0.222464, -1.388199, 0.582456>
    }
    triangle {
      <-0.274769, -1.321163, 0.540641>,
      <-0.580909, -1.647873, 0.538304>,
      < -0.222464, -1.388199, 0.582456>
    }
    triangle {
      <-0.793440, -1.663926, 0.554033>,
      <-0.995168, -2.000711, 0.675845>,
      < -0.679072, -1.871261, 0.591678>
    }
    triangle {
      <-0.679072, -1.871261, 0.591678>,
      <-0.580909, -1.647873, 0.538304>,
      < -0.793440, -1.663926, 0.554033>
    }
    triangle {
      <-0.304951, -1.232193, 0.549568>,
      <-0.793440, -1.663926, 0.554033>,
      < -0.580909, -1.647873, 0.538304>
    }
    triangle {
      <-0.580909, -1.647873, 0.538304>,
      <-0.274769, -1.321163, 0.540641>,
      < -0.304951, -1.232193, 0.549568>
    }
    triangle {
      <0.206198, -0.814991, 0.346659>,
      <0.238836, -0.837130, 0.423654>,
      < -0.222464, -1.388199, 0.582456>
    }
    triangle {
      <-0.222464, -1.388199, 0.582456>,
      <-0.274769, -1.321163, 0.540641>,
      < 0.206198, -0.814991, 0.346659>
    }
    triangle {
      <0.165879, -0.756645, 0.301222>,
      <0.206198, -0.814991, 0.346659>,
      < -0.274769, -1.321163, 0.540641>
    }
    triangle {
      <-0.274769, -1.321163, 0.540641>,
      <-0.304951, -1.232193, 0.549568>,
      < 0.165879, -0.756645, 0.301222>
    }
    triangle {
      <0.619263, -0.259680, 0.161470>,
      <0.627771, -0.236366, 0.261076>,
      < 0.238836, -0.837130, 0.423654>
    }
    triangle {
      <0.238836, -0.837130, 0.423654>,
      <0.206198, -0.814991, 0.346659>,
      < 0.619263, -0.259680, 0.161470>
    }
    triangle {
      <0.573260, -0.232304, 0.074371>,
      <0.619263, -0.259680, 0.161470>,
      < 0.206198, -0.814991, 0.346659>
    }
    triangle {
      <0.206198, -0.814991, 0.346659>,
      <0.165879, -0.756645, 0.301222>,
      < 0.573260, -0.232304, 0.074371>
    }
    triangle {
      <0.799750, 0.414668, 0.041543>,
      <0.835402, 0.396310, 0.116369>,
      < 0.627771, -0.236366, 0.261076>
    }
    triangle {
      <0.627771, -0.236366, 0.261076>,
      <0.619263, -0.259680, 0.161470>,
      < 0.799750, 0.414668, 0.041543>
    }
    triangle {
      <0.748708, 0.464226, -0.000271>,
      <0.799750, 0.414668, 0.041543>,
      < 0.619263, -0.259680, 0.161470>
    }
    triangle {
      <0.619263, -0.259680, 0.161470>,
      <0.573260, -0.232304, 0.074371>,
      < 0.748708, 0.464226, -0.000271>
    }
    triangle {
      <0.959149, 1.096807, 0.042154>,
      <1.019786, 1.040519, 0.077422>,
      < 0.835402, 0.396310, 0.116369>
    }
    triangle {
      <0.905298, 1.165040, 0.060420>,
      <0.959149, 1.096807, 0.042154>,
      < 0.799750, 0.414668, 0.041543>
    }
    triangle {
      <0.799750, 0.414668, 0.041543>,
      <0.748708, 0.464226, -0.000271>,
      < 0.905298, 1.165040, 0.060420>
    }
    triangle {
      <1.137727, 1.439817, 0.255297>,
      <1.365491, 1.522815, 0.302844>,
      < 1.019786, 1.040519, 0.077422>
    }
    triangle {
      <1.019786, 1.040519, 0.077422>,
      <0.959149, 1.096807, 0.042154>,
      < 1.137727, 1.439817, 0.255297>
    }
    triangle {
      <0.908235, 1.182119, 0.130915>,
      <1.137727, 1.439817, 0.255297>,
      < 0.959149, 1.096807, 0.042154>
    }
    triangle {
      <0.959149, 1.096807, 0.042154>,
      <0.905298, 1.165040, 0.060420>,
      < 0.908235, 1.182119, 0.130915>
    }
    triangle {
      <1.231708, 1.731123, 0.534485>,
      <1.509685, 1.934779, 0.656848>,
      < 1.365491, 1.522815, 0.302844>
    }
    triangle {
      <1.365491, 1.522815, 0.302844>,
      <1.137727, 1.439817, 0.255297>,
      < 1.231708, 1.731123, 0.534485>
    }
    triangle {
      <0.943517, 1.166306, 0.204626>,
      <1.231708, 1.731123, 0.534485>,
      < 1.137727, 1.439817, 0.255297>
    }
    triangle {
      <1.137727, 1.439817, 0.255297>,
      <0.908235, 1.182119, 0.130915>,
      < 0.943517, 1.166306, 0.204626>
    }
    triangle {
      <1.164580, 1.436688, 0.142527>,
      <0.959149, 1.096807, 0.042154>,
      < 1.019786, 1.040519, 0.077422>
    }
    triangle {
      <1.365491, 1.522815, 0.302844>,
      <1.164580, 1.436688, 0.142527>,
      < 1.019786, 1.040519, 0.077422>
    }
    triangle {
      <1.183536, 1.708301, 0.293056>,
      <0.905298, 1.165040, 0.060420>,
      < 0.959149, 1.096807, 0.042154>
    }
    triangle {
      <0.959149, 1.096807, 0.042154>,
      <1.164580, 1.436688, 0.142527>,
      < 1.183536, 1.708301, 0.293056>
    }
    triangle {
      <1.509685, 1.934779, 0.656848>,
      <1.183536, 1.708301, 0.293056>,
      < 1.164580, 1.436688, 0.142527>
    }
    triangle {
      <1.164580, 1.436688, 0.142527>,
      <1.365491, 1.522815, 0.302844>,
      < 1.509685, 1.934779, 0.656848>
    }
    triangle {
      <-0.775289, -1.564824, 0.650667>,
      <-0.793440, -1.663926, 0.554033>,
      < -0.995168, -2.000711, 0.675845>
    }
    triangle {
      <-0.691621, -1.594602, 0.770272>,
      <-0.775289, -1.564824, 0.650667>,
      < -0.995168, -2.000711, 0.675845>
    }
    triangle {
      <-0.278395, -1.200819, 0.613662>,
      <-0.304951, -1.232193, 0.549568>,
      < -0.793440, -1.663926, 0.554033>
    }
    triangle {
      <-0.793440, -1.663926, 0.554033>,
      <-0.775289, -1.564824, 0.650667>,
      < -0.278395, -1.200819, 0.613662>
    }
    triangle {
      <-0.229988, -1.211419, 0.686488>,
      <-0.278395, -1.200819, 0.613662>,
      < -0.775289, -1.564824, 0.650667>
    }
    triangle {
      <-0.775289, -1.564824, 0.650667>,
      <-0.691621, -1.594602, 0.770272>,
      < -0.229988, -1.211419, 0.686488>
    }
    triangle {
      <0.153695, -0.703857, 0.341450>,
      <0.158986, -0.673494, 0.411140>,
      < -0.229988, -1.211419, 0.686488>
    }
    triangle {
      <-0.229988, -1.211419, 0.686488>,
      <-0.278395, -1.200819, 0.613662>,
      < 0.153695, -0.703857, 0.341450>
    }
    triangle {
      <0.165879, -0.756645, 0.301222>,
      <0.153695, -0.703857, 0.341450>,
      < -0.278395, -1.200819, 0.613662>
    }
    triangle {
      <-0.278395, -1.200819, 0.613662>,
      <-0.304951, -1.232193, 0.549568>,
      < 0.165879, -0.756645, 0.301222>
    }
    triangle {
      <0.527101, -0.164332, 0.085560>,
      <0.494094, -0.099093, 0.147104>,
      < 0.158986, -0.673494, 0.411140>
    }
    triangle {
      <0.158986, -0.673494, 0.411140>,
      <0.153695, -0.703857, 0.341450>,
      < 0.527101, -0.164332, 0.085560>
    }
    triangle {
      <0.573260, -0.232304, 0.074371>,
      <0.527101, -0.164332, 0.085560>,
      < 0.153695, -0.703857, 0.341450>
    }
    triangle {
      <0.153695, -0.703857, 0.341450>,
      <0.165879, -0.756645, 0.301222>,
      < 0.573260, -0.232304, 0.074371>
    }
    triangle {
      <0.722316, 0.508540, 0.044295>,
      <0.718736, 0.534994, 0.115728>,
      < 0.494094, -0.099093, 0.147104>
    }
    triangle {
      <0.494094, -0.099093, 0.147104>,
      <0.527101, -0.164332, 0.085560>,
      < 0.722316, 0.508540, 0.044295>
    }
    triangle {
      <0.748708, 0.464226, -0.000271>,
      <0.722316, 0.508540, 0.044295>,
      < 0.527101, -0.164332, 0.085560>
    }
    triangle {
      <0.527101, -0.164332, 0.085560>,
      <0.573260, -0.232304, 0.074371>,
      < 0.748708, 0.464226, -0.000271>
    }
    triangle {
      <0.908235, 1.182119, 0.130915>,
      <0.943517, 1.166306, 0.204626>,
      < 0.718736, 0.534994, 0.115728>
    }
    triangle {
      <0.718736, 0.534994, 0.115728>,
      <0.722316, 0.508540, 0.044295>,
      < 0.908235, 1.182119, 0.130915>
    }
    triangle {
      <0.905298, 1.165040, 0.060420>,
      <0.908235, 1.182119, 0.130915>,
      < 0.722316, 0.508540, 0.044295>
    }
    triangle {
      <0.722316, 0.508540, 0.044295>,
      <0.748708, 0.464226, -0.000271>,
      < 0.905298, 1.165040, 0.060420>
    }
    triangle {
      <1.073892, 1.576896, 0.304926>,
      <1.231708, 1.731123, 0.534485>,
      < 0.943517, 1.166306, 0.204626>
    }
    triangle {
      <0.908235, 1.182119, 0.130915>,
      <1.073892, 1.576896, 0.304926>,
      < 0.943517, 1.166306, 0.204626>
    }
    triangle {
      <1.183536, 1.708301, 0.293056>,
      <1.509685, 1.934779, 0.656848>,
      < 1.231708, 1.731123, 0.534485>
    }
    triangle {
      <1.231708, 1.731123, 0.534485>,
      <1.073892, 1.576896, 0.304926>,
      < 1.183536, 1.708301, 0.293056>
    }
    triangle {
      <0.905298, 1.165040, 0.060420>,
      <1.183536, 1.708301, 0.293056>,
      < 1.073892, 1.576896, 0.304926>
    }
    triangle {
      <-0.604025, -1.648496, 0.749441>,
      <-0.642748, -1.669551, 0.754457>,
      < -0.612958, -1.633785, 0.742316>
    }
    triangle {
      <-0.565303, -1.627442, 0.744426>,
      <-0.604025, -1.648496, 0.749441>,
      < -0.612958, -1.633785, 0.742316>
    }
    triangle {
      <-0.582772, -1.683541, 0.766412>,
      <-0.637749, -1.713444, 0.773537>,
      < -0.642748, -1.669551, 0.754457>
    }
    triangle {
      <-0.642748, -1.669551, 0.754457>,
      <-0.604025, -1.648496, 0.749441>,
      < -0.582772, -1.683541, 0.766412>
    }
    triangle {
      <-0.527795, -1.653638, 0.759287>,
      <-0.582772, -1.683541, 0.766412>,
      < -0.604025, -1.648496, 0.749441>
    }
    triangle {
      <-0.604025, -1.648496, 0.749441>,
      <-0.565303, -1.627442, 0.744426>,
      < -0.527795, -1.653638, 0.759287>
    }
    triangle {
      <-0.583585, -1.834062, 0.468745>,
      <-0.590406, -1.807628, 0.456870>,
      < -0.612958, -1.633785, 0.742316>
    }
    triangle {
      <-0.612958, -1.633785, 0.742316>,
      <-0.642748, -1.669551, 0.754457>,
      < -0.583585, -1.834062, 0.468745>
    }
    triangle {
      <-0.558491, -1.847746, 0.477061>,
      <-0.583585, -1.834062, 0.468745>,
      < -0.642748, -1.669551, 0.754457>
    }
    triangle {
      <-0.642748, -1.669551, 0.754457>,
      <-0.637749, -1.713444, 0.773537>,
      < -0.558491, -1.847746, 0.477061>
    }
    triangle {
      <-0.524413, -1.998611, 0.182940>,
      <-0.567919, -1.981575, 0.171353>,
      < -0.590406, -1.807628, 0.456870>
    }
    triangle {
      <-0.590406, -1.807628, 0.456870>,
      <-0.583585, -1.834062, 0.468745>,
      < -0.524413, -1.998611, 0.182940>
    }
    triangle {
      <-0.479291, -1.982021, 0.180458>,
      <-0.524413, -1.998611, 0.182940>,
      < -0.583585, -1.834062, 0.468745>
    }
    triangle {
      <-0.583585, -1.834062, 0.468745>,
      <-0.558491, -1.847746, 0.477061>,
      < -0.479291, -1.982021, 0.180458>
    }
    triangle {
      <-0.574704, -1.783916, 0.448414>,
      <-0.565303, -1.627442, 0.744426>,
      < -0.612958, -1.633785, 0.742316>
    }
    triangle {
      <-0.612958, -1.633785, 0.742316>,
      <-0.590406, -1.807628, 0.456870>,
      < -0.574704, -1.783916, 0.448414>
    }
    triangle {
      <-0.584095, -1.940428, 0.152310>,
      <-0.574704, -1.783916, 0.448414>,
      < -0.590406, -1.807628, 0.456870>
    }
    triangle {
      <-0.590406, -1.807628, 0.456870>,
      <-0.567919, -1.981575, 0.171353>,
      < -0.584095, -1.940428, 0.152310>
    }
    triangle {
      <-0.545857, -1.776565, 0.448205>,
      <-0.527795, -1.653638, 0.759287>,
      < -0.565303, -1.627442, 0.744426>
    }
    triangle {
      <-0.565303, -1.627442, 0.744426>,
      <-0.574704, -1.783916, 0.448414>,
      < -0.545857, -1.776565, 0.448205>
    }
    triangle {
      <-0.563976, -1.899465, 0.136997>,
      <-0.545857, -1.776565, 0.448205>,
      < -0.574704, -1.783916, 0.448414>
    }
    triangle {
      <-0.574704, -1.783916, 0.448414>,
      <-0.584095, -1.940428, 0.152310>,
      < -0.563976, -1.899465, 0.136997>
    }
    triangle {
      <-0.520830, -1.790184, 0.456487>,
      <-0.513935, -1.816552, 0.468341>,
      < -0.552586, -1.733297, 0.790508>
    }
    triangle {
      <-0.552586, -1.733297, 0.790508>,
      <-0.522723, -1.697467, 0.778348>,
      < -0.520830, -1.790184, 0.456487>
    }
    triangle {
      <-0.545857, -1.776565, 0.448205>,
      <-0.520830, -1.790184, 0.456487>,
      < -0.522723, -1.697467, 0.778348>
    }
    triangle {
      <-0.522723, -1.697467, 0.778348>,
      <-0.527795, -1.653638, 0.759287>,
      < -0.545857, -1.776565, 0.448205>
    }
    triangle {
      <-0.518855, -1.882875, 0.134514>,
      <-0.475348, -1.899911, 0.146102>,
      < -0.513935, -1.816552, 0.468341>
    }
    triangle {
      <-0.513935, -1.816552, 0.468341>,
      <-0.520830, -1.790184, 0.456487>,
      < -0.518855, -1.882875, 0.134514>
    }
    triangle {
      <-0.563976, -1.899465, 0.136997>,
      <-0.518855, -1.882875, 0.134514>,
      < -0.520830, -1.790184, 0.456487>
    }
    triangle {
      <-0.520830, -1.790184, 0.456487>,
      <-0.545857, -1.776565, 0.448205>,
      < -0.563976, -1.899465, 0.136997>
    }
    triangle {
      <-0.561519, -1.718586, 0.783383>,
      <-0.522723, -1.697467, 0.778348>,
      < -0.552586, -1.733297, 0.790508>
    }
    triangle {
      <-0.600174, -1.739706, 0.788433>,
      <-0.561519, -1.718586, 0.783383>,
      < -0.552586, -1.733297, 0.790508>
    }
    triangle {
      <-0.582772, -1.683541, 0.766412>,
      <-0.527795, -1.653638, 0.759287>,
      < -0.522723, -1.697467, 0.778348>
    }
    triangle {
      <-0.522723, -1.697467, 0.778348>,
      <-0.561519, -1.718586, 0.783383>,
      < -0.582772, -1.683541, 0.766412>
    }
    triangle {
      <-0.637749, -1.713444, 0.773537>,
      <-0.582772, -1.683541, 0.766412>,
      < -0.561519, -1.718586, 0.783383>
    }
    triangle {
      <-0.561519, -1.718586, 0.783383>,
      <-0.600174, -1.739706, 0.788433>,
      < -0.637749, -1.713444, 0.773537>
    }
    triangle {
      <-0.529711, -1.840330, 0.476818>,
      <-0.600174, -1.739706, 0.788433>,
      < -0.552586, -1.733297, 0.790508>
    }
    triangle {
      <-0.552586, -1.733297, 0.790508>,
      <-0.513935, -1.816552, 0.468341>,
      < -0.529711, -1.840330, 0.476818>
    }
    triangle {
      <-0.459172, -1.941057, 0.165145>,
      <-0.529711, -1.840330, 0.476818>,
      < -0.513935, -1.816552, 0.468341>
    }
    triangle {
      <-0.513935, -1.816552, 0.468341>,
      <-0.475348, -1.899911, 0.146102>,
      < -0.459172, -1.941057, 0.165145>
    }
    triangle {
      <-0.558491, -1.847746, 0.477061>,
      <-0.637749, -1.713444, 0.773537>,
      < -0.600174, -1.739706, 0.788433>
    }
    triangle {
      <-0.600174, -1.739706, 0.788433>,
      <-0.529711, -1.840330, 0.476818>,
      < -0.558491, -1.847746, 0.477061>
    }
    triangle {
      <-0.479291, -1.982021, 0.180458>,
      <-0.558491, -1.847746, 0.477061>,
      < -0.529711, -1.840330, 0.476818>
    }
    triangle {
      <-0.529711, -1.840330, 0.476818>,
      <-0.459172, -1.941057, 0.165145>,
      < -0.479291, -1.982021, 0.180458>
    }
    triangle {
      <-0.554254, -1.969520, 0.167625>,
      <-0.584095, -1.940428, 0.152310>,
      < -0.567919, -1.981575, 0.171353>
    }
    triangle {
      <-0.524413, -1.998611, 0.182940>,
      <-0.554254, -1.969520, 0.167625>,
      < -0.567919, -1.981575, 0.171353>
    }
    triangle {
      <-0.521634, -1.940743, 0.158727>,
      <-0.563976, -1.899465, 0.136997>,
      < -0.584095, -1.940428, 0.152310>
    }
    triangle {
      <-0.584095, -1.940428, 0.152310>,
      <-0.554254, -1.969520, 0.167625>,
      < -0.521634, -1.940743, 0.158727>
    }
    triangle {
      <-0.479291, -1.982021, 0.180458>,
      <-0.521634, -1.940743, 0.158727>,
      < -0.554254, -1.969520, 0.167625>
    }
    triangle {
      <-0.554254, -1.969520, 0.167625>,
      <-0.524413, -1.998611, 0.182940>,
      < -0.479291, -1.982021, 0.180458>
    }
    triangle {
      <-0.489014, -1.911966, 0.149830>,
      <-0.459172, -1.941057, 0.165145>,
      < -0.475348, -1.899911, 0.146102>
    }
    triangle {
      <-0.518855, -1.882875, 0.134514>,
      <-0.489014, -1.911966, 0.149830>,
      < -0.475348, -1.899911, 0.146102>
    }
    triangle {
      <-0.521634, -1.940743, 0.158727>,
      <-0.479291, -1.982021, 0.180458>,
      < -0.459172, -1.941057, 0.165145>
    }
    triangle {
      <-0.459172, -1.941057, 0.165145>,
      <-0.489014, -1.911966, 0.149830>,
      < -0.521634, -1.940743, 0.158727>
    }
    triangle {
      <-0.563976, -1.899465, 0.136997>,
      <-0.521634, -1.940743, 0.158727>,
      < -0.489014, -1.911966, 0.149830>
    }
    triangle {
      <-0.489014, -1.911966, 0.149830>,
      <-0.518855, -1.882875, 0.134514>,
      < -0.563976, -1.899465, 0.136997>
    }
    triangle {
      <-0.184804, -1.219671, 0.614372>,
      <-0.219193, -1.238401, 0.618840>,
      < -0.192759, -1.206595, 0.608037>
    }
    triangle {
      <-0.150415, -1.200941, 0.609905>,
      <-0.184804, -1.219671, 0.614372>,
      < -0.192759, -1.206595, 0.608037>
    }
    triangle {
      <-0.165895, -1.250793, 0.629447>,
      <-0.214733, -1.277403, 0.635796>,
      < -0.219193, -1.238401, 0.618840>
    }
    triangle {
      <-0.219193, -1.238401, 0.618840>,
      <-0.184804, -1.219671, 0.614372>,
      < -0.165895, -1.250793, 0.629447>
    }
    triangle {
      <-0.117129, -1.224248, 0.623118>,
      <-0.165895, -1.250793, 0.629447>,
      < -0.184804, -1.219671, 0.614372>
    }
    triangle {
      <-0.184804, -1.219671, 0.614372>,
      <-0.150415, -1.200941, 0.609905>,
      < -0.117129, -1.224248, 0.623118>
    }
    triangle {
      <-0.166616, -1.384533, 0.364927>,
      <-0.172738, -1.361101, 0.354393>,
      < -0.192759, -1.206595, 0.608037>
    }
    triangle {
      <-0.192759, -1.206595, 0.608037>,
      <-0.219193, -1.238401, 0.618840>,
      < -0.166616, -1.384533, 0.364927>
    }
    triangle {
      <-0.144335, -1.396704, 0.372320>,
      <-0.166616, -1.384533, 0.364927>,
      < -0.219193, -1.238401, 0.618840>
    }
    triangle {
      <-0.219193, -1.238401, 0.618840>,
      <-0.214733, -1.277403, 0.635796>,
      < -0.144335, -1.396704, 0.372320>
    }
    triangle {
      <-0.114114, -1.530729, 0.111034>,
      <-0.152717, -1.515608, 0.100750>,
      < -0.172738, -1.361101, 0.354393>
    }
    triangle {
      <-0.172738, -1.361101, 0.354393>,
      <-0.166616, -1.384533, 0.364927>,
      < -0.114114, -1.530729, 0.111034>
    }
    triangle {
      <-0.074004, -1.515939, 0.108809>,
      <-0.114114, -1.530729, 0.111034>,
      < -0.166616, -1.384533, 0.364927>
    }
    triangle {
      <-0.166616, -1.384533, 0.364927>,
      <-0.144335, -1.396704, 0.372320>,
      < -0.074004, -1.515939, 0.108809>
    }
    triangle {
      <-0.158708, -1.339988, 0.346869>,
      <-0.150415, -1.200941, 0.609905>,
      < -0.192759, -1.206595, 0.608037>
    }
    triangle {
      <-0.192759, -1.206595, 0.608037>,
      <-0.172738, -1.361101, 0.354393>,
      < -0.158708, -1.339988, 0.346869>
    }
    triangle {
      <-0.167075, -1.479099, 0.083853>,
      <-0.158708, -1.339988, 0.346869>,
      < -0.172738, -1.361101, 0.354393>
    }
    triangle {
      <-0.172738, -1.361101, 0.354393>,
      <-0.152717, -1.515608, 0.100750>,
      < -0.167075, -1.479099, 0.083853>
    }
    triangle {
      <-0.133207, -1.333467, 0.346674>,
      <-0.117129, -1.224248, 0.623118>,
      < -0.150415, -1.200941, 0.609905>
    }
    triangle {
      <-0.150415, -1.200941, 0.609905>,
      <-0.158708, -1.339988, 0.346869>,
      < -0.133207, -1.333467, 0.346674>
    }
    triangle {
      <-0.149212, -1.442621, 0.070211>,
      <-0.133207, -1.333467, 0.346674>,
      < -0.158708, -1.339988, 0.346869>
    }
    triangle {
      <-0.158708, -1.339988, 0.346869>,
      <-0.167075, -1.479099, 0.083853>,
      < -0.149212, -1.442621, 0.070211>
    }
    triangle {
      <-0.110853, -1.345573, 0.354047>,
      <-0.104804, -1.369070, 0.364601>,
      < -0.139104, -1.295057, 0.650877>
    }
    triangle {
      <-0.139104, -1.295057, 0.650877>,
      <-0.112597, -1.263185, 0.640054>,
      < -0.110853, -1.345573, 0.354047>
    }
    triangle {
      <-0.133207, -1.333467, 0.346674>,
      <-0.110853, -1.345573, 0.354047>,
      < -0.112597, -1.263185, 0.640054>
    }
    triangle {
      <-0.112597, -1.263185, 0.640054>,
      <-0.117129, -1.224248, 0.623118>,
      < -0.133207, -1.333467, 0.346674>
    }
    triangle {
      <-0.109108, -1.427962, 0.068041>,
      <-0.070505, -1.443083, 0.078325>,
      < -0.104804, -1.369070, 0.364601>
    }
    triangle {
      <-0.104804, -1.369070, 0.364601>,
      <-0.110853, -1.345573, 0.354047>,
      < -0.109108, -1.427962, 0.068041>
    }
    triangle {
      <-0.149212, -1.442621, 0.070211>,
      <-0.109108, -1.427962, 0.068041>,
      < -0.110853, -1.345573, 0.354047>
    }
    triangle {
      <-0.110853, -1.345573, 0.354047>,
      <-0.133207, -1.333467, 0.346674>,
      < -0.149212, -1.442621, 0.070211>
    }
    triangle {
      <-0.147059, -1.281980, 0.644542>,
      <-0.112597, -1.263185, 0.640054>,
      < -0.139104, -1.295057, 0.650877>
    }
    triangle {
      <-0.181448, -1.300710, 0.649009>,
      <-0.147059, -1.281980, 0.644542>,
      < -0.139104, -1.295057, 0.650877>
    }
    triangle {
      <-0.165895, -1.250793, 0.629447>,
      <-0.117129, -1.224248, 0.623118>,
      < -0.112597, -1.263185, 0.640054>
    }
    triangle {
      <-0.112597, -1.263185, 0.640054>,
      <-0.147059, -1.281980, 0.644542>,
      < -0.165895, -1.250793, 0.629447>
    }
    triangle {
      <-0.214733, -1.277403, 0.635796>,
      <-0.165895, -1.250793, 0.629447>,
      < -0.147059, -1.281980, 0.644542>
    }
    triangle {
      <-0.147059, -1.281980, 0.644542>,
      <-0.181448, -1.300710, 0.649009>,
      < -0.214733, -1.277403, 0.635796>
    }
    triangle {
      <-0.118761, -1.390119, 0.372105>,
      <-0.181448, -1.300710, 0.649009>,
      < -0.139104, -1.295057, 0.650877>
    }
    triangle {
      <-0.139104, -1.295057, 0.650877>,
      <-0.104804, -1.369070, 0.364601>,
      < -0.118761, -1.390119, 0.372105>
    }
    triangle {
      <-0.056147, -1.479592, 0.095222>,
      <-0.118761, -1.390119, 0.372105>,
      < -0.104804, -1.369070, 0.364601>
    }
    triangle {
      <-0.104804, -1.369070, 0.364601>,
      <-0.070505, -1.443083, 0.078325>,
      < -0.056147, -1.479592, 0.095222>
    }
    triangle {
      <-0.144335, -1.396704, 0.372320>,
      <-0.214733, -1.277403, 0.635796>,
      < -0.181448, -1.300710, 0.649009>
    }
    triangle {
      <-0.181448, -1.300710, 0.649009>,
      <-0.118761, -1.390119, 0.372105>,
      < -0.144335, -1.396704, 0.372320>
    }
    triangle {
      <-0.074004, -1.515939, 0.108809>,
      <-0.144335, -1.396704, 0.372320>,
      < -0.118761, -1.390119, 0.372105>
    }
    triangle {
      <-0.118761, -1.390119, 0.372105>,
      <-0.056147, -1.479592, 0.095222>,
      < -0.074004, -1.515939, 0.108809>
    }
    triangle {
      <-0.140594, -1.504914, 0.097443>,
      <-0.167075, -1.479099, 0.083853>,
      < -0.152717, -1.515608, 0.100750>
    }
    triangle {
      <-0.114114, -1.530729, 0.111034>,
      <-0.140594, -1.504914, 0.097443>,
      < -0.152717, -1.515608, 0.100750>
    }
    triangle {
      <-0.111574, -1.479313, 0.089527>,
      <-0.149212, -1.442621, 0.070211>,
      < -0.167075, -1.479099, 0.083853>
    }
    triangle {
      <-0.167075, -1.479099, 0.083853>,
      <-0.140594, -1.504914, 0.097443>,
      < -0.111574, -1.479313, 0.089527>
    }
    triangle {
      <-0.074004, -1.515939, 0.108809>,
      <-0.111574, -1.479313, 0.089527>,
      < -0.140594, -1.504914, 0.097443>
    }
    triangle {
      <-0.140594, -1.504914, 0.097443>,
      <-0.114114, -1.530729, 0.111034>,
      < -0.074004, -1.515939, 0.108809>
    }
    triangle {
      <-0.082628, -1.453777, 0.081631>,
      <-0.056147, -1.479592, 0.095222>,
      < -0.070505, -1.443083, 0.078325>
    }
    triangle {
      <-0.109108, -1.427962, 0.068041>,
      <-0.082628, -1.453777, 0.081631>,
      < -0.070505, -1.443083, 0.078325>
    }
    triangle {
      <-0.111574, -1.479313, 0.089527>,
      <-0.074004, -1.515939, 0.108809>,
      < -0.056147, -1.479592, 0.095222>
    }
    triangle {
      <-0.056147, -1.479592, 0.095222>,
      <-0.082628, -1.453777, 0.081631>,
      < -0.111574, -1.479313, 0.089527>
    }
    triangle {
      <-0.149212, -1.442621, 0.070211>,
      <-0.111574, -1.479313, 0.089527>,
      < -0.082628, -1.453777, 0.081631>
    }
    triangle {
      <-0.082628, -1.453777, 0.081631>,
      <-0.109108, -1.427962, 0.068041>,
      < -0.149212, -1.442621, 0.070211>
    }
    triangle {
      <0.107397, -0.770686, 0.522441>,
      <0.070407, -0.790837, 0.527249>,
      < 0.098855, -0.756629, 0.515632>
    }
    triangle {
      <0.144387, -0.750535, 0.517634>,
      <0.107397, -0.770686, 0.522441>,
      < 0.098855, -0.756629, 0.515632>
    }
    triangle {
      <0.127667, -0.804227, 0.538677>,
      <0.075218, -0.832773, 0.545482>,
      < 0.070407, -0.790837, 0.527249>
    }
    triangle {
      <0.070407, -0.790837, 0.527249>,
      <0.107397, -0.770686, 0.522441>,
      < 0.127667, -0.804227, 0.538677>
    }
    triangle {
      <0.180190, -0.775615, 0.531851>,
      <0.127667, -0.804227, 0.538677>,
      < 0.107397, -0.770686, 0.522441>
    }
    triangle {
      <0.107397, -0.770686, 0.522441>,
      <0.144387, -0.750535, 0.517634>,
      < 0.180190, -0.775615, 0.531851>
    }
    triangle {
      <0.126955, -0.948006, 0.254197>,
      <0.120426, -0.922813, 0.242877>,
      < 0.098855, -0.756629, 0.515632>
    }
    triangle {
      <0.098855, -0.756629, 0.515632>,
      <0.070407, -0.790837, 0.527249>,
      < 0.126955, -0.948006, 0.254197>
    }
    triangle {
      <0.150881, -0.961098, 0.262145>,
      <0.126955, -0.948006, 0.254197>,
      < 0.070407, -0.790837, 0.527249>
    }
    triangle {
      <0.070407, -0.790837, 0.527249>,
      <0.075218, -0.832773, 0.545482>,
      < 0.150881, -0.961098, 0.262145>
    }
    triangle {
      <0.183430, -1.105240, -0.018835>,
      <0.141929, -1.088931, -0.029913>,
      < 0.120426, -0.922813, 0.242877>
    }
    triangle {
      <0.120426, -0.922813, 0.242877>,
      <0.126955, -0.948006, 0.254197>,
      < 0.183430, -1.105240, -0.018835>
    }
    triangle {
      <0.226545, -1.089422, -0.021192>,
      <0.183430, -1.105240, -0.018835>,
      < 0.126955, -0.948006, 0.254197>
    }
    triangle {
      <0.126955, -0.948006, 0.254197>,
      <0.150881, -0.961098, 0.262145>,
      < 0.226545, -1.089422, -0.021192>
    }
    triangle {
      <0.135448, -0.900075, 0.234765>,
      <0.144387, -0.750535, 0.517634>,
      < 0.098855, -0.756629, 0.515632>
    }
    triangle {
      <0.098855, -0.756629, 0.515632>,
      <0.120426, -0.922813, 0.242877>,
      < 0.135448, -0.900075, 0.234765>
    }
    triangle {
      <0.126436, -1.049679, -0.048085>,
      <0.135448, -0.900075, 0.234765>,
      < 0.120426, -0.922813, 0.242877>
    }
    triangle {
      <0.120426, -0.922813, 0.242877>,
      <0.141929, -1.088931, -0.029913>,
      < 0.126436, -1.049679, -0.048085>
    }
    triangle {
      <0.162944, -0.893043, 0.234555>,
      <0.180190, -0.775615, 0.531851>,
      < 0.144387, -0.750535, 0.517634>
    }
    triangle {
      <0.144387, -0.750535, 0.517634>,
      <0.135448, -0.900075, 0.234765>,
      < 0.162944, -0.893043, 0.234555>
    }
    triangle {
      <0.145623, -1.010535, -0.062722>,
      <0.162944, -0.893043, 0.234555>,
      < 0.135448, -0.900075, 0.234765>
    }
    triangle {
      <0.135448, -0.900075, 0.234765>,
      <0.126436, -1.049679, -0.048085>,
      < 0.145623, -1.010535, -0.062722>
    }
    triangle {
      <0.186869, -0.906135, 0.242503>,
      <0.193399, -0.931328, 0.253823>,
      < 0.156553, -0.851760, 0.561701>
    }
    triangle {
      <0.156553, -0.851760, 0.561701>,
      <0.185001, -0.817552, 0.550085>,
      < 0.186869, -0.906135, 0.242503>
    }
    triangle {
      <0.162944, -0.893043, 0.234555>,
      <0.186869, -0.906135, 0.242503>,
      < 0.185001, -0.817552, 0.550085>
    }
    triangle {
      <0.185001, -0.817552, 0.550085>,
      <0.180190, -0.775615, 0.531851>,
      < 0.162944, -0.893043, 0.234555>
    }
    triangle {
      <0.188738, -0.994717, -0.065079>,
      <0.230312, -1.010961, -0.054021>,
      < 0.193399, -0.931328, 0.253823>
    }
    triangle {
      <0.193399, -0.931328, 0.253823>,
      <0.186869, -0.906135, 0.242503>,
      < 0.188738, -0.994717, -0.065079>
    }
    triangle {
      <0.145623, -1.010535, -0.062722>,
      <0.188738, -0.994717, -0.065079>,
      < 0.186869, -0.906135, 0.242503>
    }
    triangle {
      <0.186869, -0.906135, 0.242503>,
      <0.162944, -0.893043, 0.234555>,
      < 0.145623, -1.010535, -0.062722>
    }
    triangle {
      <0.148011, -0.837703, 0.554892>,
      <0.185001, -0.817552, 0.550085>,
      < 0.156553, -0.851760, 0.561701>
    }
    triangle {
      <0.111021, -0.857853, 0.559699>,
      <0.148011, -0.837703, 0.554892>,
      < 0.156553, -0.851760, 0.561701>
    }
    triangle {
      <0.127667, -0.804227, 0.538677>,
      <0.180190, -0.775615, 0.531851>,
      < 0.185001, -0.817552, 0.550085>
    }
    triangle {
      <0.185001, -0.817552, 0.550085>,
      <0.148011, -0.837703, 0.554892>,
      < 0.127667, -0.804227, 0.538677>
    }
    triangle {
      <0.075218, -0.832773, 0.545482>,
      <0.127667, -0.804227, 0.538677>,
      < 0.148011, -0.837703, 0.554892>
    }
    triangle {
      <0.148011, -0.837703, 0.554892>,
      <0.111021, -0.857853, 0.559699>,
      < 0.075218, -0.832773, 0.545482>
    }
    triangle {
      <0.178376, -0.954066, 0.261935>,
      <0.111021, -0.857853, 0.559699>,
      < 0.156553, -0.851760, 0.561701>
    }
    triangle {
      <0.156553, -0.851760, 0.561701>,
      <0.193399, -0.931328, 0.253823>,
      < 0.178376, -0.954066, 0.261935>
    }
    triangle {
      <0.245732, -1.050279, -0.035829>,
      <0.178376, -0.954066, 0.261935>,
      < 0.193399, -0.931328, 0.253823>
    }
    triangle {
      <0.193399, -0.931328, 0.253823>,
      <0.230312, -1.010961, -0.054021>,
      < 0.245732, -1.050279, -0.035829>
    }
    triangle {
      <0.150881, -0.961098, 0.262145>,
      <0.075218, -0.832773, 0.545482>,
      < 0.111021, -0.857853, 0.559699>
    }
    triangle {
      <0.111021, -0.857853, 0.559699>,
      <0.178376, -0.954066, 0.261935>,
      < 0.150881, -0.961098, 0.262145>
    }
    triangle {
      <0.226545, -1.089422, -0.021192>,
      <0.150881, -0.961098, 0.262145>,
      < 0.178376, -0.954066, 0.261935>
    }
    triangle {
      <0.178376, -0.954066, 0.261935>,
      <0.245732, -1.050279, -0.035829>,
      < 0.226545, -1.089422, -0.021192>
    }
    triangle {
      <0.154933, -1.077460, -0.033460>,
      <0.126436, -1.049679, -0.048085>,
      < 0.141929, -1.088931, -0.029913>
    }
    triangle {
      <0.183430, -1.105240, -0.018835>,
      <0.154933, -1.077460, -0.033460>,
      < 0.141929, -1.088931, -0.029913>
    }
    triangle {
      <0.186084, -1.049979, -0.041957>,
      <0.145623, -1.010535, -0.062722>,
      < 0.126436, -1.049679, -0.048085>
    }
    triangle {
      <0.126436, -1.049679, -0.048085>,
      <0.154933, -1.077460, -0.033460>,
      < 0.186084, -1.049979, -0.041957>
    }
    triangle {
      <0.226545, -1.089422, -0.021192>,
      <0.186084, -1.049979, -0.041957>,
      < 0.154933, -1.077460, -0.033460>
    }
    triangle {
      <0.154933, -1.077460, -0.033460>,
      <0.183430, -1.105240, -0.018835>,
      < 0.226545, -1.089422, -0.021192>
    }
    triangle {
      <0.217235, -1.022498, -0.050454>,
      <0.245732, -1.050279, -0.035829>,
      < 0.230312, -1.010961, -0.054021>
    }
    triangle {
      <0.188738, -0.994717, -0.065079>,
      <0.217235, -1.022498, -0.050454>,
      < 0.230312, -1.010961, -0.054021>
    }
    triangle {
      <0.186084, -1.049979, -0.041957>,
      <0.226545, -1.089422, -0.021192>,
      < 0.245732, -1.050279, -0.035829>
    }
    triangle {
      <0.245732, -1.050279, -0.035829>,
      <0.217235, -1.022498, -0.050454>,
      < 0.186084, -1.049979, -0.041957>
    }
    triangle {
      <0.145623, -1.010535, -0.062722>,
      <0.186084, -1.049979, -0.041957>,
      < 0.217235, -1.022498, -0.050454>
    }
    triangle {
      <0.217235, -1.022498, -0.050454>,
      <0.188738, -0.994717, -0.065079>,
      < 0.145623, -1.010535, -0.062722>
    }
    triangle {
      <0.362995, -0.318899, 0.323350>,
      <0.323190, -0.340535, 0.328503>,
      < 0.353800, -0.303795, 0.316033>
    }
    triangle {
      <0.402733, -0.297197, 0.318163>,
      <0.362995, -0.318899, 0.323350>,
      < 0.353800, -0.303795, 0.316033>
    }
    triangle {
      <0.384767, -0.354859, 0.340761>,
      <0.328413, -0.385602, 0.348103>,
      < 0.323190, -0.340535, 0.328503>
    }
    triangle {
      <0.323190, -0.340535, 0.328503>,
      <0.362995, -0.318899, 0.323350>,
      < 0.384767, -0.354859, 0.340761>
    }
    triangle {
      <0.441189, -0.324181, 0.333453>,
      <0.384767, -0.354859, 0.340761>,
      < 0.362995, -0.318899, 0.323350>
    }
    triangle {
      <0.362995, -0.318899, 0.323350>,
      <0.402733, -0.297197, 0.318163>,
      < 0.441189, -0.324181, 0.333453>
    }
    triangle {
      <0.383974, -0.509416, 0.035098>,
      <0.376902, -0.482330, 0.022922>,
      < 0.353800, -0.303795, 0.316033>
    }
    triangle {
      <0.353800, -0.303795, 0.316033>,
      <0.323190, -0.340535, 0.328503>,
      < 0.383974, -0.509416, 0.035098>
    }
    triangle {
      <0.409685, -0.523429, 0.043616>,
      <0.383974, -0.509416, 0.035098>,
      < 0.323190, -0.340535, 0.328503>
    }
    triangle {
      <0.323190, -0.340535, 0.328503>,
      <0.328413, -0.385602, 0.348103>,
      < 0.409685, -0.523429, 0.043616>
    }
    triangle {
      <0.444694, -0.678401, -0.258379>,
      <0.400013, -0.660903, -0.270280>,
      < 0.376902, -0.482330, 0.022922>
    }
    triangle {
      <0.376902, -0.482330, 0.022922>,
      <0.383974, -0.509416, 0.035098>,
      < 0.444694, -0.678401, -0.258379>
    }
    triangle {
      <0.491033, -0.661361, -0.260929>,
      <0.444694, -0.678401, -0.258379>,
      < 0.383974, -0.509416, 0.035098>
    }
    triangle {
      <0.383974, -0.509416, 0.035098>,
      <0.409685, -0.523429, 0.043616>,
      < 0.491033, -0.661361, -0.260929>
    }
    triangle {
      <0.393058, -0.457967, 0.014236>,
      <0.402733, -0.297197, 0.318163>,
      < 0.353800, -0.303795, 0.316033>
    }
    triangle {
      <0.353800, -0.303795, 0.316033>,
      <0.376902, -0.482330, 0.022922>,
      < 0.393058, -0.457967, 0.014236>
    }
    triangle {
      <0.383465, -0.618711, -0.289802>,
      <0.393058, -0.457967, 0.014236>,
      < 0.376902, -0.482330, 0.022922>
    }
    triangle {
      <0.376902, -0.482330, 0.022922>,
      <0.400013, -0.660903, -0.270280>,
      < 0.383465, -0.618711, -0.289802>
    }
    triangle {
      <0.422621, -0.450359, 0.013991>,
      <0.441189, -0.324181, 0.333453>,
      < 0.402733, -0.297197, 0.318163>
    }
    triangle {
      <0.402733, -0.297197, 0.318163>,
      <0.393058, -0.457967, 0.014236>,
      < 0.422621, -0.450359, 0.013991>
    }
    triangle {
      <0.404130, -0.576642, -0.305529>,
      <0.422621, -0.450359, 0.013991>,
      < 0.393058, -0.457967, 0.014236>
    }
    triangle {
      <0.393058, -0.457967, 0.014236>,
      <0.383465, -0.618711, -0.289802>,
      < 0.404130, -0.576642, -0.305529>
    }
    triangle {
      <0.448399, -0.464438, 0.022543>,
      <0.455471, -0.491525, 0.034719>,
      < 0.415802, -0.405988, 0.365523>
    }
    triangle {
      <0.415802, -0.405988, 0.365523>,
      <0.446412, -0.369249, 0.353053>,
      < 0.448399, -0.464438, 0.022543>
    }
    triangle {
      <0.422621, -0.450359, 0.013991>,
      <0.448399, -0.464438, 0.022543>,
      < 0.446412, -0.369249, 0.353053>
    }
    triangle {
      <0.446412, -0.369249, 0.353053>,
      <0.441189, -0.324181, 0.333453>,
      < 0.422621, -0.450359, 0.013991>
    }
    triangle {
      <0.450469, -0.559602, -0.308079>,
      <0.495082, -0.577035, -0.296212>,
      < 0.455471, -0.491525, 0.034719>
    }
    triangle {
      <0.455471, -0.491525, 0.034719>,
      <0.448399, -0.464438, 0.022543>,
      < 0.450469, -0.559602, -0.308079>
    }
    triangle {
      <0.404130, -0.576642, -0.305529>,
      <0.450469, -0.559602, -0.308079>,
      < 0.448399, -0.464438, 0.022543>
    }
    triangle {
      <0.448399, -0.464438, 0.022543>,
      <0.422621, -0.450359, 0.013991>,
      < 0.404130, -0.576642, -0.305529>
    }
    triangle {
      <0.406607, -0.390884, 0.358206>,
      <0.446412, -0.369249, 0.353053>,
      < 0.415802, -0.405988, 0.365523>
    }
    triangle {
      <0.366875, -0.412455, 0.363338>,
      <0.406607, -0.390884, 0.358206>,
      < 0.415802, -0.405988, 0.365523>
    }
    triangle {
      <0.384767, -0.354859, 0.340761>,
      <0.441189, -0.324181, 0.333453>,
      < 0.446412, -0.369249, 0.353053>
    }
    triangle {
      <0.446412, -0.369249, 0.353053>,
      <0.406607, -0.390884, 0.358206>,
      < 0.384767, -0.354859, 0.340761>
    }
    triangle {
      <0.328413, -0.385602, 0.348103>,
      <0.384767, -0.354859, 0.340761>,
      < 0.406607, -0.390884, 0.358206>
    }
    triangle {
      <0.406607, -0.390884, 0.358206>,
      <0.366875, -0.412455, 0.363338>,
      < 0.328413, -0.385602, 0.348103>
    }
    triangle {
      <0.439315, -0.515887, 0.043404>,
      <0.366875, -0.412455, 0.363338>,
      < 0.415802, -0.405988, 0.365523>
    }
    triangle {
      <0.415802, -0.405988, 0.365523>,
      <0.455471, -0.491525, 0.034719>,
      < 0.439315, -0.515887, 0.043404>
    }
    triangle {
      <0.511697, -0.619291, -0.276656>,
      <0.439315, -0.515887, 0.043404>,
      < 0.455471, -0.491525, 0.034719>
    }
    triangle {
      <0.455471, -0.491525, 0.034719>,
      <0.495082, -0.577035, -0.296212>,
      < 0.511697, -0.619291, -0.276656>
    }
    triangle {
      <0.409685, -0.523429, 0.043616>,
      <0.328413, -0.385602, 0.348103>,
      < 0.366875, -0.412455, 0.363338>
    }
    triangle {
      <0.366875, -0.412455, 0.363338>,
      <0.439315, -0.515887, 0.043404>,
      < 0.409685, -0.523429, 0.043616>
    }
    triangle {
      <0.491033, -0.661361, -0.260929>,
      <0.409685, -0.523429, 0.043616>,
      < 0.439315, -0.515887, 0.043404>
    }
    triangle {
      <0.439315, -0.515887, 0.043404>,
      <0.511697, -0.619291, -0.276656>,
      < 0.491033, -0.661361, -0.260929>
    }
    triangle {
      <0.414046, -0.648523, -0.274108>,
      <0.383465, -0.618711, -0.289802>,
      < 0.400013, -0.660903, -0.270280>
    }
    triangle {
      <0.444694, -0.678401, -0.258379>,
      <0.414046, -0.648523, -0.274108>,
      < 0.400013, -0.660903, -0.270280>
    }
    triangle {
      <0.447548, -0.618969, -0.283246>,
      <0.404130, -0.576642, -0.305529>,
      < 0.383465, -0.618711, -0.289802>
    }
    triangle {
      <0.383465, -0.618711, -0.289802>,
      <0.414046, -0.648523, -0.274108>,
      < 0.447548, -0.618969, -0.283246>
    }
    triangle {
      <0.491033, -0.661361, -0.260929>,
      <0.447548, -0.618969, -0.283246>,
      < 0.414046, -0.648523, -0.274108>
    }
    triangle {
      <0.414046, -0.648523, -0.274108>,
      <0.444694, -0.678401, -0.258379>,
      < 0.491033, -0.661361, -0.260929>
    }
    triangle {
      <0.481050, -0.589414, -0.292385>,
      <0.511697, -0.619291, -0.276656>,
      < 0.495082, -0.577035, -0.296212>
    }
    triangle {
      <0.450469, -0.559602, -0.308079>,
      <0.481050, -0.589414, -0.292385>,
      < 0.495082, -0.577035, -0.296212>
    }
    triangle {
      <0.447548, -0.618969, -0.283246>,
      <0.491033, -0.661361, -0.260929>,
      < 0.511697, -0.619291, -0.276656>
    }
    triangle {
      <0.511697, -0.619291, -0.276656>,
      <0.481050, -0.589414, -0.292385>,
      < 0.447548, -0.618969, -0.283246>
    }
    triangle {
      <0.404130, -0.576642, -0.305529>,
      <0.447548, -0.618969, -0.283246>,
      < 0.481050, -0.589414, -0.292385>
    }
    triangle {
      <0.481050, -0.589414, -0.292385>,
      <0.450469, -0.559602, -0.308079>,
      < 0.404130, -0.576642, -0.305529>
    }
    triangle {
      <0.663273, 0.147517, 0.207624>,
      <0.630689, 0.129756, 0.211864>,
      < 0.655126, 0.159551, 0.201711>
    }
    triangle {
      <0.695783, 0.165213, 0.203405>,
      <0.663273, 0.147517, 0.207624>,
      < 0.655126, 0.159551, 0.201711>
    }
    triangle {
      <0.680415, 0.117707, 0.221966>,
      <0.634251, 0.092584, 0.227955>,
      < 0.630689, 0.129756, 0.211864>
    }
    triangle {
      <0.630689, 0.129756, 0.211864>,
      <0.663273, 0.147517, 0.207624>,
      < 0.680415, 0.117707, 0.221966>
    }
    triangle {
      <0.726653, 0.142896, 0.215957>,
      <0.680415, 0.117707, 0.221966>,
      < 0.663273, 0.147517, 0.207624>
    }
    triangle {
      <0.663273, 0.147517, 0.207624>,
      <0.695783, 0.165213, 0.203405>,
      < 0.726653, 0.142896, 0.215957>
    }
    triangle {
      <0.680121, -0.008736, -0.028369>,
      <0.674004, 0.013326, -0.038322>,
      < 0.655126, 0.159551, 0.201711>
    }
    triangle {
      <0.655126, 0.159551, 0.201711>,
      <0.630689, 0.129756, 0.211864>,
      < 0.680121, -0.008736, -0.028369>
    }
    triangle {
      <0.700880, -0.020378, -0.021353>,
      <0.680121, -0.008736, -0.028369>,
      < 0.630689, 0.129756, 0.211864>
    }
    triangle {
      <0.630689, 0.129756, 0.211864>,
      <0.634251, 0.092584, 0.227955>,
      < 0.700880, -0.020378, -0.021353>
    }
    triangle {
      <0.729477, -0.147124, -0.268544>,
      <0.692946, -0.132796, -0.278284>,
      < 0.674004, 0.013326, -0.038322>
    }
    triangle {
      <0.674004, 0.013326, -0.038322>,
      <0.680121, -0.008736, -0.028369>,
      < 0.729477, -0.147124, -0.268544>
    }
    triangle {
      <0.767433, -0.133236, -0.270604>,
      <0.729477, -0.147124, -0.268544>,
      < 0.680121, -0.008736, -0.028369>
    }
    triangle {
      <0.680121, -0.008736, -0.028369>,
      <0.700880, -0.020378, -0.021353>,
      < 0.767433, -0.133236, -0.270604>
    }
    triangle {
      <0.687635, 0.033464, -0.045474>,
      <0.695783, 0.165213, 0.203405>,
      < 0.655126, 0.159551, 0.201711>
    }
    triangle {
      <0.655126, 0.159551, 0.201711>,
      <0.674004, 0.013326, -0.038322>,
      < 0.687635, 0.033464, -0.045474>
    }
    triangle {
      <0.679338, -0.098246, -0.294277>,
      <0.687635, 0.033464, -0.045474>,
      < 0.674004, 0.013326, -0.038322>
    }
    triangle {
      <0.674004, 0.013326, -0.038322>,
      <0.692946, -0.132796, -0.278284>,
      < 0.679338, -0.098246, -0.294277>
    }
    triangle {
      <0.711497, 0.039536, -0.045644>,
      <0.726653, 0.142896, 0.215957>,
      < 0.695783, 0.165213, 0.203405>
    }
    triangle {
      <0.695783, 0.165213, 0.203405>,
      <0.687635, 0.033464, -0.045474>,
      < 0.711497, 0.039536, -0.045644>
    }
    triangle {
      <0.696257, -0.063849, -0.307133>,
      <0.711497, 0.039536, -0.045644>,
      < 0.687635, 0.033464, -0.045474>
    }
    triangle {
      <0.687635, 0.033464, -0.045474>,
      <0.679338, -0.098246, -0.294277>,
      < 0.696257, -0.063849, -0.307133>
    }
    triangle {
      <0.731483, 0.026464, -0.038100>,
      <0.735581, 0.003369, -0.027913>,
      < 0.700335, 0.071001, 0.243738>
    }
    triangle {
      <0.700335, 0.071001, 0.243738>,
      <0.728671, 0.102864, 0.233103>,
      < 0.731483, 0.026464, -0.038100>
    }
    triangle {
      <0.711497, 0.039536, -0.045644>,
      <0.731483, 0.026464, -0.038100>,
      < 0.728671, 0.102864, 0.233103>
    }
    triangle {
      <0.728671, 0.102864, 0.233103>,
      <0.726653, 0.142896, 0.215957>,
      < 0.711497, 0.039536, -0.045644>
    }
    triangle {
      <0.734219, -0.049830, -0.309247>,
      <0.770750, -0.064159, -0.299507>,
      < 0.735581, 0.003369, -0.027913>
    }
    triangle {
      <0.735581, 0.003369, -0.027913>,
      <0.731483, 0.026464, -0.038100>,
      < 0.734219, -0.049830, -0.309247>
    }
    triangle {
      <0.696257, -0.063849, -0.307133>,
      <0.734219, -0.049830, -0.309247>,
      < 0.731483, 0.026464, -0.038100>
    }
    triangle {
      <0.731483, 0.026464, -0.038100>,
      <0.711497, 0.039536, -0.045644>,
      < 0.696257, -0.063849, -0.307133>
    }
    triangle {
      <0.696125, 0.085884, 0.237015>,
      <0.728671, 0.102864, 0.233103>,
      < 0.700335, 0.071001, 0.243738>
    }
    triangle {
      <0.662569, 0.068389, 0.241044>,
      <0.696125, 0.085884, 0.237015>,
      < 0.700335, 0.071001, 0.243738>
    }
    triangle {
      <0.680415, 0.117707, 0.221966>,
      <0.726653, 0.142896, 0.215957>,
      < 0.728671, 0.102864, 0.233103>
    }
    triangle {
      <0.728671, 0.102864, 0.233103>,
      <0.696125, 0.085884, 0.237015>,
      < 0.680415, 0.117707, 0.221966>
    }
    triangle {
      <0.634251, 0.092584, 0.227955>,
      <0.680415, 0.117707, 0.221966>,
      < 0.696125, 0.085884, 0.237015>
    }
    triangle {
      <0.696125, 0.085884, 0.237015>,
      <0.662569, 0.068389, 0.241044>,
      < 0.634251, 0.092584, 0.227955>
    }
    triangle {
      <0.723505, -0.015147, -0.021291>,
      <0.662569, 0.068389, 0.241044>,
      < 0.700335, 0.071001, 0.243738>
    }
    triangle {
      <0.700335, 0.071001, 0.243738>,
      <0.735581, 0.003369, -0.027913>,
      < 0.723505, -0.015147, -0.021291>
    }
    triangle {
      <0.784358, -0.098709, -0.283515>,
      <0.723505, -0.015147, -0.021291>,
      < 0.735581, 0.003369, -0.027913>
    }
    triangle {
      <0.735581, 0.003369, -0.027913>,
      <0.770750, -0.064159, -0.299507>,
      < 0.784358, -0.098709, -0.283515>
    }
    triangle {
      <0.700880, -0.020378, -0.021353>,
      <0.634251, 0.092584, 0.227955>,
      < 0.662569, 0.068389, 0.241044>
    }
    triangle {
      <0.662569, 0.068389, 0.241044>,
      <0.723505, -0.015147, -0.021291>,
      < 0.700880, -0.020378, -0.021353>
    }
    triangle {
      <0.767433, -0.133236, -0.270604>,
      <0.700880, -0.020378, -0.021353>,
      < 0.723505, -0.015147, -0.021291>
    }
    triangle {
      <0.723505, -0.015147, -0.021291>,
      <0.784358, -0.098709, -0.283515>,
      < 0.767433, -0.133236, -0.270604>
    }
    triangle {
      <0.704408, -0.122685, -0.281410>,
      <0.679338, -0.098246, -0.294277>,
      < 0.692946, -0.132796, -0.278284>
    }
    triangle {
      <0.729477, -0.147124, -0.268544>,
      <0.704408, -0.122685, -0.281410>,
      < 0.692946, -0.132796, -0.278284>
    }
    triangle {
      <0.731811, -0.098510, -0.288885>,
      <0.696257, -0.063849, -0.307133>,
      < 0.679338, -0.098246, -0.294277>
    }
    triangle {
      <0.679338, -0.098246, -0.294277>,
      <0.704408, -0.122685, -0.281410>,
      < 0.731811, -0.098510, -0.288885>
    }
    triangle {
      <0.767433, -0.133236, -0.270604>,
      <0.731811, -0.098510, -0.288885>,
      < 0.704408, -0.122685, -0.281410>
    }
    triangle {
      <0.704408, -0.122685, -0.281410>,
      <0.729477, -0.147124, -0.268544>,
      < 0.767433, -0.133236, -0.270604>
    }
    triangle {
      <0.759289, -0.074270, -0.296381>,
      <0.784358, -0.098709, -0.283515>,
      < 0.770750, -0.064159, -0.299507>
    }
    triangle {
      <0.734219, -0.049830, -0.309247>,
      <0.759289, -0.074270, -0.296381>,
      < 0.770750, -0.064159, -0.299507>
    }
    triangle {
      <0.731811, -0.098510, -0.288885>,
      <0.767433, -0.133236, -0.270604>,
      < 0.784358, -0.098709, -0.283515>
    }
    triangle {
      <0.784358, -0.098709, -0.283515>,
      <0.759289, -0.074270, -0.296381>,
      < 0.731811, -0.098510, -0.288885>
    }
    triangle {
      <0.696257, -0.063849, -0.307133>,
      <0.731811, -0.098510, -0.288885>,
      < 0.759289, -0.074270, -0.296381>
    }
    triangle {
      <0.759289, -0.074270, -0.296381>,
      <0.734219, -0.049830, -0.309247>,
      < 0.696257, -0.063849, -0.307133>
    }
    triangle {
      <0.751646, 0.676661, 0.110225>,
      <0.717788, 0.667510, 0.110691>,
      < 0.756146, 0.708838, 0.097058>
    }
    triangle {
      <0.786863, 0.686261, 0.109705>,
      <0.751646, 0.676661, 0.110225>,
      < 0.756146, 0.708838, 0.097058>
    }
    triangle {
      <0.764774, 0.621841, 0.134748>,
      <0.725444, 0.610111, 0.135756>,
      < 0.717788, 0.667510, 0.110691>
    }
    triangle {
      <0.717788, 0.667510, 0.110691>,
      <0.751646, 0.676661, 0.110225>,
      < 0.764774, 0.621841, 0.134748>
    }
    triangle {
      <0.804244, 0.633571, 0.133754>,
      <0.764774, 0.621841, 0.134748>,
      < 0.751646, 0.676661, 0.110225>
    }
    triangle {
      <0.751646, 0.676661, 0.110225>,
      <0.786863, 0.686261, 0.109705>,
      < 0.804244, 0.633571, 0.133754>
    }
    triangle {
      <0.762604, 0.584984, 0.047510>,
      <0.754815, 0.616180, 0.033523>,
      < 0.756146, 0.708838, 0.097058>
    }
    triangle {
      <0.756146, 0.708838, 0.097058>,
      <0.717788, 0.667510, 0.110691>,
      < 0.762604, 0.584984, 0.047510>
    }
    triangle {
      <0.794433, 0.566507, 0.058533>,
      <0.762604, 0.584984, 0.047510>,
      < 0.717788, 0.667510, 0.110691>
    }
    triangle {
      <0.717788, 0.667510, 0.110691>,
      <0.725444, 0.610111, 0.135756>,
      < 0.794433, 0.566507, 0.058533>
    }
    triangle {
      <0.807497, 0.502353, -0.015728>,
      <0.753493, 0.523483, -0.030104>,
      < 0.754815, 0.616180, 0.033523>
    }
    triangle {
      <0.754815, 0.616180, 0.033523>,
      <0.762604, 0.584984, 0.047510>,
      < 0.807497, 0.502353, -0.015728>
    }
    triangle {
      <0.863363, 0.522930, -0.018817>,
      <0.807497, 0.502353, -0.015728>,
      < 0.762604, 0.584984, 0.047510>
    }
    triangle {
      <0.762604, 0.584984, 0.047510>,
      <0.794433, 0.566507, 0.058533>,
      < 0.863363, 0.522930, -0.018817>
    }
    triangle {
      <0.760140, 0.630363, 0.028056>,
      <0.786863, 0.686261, 0.109705>,
      < 0.756146, 0.708838, 0.097058>
    }
    triangle {
      <0.756146, 0.708838, 0.097058>,
      <0.754815, 0.616180, 0.033523>,
      < 0.760140, 0.630363, 0.028056>
    }
    triangle {
      <0.733498, 0.574491, -0.053705>,
      <0.760140, 0.630363, 0.028056>,
      < 0.754815, 0.616180, 0.033523>
    }
    triangle {
      <0.754815, 0.616180, 0.033523>,
      <0.753493, 0.523483, -0.030104>,
      < 0.733498, 0.574491, -0.053705>
    }
    triangle {
      <0.781271, 0.629409, 0.030585>,
      <0.804244, 0.633571, 0.133754>,
      < 0.786863, 0.686261, 0.109705>
    }
    triangle {
      <0.786863, 0.686261, 0.109705>,
      <0.760140, 0.630363, 0.028056>,
      < 0.781271, 0.629409, 0.030585>
    }
    triangle {
      <0.758448, 0.625208, -0.072661>,
      <0.781271, 0.629409, 0.030585>,
      < 0.760140, 0.630363, 0.028056>
    }
    triangle {
      <0.760140, 0.630363, 0.028056>,
      <0.733498, 0.574491, -0.053705>,
      < 0.758448, 0.625208, -0.072661>
    }
    triangle {
      <0.822174, 0.625553, 0.036332>,
      <0.849615, 0.605078, 0.047759>,
      < 0.830994, 0.585527, 0.156780>
    }
    triangle {
      <0.830994, 0.585527, 0.156780>,
      <0.830037, 0.605152, 0.148377>,
      < 0.822174, 0.625553, 0.036332>
    }
    triangle {
      <0.781271, 0.629409, 0.030585>,
      <0.822174, 0.625553, 0.036332>,
      < 0.830037, 0.605152, 0.148377>
    }
    triangle {
      <0.830037, 0.605152, 0.148377>,
      <0.804244, 0.633571, 0.133754>,
      < 0.781271, 0.629409, 0.030585>
    }
    triangle {
      <0.814388, 0.645850, -0.075770>,
      <0.868251, 0.624721, -0.061408>,
      < 0.849615, 0.605078, 0.047759>
    }
    triangle {
      <0.849615, 0.605078, 0.047759>,
      <0.822174, 0.625553, 0.036332>,
      < 0.814388, 0.645850, -0.075770>
    }
    triangle {
      <0.758448, 0.625208, -0.072661>,
      <0.814388, 0.645850, -0.075770>,
      < 0.822174, 0.625553, 0.036332>
    }
    triangle {
      <0.822174, 0.625553, 0.036332>,
      <0.781271, 0.629409, 0.030585>,
      < 0.758448, 0.625208, -0.072661>
    }
    triangle {
      <0.797679, 0.592083, 0.150653>,
      <0.830037, 0.605152, 0.148377>,
      < 0.830994, 0.585527, 0.156780>
    }
    triangle {
      <0.770533, 0.580617, 0.152775>,
      <0.797679, 0.592083, 0.150653>,
      < 0.830994, 0.585527, 0.156780>
    }
    triangle {
      <0.764774, 0.621841, 0.134748>,
      <0.804244, 0.633571, 0.133754>,
      < 0.830037, 0.605152, 0.148377>
    }
    triangle {
      <0.830037, 0.605152, 0.148377>,
      <0.797679, 0.592083, 0.150653>,
      < 0.764774, 0.621841, 0.134748>
    }
    triangle {
      <0.725444, 0.610111, 0.135756>,
      <0.764774, 0.621841, 0.134748>,
      < 0.797679, 0.592083, 0.150653>
    }
    triangle {
      <0.797679, 0.592083, 0.150653>,
      <0.770533, 0.580617, 0.152775>,
      < 0.725444, 0.610111, 0.135756>
    }
    triangle {
      <0.829418, 0.577151, 0.057547>,
      <0.770533, 0.580617, 0.152775>,
      < 0.830994, 0.585527, 0.156780>
    }
    triangle {
      <0.830994, 0.585527, 0.156780>,
      <0.849615, 0.605078, 0.047759>,
      < 0.829418, 0.577151, 0.057547>
    }
    triangle {
      <0.888386, 0.573712, -0.037792>,
      <0.829418, 0.577151, 0.057547>,
      < 0.849615, 0.605078, 0.047759>
    }
    triangle {
      <0.849615, 0.605078, 0.047759>,
      <0.868251, 0.624721, -0.061408>,
      < 0.888386, 0.573712, -0.037792>
    }
    triangle {
      <0.794433, 0.566507, 0.058533>,
      <0.725444, 0.610111, 0.135756>,
      < 0.770533, 0.580617, 0.152775>
    }
    triangle {
      <0.770533, 0.580617, 0.152775>,
      <0.829418, 0.577151, 0.057547>,
      < 0.794433, 0.566507, 0.058533>
    }
    triangle {
      <0.863363, 0.522930, -0.018817>,
      <0.794433, 0.566507, 0.058533>,
      < 0.829418, 0.577151, 0.057547>
    }
    triangle {
      <0.829418, 0.577151, 0.057547>,
      <0.888386, 0.573712, -0.037792>,
      < 0.863363, 0.522930, -0.018817>
    }
    triangle {
      <0.770464, 0.538455, -0.034734>,
      <0.733498, 0.574491, -0.053705>,
      < 0.753493, 0.523483, -0.030104>
    }
    triangle {
      <0.807497, 0.502353, -0.015728>,
      <0.770464, 0.538455, -0.034734>,
      < 0.753493, 0.523483, -0.030104>
    }
    triangle {
      <0.810872, 0.574102, -0.045756>,
      <0.758448, 0.625208, -0.072661>,
      < 0.733498, 0.574491, -0.053705>
    }
    triangle {
      <0.733498, 0.574491, -0.053705>,
      <0.770464, 0.538455, -0.034734>,
      < 0.810872, 0.574102, -0.045756>
    }
    triangle {
      <0.863363, 0.522930, -0.018817>,
      <0.810872, 0.574102, -0.045756>,
      < 0.770464, 0.538455, -0.034734>
    }
    triangle {
      <0.770464, 0.538455, -0.034734>,
      <0.807497, 0.502353, -0.015728>,
      < 0.863363, 0.522930, -0.018817>
    }
    triangle {
      <0.851353, 0.609814, -0.056798>,
      <0.888386, 0.573712, -0.037792>,
      < 0.868251, 0.624721, -0.061408>
    }
    triangle {
      <0.814388, 0.645850, -0.075770>,
      <0.851353, 0.609814, -0.056798>,
      < 0.868251, 0.624721, -0.061408>
    }
    triangle {
      <0.810872, 0.574102, -0.045756>,
      <0.863363, 0.522930, -0.018817>,
      < 0.888386, 0.573712, -0.037792>
    }
    triangle {
      <0.888386, 0.573712, -0.037792>,
      <0.851353, 0.609814, -0.056798>,
      < 0.810872, 0.574102, -0.045756>
    }
    triangle {
      <0.758448, 0.625208, -0.072661>,
      <0.810872, 0.574102, -0.045756>,
      < 0.851353, 0.609814, -0.056798>
    }
    triangle {
      <0.851353, 0.609814, -0.056798>,
      <0.814388, 0.645850, -0.075770>,
      < 0.758448, 0.625208, -0.072661>
    }
    triangle {
      <-1.630249, -0.514061, -0.430147>,
      <-1.390209, -0.179105, -0.425409>,
      < -1.451402, -0.150860, -0.460096>
    }
    triangle {
      <-1.451402, -0.150860, -0.460096>,
      <-1.942279, -0.566613, -0.424684>,
      < -1.630249, -0.514061, -0.430147>
    }
    triangle {
      <-1.718792, -0.868435, -0.469223>,
      <-1.630249, -0.514061, -0.430147>,
      < -1.942279, -0.566613, -0.424684>
    }
    triangle {
      <-1.942279, -0.566613, -0.424684>,
      <-2.091436, -1.038601, -0.435128>,
      < -1.718792, -0.868435, -0.469223>
    }
    triangle {
      <-1.288902, -0.322314, -0.453297>,
      <-1.327190, -0.248261, -0.425022>,
      < -1.390209, -0.179105, -0.425409>
    }
    triangle {
      <-1.390209, -0.179105, -0.425409>,
      <-1.630249, -0.514061, -0.430147>,
      < -1.288902, -0.322314, -0.453297>
    }
    triangle {
      <-1.289231, -0.379149, -0.504085>,
      <-1.288902, -0.322314, -0.453297>,
      < -1.630249, -0.514061, -0.430147>
    }
    triangle {
      <-1.630249, -0.514061, -0.430147>,
      <-1.718792, -0.868435, -0.469223>,
      < -1.289231, -0.379149, -0.504085>
    }
    triangle {
      <-1.681258, -0.487653, -0.458888>,
      <-1.468263, -0.220887, -0.538808>,
      < -1.451402, -0.150860, -0.460096>
    }
    triangle {
      <-1.451402, -0.150860, -0.460096>,
      <-1.390209, -0.179105, -0.425409>,
      < -1.681258, -0.487653, -0.458888>
    }
    triangle {
      <-1.748161, -0.671085, -0.320369>,
      <-1.681258, -0.487653, -0.458888>,
      < -1.390209, -0.179105, -0.425409>
    }
    triangle {
      <-1.390209, -0.179105, -0.425409>,
      <-1.327190, -0.248261, -0.425022>,
      < -1.748161, -0.671085, -0.320369>
    }
    triangle {
      <-1.907878, -0.779944, -0.587316>,
      <-1.434064, -0.313655, -0.587708>,
      < -1.468263, -0.220887, -0.538808>
    }
    triangle {
      <-1.468263, -0.220887, -0.538808>,
      <-1.681258, -0.487653, -0.458888>,
      < -1.907878, -0.779944, -0.587316>
    }
    triangle {
      <-2.091436, -1.038601, -0.435128>,
      <-1.907878, -0.779944, -0.587316>,
      < -1.681258, -0.487653, -0.458888>
    }
    triangle {
      <-1.681258, -0.487653, -0.458888>,
      <-1.748161, -0.671085, -0.320369>,
      < -2.091436, -1.038601, -0.435128>
    }
    triangle {
      <-1.719760, -0.411234, -0.363370>,
      <-1.942279, -0.566613, -0.424684>,
      < -1.451402, -0.150860, -0.460096>
    }
    triangle {
      <-1.390209, -0.179105, -0.425409>,
      <-1.719760, -0.411234, -0.363370>,
      < -1.451402, -0.150860, -0.460096>
    }
    triangle {
      <-1.748161, -0.671085, -0.320369>,
      <-2.091436, -1.038601, -0.435128>,
      < -1.942279, -0.566613, -0.424684>
    }
    triangle {
      <-1.942279, -0.566613, -0.424684>,
      <-1.719760, -0.411234, -0.363370>,
      < -1.748161, -0.671085, -0.320369>
    }
    triangle {
      <-1.327190, -0.248261, -0.425022>,
      <-1.748161, -0.671085, -0.320369>,
      < -1.719760, -0.411234, -0.363370>
    }
    triangle {
      <-1.719760, -0.411234, -0.363370>,
      <-1.390209, -0.179105, -0.425409>,
      < -1.327190, -0.248261, -0.425022>
    }
    triangle {
      <-0.717497, 0.092660, -0.543310>,
      <-0.770716, 0.135722, -0.528285>,
      < -1.451402, -0.150860, -0.460096>
    }
    triangle {
      <-1.451402, -0.150860, -0.460096>,
      <-1.390209, -0.179105, -0.425409>,
      < -0.717497, 0.092660, -0.543310>
    }
    triangle {
      <-0.680089, 0.038775, -0.599402>,
      <-0.717497, 0.092660, -0.543310>,
      < -1.390209, -0.179105, -0.425409>
    }
    triangle {
      <-1.390209, -0.179105, -0.425409>,
      <-1.327190, -0.248261, -0.425022>,
      < -0.680089, 0.038775, -0.599402>
    }
    triangle {
      <-0.036027, 0.335456, -0.566606>,
      <-0.077718, 0.387309, -0.511829>,
      < -0.770716, 0.135722, -0.528285>
    }
    triangle {
      <-0.770716, 0.135722, -0.528285>,
      <-0.717497, 0.092660, -0.543310>,
      < -0.036027, 0.335456, -0.566606>
    }
    triangle {
      <-0.027660, 0.302945, -0.669018>,
      <-0.036027, 0.335456, -0.566606>,
      < -0.717497, 0.092660, -0.543310>
    }
    triangle {
      <-0.717497, 0.092660, -0.543310>,
      <-0.680089, 0.038775, -0.599402>,
      < -0.027660, 0.302945, -0.669018>
    }
    triangle {
      <-1.678441, -0.542015, -0.502119>,
      <-1.942279, -0.566613, -0.424684>,
      < -1.451402, -0.150860, -0.460096>
    }
    triangle {
      <-1.451402, -0.150860, -0.460096>,
      <-1.468263, -0.220887, -0.538808>,
      < -1.678441, -0.542015, -0.502119>
    }
    triangle {
      <-1.360686, -0.369143, -0.565019>,
      <-1.678441, -0.542015, -0.502119>,
      < -1.468263, -0.220887, -0.538808>
    }
    triangle {
      <-1.468263, -0.220887, -0.538808>,
      <-1.434064, -0.313655, -0.587708>,
      < -1.360686, -0.369143, -0.565019>
    }
    triangle {
      <-1.718792, -0.868435, -0.469223>,
      <-2.091436, -1.038601, -0.435128>,
      < -1.942279, -0.566613, -0.424684>
    }
    triangle {
      <-1.942279, -0.566613, -0.424684>,
      <-1.678441, -0.542015, -0.502119>,
      < -1.718792, -0.868435, -0.469223>
    }
    triangle {
      <-1.289231, -0.379149, -0.504085>,
      <-1.718792, -0.868435, -0.469223>,
      < -1.678441, -0.542015, -0.502119>
    }
    triangle {
      <-1.678441, -0.542015, -0.502119>,
      <-1.360686, -0.369143, -0.565019>,
      < -1.289231, -0.379149, -0.504085>
    }
    triangle {
      <-0.817795, 0.130855, -0.611334>,
      <-0.770716, 0.135722, -0.528285>,
      < -1.451402, -0.150860, -0.460096>
    }
    triangle {
      <-1.451402, -0.150860, -0.460096>,
      <-1.468263, -0.220887, -0.538808>,
      < -0.817795, 0.130855, -0.611334>
    }
    triangle {
      <-0.822598, 0.091530, -0.700736>,
      <-0.817795, 0.130855, -0.611334>,
      < -1.468263, -0.220887, -0.538808>
    }
    triangle {
      <-1.468263, -0.220887, -0.538808>,
      <-1.434064, -0.313655, -0.587708>,
      < -0.822598, 0.091530, -0.700736>
    }
    triangle {
      <-0.149879, 0.443128, -0.587863>,
      <-0.077718, 0.387309, -0.511829>,
      < -0.770716, 0.135722, -0.528285>
    }
    triangle {
      <-0.770716, 0.135722, -0.528285>,
      <-0.817795, 0.130855, -0.611334>,
      < -0.149879, 0.443128, -0.587863>
    }
    triangle {
      <-0.188431, 0.452719, -0.706163>,
      <-0.149879, 0.443128, -0.587863>,
      < -0.817795, 0.130855, -0.611334>
    }
    triangle {
      <-0.817795, 0.130855, -0.611334>,
      <-0.822598, 0.091530, -0.700736>,
      < -0.188431, 0.452719, -0.706163>
    }
    triangle {
      <-1.820040, -0.475178, -0.525133>,
      <-1.942279, -0.566613, -0.424684>,
      < -1.451402, -0.150860, -0.460096>
    }
    triangle {
      <-1.468263, -0.220887, -0.538808>,
      <-1.820040, -0.475178, -0.525133>,
      < -1.451402, -0.150860, -0.460096>
    }
    triangle {
      <-1.907878, -0.779944, -0.587316>,
      <-2.091436, -1.038601, -0.435128>,
      < -1.942279, -0.566613, -0.424684>
    }
    triangle {
      <-1.942279, -0.566613, -0.424684>,
      <-1.820040, -0.475178, -0.525133>,
      < -1.907878, -0.779944, -0.587316>
    }
    triangle {
      <-1.434064, -0.313655, -0.587708>,
      <-1.907878, -0.779944, -0.587316>,
      < -1.820040, -0.475178, -0.525133>
    }
    triangle {
      <-1.820040, -0.475178, -0.525133>,
      <-1.468263, -0.220887, -0.538808>,
      < -1.434064, -0.313655, -0.587708>
    }
    triangle {
      <0.493223, 0.690812, -0.221551>,
      <0.443716, 0.738063, -0.211307>,
      < -0.077718, 0.387309, -0.511829>
    }
    triangle {
      <-0.077718, 0.387309, -0.511829>,
      <-0.036027, 0.335456, -0.566606>,
      < 0.493223, 0.690812, -0.221551>
    }
    triangle {
      <0.532858, 0.639019, -0.275688>,
      <0.493223, 0.690812, -0.221551>,
      < -0.036027, 0.335456, -0.566606>
    }
    triangle {
      <-0.036027, 0.335456, -0.566606>,
      <-0.027660, 0.302945, -0.669018>,
      < 0.532858, 0.639019, -0.275688>
    }
    triangle {
      <0.938270, 1.107734, 0.199553>,
      <0.892275, 1.146133, 0.155118>,
      < 0.443716, 0.738063, -0.211307>
    }
    triangle {
      <0.443716, 0.738063, -0.211307>,
      <0.493223, 0.690812, -0.221551>,
      < 0.938270, 1.107734, 0.199553>
    }
    triangle {
      <0.998416, 1.040871, 0.203805>,
      <0.938270, 1.107734, 0.199553>,
      < 0.493223, 0.690812, -0.221551>
    }
    triangle {
      <0.493223, 0.690812, -0.221551>,
      <0.532858, 0.639019, -0.275688>,
      < 0.998416, 1.040871, 0.203805>
    }
    triangle {
      <0.413444, 0.750084, -0.299377>,
      <0.443716, 0.738063, -0.211307>,
      < -0.077718, 0.387309, -0.511829>
    }
    triangle {
      <-0.077718, 0.387309, -0.511829>,
      <-0.149879, 0.443128, -0.587863>,
      < 0.413444, 0.750084, -0.299377>
    }
    triangle {
      <0.418268, 0.723467, -0.391226>,
      <0.413444, 0.750084, -0.299377>,
      < -0.149879, 0.443128, -0.587863>
    }
    triangle {
      <-0.149879, 0.443128, -0.587863>,
      <-0.188431, 0.452719, -0.706163>,
      < 0.418268, 0.723467, -0.391226>
    }
    triangle {
      <0.904756, 1.104924, 0.067597>,
      <0.892275, 1.146133, 0.155118>,
      < 0.443716, 0.738063, -0.211307>
    }
    triangle {
      <0.443716, 0.738063, -0.211307>,
      <0.413444, 0.750084, -0.299377>,
      < 0.904756, 1.104924, 0.067597>
    }
    triangle {
      <0.953966, 1.032798, 0.014742>,
      <0.904756, 1.104924, 0.067597>,
      < 0.413444, 0.750084, -0.299377>
    }
    triangle {
      <0.413444, 0.750084, -0.299377>,
      <0.418268, 0.723467, -0.391226>,
      < 0.953966, 1.032798, 0.014742>
    }
    triangle {
      <1.166343, 1.339025, 0.319157>,
      <1.142989, 1.701494, 0.402329>,
      < 0.892275, 1.146133, 0.155118>
    }
    triangle {
      <0.892275, 1.146133, 0.155118>,
      <0.938270, 1.107734, 0.199553>,
      < 1.166343, 1.339025, 0.319157>
    }
    triangle {
      <1.043833, 0.979271, 0.171087>,
      <1.166343, 1.339025, 0.319157>,
      < 0.938270, 1.107734, 0.199553>
    }
    triangle {
      <0.938270, 1.107734, 0.199553>,
      <0.998416, 1.040871, 0.203805>,
      < 1.043833, 0.979271, 0.171087>
    }
    triangle {
      <1.380801, 1.422492, 0.357861>,
      <1.395129, 1.937251, 0.514830>,
      < 1.142989, 1.701494, 0.402329>
    }
    triangle {
      <1.142989, 1.701494, 0.402329>,
      <1.166343, 1.339025, 0.319157>,
      < 1.380801, 1.422492, 0.357861>
    }
    triangle {
      <1.060465, 0.941887, 0.111155>,
      <1.380801, 1.422492, 0.357861>,
      < 1.166343, 1.339025, 0.319157>
    }
    triangle {
      <1.166343, 1.339025, 0.319157>,
      <1.043833, 0.979271, 0.171087>,
      < 1.060465, 0.941887, 0.111155>
    }
    triangle {
      <1.114990, 1.473234, 0.409752>,
      <1.142989, 1.701494, 0.402329>,
      < 0.892275, 1.146133, 0.155118>
    }
    triangle {
      <0.938270, 1.107734, 0.199553>,
      <1.114990, 1.473234, 0.409752>,
      < 0.892275, 1.146133, 0.155118>
    }
    triangle {
      <1.289852, 1.570425, 0.527324>,
      <1.395129, 1.937251, 0.514830>,
      < 1.142989, 1.701494, 0.402329>
    }
    triangle {
      <1.142989, 1.701494, 0.402329>,
      <1.114990, 1.473234, 0.409752>,
      < 1.289852, 1.570425, 0.527324>
    }
    triangle {
      <0.998416, 1.040871, 0.203805>,
      <1.289852, 1.570425, 0.527324>,
      < 1.114990, 1.473234, 0.409752>
    }
    triangle {
      <1.114990, 1.473234, 0.409752>,
      <0.938270, 1.107734, 0.199553>,
      < 0.998416, 1.040871, 0.203805>
    }
    triangle {
      <1.119555, 1.379803, 0.277016>,
      <0.904756, 1.104924, 0.067597>,
      < 0.892275, 1.146133, 0.155118>
    }
    triangle {
      <0.892275, 1.146133, 0.155118>,
      <0.938270, 1.107734, 0.199553>,
      < 1.119555, 1.379803, 0.277016>
    }
    triangle {
      <1.289852, 1.570425, 0.527324>,
      <1.119555, 1.379803, 0.277016>,
      < 0.938270, 1.107734, 0.199553>
    }
    triangle {
      <0.938270, 1.107734, 0.199553>,
      <0.998416, 1.040871, 0.203805>,
      < 1.289852, 1.570425, 0.527324>
    }
    triangle {
      <1.225983, 1.555135, 0.203809>,
      <0.953966, 1.032798, 0.014742>,
      < 0.904756, 1.104924, 0.067597>
    }
    triangle {
      <0.904756, 1.104924, 0.067597>,
      <1.119555, 1.379803, 0.277016>,
      < 1.225983, 1.555135, 0.203809>
    }
    triangle {
      <1.395129, 1.937251, 0.514830>,
      <1.225983, 1.555135, 0.203809>,
      < 1.119555, 1.379803, 0.277016>
    }
    triangle {
      <1.119555, 1.379803, 0.277016>,
      <1.289852, 1.570425, 0.527324>,
      < 1.395129, 1.937251, 0.514830>
    }
    triangle {
      <1.146202, 1.335999, 0.235531>,
      <1.142989, 1.701494, 0.402329>,
      < 0.892275, 1.146133, 0.155118>
    }
    triangle {
      <0.892275, 1.146133, 0.155118>,
      <0.904756, 1.104924, 0.067597>,
      < 1.146202, 1.335999, 0.235531>
    }
    triangle {
      <1.014849, 0.971955, 0.041167>,
      <1.146202, 1.335999, 0.235531>,
      < 0.904756, 1.104924, 0.067597>
    }
    triangle {
      <0.904756, 1.104924, 0.067597>,
      <0.953966, 1.032798, 0.014742>,
      < 1.014849, 0.971955, 0.041167>
    }
    triangle {
      <1.380801, 1.422492, 0.357861>,
      <1.395129, 1.937251, 0.514830>,
      < 1.142989, 1.701494, 0.402329>
    }
    triangle {
      <1.142989, 1.701494, 0.402329>,
      <1.146202, 1.335999, 0.235531>,
      < 1.380801, 1.422492, 0.357861>
    }
    triangle {
      <1.060465, 0.941887, 0.111155>,
      <1.380801, 1.422492, 0.357861>,
      < 1.146202, 1.335999, 0.235531>
    }
    triangle {
      <1.146202, 1.335999, 0.235531>,
      <1.014849, 0.971955, 0.041167>,
      < 1.060465, 0.941887, 0.111155>
    }
    triangle {
      <1.074044, 1.465593, 0.214970>,
      <1.142989, 1.701494, 0.402329>,
      < 0.892275, 1.146133, 0.155118>
    }
    triangle {
      <0.904756, 1.104924, 0.067597>,
      <1.074044, 1.465593, 0.214970>,
      < 0.892275, 1.146133, 0.155118>
    }
    triangle {
      <1.225983, 1.555135, 0.203809>,
      <1.395129, 1.937251, 0.514830>,
      < 1.142989, 1.701494, 0.402329>
    }
    triangle {
      <1.142989, 1.701494, 0.402329>,
      <1.074044, 1.465593, 0.214970>,
      < 1.225983, 1.555135, 0.203809>
    }
    triangle {
      <0.953966, 1.032798, 0.014742>,
      <1.225983, 1.555135, 0.203809>,
      < 1.074044, 1.465593, 0.214970>
    }
    triangle {
      <1.074044, 1.465593, 0.214970>,
      <0.904756, 1.104924, 0.067597>,
      < 0.953966, 1.032798, 0.014742>
    }
    triangle {
      <-1.617352, -0.576342, -0.475010>,
      <-1.360686, -0.369143, -0.565019>,
      < -1.434064, -0.313655, -0.587708>
    }
    triangle {
      <-1.434064, -0.313655, -0.587708>,
      <-1.907878, -0.779944, -0.587316>,
      < -1.617352, -0.576342, -0.475010>
    }
    triangle {
      <-1.748161, -0.671085, -0.320369>,
      <-1.617352, -0.576342, -0.475010>,
      < -1.907878, -0.779944, -0.587316>
    }
    triangle {
      <-1.907878, -0.779944, -0.587316>,
      <-2.091436, -1.038601, -0.435128>,
      < -1.748161, -0.671085, -0.320369>
    }
    triangle {
      <-1.288902, -0.322314, -0.453297>,
      <-1.289231, -0.379149, -0.504085>,
      < -1.360686, -0.369143, -0.565019>
    }
    triangle {
      <-1.360686, -0.369143, -0.565019>,
      <-1.617352, -0.576342, -0.475010>,
      < -1.288902, -0.322314, -0.453297>
    }
    triangle {
      <-1.327190, -0.248261, -0.425022>,
      <-1.288902, -0.322314, -0.453297>,
      < -1.617352, -0.576342, -0.475010>
    }
    triangle {
      <-1.617352, -0.576342, -0.475010>,
      <-1.748161, -0.671085, -0.320369>,
      < -1.327190, -0.248261, -0.425022>
    }
    triangle {
      <-1.676767, -0.686026, -0.572516>,
      <-1.907878, -0.779944, -0.587316>,
      < -1.434064, -0.313655, -0.587708>
    }
    triangle {
      <-1.360686, -0.369143, -0.565019>,
      <-1.676767, -0.686026, -0.572516>,
      < -1.434064, -0.313655, -0.587708>
    }
    triangle {
      <-1.718792, -0.868435, -0.469223>,
      <-2.091436, -1.038601, -0.435128>,
      < -1.907878, -0.779944, -0.587316>
    }
    triangle {
      <-1.907878, -0.779944, -0.587316>,
      <-1.676767, -0.686026, -0.572516>,
      < -1.718792, -0.868435, -0.469223>
    }
    triangle {
      <-1.289231, -0.379149, -0.504085>,
      <-1.718792, -0.868435, -0.469223>,
      < -1.676767, -0.686026, -0.572516>
    }
    triangle {
      <-1.676767, -0.686026, -0.572516>,
      <-1.360686, -0.369143, -0.565019>,
      < -1.289231, -0.379149, -0.504085>
    }
    triangle {
      <-0.770570, 0.031190, -0.734086>,
      <-0.822598, 0.091530, -0.700736>,
      < -1.434064, -0.313655, -0.587708>
    }
    triangle {
      <-1.434064, -0.313655, -0.587708>,
      <-1.360686, -0.369143, -0.565019>,
      < -0.770570, 0.031190, -0.734086>
    }
    triangle {
      <-0.702045, -0.016452, -0.723277>,
      <-0.770570, 0.031190, -0.734086>,
      < -1.360686, -0.369143, -0.565019>
    }
    triangle {
      <-1.360686, -0.369143, -0.565019>,
      <-1.289231, -0.379149, -0.504085>,
      < -0.702045, -0.016452, -0.723277>
    }
    triangle {
      <-0.163670, 0.396972, -0.788694>,
      <-0.188431, 0.452719, -0.706163>,
      < -0.822598, 0.091530, -0.700736>
    }
    triangle {
      <-0.822598, 0.091530, -0.700736>,
      <-0.770570, 0.031190, -0.734086>,
      < -0.163670, 0.396972, -0.788694>
    }
    triangle {
      <-0.103616, 0.320956, -0.821363>,
      <-0.163670, 0.396972, -0.788694>,
      < -0.770570, 0.031190, -0.734086>
    }
    triangle {
      <-0.770570, 0.031190, -0.734086>,
      <-0.702045, -0.016452, -0.723277>,
      < -0.103616, 0.320956, -0.821363>
    }
    triangle {
      <0.467749, 0.661287, -0.423399>,
      <0.418268, 0.723467, -0.391226>,
      < -0.188431, 0.452719, -0.706163>
    }
    triangle {
      <-0.188431, 0.452719, -0.706163>,
      <-0.163670, 0.396972, -0.788694>,
      < 0.467749, 0.661287, -0.423399>
    }
    triangle {
      <0.527175, 0.604276, -0.408886>,
      <0.467749, 0.661287, -0.423399>,
      < -0.163670, 0.396972, -0.788694>
    }
    triangle {
      <-0.163670, 0.396972, -0.788694>,
      <-0.103616, 0.320956, -0.821363>,
      < 0.527175, 0.604276, -0.408886>
    }
    triangle {
      <1.014849, 0.971955, 0.041167>,
      <0.953966, 1.032798, 0.014742>,
      < 0.418268, 0.723467, -0.391226>
    }
    triangle {
      <0.418268, 0.723467, -0.391226>,
      <0.467749, 0.661287, -0.423399>,
      < 1.014849, 0.971955, 0.041167>
    }
    triangle {
      <1.060465, 0.941887, 0.111155>,
      <1.014849, 0.971955, 0.041167>,
      < 0.467749, 0.661287, -0.423399>
    }
    triangle {
      <0.467749, 0.661287, -0.423399>,
      <0.527175, 0.604276, -0.408886>,
      < 1.060465, 0.941887, 0.111155>
    }
    triangle {
      <1.185245, 1.300259, 0.260584>,
      <1.225983, 1.555135, 0.203809>,
      < 0.953966, 1.032798, 0.014742>
    }
    triangle {
      <0.953966, 1.032798, 0.014742>,
      <1.014849, 0.971955, 0.041167>,
      < 1.185245, 1.300259, 0.260584>
    }
    triangle {
      <1.043833, 0.979271, 0.171087>,
      <1.185245, 1.300259, 0.260584>,
      < 1.014849, 0.971955, 0.041167>
    }
    triangle {
      <1.014849, 0.971955, 0.041167>,
      <1.060465, 0.941887, 0.111155>,
      < 1.043833, 0.979271, 0.171087>
    }
    triangle {
      <1.289852, 1.570425, 0.527324>,
      <1.395129, 1.937251, 0.514830>,
      < 1.225983, 1.555135, 0.203809>
    }
    triangle {
      <1.225983, 1.555135, 0.203809>,
      <1.185245, 1.300259, 0.260584>,
      < 1.289852, 1.570425, 0.527324>
    }
    triangle {
      <0.998416, 1.040871, 0.203805>,
      <1.289852, 1.570425, 0.527324>,
      < 1.185245, 1.300259, 0.260584>
    }
    triangle {
      <1.185245, 1.300259, 0.260584>,
      <1.043833, 0.979271, 0.171087>,
      < 0.998416, 1.040871, 0.203805>
    }
    triangle {
      <1.231499, 1.277827, 0.166987>,
      <1.014849, 0.971955, 0.041167>,
      < 0.953966, 1.032798, 0.014742>
    }
    triangle {
      <1.225983, 1.555135, 0.203809>,
      <1.231499, 1.277827, 0.166987>,
      < 0.953966, 1.032798, 0.014742>
    }
    triangle {
      <1.380801, 1.422492, 0.357861>,
      <1.060465, 0.941887, 0.111155>,
      < 1.014849, 0.971955, 0.041167>
    }
    triangle {
      <1.014849, 0.971955, 0.041167>,
      <1.231499, 1.277827, 0.166987>,
      < 1.380801, 1.422492, 0.357861>
    }
    triangle {
      <1.395129, 1.937251, 0.514830>,
      <1.380801, 1.422492, 0.357861>,
      < 1.231499, 1.277827, 0.166987>
    }
    triangle {
      <1.231499, 1.277827, 0.166987>,
      <1.225983, 1.555135, 0.203809>,
      < 1.395129, 1.937251, 0.514830>
    }
    triangle {
      <-1.674630, -0.794690, -0.359240>,
      <-1.718792, -0.868435, -0.469223>,
      < -2.091436, -1.038601, -0.435128>
    }
    triangle {
      <-1.748161, -0.671085, -0.320369>,
      <-1.674630, -0.794690, -0.359240>,
      < -2.091436, -1.038601, -0.435128>
    }
    triangle {
      <-1.288902, -0.322314, -0.453297>,
      <-1.289231, -0.379149, -0.504085>,
      < -1.718792, -0.868435, -0.469223>
    }
    triangle {
      <-1.718792, -0.868435, -0.469223>,
      <-1.674630, -0.794690, -0.359240>,
      < -1.288902, -0.322314, -0.453297>
    }
    triangle {
      <-1.327190, -0.248261, -0.425022>,
      <-1.288902, -0.322314, -0.453297>,
      < -1.674630, -0.794690, -0.359240>
    }
    triangle {
      <-1.674630, -0.794690, -0.359240>,
      <-1.748161, -0.671085, -0.320369>,
      < -1.327190, -0.248261, -0.425022>
    }
    triangle {
      <-0.675204, -0.001691, -0.663464>,
      <-0.680089, 0.038775, -0.599402>,
      < -1.327190, -0.248261, -0.425022>
    }
    triangle {
      <-1.327190, -0.248261, -0.425022>,
      <-1.288902, -0.322314, -0.453297>,
      < -0.675204, -0.001691, -0.663464>
    }
    triangle {
      <-0.702045, -0.016452, -0.723277>,
      <-0.675204, -0.001691, -0.663464>,
      < -1.288902, -0.322314, -0.453297>
    }
    triangle {
      <-1.288902, -0.322314, -0.453297>,
      <-1.289231, -0.379149, -0.504085>,
      < -0.702045, -0.016452, -0.723277>
    }
    triangle {
      <-0.053386, 0.294933, -0.760801>,
      <-0.027660, 0.302945, -0.669018>,
      < -0.680089, 0.038775, -0.599402>
    }
    triangle {
      <-0.680089, 0.038775, -0.599402>,
      <-0.675204, -0.001691, -0.663464>,
      < -0.053386, 0.294933, -0.760801>
    }
    triangle {
      <-0.103616, 0.320956, -0.821363>,
      <-0.053386, 0.294933, -0.760801>,
      < -0.675204, -0.001691, -0.663464>
    }
    triangle {
      <-0.675204, -0.001691, -0.663464>,
      <-0.702045, -0.016452, -0.723277>,
      < -0.103616, 0.320956, -0.821363>
    }
    triangle {
      <0.543404, 0.607104, -0.343236>,
      <0.532858, 0.639019, -0.275688>,
      < -0.027660, 0.302945, -0.669018>
    }
    triangle {
      <-0.027660, 0.302945, -0.669018>,
      <-0.053386, 0.294933, -0.760801>,
      < 0.543404, 0.607104, -0.343236>
    }
    triangle {
      <0.527175, 0.604276, -0.408886>,
      <0.543404, 0.607104, -0.343236>,
      < -0.053386, 0.294933, -0.760801>
    }
    triangle {
      <-0.053386, 0.294933, -0.760801>,
      <-0.103616, 0.320956, -0.821363>,
      < 0.527175, 0.604276, -0.408886>
    }
    triangle {
      <1.043833, 0.979271, 0.171087>,
      <0.998416, 1.040871, 0.203805>,
      < 0.532858, 0.639019, -0.275688>
    }
    triangle {
      <1.060465, 0.941887, 0.111155>,
      <1.043833, 0.979271, 0.171087>,
      < 0.543404, 0.607104, -0.343236>
    }
    triangle {
      <0.543404, 0.607104, -0.343236>,
      <0.527175, 0.604276, -0.408886>,
      < 1.060465, 0.941887, 0.111155>
    }
    triangle {
      <1.272260, 1.290232, 0.391469>,
      <1.289852, 1.570425, 0.527324>,
      < 0.998416, 1.040871, 0.203805>
    }
    triangle {
      <1.043833, 0.979271, 0.171087>,
      <1.272260, 1.290232, 0.391469>,
      < 0.998416, 1.040871, 0.203805>
    }
    triangle {
      <1.380801, 1.422492, 0.357861>,
      <1.395129, 1.937251, 0.514830>,
      < 1.289852, 1.570425, 0.527324>
    }
    triangle {
      <1.289852, 1.570425, 0.527324>,
      <1.272260, 1.290232, 0.391469>,
      < 1.380801, 1.422492, 0.357861>
    }
    triangle {
      <1.060465, 0.941887, 0.111155>,
      <1.380801, 1.422492, 0.357861>,
      < 1.272260, 1.290232, 0.391469>
    }
    triangle {
      <1.272260, 1.290232, 0.391469>,
      <1.043833, 0.979271, 0.171087>,
      < 1.060465, 0.941887, 0.111155>
    }
    triangle {
      <-1.710430, -0.329295, 0.077052>,
      <-1.470473, 0.005635, 0.081902>,
      < -1.531584, 0.033907, 0.047103>
    }
    triangle {
      <-1.531584, 0.033907, 0.047103>,
      <-2.022461, -0.381846, 0.082514>,
      < -1.710430, -0.329295, 0.077052>
    }
    triangle {
      <-1.798973, -0.683668, 0.037976>,
      <-1.710430, -0.329295, 0.077052>,
      < -2.022461, -0.381846, 0.082514>
    }
    triangle {
      <-2.022461, -0.381846, 0.082514>,
      <-2.171617, -0.853835, 0.072071>,
      < -1.798973, -0.683668, 0.037976>
    }
    triangle {
      <-1.369084, -0.137547, 0.053902>,
      <-1.407444, -0.063559, 0.082196>,
      < -1.470473, 0.005635, 0.081902>
    }
    triangle {
      <-1.470473, 0.005635, 0.081902>,
      <-1.710430, -0.329295, 0.077052>,
      < -1.369084, -0.137547, 0.053902>
    }
    triangle {
      <-1.369495, -0.194409, 0.003226>,
      <-1.369084, -0.137547, 0.053902>,
      < -1.710430, -0.329295, 0.077052>
    }
    triangle {
      <-1.710430, -0.329295, 0.077052>,
      <-1.798973, -0.683668, 0.037976>,
      < -1.369495, -0.194409, 0.003226>
    }
    triangle {
      <-1.761439, -0.302887, 0.048311>,
      <-1.548444, -0.036121, -0.031609>,
      < -1.531584, 0.033907, 0.047103>
    }
    triangle {
      <-1.531584, 0.033907, 0.047103>,
      <-1.470473, 0.005635, 0.081902>,
      < -1.761439, -0.302887, 0.048311>
    }
    triangle {
      <-1.828416, -0.486383, 0.186850>,
      <-1.761439, -0.302887, 0.048311>,
      < -1.470473, 0.005635, 0.081902>
    }
    triangle {
      <-1.470473, 0.005635, 0.081902>,
      <-1.407444, -0.063559, 0.082196>,
      < -1.828416, -0.486383, 0.186850>
    }
    triangle {
      <-1.988059, -0.595177, -0.080117>,
      <-1.514245, -0.128888, -0.080509>,
      < -1.548444, -0.036121, -0.031609>
    }
    triangle {
      <-1.548444, -0.036121, -0.031609>,
      <-1.761439, -0.302887, 0.048311>,
      < -1.988059, -0.595177, -0.080117>
    }
    triangle {
      <-2.171617, -0.853835, 0.072071>,
      <-1.988059, -0.595177, -0.080117>,
      < -1.761439, -0.302887, 0.048311>
    }
    triangle {
      <-1.761439, -0.302887, 0.048311>,
      <-1.828416, -0.486383, 0.186850>,
      < -2.171617, -0.853835, 0.072071>
    }
    triangle {
      <-1.800024, -0.226494, 0.143941>,
      <-2.022461, -0.381846, 0.082514>,
      < -1.531584, 0.033907, 0.047103>
    }
    triangle {
      <-1.470473, 0.005635, 0.081902>,
      <-1.800024, -0.226494, 0.143941>,
      < -1.531584, 0.033907, 0.047103>
    }
    triangle {
      <-1.828416, -0.486383, 0.186850>,
      <-2.171617, -0.853835, 0.072071>,
      < -2.022461, -0.381846, 0.082514>
    }
    triangle {
      <-2.022461, -0.381846, 0.082514>,
      <-1.800024, -0.226494, 0.143941>,
      < -1.828416, -0.486383, 0.186850>
    }
    triangle {
      <-1.407444, -0.063559, 0.082196>,
      <-1.828416, -0.486383, 0.186850>,
      < -1.800024, -0.226494, 0.143941>
    }
    triangle {
      <-1.800024, -0.226494, 0.143941>,
      <-1.470473, 0.005635, 0.081902>,
      < -1.407444, -0.063559, 0.082196>
    }
    triangle {
      <-0.805900, 0.284538, -0.008323>,
      <-0.859088, 0.327690, 0.007103>,
      < -1.531584, 0.033907, 0.047103>
    }
    triangle {
      <-1.531584, 0.033907, 0.047103>,
      <-1.470473, 0.005635, 0.081902>,
      < -0.805900, 0.284538, -0.008323>
    }
    triangle {
      <-0.768449, 0.230628, -0.064836>,
      <-0.805900, 0.284538, -0.008323>,
      < -1.470473, 0.005635, 0.081902>
    }
    triangle {
      <-1.470473, 0.005635, 0.081902>,
      <-1.407444, -0.063559, 0.082196>,
      < -0.768449, 0.230628, -0.064836>
    }
    triangle {
      <-0.116209, 0.520223, -0.059407>,
      <-0.157899, 0.572075, -0.004630>,
      < -0.859088, 0.327690, 0.007103>
    }
    triangle {
      <-0.859088, 0.327690, 0.007103>,
      <-0.805900, 0.284538, -0.008323>,
      < -0.116209, 0.520223, -0.059407>
    }
    triangle {
      <-0.107841, 0.487712, -0.161819>,
      <-0.116209, 0.520223, -0.059407>,
      < -0.805900, 0.284538, -0.008323>
    }
    triangle {
      <-0.805900, 0.284538, -0.008323>,
      <-0.768449, 0.230628, -0.064836>,
      < -0.107841, 0.487712, -0.161819>
    }
    triangle {
      <-1.758622, -0.357248, 0.005080>,
      <-2.022461, -0.381846, 0.082514>,
      < -1.531584, 0.033907, 0.047103>
    }
    triangle {
      <-1.531584, 0.033907, 0.047103>,
      <-1.548444, -0.036121, -0.031609>,
      < -1.758622, -0.357248, 0.005080>
    }
    triangle {
      <-1.440867, -0.184376, -0.057821>,
      <-1.758622, -0.357248, 0.005080>,
      < -1.548444, -0.036121, -0.031609>
    }
    triangle {
      <-1.548444, -0.036121, -0.031609>,
      <-1.514245, -0.128888, -0.080509>,
      < -1.440867, -0.184376, -0.057821>
    }
    triangle {
      <-1.798973, -0.683668, 0.037976>,
      <-2.171617, -0.853835, 0.072071>,
      < -2.022461, -0.381846, 0.082514>
    }
    triangle {
      <-2.022461, -0.381846, 0.082514>,
      <-1.758622, -0.357248, 0.005080>,
      < -1.798973, -0.683668, 0.037976>
    }
    triangle {
      <-1.758622, -0.357248, 0.005080>,
      <-1.440867, -0.184376, -0.057821>,
      < -1.369495, -0.194409, 0.003226>
    }
    triangle {
      <-0.906051, 0.322863, -0.076387>,
      <-0.859088, 0.327690, 0.007103>,
      < -1.531584, 0.033907, 0.047103>
    }
    triangle {
      <-1.531584, 0.033907, 0.047103>,
      <-1.548444, -0.036121, -0.031609>,
      < -0.906051, 0.322863, -0.076387>
    }
    triangle {
      <-0.910661, 0.283473, -0.166288>,
      <-0.906051, 0.322863, -0.076387>,
      < -1.548444, -0.036121, -0.031609>
    }
    triangle {
      <-1.548444, -0.036121, -0.031609>,
      <-1.514245, -0.128888, -0.080509>,
      < -0.910661, 0.283473, -0.166288>
    }
    triangle {
      <-0.230069, 0.627934, -0.080572>,
      <-0.157899, 0.572075, -0.004630>,
      < -0.859088, 0.327690, 0.007103>
    }
    triangle {
      <-0.859088, 0.327690, 0.007103>,
      <-0.906051, 0.322863, -0.076387>,
      < -0.230069, 0.627934, -0.080572>
    }
    triangle {
      <-0.268612, 0.637485, -0.198964>,
      <-0.230069, 0.627934, -0.080572>,
      < -0.906051, 0.322863, -0.076387>
    }
    triangle {
      <-0.906051, 0.322863, -0.076387>,
      <-0.910661, 0.283473, -0.166288>,
      < -0.268612, 0.637485, -0.198964>
    }
    triangle {
      <-1.900221, -0.290411, -0.017934>,
      <-2.022461, -0.381846, 0.082514>,
      < -1.531584, 0.033907, 0.047103>
    }
    triangle {
      <-1.548444, -0.036121, -0.031609>,
      <-1.900221, -0.290411, -0.017934>,
      < -1.531584, 0.033907, 0.047103>
    }
    triangle {
      <-1.988059, -0.595177, -0.080117>,
      <-2.171617, -0.853835, 0.072071>,
      < -2.022461, -0.381846, 0.082514>
    }
    triangle {
      <-2.022461, -0.381846, 0.082514>,
      <-1.900221, -0.290411, -0.017934>,
      < -1.988059, -0.595177, -0.080117>
    }
    triangle {
      <-1.514245, -0.128888, -0.080509>,
      <-1.988059, -0.595177, -0.080117>,
      < -1.900221, -0.290411, -0.017934>
    }
    triangle {
      <-1.900221, -0.290411, -0.017934>,
      <-1.548444, -0.036121, -0.031609>,
      < -1.514245, -0.128888, -0.080509>
    }
    triangle {
      <0.455523, 0.812284, 0.047567>,
      <0.409327, 0.861553, 0.057509>,
      < -0.157899, 0.572075, -0.004630>
    }
    triangle {
      <-0.157899, 0.572075, -0.004630>,
      <-0.116209, 0.520223, -0.059407>,
      < 0.455523, 0.812284, 0.047567>
    }
    triangle {
      <0.491329, 0.757722, -0.006110>,
      <0.455523, 0.812284, 0.047567>,
      < -0.116209, 0.520223, -0.059407>
    }
    triangle {
      <-0.116209, 0.520223, -0.059407>,
      <-0.107841, 0.487712, -0.161819>,
      < 0.491329, 0.757722, -0.006110>
    }
    triangle {
      <0.968875, 1.160321, 0.239809>,
      <0.927223, 1.202505, 0.194100>,
      < 0.409327, 0.861553, 0.057509>
    }
    triangle {
      <0.409327, 0.861553, 0.057509>,
      <0.455523, 0.812284, 0.047567>,
      < 0.968875, 1.160321, 0.239809>
    }
    triangle {
      <1.023363, 1.088467, 0.245604>,
      <0.968875, 1.160321, 0.239809>,
      < 0.455523, 0.812284, 0.047567>
    }
    triangle {
      <0.455523, 0.812284, 0.047567>,
      <0.491329, 0.757722, -0.006110>,
      < 1.023363, 1.088467, 0.245604>
    }
    triangle {
      <0.376937, 0.871579, -0.030802>,
      <0.409327, 0.861553, 0.057509>,
      < -0.157899, 0.572075, -0.004630>
    }
    triangle {
      <-0.157899, 0.572075, -0.004630>,
      <-0.230069, 0.627934, -0.080572>,
      < 0.376937, 0.871579, -0.030802>
    }
    triangle {
      <0.378836, 0.842255, -0.122673>,
      <0.376937, 0.871579, -0.030802>,
      < -0.230069, 0.627934, -0.080572>
    }
    triangle {
      <-0.230069, 0.627934, -0.080572>,
      <-0.268612, 0.637485, -0.198964>,
      < 0.378836, 0.842255, -0.122673>
    }
    triangle {
      <0.935458, 1.157628, 0.107596>,
      <0.927223, 1.202505, 0.194100>,
      < 0.409327, 0.861553, 0.057509>
    }
    triangle {
      <0.409327, 0.861553, 0.057509>,
      <0.376937, 0.871579, -0.030802>,
      < 0.935458, 1.157628, 0.107596>
    }
    triangle {
      <0.978922, 1.080355, 0.056450>,
      <0.935458, 1.157628, 0.107596>,
      < 0.376937, 0.871579, -0.030802>
    }
    triangle {
      <0.376937, 0.871579, -0.030802>,
      <0.378836, 0.842255, -0.122673>,
      < 0.978922, 1.080355, 0.056450>
    }
    triangle {
      <1.168734, 1.327766, 0.360369>,
      <1.136438, 1.636607, 0.457378>,
      < 0.927223, 1.202505, 0.194100>
    }
    triangle {
      <0.927223, 1.202505, 0.194100>,
      <0.968875, 1.160321, 0.239809>,
      < 1.168734, 1.327766, 0.360369>
    }
    triangle {
      <1.068128, 1.026245, 0.212975>,
      <1.168734, 1.327766, 0.360369>,
      < 0.968875, 1.160321, 0.239809>
    }
    triangle {
      <0.968875, 1.160321, 0.239809>,
      <1.023363, 1.088467, 0.245604>,
      < 1.068128, 1.026245, 0.212975>
    }
    triangle {
      <1.341825, 1.375067, 0.422867>,
      <1.319152, 1.805211, 0.632102>,
      < 1.136438, 1.636607, 0.457378>
    }
    triangle {
      <1.136438, 1.636607, 0.457378>,
      <1.168734, 1.327766, 0.360369>,
      < 1.341825, 1.375067, 0.422867>
    }
    triangle {
      <1.085421, 0.989444, 0.152862>,
      <1.341825, 1.375067, 0.422867>,
      < 1.168734, 1.327766, 0.360369>
    }
    triangle {
      <1.168734, 1.327766, 0.360369>,
      <1.068128, 1.026245, 0.212975>,
      < 1.085421, 0.989444, 0.152862>
    }
    triangle {
      <1.124388, 1.452992, 0.432134>,
      <1.136438, 1.636607, 0.457378>,
      < 0.927223, 1.202505, 0.194100>
    }
    triangle {
      <0.968875, 1.160321, 0.239809>,
      <1.124388, 1.452992, 0.432134>,
      < 0.927223, 1.202505, 0.194100>
    }
    triangle {
      <1.259879, 1.512091, 0.570591>,
      <1.319152, 1.805211, 0.632102>,
      < 1.136438, 1.636607, 0.457378>
    }
    triangle {
      <1.136438, 1.636607, 0.457378>,
      <1.124388, 1.452992, 0.432134>,
      < 1.259879, 1.512091, 0.570591>
    }
    triangle {
      <1.023363, 1.088467, 0.245604>,
      <1.259879, 1.512091, 0.570591>,
      < 1.124388, 1.452992, 0.432134>
    }
    triangle {
      <1.124388, 1.452992, 0.432134>,
      <0.968875, 1.160321, 0.239809>,
      < 1.023363, 1.088467, 0.245604>
    }
    triangle {
      <1.122958, 1.370184, 0.316763>,
      <0.935458, 1.157628, 0.107596>,
      < 0.927223, 1.202505, 0.194100>
    }
    triangle {
      <0.927223, 1.202505, 0.194100>,
      <0.968875, 1.160321, 0.239809>,
      < 1.122958, 1.370184, 0.316763>
    }
    triangle {
      <1.259879, 1.512091, 0.570591>,
      <1.122958, 1.370184, 0.316763>,
      < 0.968875, 1.160321, 0.239809>
    }
    triangle {
      <0.968875, 1.160321, 0.239809>,
      <1.023363, 1.088467, 0.245604>,
      < 1.259879, 1.512091, 0.570591>
    }
    triangle {
      <1.206046, 1.498708, 0.279558>,
      <0.978922, 1.080355, 0.056450>,
      < 0.935458, 1.157628, 0.107596>
    }
    triangle {
      <0.935458, 1.157628, 0.107596>,
      <1.122958, 1.370184, 0.316763>,
      < 1.206046, 1.498708, 0.279558>
    }
    triangle {
      <1.319152, 1.805211, 0.632102>,
      <1.206046, 1.498708, 0.279558>,
      < 1.122958, 1.370184, 0.316763>
    }
    triangle {
      <1.122958, 1.370184, 0.316763>,
      <1.259879, 1.512091, 0.570591>,
      < 1.319152, 1.805211, 0.632102>
    }
    triangle {
      <1.148676, 1.324766, 0.276631>,
      <1.136438, 1.636607, 0.457378>,
      < 0.927223, 1.202505, 0.194100>
    }
    triangle {
      <0.927223, 1.202505, 0.194100>,
      <0.935458, 1.157628, 0.107596>,
      < 1.148676, 1.324766, 0.276631>
    }
    triangle {
      <1.039062, 1.018902, 0.083167>,
      <1.148676, 1.324766, 0.276631>,
      < 0.935458, 1.157628, 0.107596>
    }
    triangle {
      <0.935458, 1.157628, 0.107596>,
      <0.978922, 1.080355, 0.056450>,
      < 1.039062, 1.018902, 0.083167>
    }
    triangle {
      <1.341825, 1.375067, 0.422867>,
      <1.319152, 1.805211, 0.632102>,
      < 1.136438, 1.636607, 0.457378>
    }
    triangle {
      <1.136438, 1.636607, 0.457378>,
      <1.148676, 1.324766, 0.276631>,
      < 1.341825, 1.375067, 0.422867>
    }
    triangle {
      <1.085421, 0.989444, 0.152862>,
      <1.341825, 1.375067, 0.422867>,
      < 1.148676, 1.324766, 0.276631>
    }
    triangle {
      <1.148676, 1.324766, 0.276631>,
      <1.039062, 1.018902, 0.083167>,
      < 1.085421, 0.989444, 0.152862>
    }
    triangle {
      <1.088473, 1.446330, 0.253474>,
      <1.136438, 1.636607, 0.457378>,
      < 0.927223, 1.202505, 0.194100>
    }
    triangle {
      <0.935458, 1.157628, 0.107596>,
      <1.088473, 1.446330, 0.253474>,
      < 0.927223, 1.202505, 0.194100>
    }
    triangle {
      <1.206046, 1.498708, 0.279558>,
      <1.319152, 1.805211, 0.632102>,
      < 1.136438, 1.636607, 0.457378>
    }
    triangle {
      <1.136438, 1.636607, 0.457378>,
      <1.088473, 1.446330, 0.253474>,
      < 1.206046, 1.498708, 0.279558>
    }
    triangle {
      <0.978922, 1.080355, 0.056450>,
      <1.206046, 1.498708, 0.279558>,
      < 1.088473, 1.446330, 0.253474>
    }
    triangle {
      <1.088473, 1.446330, 0.253474>,
      <0.935458, 1.157628, 0.107596>,
      < 0.978922, 1.080355, 0.056450>
    }
    triangle {
      <-1.697533, -0.391575, 0.032189>,
      <-1.440867, -0.184376, -0.057821>,
      < -1.514245, -0.128888, -0.080509>
    }
    triangle {
      <-1.514245, -0.128888, -0.080509>,
      <-1.988059, -0.595177, -0.080117>,
      < -1.697533, -0.391575, 0.032189>
    }
    triangle {
      <-1.828416, -0.486383, 0.186850>,
      <-1.697533, -0.391575, 0.032189>,
      < -1.988059, -0.595177, -0.080117>
    }
    triangle {
      <-1.988059, -0.595177, -0.080117>,
      <-2.171617, -0.853835, 0.072071>,
      < -1.828416, -0.486383, 0.186850>
    }
    triangle {
      <-1.369084, -0.137547, 0.053902>,
      <-1.369495, -0.194409, 0.003226>,
      < -1.440867, -0.184376, -0.057821>
    }
    triangle {
      <-1.440867, -0.184376, -0.057821>,
      <-1.697533, -0.391575, 0.032189>,
      < -1.369084, -0.137547, 0.053902>
    }
    triangle {
      <-1.407444, -0.063559, 0.082196>,
      <-1.369084, -0.137547, 0.053902>,
      < -1.697533, -0.391575, 0.032189>
    }
    triangle {
      <-1.697533, -0.391575, 0.032189>,
      <-1.828416, -0.486383, 0.186850>,
      < -1.407444, -0.063559, 0.082196>
    }
    triangle {
      <-1.757021, -0.501324, -0.065297>,
      <-1.988059, -0.595177, -0.080117>,
      < -1.514245, -0.128888, -0.080509>
    }
    triangle {
      <-1.440867, -0.184376, -0.057821>,
      <-1.757021, -0.501324, -0.065297>,
      < -1.514245, -0.128888, -0.080509>
    }
    triangle {
      <-1.798973, -0.683668, 0.037976>,
      <-2.171617, -0.853835, 0.072071>,
      < -1.988059, -0.595177, -0.080117>
    }
    triangle {
      <-1.988059, -0.595177, -0.080117>,
      <-1.757021, -0.501324, -0.065297>,
      < -1.798973, -0.683668, 0.037976>
    }
    triangle {
      <-1.369495, -0.194409, 0.003226>,
      <-1.798973, -0.683668, 0.037976>,
      < -1.757021, -0.501324, -0.065297>
    }
    triangle {
      <-1.757021, -0.501324, -0.065297>,
      <-1.440867, -0.184376, -0.057821>,
      < -1.369495, -0.194409, 0.003226>
    }
    triangle {
      <-0.858681, 0.223121, -0.199856>,
      <-0.910661, 0.283473, -0.166288>,
      < -1.514245, -0.128888, -0.080509>
    }
    triangle {
      <-1.514245, -0.128888, -0.080509>,
      <-1.440867, -0.184376, -0.057821>,
      < -0.858681, 0.223121, -0.199856>
    }
    triangle {
      <-0.790119, 0.175324, -0.189413>,
      <-0.858681, 0.223121, -0.199856>,
      < -1.440867, -0.184376, -0.057821>
    }
    triangle {
      <-1.440867, -0.184376, -0.057821>,
      <-1.369495, -0.194409, 0.003226>,
      < -0.790119, 0.175324, -0.189413>
    }
    triangle {
      <-0.243851, 0.581738, -0.281495>,
      <-0.268612, 0.637485, -0.198964>,
      < -0.910661, 0.283473, -0.166288>
    }
    triangle {
      <-0.910661, 0.283473, -0.166288>,
      <-0.858681, 0.223121, -0.199856>,
      < -0.243851, 0.581738, -0.281495>
    }
    triangle {
      <-0.183797, 0.505723, -0.314164>,
      <-0.243851, 0.581738, -0.281495>,
      < -0.858681, 0.223121, -0.199856>
    }
    triangle {
      <-0.858681, 0.223121, -0.199856>,
      <-0.790119, 0.175324, -0.189413>,
      < -0.183797, 0.505723, -0.314164>
    }
    triangle {
      <0.426998, 0.779301, -0.155196>,
      <0.378836, 0.842255, -0.122673>,
      < -0.268612, 0.637485, -0.198964>
    }
    triangle {
      <-0.268612, 0.637485, -0.198964>,
      <-0.243851, 0.581738, -0.281495>,
      < 0.426998, 0.779301, -0.155196>
    }
    triangle {
      <0.485772, 0.722230, -0.141268>,
      <0.426998, 0.779301, -0.155196>,
      < -0.243851, 0.581738, -0.281495>
    }
    triangle {
      <-0.243851, 0.581738, -0.281495>,
      <-0.183797, 0.505723, -0.314164>,
      < 0.485772, 0.722230, -0.141268>
    }
    triangle {
      <1.039062, 1.018902, 0.083167>,
      <0.978922, 1.080355, 0.056450>,
      < 0.378836, 0.842255, -0.122673>
    }
    triangle {
      <0.378836, 0.842255, -0.122673>,
      <0.426998, 0.779301, -0.155196>,
      < 1.039062, 1.018902, 0.083167>
    }
    triangle {
      <1.085421, 0.989444, 0.152862>,
      <1.039062, 1.018902, 0.083167>,
      < 0.426998, 0.779301, -0.155196>
    }
    triangle {
      <0.426998, 0.779301, -0.155196>,
      <0.485772, 0.722230, -0.141268>,
      < 1.085421, 0.989444, 0.152862>
    }
    triangle {
      <1.184764, 1.287166, 0.301301>,
      <1.206046, 1.498708, 0.279558>,
      < 0.978922, 1.080355, 0.056450>
    }
    triangle {
      <0.978922, 1.080355, 0.056450>,
      <1.039062, 1.018902, 0.083167>,
      < 1.184764, 1.287166, 0.301301>
    }
    triangle {
      <1.068128, 1.026245, 0.212975>,
      <1.184764, 1.287166, 0.301301>,
      < 1.039062, 1.018902, 0.083167>
    }
    triangle {
      <1.039062, 1.018902, 0.083167>,
      <1.085421, 0.989444, 0.152862>,
      < 1.068128, 1.026245, 0.212975>
    }
    triangle {
      <1.259879, 1.512091, 0.570591>,
      <1.319152, 1.805211, 0.632102>,
      < 1.206046, 1.498708, 0.279558>
    }
    triangle {
      <1.206046, 1.498708, 0.279558>,
      <1.184764, 1.287166, 0.301301>,
      < 1.259879, 1.512091, 0.570591>
    }
    triangle {
      <1.023363, 1.088467, 0.245604>,
      <1.259879, 1.512091, 0.570591>,
      < 1.184764, 1.287166, 0.301301>
    }
    triangle {
      <1.184764, 1.287166, 0.301301>,
      <1.068128, 1.026245, 0.212975>,
      < 1.023363, 1.088467, 0.245604>
    }
    triangle {
      <1.227420, 1.264765, 0.211582>,
      <1.039062, 1.018902, 0.083167>,
      < 0.978922, 1.080355, 0.056450>
    }
    triangle {
      <1.206046, 1.498708, 0.279558>,
      <1.227420, 1.264765, 0.211582>,
      < 0.978922, 1.080355, 0.056450>
    }
    triangle {
      <1.341825, 1.375067, 0.422867>,
      <1.085421, 0.989444, 0.152862>,
      < 1.039062, 1.018902, 0.083167>
    }
    triangle {
      <1.039062, 1.018902, 0.083167>,
      <1.227420, 1.264765, 0.211582>,
      < 1.341825, 1.375067, 0.422867>
    }
    triangle {
      <1.319152, 1.805211, 0.632102>,
      <1.341825, 1.375067, 0.422867>,
      < 1.227420, 1.264765, 0.211582>
    }
    triangle {
      <1.227420, 1.264765, 0.211582>,
      <1.206046, 1.498708, 0.279558>,
      < 1.319152, 1.805211, 0.632102>
    }
    triangle {
      <-1.754811, -0.609924, 0.147959>,
      <-1.798973, -0.683668, 0.037976>,
      < -2.171617, -0.853835, 0.072071>
    }
    triangle {
      <-1.828416, -0.486383, 0.186850>,
      <-1.754811, -0.609924, 0.147959>,
      < -2.171617, -0.853835, 0.072071>
    }
    triangle {
      <-1.369084, -0.137547, 0.053902>,
      <-1.369495, -0.194409, 0.003226>,
      < -1.798973, -0.683668, 0.037976>
    }
    triangle {
      <-1.798973, -0.683668, 0.037976>,
      <-1.754811, -0.609924, 0.147959>,
      < -1.369084, -0.137547, 0.053902>
    }
    triangle {
      <-1.407444, -0.063559, 0.082196>,
      <-1.369084, -0.137547, 0.053902>,
      < -1.754811, -0.609924, 0.147959>
    }
    triangle {
      <-1.754811, -0.609924, 0.147959>,
      <-1.828416, -0.486383, 0.186850>,
      < -1.407444, -0.063559, 0.082196>
    }
    triangle {
      <-0.763389, 0.190175, -0.129213>,
      <-0.768449, 0.230628, -0.064836>,
      < -1.407444, -0.063559, 0.082196>
    }
    triangle {
      <-1.407444, -0.063559, 0.082196>,
      <-1.369084, -0.137547, 0.053902>,
      < -0.763389, 0.190175, -0.129213>
    }
    triangle {
      <-0.790119, 0.175324, -0.189413>,
      <-0.763389, 0.190175, -0.129213>,
      < -1.369084, -0.137547, 0.053902>
    }
    triangle {
      <-1.369084, -0.137547, 0.053902>,
      <-1.369495, -0.194409, 0.003226>,
      < -0.790119, 0.175324, -0.189413>
    }
    triangle {
      <-0.133576, 0.479738, -0.253511>,
      <-0.107841, 0.487712, -0.161819>,
      < -0.768449, 0.230628, -0.064836>
    }
    triangle {
      <-0.768449, 0.230628, -0.064836>,
      <-0.763389, 0.190175, -0.129213>,
      < -0.133576, 0.479738, -0.253511>
    }
    triangle {
      <-0.183797, 0.505723, -0.314164>,
      <-0.133576, 0.479738, -0.253511>,
      < -0.763389, 0.190175, -0.129213>
    }
    triangle {
      <-0.763389, 0.190175, -0.129213>,
      <-0.790119, 0.175324, -0.189413>,
      < -0.183797, 0.505723, -0.314164>
    }
    triangle {
      <0.501616, 0.725186, -0.074621>,
      <0.491329, 0.757722, -0.006110>,
      < -0.107841, 0.487712, -0.161819>
    }
    triangle {
      <-0.107841, 0.487712, -0.161819>,
      <-0.133576, 0.479738, -0.253511>,
      < 0.501616, 0.725186, -0.074621>
    }
    triangle {
      <0.485772, 0.722230, -0.141268>,
      <0.501616, 0.725186, -0.074621>,
      < -0.133576, 0.479738, -0.253511>
    }
    triangle {
      <-0.133576, 0.479738, -0.253511>,
      <-0.183797, 0.505723, -0.314164>,
      < 0.485772, 0.722230, -0.141268>
    }
    triangle {
      <1.068128, 1.026245, 0.212975>,
      <1.023363, 1.088467, 0.245604>,
      < 0.491329, 0.757722, -0.006110>
    }
    triangle {
      <0.491329, 0.757722, -0.006110>,
      <0.501616, 0.725186, -0.074621>,
      < 1.068128, 1.026245, 0.212975>
    }
    triangle {
      <1.085421, 0.989444, 0.152862>,
      <1.068128, 1.026245, 0.212975>,
      < 0.501616, 0.725186, -0.074621>
    }
    triangle {
      <0.501616, 0.725186, -0.074621>,
      <0.485772, 0.722230, -0.141268>,
      < 1.085421, 0.989444, 0.152862>
    }
    triangle {
      <1.262310, 1.276024, 0.419818>,
      <1.259879, 1.512091, 0.570591>,
      < 1.023363, 1.088467, 0.245604>
    }
    triangle {
      <1.068128, 1.026245, 0.212975>,
      <1.262310, 1.276024, 0.419818>,
      < 1.023363, 1.088467, 0.245604>
    }
    triangle {
      <1.341825, 1.375067, 0.422867>,
      <1.319152, 1.805211, 0.632102>,
      < 1.259879, 1.512091, 0.570591>
    }
    triangle {
      <1.259879, 1.512091, 0.570591>,
      <1.262310, 1.276024, 0.419818>,
      < 1.341825, 1.375067, 0.422867>
    }
    triangle {
      <1.085421, 0.989444, 0.152862>,
      <1.341825, 1.375067, 0.422867>,
      < 1.262310, 1.276024, 0.419818>
    }
    triangle {
      <1.262310, 1.276024, 0.419818>,
      <1.068128, 1.026245, 0.212975>,
      < 1.085421, 0.989444, 0.152862>
    }
    triangle {
      <-1.857766, -0.426271, 0.106000>,
      <-1.882374, -0.461085, 0.118259>,
      < -1.842368, -0.435278, 0.111361>
    }
    triangle {
      <-1.833158, -0.391457, 0.093741>,
      <-1.857766, -0.426271, 0.106000>,
      < -1.842368, -0.435278, 0.111361>
    }
    triangle {
      <-1.894448, -0.404837, 0.093237>,
      <-1.929396, -0.454265, 0.110642>,
      < -1.882374, -0.461085, 0.118259>
    }
    triangle {
      <-1.882374, -0.461085, 0.118259>,
      <-1.857766, -0.426271, 0.106000>,
      < -1.894448, -0.404837, 0.093237>
    }
    triangle {
      <-1.859499, -0.355409, 0.075833>,
      <-1.894448, -0.404837, 0.093237>,
      < -1.857766, -0.426271, 0.106000>
    }
    triangle {
      <-1.857766, -0.426271, 0.106000>,
      <-1.833158, -0.391457, 0.093741>,
      < -1.859499, -0.355409, 0.075833>
    }
    triangle {
      <-1.889077, -0.561385, -0.201257>,
      <-1.860949, -0.569023, -0.195194>,
      < -1.842368, -0.435278, 0.111361>
    }
    triangle {
      <-1.842368, -0.435278, 0.111361>,
      <-1.882374, -0.461085, 0.118259>,
      < -1.889077, -0.561385, -0.201257>
    }
    triangle {
      <-1.902495, -0.537526, -0.212705>,
      <-1.889077, -0.561385, -0.201257>,
      < -1.882374, -0.461085, 0.118259>
    }
    triangle {
      <-1.882374, -0.461085, 0.118259>,
      <-1.929396, -0.454265, 0.110642>,
      < -1.902495, -0.537526, -0.212705>
    }
    triangle {
      <-1.895771, -0.661724, -0.520865>,
      <-1.879595, -0.702870, -0.501822>,
      < -1.860949, -0.569023, -0.195194>
    }
    triangle {
      <-1.860949, -0.569023, -0.195194>,
      <-1.889077, -0.561385, -0.201257>,
      < -1.895771, -0.661724, -0.520865>
    }
    triangle {
      <-1.875652, -0.620760, -0.536178>,
      <-1.895771, -0.661724, -0.520865>,
      < -1.889077, -0.561385, -0.201257>
    }
    triangle {
      <-1.889077, -0.561385, -0.201257>,
      <-1.902495, -0.537526, -0.212705>,
      < -1.875652, -0.620760, -0.536178>
    }
    triangle {
      <-1.834628, -0.555662, -0.198201>,
      <-1.833158, -0.391457, 0.093741>,
      < -1.842368, -0.435278, 0.111361>
    }
    triangle {
      <-1.842368, -0.435278, 0.111361>,
      <-1.860949, -0.569023, -0.195194>,
      < -1.834628, -0.555662, -0.198201>
    }
    triangle {
      <-1.836088, -0.719906, -0.490234>,
      <-1.834628, -0.555662, -0.198201>,
      < -1.860949, -0.569023, -0.195194>
    }
    triangle {
      <-1.860949, -0.569023, -0.195194>,
      <-1.879595, -0.702870, -0.501822>,
      < -1.836088, -0.719906, -0.490234>
    }
    triangle {
      <-1.825204, -0.529376, -0.208379>,
      <-1.859499, -0.355409, 0.075833>,
      < -1.833158, -0.391457, 0.093741>
    }
    triangle {
      <-1.833158, -0.391457, 0.093741>,
      <-1.834628, -0.555662, -0.198201>,
      < -1.825204, -0.529376, -0.208379>
    }
    triangle {
      <-1.790967, -0.703316, -0.492716>,
      <-1.825204, -0.529376, -0.208379>,
      < -1.834628, -0.555662, -0.198201>
    }
    triangle {
      <-1.834628, -0.555662, -0.198201>,
      <-1.836088, -0.719906, -0.490234>,
      < -1.790967, -0.703316, -0.492716>
    }
    triangle {
      <-1.838689, -0.505451, -0.219861>,
      <-1.866743, -0.497749, -0.225944>,
      < -1.946527, -0.374395, 0.075113>
    }
    triangle {
      <-1.946527, -0.374395, 0.075113>,
      <-1.906448, -0.348524, 0.068196>,
      < -1.838689, -0.505451, -0.219861>
    }
    triangle {
      <-1.825204, -0.529376, -0.208379>,
      <-1.838689, -0.505451, -0.219861>,
      < -1.906448, -0.348524, 0.068196>
    }
    triangle {
      <-1.906448, -0.348524, 0.068196>,
      <-1.859499, -0.355409, 0.075833>,
      < -1.825204, -0.529376, -0.208379>
    }
    triangle {
      <-1.770848, -0.662352, -0.508030>,
      <-1.787024, -0.621206, -0.527073>,
      < -1.866743, -0.497749, -0.225944>
    }
    triangle {
      <-1.866743, -0.497749, -0.225944>,
      <-1.838689, -0.505451, -0.219861>,
      < -1.770848, -0.662352, -0.508030>
    }
    triangle {
      <-1.790967, -0.703316, -0.492716>,
      <-1.770848, -0.662352, -0.508030>,
      < -1.838689, -0.505451, -0.219861>
    }
    triangle {
      <-1.838689, -0.505451, -0.219861>,
      <-1.825204, -0.529376, -0.208379>,
      < -1.790967, -0.703316, -0.492716>
    }
    triangle {
      <-1.931129, -0.383403, 0.080475>,
      <-1.906448, -0.348524, 0.068196>,
      < -1.946527, -0.374395, 0.075113>
    }
    triangle {
      <-1.955737, -0.418217, 0.092734>,
      <-1.931129, -0.383403, 0.080475>,
      < -1.946527, -0.374395, 0.075113>
    }
    triangle {
      <-1.894448, -0.404837, 0.093237>,
      <-1.859499, -0.355409, 0.075833>,
      < -1.906448, -0.348524, 0.068196>
    }
    triangle {
      <-1.906448, -0.348524, 0.068196>,
      <-1.931129, -0.383403, 0.080475>,
      < -1.894448, -0.404837, 0.093237>
    }
    triangle {
      <-1.929396, -0.454265, 0.110642>,
      <-1.894448, -0.404837, 0.093237>,
      < -1.931129, -0.383403, 0.080475>
    }
    triangle {
      <-1.931129, -0.383403, 0.080475>,
      <-1.955737, -0.418217, 0.092734>,
      < -1.929396, -0.454265, 0.110642>
    }
    triangle {
      <-1.893139, -0.511174, -0.222917>,
      <-1.955737, -0.418217, 0.092734>,
      < -1.946527, -0.374395, 0.075113>
    }
    triangle {
      <-1.946527, -0.374395, 0.075113>,
      <-1.866743, -0.497749, -0.225944>,
      < -1.893139, -0.511174, -0.222917>
    }
    triangle {
      <-1.830531, -0.604170, -0.538660>,
      <-1.893139, -0.511174, -0.222917>,
      < -1.866743, -0.497749, -0.225944>
    }
    triangle {
      <-1.866743, -0.497749, -0.225944>,
      <-1.787024, -0.621206, -0.527073>,
      < -1.830531, -0.604170, -0.538660>
    }
    triangle {
      <-1.902495, -0.537526, -0.212705>,
      <-1.929396, -0.454265, 0.110642>,
      < -1.955737, -0.418217, 0.092734>
    }
    triangle {
      <-1.955737, -0.418217, 0.092734>,
      <-1.893139, -0.511174, -0.222917>,
      < -1.902495, -0.537526, -0.212705>
    }
    triangle {
      <-1.875652, -0.620760, -0.536178>,
      <-1.902495, -0.537526, -0.212705>,
      < -1.893139, -0.511174, -0.222917>
    }
    triangle {
      <-1.893139, -0.511174, -0.222917>,
      <-1.830531, -0.604170, -0.538660>,
      < -1.875652, -0.620760, -0.536178>
    }
    triangle {
      <-1.865930, -0.690815, -0.505549>,
      <-1.836088, -0.719906, -0.490234>,
      < -1.879595, -0.702870, -0.501822>
    }
    triangle {
      <-1.895771, -0.661724, -0.520865>,
      <-1.865930, -0.690815, -0.505549>,
      < -1.879595, -0.702870, -0.501822>
    }
    triangle {
      <-1.833309, -0.662038, -0.514447>,
      <-1.790967, -0.703316, -0.492716>,
      < -1.836088, -0.719906, -0.490234>
    }
    triangle {
      <-1.836088, -0.719906, -0.490234>,
      <-1.865930, -0.690815, -0.505549>,
      < -1.833309, -0.662038, -0.514447>
    }
    triangle {
      <-1.875652, -0.620760, -0.536178>,
      <-1.833309, -0.662038, -0.514447>,
      < -1.865930, -0.690815, -0.505549>
    }
    triangle {
      <-1.865930, -0.690815, -0.505549>,
      <-1.895771, -0.661724, -0.520865>,
      < -1.875652, -0.620760, -0.536178>
    }
    triangle {
      <-1.800689, -0.633261, -0.523345>,
      <-1.830531, -0.604170, -0.538660>,
      < -1.787024, -0.621206, -0.527073>
    }
    triangle {
      <-1.770848, -0.662352, -0.508030>,
      <-1.800689, -0.633261, -0.523345>,
      < -1.787024, -0.621206, -0.527073>
    }
    triangle {
      <-1.833309, -0.662038, -0.514447>,
      <-1.875652, -0.620760, -0.536178>,
      < -1.830531, -0.604170, -0.538660>
    }
    triangle {
      <-1.830531, -0.604170, -0.538660>,
      <-1.800689, -0.633261, -0.523345>,
      < -1.833309, -0.662038, -0.514447>
    }
    triangle {
      <-1.790967, -0.703316, -0.492716>,
      <-1.833309, -0.662038, -0.514447>,
      < -1.800689, -0.633261, -0.523345>
    }
    triangle {
      <-1.800689, -0.633261, -0.523345>,
      <-1.770848, -0.662352, -0.508030>,
      < -1.790967, -0.703316, -0.492716>
    }
    triangle {
      <-1.376912, -0.057528, 0.002561>,
      <-1.398800, -0.088445, 0.013445>,
      < -1.363293, -0.065484, 0.007299>
    }
    triangle {
      <-1.355091, -0.026546, -0.008357>,
      <-1.376912, -0.057528, 0.002561>,
      < -1.363293, -0.065484, 0.007299>
    }
    triangle {
      <-1.409553, -0.038396, -0.008821>,
      <-1.440582, -0.082368, 0.006669>,
      < -1.398800, -0.088445, 0.013445>
    }
    triangle {
      <-1.398800, -0.088445, 0.013445>,
      <-1.376912, -0.057528, 0.002561>,
      < -1.409553, -0.038396, -0.008821>
    }
    triangle {
      <-1.378532, 0.005447, -0.024256>,
      <-1.409553, -0.038396, -0.008821>,
      < -1.376912, -0.057528, 0.002561>
    }
    triangle {
      <-1.376912, -0.057528, 0.002561>,
      <-1.355091, -0.026546, -0.008357>,
      < -1.378532, 0.005447, -0.024256>
    }
    triangle {
      <-1.404764, -0.177508, -0.270512>,
      <-1.379834, -0.184347, -0.265110>,
      < -1.363293, -0.065484, 0.007299>
    }
    triangle {
      <-1.363293, -0.065484, 0.007299>,
      <-1.398800, -0.088445, 0.013445>,
      < -1.404764, -0.177508, -0.270512>
    }
    triangle {
      <-1.416693, -0.156329, -0.280677>,
      <-1.404764, -0.177508, -0.270512>,
      < -1.398800, -0.088445, 0.013445>
    }
    triangle {
      <-1.398800, -0.088445, 0.013445>,
      <-1.440582, -0.082368, 0.006669>,
      < -1.416693, -0.156329, -0.280677>
    }
    triangle {
      <-1.410734, -0.266702, -0.554415>,
      <-1.396376, -0.303211, -0.537518>,
      < -1.379834, -0.184347, -0.265110>
    }
    triangle {
      <-1.379834, -0.184347, -0.265110>,
      <-1.404764, -0.177508, -0.270512>,
      < -1.410734, -0.266702, -0.554415>
    }
    triangle {
      <-1.392804, -0.230289, -0.568022>,
      <-1.410734, -0.266702, -0.554415>,
      < -1.404764, -0.177508, -0.270512>
    }
    triangle {
      <-1.404764, -0.177508, -0.270512>,
      <-1.416693, -0.156329, -0.280677>,
      < -1.392804, -0.230289, -0.568022>
    }
    triangle {
      <-1.356328, -0.172472, -0.267771>,
      <-1.355091, -0.026546, -0.008357>,
      < -1.363293, -0.065484, 0.007299>
    }
    triangle {
      <-1.363293, -0.065484, 0.007299>,
      <-1.379834, -0.184347, -0.265110>,
      < -1.356328, -0.172472, -0.267771>
    }
    triangle {
      <-1.357705, -0.318397, -0.527199>,
      <-1.356328, -0.172472, -0.267771>,
      < -1.379834, -0.184347, -0.265110>
    }
    triangle {
      <-1.379834, -0.184347, -0.265110>,
      <-1.396376, -0.303211, -0.537518>,
      < -1.357705, -0.318397, -0.527199>
    }
    triangle {
      <-1.348100, -0.149113, -0.276830>,
      <-1.378532, 0.005447, -0.024256>,
      < -1.355091, -0.026546, -0.008357>
    }
    triangle {
      <-1.355091, -0.026546, -0.008357>,
      <-1.356328, -0.172472, -0.267771>,
      < -1.348100, -0.149113, -0.276830>
    }
    triangle {
      <-1.317595, -0.303607, -0.529424>,
      <-1.348100, -0.149113, -0.276830>,
      < -1.356328, -0.172472, -0.267771>
    }
    triangle {
      <-1.356328, -0.172472, -0.267771>,
      <-1.357705, -0.318397, -0.527199>,
      < -1.317595, -0.303607, -0.529424>
    }
    triangle {
      <-1.360023, -0.127803, -0.287048>,
      <-1.384958, -0.121094, -0.292397>,
      < -1.455820, -0.011438, -0.024885>
    }
    triangle {
      <-1.455820, -0.011438, -0.024885>,
      <-1.420240, 0.011588, -0.031051>,
      < -1.360023, -0.127803, -0.287048>
    }
    triangle {
      <-1.348100, -0.149113, -0.276830>,
      <-1.360023, -0.127803, -0.287048>,
      < -1.420240, 0.011588, -0.031051>
    }
    triangle {
      <-1.420240, 0.011588, -0.031051>,
      <-1.378532, 0.005447, -0.024256>,
      < -1.348100, -0.149113, -0.276830>
    }
    triangle {
      <-1.299738, -0.267260, -0.543011>,
      <-1.314164, -0.230685, -0.559943>,
      < -1.384958, -0.121094, -0.292397>
    }
    triangle {
      <-1.384958, -0.121094, -0.292397>,
      <-1.360023, -0.127803, -0.287048>,
      < -1.299738, -0.267260, -0.543011>
    }
    triangle {
      <-1.317595, -0.303607, -0.529424>,
      <-1.299738, -0.267260, -0.543011>,
      < -1.360023, -0.127803, -0.287048>
    }
    triangle {
      <-1.360023, -0.127803, -0.287048>,
      <-1.348100, -0.149113, -0.276830>,
      < -1.317595, -0.303607, -0.529424>
    }
    triangle {
      <-1.442201, -0.019394, -0.020148>,
      <-1.420240, 0.011588, -0.031051>,
      < -1.455820, -0.011438, -0.024885>
    }
    triangle {
      <-1.464089, -0.050310, -0.009264>,
      <-1.442201, -0.019394, -0.020148>,
      < -1.455820, -0.011438, -0.024885>
    }
    triangle {
      <-1.409553, -0.038396, -0.008821>,
      <-1.378532, 0.005447, -0.024256>,
      < -1.420240, 0.011588, -0.031051>
    }
    triangle {
      <-1.420240, 0.011588, -0.031051>,
      <-1.442201, -0.019394, -0.020148>,
      < -1.409553, -0.038396, -0.008821>
    }
    triangle {
      <-1.440582, -0.082368, 0.006669>,
      <-1.409553, -0.038396, -0.008821>,
      < -1.442201, -0.019394, -0.020148>
    }
    triangle {
      <-1.442201, -0.019394, -0.020148>,
      <-1.464089, -0.050310, -0.009264>,
      < -1.440582, -0.082368, 0.006669>
    }
    triangle {
      <-1.408391, -0.132905, -0.289756>,
      <-1.464089, -0.050310, -0.009264>,
      < -1.455820, -0.011438, -0.024885>
    }
    triangle {
      <-1.455820, -0.011438, -0.024885>,
      <-1.384958, -0.121094, -0.292397>,
      < -1.408391, -0.132905, -0.289756>
    }
    triangle {
      <-1.352767, -0.215564, -0.570227>,
      <-1.408391, -0.132905, -0.289756>,
      < -1.384958, -0.121094, -0.292397>
    }
    triangle {
      <-1.384958, -0.121094, -0.292397>,
      <-1.314164, -0.230685, -0.559943>,
      < -1.352767, -0.215564, -0.570227>
    }
    triangle {
      <-1.416693, -0.156329, -0.280677>,
      <-1.440582, -0.082368, 0.006669>,
      < -1.464089, -0.050310, -0.009264>
    }
    triangle {
      <-1.464089, -0.050310, -0.009264>,
      <-1.408391, -0.132905, -0.289756>,
      < -1.416693, -0.156329, -0.280677>
    }
    triangle {
      <-1.392804, -0.230289, -0.568022>,
      <-1.416693, -0.156329, -0.280677>,
      < -1.408391, -0.132905, -0.289756>
    }
    triangle {
      <-1.408391, -0.132905, -0.289756>,
      <-1.352767, -0.215564, -0.570227>,
      < -1.392804, -0.230289, -0.568022>
    }
    triangle {
      <-1.384253, -0.292517, -0.540824>,
      <-1.357705, -0.318397, -0.527199>,
      < -1.396376, -0.303211, -0.537518>
    }
    triangle {
      <-1.410734, -0.266702, -0.554415>,
      <-1.384253, -0.292517, -0.540824>,
      < -1.396376, -0.303211, -0.537518>
    }
    triangle {
      <-1.355233, -0.266916, -0.548740>,
      <-1.317595, -0.303607, -0.529424>,
      < -1.357705, -0.318397, -0.527199>
    }
    triangle {
      <-1.357705, -0.318397, -0.527199>,
      <-1.384253, -0.292517, -0.540824>,
      < -1.355233, -0.266916, -0.548740>
    }
    triangle {
      <-1.392804, -0.230289, -0.568022>,
      <-1.355233, -0.266916, -0.548740>,
      < -1.384253, -0.292517, -0.540824>
    }
    triangle {
      <-1.384253, -0.292517, -0.540824>,
      <-1.410734, -0.266702, -0.554415>,
      < -1.392804, -0.230289, -0.568022>
    }
    triangle {
      <-1.326286, -0.241379, -0.556636>,
      <-1.352767, -0.215564, -0.570227>,
      < -1.314164, -0.230685, -0.559943>
    }
    triangle {
      <-1.299738, -0.267260, -0.543011>,
      <-1.326286, -0.241379, -0.556636>,
      < -1.314164, -0.230685, -0.559943>
    }
    triangle {
      <-1.355233, -0.266916, -0.548740>,
      <-1.392804, -0.230289, -0.568022>,
      < -1.352767, -0.215564, -0.570227>
    }
    triangle {
      <-1.352767, -0.215564, -0.570227>,
      <-1.326286, -0.241379, -0.556636>,
      < -1.355233, -0.266916, -0.548740>
    }
    triangle {
      <-1.317595, -0.303607, -0.529424>,
      <-1.355233, -0.266916, -0.548740>,
      < -1.326286, -0.241379, -0.556636>
    }
    triangle {
      <-1.326286, -0.241379, -0.556636>,
      <-1.299738, -0.267260, -0.543011>,
      < -1.317595, -0.303607, -0.529424>
    }
    triangle {
      <-0.910704, 0.221824, -0.000066>,
      <-0.934252, 0.188569, 0.011640>,
      < -0.895991, 0.213211, 0.005060>
    }
    triangle {
      <-0.887156, 0.255079, -0.011772>,
      <-0.910704, 0.221824, -0.000066>,
      < -0.895991, 0.213211, 0.005060>
    }
    triangle {
      <-0.945815, 0.242272, -0.012253>,
      <-0.979177, 0.195117, 0.004349>,
      < -0.934252, 0.188569, 0.011640>
    }
    triangle {
      <-0.934252, 0.188569, 0.011640>,
      <-0.910704, 0.221824, -0.000066>,
      < -0.945815, 0.242272, -0.012253>
    }
    triangle {
      <-0.912380, 0.289492, -0.028875>,
      <-0.945815, 0.242272, -0.012253>,
      < -0.910704, 0.221824, -0.000066>
    }
    triangle {
      <-0.910704, 0.221824, -0.000066>,
      <-0.887156, 0.255079, -0.011772>,
      < -0.912380, 0.289492, -0.028875>
    }
    triangle {
      <-0.940613, 0.092727, -0.293697>,
      <-0.913738, 0.085356, -0.287874>,
      < -0.895991, 0.213211, 0.005060>
    }
    triangle {
      <-0.895991, 0.213211, 0.005060>,
      <-0.934252, 0.188569, 0.011640>,
      < -0.940613, 0.092727, -0.293697>
    }
    triangle {
      <-0.953451, 0.115475, -0.304617>,
      <-0.940613, 0.092727, -0.293697>,
      < -0.934252, 0.188569, 0.011640>
    }
    triangle {
      <-0.934252, 0.188569, 0.011640>,
      <-0.979177, 0.195117, 0.004349>,
      < -0.953451, 0.115475, -0.304617>
    }
    triangle {
      <-0.947046, -0.003180, -0.599015>,
      <-0.931553, -0.042433, -0.580843>,
      < -0.913738, 0.085356, -0.287874>
    }
    triangle {
      <-0.913738, 0.085356, -0.287874>,
      <-0.940613, 0.092727, -0.293697>,
      < -0.947046, -0.003180, -0.599015>
    }
    triangle {
      <-0.927792, 0.035898, -0.613617>,
      <-0.947046, -0.003180, -0.599015>,
      < -0.940613, 0.092727, -0.293697>
    }
    triangle {
      <-0.940613, 0.092727, -0.293697>,
      <-0.953451, 0.115475, -0.304617>,
      < -0.927792, 0.035898, -0.613617>
    }
    triangle {
      <-0.888567, 0.098201, -0.290778>,
      <-0.887156, 0.255079, -0.011772>,
      < -0.895991, 0.213211, 0.005060>
    }
    triangle {
      <-0.895991, 0.213211, 0.005060>,
      <-0.913738, 0.085356, -0.287874>,
      < -0.888567, 0.098201, -0.290778>
    }
    triangle {
      <-0.890052, -0.058742, -0.569765>,
      <-0.888567, 0.098201, -0.290778>,
      < -0.913738, 0.085356, -0.287874>
    }
    triangle {
      <-0.913738, 0.085356, -0.287874>,
      <-0.931553, -0.042433, -0.580843>,
      < -0.890052, -0.058742, -0.569765>
    }
    triangle {
      <-0.879622, 0.123316, -0.300508>,
      <-0.912380, 0.289492, -0.028875>,
      < -0.887156, 0.255079, -0.011772>
    }
    triangle {
      <-0.887156, 0.255079, -0.011772>,
      <-0.888567, 0.098201, -0.290778>,
      < -0.879622, 0.123316, -0.300508>
    }
    triangle {
      <-0.846938, -0.042924, -0.572122>,
      <-0.879622, 0.123316, -0.300508>,
      < -0.888567, 0.098201, -0.290778>
    }
    triangle {
      <-0.888567, 0.098201, -0.290778>,
      <-0.890052, -0.058742, -0.569765>,
      < -0.846938, -0.042924, -0.572122>
    }
    triangle {
      <-0.892527, 0.146130, -0.311463>,
      <-0.919334, 0.153435, -0.317251>,
      < -0.995498, 0.271333, -0.029552>
    }
    triangle {
      <-0.995498, 0.271333, -0.029552>,
      <-0.957304, 0.296040, -0.036166>,
      < -0.892527, 0.146130, -0.311463>
    }
    triangle {
      <-0.879622, 0.123316, -0.300508>,
      <-0.892527, 0.146130, -0.311463>,
      < -0.957304, 0.296040, -0.036166>
    }
    triangle {
      <-0.957304, 0.296040, -0.036166>,
      <-0.912380, 0.289492, -0.028875>,
      < -0.879622, 0.123316, -0.300508>
    }
    triangle {
      <-0.827750, -0.003780, -0.586759>,
      <-0.843170, 0.035537, -0.604951>,
      < -0.919334, 0.153435, -0.317251>
    }
    triangle {
      <-0.919334, 0.153435, -0.317251>,
      <-0.892527, 0.146130, -0.311463>,
      < -0.827750, -0.003780, -0.586759>
    }
    triangle {
      <-0.846938, -0.042924, -0.572122>,
      <-0.827750, -0.003780, -0.586759>,
      < -0.892527, 0.146130, -0.311463>
    }
    triangle {
      <-0.892527, 0.146130, -0.311463>,
      <-0.879622, 0.123316, -0.300508>,
      < -0.846938, -0.042924, -0.572122>
    }
    triangle {
      <-0.980853, 0.262785, -0.024460>,
      <-0.957304, 0.296040, -0.036166>,
      < -0.995498, 0.271333, -0.029552>
    }
    triangle {
      <-1.004401, 0.229530, -0.012754>,
      <-0.980853, 0.262785, -0.024460>,
      < -0.995498, 0.271333, -0.029552>
    }
    triangle {
      <-0.945815, 0.242272, -0.012253>,
      <-0.912380, 0.289492, -0.028875>,
      < -0.957304, 0.296040, -0.036166>
    }
    triangle {
      <-0.957304, 0.296040, -0.036166>,
      <-0.980853, 0.262785, -0.024460>,
      < -0.945815, 0.242272, -0.012253>
    }
    triangle {
      <-0.979177, 0.195117, 0.004349>,
      <-0.945815, 0.242272, -0.012253>,
      < -0.980853, 0.262785, -0.024460>
    }
    triangle {
      <-0.980853, 0.262785, -0.024460>,
      <-1.004401, 0.229530, -0.012754>,
      < -0.979177, 0.195117, 0.004349>
    }
    triangle {
      <-0.944573, 0.140656, -0.314382>,
      <-1.004401, 0.229530, -0.012754>,
      < -0.995498, 0.271333, -0.029552>
    }
    triangle {
      <-0.995498, 0.271333, -0.029552>,
      <-0.919334, 0.153435, -0.317251>,
      < -0.944573, 0.140656, -0.314382>
    }
    triangle {
      <-0.884745, 0.051781, -0.616009>,
      <-0.944573, 0.140656, -0.314382>,
      < -0.919334, 0.153435, -0.317251>
    }
    triangle {
      <-0.919334, 0.153435, -0.317251>,
      <-0.843170, 0.035537, -0.604951>,
      < -0.884745, 0.051781, -0.616009>
    }
    triangle {
      <-0.953451, 0.115475, -0.304617>,
      <-0.979177, 0.195117, 0.004349>,
      < -1.004401, 0.229530, -0.012754>
    }
    triangle {
      <-1.004401, 0.229530, -0.012754>,
      <-0.944573, 0.140656, -0.314382>,
      < -0.953451, 0.115475, -0.304617>
    }
    triangle {
      <-0.927792, 0.035898, -0.613617>,
      <-0.953451, 0.115475, -0.304617>,
      < -0.944573, 0.140656, -0.314382>
    }
    triangle {
      <-0.944573, 0.140656, -0.314382>,
      <-0.884745, 0.051781, -0.616009>,
      < -0.927792, 0.035898, -0.613617>
    }
    triangle {
      <-0.918549, -0.030961, -0.584390>,
      <-0.890052, -0.058742, -0.569765>,
      < -0.931553, -0.042433, -0.580843>
    }
    triangle {
      <-0.947046, -0.003180, -0.599015>,
      <-0.918549, -0.030961, -0.584390>,
      < -0.931553, -0.042433, -0.580843>
    }
    triangle {
      <-0.887398, -0.003480, -0.592887>,
      <-0.846938, -0.042924, -0.572122>,
      < -0.890052, -0.058742, -0.569765>
    }
    triangle {
      <-0.890052, -0.058742, -0.569765>,
      <-0.918549, -0.030961, -0.584390>,
      < -0.887398, -0.003480, -0.592887>
    }
    triangle {
      <-0.927792, 0.035898, -0.613617>,
      <-0.887398, -0.003480, -0.592887>,
      < -0.918549, -0.030961, -0.584390>
    }
    triangle {
      <-0.918549, -0.030961, -0.584390>,
      <-0.947046, -0.003180, -0.599015>,
      < -0.927792, 0.035898, -0.613617>
    }
    triangle {
      <-0.856248, 0.024001, -0.601384>,
      <-0.884745, 0.051781, -0.616009>,
      < -0.843170, 0.035537, -0.604951>
    }
    triangle {
      <-0.827750, -0.003780, -0.586759>,
      <-0.856248, 0.024001, -0.601384>,
      < -0.843170, 0.035537, -0.604951>
    }
    triangle {
      <-0.887398, -0.003480, -0.592887>,
      <-0.927792, 0.035898, -0.613617>,
      < -0.884745, 0.051781, -0.616009>
    }
    triangle {
      <-0.884745, 0.051781, -0.616009>,
      <-0.856248, 0.024001, -0.601384>,
      < -0.887398, -0.003480, -0.592887>
    }
    triangle {
      <-0.846938, -0.042924, -0.572122>,
      <-0.887398, -0.003480, -0.592887>,
      < -0.856248, 0.024001, -0.601384>
    }
    triangle {
      <-0.856248, 0.024001, -0.601384>,
      <-0.827750, -0.003780, -0.586759>,
      < -0.846938, -0.042924, -0.572122>
    }
    triangle {
      <-0.429029, 0.470407, -0.090406>,
      <-0.454243, 0.434683, -0.077823>,
      < -0.413289, 0.461202, -0.084927>
    }
    triangle {
      <-0.403741, 0.506195, -0.103009>,
      <-0.429029, 0.470407, -0.090406>,
      < -0.413289, 0.461202, -0.084927>
    }
    triangle {
      <-0.466664, 0.492498, -0.103542>,
      <-0.502593, 0.441706, -0.085659>,
      < -0.454243, 0.434683, -0.077823>
    }
    triangle {
      <-0.454243, 0.434683, -0.077823>,
      <-0.429029, 0.470407, -0.090406>,
      < -0.466664, 0.492498, -0.103542>
    }
    triangle {
      <-0.430809, 0.543225, -0.121405>,
      <-0.466664, 0.492498, -0.103542>,
      < -0.429029, 0.470407, -0.090406>
    }
    triangle {
      <-0.429029, 0.470407, -0.090406>,
      <-0.403741, 0.506195, -0.103009>,
      < -0.430809, 0.543225, -0.121405>
    }
    triangle {
      <-0.461213, 0.331717, -0.405943>,
      <-0.432321, 0.323880, -0.399719>,
      < -0.413289, 0.461202, -0.084927>
    }
    triangle {
      <-0.413289, 0.461202, -0.084927>,
      <-0.454243, 0.434683, -0.077823>,
      < -0.461213, 0.331717, -0.405943>
    }
    triangle {
      <-0.475022, 0.356230, -0.417707>,
      <-0.461213, 0.331717, -0.405943>,
      < -0.454243, 0.434683, -0.077823>
    }
    triangle {
      <-0.454243, 0.434683, -0.077823>,
      <-0.502593, 0.441706, -0.085659>,
      < -0.475022, 0.356230, -0.417707>
    }
    triangle {
      <-0.468033, 0.228711, -0.734140>,
      <-0.451418, 0.186454, -0.714583>,
      < -0.432321, 0.323880, -0.399719>
    }
    triangle {
      <-0.432321, 0.323880, -0.399719>,
      <-0.461213, 0.331717, -0.405943>,
      < -0.468033, 0.228711, -0.734140>
    }
    triangle {
      <-0.447369, 0.270780, -0.749867>,
      <-0.468033, 0.228711, -0.734140>,
      < -0.461213, 0.331717, -0.405943>
    }
    triangle {
      <-0.461213, 0.331717, -0.405943>,
      <-0.475022, 0.356230, -0.417707>,
      < -0.447369, 0.270780, -0.749867>
    }
    triangle {
      <-0.405277, 0.337628, -0.402817>,
      <-0.403741, 0.506195, -0.103009>,
      < -0.413289, 0.461202, -0.084927>
    }
    triangle {
      <-0.413289, 0.461202, -0.084927>,
      <-0.432321, 0.323880, -0.399719>,
      < -0.405277, 0.337628, -0.402817>
    }
    triangle {
      <-0.406737, 0.168956, -0.702682>,
      <-0.405277, 0.337628, -0.402817>,
      < -0.432321, 0.323880, -0.399719>
    }
    triangle {
      <-0.432321, 0.323880, -0.399719>,
      <-0.451418, 0.186454, -0.714583>,
      < -0.406737, 0.168956, -0.702682>
    }
    triangle {
      <-0.395608, 0.364630, -0.413273>,
      <-0.430809, 0.543225, -0.121405>,
      < -0.403741, 0.506195, -0.103009>
    }
    triangle {
      <-0.403741, 0.506195, -0.103009>,
      <-0.405277, 0.337628, -0.402817>,
      < -0.395608, 0.364630, -0.413273>
    }
    triangle {
      <-0.360398, 0.185996, -0.705232>,
      <-0.395608, 0.364630, -0.413273>,
      < -0.405277, 0.337628, -0.402817>
    }
    triangle {
      <-0.405277, 0.337628, -0.402817>,
      <-0.406737, 0.168956, -0.702682>,
      < -0.360398, 0.185996, -0.705232>
    }
    triangle {
      <-0.409417, 0.389143, -0.425037>,
      <-0.438236, 0.397045, -0.431281>,
      < -0.520113, 0.523728, -0.122138>
    }
    triangle {
      <-0.520113, 0.523728, -0.122138>,
      <-0.479017, 0.550246, -0.129227>,
      < -0.409417, 0.389143, -0.425037>
    }
    triangle {
      <-0.395608, 0.364630, -0.413273>,
      <-0.409417, 0.389143, -0.425037>,
      < -0.479017, 0.550246, -0.129227>
    }
    triangle {
      <-0.479017, 0.550246, -0.129227>,
      <-0.430809, 0.543225, -0.121405>,
      < -0.395608, 0.364630, -0.413273>
    }
    triangle {
      <-0.339807, 0.228000, -0.720939>,
      <-0.356423, 0.270257, -0.740496>,
      < -0.438236, 0.397045, -0.431281>
    }
    triangle {
      <-0.438236, 0.397045, -0.431281>,
      <-0.409417, 0.389143, -0.425037>,
      < -0.339807, 0.228000, -0.720939>
    }
    triangle {
      <-0.360398, 0.185996, -0.705232>,
      <-0.339807, 0.228000, -0.720939>,
      < -0.409417, 0.389143, -0.425037>
    }
    triangle {
      <-0.409417, 0.389143, -0.425037>,
      <-0.395608, 0.364630, -0.413273>,
      < -0.360398, 0.185996, -0.705232>
    }
    triangle {
      <-0.504373, 0.514524, -0.116659>,
      <-0.479017, 0.550246, -0.129227>,
      < -0.520113, 0.523728, -0.122138>
    }
    triangle {
      <-0.529661, 0.478735, -0.104055>,
      <-0.504373, 0.514524, -0.116659>,
      < -0.520113, 0.523728, -0.122138>
    }
    triangle {
      <-0.466664, 0.492498, -0.103542>,
      <-0.430809, 0.543225, -0.121405>,
      < -0.479017, 0.550246, -0.129227>
    }
    triangle {
      <-0.479017, 0.550246, -0.129227>,
      <-0.504373, 0.514524, -0.116659>,
      < -0.466664, 0.492498, -0.103542>
    }
    triangle {
      <-0.502593, 0.441706, -0.085659>,
      <-0.466664, 0.492498, -0.103542>,
      < -0.504373, 0.514524, -0.116659>
    }
    triangle {
      <-0.504373, 0.514524, -0.116659>,
      <-0.529661, 0.478735, -0.104055>,
      < -0.502593, 0.441706, -0.085659>
    }
    triangle {
      <-0.465353, 0.383232, -0.428163>,
      <-0.529661, 0.478735, -0.104055>,
      < -0.520113, 0.523728, -0.122138>
    }
    triangle {
      <-0.520113, 0.523728, -0.122138>,
      <-0.438236, 0.397045, -0.431281>,
      < -0.465353, 0.383232, -0.428163>
    }
    triangle {
      <-0.401103, 0.287755, -0.752397>,
      <-0.465353, 0.383232, -0.428163>,
      < -0.438236, 0.397045, -0.431281>
    }
    triangle {
      <-0.438236, 0.397045, -0.431281>,
      <-0.356423, 0.270257, -0.740496>,
      < -0.401103, 0.287755, -0.752397>
    }
    triangle {
      <-0.475022, 0.356230, -0.417707>,
      <-0.502593, 0.441706, -0.085659>,
      < -0.529661, 0.478735, -0.104055>
    }
    triangle {
      <-0.529661, 0.478735, -0.104055>,
      <-0.465353, 0.383232, -0.428163>,
      < -0.475022, 0.356230, -0.417707>
    }
    triangle {
      <-0.447369, 0.270780, -0.749867>,
      <-0.475022, 0.356230, -0.417707>,
      < -0.465353, 0.383232, -0.428163>
    }
    triangle {
      <-0.465353, 0.383232, -0.428163>,
      <-0.401103, 0.287755, -0.752397>,
      < -0.447369, 0.270780, -0.749867>
    }
    triangle {
      <-0.437385, 0.198833, -0.718411>,
      <-0.406737, 0.168956, -0.702682>,
      < -0.451418, 0.186454, -0.714583>
    }
    triangle {
      <-0.468033, 0.228711, -0.734140>,
      <-0.437385, 0.198833, -0.718411>,
      < -0.451418, 0.186454, -0.714583>
    }
    triangle {
      <-0.403884, 0.228388, -0.727549>,
      <-0.360398, 0.185996, -0.705232>,
      < -0.406737, 0.168956, -0.702682>
    }
    triangle {
      <-0.406737, 0.168956, -0.702682>,
      <-0.437385, 0.198833, -0.718411>,
      < -0.403884, 0.228388, -0.727549>
    }
    triangle {
      <-0.447369, 0.270780, -0.749867>,
      <-0.403884, 0.228388, -0.727549>,
      < -0.437385, 0.198833, -0.718411>
    }
    triangle {
      <-0.437385, 0.198833, -0.718411>,
      <-0.468033, 0.228711, -0.734140>,
      < -0.447369, 0.270780, -0.749867>
    }
    triangle {
      <-0.370455, 0.257878, -0.736668>,
      <-0.401103, 0.287755, -0.752397>,
      < -0.356423, 0.270257, -0.740496>
    }
    triangle {
      <-0.339807, 0.228000, -0.720939>,
      <-0.370455, 0.257878, -0.736668>,
      < -0.356423, 0.270257, -0.740496>
    }
    triangle {
      <-0.403884, 0.228388, -0.727549>,
      <-0.447369, 0.270780, -0.749867>,
      < -0.401103, 0.287755, -0.752397>
    }
    triangle {
      <-0.401103, 0.287755, -0.752397>,
      <-0.370455, 0.257878, -0.736668>,
      < -0.403884, 0.228388, -0.727549>
    }
    triangle {
      <-0.360398, 0.185996, -0.705232>,
      <-0.403884, 0.228388, -0.727549>,
      < -0.370455, 0.257878, -0.736668>
    }
    triangle {
      <-0.370455, 0.257878, -0.736668>,
      <-0.339807, 0.228000, -0.720939>,
      < -0.360398, 0.185996, -0.705232>
    }
    triangle {
      <0.097698, 0.698875, -0.082638>,
      <0.076944, 0.669582, -0.072328>,
      < 0.110186, 0.690794, -0.077962>
    }
    triangle {
      <0.118312, 0.728168, -0.092963>,
      <0.097698, 0.698875, -0.082638>,
      < 0.110186, 0.690794, -0.077962>
    }
    triangle {
      <0.066382, 0.716306, -0.093167>,
      <0.037021, 0.674802, -0.078554>,
      < 0.076944, 0.669582, -0.072328>
    }
    triangle {
      <0.076944, 0.669582, -0.072328>,
      <0.097698, 0.698875, -0.082638>,
      < 0.066382, 0.716306, -0.093167>
    }
    triangle {
      <0.095818, 0.757874, -0.107799>,
      <0.066382, 0.716306, -0.093167>,
      < 0.097698, 0.698875, -0.082638>
    }
    triangle {
      <0.097698, 0.698875, -0.082638>,
      <0.118312, 0.728168, -0.092963>,
      < 0.095818, 0.757874, -0.107799>
    }
    triangle {
      <0.071129, 0.584948, -0.340914>,
      <0.094517, 0.578247, -0.335725>,
      < 0.110186, 0.690794, -0.077962>
    }
    triangle {
      <0.110186, 0.690794, -0.077962>,
      <0.076944, 0.669582, -0.072328>,
      < 0.071129, 0.584948, -0.340914>
    }
    triangle {
      <0.059627, 0.604756, -0.350455>,
      <0.071129, 0.584948, -0.340914>,
      < 0.076944, 0.669582, -0.072328>
    }
    triangle {
      <0.076944, 0.669582, -0.072328>,
      <0.037021, 0.674802, -0.078554>,
      < 0.059627, 0.604756, -0.350455>
    }
    triangle {
      <0.065305, 0.500353, -0.609409>,
      <0.078913, 0.465803, -0.593417>,
      < 0.094517, 0.578247, -0.335725>
    }
    triangle {
      <0.094517, 0.578247, -0.335725>,
      <0.071129, 0.584948, -0.340914>,
      < 0.065305, 0.500353, -0.609409>
    }
    triangle {
      <0.082224, 0.534749, -0.622265>,
      <0.065305, 0.500353, -0.609409>,
      < 0.071129, 0.584948, -0.340914>
    }
    triangle {
      <0.071129, 0.584948, -0.340914>,
      <0.059627, 0.604756, -0.350455>,
      < 0.082224, 0.534749, -0.622265>
    }
    triangle {
      <0.116953, 0.589802, -0.338358>,
      <0.118312, 0.728168, -0.092963>,
      < 0.110186, 0.690794, -0.077962>
    }
    triangle {
      <0.110186, 0.690794, -0.077962>,
      <0.094517, 0.578247, -0.335725>,
      < 0.116953, 0.589802, -0.338358>
    }
    triangle {
      <0.115444, 0.451474, -0.583677>,
      <0.116953, 0.589802, -0.338358>,
      < 0.094517, 0.578247, -0.335725>
    }
    triangle {
      <0.094517, 0.578247, -0.335725>,
      <0.078913, 0.465803, -0.593417>,
      < 0.115444, 0.451474, -0.583677>
    }
    triangle {
      <0.124616, 0.611664, -0.346841>,
      <0.095818, 0.757874, -0.107799>,
      < 0.118312, 0.728168, -0.092963>
    }
    triangle {
      <0.118312, 0.728168, -0.092963>,
      <0.116953, 0.589802, -0.338358>,
      < 0.124616, 0.611664, -0.346841>
    }
    triangle {
      <0.153333, 0.465428, -0.585771>,
      <0.124616, 0.611664, -0.346841>,
      < 0.116953, 0.589802, -0.338358>
    }
    triangle {
      <0.116953, 0.589802, -0.338358>,
      <0.115444, 0.451474, -0.583677>,
      < 0.153333, 0.465428, -0.585771>
    }
    triangle {
      <0.111603, 0.630763, -0.356234>,
      <0.086934, 0.635711, -0.360810>,
      < 0.017143, 0.737021, -0.106888>
    }
    triangle {
      <0.017143, 0.737021, -0.106888>,
      <0.052804, 0.761741, -0.113763>,
      < 0.111603, 0.630763, -0.356234>
    }
    triangle {
      <0.124616, 0.611664, -0.346841>,
      <0.111603, 0.630763, -0.356234>,
      < 0.052804, 0.761741, -0.113763>
    }
    triangle {
      <0.052804, 0.761741, -0.113763>,
      <0.095818, 0.757874, -0.107799>,
      < 0.124616, 0.611664, -0.346841>
    }
    triangle {
      <0.170325, 0.499890, -0.598647>,
      <0.156717, 0.534440, -0.614639>,
      < 0.086934, 0.635711, -0.360810>
    }
    triangle {
      <0.086934, 0.635711, -0.360810>,
      <0.111603, 0.630763, -0.356234>,
      < 0.170325, 0.499890, -0.598647>
    }
    triangle {
      <0.153333, 0.465428, -0.585771>,
      <0.170325, 0.499890, -0.598647>,
      < 0.111603, 0.630763, -0.356234>
    }
    triangle {
      <0.111603, 0.630763, -0.356234>,
      <0.124616, 0.611664, -0.346841>,
      < 0.153333, 0.465428, -0.585771>
    }
    triangle {
      <0.032894, 0.732444, -0.103366>,
      <0.052804, 0.761741, -0.113763>,
      < 0.017143, 0.737021, -0.106888>
    }
    triangle {
      <0.012377, 0.702237, -0.092646>,
      <0.032894, 0.732444, -0.103366>,
      < 0.017143, 0.737021, -0.106888>
    }
    triangle {
      <0.066382, 0.716306, -0.093167>,
      <0.095818, 0.757874, -0.107799>,
      < 0.052804, 0.761741, -0.113763>
    }
    triangle {
      <0.052804, 0.761741, -0.113763>,
      <0.032894, 0.732444, -0.103366>,
      < 0.066382, 0.716306, -0.093167>
    }
    triangle {
      <0.037021, 0.674802, -0.078554>,
      <0.066382, 0.716306, -0.093167>,
      < 0.032894, 0.732444, -0.103366>
    }
    triangle {
      <0.032894, 0.732444, -0.103366>,
      <0.012377, 0.702237, -0.092646>,
      < 0.037021, 0.674802, -0.078554>
    }
    triangle {
      <0.066323, 0.625516, -0.358568>,
      <0.012377, 0.702237, -0.092646>,
      < 0.017143, 0.737021, -0.106888>
    }
    triangle {
      <0.017143, 0.737021, -0.106888>,
      <0.086934, 0.635711, -0.360810>,
      < 0.066323, 0.625516, -0.358568>
    }
    triangle {
      <0.120186, 0.548768, -0.624379>,
      <0.066323, 0.625516, -0.358568>,
      < 0.086934, 0.635711, -0.360810>
    }
    triangle {
      <0.086934, 0.635711, -0.360810>,
      <0.156717, 0.534440, -0.614639>,
      < 0.120186, 0.548768, -0.624379>
    }
    triangle {
      <0.059627, 0.604756, -0.350455>,
      <0.037021, 0.674802, -0.078554>,
      < 0.012377, 0.702237, -0.092646>
    }
    triangle {
      <0.012377, 0.702237, -0.092646>,
      <0.066323, 0.625516, -0.358568>,
      < 0.059627, 0.604756, -0.350455>
    }
    triangle {
      <0.082224, 0.534749, -0.622265>,
      <0.059627, 0.604756, -0.350455>,
      < 0.066323, 0.625516, -0.358568>
    }
    triangle {
      <0.066323, 0.625516, -0.358568>,
      <0.120186, 0.548768, -0.624379>,
      < 0.082224, 0.534749, -0.622265>
    }
    triangle {
      <0.090375, 0.475914, -0.596543>,
      <0.115444, 0.451474, -0.583677>,
      < 0.078913, 0.465803, -0.593417>
    }
    triangle {
      <0.065305, 0.500353, -0.609409>,
      <0.090375, 0.475914, -0.596543>,
      < 0.078913, 0.465803, -0.593417>
    }
    triangle {
      <0.117778, 0.500089, -0.604018>,
      <0.153333, 0.465428, -0.585771>,
      < 0.115444, 0.451474, -0.583677>
    }
    triangle {
      <0.115444, 0.451474, -0.583677>,
      <0.090375, 0.475914, -0.596543>,
      < 0.117778, 0.500089, -0.604018>
    }
    triangle {
      <0.082224, 0.534749, -0.622265>,
      <0.117778, 0.500089, -0.604018>,
      < 0.090375, 0.475914, -0.596543>
    }
    triangle {
      <0.090375, 0.475914, -0.596543>,
      <0.065305, 0.500353, -0.609409>,
      < 0.082224, 0.534749, -0.622265>
    }
    triangle {
      <0.145256, 0.524329, -0.611513>,
      <0.120186, 0.548768, -0.624379>,
      < 0.156717, 0.534440, -0.614639>
    }
    triangle {
      <0.170325, 0.499890, -0.598647>,
      <0.145256, 0.524329, -0.611513>,
      < 0.156717, 0.534440, -0.614639>
    }
    triangle {
      <0.117778, 0.500089, -0.604018>,
      <0.082224, 0.534749, -0.622265>,
      < 0.120186, 0.548768, -0.624379>
    }
    triangle {
      <0.120186, 0.548768, -0.624379>,
      <0.145256, 0.524329, -0.611513>,
      < 0.117778, 0.500089, -0.604018>
    }
    triangle {
      <0.153333, 0.465428, -0.585771>,
      <0.117778, 0.500089, -0.604018>,
      < 0.145256, 0.524329, -0.611513>
    }
    triangle {
      <0.145256, 0.524329, -0.611513>,
      <0.170325, 0.499890, -0.598647>,
      < 0.153333, 0.465428, -0.585771>
    }
    triangle {
      <0.612319, 0.812486, 0.038720>,
      <0.600707, 0.781647, 0.050604>,
      < 0.647199, 0.815048, 0.041144>
    }
    triangle {
      <0.624349, 0.844690, 0.026299>,
      <0.612319, 0.812486, 0.038720>,
      < 0.647199, 0.815048, 0.041144>
    }
    triangle {
      <0.553868, 0.827446, 0.026507>,
      <0.539272, 0.791604, 0.040209>,
      < 0.600707, 0.781647, 0.050604>
    }
    triangle {
      <0.600707, 0.781647, 0.050604>,
      <0.612319, 0.812486, 0.038720>,
      < 0.553868, 0.827446, 0.026507>
    }
    triangle {
      <0.568471, 0.863418, 0.012751>,
      <0.553868, 0.827446, 0.026507>,
      < 0.612319, 0.812486, 0.038720>
    }
    triangle {
      <0.612319, 0.812486, 0.038720>,
      <0.624349, 0.844690, 0.026299>,
      < 0.568471, 0.863418, 0.012751>
    }
    triangle {
      <0.561645, 0.780891, -0.055625>,
      <0.594855, 0.772120, -0.048572>,
      < 0.647199, 0.815048, 0.041144>
    }
    triangle {
      <0.647199, 0.815048, 0.041144>,
      <0.600707, 0.781647, 0.050604>,
      < 0.561645, 0.780891, -0.055625>
    }
    triangle {
      <0.543402, 0.811227, -0.070301>,
      <0.561645, 0.780891, -0.055625>,
      < 0.600707, 0.781647, 0.050604>
    }
    triangle {
      <0.600707, 0.781647, 0.050604>,
      <0.539272, 0.791604, 0.040209>,
      < 0.543402, 0.811227, -0.070301>
    }
    triangle {
      <0.522593, 0.780096, -0.161946>,
      <0.542587, 0.729087, -0.138345>,
      < 0.594855, 0.772120, -0.048572>
    }
    triangle {
      <0.594855, 0.772120, -0.048572>,
      <0.561645, 0.780891, -0.055625>,
      < 0.522593, 0.780096, -0.161946>
    }
    triangle {
      <0.547475, 0.830878, -0.180936>,
      <0.522593, 0.780096, -0.161946>,
      < 0.561645, 0.780891, -0.055625>
    }
    triangle {
      <0.561645, 0.780891, -0.055625>,
      <0.543402, 0.811227, -0.070301>,
      < 0.547475, 0.830878, -0.180936>
    }
    triangle {
      <0.610395, 0.776344, -0.048796>,
      <0.624349, 0.844690, 0.026299>,
      < 0.647199, 0.815048, 0.041144>
    }
    triangle {
      <0.647199, 0.815048, 0.041144>,
      <0.594855, 0.772120, -0.048572>,
      < 0.610395, 0.776344, -0.048796>
    }
    triangle {
      <0.596524, 0.708023, -0.124003>,
      <0.610395, 0.776344, -0.048796>,
      < 0.594855, 0.772120, -0.048572>
    }
    triangle {
      <0.594855, 0.772120, -0.048572>,
      <0.542587, 0.729087, -0.138345>,
      < 0.596524, 0.708023, -0.124003>
    }
    triangle {
      <0.610423, 0.795963, -0.057097>,
      <0.568471, 0.863418, 0.012751>,
      < 0.624349, 0.844690, 0.026299>
    }
    triangle {
      <0.624349, 0.844690, 0.026299>,
      <0.610395, 0.776344, -0.048796>,
      < 0.610423, 0.795963, -0.057097>
    }
    triangle {
      <0.652457, 0.728534, -0.127057>,
      <0.610423, 0.795963, -0.057097>,
      < 0.610395, 0.776344, -0.048796>
    }
    triangle {
      <0.610395, 0.776344, -0.048796>,
      <0.596524, 0.708023, -0.124003>,
      < 0.652457, 0.728534, -0.127057>
    }
    triangle {
      <0.608311, 0.834041, -0.073426>,
      <0.587629, 0.860479, -0.086696>,
      < 0.518063, 0.890592, -0.003822>
    }
    triangle {
      <0.518063, 0.890592, -0.003822>,
      <0.539218, 0.888661, -0.000876>,
      < 0.608311, 0.834041, -0.073426>
    }
    triangle {
      <0.610423, 0.795963, -0.057097>,
      <0.608311, 0.834041, -0.073426>,
      < 0.539218, 0.888661, -0.000876>
    }
    triangle {
      <0.539218, 0.888661, -0.000876>,
      <0.568471, 0.863418, 0.012751>,
      < 0.610423, 0.795963, -0.057097>
    }
    triangle {
      <0.677413, 0.779382, -0.146067>,
      <0.657345, 0.830325, -0.169648>,
      < 0.587629, 0.860479, -0.086696>
    }
    triangle {
      <0.587629, 0.860479, -0.086696>,
      <0.608311, 0.834041, -0.073426>,
      < 0.677413, 0.779382, -0.146067>
    }
    triangle {
      <0.652457, 0.728534, -0.127057>,
      <0.677413, 0.779382, -0.146067>,
      < 0.608311, 0.834041, -0.073426>
    }
    triangle {
      <0.608311, 0.834041, -0.073426>,
      <0.610423, 0.795963, -0.057097>,
      < 0.652457, 0.728534, -0.127057>
    }
    triangle {
      <0.523528, 0.859342, 0.009955>,
      <0.539218, 0.888661, -0.000876>,
      < 0.518063, 0.890592, -0.003822>
    }
    triangle {
      <0.509758, 0.834838, 0.018941>,
      <0.523528, 0.859342, 0.009955>,
      < 0.518063, 0.890592, -0.003822>
    }
    triangle {
      <0.553868, 0.827446, 0.026507>,
      <0.568471, 0.863418, 0.012751>,
      < 0.539218, 0.888661, -0.000876>
    }
    triangle {
      <0.539218, 0.888661, -0.000876>,
      <0.523528, 0.859342, 0.009955>,
      < 0.553868, 0.827446, 0.026507>
    }
    triangle {
      <0.539272, 0.791604, 0.040209>,
      <0.553868, 0.827446, 0.026507>,
      < 0.523528, 0.859342, 0.009955>
    }
    triangle {
      <0.523528, 0.859342, 0.009955>,
      <0.509758, 0.834838, 0.018941>,
      < 0.539272, 0.791604, 0.040209>
    }
    triangle {
      <0.556545, 0.843166, -0.082496>,
      <0.509758, 0.834838, 0.018941>,
      < 0.518063, 0.890592, -0.003822>
    }
    triangle {
      <0.518063, 0.890592, -0.003822>,
      <0.587629, 0.860479, -0.086696>,
      < 0.556545, 0.843166, -0.082496>
    }
    triangle {
      <0.603482, 0.851455, -0.184010>,
      <0.556545, 0.843166, -0.082496>,
      < 0.587629, 0.860479, -0.086696>
    }
    triangle {
      <0.587629, 0.860479, -0.086696>,
      <0.657345, 0.830325, -0.169648>,
      < 0.603482, 0.851455, -0.184010>
    }
    triangle {
      <0.543402, 0.811227, -0.070301>,
      <0.539272, 0.791604, 0.040209>,
      < 0.509758, 0.834838, 0.018941>
    }
    triangle {
      <0.509758, 0.834838, 0.018941>,
      <0.556545, 0.843166, -0.082496>,
      < 0.543402, 0.811227, -0.070301>
    }
    triangle {
      <0.547475, 0.830878, -0.180936>,
      <0.543402, 0.811227, -0.070301>,
      < 0.556545, 0.843166, -0.082496>
    }
    triangle {
      <0.556545, 0.843166, -0.082496>,
      <0.603482, 0.851455, -0.184010>,
      < 0.547475, 0.830878, -0.180936>
    }
    triangle {
      <0.559558, 0.744059, -0.142974>,
      <0.596524, 0.708023, -0.124003>,
      < 0.542587, 0.729087, -0.138345>
    }
    triangle {
      <0.522593, 0.780096, -0.161946>,
      <0.559558, 0.744059, -0.142974>,
      < 0.542587, 0.729087, -0.138345>
    }
    triangle {
      <0.599966, 0.779706, -0.153997>,
      <0.652457, 0.728534, -0.127057>,
      < 0.596524, 0.708023, -0.124003>
    }
    triangle {
      <0.596524, 0.708023, -0.124003>,
      <0.559558, 0.744059, -0.142974>,
      < 0.599966, 0.779706, -0.153997>
    }
    triangle {
      <0.547475, 0.830878, -0.180936>,
      <0.599966, 0.779706, -0.153997>,
      < 0.559558, 0.744059, -0.142974>
    }
    triangle {
      <0.559558, 0.744059, -0.142974>,
      <0.522593, 0.780096, -0.161946>,
      < 0.547475, 0.830878, -0.180936>
    }
    triangle {
      <0.640447, 0.815418, -0.165039>,
      <0.603482, 0.851455, -0.184010>,
      < 0.657345, 0.830325, -0.169648>
    }
    triangle {
      <0.677413, 0.779382, -0.146067>,
      <0.640447, 0.815418, -0.165039>,
      < 0.657345, 0.830325, -0.169648>
    }
    triangle {
      <0.599966, 0.779706, -0.153997>,
      <0.547475, 0.830878, -0.180936>,
      < 0.603482, 0.851455, -0.184010>
    }
    triangle {
      <0.603482, 0.851455, -0.184010>,
      <0.640447, 0.815418, -0.165039>,
      < 0.599966, 0.779706, -0.153997>
    }
    triangle {
      <0.652457, 0.728534, -0.127057>,
      <0.599966, 0.779706, -0.153997>,
      < 0.640447, 0.815418, -0.165039>
    }
    triangle {
      <0.640447, 0.815418, -0.165039>,
      <0.677413, 0.779382, -0.146067>,
      < 0.652457, 0.728534, -0.127057>
    }
    triangle {
      <0.287479, 0.010495, -0.458025>,
      <0.241601, -0.033170, -0.451575>,
      < 0.552448, -0.336204, -0.292043>
    }
    triangle {
      <0.552448, -0.336204, -0.292043>,
      <0.598327, -0.292538, -0.298493>,
      < 0.287479, 0.010495, -0.458025>
    }
    triangle {
      <0.333358, 0.054161, -0.464475>,
      <0.287479, 0.010495, -0.458025>,
      < 0.598327, -0.292538, -0.298493>
    }
    triangle {
      <0.598327, -0.292538, -0.298493>,
      <0.644205, -0.248873, -0.304943>,
      < 0.333358, 0.054161, -0.464475>
    }
    triangle {
      <-0.073776, 0.362670, -0.643428>,
      <-0.119654, 0.319004, -0.636978>,
      < 0.241601, -0.033170, -0.451575>
    }
    triangle {
      <0.241601, -0.033170, -0.451575>,
      <0.287479, 0.010495, -0.458025>,
      < -0.073776, 0.362670, -0.643428>
    }
    triangle {
      <-0.027897, 0.406336, -0.649878>,
      <-0.073776, 0.362670, -0.643428>,
      < 0.287479, 0.010495, -0.458025>
    }
    triangle {
      <0.287479, 0.010495, -0.458025>,
      <0.333358, 0.054161, -0.464475>,
      < -0.027897, 0.406336, -0.649878>
    }
    triangle {
      <0.254417, -0.058489, -0.574796>,
      <0.478160, -0.276608, -0.459967>,
      < 0.552448, -0.336204, -0.292043>
    }
    triangle {
      <0.552448, -0.336204, -0.292043>,
      <0.241601, -0.033170, -0.451575>,
      < 0.254417, -0.058489, -0.574796>
    }
    triangle {
      <-0.005619, 0.195011, -0.708251>,
      <0.254417, -0.058489, -0.574796>,
      < 0.241601, -0.033170, -0.451575>
    }
    triangle {
      <0.241601, -0.033170, -0.451575>,
      <-0.119654, 0.319004, -0.636978>,
      < -0.005619, 0.195011, -0.708251>
    }
    triangle {
      <0.267224, -0.083769, -0.697925>,
      <0.403930, -0.217039, -0.627765>,
      < 0.478160, -0.276608, -0.459967>
    }
    triangle {
      <0.478160, -0.276608, -0.459967>,
      <0.254417, -0.058489, -0.574796>,
      < 0.267224, -0.083769, -0.697925>
    }
    triangle {
      <0.108339, 0.071122, -0.779467>,
      <0.267224, -0.083769, -0.697925>,
      < 0.254417, -0.058489, -0.574796>
    }
    triangle {
      <0.254417, -0.058489, -0.574796>,
      <-0.005619, 0.195011, -0.708251>,
      < 0.108339, 0.071122, -0.779467>
    }
    triangle {
      <0.511210, -0.245152, -0.464612>,
      <0.598327, -0.292538, -0.298493>,
      < 0.552448, -0.336204, -0.292043>
    }
    triangle {
      <0.552448, -0.336204, -0.292043>,
      <0.478160, -0.276608, -0.459967>,
      < 0.511210, -0.245152, -0.464612>
    }
    triangle {
      <0.424151, -0.197791, -0.630605>,
      <0.511210, -0.245152, -0.464612>,
      < 0.478160, -0.276608, -0.459967>
    }
    triangle {
      <0.478160, -0.276608, -0.459967>,
      <0.403930, -0.217039, -0.627765>,
      < 0.424151, -0.197791, -0.630605>
    }
    triangle {
      <0.544186, -0.213760, -0.469237>,
      <0.644205, -0.248873, -0.304943>,
      < 0.598327, -0.292538, -0.298493>
    }
    triangle {
      <0.598327, -0.292538, -0.298493>,
      <0.511210, -0.245152, -0.464612>,
      < 0.544186, -0.213760, -0.469237>
    }
    triangle {
      <0.444299, -0.178609, -0.633425>,
      <0.544186, -0.213760, -0.469237>,
      < 0.511210, -0.245152, -0.464612>
    }
    triangle {
      <0.511210, -0.245152, -0.464612>,
      <0.424151, -0.197791, -0.630605>,
      < 0.444299, -0.178609, -0.633425>
    }
    triangle {
      <0.027430, 0.226467, -0.712896>,
      <-0.005619, 0.195011, -0.708251>,
      < -0.119654, 0.319004, -0.636978>
    }
    triangle {
      <-0.119654, 0.319004, -0.636978>,
      <-0.073776, 0.362670, -0.643428>,
      < 0.027430, 0.226467, -0.712896>
    }
    triangle {
      <0.060407, 0.257859, -0.717521>,
      <0.027430, 0.226467, -0.712896>,
      < -0.073776, 0.362670, -0.643428>
    }
    triangle {
      <-0.073776, 0.362670, -0.643428>,
      <-0.027897, 0.406336, -0.649878>,
      < 0.060407, 0.257859, -0.717521>
    }
    triangle {
      <0.128560, 0.090369, -0.782307>,
      <0.108339, 0.071122, -0.779467>,
      < -0.005619, 0.195011, -0.708251>
    }
    triangle {
      <-0.005619, 0.195011, -0.708251>,
      <0.027430, 0.226467, -0.712896>,
      < 0.128560, 0.090369, -0.782307>
    }
    triangle {
      <0.148708, 0.109552, -0.785128>,
      <0.128560, 0.090369, -0.782307>,
      < 0.027430, 0.226467, -0.712896>
    }
    triangle {
      <0.027430, 0.226467, -0.712896>,
      <0.060407, 0.257859, -0.717521>,
      < 0.148708, 0.109552, -0.785128>
    }
    triangle {
      <0.287445, -0.064522, -0.700765>,
      <0.424151, -0.197791, -0.630605>,
      < 0.403930, -0.217039, -0.627765>
    }
    triangle {
      <0.403930, -0.217039, -0.627765>,
      <0.267224, -0.083769, -0.697925>,
      < 0.287445, -0.064522, -0.700765>
    }
    triangle {
      <0.128560, 0.090369, -0.782307>,
      <0.287445, -0.064522, -0.700765>,
      < 0.267224, -0.083769, -0.697925>
    }
    triangle {
      <0.267224, -0.083769, -0.697925>,
      <0.108339, 0.071122, -0.779467>,
      < 0.128560, 0.090369, -0.782307>
    }
    triangle {
      <0.307593, -0.045340, -0.703585>,
      <0.444299, -0.178609, -0.633425>,
      < 0.424151, -0.197791, -0.630605>
    }
    triangle {
      <0.424151, -0.197791, -0.630605>,
      <0.287445, -0.064522, -0.700765>,
      < 0.307593, -0.045340, -0.703585>
    }
    triangle {
      <0.148708, 0.109552, -0.785128>,
      <0.307593, -0.045340, -0.703585>,
      < 0.287445, -0.064522, -0.700765>
    }
    triangle {
      <0.287445, -0.064522, -0.700765>,
      <0.128560, 0.090369, -0.782307>,
      < 0.148708, 0.109552, -0.785128>
    }
    triangle {
      <0.320443, 0.004359, -0.584066>,
      <0.333358, 0.054161, -0.464475>,
      < 0.644205, -0.248873, -0.304943>
    }
    triangle {
      <0.644205, -0.248873, -0.304943>,
      <0.544186, -0.213760, -0.469237>,
      < 0.320443, 0.004359, -0.584066>
    }
    triangle {
      <0.307593, -0.045340, -0.703585>,
      <0.320443, 0.004359, -0.584066>,
      < 0.544186, -0.213760, -0.469237>
    }
    triangle {
      <0.544186, -0.213760, -0.469237>,
      <0.444299, -0.178609, -0.633425>,
      < 0.307593, -0.045340, -0.703585>
    }
    triangle {
      <0.060407, 0.257859, -0.717521>,
      <-0.027897, 0.406336, -0.649878>,
      < 0.333358, 0.054161, -0.464475>
    }
    triangle {
      <0.333358, 0.054161, -0.464475>,
      <0.320443, 0.004359, -0.584066>,
      < 0.060407, 0.257859, -0.717521>
    }
    triangle {
      <0.148708, 0.109552, -0.785128>,
      <0.060407, 0.257859, -0.717521>,
      < 0.320443, 0.004359, -0.584066>
    }
    triangle {
      <0.320443, 0.004359, -0.584066>,
      <0.307593, -0.045340, -0.703585>,
      < 0.148708, 0.109552, -0.785128>
    }
    triangle {
      <-0.069479, -0.372300, -0.409894>,
      <-0.143844, -0.443067, -0.399419>,
      < 0.360166, -0.934408, -0.140753>
    }
    triangle {
      <0.360166, -0.934408, -0.140753>,
      <0.434530, -0.863641, -0.151227>,
      < -0.069479, -0.372300, -0.409894>
    }
    triangle {
      <0.004958, -0.301468, -0.420389>,
      <-0.069479, -0.372300, -0.409894>,
      < 0.434530, -0.863641, -0.151227>
    }
    triangle {
      <0.434530, -0.863641, -0.151227>,
      <0.508968, -0.792809, -0.161722>,
      < 0.004958, -0.301468, -0.420389>
    }
    triangle {
      <-0.655150, 0.198649, -0.710470>,
      <-0.729514, 0.127881, -0.699996>,
      < -0.143844, -0.443067, -0.399419>
    }
    triangle {
      <-0.143844, -0.443067, -0.399419>,
      <-0.069479, -0.372300, -0.409894>,
      < -0.655150, 0.198649, -0.710470>
    }
    triangle {
      <-0.580712, 0.269481, -0.720965>,
      <-0.655150, 0.198649, -0.710470>,
      < -0.069479, -0.372300, -0.409894>
    }
    triangle {
      <-0.069479, -0.372300, -0.409894>,
      <0.004958, -0.301468, -0.420389>,
      < -0.580712, 0.269481, -0.720965>
    }
    triangle {
      <-0.122960, -0.484066, -0.599163>,
      <0.239774, -0.837682, -0.413002>,
      < 0.360166, -0.934408, -0.140753>
    }
    triangle {
      <0.360166, -0.934408, -0.140753>,
      <-0.143844, -0.443067, -0.399419>,
      < -0.122960, -0.484066, -0.599163>
    }
    triangle {
      <-0.544637, -0.072988, -0.815575>,
      <-0.122960, -0.484066, -0.599163>,
      < -0.143844, -0.443067, -0.399419>
    }
    triangle {
      <-0.143844, -0.443067, -0.399419>,
      <-0.729514, 0.127881, -0.699996>,
      < -0.544637, -0.072988, -0.815575>
    }
    triangle {
      <-0.102226, -0.525025, -0.798829>,
      <0.119366, -0.741047, -0.685104>,
      < 0.239774, -0.837682, -0.413002>
    }
    triangle {
      <0.239774, -0.837682, -0.413002>,
      <-0.122960, -0.484066, -0.599163>,
      < -0.102226, -0.525025, -0.798829>
    }
    triangle {
      <-0.359776, -0.273949, -0.931008>,
      <-0.102226, -0.525025, -0.798829>,
      < -0.122960, -0.484066, -0.599163>
    }
    triangle {
      <-0.122960, -0.484066, -0.599163>,
      <-0.544637, -0.072988, -0.815575>,
      < -0.359776, -0.273949, -0.931008>
    }
    triangle {
      <0.293256, -0.786745, -0.420456>,
      <0.434530, -0.863641, -0.151227>,
      < 0.360166, -0.934408, -0.140753>
    }
    triangle {
      <0.360166, -0.934408, -0.140753>,
      <0.239774, -0.837682, -0.413002>,
      < 0.293256, -0.786745, -0.420456>
    }
    triangle {
      <0.152058, -0.709953, -0.689741>,
      <0.293256, -0.786745, -0.420456>,
      < 0.239774, -0.837682, -0.413002>
    }
    triangle {
      <0.239774, -0.837682, -0.413002>,
      <0.119366, -0.741047, -0.685104>,
      < 0.152058, -0.709953, -0.689741>
    }
    triangle {
      <0.346820, -0.735782, -0.428021>,
      <0.508968, -0.792809, -0.161722>,
      < 0.434530, -0.863641, -0.151227>
    }
    triangle {
      <0.434530, -0.863641, -0.151227>,
      <0.293256, -0.786745, -0.420456>,
      < 0.346820, -0.735782, -0.428021>
    }
    triangle {
      <0.184813, -0.678756, -0.694306>,
      <0.346820, -0.735782, -0.428021>,
      < 0.293256, -0.786745, -0.420456>
    }
    triangle {
      <0.293256, -0.786745, -0.420456>,
      <0.152058, -0.709953, -0.689741>,
      < 0.184813, -0.678756, -0.694306>
    }
    triangle {
      <-0.491155, -0.022051, -0.823029>,
      <-0.544637, -0.072988, -0.815575>,
      < -0.729514, 0.127881, -0.699996>
    }
    triangle {
      <-0.729514, 0.127881, -0.699996>,
      <-0.655150, 0.198649, -0.710470>,
      < -0.491155, -0.022051, -0.823029>
    }
    triangle {
      <-0.437591, 0.028912, -0.830595>,
      <-0.491155, -0.022051, -0.823029>,
      < -0.655150, 0.198649, -0.710470>
    }
    triangle {
      <-0.655150, 0.198649, -0.710470>,
      <-0.580712, 0.269481, -0.720965>,
      < -0.437591, 0.028912, -0.830595>
    }
    triangle {
      <-0.327084, -0.242855, -0.935645>,
      <-0.359776, -0.273949, -0.931008>,
      < -0.544637, -0.072988, -0.815575>
    }
    triangle {
      <-0.544637, -0.072988, -0.815575>,
      <-0.491155, -0.022051, -0.823029>,
      < -0.327084, -0.242855, -0.935645>
    }
    triangle {
      <-0.294329, -0.211658, -0.940210>,
      <-0.327084, -0.242855, -0.935645>,
      < -0.491155, -0.022051, -0.823029>
    }
    triangle {
      <-0.491155, -0.022051, -0.823029>,
      <-0.437591, 0.028912, -0.830595>,
      < -0.294329, -0.211658, -0.940210>
    }
    triangle {
      <-0.069535, -0.493931, -0.803466>,
      <0.152058, -0.709953, -0.689741>,
      < 0.119366, -0.741047, -0.685104>
    }
    triangle {
      <0.119366, -0.741047, -0.685104>,
      <-0.102226, -0.525025, -0.798829>,
      < -0.069535, -0.493931, -0.803466>
    }
    triangle {
      <-0.327084, -0.242855, -0.935645>,
      <-0.069535, -0.493931, -0.803466>,
      < -0.102226, -0.525025, -0.798829>
    }
    triangle {
      <-0.102226, -0.525025, -0.798829>,
      <-0.359776, -0.273949, -0.931008>,
      < -0.327084, -0.242855, -0.935645>
    }
    triangle {
      <-0.036779, -0.462734, -0.808031>,
      <0.184813, -0.678756, -0.694306>,
      < 0.152058, -0.709953, -0.689741>
    }
    triangle {
      <0.152058, -0.709953, -0.689741>,
      <-0.069535, -0.493931, -0.803466>,
      < -0.036779, -0.462734, -0.808031>
    }
    triangle {
      <-0.294329, -0.211658, -0.940210>,
      <-0.036779, -0.462734, -0.808031>,
      < -0.069535, -0.493931, -0.803466>
    }
    triangle {
      <-0.069535, -0.493931, -0.803466>,
      <-0.327084, -0.242855, -0.935645>,
      < -0.294329, -0.211658, -0.940210>
    }
    triangle {
      <-0.015913, -0.382166, -0.614183>,
      <0.004958, -0.301468, -0.420389>,
      < 0.508968, -0.792809, -0.161722>
    }
    triangle {
      <0.508968, -0.792809, -0.161722>,
      <0.346820, -0.735782, -0.428021>,
      < -0.015913, -0.382166, -0.614183>
    }
    triangle {
      <-0.036779, -0.462734, -0.808031>,
      <-0.015913, -0.382166, -0.614183>,
      < 0.346820, -0.735782, -0.428021>
    }
    triangle {
      <0.346820, -0.735782, -0.428021>,
      <0.184813, -0.678756, -0.694306>,
      < -0.036779, -0.462734, -0.808031>
    }
    triangle {
      <-0.437591, 0.028912, -0.830595>,
      <-0.580712, 0.269481, -0.720965>,
      < 0.004958, -0.301468, -0.420389>
    }
    triangle {
      <0.004958, -0.301468, -0.420389>,
      <-0.015913, -0.382166, -0.614183>,
      < -0.437591, 0.028912, -0.830595>
    }
    triangle {
      <-0.294329, -0.211658, -0.940210>,
      <-0.437591, 0.028912, -0.830595>,
      < -0.015913, -0.382166, -0.614183>
    }
    triangle {
      <-0.015913, -0.382166, -0.614183>,
      <-0.036779, -0.462734, -0.808031>,
      < -0.294329, -0.211658, -0.940210>
    }
    triangle {
      <-0.486771, -0.753198, -0.320325>,
      <-0.561135, -0.823965, -0.309851>,
      < -0.057125, -1.315306, -0.051184>
    }
    triangle {
      <-0.057125, -1.315306, -0.051184>,
      <0.017239, -1.244538, -0.061659>,
      < -0.486771, -0.753198, -0.320325>
    }
    triangle {
      <-0.412407, -0.682430, -0.330800>,
      <-0.486771, -0.753198, -0.320325>,
      < 0.017239, -1.244538, -0.061659>
    }
    triangle {
      <0.017239, -1.244538, -0.061659>,
      <0.091603, -1.173771, -0.072133>,
      < -0.412407, -0.682430, -0.330800>
    }
    triangle {
      <-1.072441, -0.182249, -0.620902>,
      <-1.146805, -0.253016, -0.610427>,
      < -0.561135, -0.823965, -0.309851>
    }
    triangle {
      <-0.561135, -0.823965, -0.309851>,
      <-0.486771, -0.753198, -0.320325>,
      < -1.072441, -0.182249, -0.620902>
    }
    triangle {
      <-0.998077, -0.111482, -0.631376>,
      <-1.072441, -0.182249, -0.620902>,
      < -0.486771, -0.753198, -0.320325>
    }
    triangle {
      <-0.486771, -0.753198, -0.320325>,
      <-0.412407, -0.682430, -0.330800>,
      < -0.998077, -0.111482, -0.631376>
    }
    triangle {
      <-0.540325, -0.865028, -0.509574>,
      <-0.177591, -1.218644, -0.323413>,
      < -0.057125, -1.315306, -0.051184>
    }
    triangle {
      <-0.057125, -1.315306, -0.051184>,
      <-0.561135, -0.823965, -0.309851>,
      < -0.540325, -0.865028, -0.509574>
    }
    triangle {
      <-0.962002, -0.453951, -0.725986>,
      <-0.540325, -0.865028, -0.509574>,
      < -0.561135, -0.823965, -0.309851>
    }
    triangle {
      <-0.561135, -0.823965, -0.309851>,
      <-1.146805, -0.253016, -0.610427>,
      < -0.962002, -0.453951, -0.725986>
    }
    triangle {
      <-0.519518, -0.905922, -0.709260>,
      <-0.297926, -1.121945, -0.595535>,
      < -0.177591, -1.218644, -0.323413>
    }
    triangle {
      <-0.177591, -1.218644, -0.323413>,
      <-0.540325, -0.865028, -0.509574>,
      < -0.519518, -0.905922, -0.709260>
    }
    triangle {
      <-0.777067, -0.654847, -0.841439>,
      <-0.519518, -0.905922, -0.709260>,
      < -0.540325, -0.865028, -0.509574>
    }
    triangle {
      <-0.540325, -0.865028, -0.509574>,
      <-0.962002, -0.453951, -0.725986>,
      < -0.777067, -0.654847, -0.841439>
    }
    triangle {
      <-0.124036, -1.167643, -0.330887>,
      <0.017239, -1.244538, -0.061659>,
      < -0.057125, -1.315306, -0.051184>
    }
    triangle {
      <-0.057125, -1.315306, -0.051184>,
      <-0.177591, -1.218644, -0.323413>,
      < -0.124036, -1.167643, -0.330887>
    }
    triangle {
      <-0.265234, -1.090851, -0.600172>,
      <-0.124036, -1.167643, -0.330887>,
      < -0.177591, -1.218644, -0.323413>
    }
    triangle {
      <-0.177591, -1.218644, -0.323413>,
      <-0.297926, -1.121945, -0.595535>,
      < -0.265234, -1.090851, -0.600172>
    }
    triangle {
      <-0.070471, -1.116680, -0.338452>,
      <0.091603, -1.173771, -0.072133>,
      < 0.017239, -1.244538, -0.061659>
    }
    triangle {
      <0.017239, -1.244538, -0.061659>,
      <-0.124036, -1.167643, -0.330887>,
      < -0.070471, -1.116680, -0.338452>
    }
    triangle {
      <-0.232552, -1.059719, -0.604717>,
      <-0.070471, -1.116680, -0.338452>,
      < -0.124036, -1.167643, -0.330887>
    }
    triangle {
      <-0.124036, -1.167643, -0.330887>,
      <-0.265234, -1.090851, -0.600172>,
      < -0.232552, -1.059719, -0.604717>
    }
    triangle {
      <-0.908447, -0.402949, -0.733460>,
      <-0.962002, -0.453951, -0.725986>,
      < -1.146805, -0.253016, -0.610427>
    }
    triangle {
      <-1.146805, -0.253016, -0.610427>,
      <-1.072441, -0.182249, -0.620902>,
      < -0.908447, -0.402949, -0.733460>
    }
    triangle {
      <-0.854882, -0.351986, -0.741026>,
      <-0.908447, -0.402949, -0.733460>,
      < -1.072441, -0.182249, -0.620902>
    }
    triangle {
      <-1.072441, -0.182249, -0.620902>,
      <-0.998077, -0.111482, -0.631376>,
      < -0.854882, -0.351986, -0.741026>
    }
    triangle {
      <-0.744376, -0.623753, -0.846076>,
      <-0.777067, -0.654847, -0.841439>,
      < -0.962002, -0.453951, -0.725986>
    }
    triangle {
      <-0.962002, -0.453951, -0.725986>,
      <-0.908447, -0.402949, -0.733460>,
      < -0.744376, -0.623753, -0.846076>
    }
    triangle {
      <-0.711693, -0.592621, -0.850621>,
      <-0.744376, -0.623753, -0.846076>,
      < -0.908447, -0.402949, -0.733460>
    }
    triangle {
      <-0.908447, -0.402949, -0.733460>,
      <-0.854882, -0.351986, -0.741026>,
      < -0.711693, -0.592621, -0.850621>
    }
    triangle {
      <-0.486826, -0.874829, -0.713897>,
      <-0.265234, -1.090851, -0.600172>,
      < -0.297926, -1.121945, -0.595535>
    }
    triangle {
      <-0.297926, -1.121945, -0.595535>,
      <-0.519518, -0.905922, -0.709260>,
      < -0.486826, -0.874829, -0.713897>
    }
    triangle {
      <-0.744376, -0.623753, -0.846076>,
      <-0.486826, -0.874829, -0.713897>,
      < -0.519518, -0.905922, -0.709260>
    }
    triangle {
      <-0.519518, -0.905922, -0.709260>,
      <-0.777067, -0.654847, -0.841439>,
      < -0.744376, -0.623753, -0.846076>
    }
    triangle {
      <-0.454144, -0.843696, -0.718442>,
      <-0.232552, -1.059719, -0.604717>,
      < -0.265234, -1.090851, -0.600172>
    }
    triangle {
      <-0.265234, -1.090851, -0.600172>,
      <-0.486826, -0.874829, -0.713897>,
      < -0.454144, -0.843696, -0.718442>
    }
    triangle {
      <-0.711693, -0.592621, -0.850621>,
      <-0.454144, -0.843696, -0.718442>,
      < -0.486826, -0.874829, -0.713897>
    }
    triangle {
      <-0.486826, -0.874829, -0.713897>,
      <-0.744376, -0.623753, -0.846076>,
      < -0.711693, -0.592621, -0.850621>
    }
    triangle {
      <-0.433205, -0.763064, -0.524614>,
      <-0.412407, -0.682430, -0.330800>,
      < 0.091603, -1.173771, -0.072133>
    }
    triangle {
      <0.091603, -1.173771, -0.072133>,
      <-0.070471, -1.116680, -0.338452>,
      < -0.433205, -0.763064, -0.524614>
    }
    triangle {
      <-0.454144, -0.843696, -0.718442>,
      <-0.433205, -0.763064, -0.524614>,
      < -0.070471, -1.116680, -0.338452>
    }
    triangle {
      <-0.070471, -1.116680, -0.338452>,
      <-0.232552, -1.059719, -0.604717>,
      < -0.454144, -0.843696, -0.718442>
    }
    triangle {
      <-0.854882, -0.351986, -0.741026>,
      <-0.998077, -0.111482, -0.631376>,
      < -0.412407, -0.682430, -0.330800>
    }
    triangle {
      <-0.412407, -0.682430, -0.330800>,
      <-0.433205, -0.763064, -0.524614>,
      < -0.854882, -0.351986, -0.741026>
    }
    triangle {
      <-0.711693, -0.592621, -0.850621>,
      <-0.854882, -0.351986, -0.741026>,
      < -0.433205, -0.763064, -0.524614>
    }
    triangle {
      <-0.433205, -0.763064, -0.524614>,
      <-0.454144, -0.843696, -0.718442>,
      < -0.711693, -0.592621, -0.850621>
    }
    triangle {
      <-0.950303, -1.142962, -0.157500>,
      <-1.024741, -1.213794, -0.147005>,
      < -0.520731, -1.705135, 0.111661>
    }
    triangle {
      <-0.520731, -1.705135, 0.111661>,
      <-0.446293, -1.634303, 0.101167>,
      < -0.950303, -1.142962, -0.157500>
    }
    triangle {
      <-0.875939, -1.072195, -0.167974>,
      <-0.950303, -1.142962, -0.157500>,
      < -0.446293, -1.634303, 0.101167>
    }
    triangle {
      <-0.446293, -1.634303, 0.101167>,
      <-0.371929, -1.563536, 0.090692>,
      < -0.875939, -1.072195, -0.167974>
    }
    triangle {
      <-1.535973, -0.572014, -0.458076>,
      <-1.610411, -0.642846, -0.447581>,
      < -1.024741, -1.213794, -0.147005>
    }
    triangle {
      <-1.024741, -1.213794, -0.147005>,
      <-0.950303, -1.142962, -0.157500>,
      < -1.535973, -0.572014, -0.458076>
    }
    triangle {
      <-1.461609, -0.501246, -0.468551>,
      <-1.535973, -0.572014, -0.458076>,
      < -0.950303, -1.142962, -0.157500>
    }
    triangle {
      <-0.950303, -1.142962, -0.157500>,
      <-0.875939, -1.072195, -0.167974>,
      < -1.461609, -0.501246, -0.468551>
    }
    triangle {
      <-1.003857, -1.254793, -0.346749>,
      <-0.641123, -1.608409, -0.160587>,
      < -0.520731, -1.705135, 0.111661>
    }
    triangle {
      <-0.520731, -1.705135, 0.111661>,
      <-1.024741, -1.213794, -0.147005>,
      < -1.003857, -1.254793, -0.346749>
    }
    triangle {
      <-1.425534, -0.843715, -0.563161>,
      <-1.003857, -1.254793, -0.346749>,
      < -1.024741, -1.213794, -0.147005>
    }
    triangle {
      <-1.024741, -1.213794, -0.147005>,
      <-1.610411, -0.642846, -0.447581>,
      < -1.425534, -0.843715, -0.563161>
    }
    triangle {
      <-0.983123, -1.295752, -0.546415>,
      <-0.761531, -1.511774, -0.432690>,
      < -0.641123, -1.608409, -0.160587>
    }
    triangle {
      <-0.641123, -1.608409, -0.160587>,
      <-1.003857, -1.254793, -0.346749>,
      < -0.983123, -1.295752, -0.546415>
    }
    triangle {
      <-1.240673, -1.044676, -0.678594>,
      <-0.983123, -1.295752, -0.546415>,
      < -1.003857, -1.254793, -0.346749>
    }
    triangle {
      <-1.003857, -1.254793, -0.346749>,
      <-1.425534, -0.843715, -0.563161>,
      < -1.240673, -1.044676, -0.678594>
    }
    triangle {
      <-0.587568, -1.557407, -0.168061>,
      <-0.446293, -1.634303, 0.101167>,
      < -0.520731, -1.705135, 0.111661>
    }
    triangle {
      <-0.520731, -1.705135, 0.111661>,
      <-0.641123, -1.608409, -0.160587>,
      < -0.587568, -1.557407, -0.168061>
    }
    triangle {
      <-0.728766, -1.480615, -0.437347>,
      <-0.587568, -1.557407, -0.168061>,
      < -0.641123, -1.608409, -0.160587>
    }
    triangle {
      <-0.641123, -1.608409, -0.160587>,
      <-0.761531, -1.511774, -0.432690>,
      < -0.728766, -1.480615, -0.437347>
    }
    triangle {
      <-0.534077, -1.506509, -0.175607>,
      <-0.371929, -1.563536, 0.090692>,
      < -0.446293, -1.634303, 0.101167>
    }
    triangle {
      <-0.446293, -1.634303, 0.101167>,
      <-0.587568, -1.557407, -0.168061>,
      < -0.534077, -1.506509, -0.175607>
    }
    triangle {
      <-0.696083, -1.449483, -0.441892>,
      <-0.534077, -1.506509, -0.175607>,
      < -0.587568, -1.557407, -0.168061>
    }
    triangle {
      <-0.587568, -1.557407, -0.168061>,
      <-0.728766, -1.480615, -0.437347>,
      < -0.696083, -1.449483, -0.441892>
    }
    triangle {
      <-1.371979, -0.792713, -0.570635>,
      <-1.425534, -0.843715, -0.563161>,
      < -1.610411, -0.642846, -0.447581>
    }
    triangle {
      <-1.610411, -0.642846, -0.447581>,
      <-1.535973, -0.572014, -0.458076>,
      < -1.371979, -0.792713, -0.570635>
    }
    triangle {
      <-1.318488, -0.741815, -0.578180>,
      <-1.371979, -0.792713, -0.570635>,
      < -1.535973, -0.572014, -0.458076>
    }
    triangle {
      <-1.535973, -0.572014, -0.458076>,
      <-1.461609, -0.501246, -0.468551>,
      < -1.318488, -0.741815, -0.578180>
    }
    triangle {
      <-1.207908, -1.013517, -0.683251>,
      <-1.240673, -1.044676, -0.678594>,
      < -1.425534, -0.843715, -0.563161>
    }
    triangle {
      <-1.425534, -0.843715, -0.563161>,
      <-1.371979, -0.792713, -0.570635>,
      < -1.207908, -1.013517, -0.683251>
    }
    triangle {
      <-1.175225, -0.982385, -0.687796>,
      <-1.207908, -1.013517, -0.683251>,
      < -1.371979, -0.792713, -0.570635>
    }
    triangle {
      <-1.371979, -0.792713, -0.570635>,
      <-1.318488, -0.741815, -0.578180>,
      < -1.175225, -0.982385, -0.687796>
    }
    triangle {
      <-0.950358, -1.264593, -0.551072>,
      <-0.728766, -1.480615, -0.437347>,
      < -0.761531, -1.511774, -0.432690>
    }
    triangle {
      <-0.761531, -1.511774, -0.432690>,
      <-0.983123, -1.295752, -0.546415>,
      < -0.950358, -1.264593, -0.551072>
    }
    triangle {
      <-1.207908, -1.013517, -0.683251>,
      <-0.950358, -1.264593, -0.551072>,
      < -0.983123, -1.295752, -0.546415>
    }
    triangle {
      <-0.983123, -1.295752, -0.546415>,
      <-1.240673, -1.044676, -0.678594>,
      < -1.207908, -1.013517, -0.683251>
    }
    triangle {
      <-0.917676, -1.233461, -0.555617>,
      <-0.696083, -1.449483, -0.441892>,
      < -0.728766, -1.480615, -0.437347>
    }
    triangle {
      <-0.728766, -1.480615, -0.437347>,
      <-0.950358, -1.264593, -0.551072>,
      < -0.917676, -1.233461, -0.555617>
    }
    triangle {
      <-1.175225, -0.982385, -0.687796>,
      <-0.917676, -1.233461, -0.555617>,
      < -0.950358, -1.264593, -0.551072>
    }
    triangle {
      <-0.950358, -1.264593, -0.551072>,
      <-1.207908, -1.013517, -0.683251>,
      < -1.175225, -0.982385, -0.687796>
    }
    triangle {
      <-0.896810, -1.152893, -0.361768>,
      <-0.875939, -1.072195, -0.167974>,
      < -0.371929, -1.563536, 0.090692>
    }
    triangle {
      <-0.371929, -1.563536, 0.090692>,
      <-0.534077, -1.506509, -0.175607>,
      < -0.896810, -1.152893, -0.361768>
    }
    triangle {
      <-0.917676, -1.233461, -0.555617>,
      <-0.896810, -1.152893, -0.361768>,
      < -0.534077, -1.506509, -0.175607>
    }
    triangle {
      <-0.534077, -1.506509, -0.175607>,
      <-0.696083, -1.449483, -0.441892>,
      < -0.917676, -1.233461, -0.555617>
    }
    triangle {
      <-1.318488, -0.741815, -0.578180>,
      <-1.461609, -0.501246, -0.468551>,
      < -0.875939, -1.072195, -0.167974>
    }
    triangle {
      <-0.875939, -1.072195, -0.167974>,
      <-0.896810, -1.152893, -0.361768>,
      < -1.318488, -0.741815, -0.578180>
    }
    triangle {
      <-1.175225, -0.982385, -0.687796>,
      <-1.318488, -0.741815, -0.578180>,
      < -0.896810, -1.152893, -0.361768>
    }
    triangle {
      <-0.896810, -1.152893, -0.361768>,
      <-0.917676, -1.233461, -0.555617>,
      < -1.175225, -0.982385, -0.687796>
    }
    texture{_X1_X2_G0}
  }
}
