/////////////////////////////////////////////////////////////////
// "Water Whirl" (reverse ior test)
////////////////////////////////////
// made by Miroslav Hundak in 1999.

#declare INDEX = 1.33;
#declare NGH = 6; // !!!
#declare ROUND_SKY = 1;
#declare W_RES = 150;
#declare W_SIZE = 20;
#declare W_DEPTH = 50;
#declare W_ROT = 215;
#declare B_RES = 400;

#declare VIEW = 1;
#declare POOL = 1;
#declare BALL = 1;
#declare WATER = 1;
#declare BUBBLES = 1;
#declare A_LIGHT = 1;
#declare STURM_ON = 1;
#declare TEXTURE_PREVIEW = 0;

#include "texture.inc"
#include "golds.inc"

global_settings { 
	//ambient_light rgb <0.15, 0.15, 0.5> 
	max_trace_level 100
	radiosity {
		distance_maximum 50000
	}
}

#if(VIEW = 1)
camera {
	location <0, -3.5, -5>
	look_at <0, -1.5, 0>
	angle 90
}
#end
#if(VIEW = 2)
camera {
	location <0, 5, -5>
	look_at <0, -1.5, 0>
	angle 90
}
#end


////////////////////////////////
// OBJECTS
//////////////////////////////

#declare oEdge = intersection {
	sphere { <0, 0, -8>, 10 }
	sphere { <0, 0, 8>, 10 }
}

#declare oPool = difference {
	cylinder { <0, -1, 0>, <0, 0, 0>, 1
		scale 100
	}
	union {
		cylinder { <0, -1, 0>, <0, 1, 0>, 1
			scale <8, 200, 8>
		}
		torus { 8, 0.15
			scale <1, 2, 1>
			translate <0, -1, 0>
		}
		torus { 8, 0.1*0.7
			scale <1, 1, 1>
			translate <0, -3, 0>
		}
		torus { 8, 0.1*0.7
			scale <1, 1, 1>
			translate <0, -4.5, 0>
		}
		torus { 8, 0.1*0.7
			scale <1, 1, 1>
			translate <0, -6, 0>
		}
	}
	texture { txFloor_1 scale 5 }
}

#declare oWhirl = blob {
	threshold 0.15
	#declare i = 0;
	#declare r = W_SIZE;
	#declare fi = 0;
	#declare dr = 0;
	#while(i < W_RES)
		sphere { <0, 0, 0>, r, 1 
			scale <1, 1/r, 1>
			translate <dr, -i*(W_DEPTH/W_RES), 0>
			rotate y*fi
		}
		#declare dr = r/8;
		#declare i = i+1;
		#declare fi = fi+W_ROT;
		#declare r = pow(r, 0.95);
	#end
	sturm STURM_ON
}

#macro mBubbles(dw)
blob {
	threshold 0.1
	#declare i = 0;
	#declare dx = seed(333+dw);
	#declare dy = seed(666+dw);
	#declare dz = seed(999+dw);
	#declare dr1 = rand(dy);
	#declare dr2 = rand(dz);
	#declare r = W_SIZE*8;
	#while(i < B_RES)
		sphere { <0, 0, 0>, 0.5+0.75*rand(dx), 1
			translate y*(-i/2)
			translate <rand(dx), rand(dy), rand(dz)>*4
			translate x*(10+dr2*15+r)
			rotate y*(i*(360/100)+(dr1*360))
		}
		#declare r = pow(r, 0.991);
		#declare i = i+1;
	#end
	sturm STURM_ON
}
#end

#declare oMinus = union { 
	object { oWhirl 
		texture {
			#if(TEXTURE_PREVIEW)
			pigment { color rgbf <1, 1, 1, 0> }
			#else
			pigment { color rgbf <1, 1, 1, 1> }
			#end
			normal {
				ripples 0.5
				scale 1
				turbulence 0.5
			}
		}
	}
	#if(BUBBLES)
	union {
		object { mBubbles(0) scale 1/8 /*translate <-2, 0, -1>*/ }
		object { mBubbles(1) scale 1/8 /*translate <-1.5, 0, -0.5>*/ }
		object { mBubbles(2) scale 1/8 /*translate <2, 0, 0>*/ }
		//object { mBubbles(3) scale 1/8 /*translate <1, 0, -1.5>*/ }
		object { mBubbles(4) scale 1/8 /*translate <-0.25, 0, -2>*/ }
		texture {
			#if(TEXTURE_PREVIEW)
			pigment { color rgbf <1, 1, 1, 0> }
			#else
			pigment { color rgbf <1, 1, 1, 1> }
			#end
		}
	}
	#end
	scale 0.3
}

#declare oWater = difference {
	box { <-1, -1, -1>, <1, 0, 1>
		scale 100
		translate y*(-0.25)
		texture {
			#if(TEXTURE_PREVIEW)
			pigment { color rgbf <1, 1, 1, 0> }
			#else
			pigment { color rgbf <1, 1, 1, 1> }
			#end
			normal {
				ripples 0.5
				scale 0.6
				turbulence 0.5
			}
		}
	}
	object { oMinus	}
	texture {
		pigment { color rgbf <1, 1, 1, 1> }
		normal {
			bumps 0.5
			scale 0.3
		}
		finish {
			ambient 0
			diffuse 0
			phong 1
			phong_size 60
		}
	}
	interior { ior INDEX }
	hollow
}

#declare oLight = object {
	sphere { <0, 0, 0>, 0.2 }
	texture { 
		pigment { color rgb <0.9, 0.9, 0.9> }
		finish {
			ambient 0.75
		}
	}
	scale <1, 3, 1>
	no_shadow
	//hollow
}

#declare oCross = union {
	sphere { <0, 0, 0>, 0.5
		scale <0.1, 1, 0.1>
	}
	sphere { <0, 0, 0>, 0.5
		scale <0.5, 0.1, 0.1>
	}
	texture { T_Silver_5E }
} 

////////////////////////////////
// SCENE
//////////////////////////////

#if(TEXTURE_PREVIEW)
light_source { <0, -3.5, -5> color rgb 1 }
#else 
#declare i = 0;
#while(i < NGH*2)
	light_source { <-7.9, -1, 0> color rgb 0.9 
		//looks_like { oLight translate x*(-0.15) }
		#if(A_LIGHT)
			area_light x*0.4, y*0.6, 3, 3
			adaptive 1
			//jitter
		#end
		fade_distance 4
		fade_power 7
		rotate y*(i*30)
	}
	object { oLight
		translate <-8, -1, 0>
		rotate y*(i*30+30)
	}
	#declare i = i+1;
#end

light_source { <0, -15, 0> color rgb <1, 0 ,0>
	fade_distance 10
	fade_power 5
}
#end

#if(ROUND_SKY)
	sphere { <0, 0, 0>, 1
		scale <20000, 4000, 20000>
		texture { txSky_1 }
	}
#else
	plane { y, 4000 texture { txSky_1 } }
#end

#if(WATER)
object { oWater }
#end

#if(POOL)
object { oPool }
#declare i = 0;
#while(i < NGH*2)
	union {
		cone { <0, -2.3, 0>, 0.1, <0, -1.8, 0>, 0 }
		cone { <0, -2.3, -0.8>, 0, <0, -2.3, 0>, 0.1 }
		cone { <0, -2.3, 0.8>, 0, <0, -2.3, 0>, 0.1 }
		cone { <0, -2.3, 0>, 0.1, <0, -3.1, 0>, 0 }
		texture { T_Gold_5A }
		translate <-8, 0, 0>
		rotate y*(i*30)
	}
	#declare i = i+1;
#end
#declare i = 0;
#while (i < NGH*2)
	#declare j = 0;
	#while(j < 4)
		object { oCross
			translate <0, (j*(-1.5))-2.3, 8>
			rotate y*(i*30+15)
		}
		#declare j = j+1;
	#end
	#declare i = i+1;
#end
intersection {
	box { <-1, -1, -1>, <1, 0, 1>
		scale 100
	}
	union {
	#declare i = 0;
	#while(i < NGH*2)
		object { oEdge
			scale <1.1, 3.1, 1.5> 
			translate <-13, -15, 0>
			texture { txFloor_2 scale 5 }
			rotate y*i*30 
		}
		#declare i = i+1;
	#end
	}
}
cylinder { <0, -100, 0>, <0, -15.9, 0>, 100
	texture { Rust
		scale 5
		finish { ambient 1 }
	}
}
#end

#if(BALL)
sphere { <0, 0, 0>, 1
	scale 1.2
	texture { Candy_Cane finish { ambient 0.5 } scale 0.5 }
	translate <5, 0.4, 2>
	hollow
}
#end
