// Textures by Miroslav Hundak

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "skies.inc"
#include "stars.inc"
#include "metals.inc"

#ifndef(TEXTURE_PREVIEW)
	#declare TEXTURE_PREVIEW = 0;
#end

#if(TEXTURE_PREVIEW)
//****************************************************************************
// preview textures

#declare txCrystal_1 = texture {
	pigment { color <1, 1, 1> }
	finish { 
		specular 1
		roughness 0.005
	}
}
#declare txCrystal_2 = texture { txCrystal_1 }
#declare txSteel_1 = texture { txCrystal_1 }
#declare txSteel_2 = texture { txCrystal_1 }
#declare txFloor_1 = texture { txCrystal_1 }
#declare txFloor_2 = texture { txCrystal_1 }
#declare txBlank = texture { txCrystal_1 }
#declare txSky_1 = texture { txCrystal_1 }

#else
//****************************************************************************
// "real" textures

#declare txBlank = texture {
	pigment { color rgb 0.75 }
	finish {
		phong 1
		phong_size 60
	}
}

#declare txCrystal_1 = texture {
	pigment { color rgbt <1, 1, 1, 1> }
	finish {
		//phong 1
		//phong_size 40
		specular 1
		roughness 0.005
		//metallic
		reflection 0.2
	}
}

#declare txCrystal_2 = texture {
	pigment { color rgbf <1, .5, .5, 1> }
	finish {
		//phong 1
		//phong_size 40
		specular 1
		roughness 0.005
		//metallic
		reflection 0.2
	}
}

#declare txSteel_1 = texture {
	pigment { color rgb <0, 0, 0> }
	normal {
		wrinkles 0.5
		//turbulence 1
		scale 0.0001
	}
	finish {
		specular 1
		roughness 0.005
		metallic
		reflection 1.0
	}
}

#declare txSteel_2 = texture {
	pigment { color rgb <0.5, 0.5, 0.5> }
	finish {
  		brilliance 10
  		diffuse 1
  		specular 0.90
  		roughness 1/20
		ambient 0.99
		metallic
		reflection 0.01
	}
}

#declare txFloor_1 = texture {
	//checker
	//texture { 
		T_Stone14 
		finish { ambient 0.4 }
	//}
	//texture { T_Stone24 finish { ambient 0.4 } }
}

#declare txSky_1 =
texture {
	pigment { onion
		color_map {
			[0 color rgb <0.2, 0.9, 0.6>]
			[0.3 color rgb <0.1, 0.45, 0.5>]
			[0.7 color rgb <1, 0.7, 0.3>]
		}
		scale 20000
	}
	finish { ambient 1 }
}
texture {
	T_Cloud1
	finish { ambient 1 }
	scale 300 translate z*(-6000)
}

#declare txFloor_2 =
texture {
	checker
	texture { txFloor_1 scale <1/1000, 15, 1/1000> }
	texture { T_Gold_5A }
	scale <1000, 1/15, 1000>
	translate x*500
	rotate z*30
}

#end

		