// Persistence of Vision Ray Tracer Include File
// File: nacl.inc
// Vers: 3.1
// Desc: A program to create a crystal of NaCl (salt) with the size of a box{ -1, 1 }.
// Date: 99-02-09
// Auth: Victor Widell ( vicce.was@home.se )


 
#macro NaCl (how_many, NaCl_scale, NaCl_translate) 

  #local diameter1 = .02;        // Diameter of the Sticks.
  #local diameter2 = .2;         // Diameter of the Clorine.
  #local diameter3 = .1;         // Diameter of the Natrium.
  
  #local even = 1;
  #local H = how_many;
  #while ( H > 0 )
    #local H = H-1;
    #if ( even )
      #local even = 0;
    #else
      #local even = 1;
    #end
  #end
  
  union{                         // The whole crystal.
  
    #local X = 0;
    #local Z = 0;
    
    #local sticks = union{
      #while ( X<how_many )
        #while ( Z<how_many )
          cylinder{ <X, 0, Z>, <X, how_many-1, Z>, diameter1 }
          #local Z = Z+1;
        #end
        #local Z = 0;
        #local X = X+1;
      #end
      translate (how_many-1)/-2
    }
    
    union{
      object{ sticks }
      object{ sticks rotate 90*x }
      object{ sticks rotate 90*z }
      pigment{ rgb <.75, .75, 1> }
      finish{ phong 1 phong_size 120 reflection .4 metallic }
    }
    
    #local X = 0;
    #local Y = 0;
    #local Z = 0;
    #local even2 = 1;
    #local diameter = diameter2;
    #local RGB = green 1;
    
    union {
      #while ( X<how_many )
        #while ( Y<how_many )
          #while ( Z<how_many )
            sphere { <X, Y, Z>, diameter pigment{ RGB } }
            #if ( diameter=diameter3 )
              #local diameter = diameter2;
              #local RGB = green 1;
            #else
              #local diameter = diameter3;
              #local RGB = rgb 1;
            #end
            #local Z = Z+1;
          #end
          #if ( even )
            #if ( even2 )
              #local diameter = diameter3;
              #local RGB = rgb 1;
              #local even2 = 0;
            #else
              #local diameter = diameter2;
              #local RGB = green 1;
              #local even2 = 1;
            #end       
          #end
          #local Z = 0;
          #local Y = Y+1;
         #end
          #if ( even )
            #if ( even2 )
              #local diameter = diameter3;
              #local RGB = rgb 1;
              #local even2 = 0;
            #else
              #local diameter = diameter2;
              #local RGB = green 1;
              #local even2 = 1;
            #end       
          #end
        #local Y = 0;
        #local X = X+1;
      #end
      translate (how_many-1)/-2
    }
    
    scale 1/(((how_many-1)/2)+diameter2)
    scale NaCl_scale  
    translate NaCl_translate
  
  }
  
#end

