#include "nacl.inc"

NaCl (5, 1.5, z*1.5)

camera {  //  Camera Camera01
  location  <-4.000, -8.000, 5.850>
  direction <0.0,     0.0,  1.3563>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <0.269, 0.273, 1.785>  // Focal blur settings
//  focal_point  <0.269, 0.273, 1.785> // Always Lookat
//  aperture     1.0
//  blur_samples 19
//  confidence   0.9
//  variance     0.01

}

// *******  L I G H T S *******
light_source {   // Light1
  <-18.600, -13.050, 17.750>
  color rgb 1.3
}


// ********  TEXTURES  *******
//

#include "kemi.inc"



// ********  REFERENCED OBJECTS  *******

#declare eMkolv = lathe {
  cubic_spline
  13  // control points
  <-1.03, -0.04>,
  <0.0, 0.06>,
  <1.96, 0.05>,
  <1.46, 0.78>,
  <0.5, 2.0>,
  <0.44, 3.63>,
  <0.57, 4.01>,
  <0.41, 3.84>,
  <0.45, 2.0>,
  <1.44, 0.75>,
  <1.91, 0.07>,
  <0.0, 0.11>,
  <-1.01, 0.09>
  rotate <90,0,90>
  texture {
    Glass1
  }
  scale 0.6
  translate  <-1.25, 4.3, 0.0>
}


#declare TraSwp001 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  9  // control points
  <-1.0, -1.0>,
  <0.5, -0.5>,
  <0.5, 0.5>,
  <-1.0, 1.0>,
  <-1.0, 0.5>,
  <0.0, 0.2>,
  <0.0, -0.2>,
  <-1.0, -0.5>,
  <-1.0, -1.0>
  rotate -x*90
  texture {
    Chrome_Textur1
  }
  scale <1.5, 1.5, 0.375>
}
#declare CSG002 = union {
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.5>
    rotate -90.0*x
    translate  <0.0, -0.25, 0.0>
  }
  sphere { // Sphere002
    <0,0,0>,1
    scale 0.05
    translate  <0.0, -0.25, 0.0>
  }
  sphere { // Sphere3
    <0,0,0>,1
    scale 0.05
    translate  <0.0, 0.25, 0.0>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 0.5>
    translate  <0.0, -0.2, -0.4>
  }
  sphere { // Sphere4
    <0,0,0>,1
    scale 0.05
    translate  <0.0, -0.2, 0.1>
  }
  sphere { // Sphere5
    <0,0,0>,1
    scale 0.05
    translate  <0.0, -0.2, -0.4>
  }
  texture {
    Chrome_Textur1
  }
  rotate -27.5*y
  translate  8.4*z
}
#declare TraSwp002 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  9  // control points
  <-0.22, -0.33>,
  <0.0, -0.6>,
  <0.8, -0.6>,
  <0.8, 0.6>,
  <-0.01, 0.6>,
  <-0.22, 0.33>,
  <0.65, 0.33>,
  <0.65, -0.33>,
  <-0.22, -0.33>
  rotate -x*90
  texture {
    plastictex
  }
  scale <1.0, 1.0, 0.2>
  translate  <-2.0, 0.0, 8.3>
}
#declare stativ1 = union {
  object { TraSwp001 }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Textur1
    }
    scale <0.075, 0.075, 10.0>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Textur1
    }
    scale <0.075, 0.075, 1.3>
    rotate -90.0*y
    translate  8.4*z
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    texture {
      plastictex
    }
    scale 0.2
    rotate -90.0*x
    translate  <0.0, -0.1, 8.4>
  }
  object { CSG002 }
  object { TraSwp002 }
}
#declare kolv3 = union {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.33, 0.33, 2.0>
  }
  sphere { // Sphere001
    <0,0,0>,1
  }
}
#declare kolv2 = union {
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 3.0>
  }
  sphere { // Sphere2
    <0,0,0>,1
    scale 0.97
  }
}
#declare kolv1 = difference {
  object { kolv3 }
  object { kolv2 }
  texture {
    Glass1
  }
}
#declare kolv7 = intersection {
  plane { // kolv6
    z,0
    translate  0.35*z
  }
  sphere { // kolv5
    <0,0,0>,1
    scale 0.965
  }
  texture {
    redtex
  }
}
#declare kolv = merge {
  object { kolv1 }
  torus { // kolv4
    0.325, 0.025  rotate -x*90
    texture {
      Glass1
    }
    translate  2.0*z
  }
  object { kolv7 }
  translate  <-1.8, 0.0, 6.7>
}
#declare stativ = union { // stativ
  object { stativ1 }
  object { kolv }
}




// ********  OBJECTS  *******

box { // Cube005
  <-1, -1, -1>, <1, 1, 1>
  texture {
    periodictex
    scale 2.0
    rotate <90.0, 0.0, 0.0>
  translate <-1.000000, -1.000000, -1.000000>
  }
  scale <7.6, 0.05, 5.35>
  rotate -15.0*z
  translate  <1.05, 22.5, 1.0>
}


cylinder { // Cylndr007
  <0,0,1>, <0,0,0>, 1 
  texture {
    Glass1
  }
  scale <0.03, 0.03, 4.0>
  rotate <0.0, 12.5, 0.0>
  translate  <-0.3, -2.55, 0.1>
}


lathe {
  cubic_spline
  16  // control points
  <-1.3, 0.0>,
  <0.0, 0.0>,
  <0.3, 0.0>,
  <0.5, 0.1>,
  <0.5, 0.5>,
  <0.5, 1.5>,
  <0.5, 2.0>,
  <0.5, 2.5>,
  <0.5, 2.9>,
  <0.6, 3.0>,
  <0.45, 3.0>,
  <0.44, 1.5>,
  <0.43, 0.6>,
  <0.41, 0.1>,
  <0.0, 0.05>,
  <-0.5, 0.1>
  rotate <90,0,90>
  texture {
    Glass1
  }
  scale 0.75
  translate  <-0.05, -2.55, 0.0>
}


#declare pencil4 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.5, -1.0>,
  <0.5, -1.0>,
  <1.0, 0.0>,
  <0.5, 1.0>,
  <-0.5, 1.0>,
  <-1.0, 0.0>,
  <-0.5, -1.0>
  rotate -x*90
  texture {
    plastictex
  }
  scale <0.08, 0.08, 4.0>
  rotate -90.0*x
}
intersection { // pencil5
  cone { // pencil3
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      DMFWood5
    }
    scale <1.0, 1.0, 5.0>
    rotate -90.0*x
  }
  object { pencil4 }
  scale 0.6
  rotate -57.5*z
  translate  <-4.4, 3.8, 0.17>
}


#declare pencil1 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.5, -1.0>,
  <0.5, -1.0>,
  <1.0, 0.0>,
  <0.5, 1.0>,
  <-0.5, 1.0>,
  <-1.0, 0.0>,
  <-0.5, -1.0>
  rotate -x*90
  texture {
    plastictex
  }
  scale <0.08, 0.08, 4.0>
  rotate -90.0*x
}
intersection { // pencil
  cone { // pencil2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      DMFWood5
    }
    scale <1.0, 1.0, 5.0>
    rotate -90.0*x
  }
  object { pencil1 }
  scale 0.6
  rotate 7.5*z
  translate  <2.6, -2.75, 0.05>
}


superellipsoid { // rubber1
  <0.1, 0.1>
  texture {
    rubbertex
  }
  scale <0.2, 0.1, 0.1>
  translate  <-3.8, 4.8, 0.2>
}


superellipsoid { // rubber
  <0.1, 0.1>
  texture {
    rubbertex
  }
  scale <0.2, 0.1, 0.1>
  rotate 17.5*z
  translate  <-2.85, -1.1, 0.1>
}


object { // eMkolv1->e-kolv
  eMkolv
  rotate 0.0*z
  translate  <12.05, -2.45, -5.7>
}


union { // block
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    texture {
      spiraltex
    }
    scale <0.07, 0.07, 4.2>
    rotate -90.0*x
    translate  <-1.4, -2.1, 0.0>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    texture {
      blocktex
    }
    scale <1.4, 2.1, 0.05>
  }
  rotate 107.5*z
  translate  <-4.85, 4.4, 0.05>
}


object { eMkolv }


plane { // Plane001
  z,0
  texture {
    floortex
  }
  translate  -10.75*z
}


box { // Cube002
  <-1, -1, -1>, <1, 1, 1>
  texture {
    walltex
  }
  scale <30.300001, 27.85, 15.7>
  rotate -15.0*z
  translate  <-14.6, -1.9, 3.0>
}


box { // Cube001
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Cork1
  }
  scale <3.2, 3.4, -0.15>
  rotate -15.0*z
  translate  <10.25, 3.65, -5.85>
}


superellipsoid { // SuprQ001
  <0.05, 0.05>
  texture {
    DMFDarkOak1
    scale <1.0, -0.1, -0.2>
    rotate -90.0*y
  }
  scale <9.0, 5.5, 0.2>
  rotate -15.0*z
  translate  <-4.6, 2.1, -0.2>
}


object { // stativ3->stativ
  stativ
  translate  <12.2, 5.1, -5.7>
}


object { // stativ2->stativ
  stativ
  rotate 52.5*z
  translate  <-2.9, 2.1, 0.0>
}




