//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 5 lights, 18 materials and 144 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 02/27/1999    (27.02.1999)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.1 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
  #declare phd=0.5;
  photon_mapping {
    min_gather_count 20
    max_gather_count 100
    min_gather_radius .1*phd*sqrt(20)/2
    gather_radius_step .1*phd*sqrt(20)/2
    gather_num_steps 2
    //min_gather_radius .1*phd*sqrt(20)
    //gather_num_steps 1
  }
}

background { color <0.000,0.000,0.000> }

fog {
  fog_type 2    // Ground Fog
  distance     75.0
  color <0.541176,0.486275,0.572549,0.0,0.0>
  turbulence   <1.0,1.0,1.0>
    omega      0.5
    lambda     2.0
    octaves    6
    turb_depth 0.0
  up           <0,0,1>
  fog_offset   0.0
  fog_alt      1.4
}

camera {  //  Camera StdCam
  location  <      0.000,     -25.468,       3.056>
  direction <        0.0,         0.0,      1.8317> // Aperture is 0.53 degrees
  sky       <    0.17348,    -0.00066,     0.98484> // Use right handed-system (rotated by 10.00 degrees)!
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <      0.000,      -1.600,       2.011>
}

//
// *******  L I G H T S *******
//

light_source {   // CausticLight
  <-3.500, -10.500, 3.250>
  color rgb <0.750, 0.750, 0.750>
  fade_distance  4.0
  fade_power 2.0
  photon_mapping { reflection on refraction on }
}

light_source {   // BackLight
  <-1512.126, -4628.332, 40.150>
  color rgb <0.257, 0.157, 0.329>*0.4283
  shadowless
}

light_source {   // FrontLight1
  <30.000, 105.000, 6.000>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  30.0
  fade_power 2.0
  media_interaction off
}

light_source {   // FrontLight2
  <-136.601, 356.248, 4.507>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  30.0
  fade_power 2.0
  media_interaction off
}

light_source {   // FrontLight3
  <-120.399, 386.878, 4.507>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  30.0
  fade_power 2.0
  media_interaction off
}


//
// ********  MATERIALS  *******
//

#include "world1.inc"


//
// ********  REFERENCED OBJECTS  *******
//

// Include contains 'Terrace1'
#include "world1.in1"

#declare Terrace1 = object {
  Terrace1_Raw
  scale <5.0, 5.0, 2.0>
  translate  <29.645392, 160.819476, -1.0>
  material {
    WaterTex
    // Transform to world space
  }
}
// Include contains 'Terrace2'
#include "world1.in2"

#declare Terrace2 = object {
  Terrace2_Raw
  scale <5.0, 5.0, 2.0>
  translate  <30.492408, 160.592703, 0.0>
  material {
    WaterTex
    // Transform to world space
  }
}
// Include contains 'Terrace3'
#include "world1.in3"

#declare Terrace3 = object {
  Terrace3_Raw
  scale <5.0, 5.0, 2.0>
  translate  <31.158739, 159.817598, 1.0>
  material {
    WaterTex
    // Transform to world space
  }
}
#declare Hill1 = union { // Hill1
  object { Terrace1 }
  object { Terrace2 }
  object { Terrace3 }
}


#declare LampArm1 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  22  // control points
  <-0.11122, 0.0>,
  <0.996642, 0.0>,
  <0.359139, 1.040634>,
  <0.903442, 1.091499>,
  <0.039121, 2.082549>,
  <0.449239, 2.171961>,
  <-1.603574, 3.439524>,
  <-1.190284, 3.785632>,
  <-3.414314, 3.780737>,
  <-3.850497, 3.937968>,
  <-4.679994, 3.554688>,
  <-4.681859, 3.459238>,
  <-3.903323, 3.666853>,
  <-1.77397, 3.54945>,
  <-1.851015, 3.370945>,
  <-0.079573, 2.243458>,
  <-0.238484, 2.11102>,
  <0.276499, 1.297994>,
  <0.1065, 1.155759>,
  <0.474088, 0.310943>,
  <0.256614, 0.399555>,
  <-0.11122, 0.0>
  rotate -x*90
  material {
    TreeMetal
  }
  scale <1.5, 1.5, 0.6>
  rotate <90.0, -0.0, 0.0>
  translate  <7.0, 0.3, 0.5>
}
#declare CyrstalArm1 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  9  // control points
  <1.676221, -2.529724>,
  <3.70913, -0.959236>,
  <2.510191, -1.147558>,
  <1.382166, -0.153291>,
  <1.186624, -0.129724>,
  <0.44586, -0.870488>,
  <1.904034, -1.474947>,
  <0.703323, -2.164034>,
  <1.676221, -2.529724>
  rotate -x*90
  scale <0.2, 0.2, 0.15>
  rotate 90.0*x
  translate  0.075*y
}


#include "C:\Pov\Working\world1\birdbody.inc"

#declare BirdBody_Ref = object {
  Layer0_Black}
#include "C:\Pov\Working\world1\wings1.inc"

#declare BirdWings1_Ref = object {
  Layer3_Black  scale 2.2
  translate  <-0.0888, 0.7831, 0.09906>
}
#declare BirdBody_Ref = object {
  Layer0_Black}


#declare BirdWings1_Ref = object {
  Layer3_Black  scale 2.2
  translate  <-0.0888, 0.7831, 0.09906>
}


#declare RotSweep005 = lathe {
  linear_spline
  7  // control points
  <1.0, 0.0>,
  <0.772688, 1.429824>,
  <1.726884, 2.341582>,
  <1.981507, 4.505879>,
  <1.069749, 5.906307>,
  <1.760502, 7.154623>,
  <1.0, 10.0>
  rotate <90,0,90>
}
#declare TreePiece16 = union {
  object { RotSweep005 }
  sphere { // Sphere009
    <0,0,0>,1
  }
  sphere { // Sphere010
    <0,0,0>,1
    translate  10.0*z
  }
}
#declare Branch17 = union {
  object { TreePiece16 }
  object { // TreePiece17->TreePiece16
    TreePiece16
    rotate <-0.0, -35.741135, 9.176926>
    translate  10.0*z
  }
  object { // TreePiece18->TreePiece16
    TreePiece16
    rotate <-0.0, 35.257706, 53.364574>
    translate  10.0*z
  }
  object { // TreePiece19->TreePiece16
    TreePiece16
    rotate <-4.449559, 55.506046, -21.283331>
    translate  10.0*z
  }
}
#declare TreeInGrove1 = union {
  object { Branch17 }
  object { // Branch18->Branch17
    Branch17
    scale 0.7
    rotate <-0.0, 19.369938, -0.0>
    translate  <-8.293762, -0.785164, 12.031915>
  }
  object { // Branch19->Branch17
    Branch17
    scale 0.7
    rotate <-0.0, -265.664063, -14.307443>
    translate  <-3.319947, 6.412176, 19.075972>
  }
  object { // Branch20->Branch17
    Branch17
    scale 0.7
    rotate <-0.0, -52.652786, 19.932573>
    translate  <13.554561, -0.261721, 11.310532>
  }
  material {
    TreeMetal
  }
}


#declare RotSweep001 = lathe {
  linear_spline
  7  // control points
  <1.0, 0.0>,
  <1.027312, 1.429824>,
  <0.665954, 2.97814>,
  <1.387386, 4.675628>,
  <0.815126, 5.991181>,
  <1.123944, 7.621432>,
  <1.0, 10.0>
  rotate <90,0,90>
}
#declare TreePiece = union {
  object { RotSweep001 }
  sphere { // Sphere001
    <0,0,0>,1
  }
  sphere { // Sphere002
    <0,0,0>,1
    translate  10.0*z
  }
}
#declare Branch1 = union {
  object { TreePiece }
  object { // TreePiece1->TreePiece
    TreePiece
    rotate <-0.0, -35.741135, 9.176926>
    translate  10.0*z
  }
  object { // TreePiece2->TreePiece
    TreePiece
    rotate <-0.0, 35.257706, 53.364574>
    translate  10.0*z
  }
  object { // TreePiece3->TreePiece
    TreePiece
    rotate <-4.449559, 55.506046, -21.283331>
    translate  10.0*z
  }
}


#declare RotSweep002 = lathe {
  linear_spline
  7  // control points
  <1.0, 0.0>,
  <1.069749, 1.429824>,
  <0.750828, 2.893266>,
  <1.005452, 4.421005>,
  <0.9, 6.203367>,
  <1.251256, 7.918493>,
  <1.0, 10.0>
  rotate <90,0,90>
}
#declare TreePiece4 = union {
  object { RotSweep002 }
  sphere { // Sphere003
    <0,0,0>,1
  }
  sphere { // Sphere004
    <0,0,0>,1
    translate  10.0*z
  }
}
#declare Branch5 = union {
  object { TreePiece4 }
  object { // TreePiece5->TreePiece4
    TreePiece4
    rotate <-0.0, -35.741135, 9.176926>
    translate  10.0*z
  }
  object { // TreePiece6->TreePiece4
    TreePiece4
    rotate <-0.0, 35.257706, 53.364574>
    translate  10.0*z
  }
  object { // TreePiece7->TreePiece4
    TreePiece4
    rotate <-4.449559, 55.506046, -21.283331>
    translate  10.0*z
  }
}


#declare RotSweep003 = lathe {
  linear_spline
  7  // control points
  <1.0, 0.0>,
  <1.069749, 1.811758>,
  <1.429824, 2.765954>,
  <1.1752, 5.142437>,
  <0.687814, 5.948744>,
  <1.03907, 7.748744>,
  <1.0, 10.0>
  rotate <90,0,90>
}
#declare TreePiece8 = union {
  object { RotSweep003 }
  sphere { // Sphere005
    <0,0,0>,1
  }
  sphere { // Sphere006
    <0,0,0>,1
    translate  10.0*z
  }
}
#declare Branch9 = union {
  object { TreePiece8 }
  object { // TreePiece9->TreePiece8
    TreePiece8
    rotate <-0.0, -35.741135, 9.176926>
    translate  10.0*z
  }
  object { // TreePiece10->TreePiece8
    TreePiece8
    rotate <-0.0, 35.257706, 53.364574>
    translate  10.0*z
  }
  object { // TreePiece11->TreePiece8
    TreePiece8
    rotate <-4.449559, 55.506046, -21.283331>
    translate  10.0*z
  }
}


#declare RotSweep004 = lathe {
  linear_spline
  7  // control points
  <1.0, 0.0>,
  <1.027312, 1.429824>,
  <1.260075, 2.893266>,
  <0.87814, 4.123944>,
  <1.19706, 5.312186>,
  <1.03907, 7.366809>,
  <1.0, 10.0>
  rotate <90,0,90>
}
#declare TreePiece12 = union {
  object { RotSweep004 }
  sphere { // Sphere007
    <0,0,0>,1
  }
  sphere { // Sphere008
    <0,0,0>,1
    translate  10.0*z
  }
}
#declare Branch13 = union {
  object { TreePiece12 }
  object { // TreePiece13->TreePiece12
    TreePiece12
    rotate <-0.0, -35.741135, 9.176926>
    translate  10.0*z
  }
  object { // TreePiece14->TreePiece12
    TreePiece12
    rotate <-0.0, 35.257706, 53.364574>
    translate  10.0*z
  }
  object { // TreePiece15->TreePiece12
    TreePiece12
    rotate <-4.449559, 55.506046, -21.283331>
    translate  10.0*z
  }
}




//
// ********  OBJECTS  *******
//

lathe { // Stand
  linear_spline
  12  // control points
  <1.8, -0.202123>,
  <1.8, -0.002123>,
  <2.0, 0.397877>,
  <1.46375, 0.769127>,
  <1.441426, 0.907071>,
  <1.285, 0.892877>,
  <0.7, 1.297877>,
  <0.535, 1.957877>,
  <0.603041, 2.078493>,
  <0.48, 2.177877>,
  <0.3, 2.897877>,
  <0.0, 3.197877>
  rotate <90,0,90>
  material {
    CrystalTex
  }
  scale 1.5
  translate  <30.0, 105.0, 0.0>
  photon_mapping { ignore_photons }
}


object { // Hill3->Hill1
  Hill1
  rotate 67.021004*z
  translate  <198.084898, 68.922561, 0.0>
}


#declare sky_vect = <0.17348, -0.00066, 0.98484>;
#declare cam_loc = <0.000, -25.468, 3.056>;  // using camera 'StdCam'
#declare lookat = <0.000, -1.600, 2.011>;
#declare light_loc = <30.00000, 105.00000, 6.00000>;  // using light source 'FrontLight1'

#declare flare_size = 0.200;
#declare bright_background = 0;
#declare flare_brightness = 0.750;
// Note: if the following two lines cause an error, make sure that
// you have the NKFlare\ subdirectory in the directory where you are
// exporting POV-files to.
#include "NKFlare\Sparkle4.flr"
#include "NKFlare\nkflare.inc"


// Include contains 'Terrace4'
#include "world1.in4"

#declare Terrace4 = object {
  Terrace4_Raw
  scale <5.0, 5.0, 2.0>
  translate  <-27.111184, 156.247221, -1.0>
  material {
    WaterTex
    // Transform to world space
  }
}
// Include contains 'Terrace5'
#include "world1.in5"

#declare Terrace5 = object {
  Terrace5_Raw
  scale <5.0, 5.0, 2.0>
  translate  <-27.111184, 156.247221, 0.0>
  material {
    WaterTex
    // Transform to world space
  }
}
// Include contains 'Terrace6'
#include "world1.in6"

#declare Terrace6 = object {
  Terrace6_Raw
  scale <5.0, 5.0, 2.0>
  translate  <-27.111184, 156.247221, 1.0>
  material {
    WaterTex
    // Transform to world space
  }
}
union { // Hill2
  object { Terrace4 }
  object { Terrace5 }
  object { Terrace6 }
}


object { Hill1 }


#declare Pyramid1 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 0.75>
  rotate <-0.0, -180.0, 194.870865>
  translate  <2.540692, -11.688692, 0.75>
}
#declare Pyramid2 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.1>
  rotate <-0.0, -180.0, 164.327591>
  translate  <2.620007, -12.839074, 1.1>
}
#declare Pyramid3 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.5>
  rotate <-0.0, -180.0, 163.749069>
  translate  <2.947348, -10.57757, 1.5>
}
#declare Pyramid4 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 0.6>
  rotate <-0.0, -180.0, -157.503235>
  translate  <3.760662, -10.676957, 0.6>
}
#declare Pyramid5 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 0.9>
  rotate <-0.0, -180.0, -135.019516>
  translate  <1.568659, -12.055559, 0.9>
}
#declare Pyramid6 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.3>
  rotate <-0.0, -180.0, 251.721893>
  translate  <1.965412, -10.399221, 1.3>
}
#declare Pyramid7 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.0>
  rotate <-0.0, -180.0, 175.55278>
  translate  <3.691162, -12.12497, 1.0>
}
#declare BunchOfPyramids = union {
  object { Pyramid1 }
  object { Pyramid2 }
  object { Pyramid3 }
  object { Pyramid4 }
  object { Pyramid5 }
  object { Pyramid6 }
  object { Pyramid7 }
  material {
    HillTex
  }
  translate  <-0.291324, -4.140753, 0.0>
}
#declare Pyramid15 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 0.75>
  rotate <-0.0, -180.0, 194.870865>
  translate  <2.540692, -11.688692, 0.75>
}
#declare Pyramid16 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.1>
  rotate <-0.0, -180.0, 164.327591>
  translate  <2.620007, -12.839074, 1.1>
}
#declare Pyramid17 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.5>
  rotate <-0.0, -180.0, 163.749069>
  translate  <2.947348, -10.57757, 1.5>
}
#declare Pyramid18 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 0.6>
  rotate <-0.0, -180.0, -157.503235>
  translate  <3.760662, -10.676957, 0.6>
}
#declare Pyramid19 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 0.9>
  rotate <-0.0, -180.0, -135.019516>
  translate  <1.568659, -12.055559, 0.9>
}
#declare Pyramid20 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.3>
  rotate <-0.0, -180.0, 251.721893>
  translate  <1.965412, -10.399221, 1.3>
}
#declare Pyramid21 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.0>
  rotate <-0.0, -180.0, 175.55278>
  translate  <3.691162, -12.12497, 1.0>
}
#declare BunchOfPyramids2 = union {
  object { Pyramid15 }
  object { Pyramid16 }
  object { Pyramid17 }
  object { Pyramid18 }
  object { Pyramid19 }
  object { Pyramid20 }
  object { Pyramid21 }
  material {
    HillTex
  }
  translate  <-12.490802, 25.863458, 0.0>
}
#declare Pyramid22 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 0.75>
  rotate <-0.0, -180.0, 194.870865>
  translate  <2.540692, -11.688692, 0.75>
}
#declare Pyramid23 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.1>
  rotate <-0.0, -180.0, 164.327591>
  translate  <2.620007, -12.839074, 1.1>
}
#declare Pyramid24 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.5>
  rotate <-0.0, -180.0, 163.749069>
  translate  <2.947348, -10.57757, 1.5>
}
#declare Pyramid25 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 0.6>
  rotate <-0.0, -180.0, -157.503235>
  translate  <3.760662, -10.676957, 0.6>
}
#declare Pyramid26 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 0.9>
  rotate <-0.0, -180.0, -135.019516>
  translate  <1.568659, -12.055559, 0.9>
}
#declare Pyramid27 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.3>
  rotate <-0.0, -180.0, 251.721893>
  translate  <1.965412, -10.399221, 1.3>
}
#declare Pyramid28 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.0>
  rotate <-0.0, -180.0, 175.55278>
  translate  <3.691162, -12.12497, 1.0>
}
#declare BunchOfPyramids3 = union {
  object { Pyramid22 }
  object { Pyramid23 }
  object { Pyramid24 }
  object { Pyramid25 }
  object { Pyramid26 }
  object { Pyramid27 }
  object { Pyramid28 }
  material {
    HillTex
  }
  translate  <-4.491519, 37.69538, 0.0>
}
#declare Pyramid43 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 0.75>
  rotate <-0.0, -180.0, 194.870865>
  translate  <2.540692, -11.688692, 0.75>
}
#declare Pyramid44 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.1>
  rotate <-0.0, -180.0, 164.327591>
  translate  <2.620007, -12.839074, 1.1>
}
#declare Pyramid45 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.5>
  rotate <-0.0, -180.0, 163.749069>
  translate  <2.947348, -10.57757, 1.5>
}
#declare Pyramid46 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 0.6>
  rotate <-0.0, -180.0, -157.503235>
  translate  <3.760662, -10.676957, 0.6>
}
#declare Pyramid47 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 0.9>
  rotate <-0.0, -180.0, -135.019516>
  translate  <1.568659, -12.055559, 0.9>
}
#declare Pyramid48 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.3>
  rotate <-0.0, -180.0, 251.721893>
  translate  <1.965412, -10.399221, 1.3>
}
#declare Pyramid49 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.0>
  rotate <-0.0, -180.0, 175.55278>
  translate  <3.691162, -12.12497, 1.0>
}
#declare BunchOfPyramids6 = union {
  object { Pyramid43 }
  object { Pyramid44 }
  object { Pyramid45 }
  object { Pyramid46 }
  object { Pyramid47 }
  object { Pyramid48 }
  object { Pyramid49 }
  material {
    HillTex
  }
  translate  <22.009798, 93.200505, 0.0>
}
#declare Pyramid57 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 0.75>
  rotate <-0.0, -180.0, 194.870865>
  translate  <2.540692, -11.688692, 0.75>
}
#declare Pyramid58 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.1>
  rotate <-0.0, -180.0, 164.327591>
  translate  <2.620007, -12.839074, 1.1>
}
#declare Pyramid59 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.5>
  rotate <-0.0, -180.0, 163.749069>
  translate  <2.947348, -10.57757, 1.5>
}
#declare Pyramid60 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 0.6>
  rotate <-0.0, -180.0, -157.503235>
  translate  <3.760662, -10.676957, 0.6>
}
#declare Pyramid61 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 0.9>
  rotate <-0.0, -180.0, -135.019516>
  translate  <1.568659, -12.055559, 0.9>
}
#declare Pyramid62 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.3>
  rotate <-0.0, -180.0, 251.721893>
  translate  <1.965412, -10.399221, 1.3>
}
#declare Pyramid63 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.0>
  rotate <-0.0, -180.0, 175.55278>
  translate  <3.691162, -12.12497, 1.0>
}
#declare BunchOfPyramids8 = union {
  object { Pyramid57 }
  object { Pyramid58 }
  object { Pyramid59 }
  object { Pyramid60 }
  object { Pyramid61 }
  object { Pyramid62 }
  object { Pyramid63 }
  material {
    HillTex
  }
  translate  <11.130827, 26.285167, 0.0>
}
#declare Pyramid78 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 0.75>
  rotate <-0.0, -180.0, 194.870865>
  translate  <2.540692, -11.688692, 0.75>
}
#declare Pyramid79 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.1>
  rotate <-0.0, -180.0, 164.327591>
  translate  <2.620007, -12.839074, 1.1>
}
#declare Pyramid80 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.5>
  rotate <-0.0, -180.0, 163.749069>
  translate  <2.947348, -10.57757, 1.5>
}
#declare Pyramid81 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 0.6>
  rotate <-0.0, -180.0, -157.503235>
  translate  <3.760662, -10.676957, 0.6>
}
#declare Pyramid82 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 0.9>
  rotate <-0.0, -180.0, -135.019516>
  translate  <1.568659, -12.055559, 0.9>
}
#declare Pyramid83 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.3>
  rotate <-0.0, -180.0, 251.721893>
  translate  <1.965412, -10.399221, 1.3>
}
#declare Pyramid84 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.0>
  rotate <-0.0, -180.0, 175.55278>
  translate  <3.691162, -12.12497, 1.0>
}
#declare BunchOfPyramids11 = union {
  object { Pyramid78 }
  object { Pyramid79 }
  object { Pyramid80 }
  object { Pyramid81 }
  object { Pyramid82 }
  object { Pyramid83 }
  object { Pyramid84 }
  material {
    HillTex
  }
  translate  <-12.026992, 60.301799, 0.0>
}
#declare Pyramid85 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 0.75>
  rotate <-0.0, -180.0, 194.870865>
  translate  <2.540692, -11.688692, 0.75>
}
#declare Pyramid86 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.1>
  rotate <-0.0, -180.0, 164.327591>
  translate  <2.620007, -12.839074, 1.1>
}
#declare Pyramid87 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.5>
  rotate <-0.0, -180.0, 163.749069>
  translate  <2.947348, -10.57757, 1.5>
}
#declare Pyramid88 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 0.6>
  rotate <-0.0, -180.0, -157.503235>
  translate  <3.760662, -10.676957, 0.6>
}
#declare Pyramid89 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 0.9>
  rotate <-0.0, -180.0, -135.019516>
  translate  <1.568659, -12.055559, 0.9>
}
#declare Pyramid90 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.3>
  rotate <-0.0, -180.0, 251.721893>
  translate  <1.965412, -10.399221, 1.3>
}
#declare Pyramid91 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.0>
  rotate <-0.0, -180.0, 175.55278>
  translate  <3.691162, -12.12497, 1.0>
}
#declare BunchOfPyramids12 = union {
  object { Pyramid85 }
  object { Pyramid86 }
  object { Pyramid87 }
  object { Pyramid88 }
  object { Pyramid89 }
  object { Pyramid90 }
  object { Pyramid91 }
  material {
    HillTex
  }
  translate  <-31.44993, 69.708493, 0.0>
}
#declare Pyramid92 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 0.75>
  rotate <-0.0, -180.0, 194.870865>
  translate  <2.540692, -11.688692, 0.75>
}
#declare Pyramid93 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.1>
  rotate <-0.0, -180.0, 164.327591>
  translate  <2.620007, -12.839074, 1.1>
}
#declare Pyramid94 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.5>
  rotate <-0.0, -180.0, 163.749069>
  translate  <2.947348, -10.57757, 1.5>
}
#declare Pyramid95 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 0.6>
  rotate <-0.0, -180.0, -157.503235>
  translate  <3.760662, -10.676957, 0.6>
}
#declare Pyramid96 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 0.9>
  rotate <-0.0, -180.0, -135.019516>
  translate  <1.568659, -12.055559, 0.9>
}
#declare Pyramid97 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.3>
  rotate <-0.0, -180.0, 251.721893>
  translate  <1.965412, -10.399221, 1.3>
}
#declare Pyramid98 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <0.2, 0.2, 1.0>
  rotate <-0.0, -180.0, 175.55278>
  translate  <3.691162, -12.12497, 1.0>
}
#declare BunchOfPyramids13 = union {
  object { Pyramid92 }
  object { Pyramid93 }
  object { Pyramid94 }
  object { Pyramid95 }
  object { Pyramid96 }
  object { Pyramid97 }
  object { Pyramid98 }
  material {
    HillTex
  }
  translate  <13.67761, 61.075064, 0.0>
}
union { // Pyramids
  object { BunchOfPyramids }
  object { BunchOfPyramids2 }
  object { BunchOfPyramids3 }
  object { BunchOfPyramids6 }
  object { BunchOfPyramids8 }
  object { BunchOfPyramids11 }
  object { BunchOfPyramids12 }
  object { BunchOfPyramids13 }
}


#declare sky_vect = <0.17348, -0.00066, 0.98484>;
#declare cam_loc = <0.000, -25.468, 3.056>;  // using camera 'StdCam'
#declare lookat = <0.000, -1.600, 2.011>;
#declare light_loc = <-3.50000, -10.50000, 3.25000>;  // using light source 'CausticLight'

#declare flare_size = 0.500;
#declare bright_background = 0;
#declare flare_brightness = 0.700;
// Note: if the following two lines cause an error, make sure that
// you have the NKFlare\ subdirectory in the directory where you are
// exporting POV-files to.
#include "NKFlare\Sparkle4.flr"
#include "NKFlare\nkflare.inc"


#declare LampStandBase1 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  19  // control points
  <-1.106157, 0.0>,
  <-0.8, -0.5>,
  <-1.0, -1.0>,
  <-0.5, -0.8>,
  <0.010616, -1.116773>,
  <0.5, -0.8>,
  <1.0, -1.0>,
  <0.8, -0.5>,
  <1.106157, -0.010616>,
  <0.8, 0.5>,
  <1.0, 1.0>,
  <0.5, 0.8>,
  <0.0, 1.138004>,
  <-0.5, 0.8>,
  <-1.0, 1.0>,
  <-0.8, 0.5>,
  <-1.106157, 0.0>,
  <-0.8, -0.5>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    ChromeTex
  }
  scale <1.5, 1.5, 0.5>
  rotate -45.0*z
  translate  7.3*x
}
#declare LampCrystal = merge {
  superellipsoid { // HangingLight
    <0.1, 2.0>
    scale 0.35
  }
  object { CyrstalArm1 }
  object { // CyrstalArm2->CyrstalArm1
    CyrstalArm1
    rotate -90.0*z
    translate  -0.0*y
  }
  object { // CyrstalArm3->CyrstalArm1
    CyrstalArm1
    rotate 180.0*z
    translate  -0.0*x
  }
  object { // CyrstalArm4->CyrstalArm1
    CyrstalArm1
    rotate 90.0*z
  }
  material {
    CrystalTex
  }
  scale 1.428571
  rotate -12.858212*z
  translate  <0.0, 0.0, 5.3>
}
union { // LampAssembly1
  object { LampArm1 }
  object { LampStandBase1   photon_mapping { photon_density 0.02*phd ignore_photons }}
  object { LampCrystal }
  object { // LampArm2->LampArm1
    LampArm1
    rotate <-0.0, -0.0, 180.0>
    translate  -0.0*z
  }
  scale 0.7
  rotate 12.729344*z
  translate  <-3.5, -10.5, 0.0>
}


sphere { // SkySph
  <0,0,0>,1
  material {
    SkyTex
  }
  hollow
  scale 100000.0
}




merge { // Bird3
  object { // BirdBody3->BirdBody
    BirdBody_Ref
  }
  object { // BirdWings3->BirdWings1
    BirdWings1_Ref
    translate  -0.0*x
  }
  material {
    Glass_1
  }
  scale 0.3
  rotate <82.563171, 0.0, -0.0>
  translate  <-6.226813, 0.725408, 7.990415>
  photon_mapping { ignore_photons }
}


#include "C:\Pov\Working\world1\wings2.inc"

#declare BirdWings2_Ref = object {
  Layer1_Black
  scale 4.5
  translate  <-0.0904, 1.40337, 0.0>
}
merge { // Bird2
  object { // BirdBody2->BirdBody
    BirdBody_Ref
  }
  object { BirdWings2_Ref }
  material {
    Glass_1
  }
  scale 0.3
  rotate <104.874443, -0.243986, 2.462891>
  translate  <-2.733485, -10.992455, 0.9826>
  photon_mapping { photon_density 0.02*phd ignore_photons }
}


merge { // Bird1
  object { // BirdBody1->BirdBody
    BirdBody_Ref
  }
  object { BirdWings1_Ref }
  material {
    Glass_1
  }
  scale 0.3
  rotate <102.183044, 17.342432, -16.564775>
  translate  <1.212399, -19.807253, 2.343036>
  photon_mapping { ignore_photons }
}




plane { // Plane001
  z,0
  material {
    WaterTex
  }
  photon_mapping { reflection off }
}


box { // MountainsCube
  <-1, -1, -1>, <1, 1, 1>
  material {
    MountainsTex2
  }
  scale <1000.0, 1.0, 1000.0>
  translate  <0.0, 2145.5, 120.0>
}


union { // Tree1
  object { Branch1 }
  object { // Branch2->Branch1
    Branch1
    scale 0.7
    rotate <-0.0, 19.369938, -0.0>
    translate  <-8.293762, -0.785164, 12.031915>
  }
  object { // Branch3->Branch1
    Branch1
    scale 0.7
    rotate <-0.0, -265.664063, -14.307443>
    translate  <-3.319947, 6.412176, 19.075972>
  }
  object { // Branch4->Branch1
    Branch1
    scale 0.7
    rotate <-0.0, -52.652786, 19.932573>
    translate  <13.554561, -0.261721, 11.310532>
  }
  material {
    TreeMetal
  }
  translate  <34.17769, 88.672323, 0.0>
}


union { // Tree2
  object { Branch5 }
  object { // Branch6->Branch5
    Branch5
    scale 0.7
    rotate <-0.0, 19.369938, -0.0>
    translate  <-8.293762, -0.785164, 12.031915>
  }
  object { // Branch7->Branch5
    Branch5
    scale 0.7
    rotate <-0.0, -265.664063, -14.307443>
    translate  <-3.319947, 6.412176, 19.075972>
  }
  object { // Branch8->Branch5
    Branch5
    scale 0.7
    rotate <-0.0, -52.652786, 19.932573>
    translate  <13.554561, -0.261721, 11.310532>
  }
  material {
    TreeMetal
  }
  rotate -7.849249*z
  translate  <42.820078, 105.028725, 0.0>
}


union { // Tree3
  object { Branch9 }
  object { // Branch10->Branch9
    Branch9
    scale 0.7
    rotate <-0.0, 19.369938, -0.0>
    translate  <-8.293762, -0.785164, 12.031915>
  }
  object { // Branch11->Branch9
    Branch9
    scale 0.7
    rotate <-0.0, -265.664063, -14.307443>
    translate  <-3.319947, 6.412176, 19.075972>
  }
  object { // Branch12->Branch9
    Branch9
    scale 0.7
    rotate <-0.0, -52.652786, 19.932573>
    translate  <13.554561, -0.261721, 11.310532>
  }
  material {
    TreeMetal
  }
  rotate 162.276932*z
  translate  <14.070607, 100.259431, 0.0>
}


union { // Tree4
  object { Branch13 }
  object { // Branch14->Branch13
    Branch13
    scale 0.7
    rotate <-0.0, 19.369938, -0.0>
    translate  <-8.293762, -0.785164, 12.031915>
  }
  object { // Branch15->Branch13
    Branch13
    scale 0.7
    rotate <-0.0, -265.664063, -14.307443>
    translate  <-3.319947, 6.412176, 19.075972>
  }
  object { // Branch16->Branch13
    Branch13
    scale 0.7
    rotate <-0.0, -52.652786, 19.932573>
    translate  <13.554561, -0.261721, 11.310532>
  }
  material {
    TreeMetal
  }
  rotate 31.568371*z
  translate  <25.733939, 119.734865, 0.0>
}








