//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 2 lights, 16 textures and 282 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 01/14/1999    (14.01.1999)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
    finish { diffuse 0.4 ambient 0.3 specular 0.6 roughness 0.001 }
  }
}

/* // Scene Comment

This scene was created with Moray V3.1 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

fog {
  fog_type 1    // Constant
  distance     5000.0
  color <0.6,0.6,0.6,0.0,0.0>
}

camera {  //  Camera Camera01
  location  <    -45.913,     160.803,    -430.966>
  direction <        0.0,         0.0,      2.4880> // Aperture is 0.40 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <    -22.361,      -1.649,    -163.511>
}

//
// *******  L I G H T S *******
//

light_source {   // Light001
  <-48.539, 117.224, -378.293>
  color rgb <1.000, 0.000, 1.000>
  shadowless
}

light_source {   // RingSun
  <0.000, 0.000, 0.000>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  195.0
  fade_power 100.0
}


//
// ********  TEXTURES  *******
//

#include "ring.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare HT_OKranzKugel1 = object {
  sphere { // HT_OKranzKugel1
    <0,0,0>,1
    material {
      Steuertribwer2
    }
    scale 0.15
    translate  <0.5, 1.1, 2.4>
  }
}
#declare HT_ObKranzKugel = union {
  object { HT_OKranzKugel1 }
  object { // HT_OKranzKuge2->HT_OKranzKugel1
    HT_OKranzKugel1
    rotate <-0.0, 0.0, -90.0>
    translate  <0.031371, 0.924264, 0.0>
  }
  object { // HT_OKranzKuge3->HT_OKranzKugel1
    HT_OKranzKugel1
    rotate <-0.0, 0.0, 180.0>
    translate  <1.6, 0.6, 0.0>
  }
  object { // HT_OKranzKuge4->HT_OKranzKugel1
    HT_OKranzKugel1
    rotate <-0.0, 0.0, 90.0>
    translate  <1.524264, -1.631371, 0.0>
  }
  object { // HT_OKranzKuge5->HT_OKranzKugel1
    HT_OKranzKugel1
    rotate <-0.0, 0.0, -0.0>
    translate  <-1.0, -2.2, 0.0>
  }
  object { // HT_OKranzKuge6->HT_OKranzKugel1
    HT_OKranzKugel1
    rotate <-0.0, 0.0, -90.0>
    translate  <-2.231371, 0.075736, 0.0>
  }
  object { // HT_OKranzKuge7->HT_OKranzKugel1
    HT_OKranzKugel1
    rotate <-0.0, 0.0, 180.0>
    translate  <-0.6, 1.6, 0.0>
  }
  object { // HT_OKranzKuge8->HT_OKranzKugel1
    HT_OKranzKugel1
    rotate <-0.0, 0.0, 90.0>
    translate  <0.675736, 0.631371, 0.0>
  }
}
#declare HT_Auslass1 = object {
  torus { // HT_Auslass1
    0.35, 0.05  rotate -x*90
    rotate -90.0*x
    translate  <0.0, -1.6, 1.5>
  }
}
#declare HT_Strebe1 = object {
  box { // HT_Strebe1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 0.3, 0.3>
    rotate -45.0*x
    translate  <0.0, 0.9, 2.4>
  }
}
#declare HT_OStrebnkranz = union {
  object { HT_Strebe1 }
  object { // HT_Strebe2->HT_Strebe1
    HT_Strebe1
    rotate -45.0*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // HT_Strebe3->HT_Strebe1
    HT_Strebe1
    rotate -90.0*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // HT_Strebe4->HT_Strebe1
    HT_Strebe1
    rotate -135.0*z
    translate  <0.0, 0.0, -0.0>
  }
  object { // HT_Strebe5->HT_Strebe1
    HT_Strebe1
    rotate -180.0*z
    translate  <0.0, 0.0, -0.0>
  }
  object { // HT_Strebe6->HT_Strebe1
    HT_Strebe1
    rotate 135.0*z
    translate  <0.0, -0.0, -0.0>
  }
  object { // HT_Strebe7->HT_Strebe1
    HT_Strebe1
    rotate 90.0*z
    translate  <0.0, -0.0, -0.0>
  }
  object { // HT_Strebe8->HT_Strebe1
    HT_Strebe1
    rotate 45.0*z
    translate  <-0.0, -0.0, -0.0>
  }
}
#declare HT_Licht = object {
  cylinder { // HT_Licht
    <0,0,1>, <0,0,0>, 1 
    material {
      Steuertribwer2
    }
    scale <0.3, 0.3, 2.6>
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.3, 0.0, 1.5>
  }
}
//
// Include file contains 'WE_Cover'
//
#include "ring.in1"
#declare WE_Cover = object {
  WE_Cover_Raw
  material {
    BlueGlass_Tex
  }
  scale 1.5
  translate  -0.9*z
}
#declare WR_Rotor1 = union {
  sphere { // WeaponSphere1
    <0,0,0>,1
    scale 0.2
    translate  <0.8, 0.0, -1.4>
  }
  sphere { // WeaponSphere2
    <0,0,0>,1
    scale 0.2
    translate  <-0.8, 0.0, -1.4>
  }
  cylinder { // WeaponCyl2
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 1.4>
    rotate 90.0*y
    translate  <-0.7, 0.0, -1.4>
  }
}
#declare WR_Rotor2 = union {
  sphere { // WeaponSphere3
    <0,0,0>,1
    scale 0.2
    translate  <0.8, 0.0, -1.4>
  }
  sphere { // WeaponSphere4
    <0,0,0>,1
    scale 0.2
    translate  <-0.8, 0.0, -1.4>
  }
  cylinder { // WeaponCyl3
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 1.4>
    rotate 90.0*y
    translate  <-0.7, 0.0, -1.4>
  }
  rotate -90.0*z
}
#declare W_Rotor = union {
  cone { // WR_Cone
    <0,0,0>, 0.0, <0,0,1>, 0.1
    scale 2.0
    rotate 180.0*x
  }
  object { WR_Rotor1 }
  object { WR_Rotor2 }
  material {
    Silver
  }
}
#declare WE_Weapon = union {
  object { WE_Cover }
  object { W_Rotor }
}
#declare WE_RingFront = union {
  torus { // WEM_Ring1
    0.5, 0.1  rotate -x*90
    scale 0.7
    rotate -90.0*x
    translate  <-1.5, 4.03, 0.0>
  }
  torus { // WEM_Ring2
    0.5, 0.1  rotate -x*90
    scale <0.84, 0.84, 0.7>
    rotate -90.0*x
    translate  <-1.5, 3.89, 0.0>
  }
  torus { // WEM_Ring3
    0.5, 0.1  rotate -x*90
    scale <1.008, 1.008, 0.7>
    rotate -90.0*x
    translate  <-1.5, 3.75, 0.0>
  }
  torus { // WEM_Ring4
    0.5, 0.1  rotate -x*90
    scale <1.2096, 1.2096, 0.7>
    rotate -90.0*x
    translate  <-1.5, 3.61, 0.0>
  }
  torus { // WEM_Ring5
    0.5, 0.1  rotate -x*90
    scale <1.4, 1.4, 0.7>
    rotate -90.0*x
    translate  <-1.5, 3.47, 0.0>
  }
  material {
    BlueHull_Tex
  }
  scale 1.428571
  rotate 90.0*x
  translate  <2.142857, 0.0, -7.857143>
}
#declare WE_Main = union {
  cylinder { // WEM_Engine
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 10.0>
    translate  -12.9*z
  }
  object { WE_RingFront }
}
#declare WE_RingBack = union {
  torus { // WEO_Ring1
    0.5, 0.1  rotate -x*90
    scale <1.4, 1.4, 0.7>
    rotate -90.0*x
    translate  <-1.5, -4.09, 0.0>
  }
  torus { // WEO_Ring2
    0.5, 0.1  rotate -x*90
    scale <1.2096, 1.2096, 0.7>
    rotate -90.0*x
    translate  <-1.5, -3.95, 0.0>
  }
  torus { // WEO_Ring3
    0.5, 0.1  rotate -x*90
    scale <1.008, 1.008, 0.7>
    rotate -90.0*x
    translate  <-1.5, -3.81, 0.0>
  }
  torus { // WEO_Ring4
    0.5, 0.1  rotate -x*90
    scale <0.84, 0.84, 0.7>
    rotate -90.0*x
    translate  <-1.5, -3.67, 0.0>
  }
  torus { // WEO_Ring5
    0.5, 0.1  rotate -x*90
    scale 0.7
    rotate -90.0*x
    translate  <-1.5, -3.53, 0.0>
  }
  material {
    BlueHull_Tex
  }
  scale 1.428571
  rotate 90.0*x
  translate  <2.142857, 0.0, -7.857143>
}
#declare WE_Outlet = union {
  cylinder { // WEO_Outlet
    <0,0,1>, <0,0,0>, 1 open
    scale <1.2, 1.2, 1.5>
    translate  -15.2*z
  }
  object { WE_RingBack }
}
#declare WeaponEngine = union {
  object { WE_Weapon }
  object { WE_Main }
  object { WE_Outlet }
  scale 0.6
  rotate -90.0*x
  translate  <-1.5, 4.8, 0.0>
}
#declare A_Balken = intersection {
  plane { // A_Vorne
    z,0
    rotate <-90.0, 0.0, 2.0>
    translate  0.5*y
  }
  plane { // A_Oben
    z,0
    rotate -1.0*y
    translate  0.2*z
  }
  plane { // A_Hinten
    z,0
    rotate <90.0, 0.0, -2.0>
    translate  -0.5*y
  }
  plane { // A_Unten
    z,0
    rotate <180.0, 1.0, 0.0>
    translate  -0.2*z
  }
  plane { // A_Links
    z,0
    rotate -90.0*y
    translate  -1.0*x
  }
  plane { // A_Rechts
    z,0
    rotate 90.0*y
    translate  7.5*x
  }
}
#declare KWaffeBodyCSG = intersection {
  plane { // KWaffePlane01
    z,0
  }
  plane { // KWaffePlane2
    z,0
    rotate 45.0*y
    translate  <0.6, 0.0, -0.3>
  }
  plane { // KWaffePlane3
    z,0
    rotate 90.0*y
    translate  <0.9, 0.0, -0.85>
  }
  plane { // KWaffePlane4
    z,0
    rotate <-180.0, 0.0, -180.0>
    translate  <0.55, 0.0, -1.2>
  }
  plane { // KWaffePlane5
    z,0
    rotate <180.0, -45.0, -180.0>
    translate  <-0.1, 0.0, -0.85>
  }
  plane { // KWaffePlane6
    z,0
    rotate <0.0, -90.0, 0.0>
    translate  <-0.35, 0.0, -0.3>
  }
  plane { // KWaffePlane7
    z,0
    rotate 90.0*x
    translate  <0.0, -0.4, -0.55>
  }
  plane { // KWaffePlane8
    z,0
    rotate -90.0*x
    translate  <0.0, 0.9, -0.5>
  }
  scale 1.25
  rotate <-180.0, 45.0, 0.0>
  translate  <2.520842, 0.3125, -0.284094>
}
#declare KleineWaffe = difference {
  object { KWaffeBodyCSG }
  box { // KW_LochLinks
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black_Tex
    }
    scale <0.2, 1.0, 0.1>
    translate  3.6*x
  }
  box { // KW_LochRechts
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black_Tex
    }
    scale <0.2, 1.0, 0.1>
    translate  3.0*x
  }
}
#declare AuslegerArm = union {
  object { A_Balken }
  object { KleineWaffe }
}
#declare Ausleger = union {
  object { WeaponEngine }
  object { AuslegerArm }
  material {
    HullCyl_Tex1
  }
  scale 0.8
  rotate <-90.0, 0.0, 45.0>
  translate  <-4.9, -4.8, 1.5>
}
#declare ST_SchraegeF = object {
  cone { // ST_SchraegeF
    <0,0,0>, 1.0, <0,0,1>, 0.8
    scale <1.0, 1.0, 0.25>
    translate  2.1*z
  }
}
#declare ST_Bohrung2 = object {
  cylinder { // ST_Bohrung2
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 2.0>
    rotate <-90.0, 0.0, -90.0>
    translate  -1.0*x
  }
}
#declare ST_Strebe1 = object {
  cylinder { // ST_Strebe1
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.6>
    rotate -38.650002*y
    translate  <1.1, 0.0, 2.0>
  }
}
#declare ST_OStrebnkranz = union {
  object { ST_Strebe1 }
  object { // ST_Strebe2->ST_Strebe1
    ST_Strebe1
    rotate <-0.0, -0.0, -15.0>
  }
  object { // ST_Strebe3->ST_Strebe1
    ST_Strebe1
    rotate <0.0, -0.0, -30.0>
    translate  0.0*x
  }
  object { // ST_Strebe4->ST_Strebe1
    ST_Strebe1
    rotate <0.0, -0.0, -45.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // ST_Strebe5->ST_Strebe1
    ST_Strebe1
    rotate <0.0, -0.0, -60.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // ST_Strebe6->ST_Strebe1
    ST_Strebe1
    rotate <0.0, -0.0, -75.0>
    translate  0.0*y
  }
  object { // ST_Strebe7->ST_Strebe1
    ST_Strebe1
    rotate <-0.0, -0.0, -90.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // ST_Strebe8->ST_Strebe1
    ST_Strebe1
    rotate <0.0, -0.0, -105.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // ST_Strebe9->ST_Strebe1
    ST_Strebe1
    rotate <0.0, -0.0, -120.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // ST_Strebe10->ST_Strebe1
    ST_Strebe1
    rotate <0.0, -0.0, -135.0>
    translate  0.0*y
  }
  object { // ST_Strebe11->ST_Strebe1
    ST_Strebe1
    rotate <0.0, -0.0, -150.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // ST_Strebe12->ST_Strebe1
    ST_Strebe1
    rotate <0.0, -0.0, -165.0>
    translate  -0.0*y
  }
  object { // ST_Strebe13->ST_Strebe1
    ST_Strebe1
    rotate <-0.0, -0.0, 180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // ST_Strebe14->ST_Strebe1
    ST_Strebe1
    rotate <0.0, -0.0, 165.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // ST_Strebe15->ST_Strebe1
    ST_Strebe1
    rotate <0.0, -0.0, 150.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // ST_Strebe16->ST_Strebe1
    ST_Strebe1
    rotate <0.0, -0.0, 135.0>
    translate  0.0*x
  }
  object { // ST_Strebe17->ST_Strebe1
    ST_Strebe1
    rotate <-0.0, -0.0, 120.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // ST_Strebe18->ST_Strebe1
    ST_Strebe1
    rotate <-0.0, -0.0, 105.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // ST_Strebe19->ST_Strebe1
    ST_Strebe1
    rotate <0.0, -0.0, 90.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // ST_Strebe20->ST_Strebe1
    ST_Strebe1
    rotate <0.0, -0.0, 75.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // ST_Strebe21->ST_Strebe1
    ST_Strebe1
    rotate <0.0, -0.0, 60.0>
    translate  -0.0*y
  }
  object { // ST_Strebe22->ST_Strebe1
    ST_Strebe1
    rotate <-0.0, -0.0, 45.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // ST_Strebe23->ST_Strebe1
    ST_Strebe1
    rotate <0.0, -0.0, 30.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // ST_Strebe24->ST_Strebe1
    ST_Strebe1
    rotate <-0.0, -0.0, 15.0>
    translate  <-0.0, 0.0, 0.0>
  }
}
#declare ST_Grundkoerper = union {
  cylinder { // ST_AussenRing
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 1.2>
    translate  0.9*z
  }
  object { ST_SchraegeF }
  object { // ST_SchraegeH->ST_SchraegeF
    ST_SchraegeF
    rotate -180.0*x
    translate  3.0*z
  }
}
#declare ST_Bohrung = union {
  object { ST_Bohrung2 }
  object { // ST_Bohrung3->ST_Bohrung2
    ST_Bohrung2
    rotate -90.0*z
  }
  translate  1.5*z
}
#declare ST_Koerper = difference {
  object { ST_Grundkoerper }
  object { ST_Bohrung }
  object { ST_OStrebnkranz }
  object { // ST_UStrebnkranz->ST_OStrebnkranz
    ST_OStrebnkranz
    rotate -180.0*x
    translate  3.0*z
  }
}
#declare ST_Auslass1 = object {
  torus { // ST_Auslass1
    0.35, 0.05  rotate -x*90
    scale <1.0, 1.0, 2.0>
    rotate -90.0*x
    translate  <0.0, -0.95, 1.5>
  }
}
#declare ST_Licht = object {
  cylinder { // ST_Licht
    <0,0,1>, <0,0,0>, 1 
    material {
      Steuertribwer2
    }
    scale <0.3, 0.3, 1.4>
    rotate <-90.0, 0.0, -90.0>
    translate  <-0.7, 0.0, 1.5>
  }
}
#declare ST_Finne = difference {
  box { // ST_FinneKoerper
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.4, 0.5>
    translate  1.5*z
  }
  plane { // ST_FinneCut
    z,0
    rotate 105.0*x
    translate  <0.0, 0.2, 1.5>
  }
  rotate <-90.0, 0.0, -45.0>
  translate  <0.0, -0.1, 1.5>
}
#declare St_Triebwer = union {
  object { ST_Koerper }
  object { ST_Auslass1 }
  object { // ST_Auslass2->ST_Auslass1
    ST_Auslass1
    rotate <-0.0, 0.0, -90.0>
    translate  <-0.0, 0.0, -0.0>
  }
  object { // ST_Auslass3->ST_Auslass1
    ST_Auslass1
    rotate <-0.0, 0.0, -180.0>
    translate  <0.0, 0.0, -0.0>
  }
  object { // ST_Auslass4->ST_Auslass1
    ST_Auslass1
    rotate <-0.0, 0.0, 90.0>
    translate  <0.0, 0.0, -0.0>
  }
  object { ST_Licht }
  object { // ST_Licht2->ST_Licht
    ST_Licht
    rotate <0.0, 0.0, -90.0>
  }
  object { ST_Finne }
  object { // ST_Finne1->ST_Finne
    ST_Finne
    rotate -90.0*z
    translate  -0.0*y
  }
  object { // ST_Finne2->ST_Finne
    ST_Finne
    rotate 180.0*z
    translate  -0.0*x
  }
  object { // ST_Finne3->ST_Finne
    ST_Finne
    rotate 90.0*z
    translate  0.0*y
  }
  material {
    HullSphere_Te1
  }
  translate  6.0*z
}
#declare HTW_CutL = object {
  plane { // HTW_CutL
    z,0
    rotate <-90.0, 0.0, -180.0>
    translate  0.95*y
  }
}
#declare H_TriebwerkK = object {
  cylinder { // H_TriebwerkK
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.5>
    rotate -90.0*y
    translate  1.4*x
  }
}
#declare HTW_Cut = object {
  object { // HTW_Cut->H_TriebwerkK
    H_TriebwerkK
    scale <1.2, 0.8, 0.8>
    translate  -0.2*x
  }
}
#declare HTW_SchleuseL = object {
  torus { // HTW_SchleuseL
    0.175, 0.025  rotate -x*90
    scale <1.0, 1.0, 4.0>
    rotate -90.0*x
    translate  -0.95*y
  }
}
#declare HRA_Teil1 = object {
  cylinder { // HRA_Teil1
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.5>
  }
}
#declare H_RadarAntT1 = union {
  object { HRA_Teil1 }
  object { // HRA_Teil2->HRA_Teil1
    HRA_Teil1
    scale <1.0, 1.0, 1.1>
    translate  <0.08, 0.0, -0.025>
  }
  object { // HRA_Teil3->HRA_Teil1
    HRA_Teil1
    scale <1.0, 1.0, 1.2>
    translate  <0.16, 0.0, -0.05>
  }
  object { // HRA_Teil4->HRA_Teil1
    HRA_Teil1
    scale <1.0, 1.0, 1.3>
    translate  <0.24, 0.0, -0.075>
  }
  object { // HRA_Teil5->HRA_Teil1
    HRA_Teil1
    scale <1.0, 1.0, 1.4>
    translate  <0.32, 0.0, -0.1>
  }
  object { // HRA_Teil6->HRA_Teil1
    HRA_Teil1
    scale <1.0, 1.0, 1.5>
    translate  <0.4, 0.0, -0.125>
  }
  object { // HRA_Teil7->HRA_Teil1
    HRA_Teil1
    scale <1.0, 1.0, 1.6>
    translate  <0.48, 0.0, -0.15>
  }
  object { // HRA_Teil8->HRA_Teil1
    HRA_Teil1
    scale <1.0, 1.0, 1.7>
    translate  <0.56, 0.0, -0.175>
  }
  object { // HRA_Teil9->HRA_Teil1
    HRA_Teil1
    scale <1.0, 1.0, 1.8>
    translate  <0.64, 0.0, -0.2>
  }
  object { // HRA_Teil10->HRA_Teil1
    HRA_Teil1
    scale <1.0, 1.0, 1.9>
    translate  <0.72, 0.0, -0.225>
  }
  object { // HRA_Teil11->HRA_Teil1
    HRA_Teil1
    scale <1.0, 1.0, 2.0>
    translate  <0.8, 0.0, -0.25>
  }
  material {
    BlueHull_Tex
  }
}
#declare Gang1 = object {
  torus { // Gang1
    1.5, 0.5  rotate -x*90
  }
}
#declare V_Aussparung1 = object {
  cylinder { // V_Aussparung1
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.8, 30.0>
    rotate -0.7*y
    translate  <2.0, 0.0, -0.5>
  }
}
#declare K_FSensoren = object {
  sphere { // K_FSensoren
    <0,0,0>,1
    scale 0.2
    translate  <1.8, 0.0, 13.3>
  }
}
#declare KPA_Teil1 = object {
  cylinder { // KPA_Teil1
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.5>
  }
}
#declare KP_AntT1 = union {
  object { KPA_Teil1 }
  object { // KPA_Teil2->KPA_Teil1
    KPA_Teil1
    scale <1.0, 1.0, 1.1>
    translate  <0.08, 0.0, -0.025>
  }
  object { // KPA_Teil3->KPA_Teil1
    KPA_Teil1
    scale <1.0, 1.0, 1.2>
    translate  <0.16, 0.0, -0.05>
  }
  object { // KPA_Teil4->KPA_Teil1
    KPA_Teil1
    scale <1.0, 1.0, 1.3>
    translate  <0.24, 0.0, -0.075>
  }
  object { // KPA_Teil5->KPA_Teil1
    KPA_Teil1
    scale <1.0, 1.0, 1.4>
    translate  <0.32, 0.0, -0.1>
  }
  object { // KPA_Teil6->KPA_Teil1
    KPA_Teil1
    scale <1.0, 1.0, 1.5>
    translate  <0.4, 0.0, -0.125>
  }
  object { // KPA_Teil7->KPA_Teil1
    KPA_Teil1
    scale <1.0, 1.0, 1.6>
    translate  <0.48, 0.0, -0.15>
  }
  object { // KPA_Teil8->KPA_Teil1
    KPA_Teil1
    scale <1.0, 1.0, 1.7>
    translate  <0.56, 0.0, -0.175>
  }
  object { // KPA_Teil9->KPA_Teil1
    KPA_Teil1
    scale <1.0, 1.0, 1.8>
    translate  <0.64, 0.0, -0.2>
  }
  object { // KPA_Teil10->KPA_Teil1
    KPA_Teil1
    scale <1.0, 1.0, 1.9>
    translate  <0.72, 0.0, -0.225>
  }
  object { // KPA_Teil11->KPA_Teil1
    KPA_Teil1
    scale <1.0, 1.0, 2.0>
    translate  <0.8, 0.0, -0.25>
  }
  material {
    BlueHull_Tex
  }
}
#declare KP_Antenn = union {
  object { KP_AntT1 }
  object { // KP_AntT2->KP_AntT1
    KP_AntT1
    rotate 180.0*z
    translate  1.6*x
  }
  scale <2.0, 0.7, 0.7>
  translate  <-1.6, 0.0, 1.5>
}
#declare K_Paddle = union {
  cone { // KP_Basis
    <0,0,0>, 0.2, <0,0,1>, 0.05
    scale <1.0, 1.0, 0.2>
    translate  0.9*z
  }
  cone { // KP_Schaft
    <0,0,0>, 0.05, <0,0,1>, 0.0
    scale <1.0, 1.0, 0.2>
    translate  1.1*z
  }
  sphere { // KP_Kugel
    <0,0,0>,1
    scale 0.05
    translate  1.3*z
  }
  object { KP_Antenn }
  scale <3.0, 5.0, 5.0>
  rotate <90.0, 0.0, -90.0>
  translate  <-0.8, 0.0, 7.7>
}
#declare K_ASeg10 = intersection {
  plane { // K_ASegPartL1
    z,0
    rotate 90.0*y
  }
  plane { // K_ASegPartR1
    z,0
    rotate -90.0*y
    translate  -0.05*x
  }
  translate  <0.025, 0.0, 13.2>
}
#declare K_ASeg = intersection {
  plane { // K_ASegPartL
    z,0
    rotate 90.0*y
  }
  plane { // K_ASegPartR
    z,0
    rotate -90.0*y
    translate  -0.1*x
  }
  translate  <0.05, 0.0, 13.2>
}
#declare Gang42 = object {
  torus { // Gang42
    1.5, 0.5  rotate -x*90
  }
}
#declare CSGFins = difference {
  sphere { // Fins
    <0,0,0>,1
    scale <0.3, 6.0, 6.0>
  }
  plane { // K_FinCut
    z,0
    scale <1.0, 0.909091, 1.0>
    translate  -0.2*x
  }
}
#declare K_FinObenRotAll = union {
  object { CSGFins }
  box { // K_FinHinten
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 6.0, 1.5>
    translate  -1.5*z
  }
  scale 0.5
  rotate <-180.0, 0.0, -180.0>
  translate  <0.0, 2.12, -2.92>
}
#declare K_FinObenRot = difference {
  object { K_FinObenRotAll }
  cylinder { // K_RotCut
    <0,0,1>, <0,0,0>, 1 
    scale <3.65, 2.1, 1.0>
    rotate -90.0*y
    translate  <0.5, 2.1, -1.4>
  }
  material {
    RedHull_Tex
  }
}
#declare K_FinObenRot1 = difference {
  cylinder { // K_RotCut2
    <0,0,1>, <0,0,0>, 1 
    scale <3.65, 2.1, 0.2>
    rotate -90.0*y
    translate  <0.1, 2.1, -1.4>
  }
  plane { // K_FinCut1
    z,0
    scale <0.5, 0.454545, 0.5>
    rotate <180.0, 0.0, 180.0>
    translate  <0.1, 2.1, -1.4>
  }
  material {
    HullSmallPlane_Tex
    rotate <0.0, 90.0, 0.0>
    translate <0.050000, 2.100000, -2.550000>
  }
}
#declare K_FinOben = union {
  object { K_FinObenRot }
  object { K_FinObenRot1 }
  scale <1.0, 2.0, 2.0>
  rotate -180.0*x
  translate  <0.0, 8.5, -0.3>
}




//
// ********  OBJECTS  *******
//

cylinder { // Ring1
  <0,0,1>, <0,0,0>, 1 open
  material {
    Flat_Black
  }
  hollow
  scale <192.082001, 192.082001, 1.0>
  rotate -90.0*y
}


#declare sky_vect = <0.00000, 0.00000, 1.00000>
#declare cam_loc = <-45.913, 160.803, -430.966>  // using camera 'Camera01'
#declare lookat = <-22.361, -1.649, -163.511>
#declare light_loc = <-48.53851, 117.22407, -378.29332>  // using light source 'Light001'

#declare flare_size = 1.000
#declare bright_background = 0
#declare flare_brightness = 1.000
#include "NKFlare\Sunset1.flr"
#include "NKFlare\nkflare.inc"




box { // shadowmaker16
  <-1, -1, -1>, <1, 1, 1>
  material {
    Flat_Black
  }
  scale <0.5, 14.71, 0.07687>
  rotate -67.699997*x
  translate  <-0.504181, -137.377617, -56.343821>
}


sphere { // SkySphere1
  <0,0,0>,1
  material {
    Starfield
  }
  hollow
  scale 5001.0
}


box { // shadowmaker
  <-1, -1, -1>, <1, 1, 1>
  material {
    Flat_Black
  }
  scale <0.5, 14.71, 0.076868>
  translate  <-0.504181, -0.098455, -149.374614>
}


box { // shadowmaker1
  <-1, -1, -1>, <1, 1, 1>
  material {
    Flat_Black
  }
  scale <0.5, 14.71, 0.076868>
  rotate -22.6*x
  translate  <-0.504181, -56.617156, -138.137968>
}


box { // shadowmaker2
  <-1, -1, -1>, <1, 1, 1>
  material {
    Flat_Black
  }
  scale <0.5, 14.71, 0.076868>
  rotate -45.099998*x
  translate  <-0.504181, -105.638568, -105.539347>
}


box { // shadowmaker3
  <-1, -1, -1>, <1, 1, 1>
  material {
    Flat_Black
  }
  scale <0.5, 14.71, 0.076868>
  rotate -90.0*x
  translate  <-0.504181, -149.341144, -0.152405>
}


box { // shadowmaker4
  <-1, -1, -1>, <1, 1, 1>
  material {
    Flat_Black
  }
  scale <0.5, 14.71, 0.076868>
  rotate -112.599998*x
  translate  <-0.504181, -137.50503, 58.117697>
}


box { // shadowmaker5
  <-1, -1, -1>, <1, 1, 1>
  material {
    Flat_Black
  }
  scale <0.5, 14.71, 0.076868>
  rotate -135.199997*x
  translate  <-0.504181, -104.728098, 106.145008>
}


box { // shadowmaker6
  <-1, -1, -1>, <1, 1, 1>
  material {
    Flat_Black
  }
  scale <0.5, 14.71, 0.076868>
  rotate -157.800003*x
  translate  <-0.504181, -55.790317, 138.466705>
}


box { // shadowmaker7
  <-1, -1, -1>, <1, 1, 1>
  material {
    Flat_Black
  }
  scale <0.5, 14.71, 0.076868>
  rotate -180.0*x
  translate  <-0.504181, -0.251626, 149.164731>
}


box { // shadowmaker8
  <-1, -1, -1>, <1, 1, 1>
  material {
    Flat_Black
  }
  scale <0.5, 14.71, 0.076868>
  rotate 157.399994*x
  translate  <-0.504181, 56.880388, 138.01147>
}


box { // shadowmaker9
  <-1, -1, -1>, <1, 1, 1>
  material {
    Flat_Black
  }
  scale <0.5, 14.71, 0.076868>
  rotate 157.399994*x
  translate  <-0.504181, 56.880388, 138.01147>
}


box { // shadowmaker10
  <-1, -1, -1>, <1, 1, 1>
  material {
    Flat_Black
  }
  scale <0.5, 14.71, 0.076868>
  rotate 134.800003*x
  translate  <-0.504181, 106.273404, 104.551685>
}


box { // shadowmaker11
  <-1, -1, -1>, <1, 1, 1>
  material {
    Flat_Black
  }
  scale <0.5, 14.71, 0.076868>
  rotate 112.199997*x
  translate  <-0.504181, 138.595101, 54.931051>
}


box { // shadowmaker12
  <-1, -1, -1>, <1, 1, 1>
  material {
    Flat_Black
  }
  scale <0.5, 14.71, 0.076868>
  rotate 90.0*x
  translate  <-0.504181, 149.06551, -0.835257>
}


box { // shadowmaker13
  <-1, -1, -1>, <1, 1, 1>
  material {
    Flat_Black
  }
  scale <0.5, 14.71, 0.076868>
  rotate 67.399994*x
  translate  <-0.504181, 137.912248, -57.056801>
}


box { // shadowmaker14
  <-1, -1, -1>, <1, 1, 1>
  material {
    Flat_Black
  }
  scale <0.5, 14.71, 0.076868>
  rotate 44.799988*x
  translate  <-0.504181, 105.590551, -105.766964>
}


box { // shadowmaker15
  <-1, -1, -1>, <1, 1, 1>
  material {
    Flat_Black
  }
  scale <0.5, 14.71, 0.076868>
  rotate 22.200012*x
  translate  <-0.504181, 55.514682, -138.543896>
}


#declare sky_vect = <0.00000, 0.00000, 1.00000>
#declare cam_loc = <-45.913, 160.803, -430.966>  // using camera 'Camera01'
#declare lookat = <-22.361, -1.649, -163.511>
#declare light_loc = <0.00000, 0.00000, 0.00000>  // using light source 'RingSun'

#declare flare_size = 1.000
#declare bright_background = 0
#declare flare_brightness = 1.000
#include "NKFlare\BigStar.flr"
#include "NKFlare\nkflare.inc"




cylinder { // Ring
  <0,0,1>, <0,0,0>, 1 open
  material {
    Terrain_lon
  }
  hollow
  scale <191.082001, 191.082001, 1.0>
  rotate -90.0*y
}


sphere { // SkySphere
  <0,0,0>,1
  material {
    Galaxy_Lon
  }
  hollow
  // All transformations fixed
  scale 5000.0
}


#declare HT_Grundkoerper = union {
  cylinder { // HT_AussenRing
    <0,0,1>, <0,0,0>, 1 
    scale <1.6, 1.6, 1.2>
    translate  0.9*z
  }
  cylinder { // HT_MittlRing
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 1.8>
    translate  0.6*z
  }
  cylinder { // HT_InnererRing
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 3.0>
  }
}
#declare HT_Bohrung = union {
  cylinder { // HT_Bohrung1
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 3.2>
    rotate -90.0*x
    translate  -1.6*y
  }
  cylinder { // HT_Bohrung2
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 3.2>
    rotate <-90.0, 0.0, -90.0>
    translate  -1.6*x
  }
  translate  1.5*z
}
#declare HT_Koerper = difference {
  object { HT_Grundkoerper }
  object { HT_Bohrung }
  object { HT_ObKranzKugel }
  object { // HT_ObKranzKug1->HT_ObKranzKugel
    HT_ObKranzKugel
    rotate -90.0*z
    translate  -1.8*z
  }
}
#declare Hptst_Triebwerk = union {
  object { HT_Koerper }
  object { HT_Auslass1 }
  object { // HT_Auslass2->HT_Auslass1
    HT_Auslass1
    rotate <-0.0, 0.0, -90.0>
    translate  <-0.0, 0.0, -0.0>
  }
  object { // HT_Auslass3->HT_Auslass1
    HT_Auslass1
    rotate <-0.0, 0.0, -180.0>
    translate  <0.0, 0.0, -0.0>
  }
  object { // HT_Auslass4->HT_Auslass1
    HT_Auslass1
    rotate <-0.0, 0.0, 90.0>
    translate  <0.0, 0.0, -0.0>
  }
  object { HT_OStrebnkranz }
  object { // HT_UStrebnkranz->HT_OStrebnkranz
    HT_OStrebnkranz
    translate  -1.8*z
  }
  object { HT_Licht }
  object { // HT_Licht2->HT_Licht
    HT_Licht
    rotate <0.0, 0.0, -90.0>
  }
  material {
    HullSphere_Te1
  }
}
#declare FrontRotor = union {
  object { Hptst_Triebwerk }
  object { Ausleger }
  object { // Ausleger1->Ausleger
    Ausleger
    rotate <-0.0, -0.0, -90.0>
    translate  <0.0, -0.0, -0.0>
  }
  object { // Ausleger2->Ausleger
    Ausleger
    rotate <-0.0, -0.0, 180.0>
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Ausleger3->Ausleger
    Ausleger
    rotate <-0.0, -0.0, 90.0>
    translate  <0.0, 0.0, -0.0>
  }
}
#declare H_Koerper = difference {
  sphere { // H_Kugel
    <0,0,0>,1
  }
  plane { // H_BodyCut
    z,0
    rotate 0.0*y
    translate  -0.9*z
  }
  torus { // HTW_RingCut
    1.225, 0.275  rotate -x*90
  }
  object { HTW_CutL }
  object { // HTW_CutR->HTW_CutL
    HTW_CutL
    rotate 180.0*z
  }
}
#declare H_TWRoehre = difference {
  object { H_TriebwerkK }
  object { HTW_Cut }
}
#declare H_Triebwerk = union {
  object { H_TWRoehre }
  object { // HTW_Engine->HTW_Cut
    HTW_Cut
    material {
      Steuertribwer2
      scale 0.2
      rotate -90.0*y
    }
    scale <0.7, 1.0, 1.0>
    translate  0.2*x
  }
  torus { // HTW_Auslassring
    0.225, 0.025  rotate -x*90
    rotate -90.0*y
    translate  1.4*x
  }
  translate  -0.1*x
}
#declare H_RadarAntenne = union {
  object { H_RadarAntT1 }
  object { // H_RadarAntT2->H_RadarAntT1
    H_RadarAntT1
    rotate 180.0*z
    translate  1.6*x
  }
  scale 0.4
  rotate <-30.0, 0.0, -30.0>
  translate  <-0.3, 0.1, 1.3>
}
#declare H_Radar = union {
  cone { // H_RadarBasis
    <0,0,0>, 0.3, <0,0,1>, 0.05
    scale <1.0, 1.0, 0.2>
    translate  0.9*z
  }
  cone { // H_RadarSchaft
    <0,0,0>, 0.05, <0,0,1>, 0.0
    scale <1.0, 1.0, 0.2>
    translate  1.1*z
  }
  sphere { // H_RadarKugel
    <0,0,0>,1
    scale 0.05
    translate  1.3*z
  }
  object { H_RadarAntenne }
}
#declare Heck = union {
  object { H_Koerper }
  torus { // H_Schleuse
    0.35, 0.05  rotate -x*90
    scale <1.0, 1.0, 2.0>
    translate  -0.95*z
  }
  object { H_Triebwerk }
  object { HTW_SchleuseL }
  object { // HTW_SchleuseR->HTW_SchleuseL
    HTW_SchleuseL
    translate  1.9*y
  }
  object { H_Radar }
  material {
    HullSphere_Te1
  }
  scale 1.3
  rotate <90.0, -90.0, 0.0>
  translate  18.35*z
}
#declare V_Rohr = union {
  object { Gang1 }
  object { // Gang2->Gang1
    Gang1
    scale <0.995, 0.995, 1.0>
    translate  0.7*z
  }
  object { // Gang3->Gang1
    Gang1
    scale <0.99, 0.99, 1.0>
    translate  1.4*z
  }
  object { // Gang4->Gang1
    Gang1
    scale <0.985, 0.985, 1.0>
    translate  2.1*z
  }
  object { // Gang5->Gang1
    Gang1
    scale <0.98, 0.98, 1.0>
    translate  2.8*z
  }
  object { // Gang6->Gang1
    Gang1
    scale <0.975, 0.975, 1.0>
    translate  3.5*z
  }
  object { // Gang7->Gang1
    Gang1
    scale <0.97, 0.97, 1.0>
    translate  4.2*z
  }
  object { // Gang8->Gang1
    Gang1
    scale <0.965, 0.965, 1.0>
    translate  4.9*z
  }
  object { // Gang9->Gang1
    Gang1
    scale <0.96, 0.96, 1.0>
    translate  5.6*z
  }
  object { // Gang10->Gang1
    Gang1
    scale <0.955, 0.955, 1.0>
    translate  6.3*z
  }
  object { // Gang11->Gang1
    Gang1
    scale <0.95, 0.95, 1.0>
    translate  7.0*z
  }
  object { // Gang12->Gang1
    Gang1
    scale <0.945, 0.945, 1.0>
    translate  7.7*z
  }
  object { // Gang13->Gang1
    Gang1
    scale <0.94, 0.94, 1.0>
    translate  8.4*z
  }
  object { // Gang14->Gang1
    Gang1
    scale <0.935, 0.935, 1.0>
    translate  9.1*z
  }
  object { // Gang15->Gang1
    Gang1
    scale <0.93, 0.93, 1.0>
    translate  9.8*z
  }
  object { // Gang16->Gang1
    Gang1
    scale <0.925, 0.925, 1.0>
    translate  10.5*z
  }
  object { // Gang17->Gang1
    Gang1
    scale <0.92, 0.92, 1.0>
    translate  11.2*z
  }
  object { // Gang18->Gang1
    Gang1
    scale <0.915, 0.915, 1.0>
    translate  11.9*z
  }
  object { // Gang19->Gang1
    Gang1
    scale <0.91, 0.91, 1.0>
    translate  12.6*z
  }
  object { // Gang20->Gang1
    Gang1
    scale <0.905, 0.905, 1.0>
    translate  13.3*z
  }
  object { // Gang21->Gang1
    Gang1
    scale <0.9, 0.9, 1.0>
    translate  14.0*z
  }
  object { // Gang22->Gang1
    Gang1
    scale <0.895, 0.895, 1.0>
    translate  14.7*z
  }
  object { // Gang23->Gang1
    Gang1
    scale <0.89, 0.89, 1.0>
    translate  15.4*z
  }
  object { // Gang24->Gang1
    Gang1
    scale <0.885, 0.885, 1.0>
    translate  16.1*z
  }
  object { // Gang25->Gang1
    Gang1
    scale <0.88, 0.88, 1.0>
    translate  16.8*z
  }
  object { // Gang26->Gang1
    Gang1
    scale <0.875, 0.875, 1.0>
    translate  17.5*z
  }
  object { // Gang27->Gang1
    Gang1
    scale <0.87, 0.87, 1.0>
    translate  18.2*z
  }
  object { // Gang28->Gang1
    Gang1
    scale <0.865, 0.865, 1.0>
    translate  18.9*z
  }
  object { // Gang29->Gang1
    Gang1
    scale <0.86, 0.86, 1.0>
    translate  19.6*z
  }
  object { // Gang30->Gang1
    Gang1
    scale <0.855, 0.855, 1.0>
    translate  20.3*z
  }
  object { // Gang31->Gang1
    Gang1
    scale <0.85, 0.85, 1.0>
    translate  21.0*z
  }
  object { // Gang32->Gang1
    Gang1
    scale <0.845, 0.845, 1.0>
    translate  21.7*z
  }
  object { // Gang33->Gang1
    Gang1
    scale <0.84, 0.84, 1.0>
    translate  22.4*z
  }
  object { // Gang34->Gang1
    Gang1
    scale <0.835, 0.835, 1.0>
    translate  23.1*z
  }
  object { // Gang35->Gang1
    Gang1
    scale <0.83, 0.83, 1.0>
    translate  23.8*z
  }
  object { // Gang36->Gang1
    Gang1
    scale <0.825, 0.825, 1.0>
    translate  24.5*z
  }
  object { // Gang37->Gang1
    Gang1
    scale <0.82, 0.82, 1.0>
    translate  25.2*z
  }
  object { // Gang38->Gang1
    Gang1
    scale <0.815, 0.815, 1.0>
    translate  25.9*z
  }
  object { // Gang39->Gang1
    Gang1
    scale <0.81, 0.81, 1.0>
    translate  26.6*z
  }
  object { // Gang40->Gang1
    Gang1
    scale <0.805, 0.805, 1.0>
    translate  27.3*z
  }
  object { // Gang41->Gang1
    Gang1
    scale <0.8, 0.8, 1.0>
    translate  28.0*z
  }
}
#declare VerbindungsRohr = difference {
  object { V_Rohr }
  object { V_Aussparung1 }
  object { // V_Aussparung2->V_Aussparung1
    V_Aussparung1
    rotate 1.4*y
    translate  -3.9*x
  }
  material {
    HullSphere_Te1
  }
  scale <0.4, 0.4, 0.5>
  translate  3.0*z
}
#declare K_Sensoren = union {
  object { K_FSensoren }
  object { // K_FSensoren1->K_FSensoren
    K_FSensoren
    rotate -36.0*z
  }
  object { // K_FSensoren2->K_FSensoren
    K_FSensoren
    rotate -72.0*z
    translate  -0.0*y
  }
  object { // K_FSensoren3->K_FSensoren
    K_FSensoren
    rotate -108.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // K_FSensoren4->K_FSensoren
    K_FSensoren
    rotate -144.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // K_FSensoren5->K_FSensoren
    K_FSensoren
    rotate 180.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // K_FSensoren6->K_FSensoren
    K_FSensoren
    rotate 144.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // K_FSensoren7->K_FSensoren
    K_FSensoren
    rotate 108.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // K_FSensoren8->K_FSensoren
    K_FSensoren
    rotate 72.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // K_FSensoren9->K_FSensoren
    K_FSensoren
    rotate 36.0*z
    translate  <0.0, -0.0, 0.0>
  }
  material {
    YellowChrome_Tex
  }
}
#declare K_Kugel = difference {
  sphere { // K_KugelTeil
    <0,0,0>,1
    scale 6.0
    translate  7.6*z
  }
  plane { // K_CutHinten
    z,0
    translate  <6.6, 0.0, 5.0>
  }
  cylinder { // K_CockpitRoehre
    <0,0,1>, <0,0,0>, 1 
    translate  12.7*z
  }
  sphere { // K_KugelTeil3
    <0,0,0>,1
    scale 5.5
    translate  7.6*z
  }
  object { K_Sensoren }
}
#declare K_KegelAussen1 = difference {
  cone { // K_AttachAusse1
    <0,0,0>, 0.0, <0,0,1>, 6.16
    open
    scale <1.0, 1.0, 10.0>
    translate  7.6*z
  }
  cone { // K_AttachAusI1
    <0,0,0>, 0.0, <0,0,1>, 3.0
    open
    scale <1.0, 1.0, 10.0>
    translate  7.6*z
  }
  scale <0.4, 0.4, 1.0>
}
#declare K_AttachAUnse1 = intersection {
  sphere { // K_KugelTeil2
    <0,0,0>,1
    material {
      BlueHull_Tex
    }
    scale 6.1
    translate  7.6*z
  }
  object { K_KegelAussen1 }
}
#declare K_ISegmented = difference {
  object { K_AttachAUnse1 }
  object { K_ASeg10 }
  object { // K_ASeg11->K_ASeg10
    K_ASeg10
    rotate -18.0*z
    translate  -0.0*z
  }
  object { // K_ASeg12->K_ASeg10
    K_ASeg10
    rotate -36.0*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // K_ASeg13->K_ASeg10
    K_ASeg10
    rotate -54.0*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // K_ASeg14->K_ASeg10
    K_ASeg10
    rotate -72.0*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // K_ASeg15->K_ASeg10
    K_ASeg10
    rotate -90.0*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // K_ASeg16->K_ASeg10
    K_ASeg10
    rotate -108.0*z
    translate  <0.0, 0.0, -0.0>
  }
  object { // K_ASeg17->K_ASeg10
    K_ASeg10
    rotate -126.0*z
    translate  <0.0, 0.0, -0.0>
  }
  object { // K_ASeg18->K_ASeg10
    K_ASeg10
    rotate -144.0*z
    translate  <0.0, 0.0, -0.0>
  }
  object { // K_ASeg19->K_ASeg10
    K_ASeg10
    rotate -162.0*z
    translate  <0.0, 0.0, -0.0>
  }
}
#declare K_KegelAussen = difference {
  cone { // K_AttachAussen
    <0,0,0>, 0.0, <0,0,1>, 7.6
    scale <1.0, 1.0, 10.0>
    translate  7.6*z
  }
  cone { // K_AttachAusI
    <0,0,0>, 0.0, <0,0,1>, 3.9
    open
    scale <1.0, 1.0, 10.0>
    translate  7.6*z
  }
}
#declare K_AttachAUnseg = intersection {
  sphere { // K_KugelTeil1
    <0,0,0>,1
    material {
      BlueHull_Tex
    }
    scale 6.1
    translate  7.6*z
  }
  object { K_KegelAussen }
}
#declare K_ASegmented = difference {
  object { K_AttachAUnseg }
  object { K_ASeg }
  object { // K_ASeg1->K_ASeg
    K_ASeg
    rotate -18.0*z
    translate  -0.0*z
  }
  object { // K_ASeg2->K_ASeg
    K_ASeg
    rotate -36.0*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // K_ASeg3->K_ASeg
    K_ASeg
    rotate -54.0*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // K_ASeg4->K_ASeg
    K_ASeg
    rotate -72.0*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // K_ASeg5->K_ASeg
    K_ASeg
    rotate -90.0*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // K_ASeg6->K_ASeg
    K_ASeg
    rotate -108.0*z
    translate  <0.0, 0.0, -0.0>
  }
  object { // K_ASeg7->K_ASeg
    K_ASeg
    rotate -126.0*z
    translate  <0.0, 0.0, -0.0>
  }
  object { // K_ASeg8->K_ASeg
    K_ASeg
    rotate -144.0*z
    translate  <0.0, 0.0, -0.0>
  }
  object { // K_ASeg9->K_ASeg
    K_ASeg
    rotate -162.0*z
    translate  <0.0, 0.0, -0.0>
  }
}
#declare V_Rohr1 = union {
  object { Gang42 }
  object { // Gang43->Gang42
    Gang42
    scale <1.17, 1.17, 1.0>
    translate  0.5*z
  }
  object { // Gang44->Gang42
    Gang42
    scale <1.34, 1.34, 1.0>
    translate  1.0*z
  }
  object { // Gang45->Gang42
    Gang42
    scale <1.51, 1.51, 1.0>
    translate  1.5*z
  }
  object { // Gang46->Gang42
    Gang42
    scale <1.68, 1.68, 1.0>
    translate  2.0*z
  }
  object { // Gang47->Gang42
    Gang42
    scale <1.85, 1.85, 1.0>
    translate  2.5*z
  }
  object { // Gang48->Gang42
    Gang42
    scale <2.02, 2.02, 1.0>
    translate  3.0*z
  }
  object { // Gang49->Gang42
    Gang42
    scale <2.19, 2.19, 1.0>
    translate  3.5*z
  }
  object { // Gang50->Gang42
    Gang42
    scale <2.36, 2.36, 1.0>
    translate  4.0*z
  }
  object { // Gang51->Gang42
    Gang42
    scale <2.53, 2.53, 1.0>
    translate  4.5*z
  }
  object { // Gang52->Gang42
    Gang42
    scale <2.7, 2.7, 1.0>
    translate  5.0*z
  }
}
#declare KommandoKugel = union {
  object { K_Kugel }
  object { K_Paddle }
  object { // K_Paddle1->K_Paddle
    K_Paddle
    rotate -180.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { K_ISegmented }
  object { K_ASegmented }
  object { V_Rohr1 }
  cylinder { // K_Cockpit
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver
    }
    scale <0.9, 0.9, 1.2>
    rotate <-180.0, -0.0, -180.0>
    translate  <0.0, 0.0, 13.332067>
  }
  object { K_FinOben }
  object { // K_FinOben1->K_FinOben
    K_FinOben
    rotate -0.0*x
    translate  <0.0, -8.5, 0.0>
  }
  material {
    HullSphere_Tex
  }
  scale 0.5
  rotate <-180.0, 0.0, -180.0>
}
union { // Comet
  object { FrontRotor }
  object { St_Triebwer }
  object { Heck }
  object { VerbindungsRohr }
  object { // St_Triebwer1->St_Triebwer
    St_Triebwer
    translate  6.0*z
  }
  object { KommandoKugel }
  scale 0.5
  rotate 10.0*y
  translate  <-47.783221, 117.383299, -373.756314>
}


