#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "metals.inc"

// an image of a metal man standing in front of a fractal image
//background {White}

#declare cl=clock     ;
#declare cl2=clock*clock;
#declare icl=1-clock     ;
#declare scl=sqrt(clock)  ;
#declare sicl=sqrt(abs(1-clock));
                                                     
#declare CuPosX=0      ;
#declare CuPosY=0       ;
#declare CuPosZ=0        ;
#declare CuPosDX=1        ;
#declare CuPosDY=1         ;
#declare CuPosDZ=1          ;


//#declare CuTex= texture {pigment{Pink}}
                                                  
#macro BODYMON(larmx,rarmx,COLORR)         
                
                    #switch (COLORR)
  #range (-0.2,0.2)
   #declare rept=texture{pigment {
        //pigment_map 
        leopard}}
  #range (0.2001,0.4)
   #declare rept=texture{pigment {Brown}}
  #range (0.4001,0.6)
   #declare rept=texture{pigment {Coral}}
  #range (0.6001,0.8)
   #declare rept=texture{pigment {Yellow}}
  #range (0.8001,1.1)              
    #declare rept=texture{
                         pigment {
                                 gradient y
                                 color_map {
                                            [0.0  color White]
                                            [0.4  color White]
                                            [0.41  color Black]
                                            [0.60  color Black]
                                            [0.61  color White]
                                            [1.0  color White]
                                            }                       
                                frequency 4
                                }
                        }

 #end // End of conditional part                        
                                                  
#declare CClock=2*clock                            ;
#declare leng=18;

#declare ydelt=.7     ;
//#declare larmx=90*cos(clock*3*pi); // 90*cos(clock*4*pi)    48   98
#declare larmz=20;   
#declare rarmz=-20                   ;
#declare lelbow=15;
#declare relbow=15 ;
#declare foreL=1.02    ;
#declare llegx=-10      ;
#declare llegy=-10       ;
#declare rlegx=10        ;
#declare rlegy=10        ;
//#declare lshinx=-10+(cos(CClock*4*pi)-1)*(2*pi-mod(CClock*2*pi,2*pi))*13
//#declare rshinx=-10+(cos(CClock*4*pi*pi)-1)*(2*pi-mod(CClock*2*pi+pi,2*pi))*13
#declare lshinx=-5+45*(-1+cos(CClock*4*pi))/pow((int(sin(2*CClock*pi+pi)+.999)+1),2);
#declare rshinx=-5+45*(-1+cos(CClock*4*pi))/pow((int(sin(2*CClock*pi)+.999)+1),2) ;
#declare thighL=2.65;
#declare shinL=2.3   ;
#declare bicepL=2.2   ;
#declare boost=1       ;
#declare joint=1        ;
#declare footA=90        ;
#declare chestY=4.5       ;
#declare headA=20           ;
#declare headACu=0;//*sin(2*clock);
#declare fingRA=-30         ;
#declare fingLA=30;

#declare body2=
blob {
threshold 0.4


     sphere {<0,0,0>,1.35*boost,1                   //shoulder ball
            scale <1,1,1>
            translate <2,chestY+.15,0>
            }
     sphere {<0,0,0>,1.35*boost,1                   //shoulder ball
            scale <1,1,1>
            translate <-2,chestY+.15,0>
            }
     cylinder {<-1.0,0,0>,<1.0,0,0>,2,1                 //shouldertop
              scale <1,.4,.3>
              translate <0,chestY+.15,0>
              }
     cylinder {<0,chestY-.3,0>,<0,chestY+2.7,-.23>,1,1   //neck
              }
     sphere {<0,-bicepL,0>,bicepL*1*boost,1                   //biceps
            scale <1,1.4,1>
            translate <0.2,.75,-.1>
            scale <0.55,1,0.65>
            rotate <larmx,0,larmz>
            translate <2,chestY,0>
            }
     cylinder {<0,0-ydelt*1.6,0>,<0,-bicepL-ydelt,0>,bicepL*boost,1                   //biceps
            scale <0.3,1,0.3>
            rotate <larmx,0,larmz>
            translate <2,chestY,0>
            }
     sphere {<0,-bicepL,0>,bicepL*1*boost,1
            scale <1,1.4,1>
            translate <-.2,.75,-.1>
            scale <0.55,1,0.65>
            rotate <rarmx,0,rarmz>
            translate <-2,chestY,0>
            }
     cylinder{<0,0-ydelt*1.6,0>,<0,-bicepL-ydelt,0>,bicepL*boost,1
            scale <0.3,1,0.3>
            rotate <rarmx,0,rarmz>
            translate <-2,chestY,0>
            }
     sphere {<0,0,0>,foreL*1.75*boost,1
              scale <.45,1,.5>
              translate <0,-foreL+.55,0>
              rotate <lelbow,0,-.20>
              translate <0,-2*bicepL,0-.2>
              rotate <larmx,0,larmz>
              translate <2,chestY,0>
              }

     cylinder{<0,0-ydelt,0>,<0,-foreL-ydelt,0>,foreL*1.5*boost,1
              scale <.35,1,.375>
              rotate <lelbow,0,0>
              translate <0,-2*bicepL,0-.2>                //
              rotate <larmx,0,larmz>
              translate <2,chestY,0>
              }
     sphere {<0,0,0>,foreL*1.75*boost,1
              scale <.35,1,.5>
              translate <0,-foreL+.55,0>
              rotate <relbow,0,0>
              translate <0,-2*bicepL,0-.2>
              rotate <rarmx,0,rarmz>
              translate <-2,chestY,0>
              }
      cylinder{<0,0-ydelt,0>,<0,-foreL-ydelt,0>,foreL*1.5*boost,1
              scale <.35,1,.375>
              rotate <relbow,0,0>
              translate <0,-2*bicepL,0-.2>
              rotate <rarmx,0,rarmz>
              translate <-2,chestY,0>
              }  

/*
     cylinder{<-.6,0,-.15>,<.6,0,-.15>,1,1                //hand
              scale <.5,1,1>
              translate <.2,-2*foreL-.3,-.2>
              //scale <.5,1,.375>
              rotate <lelbow,0,0>
              translate <0,-2*bicepL,0-.2>
              rotate <larmx,0,larmz>
              translate <2,chestY,0>
              }
 */
  cylinder{<-.6,0,-.15>,<.6,0,-.15>,1,1                //hand
              scale <.225,.9,1.1>
              translate <-.2,-2*foreL-.3,-.2>
              //scale <.5,1,.375>
              rotate <relbow,0,0>
              translate <0,-2*bicepL,0-.2>
              rotate <rarmx,0,rarmz>
              translate <-2,chestY,0>
              }

      cylinder{<-0,0,-1.15>,<0,-.5,-1.65>,.4,1              //thumb
              scale <.5,1.3,.5>
              rotate <0,0,45>
              translate <0,.13,0.05>
              translate <-.2,-2*foreL-.3,-.2>
              //scale <.5,1,.375>
              rotate <relbow,0,0>
              translate <0,-2*bicepL,0-.2>
              rotate <rarmx,0,rarmz>
              translate <-2,chestY,0>
              }
#declare fingD=.65 ;
#declare fingS=-1 ;

 cylinder{<-0,-.2,fingS>,<0,-.2-.85,fingS>,.4,1                 //finger
              scale <.45,0.8,.45>
               rotate <0,0,-fingRA>
              translate <-.2,-2*foreL-.8,-.2>
              //scale <.5,1,.375>
              rotate <relbow,0,0>
              translate <0,-2*bicepL,0-.2>
              rotate <rarmx,0,rarmz>
              translate <-2,chestY,0>
              }


cylinder{<-0,-.2,fingS+fingD*1>,<0,-.2-.85,fingS+fingD*1>,.4,1          //finger
              scale <.45,0.9,.45>
               rotate <0,0,-fingRA>
              translate <-.2,-2*foreL-.8,-.2>
              //scale <.5,1,.375>
              rotate <relbow,0,0>
              translate <0,-2*bicepL,0-.2>
              rotate <rarmx,0,rarmz>
              translate <-2,chestY,0>
              }
cylinder{<-0,-.2,fingS+fingD*2>,<0,-.2-.85,fingS+fingD*2>,.4,1           //finger
               scale <.45,0.8,.45>
                rotate <0,0,-fingRA>
              translate <-.2,-2*foreL-.8,-.2>
              //scale <.5,1,.375>
              rotate <relbow,0,0>
              translate <0,-2*bicepL,0-.2>
              rotate <rarmx,0,rarmz>
              translate <-2,chestY,0>
              }
 cylinder{<-0,-.2,fingS+fingD*3>,<0,-.2-.85,fingS+fingD*3>,.4,1         //finger
              scale <.45,0.7,.45>
               rotate <0,0,-fingRA>
              translate <-.2,-2*foreL-.8,-.2>
              //scale <.5,1,.375>
              rotate <relbow,0,0>
              translate <0,-2*bicepL,0-.2>
              rotate <rarmx,0,rarmz>
              translate <-2,chestY,0>
              }

cylinder{<.6,0,-.15>,<-.6,0,-.15>,1,1                //hand
              scale <.225,.9,1.1>
              translate <.2,-2*foreL-.3,-.2>
              //scale <.5,1,.375>
              rotate <lelbow,0,0>
              translate <0,-2*bicepL,0-.2>
              rotate <larmx,0,larmz>
              translate <2,chestY,0>
              }

    cylinder{<-0,0,-1.15>,<0,-.5,-1.65>,.4,1                //thumb
              scale <.5,1.3,.5>
              rotate <0,0,-45>
              translate <0,.13,.05>
              translate <.2,-2*foreL-.3,-.2>
              //scale <.5,1,.375>
              rotate <lelbow,0,0>
              translate <0,-2*bicepL,0-.2>
              rotate <larmx,0,larmz>
              translate <2,chestY,0>
              }
#declare fingD=.65;
#declare fingS=-1 ;

 cylinder{<-0,-.2,fingS>,<0,-.2-.85,fingS>,.4,1                 //finger
              scale <.45,0.8,.45>
               rotate <0,0,-fingLA>
              translate <.2,-2*foreL-.8,-.2>
              //scale <.5,1,.375>
              rotate <lelbow,0,0>
              translate <0,-2*bicepL,0-.2>
              rotate <larmx,0,larmz>
              translate <2,chestY,0>
              }


 cylinder{<-0,-.2,fingS+fingD*1>,<0,-.2-.85,fingS+fingD*1>,.4,1                //finger
              scale <.45,0.9,.45>
               rotate <0,0,-fingLA>
              translate <.2,-2*foreL-.8,-.2>
              //scale <.5,1,.375>
              rotate <lelbow,0,0>
              translate <0,-2*bicepL,0-.2>
              rotate <larmx,0,larmz>
              translate <2,chestY,0>
              }
 cylinder{<-0,-.2,fingS+fingD*2>,<0,-.2-.85,fingS+fingD*2>,.4,1                //finger
              scale <.45,0.8,.45>
               rotate <0,0,-fingLA>
              translate <.2,-2*foreL-.8,-.2>
              //scale <.5,1,.375>
              rotate <lelbow,0,0>
              translate <0,-2*bicepL,0-.2>
              rotate <larmx,0,larmz>
              translate <2,chestY,0>
              }
 cylinder{<-0,-.2,fingS+fingD*3>,<0,-.2-.85,fingS+fingD*3>,.4,1                //finger
              scale <.45,0.7,.45>
               rotate <0,0,-fingLA>
              translate <.2,-2*foreL-.8,-.2>
              //scale <.5,1,.375>
              rotate <lelbow,0,0>
              translate <0,-2*bicepL,0-.2>
              rotate <larmx,0,larmz>
              translate <2,chestY,0>
              }


cylinder {<0,15,0>,<0,0,0>,3.2*boost,1                        //torso
              scale <.9,.333,.4>
              translate <0,-1,0>
              }
cylinder {<0,5,0>,<0,0,0>,3.2*boost,1                        //torso
              scale <.9*.8,1*.46,.4*.78>
              translate <0,1,-.6>
              }


  sphere {<0,-thighL-ydelt*0,0>,thighL*1.2*boost,1                 //thigh
            scale <0.55,1.2,0.55>
            rotate <llegx,llegy,0>
            translate <0.7,-0.7,0>
            }
  cylinder{<0,0-ydelt,0>,<0,-thighL-ydelt,0>,thighL*boost,1          //thigh
            scale <0.55,1,0.55>
            rotate <llegx,llegy,0>
            translate <0.7,-0.7,0>
            }
  sphere {<0,-thighL-ydelt*0,0>,thighL*1.2*boost,1                 //thigh
            scale <0.55,1.2,0.55>
            rotate <rlegx,rlegy,0>
            translate <-0.7,-0.7,0>
            }
 cylinder{<0,0-ydelt,0>,<0,-thighL-ydelt,0>,thighL*boost,1          //thigh
            scale <0.55,1,0.55>
            rotate <rlegx,rlegy,0>
            translate <-0.7,-0.7,0>
            }
  sphere {<0,-shinL-ydelt,0>,shinL*boost*.65,1
            translate <-.0,shinL/2,.220>
            scale <.8,1,.8>
            rotate <lshinx,0,0>
            translate <0,-2*thighL,0>
            rotate <llegx,llegy,0>
            translate <0.7,-0.7,0>
            }
cylinder{<0,0-ydelt,0>,<0,-shinL-ydelt,0>,shinL*boost,1
          translate <0,0,.6>
            scale <.4,1,.4>
            rotate <lshinx,0,0>
            translate <0,-2*thighL,0>
            rotate <llegx,llegy,0>
            translate <0.7,-0.7,0>
            }
   sphere {<0,-shinL-ydelt,0>,shinL*boost*.65,1
            translate <0,shinL/2,.220>
            scale <.8,1,.8>
            rotate <rshinx,0,0>
            translate <0,-2*thighL,0>
            rotate <rlegx,rlegy,0>
            translate <-0.7,-0.7,0>
            }
  cylinder{<0,0-ydelt,0>,<0,-shinL-ydelt,0>,shinL*boost,1
            translate <0,0,.6>
            scale <.4,1,.4>
            rotate <rshinx,0,0>
            translate <0,-2*thighL,0>
            rotate <rlegx,rlegy,0>
            translate <-0.7,-0.7,0>
            }
    sphere {<0,-shinL-ydelt,0>,shinL*.5,1         //foot
            translate <0,-shinL*.5,.220>
            scale <.8,1,.8>
            rotate <lshinx,0,0>
            translate <0,-2*thighL,0>
            rotate <llegx,llegy,0>
            translate <0.7,-0.7,0>
            }
     cylinder {<0,0,0>,<0,-shinL,0>,shinL*.5,1         //foot
            scale <1,.8,.5>
            rotate <footA,0,0>
            translate <0,-shinL*1.6-ydelt,.220>
            rotate <lshinx,0,0>
            translate <0,-2*thighL,0>
            rotate <llegx,llegy,0>
            translate <0.7,-0.7,0>
            }
     sphere {<0,-shinL-ydelt,0>,shinL*.5,1         //foot
            translate <0,-shinL*.5,.220>
            scale <.8,1,.8>
            rotate <rshinx,0,0>
            translate <0,-2*thighL,0>
            rotate <rlegx,rlegy,0>
            translate <-0.7,-0.7,0>
            }
     cylinder {<0,0,0>,<0,-shinL,0>,shinL*.5,1         //foot
            scale <1,.8,.5>
            rotate <footA,0,0>
            translate <0,-shinL*1.6-ydelt,.220>
            rotate <rshinx,0,0>
            translate <0,-2*thighL,0>
            rotate <rlegx,rlegy,0>
            translate <-0.7,-0.7,0>
            }
     sphere {<0,0,0>,1.9*boost,1                   //but
            scale <1,1,1>
            translate <-.6,-1.1,.051>
            }
     sphere {<0,0,0>,1.9*boost,1                   //but
            scale <1,1,1>
            translate <.6,-1.1,.051>
            }
     sphere {<0,0,0>,1.9*boost,1                   //but
            scale <1,1,1>
            translate <-.6,-1.1,.151>
            }
     sphere {<0,0,0>,1.9*boost,1                   //but
            scale <1,1,1>
            translate <.6,-1.1,.151>
            }
     sphere {<0,0,0>,1.5*boost,-1.52                   //anti-but
            scale <.4,1,1>
            translate <-2,-1,0>
            }
     sphere {<0,0,0>,1.5*boost,-1.52                  //anti-but
            scale <.4,1,1>
            translate <2,-1,0>
            }
cylinder{<-1.,-.20,.0>,<-.15,-.20,0>,1.0,1                  //chest musc
         scale <1,1.6,1.2>
         translate <-.2,chestY-.7,-1.>
         }

cylinder{<.15,-.20,0>,<1.,-.20,.0>,1.0,1                  //chest musc
         scale <1,1.6,1.2>
         translate <0.2,chestY-.7,-1.>
         }

sphere { <0,0,0>,2,1   scale <2,3.5,2>
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               
            }

sphere {<0,0,0>,1.5,1   //scale <.2,.2,.1>          //cheeks
       translate <-1.2,-.30,-.9>
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               
            }
sphere {<0,0,0>,1.5,1   //scale <.2,.2,.1>          //cheeks
       translate <1.2,-.30,-.9>
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }

sphere {<0,0,0>,1.1,-1   //scale <.2,.2,.1>          //eyesockets
       translate <1,1.4,-1.1>
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }

sphere {<0,0,0>,1.1,-1   //scale <.2,.2,.1>          //eyesockets
       translate <-1,1.4,-1.1>
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }

sphere {<0,0,0>,6,1   scale <.6,.8,.8>          //back brain
      translate <0,1.9,2>
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }

#declare browX=0.1;
#declare browZ=0.3 ;

cylinder{<-1.42,1.4,-2.6>,<1.42,1.4,-2.6>,1,-1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }          //anti-brow
cylinder{<-1.4+browX*0,2.3,-1.00>,<1.4-browX*0,2.3,-1.00>,1.1,2
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }          //brow
cylinder{<-1.4+browX*1,2.7,-0.925>,<1.4-browX*1,2.7,-0.925>,1.1,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }          //brow
cylinder{<-1.4+browX*2,3.1,-0.850>,<1.4-browX*2,3.1,-0.850>,1.1,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }          //brow
cylinder{<-1.4+browX*3,3.4,-0.775>,<1.4-browX*3,3.4,-0.775>,1.1,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }          //brow
cylinder{<-1.4+browX*4,3.7,-0.700>,<1.4-browX*4,3.7,-0.700>,1.1,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }          //brow
cylinder{<-1.4+browX*5,4.0,-0.625>,<1.4-browX*5,4.0,-0.625>,1.1,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }          //brow




cylinder{<-1.4+browX*0,2.3,-1.00+browZ>,<1.4-browX*0,2.3,-1+browZ>,1.1,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }          //brow
cylinder{<-1.4+browX*1,2.7,-0.95+browZ>,<1.4-browX*1,2.7,-0.95+browZ>,1.1,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }          //brow
cylinder{<-1.4+browX*2,3.1,-0.90+browZ>,<1.4-browX*2,3.1,-0.90+browZ>,1.1,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }          //brow
cylinder{<-1.4+browX*3,3.4,-0.85+browZ>,<1.4-browX*3,3.4,-0.85+browZ>,1.1,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }          //brow
cylinder{<-1.4+browX*4,3.7,-0.80+browZ>,<1.4-browX*4,3.7,-0.80+browZ>,1.1,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }          //brow

#declare browX=browX*.9     ;
#declare browZ= 2*browZ      ;
cylinder{<-1.4+browX*0,2.3,-1.00+browZ>,<1.4-browX*0,2.3,-1+browZ>,1.1,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }          //brow
cylinder{<-1.4+browX*1,2.7,-0.95+browZ>,<1.4-browX*1,2.7,-0.95+browZ>,1.1,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }          //brow
cylinder{<-1.4+browX*2,3.1,-0.90+browZ>,<1.4-browX*2,3.1,-0.90+browZ>,1.1,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }          //brow
cylinder{<-1.4+browX*3,3.4,-0.85+browZ>,<1.4-browX*3,3.4,-0.85+browZ>,1.1,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }          //brow
cylinder{<-1.4+browX*4,3.7,-0.80+browZ>,<1.4-browX*4,3.7,-0.80+browZ>,1.1,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }          //brow
cylinder{<-1.4+browX*5,4.0,-0.75+browZ>,<1.4-browX*5,4.0,-0.75+browZ>,1.1,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }          //brow

#declare browX=browX*.9 ;
#declare browZ= 3*browZ/2 ;
cylinder{<-1.4+browX*0,2.3,-1.00+browZ>,<1.4-browX*0,2.3,-1+browZ>,1.1,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }          //brow
cylinder{<-1.4+browX*1,2.7,-0.95+browZ>,<1.4-browX*1,2.7,-0.95+browZ>,1.1,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }          //brow
cylinder{<-1.4+browX*2,3.1,-0.90+browZ>,<1.4-browX*2,3.1,-0.90+browZ>,1.1,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }          //brow
cylinder{<-1.4+browX*3,3.4,-0.85+browZ>,<1.4-browX*3,3.4,-0.85+browZ>,1.1,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }          //brow
cylinder{<-1.4+browX*4,3.7,-0.80+browZ>,<1.4-browX*4,3.7,-0.80+browZ>,1.1,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }          //brow
cylinder{<-1.4+browX*5,4.0,-0.75+browZ>,<1.4-browX*5,4.0,-0.75+browZ>,1.1,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }          //brow

cylinder{<-1.3+browX*5,3.6,-0.75+browZ>,<-1.2+browX*5,3.35,0.75+browZ>,2,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               }
cylinder{<1.3-browX*5,3.6,-0.75+browZ>,<1.2-browX*5,3.35,0.75+browZ>,2,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               
          //pigment {Red}
           }

cylinder {<0,2.1,-1.7>,<0,-.4,-2.9>,.5,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               
            //pigment {Red}
           }                      //nose
cylinder {<0,2.1,-1.7>,<0,-.4,-2.9>,.5,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               
            //pigment {Red}
            }                      //nose
cylinder {<0,2.1,-1.7>,<0,-.4,-2.6>,.5,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               
            //pigment {Red}
            }                      //nose
cylinder {<-.1,-.1,-2.6>,<-.5,-.5,-2.7>,.4,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
                
           //pigment {Red}
            }                      //nose
cylinder {<.1,-.1,-2.6>,<.5,-.5,-2.7>,.4,1
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
                               
          //pigment {Red}
             
            }                      //nose

#declare mou=
         0.15+0*clock ;

sphere {<0,0,0>,2,-3
       scale <.8,mou,1>                 //mouth??
       rotate <0,0,0>
       translate <0,-2.,-1>
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
               
       }
cylinder {<0,1,0>,<0,-1,0>,1.5,1
         scale <1,.8,.8>
         translate <0,-2.6,-1.4>
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
}
                      

      texture {rept}                      
       }

#declare eyepigs=
                pigment {
                        gradient z
                        pigment_map{
                         [0       Black]
                         [0.008    Black]
                         [0.0081  White]
                         [0.018   Wheat]
                         [0.03 red 0.1 green 0.3 blue .7]
                         [0.125  red 0.1 green 0.3 blue .7]
                         [0.12501     White]
                         [1       White]
                         }
                         }

#declare B=
union {
      object {body2
      //texture {rept}
      }
sphere {<0,0,.5>,.5        //eyesockets
       pigment {eyepigs}
       
       scale .6/.5
       translate <0,0,-.6>
       translate <1.2,1.4,-1.1>
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
            //pigment {White}
            }

sphere {<0,0,.5>,.5         //eyesockets
       pigment {eyepigs}
       scale .6/.5
       translate <0,0,-.6>
       translate <-1.2,1.4,-1.1>
            rotate <-10,headACu,0>
            scale <.40,.40,.405>
            translate <0,6.7,-1.25>
            translate <CuPosX,CuPosY,CuPosZ>
            scale <CuPosDX,CuPosDY,CuPosDZ>
            }       
      }         
           
                                     
union{
        object {       B
                scale 0.052
                translate <0,.55,0>
                }                
        difference{        
                superellipsoid{<0.7,0.7>
                                scale <0.06,0.05,0.08>
                                rotate<5,0,0>
                                 translate <0,.98,-.04>
                                }
                cylinder{<0,-10,0>,<0.0.01,0>,0.1 
                        scale <1.1,1,1.35>      
                        rotate<5,0,0>
                        translate <0,.96,-.04>
                        }                
               pigment {Yellow/2+Coral/3}              
                }                
        cylinder{<0,0,0>,<0.0.01,0>,0.1 
                scale <1.1,1,1.35>      
                rotate<5,0,0>
                translate <0,.96,-.04>
                //   texture {rept}
               pigment {Yellow/2+Coral/3}
                } 
      }         
                             
       
#end  
/*
camera {
//     location <3,3,-23>     look_at <2.7,9.2,3>    angle .32     //   STARTING original
     location <3,3,-23>     look_at <3,4,0>    angle 39     //   ENDINGoriginal SAVEME!
    // location <3,3,-23>     look_at <2.7+0.3*clock,9.2-5.2*clock,2.3-2.3*clock>    angle .32+43*scl     //   SAVEME!
                                     }

//orthographic
//up <0,0,12>*13.5
//right <16,0,0>*13.5
//location<3,40,0>
// look_at <3,4,0> 





light_source {<12, 3, -51.8056> color White}
light_source {<0, 251.8056, 0> color White}
light_source {<104, 444.8056, 0> color White*.6}

  
  
  */                                     