// Author: Frank Epple.           
// You can try around with the different cameras an the 4 ice_texturen.gif's.
// Have much fun!

// Un-comment this to render faster!
//#declare FAST_TEXTURE = 1;  // No reflections.
//#declare FAST_OBJECT  = 1;  // No height_field, no superellipsoids.
//#declare FAST_LIGHT   = 1;  // No lights inside the huts.

#include "colors.inc"           
#include "skies.inc"

// ----------------------------------------------------------------------------------------
// Material declarations
// ----------------------------------------------------------------------------------------

#declare T_SNOW = texture
{
  pigment
  {
    color rgb <0.98,0.98,0.98>
  }
  normal
  {
    bumps 0.2
    scale 0.02
  }
  finish
  {
    ambient 0.5
    diffuse 0.8
  }
}

#declare T_ICE = texture
{
  pigment
  {
    color rgb <0.78,0.78,0.98>
  }
  normal
  {
    bumps 0.05
    scale 3
  }
  finish
  {
    ambient 0.4
    diffuse 0.6
#ifndef (FAST_TEXTURE)
    reflection 0.12       
#end
  }
}

#declare T_ICE2 = texture
{
  pigment
  {
    color rgb <0.78,0.78,0.98>
  }
  normal
  {
    bumps 0.04
    scale 0.05
  }
  finish
  {
    ambient 0.4
    diffuse 0.6
#ifndef (FAST_TEXTURE)
    reflection 0.12       
#end
  }
}

// ----------------------------------------------------------------------------------------
// Parameters
// ----------------------------------------------------------------------------------------

// ----------------------------------------------------------------------------------------
// OBJECT DEFINITIONS
// Measure: 1.0 = 1 meter
// ----------------------------------------------------------------------------------------

#declare SANTATOWER = union
{
  lathe
  {
    cubic_spline
    8,
    <2.5, -1.0>,<2.4, 0.0>,<1.6, 7.0>,<2.7, 10.2>,<2.1, 12.3>,<1.8, 13.3>
    <2.1, 14.0>, <2.2, 14.1>
    texture { T_ICE }
  }
  lathe
  {
    cubic_spline
    6,
    <2.3, 13.7>,<2.2, 13.8>,<2.101, 14.01>,<0.5, 17.0>,<0.0, 21.0>, <0.0, 23.0>
    texture { T_SNOW }
  }
/*  cylinder
  {
    <0,0,0>
    <0,14,0>
    2
    
    texture { T_ICE }
  }                   
  cone
  {
    <0,14,0>, 2.3
    <0,17.7,0>, 0.1
    
    texture { T_SNOW }
  }
  cone
  {
    <0,17.7,0>, 0.1
    <0,20,0>, 0.0
    
    texture { T_SNOW }
  }
  difference
  {                                
    cylinder
    {
      <0,10,0>
      <0,11.4>
      3       
    }
    cylinder
    {
      <0,10.1,0>
      <0,11.5,0>
      2.7
    }    
    box
    {
      <-3.0, 10.3, 0.3>
      < 3.0, 11.5,-0.3>
    }                               
    box
    {
      <-3.0, 10.3, 0.3>
      < 3.0, 11.5,-0.3>
      rotate <0,45,0>
    }                               
    box
    {
      <-3.0, 10.3, 0.3>
      < 3.0, 11.5,-0.3>
      rotate <0,90,0>
    }                               
    box
    {
      <-3.0, 10.3, 0.3>
      < 3.0, 11.5,-0.3>
      rotate <0,135,0>
    }                               
    
    texture { T_ICE }
  }*/
}

#declare ENTRYTOWER = union
{ 
  lathe
  {
    cubic_spline
    6,
    <2.3, -1.0>,<2.1, 0.0>,<1.6, 4.0>,<1.7, 7.2>,<2.2, 8.0>,<2.3, 8.1>

    texture { T_ICE }
  }
  difference
  {
    cylinder
    {
      <0,8.0,0>
      <0,9.3,0>
      2.2                          
    }
    cylinder
    {
      <0,8.01,0>
      <0,9.31,0>
      1.6                          
    }
    box
    {
      <-3.0, 8.4, 0.4>
      < 3.0, 9.4,-0.4>
    }                               
    box
    {
      <-3.0, 8.4, 0.4>
      < 3.0, 9.4,-0.4>
      rotate <0,45,0>
    }                               
    box
    {
      <-3.0, 8.4, 0.4>
      < 3.0, 9.4,-0.4>
      rotate <0,90,0>
    }                               
    box
    {
      <-3.0, 8.4, 0.4>
      < 3.0, 9.4,-0.4>
      rotate <0,135,0>
    }
      
    texture { T_ICE }
  }
     
#declare c=1;
#while (c<16)
blob
  {              
//    treshold .65    
    sphere { <0.2, 0.4, 0.27>, 0.4,2.1 }  
    sphere { <0.2, 0.4, -0.27>, 0.4,1.9 }
    sphere { <-0.2, 0.4, 0.191>, 0.4,1.75 }  
    sphere { <-0.2, 0.4, -0.191>, 0.4,1.81 }
    sphere { <0.2, 0.4, 0.0>, 0.3,1.8 }

    sphere { <0.2, 0.0, 0.27>, 0.4,2.1 }  
    sphere { <0.2, 0.0, -0.27>, 0.4,1.9 }
    sphere { <-0.2, 0.0, 0.191>, 0.4,1.75 }  
    sphere { <-0.2, 0.0, -0.191>, 0.4,1.81 }
    sphere { <0.2, 0.0, 0.0>, 0.3,1.8 }

    sphere { <0.2, 0.2, 0.0>, 0.3,2.1 }
    sphere { <0.0, 0.4, 0.0>, 0.3,2.1 }
    
    scale <1.0, 0.67, 1.0>
    translate <1.9, 9.28, 0.0>
    rotate <0, c*360/16, 0>
    
    texture { T_SNOW }
  }               
#declare c=c+2;
#end
  
  scale 0.7                     
}        

#declare EDGETOWER = object
{ 
  ENTRYTOWER
  
  scale 1.2
}        

#declare WALL = union
// Describes 1 meter of the wall.
{
  difference
  {        
    cylinder
    {
      <0.0,2.0,0.0>
      <1.0,2.0,0.0> 
      7.0
    }                      
    cylinder
    {
      <-0.1,2.0,0.0>
      < 1.1,2.0,0.0> 
      6.0
    }                   
    plane
    {
      y,0
    }    
    plane
    {
      -y,-4
    }                 
    plane
    {
      -z,0
    }                
    
    texture { T_ICE2 }
  }  
  blob
  {              
//    treshold 0.65    
    sphere { <0.1,0,0>, 0.12, 1 }  
    sphere { <0.2,0,0>, 0.17, 1 }
    sphere { <0.3,0,0>, 0.15, 1 }
    sphere { <0.4,0,0>, 0.14, 1 }
    sphere { <0.5,0,0>, 0.13, 1 }
    sphere { <0.6,0,0>, 0.15, 1 }
    sphere { <0.7,0,0>, 0.12, 1 }
    sphere { <0.8,0,0>, 0.16, 1 }
    sphere { <0.9,0,0>, 0.12, 1 }
    
    scale <1,8,10>    
    translate <0.0, 4.0, -6.2>

    texture { T_SNOW }
  }
//  cylinder
//  {
//    <0.0,4.0,-5.83>
//    <1.0,4.0,-5.83>
//    0.5
//
//    texture { T_SNOW }
//  }
  
  translate <0.0, 0.0, 6.0>
}              

#declare HOUSE = union
{           
  difference  // Walls with windows and door.
  { 
#ifndef (FAST_OBJECT) 
    superellipsoid
    {
      <0.03,0.03>
      scale <2.5,1.9,1.5>
      translate <0.0,1.5,0.0> 
    }                
#else
    box
    {                 
      <-2.5,0.0,-1.5>
      < 2.5,3.4, 1.5>
    }
#end
    box
    {                 
      <-2.3,0.0,-1.3>
      < 2.3,3.5, 1.3>
    }
    plane
    {
      -y,0
      rotate <40,0,0>
      translate <0,3.2,0>
    }
    plane
    {
      -y,0
      rotate <-40,0,0>
      translate <0,3.2,0>
    }            
    cylinder  // Round window.
    {
      <-2.6,2.2,0.0>
      < 2.6,2.2,0.0>
      0.2
    }
    box // Three window side.
    {
      < 1.2,0.8,-1.6>
      < 1.9,1.6, 0.0>
    }
    box
    {
      <-1.2,0.8,-1.6>
      <-1.9,1.6, 0.0>
    }
    box
    {
      < 0.3,0.8,-1.6>
      <-0.3,1.6, 0.0>
    }
    box // Two window side.
    {
      < 0.6,0.8, 1.6>
      < 1.7,1.6, 0.0>
    }
    box
    {
      <-0.6,0.8, 1.6>
      <-1.7,1.6, 0.0>
    }
    box // One window side.
    {
      <2.7,0.8,-0.6>
      <0.0,1.6, 0.2>
    }
    box // Door side.
    {
      <-2.75,0.0,-0.2>
      <-2.037,1.6, 0.6>
    }
  
    texture { T_ICE }
  }
  difference  // Roof.
  {
    union
    {
      union
      { 
        box
        {
          <-2.7,0.0,-0.6>
          < 2.7,0.3, 1.5>
        }
        cylinder
        {
          <-2.7,0.15,1.5>
          < 2.7,0.15,1.5>
          0.15
        }
        translate <0,0,0.6>
        rotate <40,0,0>
        translate <0.0,3.0,0.0>
      }
      union
      {                    
        box
        {
          <-2.7,0.0,-1.5>
          < 2.7,0.3, 0.6>
        }
        cylinder
        {
          <-2.7,0.15,-1.5>
          < 2.7,0.15,-1.5>
          0.15
        }
        translate <0,0,-0.6>
        rotate <-40,0,0>
        translate <0.0,3.0,0.0>
      }                       
      cylinder
      {
        <-2.7,3.027,0.0>
        < 2.7,3.027,0.0>
        0.28
      }
    }
    cylinder
    {
      <-2.8,2.7,0.0>
      < 2.8,2.7,0.0>
      0.238
    }
    texture { T_SNOW }
  }
  
#ifndef (FAST_LIGHT)
  light_source
  {
    <0,2.0,0>
    color rgb <0.95, 0.93, 0.10>
    fade_distance 3
    fade_power 1.7
  }
#end                           
}

#declare HOUSE2 = union
{
  object
  {
    HOUSE
  }
  object
  {
    HOUSE
    
    rotate <0,90,0>
    translate <-2.5,0,0>
  }
}

#declare SNOWFATHERSTAIRS = difference
{
  union
  {
    cylinder
    {
      <0,0,100>
      <0,0.3,100>
      70
      
      texture { T_ICE }  
    }
    cylinder
    {
      <0,0.3,100>
      <0,0.6,100>
      69.5
      
      texture { T_ICE }  
    }
    cylinder
    {
      <0,0.6,100>
      <0,0.9,100>
      69
      
      texture { T_ICE }  
    }        
  }
  box
  {
    <-150.0, -0.1,  0.0>
    <150.0, 20.0, -150.0>

    rotate <0,90+37,0>
    translate <-27,0,25>
    
    texture { T_ICE }
  }
  box
  {
    <-150.0, -0.1,  0.0>
    <150.0, 20.0, -150.0>

    rotate <0,-90-37,0>
    translate <27,0,25>
    
    texture { T_ICE }
  }
}

#declare LITTLE_TOP_TOWER = union
{         
  difference
  {
    union
    {
      sphere
      {
        <0.0, 0.0, 0.0>
        2.4
        scale <1,2,1>
        translate <0,2,0>
      }
      cylinder
      {
        <0.0, 2.0, 0.0>
        <0.0, 7.0, 0.0>
        2.4
      }  
    }
    cylinder
    {
      <0.0, 2.0, 0.0>
      <0.0, 7.0, 0.0>
      2.1
    }    
    cylinder
    {
      <0.0, 5.0, 3.0>
      <0.0, 5.0,-3.0>
      0.3
    }
    cylinder
    {
      <0.0, 4.0, 3.0>
      <0.0, 4.0,-3.0>
      0.3
      
      rotate <0,50,0>
    }
    cylinder
    {
      <0.0, 4.0, 3.0>
      <0.0, 4.0,-3.0>
      0.3             
      
      rotate <0,-60,0>
    }
  }                     
  difference
  {
    cylinder
    {
      <0.0, 0.0, 0.0>
      <0.0, 4.0, 0.0>
      2.7
    }                     
    torus
    {    
      7, 7
      
      translate <0.0, 5.7, 0.0>
    }                  
                       
    scale <1,2,1>
    translate <0.0, 7.0, 0.0>
    
    texture { T_SNOW }
  }               
  torus
  {                 
    2.35, 0.52
    translate <0.0, 7.0, 0.0>
    texture { T_SNOW }
  }
  
#ifndef (FAST_LIGHT)
  light_source
  {
    <0,4.0,0>
    color rgb <0.95, 0.93, 0.10>
    fade_distance 2
    fade_power 1.7
  }
#end                           

  texture { T_ICE }
}

#declare SANTATOWER = union
{ 
  difference
  {
    cylinder
    {
      <0.0, 0.0, 0.0>
      <0.0, 27.0, 0.0>
      5.0     
    }
    cylinder
    {
      <0.0, 0.0, 0.0>
      <0.0, 26.5, 0.0>
      4.50     
    }
    #declare c=7;
    #while (c<=26)
      union // Windows in the tower.
      {
        box
        {
          < 0.3, c    ,-5.5>
          <-0.3, c+0.4, 5.5>
        }
        cylinder
        {
          < 0.0, c+0.4,-5.5>
          < 0.0, c+0.4, 5.5>
          0.3
        }
        
        rotate <0,c*20+90,0>
      }
      #declare c=c+1;
    #end                                     

    union // Door at the bottom of the tower.
    {
      box
      {
        < 0.5, 6    , 3.5>
        <-0.5, 6+1.4, 5.5>
      }
      cylinder
      {
        < 0.0, 6+1.4, 3.5>
        < 0.0, 6+1.4, 5.5>
        0.5
      }
        
      rotate <0,6*20+90,0>
    }
      
    texture { T_ICE }
  }
  difference
  { // Rounding under the 3 top-towers.
    cylinder
    {
      <0.0, 27.0, 0.0>
      <0.0, 31.5, 0.0>
      7
    }
    torus
    {
      8, 3
      
      translate <0.0, 27.0, 0.0>
    }
    torus
    {
      8, 3
      
      translate <0.0, 31.5, 0.0>
    }
    texture { T_ICE }
  }
  #declare c = 10;
  #while (c<360)
    object
    {
      LITTLE_TOP_TOWER

      translate <0.0, 28.0, -4.5>
      rotate <0,c,0>      
    }
    #declare c = c + 120;
  #end

#ifndef (FAST_LIGHT)
  light_source
  {
    <0,12.0,0>
    color rgb <0.95, 0.93, 0.10>
    fade_distance 7
    fade_power 4
  }
  light_source
  {
    <0,17.0,0>
    color rgb <0.95, 0.93, 0.10>
    fade_distance 7
    fade_power 4
  }
  light_source
  {
    <0,22.0,0>
    color rgb <0.95, 0.93, 0.10>
    fade_distance 7
    fade_power 4
  }
#end                           
}
  
#declare SNOWFATHERCASTLE = union
{                           
  difference
  {
    union
    {
      intersection
      { // Basefeature of the palace.
        box
        {
          <-17.0, 0.0, 35.0>
          < 17.0, 7.0, 57.0>
          
        }
        cylinder  
        {
          <0.0, 0.0, 100.0>
          <0.0, 7.0, 100.0>
          64
        }
      } 
      cylinder
      { // Tower to the right of the entry.
        <8.0, 0.0, 37.0>
        <8.0, 7.0, 37.0>
        2
      }
      cylinder
      { // Tower to the left of the entry.
        <-8.0, 0.0, 37.0>
        <-8.0, 7.0, 37.0>
        2
      }
    }
    intersection
    { // Cutting out the balcony.
      box
      {
        <-16.5, 6.0, 35.5>
        < 16.5, 7.1, 56.5>
        
      }
      cylinder  
      {
        <0.0, 5.9, 100.0>
        <0.0, 7.1, 100.0>
        63.5
      }
    } 
    cylinder
    { // Balcony to the right of the entry.
      <8.0, 6.0, 37.0>
      <8.0, 7.1, 37.0>
      1.5
    }
    cylinder
    { // Balcony to the left of the entry.
      <-8.0, 6.0, 37.0>
      <-8.0, 7.1, 37.0>
      1.5
    }
    
    #declare c = -34;
    #while (c <= 56)
      box // Zinnen
      { // The front door.
        < -18, 6.4, c+0.2>
        < 18, 7.1, c-0.2>
      }                  
      #declare c = c + 1;
    #end
    
    #declare c = -16;
    #while (c <= 16)
      box // Zinnen
      { // The front door.
        < c-0.2, 6.4, 30.0>
        < c+0.2, 7.1, 60.0>
      }                  
      #declare c = c + 1;
    #end
    
    box
    { // The front door.
      <-2.0, 0.9, 30.0>
      < 2.0, 3.0, 40.0>
    }                  
    cylinder
    { // The rounding in the front door.
      < 0.0, 3.0, 30.0>
      < 0.0, 3.0, 40.0>
      2.0
    }   
    box
    { // Room behind the front door.
      < -7.0, 0.9, 36.7>
      <  7.0, 5.0, 50.0>
    }
    
    texture { T_ICE }
  }                    

#ifndef (FAST_LIGHT)
  light_source
  {
    <1,3.0,42>
    color rgb <0.95, 0.93, 0.10>
    fade_distance 10
    fade_power 1.7
  }
  light_source
  {
    <-1,3.0,42>
    color rgb <0.95, 0.93, 0.10>
    fade_distance 10
    fade_power 1.7
  }
#end                           

  object
  {
    EDGETOWER
                    
    scale 1.3
    translate <17, 0.0, 38>
  }
  object
  {
    EDGETOWER
             
    scale 1.3
    translate <-17, 0.0, 38>
  }

  object
  {
    SANTATOWER
    
    translate <0.0, 0.0, 53.0>
  }
  
/*  difference
  {
      difference
      {
        cylinder  
        {
          <0,0.9,100>
          <0,7.0,100>
          64
          
          texture { T_ICE }  
        }
        cylinder  
        {
          <0,6.0,100>
          <0,7.1,100>
          66.7
          
          texture { T_ICE }  
        }
      }                                              
    }
  }*/
}
                    
#declare CASTLE = union
{
  object                                  
  { // Front left
    EDGETOWER
    
    translate <-17,0,0>
  }
                      
  object
  { // Front right
    EDGETOWER
    
    translate <17,0,0>
  }
  
  object
  { // Right
    EDGETOWER
    
    translate <27,0,25>
  }
  
  object
  { // Left
    EDGETOWER
    
    translate <-27,0,25>
  }
  
  object
  {
    ENTRYTOWER
    
    translate <-5,0,0>
  }
  
  object
  {
    ENTRYTOWER
    
    translate <5,0,0>
  }
         
  object
  {
    WALL  
    scale <12,1,1>
    translate <-17,0,0>
  }
  object
  {
    WALL  
    scale <12,1,1>
    translate <5,0,0>
  }
  object
  {
    WALL  
    scale <26.926,1,1>
    rotate <0,68.2,0>
    translate <-27,0,25>
  }
  object
  {
    WALL  
    scale <26.926,1,1>
    rotate <0,-68.2,0>
    translate <17,0,0>
  }
  object
  {
    WALL  
    scale <21,1,1>
    rotate <0,-90-40,0>
    translate <27,0,25>
  }
  object
  {
    WALL        
    translate <-1,0,0>
    scale <21,1,1>
    rotate <0,90+40,0>
    translate <-27,0,25>
  }
  
  object
  {
    SNOWFATHERSTAIRS
  }                
  object
  {
    SNOWFATHERCASTLE
  }             
  
  object
  { // 1
    HOUSE             
    rotate <0,-30,0>
    translate <0,0,25>
  }
  object
  { // 2
    HOUSE2             
    rotate <0,-182,0>
    translate <-3,0,18>
  }
  object
  { // 3
    HOUSE             
    rotate <0,-59,0>
    translate <-5,0,10>
  }
  object
  { // 4
    HOUSE             
    rotate <0,10,0>
    translate <-12,0,25>
  }
  object
  { // 5
    HOUSE             
    rotate <0,-110,0>
    translate <-16,0,17>
  }
  object
  { // 6
    HOUSE             
    rotate <0,30,0>
    translate <-14,0,8>
  }                              
  object
  { // 7
    HOUSE2
    rotate <0,30,0>
    translate <12,0,7>
  }
  object
  { // 8
    HOUSE             
    rotate <0,110,0>
    translate <16,0,14>
  }                              
  object
  { // 9
    HOUSE             
    rotate <0,-15,0>
    translate <15,0,21>
  }                              
  object
  { // 10
    HOUSE             
    rotate <0,-10,0>
    translate <13,0,27>
  }                              
}

// ----------------------------------------------------------------------------------------
// Setting all Objects into the Scene:
// ----------------------------------------------------------------------------------------
  
camera { location <-40.00, 105.00, -80.00> look_at <9.00,91.00,15.0> angle 47}  // Competition Camera1!
//camera { location <-40.00, 105.00, -80.00> look_at <3.00,80.00,10.0> angle 7}  // House Camera!
//camera { location <-27.00, 80+(8.0*0.7*1.2)+1.7, 25.00-21.00> look_at <0.00,80.00,0.00>}  // Tower Camera!
//camera { location <0.00, 310.00, -20.00> look_at <0.00,80.00,0.00> }  // Topview!
//camera { location <0.00, 81.67, -50.00> look_at <0.00,83.00,-21.00> }  // Front View!
//camera { location <-40.00, 105.00, -80.00> look_at <-17.00,87.00,-21.00> angle 6}  // Tower-cam!
//camera { location <-80, 110, 80> look_at <0,80,10> angle 40}
//camera { location <0.00, 105.00, -20.00> look_at <0.00,80.00,30.0> angle 65}  // Competition Camera1!
//camera { location <0.00, 125.00, -80.00> look_at <0.00,117.00,15.0> angle 12}  // Top-tower-cam!

light_source
{
//  <-3000.0,5000.0,-1000.0>  // 1
//  <-3000.0,1300.0,-1000.0>  // 2
  < 3000.0,1300.0,-1000.0>  // 3
//  <-3000.0,1300.0, 3000.0>
  rgb 1
}   

background
{
  color rgb <0.0,0.0,0.0>
}                  

sky_sphere
{
  pigment {P_Cloud1}
}

#ifndef (FAST_OBJECT)
height_field
{
  gif "ice.gif"
  smooth

  texture
  {
    material_map
    {
        gif "Ice_texture4.gif"
        interpolate 2
        once
        texture { T_SNOW } 
        texture { T_ICE } 
    }
    rotate <90,0,0>
  }

  translate <-0.5, 0,-0.5 >
  scale <250,255/240*30,250>
  translate <10.0, 50.0, -1.0>
}                    

/*plane
{
  y,0
  
  texture { T_SNOW }
}*/
#else
cone
{
  <0,0,0>,90
  <0,80,0>,40
  
  texture { T_ICE }
}
#end

object
{
  CASTLE
  
  translate <0,80,-21>
}
                    