#include "colors.inc"
#include "shapes2.inc"
#include "metals.inc"
#include "stones.inc"


camera {
  location <0.5, -3.7, -1.5>
  look_at <0,-3.5,0>
  blur_samples 20
}

light_source{<-200,10,-400> color rgb<.5,.5,.5>}
light_source{<500,200,2400> color rgb<1,1,1>}




plane {y,-3.8
  pigment {rgb<.256,.253,.488>}
  normal {
    agate
    agate_turb .5

  }
  finish {
    ambient .2
    diffuse .5
    reflection .5
    ior 1.33
    specular .5
    phong 1
    phong_size 150
    refraction 1
  }
}

plane {y, -3.9
  pigment {
    bozo
    turbulence .9
    color_map {
      [0 Yellow]
      [1 Green]
    }
  }
}

background{color rgb<0.7,0.8,0.9>}

#declare SkyRadius = 80

sphere
{
   <0,0,0>, SkyRadius
   pigment
   {
      bozo
      turbulence 0.6
         octaves 6
         omega 0.7
         lambda 2.2
      color_map
      {
         [0.0 0.2 color rgb <0.00, 0.00, 0.00>
                  color rgb <0.25, 0.25, 0.25>]
         [0.2 0.4 color rgb <0.25, 0.25, 0.25>
                  color rgb <0.75, 0.75, 0.75>]
         [0.4 0.6 color rgb <0.75, 0.75, 0.75>
                  color rgbt <1, 1, 1, 1>]
         [0.6 1.0 color rgbt <1, 1, 1, 1>
                  color rgbt <1, 1, 1, 1>]
      }
      scale <0.2*SkyRadius, 2*SkyRadius, 0.2*SkyRadius>
   }
   hollow
   scale <30, 1, 40>
   rotate y*20
   clipped_by { box { <-3000,10,-40000> <3000,1000,40000> } }
}


#declare planet =
union {

sphere
{  <0, 0, 0>, 60368
   pigment {image_map {gif "saturn.gif" map_type 1 interpolate 2}}
   finish {ambient 0 diffuse 1 specular 0}
}


disc
{
  <0, 0, 0>
  y,
  92000,
  74500
  pigment {color red 0.99 green 0.88 blue 0.79 filter 0.6}
  finish {ambient 0 diffuse 5}
}


disc
{
  <0, 0, 0>
  y,
  98390,
  92000
  pigment {color red 0.99 green 0.88 blue 0.79 filter 0.2}
  finish {ambient 0 diffuse 5}
}


disc
{
  <0, 0, 0>
  y,
  117500,
  98390
  pigment {color red 0.99 green 0.88 blue 0.79 filter 0.05}
  finish {ambient 0 diffuse 5}
}


disc
{
  <0, 0, 0>
  y,
  133570,
  122200
  pigment {color red 0.99 green 0.88 blue 0.79 filter 0.05}
  finish {ambient 0 diffuse 5}
}

disc
{
  <0, 0, 0>
  y,
  136800,
  133895
  pigment {color red 0.99 green 0.88 blue 0.79 filter 0.2}
  finish {ambient 0 diffuse 5}
}

disc
{
  <0, 0, 0>
  y,
  140460,
  140210
  pigment {color red 0.99 green 0.88 blue 0.79 filter 0.05}
  finish {ambient 0 diffuse 5}
}
}

object {
  planet
  scale .01
  rotate x*-35
  rotate z*-25
  translate<-1500,1000,2500>
}





#declare flare =
sphere {0,.8
  pigment { color rgbt <1,1,1,1>}
  halo {
    emitting
    spherical_mapping
    linear
    color_map {
      [0 color rgbt <0,0,1,1>]
      [1 color rgbt <1,1,1,-.5>]
    }
    samples 10
  }
  hollow
}

#declare flare2 =
sphere {0,.8
  pigment { color rgbt <1,1,1,1>}
  halo {
    emitting
    spherical_mapping
    turbulence 1.5
    linear
    color_map {
      [0 color rgbt <0,1,0,1>]
      [.5 color rgbt <1,1,0,-1>]
      [1 color rgbt <1,0,0,1>]
    }
    frequency 3
    samples 20
    scale 0.5
  }
  hollow
  scale 1.5
}


#declare ship =
union {
  union {
    sphere {<0,0,0>,.5 scale<4,1.5,1> pigment{rgb<0,.1,0>}}
    clipped_by{plane{x,1.5}}
    clipped_by{plane{-x,1.5}}
  }
  cone{<1.5,0,0>,.33 <2,0,0>,.25 scale<1,1.5,1>}
  cone{<2,0,0>,.25 <4,0,0>,0 scale<1,1.5,1> pigment {rgb<0,.1,0>}}

  cone{<-1.5,0,0>,.33 <-7,0,0>,.1 scale<1,1.5,1>}

  cylinder{<1,0,-.5><-1,0,-.5>,.2}
  cylinder{<1,0,.5><-1,0,.5>,.2}

  union {
    box{<1,-.05,-2.5><-1,.05,-.5>}
    cylinder{<1,0,-2.4><-1,0,-2.4>,.2}
    cylinder{<-1,0,-2.4><-3,0,-2.4>,.1 pigment{rgb<0,.1,0>}}
    sphere{<-3.1,0,-2.4>,.2 pigment{rgb<0,.1,0>}}
    cylinder{<-3.1,0,-2.4><-5,0,-2.4>,.1 pigment{rgb<0,.1,0>}}
    cone{<-5,0,-2.4>,.1 <-5.2,0,-2.4>,.15 pigment{rgb<0,.1,0>}}
    object{flare scale<8,.3,.3> translate<-10.2,0,-2.4>}
    rotate x*-15
  }

  union {
    box{<1,-.05,2.5><-1,.05,.5>}
    cylinder{<1,0,2.4><-1,0,2.4>,.2}
    cylinder{<-1,0,2.4><-3,0,2.4>,.1 pigment{rgb<0,.1,0>}}
    sphere{<-3.1,0,2.4>,.2 pigment{rgb<0,.1,0>}}
    cylinder{<-3.1,0,2.4><-5,0,2.4>,.1 pigment{rgb<0,.1,0>}}
    cone{<-5,0,2.4>,.1 <-5.2,0,2.4>,.15 pigment{rgb<0,.1,0>}}
    object{flare scale<8,.3,.3> translate<-10.2,0,2.4>}
    rotate x*15
  }
}

object {
  ship
  texture {T_Chrome_5E}
  rotate x*-85
  rotate y*45
  rotate z*-35
  scale .5
  translate<0,20,49>
}

object {
  ship
  texture {T_Chrome_5E}
  rotate x*-85
  rotate y*45
  rotate z*-35
  scale .5
  translate<5,30,60>
}

object {
  ship
  texture {T_Chrome_5E}
  rotate x*-35
  rotate y*-75
  scale .2
  translate<-2,-2,1>
}

object {
  ship
  texture {T_Chrome_5E}
  rotate x*-45
  rotate y*-75
  scale .2
  translate<-2,-3,3>
}



#declare tower =
union {
  cylinder{<0,0,0><0,6,0>,.5
    texture{T_Chrome_5E}}
  sphere{<0,6,0>,1}
  torus{1.5,.3
    texture{T_Copper_3E}
    translate <0,6,0>
  }
  torus{1.3,.08
    texture{T_Copper_3E}
    translate <0,6.5,0>
  }
  torus{1.3,.08
    texture{T_Copper_3E}
    translate <0,5.5,0>
  }
}

object {
  tower
  texture{T_Chrome_5E}
  scale .5
  translate<-3,-4,6>
}

object {
  tower
  texture{T_Chrome_5E}
  scale .5
  translate<3,-4,19>
}

object {
  tower
  texture{T_Chrome_5E}
  scale .7
  translate<-22,-4,19>
}

#declare cabin = union
{
  merge {
    difference {
      sphere {<0,0,0>,.5 scale .4 translate <0,.5,0> texture {T_Chrome_3A}
        normal { bump_map {gif "r4.gif" bump_size 5.0 map_type 1 interpolate 0}}}
      cylinder {<0,-.02,-.2><0,.02,-.2>,.4 scale .4 translate <0,.5,0>}
    }
    difference {
      sphere {<0,0,0>,.5 texture {T_Chrome_3A}
        normal { bump_map {gif "r4.gif" bump_size 10.0 map_type 1 interpolate 2}}}
      cylinder {<0,-.04,-.2><0,.04,-.2>,.4}
    }
  }
  sphere {<0,0,0>,.45 pigment {Yellow filter .3}}
  sphere {<0,0,0>,.45 pigment {Red filter .3} scale .4 translate <0,.5,0>}
}

#declare ypos = .1
#declare neck = union
{
  union {
    torus{.15,0 translate <0,0,0>}
    #while ( ypos < 1.6 )
      torus{.15,.1 translate<0,ypos,0>}
      #declare ypos = ypos + .1
    #end
    rotate x*90
    texture {T_Chrome_3A}
  }
  cylinder {<0,.35,0><0,.35,1.5>,.05 texture {T_Brass_5A}}
  cylinder {<0,-.35,0><0,-.35,1.5>,.05 texture {T_Brass_5A}}
  cylinder {<.25,0,0><.25,0,1.5>,.05 texture {T_Brass_5A}}
  cylinder {<-.25,0,0><-.25,0,1.5>,.05 texture {T_Brass_5A}}
}

#declare body = union
{
  difference {
    cylinder {<0,0,1.5><0,0,6>,.45 texture {T_Chrome_4A} //bulk
      normal { bump_map {gif "r4.gif" bump_size 5.0 map_type 2 interpolate 2}}}
    cylinder {<-.8,0,1.4><-.8,0,6.1>,.5 texture {T_Copper_3E}}
    cylinder {<.8,0,1.4><.8,0,6.1>,.5 texture {T_Copper_3E}}
  }

  union {
    cylinder {<0,.4,1.7><0,.6,1.7>,.03 texture {T_Brass_5A}} //support
    cylinder {<0,.4,5.8><0,.6,5.8>,.03 texture {T_Brass_5A}} //support
    cylinder {<0,.7,1.5><0,.7,6>,.1}
    cone {<0,.7,1.5>,.1 <0,.7,1.0>,0}
    texture {T_Chrome_3A}
  }

  union {
    cylinder {<-.2,0,1.7><-.6,0,1.7>,.03 texture {T_Brass_5A}} //support
    cylinder {<-.2,0,5.8><-.6,0,5.8>,.03 texture {T_Brass_5A}} //support
    cylinder {<-.7,0,1.5><-.7,0,6>,.1}
    cone {<-.7,0,1.5>,.1 <-.7,0,1.0>,0}
    texture {T_Chrome_3A}
  }

  union {
    cylinder {<.2,0,1.7><.6,0,1.7>,.03 texture {T_Brass_5A}} //support
    cylinder {<.2,0,5.8><.6,0,5.8>,.03 texture {T_Brass_5A}} //support
    cylinder {<.7,0,1.5><.7,0,6>,.1}
    cone {<.7,0,1.5>,.1 <.7,0,1.0>,0}
    texture {T_Chrome_3A}
  }

}

#declare ship2 = union
{
  object {cabin}
  object {neck}
  object {body}
  object{flare scale<4,.7,.7> rotate y*90 translate<0,0,8>}
}

object {
  ship2
  scale .5
  rotate y*80
  translate<1,0,15>
}

object {
  ship2
  scale .5
  rotate y*80
  translate<3,2,20>
}


#declare rot = 0
#declare ypos = 4.8
#declare grot = 0

#declare major =
union {
  cone{<0,6.3,0>,.8 <0,5.5,0>,1}
  cylinder{<0,5.5,0><0,5.0,0>,1}
  cylinder{<0,5,0><0,4.8,0>,.7}

  #while ( ypos > 3.4 )
    torus{1,.1 translate<0,ypos,0>}
    #declare ypos = ypos - .1
  #end

  cone{<0,3.5,0>,1 <0,3.3,0>,.95}
  cylinder{<0,3.3,0><0,2.3,0>,.95}
  difference {
    cylinder{<0,2.3,0><0,0.7,0>,1.1}
    #while (rot < 360)
      cylinder{<0,2.3,0><0,0.7,0>,.1 translate<1.1,0,0> rotate y*rot}
      #declare rot = rot + 10
    #end
  }
  cone{<0,0.7,0>,1 <0,0.5,0>,.9}
  cone{<0,0.5,0>,1 <0,0,0>,1.3}
  torus{1.2,.1 translate<0,0,0>}
  torus{1.1,.1 translate<0,-.1,0>}
  torus{1.0,.1 translate<0,-.2,0>}
  #while (grot < 360)
    difference {
      cylinder{<.9,5.3,0><1.5,5.5,0>,.15 rotate y*grot texture {T_Chrome_3C}}
      cylinder{<.89,5.29,0><1.51,5.51,0>,.1 rotate y*grot texture {T_Chrome_1A}}
    }
    #declare grot = grot + 30
  #end
  object {flare2 scale<2,5,1.5> translate<-.7,-4,0>}
}

object {
  major
  texture{T_Chrome_1A}
  normal { bump_map {gif "ridges.gif" bump_size 10.2 map_type 2} scale 5}
  scale .27
  translate<0,-3.4,2>
}

#declare rot = 0
#declare silo =
union {
  difference {
    box{<-1,-1,-1><1,1,1>}
    cylinder{<0,1.1,0><0,-1.1,0>,.5}
  }
  torus{.55,.01 translate<0,1.05,0> texture{T_Chrome_5A}}
  torus{.55,.01 translate<0,1.1,0> texture {T_Chrome_5A}}
  #while (rot < 360)
    cylinder{<0,0,0><0,.1,0>,.01 translate<.55,1,0> rotate y*rot texture{T_Chrome_5A}}
    #declare rot = rot + 10
  #end
}

object {
  silo
  scale 1
  translate<0,-4.75,2>
  texture {T_Chrome_1A}
}


height_field {
  png "height1.png"
  smooth
  texture {T_Stone8}
  translate <-.5,-.5,75>
  scale <200,12,1>
}

#declare LX = 1
#declare LY = -25
#declare LZ = 2
#declare LightningSeed = 0726
#declare LSegments =100
#declare LightningWidth = .02
#declare LightningScale = <.1,.1,.1>
#include "lightning.inc"

#declare LX = 14
#declare LY = -17
#declare LZ = 20
#declare LightningSeed = 1111
#declare LSegments = 70
#include "lightning.inc"

#declare LX = -35
#declare LY = -20
#declare LZ = 20
#declare LightningSeed = 0726
#declare LSegments = 100
#include "lightning.inc"
