/*This is the core file for my IRTC Feb 99 submission.
  Most objects were put into separate include files for
  modular design, allowing for quicker renders by 
  leaving out glass, etc. I am not including these in 
  the zip, however you can email me at danroot@juno.com
  if they are needed for IRTC purposes.*/
  

#include "bottle2.inc"                   
#include "room.inc"     

#include "hull.inc"
#include "sails.inc" 
#include "poles.inc"
#include "ropes.inc"

// Ship in a Bottle
// File: shipworld.pov
// Vers: 3.1
// Desc: For IRTC Feb '99
// Date: mm/dd/yy
// Auth: Daniel Root
//

#version 3.1
background {color rgb<.8,.8,1>} 

global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location  <33.0, 25.5, -18.0>
  look_at   <0.0, 15.0,  -30.0> 

}            
light_source {<33,120,0> rgb<.5,.5,.55>}

 
union{
//object{bottle pigment{rgb<.8,.9,.8>}}  
// object{bottle pigment{rgbf<.8,.9,.8,.9>} interior{ior 1.5}}  
object{bottle 
 pigment{rgbf<.8,.9,.8,.99> } 
 interior{ior 1.5}
 finish{reflection .1 phong .05}
}                             
 object{cork pigment{rgb<.9,.8,.5>}}
 object{liquid pigment{rgbf<.85,.85,.9,.85>}interior{ior 1.7 caustics .5}}
 union{object{hull}
       object{sails1}
       object{sails2}
       object{sails3}
       object{poles}
       object{ropes}   
       translate<0,1.5,0>
 } 
 translate<-10,0,-7.9>
 rotate<0,-34,0>
 scale<1.5,1.5,1.5>
} 
object{scene}



       
          
 


